<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$eventId = (isset($event_data['event_id']) && ($event_data['event_id'] != '')) ? $event_data['event_id'] : '';
$eventView = isset($event_data['view']) ? $event_data['view'] : 0;
$isPulled = 0;
if ($eventId != '') {
	$isPulled = 1;
}
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Event.event_detail'); ?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id' => 'form_event',
				);
				echo form_open_multipart('', $form_id);
				$isEventBooked = (isset($event_is_booked) && ($event_is_booked != 0)) ? $event_is_booked : '';
				?>
				<input type="hidden" id="event_id" name="event_id" value="<?= $eventId ?>">
				<input type="hidden" id="category_for" name="category_for" value="event">
				<input type="hidden" id="is_pulled" name="is_pulled" value="<?= $isPulled ?>">
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Event.event_name'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="event_name" id="event_name" placeholder="Enter <?= lang('Event.event_name'); ?>" value="<?= (isset($event_data['event_name']) && ($event_data['event_name'] != '')) ? $event_data['event_name'] : '';  ?>" />
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Event.category'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<select data-placeholder="Select <?= lang('Event.category'); ?>" name="category_id[]"
							id="category_id" class="select2 form-select form-select-lg categoryDd" multiple>
							<?php
							if (isset($event_category_data) && !empty($event_category_data)) {
								foreach ($event_category_data as  $categoryElement) { ?>
									<option value="<?= isset($categoryElement['category_id']) ? $categoryElement['category_id'] : ""; ?>" selected> <?= $categoryElement['category_name']; ?> </option>
							<?php  }
							} ?>
						</select>
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Event.start_date'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="start_date" id="start_date" placeholder="Enter <?= lang('Event.start_date'); ?>" value="<?= (isset($event_data['start_date']) && isValidDate($event_data['start_date'])) ? siteDateFormat($event_data['start_date'], true) : ''; ?>" />
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Event.end_date'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="end_date" id="end_date" placeholder="Enter <?= lang('Event.end_date'); ?>" value="<?= (isset($event_data['end_date']) && isValidDate($event_data['end_date'])) ? siteDateFormat($event_data['end_date'], true) : ''; ?>" />
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Event.description'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<textarea class="form-control description " name="description" id="description" rows="5" cols="5" placeholder="Enter <?= lang('Event.description'); ?>" rows="10" cols="10" class="form-control description"><?= (isset($event_data['description']) && ($event_data['description'] != '')) ? $event_data['description'] : ''; ?></textarea>
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Event.event_venue'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<select id="common_area_id" name="common_area_id" class="select2 form-select form-select-lg commonAreaDd dt-common_area" data-allow-clear="true">
							<option></option>
							<?php if (isset($event_data['common_area_id']) && $event_data['common_area_id'] != 0) { ?>
								<option value="<?= isset($event_data['common_area_id']) ? $event_data['common_area_id'] : 0 ?>" selected> <?= isset($event_data['common_area_name']) ? $event_data['common_area_name'] : ''  ?> </option>
							<?php } ?>
						</select>
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Event.terms_and_conditions'); ?></label>
					<div class="col-sm-10">
						<textarea class="form-control terms_and_conditions" name="terms_and_conditions" id="terms_and_conditions" rows="5" cols="5" placeholder="Enter <?= lang('Event.terms_and_conditions'); ?>" rows="10" cols="10" class="form-control terms_and_conditions"><?= (isset($event_data['terms_and_conditions']) && ($event_data['terms_and_conditions'] != '')) ? $event_data['terms_and_conditions'] : ''; ?></textarea>
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label"><?= lang('Event.event_thumbnail_image') ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="file" accept="image/*" class="form-control" name="event_thumbnail_image">
						<span class="form-text text-muted"><?= FILE_UPLOAD_TYPE_MSG; ?></span> <br>
						<?php
						$thumbailImage = site_url('uploads/no_image.png');
						if (isset($event_data['event_thumbnail_image']) && $event_data['event_thumbnail_image'] != '') { ?>
							<?php
							if (file_exists(THUMBNAIL_EVENT_IMAGE_PATH . $event_data['event_thumbnail_image'])) {
								$thumbailImage = site_url() . THUMBNAIL_EVENT_IMAGE_PATH . $event_data['event_thumbnail_image'];
							} ?>
						<?php } ?>
						<a href="<?= $thumbailImage; ?>" target="_blank"><img src="<?= $thumbailImage; ?>" width="100" class="img-fluid" alt=""></a>
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Event.event_image'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="file" accept="image/*" class="form-control" name="event_image[]" multiple="multiple">
						<span class="form-text text-muted"><?= FILE_UPLOAD_TYPE_MSG; ?></span> <br>
						<?php
						if (isset($image_data) && is_array($image_data) && !empty($image_data)) {
							foreach ($image_data as $image) {
								if (file_exists(EVENT_IMAGE_PATH . $image['event_image'])) {
									$paths = site_url() . EVENT_IMAGE_PATH . $image['event_image']; ?> &nbsp;&nbsp;&nbsp;
									<span class="document-image-<?= $image['event_image_id']; ?>">
										<a href="<?= $paths; ?>" target="_blank">
											<img src="<?= $paths; ?>" width="100" class="img-fluid" alt="">
											<?php if ($eventView != 1) { ?>
												<?php if (!empty($eventId) && $dtCIAcl->checkAccess('Event|deleteImage')) { ?>
													<a href="javascript:void(0);" id="<?php echo $image['event_image_id']; ?>" class="btn btn-icon btn-outline-dribbble delete-image"> <i class="tf-icons ti ti-trash"></i> </a>
												<?php } ?>
											<?php } ?>
										</a>
									</span>
						<?php }
							}
						} ?>
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang("Event.is_booking_required"); ?></label>
					<div class="col-sm-10">
						<input type="checkbox" class="form-check-input" id="is_booking_required"
							name="is_booking_required" <?= isset($event_data['is_booking_required']) && $event_data['is_booking_required'] == 1 ? "checked" : '' ?>
							value="1">
					</div>
				</div>
				<div id="is_booikg_required_container" style="display: none;">
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Event.is_guest_allowed'); ?></label>
						<div class="col-sm-10">
							<div class="form-check form-check-inline mt-3">
								<input class="form-check-input" type="radio" name="is_guest_allowed" id="is_guest_allowed" value="1" <?php if (isset($event_data['is_guest_allowed']) && $event_data['is_guest_allowed'] == 1) {
																																			echo "checked";
																																		} ?> />
								<label class="form-check-label" for="inlineRadio1">Yes</label>
							</div>
							<div class="form-check form-check-inline">
								<input
									class="form-check-input" type="radio" name="is_guest_allowed" id="is_guest_allowed" value="0" <?php if (isset($event_data['is_guest_allowed']) && $event_data['is_guest_allowed'] == 0) {
																																		echo "checked";
																																	} ?> />
								<label class="form-check-label" for="inlineRadio2">No</label>
							</div>
							<label id="bio-error" class="validation-invalid-label" for="is_guest_allowed"></label>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang("Event.is_cash_payment_allowed"); ?></label>
						<div class="col-sm-10">
							<input type="checkbox" class="form-check-input" id="is_cash_payment_allowed"
								name="is_cash_payment_allowed" <?= isset($event_data['is_cash_payment_allowed']) && $event_data['is_cash_payment_allowed'] == 1 ? "checked" : '' ?>
								value="1">
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang("Event.is_cancellation_allowed"); ?></label>
						<div class="col-sm-10">
							<input type="checkbox" class="form-check-input" id="is_cancellation_allowed"
								name="is_cancellation_allowed" <?= isset($event_data['is_cancellation_allowed']) && $event_data['is_cancellation_allowed'] == 1 ? "checked" : '' ?>
								value="1">
						</div>
					</div>
					<div class="row mb-3" id="before_minutes_container" style="display: none;">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang("Event.before_minutes"); ?></label>
						<div class="col-sm-10">
							<input type="text" class="form-control dt-before_minutes nonDecimal" name="before_minutes" id="before_minutes"
								placeholder="Enter <?= lang('Event.before_minutes'); ?>"
								value="<?= (isset($event_data['before_minutes']) && ($event_data['before_minutes'] != '')) ? $event_data['before_minutes'] : ''; ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Event.rate_type'); ?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<?php
							$eventTypes = eventType();
							?>
							<select data-placeholder="Select  <?= lang('Event.rate_type'); ?>" name="rate_type" id="rate_type" class="form-control select dt-rate-type">
								<option value=""> </option>
								<?php
								$selectedEventTypes = isset($event_data['rate_type']) ? $event_data['rate_type'] : "";
								foreach ($eventTypes as $eventKey => $event) { ?>
									<option <?= ($selectedEventTypes == $eventKey) ? "selected" : ""; ?>
										value="<?= $eventKey; ?>"> <?= $event; ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Event.booking_type'); ?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<?php
							$eventTypes = eventType();
							?>
							<select data-placeholder="Select  <?= lang('Event.booking_type'); ?>" name="booking_type" id="booking_type" class="form-control select dt-booking-type">
								<option value=""> </option>
								<?php
								$selectedEventTypes = isset($event_data['booking_type']) ? $event_data['booking_type'] : "";
								foreach ($eventTypes as $eventKey => $event) { ?>
									<option <?= ($selectedEventTypes == $eventKey) ? "selected" : ""; ?>
										value="<?= $eventKey; ?>"> <?= $event; ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Event.max_guest_allowed'); ?></label>
						<div class="col-sm-10">
							<input type="text" class="form-control nonDecimal" name="max_guest_allowed" id="max_guest_allowed" placeholder="Enter <?= lang('Event.max_guest_allowed'); ?>" value="<?= isset($event_data['max_guest_allowed'])  ? $event_data['max_guest_allowed'] : ''; ?>" />
						</div>
					</div>

					<hr class="my-4 mx-n4" />
					<h6> <?= lang('Event.event_rate'); ?></h6>
					<div class="row g-3" id="event-rate-table">
						<?php if(!empty($eventId)){?>
							<?php } ?>
							<?= isset($event_rate_table) ? $event_rate_table : ""; ?>
					</div>
					<?php if ($eventView != 1) { ?>
						<div class="pt-4">
							<button type="button" class="btn btn-primary generateEventRate">Generate Event Rate Table</button>
						</div>
						<hr class="my-4 mx-n4" />
					<?php } ?>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 colm-label" for="basic-default-name"><?= lang('CommonMessage.common_active'); ?></label>
					<div class="col-sm-10">
						<label class="switch switch-sm"><span class="switch-label"></span>
							<input type="checkbox" class="switch-input form-add-switchery" name="is_active" id="is_active" <?php echo (!isset($event_data['is_active']) || $event_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
							<span class="switch-toggle-slider">
								<span class="switch-on"></span>
								<span class="switch-off"></span>
							</span>

						</label>
					</div>
				</div>

				<?php if ($eventView != 1) { ?>
					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Event'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
				<?php } ?>

				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
	var editable = <?= $eventView ?>;
	if (editable == 1) {
		$("#form_event :input").prop("disabled", true);
	}
	$(document).ready(function() {
		numberInit();
		nonDecimal();
		commonAreaDd();
		categoryDd();
		$("#start_date").flatpickr({
			enableTime: true,
			dateFormat: "d-m-Y H:i",
		});
		$("#end_date").flatpickr({
			enableTime: true,
			dateFormat: "d-m-Y H:i",
		});
		ckEditorInit('description');
		ckEditorInit('terms_and_conditions');
		// $('.dt-before_minutes').timepicker({ 'timeFormat': 'i','scrollDefault': 'now', 'step': '5','ampm': true  });
		$('.dt-rate-type').select2();
		$('.dt-booking-type').select2();
		switcheryKeyGen("datatable-list-switchery");

		toggleBeforeMinutes();
		$('#is_cancellation_allowed').on('change', function() {
			toggleBeforeMinutes();
		});

		function toggleBeforeMinutes() {
			if ($('#is_cancellation_allowed').is(':checked')) {
				$('#before_minutes_container').show();
			} else {
				$('#before_minutes_container').hide();
			}
		}

		toggleBookingRequired();
		$('#is_booking_required').on('change', function() {
			toggleBookingRequired();
		});

		function toggleBookingRequired() {
			if ($('#is_booking_required').is(':checked')) {
				$('#is_booikg_required_container').show();
			} else {
				$('#is_booikg_required_container').hide();
			}
		}
		addSerialNumber('event_rate_table');
		// Initialize
		var validator = $("#form_event").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo(element.parents('.form-check').parent());
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo(element.parent());
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo(element.parent().parent());
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				event_name: {
					required: true,
				},
				start_date: {
					required: true,
				},
				end_date: {
					required: true,
				},
				description: {
					required: true,
				},
				common_area_id: {
					required: true,
				},
				rate_type: {
					required: "#rate_type:visible",
				},
				booking_type: {
					required: "#rate_type:visible",
				},
				"category_id[]": {
					required: true,
				},
				<?php
				if ($eventId == '') { ?> "event_image[]": {
						required: true,
					},
				<?php } ?>
				<?php
				if ($eventId == '') { ?>
					event_thumbnail_image: {
						required: true,
					},
				<?php } ?>

			},
			messages: {
				event_name: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Event.event_name"); ?>',
				},
				start_date: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Event.start_date"); ?>',
				},
				end_date: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Event.end_date"); ?>',
				},
				description: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Event.description"); ?>',
				},
				common_area_id: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Event.event_venue"); ?>',
				},
				rate_type: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Event.rate_type"); ?>',
				},
				booking_type: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Event.booking_type"); ?>',
				},
				"category_id[]": {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Event.category"); ?>',
				},
				<?php
				if ($eventId == '') { ?> "event_image[]": {
						required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Event.event_image"); ?>',
					},
				<?php } ?>
				<?php
				if ($eventId == '') { ?>
					event_thumbnail_image: {
						required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Event.event_thumbnail_image"); ?>',
					},
				<?php } ?>
			},
			submitHandler: function(e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Event/save"); ?>',
					type: 'post',
					beforeSubmit: function(formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function() {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Event');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Event');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});
	});

	$(document).on('click', '.generateEventRate', function() {
		$("#is_pulled").val(1);
		var lastIndex = ($("#event_rate_table tbody tr:last").length >= 1) ? $("#event_rate_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		var rateType = $('#rate_type').val();
		var eventId = $('#event_id').val();
		var startDate = $('#start_date').val();
		var endDate = $('#end_date').val();
		<?php /*
		var eventRateTable = "<?= $event_rate_table ;?>";
		*/ ?>
		$.ajax({
			type: "POST",
			url: "<?php echo admin_url('Event/getEventTableRow'); ?>",
			dataType: "json",
			data: {
				rate_type: rateType,
				event_id: eventId,
				start_date: startDate,
				end_date: endDate,
				row_number: rowNumber,
			},
			success: function(resObj) {
				if (resObj.success) {
					<?php /*
					$('#event-rate-table').html(eventRateTable);
					*/ ?>
					$('#event_rate_table tbody').html(resObj.event_rate_row_data);
					addSerialNumber('event_rate_table');
					numberInit();
				} else {
					Swal.fire({
						title: 'Error!',
						text: resObj.msg,
						icon: 'error',
						customClass: {
							confirmButton: 'btn btn-primary waves-effect waves-light'
						},
						buttonsStyling: false
					}).then(function() {
						dt_DataTable.ajax.reload();
					});
				}
			}
		});
	});

	$(document).on('click', '.delete-image', function() {
		var deleteId = $(this).attr("id");
		var eventId = $("#event_id").val();
		Swal.fire({
			title: "<?= ucwords(lang('CommonMessage.common_delete')); ?>",
			text: "<?= lang('CommonMessage.delete_warning'); ?>",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonText: 'OK',
			customClass: {
				confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
				cancelButton: 'btn btn-label-secondary waves-effect waves-light'
			},
			buttonsStyling: false
		}).then(function(result) {
			if (result.value) {
				$("span.document-image-" + deleteId).remove();
				$.ajax({
					type: "post",
					url: "<?= admin_url("Event/deleteEventImage") ?>",
					dataType: "json",
					data: {
						event_image_id: deleteId,
						event_id: eventId
					},
					success: function(data) {
						if (data['success']) {
							$(".delete-image").click(function() {
								$(this).parent().remove();
							});
							Swal.fire({
								title: 'Success',
								text: data['msg'],
								icon: 'success',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
						} else {
							Swal.fire({
								title: 'Error!',
								text: data['msg'],
								icon: 'error',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
						}
					}
				});
			}
		});
	});

	$('#start_date, #end_date, #rate_type').on('change', function() {
		var isBookingRequired = $('#is_booking_required').is(':checked');
		if (isBookingRequired) {
			$("#is_pulled").val(0);
		} else {
			$("#is_pulled").val(1);
		}
	});

	$('#is_booking_required').on('change', function() {
		var isBookingRequired = $('#is_booking_required').is(':checked');
		if (isBookingRequired) {
			$("#is_pulled").val(0);
		} else {
			$("#is_pulled").val(1);
		}
	});
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>