<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#commonkeys_detail" aria-controls="commonkeys_detail" aria-selected="true">
			<?= lang('CommonKeys.commonkeys_detail'); ?>
		</button>
	</li>
    <li class="nav-item">
        <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#key_set_history" aria-controls="key_set_history" aria-selected="false">
            <?= lang('CommonKeys.key_set_history'); ?>
        </button>
    </li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="commonkeys_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="commonkeys_detail_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("CommonKeys.description"); ?></td>
						<td><?php
							echo (isset($common_keys_data['description']) && $common_keys_data['description'] != "") ? ($common_keys_data['description']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("CommonKeys.remarks"); ?></td>
						<td><?php
							echo (isset($common_keys_data['remarks']) && $common_keys_data['remarks'] != "") ? $common_keys_data['remarks'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("CommonKeys.keys_set"); ?></td>
						<td><?php
							echo (isset($common_keys_data['keys_name']) && $common_keys_data['keys_name'] != "") ? ($common_keys_data['keys_name']) : '-';
							?>
						</td>
					</tr>
                    <tr>
                        <td>
                            <?= lang("CommonKeys.issue_key"); ?>
                        </td>
                        <td>
                        <div class="table-responsive text-nowrap">
                            <table id="key_set_history_table" class="table table-bordered">
                            <?php if(isset($common_keys_issue_data) && !empty($common_keys_issue_data)){ ?>
                                <thead>
                                <tr>
                                    <th><?= lang("CommonKeys.key_name"); ?></th>
                                    <th><?= lang("CommonKeys.key_issue_name"); ?></th>

                                </tr>
                                <?php foreach ($common_keys_issue_data as $commonKeyElement){ ?>
                                <tr>
                                    <td class="text-bold"><?= $commonKeyElement['keys_name']; ?></td>
                                    <td><?php
                                        echo $commonKeyElement['key_issue_name'];
                                        ?></td>
                                </tr>
                            <?php } } ?>
                            </table>
                        </div>
                        </td>
                    </tr>
					<tr>
						<td><?= lang("Society.created_at"); ?></td>
						<td><?php
							echo (isValidDate($common_keys_data['created_at']) && $common_keys_data['created_at'] != "") ? siteDateFormat($common_keys_data['created_at'],true) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Society.created_by"); ?></td>
						<td><?php
							echo (isset($common_keys_data['created_by']) && $common_keys_data['created_by'] != "") ? ($common_keys_data['created_by']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Society.updated_at"); ?></td>
						<td><?php
							echo (isValidDate($common_keys_data['updated_at']) && $common_keys_data['updated_at'] != "") ? siteDateFormat($common_keys_data['updated_at'],true) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Society.updated_by"); ?></td>
						<td><?php
							echo (isset($common_keys_data['updated_by']) && $common_keys_data['updated_by'] != "") ? ($common_keys_data['updated_by']) : '-';
							?>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>

    <div class="tab-pane fade" id="key_set_history" role="tabpanel">
        <div class="table-responsive text-nowrap">
            <table id="key_set_history_table" class="table table-bordered">
                <thead>
                <tr>
                    <th><?= lang("CommonMessage.common_sr_no"); ?></th>
                    <th><?= lang("KeyIssue.key_issue_date"); ?></th>
                    <th><?= lang("KeyIssue.common_keys"); ?></th>
                    <th><?= lang("KeyIssue.key_name"); ?></th>
                    <th><?= lang("KeyIssue.key_issue"); ?></th>

                </tr>
                </thead>
                <tbody class="">
                <?php if ($key_issue_data != '' && array_filter($key_issue_data)) { ?>
                    <?php
                    $sr = 1;
                    foreach ($key_issue_data as $key => $value) { ?>
                        <tr>
                            <td><?= $sr; ?></td>
                            <td><?= isset($value['key_issue_date']) && isValidDate($value['key_issue_date']) ? YMDToDMY($value['key_issue_date']) : ''; ?> </td>
                            <td> <?= isset($value['description']) ? $value['description'] : ''; ?> </td>
                            <td> <?=isset($value['keys_name']) ? $value['keys_name'] : ''; ?> </td>
                            <td> <?=isset($value['key_issue']) ? $value['key_issue'] : ''; ?> </td>
                        </tr>
                        <?php $sr++;
                    }
                } else {   ?>
                    <tr>
                        <td colspan="5" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
	
</div>