<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Charges.charges_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_charges',
				);
				echo form_open_multipart('',$form_id);
				$chargesId = (isset($charges_data['charges_id']) && ($charges_data['charges_id'] != '')) ? $charges_data['charges_id'] : '';
				?>
				<input type="hidden" id="charges_id" name="charges_id" value="<?= $chargesId ?>">
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Charges.fee_type');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<?php
								$feeTypes = feeType();
							?>
							<select data-placeholder="Select  <?= lang('Charges.fee_type'); ?>" name="fee_type"
								id="fee_type" class="select2 form-select dt-fee-type">
								<option value=""> </option>
								<?php
								$selectedChargesType = isset($charges_data['fee_type']) ? $charges_data['fee_type'] : "";
								foreach ($feeTypes as $feeKey => $feeType) { ?>
									<option <?= ($selectedChargesType == $feeKey) ? "selected" : ""; ?>
										value="<?= $feeKey; ?>"> <?= $feeType; ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Charges.charges_name');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="charges_name" id="charges_name" placeholder="Enter <?= lang('Charges.charges_name');?>" value="<?= (isset($charges_data['charges_name']) && ($charges_data['charges_name'] != '')) ? ($charges_data['charges_name']) : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Charges.amount');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="amount" id="amount" placeholder="Enter <?= lang('Charges.amount');?>" value="<?= (isset($charges_data['amount']) && ($charges_data['amount'] != '')) ? roundNumber($charges_data['amount']) : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Charges.deposit');?><span class="text-danger"> </span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="deposit" id="deposit" placeholder="Enter <?= lang('Charges.deposit');?>" value="<?= (isset($charges_data['deposit']) && ($charges_data['deposit'] != '')) ? roundNumber($charges_data['deposit']) : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Charges.gst');?><span class="text-danger"> </span></label>
						<div class="col-sm-10">	
							<select id="tax_id" name="tax_id" class="select2 form-select form-select-lg taxDd dt-tax" data-allow-clear="true">
							<option></option>
							<?php if(isset($charges_data['tax_id']) && $charges_data['tax_id'] != 0){ ?>
							<option value="<?= isset($charges_data['tax_id']) ? $charges_data['tax_id'] : 0 ?>" selected> <?= isset($charges_data['tax_name']) ? $charges_data['tax_name'] : ''  ?> </option>
							<?php } ?>
						</select>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Charges.remarks');?><span class="text-danger"> </span></label>
						<div class="col-sm-10">
							<textarea name="remarks"  id="remarks" placeholder="Enter <?= lang('Charges.remarks'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($charges_data['remarks']) && ($charges_data['remarks'] != '')) ? $charges_data['remarks'] : ''; ?></textarea>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($charges_data['is_active']) || $charges_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>
						</div>
					</div>
					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Charges'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
    	taxDd();
    	$(".dt-fee-type").select2();
		switcheryKeyGen("datatable-list-switchery");
        // Initialize
		var validator = $("#form_charges").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				fee_type: {
					required: true
				},
				charges_name: {
					required: true
				},
				amount : {
					required: true
				},
				// tax_id : {
				// 	required: true,
				// },
            },
            messages: {
				fee_type: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Charges.fee_type');?>"
				},
				amount : {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Charges.amount');?>"
				},
				// tax_id : {
				// 	required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Charges.gst');?>"
				// },
				charges_name: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Charges.charges_name');?>"
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Charges/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Charges');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Charges');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
