<!-- Add New Address Modal -->
<div class="modal fade" id="category_modal" tabindex="-1" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-simple modal-add-new-address">
		<div class="modal-content p-3 p-md-5">
			<div class="modal-body">
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				<div class="text-center mb-4">
					<h3 class="address-title mb-2"><?= lang('Category.category_form'); ?></h3>
				</div>
				<?php
				$form_id = array(
					'id' => 'form_category',
					'method' => 'post',
					'class' => 'row g-3',
					'autocomplete' => 'off'
				);
				echo form_open_multipart('',$form_id);
				?>
				<input type="hidden" name="category_id" id="category_id">
 				<div class="col-12">
					<label class="form-label" for=""><?= lang('Category.category_for'); ?><span class="text-danger"> *</span></label>
					<?php
                        $categoryFors = categoryFor();
                    ?>
                    <select data-placeholder="Select  <?= lang('Category.category_for'); ?>" name="category_for" id="category_for"  class="select2 form-select form-select-lg dt-category-for" data-allow-clear="true" >
                        
                        <?php
                        
                        foreach ($categoryFors as $categoryKey => $category) { ?>
                            <option value="<?= $categoryKey; ?>"> <?= $category; ?> </option>
                        <?php } ?>
                    </select>
				</div>
				<div class="col-12">
					<label class="form-label" for=""><?= lang('Category.category_name'); ?><span class="text-danger"> *</span></label>
					<input
						type="text"
						id="category_name"
						name="category_name"
						class="form-control"
						placeholder="Enter <?= lang('Category.category_name'); ?>"/>
				</div>

				<div class="col-12">
					<label class="form-label" for=""><?= lang('Category.category_image'); ?><span class="text-danger"> </span></label>

					<input type="file" accept="image/*" class="form-control" name="category_image">
					<span class="form-text text-muted"><?= FILE_UPLOAD_TYPE_MSG; ?></span> <br>
					<span id="image_display">
					</span>
				</div>
				<div class="col-12">

					<label class="switch switch-sm">
						<input type="checkbox" class="switch-input form-add-switchery "  name="is_active" id="is_active"/>
						<span class="switch-toggle-slider">
                              <span class="switch-on"></span>
                              <span class="switch-off"></span>
                            </span>
						<span class="switch-label">Active</span>
					</label>
				</div>
				<div class="col-12 text-center">
					<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
					<button
						id="cancelBtn"
						type="reset"
						class="btn btn-label-secondary"
						data-bs-dismiss="modal"
						aria-label="Close">
						Cancel
					</button>
				</div>
				<?= form_close(); ?>
			</div>
		</div>
	</div>
</div>
<!--/ Add New Address Modal -->


<!--  add,update and delete model code here-->
<script type="text/javascript">
	//var laddaSubmitBtn = Ladda.create(document.querySelector('#submit'));
	$(document).ready(function () {
		$(".dt-category-for").select2();
		Select2InitModalPopup();
		//societyDd();
		//customToolTip();
		//validation
		var validator = $("#form_category").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function (element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function (element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function (label) {
				label.addClass('validation-valid-label'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function (error, element) {
				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo(element.parents('.form-check').parent());
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo(element.parent());
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo(element.parent().parent());
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				category_name: {
					required: true
				},
				category_for: {
					required: true
				},
			},
			messages: {
				category_name: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Category.category_name'); ?>",
				},
				category_for: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Category.category_for'); ?>",
				},
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Category/addEdit");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {
						//laddaStop();
					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    $('#category_modal').modal('hide');
                                    dt_DataTable.ajax.reload(null, false);
                                }
							});
							// setTimeout(function () {
							// 	$('#category_modal').modal('hide');
							// 	dt_DataTable.ajax.reload(null, false);
							// }, 1000);
						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>