<?php
$assets = base_url() . 'assets/';
$budgetData = !empty($budget_data) && is_array($budget_data) ? $budget_data : array();
$totalExpense = 0;
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $name; ?></title>
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
    <link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
    <link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">
</head>

<body style='font-family:chelvetica;font-size: 9px'>
<div class="row">
    <div class="col-xs-12">
        <h3 style="color: red; text-align: center;"><?= lang('Budget.budget_details'); ?></h3>

        <table class="table" style="border-collapse: collapse;" border="1" cellpadding="1" cellspacing="1" width="100%">
            <thead>
            <tr>
                <td colspan="2" rowspan="2"><center><strong><?= lang('Budget.budgeting'); ?></strong></center></td>
                <td><center><strong>Society</strong></center></td>
                <td><center><strong>Year</strong></center></td>
            </tr>
            <tr>
                <td><center><strong><?= isset($budgetData["society_name"]) ? $budgetData["society_name"] : ""; ?></strong></center></td>
                <td><center><strong><?= isset($budgetData["financial_year_prefix"]) ? $budgetData["financial_year_prefix"] : ""; ?></strong></center></td>
            </tr>
            </thead>

            <tbody>
            <tr>
                <td><center><strong>Expenses</strong></center></td>
                <td><center><strong>Amount</strong></center></td>
                <td><center><strong>Incomes</strong></center></td>
                <td><center><strong>Amount</strong></center></td>
            </tr>
            <tr>
                <!-- Expenses Data -->
                <td colspan="2">
                    <table class="table" style="border: none; width: 100%; border-collapse: collapse;" >
                        <tbody>
                        <?php 
                        if (!empty($expense_data)) {
                            foreach ($expense_data as $expenseElement) {
                                echo '<tr style="border-bottom: 1px solid #ddd;"><td><strong>' . trim($expenseElement['account_code_name']) . '</strong></td></tr>';
                                
                                if (isset($expenseElement['sub_account_data']) && !empty($expenseElement['sub_account_data'])) {
                                    foreach ($expenseElement['sub_account_data'] as $subAccountElement) {
                                        $expenseAmountValue = isset($subAccountElement['amount']) ? $subAccountElement['amount'] : 0;
                                        $totalExpense += $expenseAmountValue;
                                        ?>
                                        <tr style="border-bottom: 1px solid #ddd;">
                                            <td class="text-primary"><?= $subAccountElement['sub_account_code_name']; ?> </td>
                                            <td class="text-right"><?= $expenseAmountValue; ?></td>
                                        </tr>
                                        <?php
                                    }
                                }
                            }
                        }
                        ?>
                        </tbody>
                    </table>
                </td>

                <!-- Incomes Data -->
                <td colspan="2">
                    <table class="table" style="border: none; width: 100%; border-collapse: collapse;" >
                        <tbody>
                        <?php 
                        if (!empty($income_data)) {
                            $totalIncome = 0;
                            foreach ($income_data as $incomeElement) {
                                echo '<tr style="border-bottom: 1px solid #ddd;"><td><strong>' . trim($incomeElement['account_code_name']) . '</strong></td></tr>';
                                
                                if (isset($incomeElement['sub_account_data']) && !empty($incomeElement['sub_account_data'])) {
                                    foreach ($incomeElement['sub_account_data'] as $subAccountElement) {
                                        $incomeAmountValue = isset($subAccountElement['amount']) ? $subAccountElement['amount'] : 0;
                                        $totalIncome += $incomeAmountValue;
                                        ?>
                                        <tr style="border-bottom: 1px solid #ddd;">
                                            <td class="text-primary"><?= $subAccountElement['sub_account_code_name']; ?>: </td>
                                            <td class="text-right"><?= $incomeAmountValue; ?></td>
                                        </tr>
                                        <?php
                                    }
                                }
                            }
                        }
                        ?>
                        </tbody>
                    </table>
                </td>
            </tr>
            <tr>
                <td><center><strong>Total Expense</strong></center></td>
                <td class="text-right"><?= $totalExpense; ?></td>
                <td><center><strong>Total Income</strong></center></td>
                <td class="text-right"><?= $incomeAmountValue; ?></td>
            </tr>
            </tbody>
        </table>
    </div>
</div>
</body>
</html>
