<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$budgetAccountData = isset($budget_account_data) ? $budget_account_data : array();
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Budget.budget_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_budget',
				);
				echo form_open_multipart('',$form_id);
				$budgetId = (isset($budget_data['budget_id']) && ($budget_data['budget_id'] != '')) ? $budget_data['budget_id'] : '';
				?>
				<input type="hidden" id="budget_id" name="budget_id" value="<?= $budgetId ?>">
					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Budget.financial_year');?><span class="text-danger"> *</span></label>
						<select id="financial_year_id" name="financial_year_id" class="select2 form-select form-select-lg financialYearDd" data-allow-clear="true">
							<option></option>
							<?php if(isset($budget_data['financial_year_id']) && $budget_data['financial_year_id'] != 0){ ?>
							<option value="<?= isset($budget_data['financial_year_id']) ? $budget_data['financial_year_id'] : 0 ?>" selected> <?= isset($budget_data['financial_year_prefix']) ? $budget_data['financial_year_prefix'] : ''  ?> </option>
							<?php } ?>
						</select>
					</div>

					<hr class="my-4 mx-n4" />
					<h6> <?= lang('Budget.account_info'); ?></h6>
					<div class="row g-3">
                    	<?= isset($budget_account_table) ? $budget_account_table : ""; ?>
                	</div>

					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Budget'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
    	documentDd();
		financialYearDd();
		switcheryKeyGen("datatable-list-switchery");
		addSerialNumber("budget_account_table");
        // Initialize
		var validator = $("#form_budget").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				financial_year_id: {
					required: true,
				},
            },
            messages: {
				financial_year_id: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Budget.financial_year"); ?>',
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Budget/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Budget');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Budget');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });

</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
