<style>
	.dt-no-padding-table tr td {
		padding: 5px !important;
		margin: 0 !important;
	}
</style>

<div class="card">
	<div class="card-header header-elements-inline">
		<h5 class="card-title">Booking Map</h5>
		<div class="header-elements">
			<div class="row">
				<div class="col-5">
					<select class="select mr-3" id="booking_month" data-placeholder="Select Month">
						<option></option>
						<?= monthsDropDown(date("m")); ?>
					</select>
				</div>

				<div class="col-5">
					<select class="form-control select mr-3" id="booking_year" data-placeholder="Select Year">
						<option></option>
						<?= yearDropDown(date("Y")-5,date("Y"),date("Y")); ?>
					</select>
				</div>

				<div class="col-2">
					<button type="button" class="btn btn-icon btn-outline-dribbble dt-filter"><i class="fa fa-filter"></i></button>
				</div>
			</div>
		</div>
	</div>
	<div class="card-body table-responsive">
		<div class="row dt-booking-div">
		</div>
	</div>
</div>
<script>
	$(document).ready(function (){
		$(".select").select2({ allowClear: true,containerCssClass: 'border-primary'});
		$(".dt-filter").click(function (){
			$.ajax({
				type: 'post',
				url: '<?php echo admin_url('BookingCalendar/bookingData'); ?>',
				dataType: 'html',
				data: {
					booking_year: $("#booking_year").val(),
					booking_month: $("#booking_month").val(),
				},
				success: function (jsonObj) {
					$(".dt-booking-div").html(jsonObj);
				}
			});
		});
		$(".dt-filter").click();
	});
</script>
