<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();

$prefix = session('is_super_admin') ? 'SuperAdmin' : 'Admin/Auth';
$editUserUrl = site_url($prefix . "/edit_user");
?>
<div class="card">
    <div class="card-datatable table-responsive text-nowrap">
        <table id="dt-users-table" class="datatables-ajax table dt-datatable">
            <thead>
            <tr>
                <th><?= lang('Auth.index_fname_th'); ?></th>
                <th><?= lang('Auth.index_lname_th'); ?></th>
                <th><?= lang('Auth.index_email_th'); ?></th>
                <th><?= lang('Auth.index_groups_th'); ?></th>
                <th><?= lang('Auth.index_status_th'); ?></th>
                <th class="text-center"><?= lang('CommonMessage.common_action'); ?></th>
            </tr>
            </thead>
        </table>
    </div>

</div>

<script type="text/javascript">
    var dt_DataTable;
    $(document).ready(function () {
        dt_DataTable = $('#dt-users-table').DataTable({
            dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
                '<"me-5 ms-n2 pe-5"f>' +
                '<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
                '>t' +
                '<"row mx-2"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            processing: true,
            serverSide: true,
            displayLength: 10,
            language: {
                sLengthMenu: 'Show _MENU_',
                search: '',
                searchPlaceholder: 'Search <?= lang('Auth.user'); ?>',
                info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
            },
            buttons:[
                <?php if ($dtCIAcl->checkAccess("Auth|edit_user")) { ?>
                {
                    text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang("Auth.add_users"); ?> </span>',
                    className: 'add-new btn btn-primary  px-1 me-2 ',
                    action: function () {
                        window.location.href = '<?= $editUserUrl;?>';
                    }
                },
                <?php } ?>
            ],
            "ajax": {
                "url": "<?php echo admin_url('Auth/getUsersListing'); ?>",
                "type": "POST",
                "data": function (d) {

                }
            },
            "order": [[1, "asc"]],
            "columns": [
                {"data": "first_name"},
                {"data": "last_name"},
                {"data": "email"},
                {"data": "group_name",  "searchable": false},
                {
                    "data": "active",
                    "sortable": false,
                    "searchable": false,
                    "render": function (data, type, row) {
                        var checked = (data == 1) ? "checked" : "";
                        return '<label class="switch switch-primary switch-sm">' +
                            '<input type="checkbox" class="switch-input dt-active-status1" ' + checked + '  data-id="' + row['id'] + '" value="1" />' +
                            '<span class="switch-toggle-slider">' +
                            '<span class="switch-on"></span>' +
                            '<span class="switch-off"></span>' +
                            '</span>';
                        '</label>';
                    }
                },
                {
                    "data": "action_button",
                    "class": "text-center",
                    "sortable": false,
                    "searchable": false
                },
            ],
            "fnDrawCallback": function (oSettings, json) {
                customToolTip();
                $('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
                $('.dt-buttons').addClass('d-flex flex-wrap');
                $('.dataTables_filter .form-control').removeClass('form-control-sm');
                $('.dataTables_length .form-select').removeClass('form-select-sm');
            }
        });
        // $('div.head-label').html('<h5 class="card-title mb-0">Manage Groups</h5>');
        dtDataTableSearch();
    });

    $(document).on('click', '.dt-active-status1', function () {
        var id = $(this).attr('data-id');
        var isActive = $(this).is(":checked") ? 1 : 0;
        $.ajax({
            type: 'post',
            url: '<?php echo admin_url('Auth/changeStatus'); ?>',
            data: {user_id:id, status: isActive},
            dataType: 'json',
            success: function (data) {
                if (data) {
                    Swal.fire({
                        title: 'Success',
                        text: data.msg,
                        icon: 'success',
                        customClass: {
                            confirmButton: 'btn btn-primary waves-effect waves-light'
                        },
                        buttonsStyling: false
                    }).then(function() {
                        dt_DataTable.ajax.reload(null,false);
                    });
                } else {
                    Swal.fire({
                        title: 'Error!',
                        text: data.msg,
                        icon: 'error',
                        customClass: {
                            confirmButton: 'btn btn-primary waves-effect waves-light'
                        },
                        buttonsStyling: false
                    });
                }
            }
        });
    });

    //Delete Record
    $(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr('data-id');
        Swal.fire({
            title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
            text: "<?= lang('CommonMessage.delete_warning'); ?>",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
            customClass: {
                confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                cancelButton: 'btn btn-label-secondary waves-effect waves-light'
            },
            buttonsStyling: false
        }).then(function (result) {
            if (result.value) {
                $.ajax({
                    type: "post",
                    url: "<?= admin_url("Auth/deleteUser")?>",
                    dataType: "json",
                    data: {user_id: id},
                    success: function (data) {
                        if (data['success']) {
                            Swal.fire({
                                title: 'Success',
                                text: data['msg'],
                                icon: 'success',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function () {
                                dt_DataTable.ajax.reload();
                            });
                        } else {
                            Swal.fire({
                                title: 'Error!',
                                text: data['msg'],
                                icon: 'error',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function () {
                                dt_DataTable.ajax.reload();
                            });
                        }
                    }
                });
            }
        });
    });
</script>
