<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();

$prefix = session('is_super_admin') ? 'SuperAdmin' : 'Admin/Auth';
$editGroupUrl = site_url($prefix . "/edit_group");
?>
<div class="card">
    <div class="card-datatable table-responsive text-nowrap">
        <table id="dt-groups-table" class="datatables-ajax table dt-datatable">
            <thead>
            <tr>
                <th><?= lang("Auth.group_name"); ?></th>
                <th><?= lang("Auth.group_desc"); ?></th>
                <th><?= lang('CommonMessage.common_created_at'); ?></th>
                <th><?= lang('CommonMessage.common_updated_at'); ?></th>
                <th><?= lang('CommonMessage.common_updated_by'); ?></th>
                <th><?= lang("CommonMessage.common_action"); ?></th>
            </tr>
            </thead>
        </table>
    </div>

</div>

<script type="text/javascript">
    var dt_DataTable;
    $(document).ready(function () {
        dt_DataTable = $('#dt-groups-table').DataTable({
            dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
                '<"me-5 ms-n2 pe-5"f>' +
                '<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
                '>t' +
                '<"row mx-2"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            processing: true,
            serverSide: true,
            displayLength: 10,
            language: {
                sLengthMenu: 'Show _MENU_',
                search: '',
                searchPlaceholder: 'Search <?= lang('Auth.group'); ?>',
                info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
            },
            buttons:[
                <?php if ($dtCIAcl->checkAccess("Auth|edit_group")) { ?>
                {
                    text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang("Auth.add_groups"); ?> </span>',
                    className: 'add-new btn btn-primary  px-1 me-2 ',
                    action: function () {
                        window.location.href = '<?= $editGroupUrl; ?>';
                    }
                },
                <?php } ?>

            ],
            "ajax": {
                "url": "<?php echo admin_url('Auth/getGroupsListing'); ?>",
                "type": "POST",
                "data": function (d) {

                }
            },
            "order": [[1, "asc"]],
            "columns": [
                {"data": "name"},
                {"data": "description"},
                {"data": "created_at"},
                {"data": "updated_at"},
                {"data": "updated_by"},
                {
                    "data": "action_button",
                    "class": "text-center",
                    "sortable": false,
                    "searchable": false
                },
            ],
            "fnDrawCallback": function (oSettings, json) {
                customToolTip();
                $('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
                $('.dt-buttons').addClass('d-flex flex-wrap');
                $('.dataTables_filter .form-control').removeClass('form-control-sm');
                $('.dataTables_length .form-select').removeClass('form-select-sm');
            }
        });
        // $('div.head-label').html('<h5 class="card-title mb-0">Manage Groups</h5>');
        dtDataTableSearch();
    });

    //Delete Record
    $(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr('data-id');
        Swal.fire({
            title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
            text: "<?= lang('CommonMessage.delete_warning'); ?>",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
            customClass: {
                confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                cancelButton: 'btn btn-label-secondary waves-effect waves-light'
            },
            buttonsStyling: false
        }).then(function (result) {
            if (result.value) {
                $.ajax({
                    type: "post",
                    url: "<?= admin_url("Auth/deleteGroup")?>",
                    dataType: "json",
                    data: {group_id: id},
                    success: function (data) {
                        if (data['success']) {
                            Swal.fire({
                                title: 'Success',
                                text: data['msg'],
                                icon: 'success',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function () {
                                dt_DataTable.ajax.reload();
                            });
                        } else {
                            Swal.fire({
                                title: 'Error!',
                                text: data['msg'],
                                icon: 'error',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function () {
                                dt_DataTable.ajax.reload();
                            });
                        }
                    }
                });
            }
        });
    });
</script>
