<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$areaView = isset($area_data['view']) ? $area_data['view'] : 0;
$numberType = isset($area_data['number_type']) ? $area_data['number_type'] : '';
?>

<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0"><?= lang('Area.area_form');?></h5>
            </div>
            <div class="card-body">
                <?php
                //create  form open tag
                $form_id = array(
                    'id' => 'form_area',
                );
                echo form_open_multipart('',$form_id);
                $areaId = (isset($area_data['area_id']) && ($area_data['area_id'] != '')) ? $area_data['area_id'] : '';
                ?>
                <input type="hidden" id="area_id" name="area_id" value="<?= $areaId ?>">
                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Area.area_name');?><span class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="area_name" id="area_name" placeholder="Enter <?= lang('Area.area_name');?>" value="<?= (isset($area_data['area_name']) && ($area_data['area_name'] != '')) ? $area_data['area_name'] : '';  ?>" />
                    </div>
                </div>


                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Area.vehicle_type');?><span class="text-danger"> *</span></label>
                    <?php
                    $vehicleTypes = vehicleType();
                    ?>
                    <div class="col-sm-10">
                        <select data-placeholder="Select  <?= lang('Area.vehicle_type'); ?>" name="vehicle_type"
                                id="vehicle_type" class="select2 form-select dt-vehicle-type">
                            <option> </option>
                            <?php
                            $selectedVehicleType = isset($area_data['vehicle_type']) ? $area_data['vehicle_type'] : "";
                            foreach ($vehicleTypes as $vkey => $vehicleTypeElement) { ?>
                                <option <?= ($selectedVehicleType == $vkey) ? "selected" : ""; ?>
                                        value="<?= $vkey; ?>"> <?= $vehicleTypeElement; ?> </option>
                            <?php } ?>
                        </select>
                    </div>
                </div>


                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Area.slot');?><span class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control numberInit" name="slot" id="slot" placeholder="Enter <?= lang('Area.slot');?>" value="<?= (isset($area_data['slot']) && ($area_data['slot'] != '')) ? $area_data['slot'] : '';  ?>" />
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Area.number_type');?><span class="text-danger"> *</span></label>
                    <?php
                    $numberTypes = numberType();
                    ?>
                    <div class="col-sm-10">
                    <select data-placeholder="Select  <?= lang('Area.number_type'); ?>" name="number_type"
                            id="number_type" class="select2 form-select dt-number-type">
                        <option> </option>
                        <?php
                        $selectedNumberType = isset($area_data['number_type']) ? $area_data['number_type'] : "";
                        foreach ($numberTypes as $key => $numberTypeElement) { ?>
                            <option <?= ($selectedNumberType == $key) ? "selected" : ""; ?>
                                    value="<?= $key; ?>"> <?= $numberTypeElement; ?> </option>
                        <?php } ?>
                    </select>
                    </div>
                </div>

                <div class="row mb-3 dt-range-div">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Area.range_label');?><span class="text-danger"> </span></label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="range_label" id="range_label" placeholder="Enter <?= lang('Area.range_label');?>" value="<?= (isset($area_data['range_label']) && ($area_data['range_label'] != '')) ? $area_data['range_label'] : '';  ?>" />
                    </div>
                </div>

                <div class="row mb-3 dt-range-div">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Area.range_start_from');?><span class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <input type="tel" class="form-control numberInit" name="range_start_from" id="range_start_from" placeholder="Enter <?= lang('Area.range_start_from');?>" value="<?= (isset($area_data['range_start_from']) && ($area_data['range_start_from'] != '')) ? $area_data['range_start_from'] : '';  ?>" />
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
                    <div class="col-sm-10">
                        <label class="switch switch-sm"><span class="switch-label"></span>
                            <input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($area_data['is_active']) || $area_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
                            <span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
                        </label>
                    </div>
                </div>
                <div class="pt-4">
                    <button type="submit" class="btn btn-primary me-sm-3 me-1"><?= lang('CommonMessage.common_submit'); ?></button>
                    <button type="button" onclick="window.location.href='<?php echo admin_url('Area'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>


<!--  add,update and delete model code here-->
<script type="text/javascript">
    //var laddaSubmitBtn = Ladda.create(document.querySelector('#submit'));
    $(document).ready(function () {
        <?php /* if(!empty($areaId)){ ?>
            $("#slot").attr("readonly" , true);
        <?php } */?>
        numberInit();
        $('.dt-number-type,.dt-vehicle-type').select2();
        //validation
        var validator = $("#form_area").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function (label) {
                label.addClass('validation-valid-label'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function (error, element) {
                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo(element.parents('.form-check').parent());
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo(element.parent());
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo(element.parent().parent());
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                area_name: {
                    required: true
                },
                slot: {
                    required: true
                },
                vehicle_type: {
                    required: true
                },
                number_type: {
                    required: true
                },
            },
            messages: {
                area_name: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang("Area.area_name"); ?>",
                },
                slot: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang("Area.slot"); ?>",
                },
                vehicle_type: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang("Area.vehicle_type"); ?>",
                },
                number_type: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang("Area.number_type"); ?>",
                },
            },
            submitHandler: function (e) {
                $(e).ajaxSubmit({
                    url: '<?php echo admin_url("Area/save");?>',
                    type: 'post',
                    beforeSubmit: function (formData, jqForm, options) {
                        //laddaStart();
                    },
                    complete: function () {
                        //laddaStop();
                    },
                    dataType: 'json',
                    clearForm: false,
                    success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
                                    dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Area');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Area');?>';
							// }, 1000);

						} else {
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
                });
            }
        });



    });

    $(document).on('change', '.dt-number-type', function () {
        var numberType = $(this).val();
        if (numberType == 'range') {
            $(".dt-range-div").show();
        } else {
            $(".dt-range-div").hide();
        }
    });

    <?php if(strtolower($numberType) == 'range'){?>
    $(".dt-range-div").show();
    <?php } else {?>
    $(".dt-range-div").hide();
    <?php }?>
</script>
