<div class="modal fade" id="amenities_reject_reason_modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
        <div class="modal-content p-3 p-md-5">
            <div class="modal-body">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="text-center mb-4">
                    <h3 class="mb-2">Reject Amenities</h3>
                </div>

                <?php
                $form_id = array(
                    'id'        => 'form_amenities_reject_reason_modal',
                    'method'    => 'post',
                    'class'     => 'row g-3',
                    'autocomplete' => 'off'
                ); ?>
                <?= form_open('', $form_id); ?>

                <input type="hidden" name="modal_amenities_id" id="modal_amenities_id">
                <input type="hidden" name="modal_status" id="modal_status">

                <div class="col-12">
                    <label class="form-label" for="modalAddCardName"><?= lang('Amenities.reject_reason'); ?><span class="text-danger"> *</span></label>
                    <textarea name="reject_reason" id="reject_reason" placeholder="Enter <?= lang('Amenities.reject_reason'); ?>" rows="3" cols="5" class="form-control"></textarea>
                </div> 

                <div class="col-12 text-center">
                    <button type="submit" class="btn btn-primary me-sm-3 me-1">Submit</button>
                    <button type="reset" class="btn btn-label-secondary btn-reset" data-bs-dismiss="modal" aria-label="Close">
                        Cancel
                    </button>
                </div>
                <?= form_close(); ?>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {

		// Initialize
		var validator = $("#form_amenities_reject_reason_modal").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
                reject_reason: {
					required: true,
				}
			},
			messages: {
                reject_reason: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Amenities.reject_reason"); ?>',
				}
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Amenities/rejectAmenitiesStatus");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {

					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
                            $('#amenities_reject_reason_modal').modal('hide');
							Swal.fire({
								title: 'Success',
								text: resObj.msg,
								icon: 'success',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								window.location.href = '<?php echo admin_url('Amenities');?>';
							});

						} else {
							Swal.fire({
								title: 'Error!',
								text: resObj.msg,
								icon: 'error',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							});
						}
					}
				});
			}
		});
	});

</script>