<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#amenities_detail" aria-controls="amenities_detail" aria-selected="true">
			<?= lang('Amenities.amenities_detail'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#unit_information" aria-controls="unit_information" aria-selected="false">
			<?= lang('Amenities.unit_information'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#booking_slot_information" aria-controls="booking_slot_information" aria-selected="false">
			<?= lang('Amenities.booking_slot_information'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="amenities_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="amenities_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Amenities.amenities_name"); ?></td>
						<td><?php
							echo (isset($amenities_data['amenities_name']) && $amenities_data['amenities_name'] != "") ? $amenities_data['amenities_name'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Amenities.total_quantity"); ?></td>
						<td><?php
							echo (isset($amenities_data['total_quantity']) && $amenities_data['total_quantity'] != "") ? $amenities_data['total_quantity'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Amenities.max_advance_booking"); ?></td>
						<td><?php
							echo (isset($amenities_data['max_advance_booking']) && $amenities_data['max_advance_booking'] != "") ? $amenities_data['max_advance_booking'] . " " . underscoreToUcWord($amenities_data['day_type']) : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Amenities.amenities_operational_hours"); ?></td>
						<td><?php
							echo (isset($amenities_data['from_hour']) && $amenities_data['from_hour'] != "") ? date("h:i A",strtotime($amenities_data['from_hour'])) .' To '.date("h:i A",strtotime($amenities_data['to_hour'])) : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Amenities.common_area"); ?></td>
						<td><?php
							echo (isset($amenities_data['common_area_name']) && $amenities_data['common_area_name'] != "") ? $amenities_data['common_area_name'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Amenities.max_booking_per_slot"); ?></td>
						<td><?php
							echo (isset($amenities_data['max_booking_per_slot']) && $amenities_data['max_booking_per_slot'] != "") ? ($amenities_data['max_booking_per_slot']) : '-';
							?>
						</td>
					</tr>									
					<tr>
						<td><?= lang("Amenities.payment_required"); ?></td>
						<td><?php
							echo (isset($amenities_data['payment_required']) && $amenities_data['payment_required'] != 0) ? 'Yes' : 'No';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Amenities.admin_approval_required"); ?></td>
						<td><?php
							echo (isset($amenities_data['admin_approval_required']) && $amenities_data['admin_approval_required'] != 0) ? 'Yes' : 'No';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Amenities.booking_allowed"); ?></td>
						<td><?php
							echo (isset($amenities_data['booking_allowed']) && $amenities_data['booking_allowed'] != 0) ? 'Yes' : 'No';
							?>
						</td>
					</tr>
					<?php if(isset($amenities_data['payment_required']) && $amenities_data['payment_required'] != 0){?>
						<tr>
							<td><?= lang("Amenities.cancel_before"); ?></td>
							<td><?php
								echo (isset($amenities_data['cancel_before']) && $amenities_data['cancel_before'] != "") ? $amenities_data['cancel_before'] . " " . underscoreToUcWord($amenities_data['cancel_before_type']) : '-';
								?>
							</td>
						</tr>
						<tr>
							<td><?= lang("Amenities.pay_before"); ?></td>
							<td><?php
								echo (isset($amenities_data['pay_before']) && $amenities_data['pay_before'] != "") ? $amenities_data['pay_before'] . " " . underscoreToUcWord($amenities_data['pay_before_type']) : '-';
								?>
							</td>
						</tr>
						<tr>
							<td><?= lang("Amenities.tax"); ?></td>
							<td><?php
								echo (isset($amenities_data['tax_name']) && $amenities_data['tax_name'] != "") ? ($amenities_data['tax_name']) : '-';
								?>
							</td>
						</tr>
					<?php }?>
					<?php /*				
					<tr>
						<td><?= lang("Amenities.status"); ?></td>
						<td><?php
							echo (isset($amenities_data['status']) && $amenities_data['status'] != "") ? underscoreToUcWord($amenities_data['status']) : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_rejected_at"); ?></td>
						<td><?php
							echo (isset($amenities_data['rejected_at']) && isValidDate($amenities_data['rejected_at'])) ? siteDateFormat($amenities_data['rejected_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_rejected_by"); ?></td>
						<td><?php
							echo (isset($amenities_data['rejected_by']) && $amenities_data['rejected_by'] != 0) ? $amenities_data['rejected_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_approved_at"); ?></td>
						<td><?php
							echo (isset($amenities_data['approved_at']) && isValidDate($amenities_data['approved_at'])) ? siteDateFormat($amenities_data['approved_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_approved_by"); ?></td>
						<td><?php
							echo (isset($amenities_data['approved_by']) && $amenities_data['approved_by'] != 0) ? $amenities_data['approved_by'] : '-';
							?></td>
					</tr> */ ?>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($amenities_data['created_at']) && isValidDate($amenities_data['created_at'])) ? siteDateFormat($amenities_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($amenities_data['created_by']) && $amenities_data['created_by'] != "") ? $amenities_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($amenities_data['updated_at']) && isValidDate($amenities_data['updated_at'])) ? siteDateFormat($amenities_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($amenities_data['updated_by']) && $amenities_data['updated_by'] != "") ? $amenities_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>

	<div class="tab-pane fade" id="unit_information" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="unit_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang("Amenities.unit_name"); ?></th>
					</tr>
				</thead>
				<tbody class="">
					<?php if ($amenities_unit_data != '' && array_filter($amenities_unit_data)) { ?>
						<?php
						$sr = 1;
						foreach ($amenities_unit_data as $key => $value) { ?>
							<tr>
								<td><?= $sr; ?></td>
								<td><?= $value['unit_name']; ?> </td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="4" align="center"> <?= lang('CommonMessage.no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>
	</div>

	<div class="tab-pane fade" id="booking_slot_information" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="unit_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang('Amenities.start_time'); ?></th>
						<th><?= lang('Amenities.end_time'); ?></th>
						<th><?= lang('Amenities.hour'); ?></th>
						<th><?= lang('Amenities.minutes'); ?></th>
						<?php if(isset($amenities_data['payment_required']) && $amenities_data['payment_required'] != 0){?>
							<th><?= lang('Amenities.unit_payment_information'); ?></th>
						<?php }?>
						<th><?= lang('Amenities.day'); ?></th>
					</tr>
				</thead>
				<tbody class="">
					<?php if ($amenities_booking_slot_data != '' && array_filter($amenities_booking_slot_data)) { ?>
						<?php
						$sr = 1;
						
						foreach ($amenities_booking_slot_data as $key => $value) { 
							$dayData = isset($value['day_data']) ? $value['day_data'] : array();
							$selectedDays = array();
							if (!empty($dayData)) {
								foreach ($dayData as $day) {
									$selectedDays[] = isset($day['day']) ? $day['day'] : "";
								}
							}
							
							?>
							<tr>
								<td><?= $sr; ?></td>
								<td><?= date("h:i A",strtotime($value['start_time'])) ?> </td>
								<td><?= date("h:i A",strtotime($value['end_time'])) ?> </td>
								<td><?= $value['hour']; ?> </td>
								<td><?= $value['minutes']; ?> </td>
								<?php if(isset($amenities_data['payment_required']) && $amenities_data['payment_required'] != 0){ ?>
									<td>
										<table class="table table-bordered">
											<tr>
												<th><?= lang('Amenities.unit_name'); ?></th>
												<th><?= lang('Amenities.price'); ?></th>
											</tr>
											<?php foreach ($value['unit_price_data'] as $upkey => $unitPrice) {?>
												<tr>
													<td><?= $unitPrice['unit_name']; ?></td>
													<td><?= $unitPrice['unit_price']; ?></td>
												</tr>
											<?php }?>
										</table>
									</td>
								<?php }?>
								<td><?php echo underscoreToUcWord(implode(', ', $selectedDays)); ?> </td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="4" align="center"> <?= lang('CommonMessage.no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>
	</div>
</div>