<?php
$html = '';
if (isset($amenities_booking_slot_data) && !empty($amenities_booking_slot_data)) {
	foreach ($amenities_booking_slot_data as $key => $value) {
		$data["booking_slot_row_number"] = $key + 1;
		$data["amenities_booking_slot_data"] = $value;
		$html .= view('Admin/Amenities/AmenitiesBookingSlotRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="amenities_booking_slot_table" class="table table-bordered">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('Amenities.start_time'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Amenities.end_time'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Amenities.hour'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Amenities.minutes'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Amenities.day'); ?><span class="text-danger"> *</span></th>
                <th><?= lang('Amenities.payment'); ?></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($amenities_booking_slot_data) && !empty($amenities_booking_slot_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["booking_slot_row_number"] =  1;
				echo view('Admin/Amenities/AmenitiesBookingSlotRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;

	function addAmenitiesBookingSlot() {
		var lastIndex = ($("#amenities_booking_slot_table tbody tr:last").length >= 1) ? $("#amenities_booking_slot_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('Amenities/addAmenitiesBookingSlotRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				booking_slot_row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#amenities_booking_slot_table tbody').append(data);
					addSerialNumber('amenities_booking_slot_table');
                    amenitiesUnit();
					amenitiesBookingSlot();
					startTime();
					endTime();
					// hour();
					minutes();
					$(".dt-day").select2();
					unitPriceStore();

                    var  paymentRequired = $("#payment_required").prop('checked');
                    if(paymentRequired == true){
                        $(".dt-unit-price-modal-show").show();
                    }
                    else {
                        $(".dt-unit-price-modal-show").hide();
                    }
					// Event listener for time inputs change
					// $('#amenities_booking_slot_table').on('change', '.dt-start-time, .dt-end-time', function () {
					// 	let row = $(this).closest('tr'); // Find the closest row
					// 	let startTime = row.find('.dt-start-time').val();
					// 	let endTime = row.find('.dt-end-time').val();

					// 	if (startTime && endTime) {
					// 		// Calculate the difference
					// 		let timeDiff = calculateTimeDifference(startTime, endTime);

					// 		// Update the hour and minutes fields
					// 		row.find('.dt-hour').val(timeDiff.hours);
					// 		row.find('.dt-minutes').val(timeDiff.minutes);
					// 	}
					// });
					customToolTip();
				}
			}
		});
	}


	$(document).on('click', '.dt-delete-item-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".amenities_booking_slot_id").val();
		var amenitiesId = $("#amenities_id").val();
		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					var deleteId = [];
					deleteId.push(id);
					$.ajax({
						type: "POST",
						url: "<?php echo admin_url('Amenities/deleteAmenitiesBookingSlotRow');?>",
						dataType: "json",
						async:false,
						data: {
                            amenities_booking_slot_id: deleteId,
                            amenities_id: amenitiesId
						},
						success: function (resObj) {
							if (resObj.success) {
								$(trField).remove();
								addSerialNumber('amenities_booking_slot_table');

								Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function() {
									if ($('#amenities_booking_slot_table tbody > tr').length == 0) {
                                        addAmenitiesBookingSlot();
										unitPriceStore();
									}
									unitPriceStore();
								});
							} else {
								Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
								unitPriceStore();
							}
						}
					});
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('amenities_booking_slot_table');
			if ($('#amenities_booking_slot_table tbody > tr').length == 0) {
                addAmenitiesBookingSlot();
				
			}
			unitPriceStore();
		}
	});

	$(document).on('click', '.dt-payment', function () {
        var unitNameArray = [];
        var unitArray = [];

        // $("table#amenities_unit_table .amenities_unit_id").each(function (index) {
        //     var objectOfThisRow = {};
        //     var unitTr = $(this).closest('tr');
        //     var unitName = unitTr.find(".dt-unit-name").val() || '';
        //     objectOfThisRow["unit_name"] = unitName;
        //     objectOfThisRow["unit_price"] = 0;
        //     unitArray.push(objectOfThisRow);
        //     unitNameArray.push(unitName);
        // });

		var trField = $(this).closest('tr');
		var rowNumber = trField.attr("data-id").split("_").pop();
		var bookingSlotId = trField.find(".amenities_booking_slot_id").val() || 0;
        var unitPriceJson = trField.find(".dt-unit-price-json").val() || '';
		var selectedLength = bookingSlotId.length;

		//if (bookingSlotId == 0) {
		//	Swal.fire({
		//		title: "<?php //= ucwords(lang('info')); ?>//",
		//		text: "<?php //= lang('Amenities.payment_info'); ?>//",
		//		confirmButtonColor: "<?php //= BTN_DELETE_INFO; ?>//",
		//		type: "<?php //= lang('info'); ?>//"
		//	}).then(function () {
		//		return false;
		//	});
		//}
		//else {
			$.ajax({
				type: "POST",
				async:false,
				url: "<?php echo admin_url('Amenities/getUnitPaymentData'); ?>",
				dataType: "json",
				data: {
					row_number: rowNumber,
					amenities_booking_slot_id: bookingSlotId,
                    unit_name:unitNameArray,
                    unit_price_json: unitPriceJson
				},
				success: function(resObj) {
					$("#view_model_payment").html(resObj.item_row_data);
					$('#payment_model').modal('show');

                    addSerialNumber('amenities_booking_slot_unit_payment_table');
				}
			});
		// }
	});


    $(document).on('click', '#unit_payment_modal_submit', function () {
        var rowId = $(this).closest("form").find("#unit_payment_row_id").val();
        var trField = $("#amenities_booking_slot_table").find("tr#unit_payment_tr_" + rowId);

        var unitPriceArray = [];
        $("#payment_model table#amenities_booking_slot_unit_payment_table").each(function () {
            var tableData = $(this).find('tr').not(':first');
            if (tableData.length > 0) {
                tableData.each(function () {
                    var objectOfThisRow = {};
                    objectOfThisRow["unit_name"] = $(this).find(".dt-unit-name").val();
                    objectOfThisRow["unit_price"] = $(this).find(".dt-unit-payment").val();
                    unitPriceArray.push(objectOfThisRow);
                });
            }
        });
        trField.find(".dt-unit-price-json").val(JSON.stringify(unitPriceArray));
        $("#payment_model").modal('hide');
    });


	
</script>
<div id="view_model_payment">

</div>