<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class WaterMeterReadingModel extends BaseModel
{
	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getWaterMeterReadingData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_water_meter_reading as twmr');
        $builder->select("twmr.*,ts.society_name,twt.water_tank_name");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = twmr.society_id","left");
		$builder->join("tbl_water_tank as twt","twt.water_tank_id = twmr.water_tank_id","left");
		$builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = twmr.updated_by AND tupdate.society_id = twmr.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = twmr.created_by AND tcreate.society_id = twmr.society_id","left");

		if (isset($filterData['water_meter_reading_id']) && !empty($filterData['water_meter_reading_id'])) {
			if (is_array($filterData['water_meter_reading_id'])) {
				$builder->whereIn('twmr.water_meter_reading_id', $filterData['water_meter_reading_id']);
			} else {
				$builder->where('twmr.water_meter_reading_id', $filterData['water_meter_reading_id']);
			}
		}
		if (isset($filterData['water_meter_reading_id_not']) && !empty($filterData['water_meter_reading_id_not'])) {
			if (is_array($filterData['water_meter_reading_id_not'])) {
				$builder->whereNotIn('twmr.water_meter_reading_id', $filterData['water_meter_reading_id_not']);
			} else {
				$builder->where('twmr.water_meter_reading_id !=', $filterData['water_meter_reading_id_not']);
			}
		}
		if (isset($filterData['water_tank_id']) && !empty($filterData['water_tank_id'])) {
			if (is_array($filterData['water_tank_id'])) {
				$builder->whereIn('twmr.water_tank_id', $filterData['water_tank_id']);
			} else {
				$builder->where('twmr.water_tank_id', $filterData['water_tank_id']);
			}
		}
		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('twmr.society_id', $filterData['society_id']);
			} else {
				$builder->where('twmr.society_id', $filterData['society_id']);
			}
		}
		if (isset($filterData['reading_date_time']) && !empty($filterData['reading_date_time'])) {
			$builder->select('twmr.society_id', $filterData['society_id']);
		}
		// if (isset($filterData['reading_date_time']) && !empty($filterData['reading_date_time'])) {
		// 	$builder->where("twmr.reading_date_time <= ",$filterData['reading_date_time']);
		// }

		// if (isset($filterData['get_last_record'])) {
			if (isset($filterData['get_last_record']) && $filterData['get_last_record'] == '1') {
				$builder->orderBy('twmr.reading_date_time', 'DESC'); // Fetch latest reading
				$builder->limit(1); // Only fetch the most recent entry
			}
		// }
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('ts.society_name', $filterData['search'], 'both');
			$builder->orLike('twt.water_tank_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('twmr.is_active', $filterData['is_active']);
		}
		$builder->orderBy('twmr.water_meter_reading_id','DESC');
		$builder->groupBy('twmr.water_meter_reading_id');
		if(!isset($filterData['is_api_call'])){
			accessFilter($builder, array("society" => "twmr.society_id"));
		}
		if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
		return $queryData;
	}

	public function deleteRecord($waterMeterReadingId,$userId = 0,$societyId = 0)
	{
		$builder = $this->db->table('tbl_water_meter_reading');
        $waterMeterReadingIdArray = is_array($waterMeterReadingId) ? $waterMeterReadingId : array($waterMeterReadingId);
        $builder->whereIn('water_meter_reading_id', $waterMeterReadingIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($waterMeterReadingId)){
				foreach($waterMeterReadingId as $waterMeterReading){
					$deleteDataArray['module'] = 'Water Meter Reading';
            		$deleteDataArray['activity'] = "Water Meter Reading Deleted";
					$deleteDataArray['module_id'] = $waterMeterReading;
					$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
					logActivity('Water Meter Reading Deleted [WaterMeterReadingID: ' . $waterMeterReading . ']',$userId,'Water Meter Reading',$waterMeterReading,json_encode($deleteDataArray),'','Water Meter Reading',$waterMeterReading,$societyId);
				}
			}
			return true;
		}
		return false;
	}
}
?>
