<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class VoucherModel extends BaseModel
{

    public function getVoucherData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_voucher as tv');
        $builder->select("tv.*");

        if(isset($filterData['voucher_id']) && !empty($filterData['voucher_id'])) {
            if (is_array($filterData['voucher_id'])) {
                $builder->whereIn('tv.voucher_id', $filterData['voucher_id']);
            } else {
                $builder->where('tv.voucher_id', $filterData['voucher_id']);
            }
        }
        
        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tv.society_id', $filterData['society_id']);
            } else {
                $builder->where('tv.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('ta.amenities_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tv.voucher_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getVoucherTransactionData($filterData)
	{
		$builder = $this->db->table('tbl_voucher_transaction as tvt');
		$builder->select("tvt.*");

		if(isset($filterData['voucher_transaction_id']) && !empty($filterData['voucher_transaction_id'])) {
			if (is_array($filterData['voucher_transaction_id'])) {
				$builder->whereIn('tvt.voucher_transaction_id', $filterData['voucher_transaction_id']);
			} else {
				$builder->where('tvt.voucher_transaction_id', $filterData['voucher_transaction_id']);
			}
		}

		if(isset($filterData['voucher_id']) && !empty($filterData['voucher_id'])) {
			if (is_array($filterData['voucher_id'])) {
				$builder->whereIn('tvt.voucher_id', $filterData['voucher_id']);
			} else {
				$builder->where('tvt.voucher_id', $filterData['voucher_id']);
			}
		}

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

    public function getVoucherBookingSlotUnitPriceData($filterData)
    {
        $builder = $this->db->table('tbl_amenities_booking_slot_unit_price as tabsup');
        $builder->select("tabsup.*");

        if(isset($filterData['amenities_booking_slot_unit_price_id']) && !empty($filterData['amenities_booking_slot_unit_price_id'])) {
            if (is_array($filterData['amenities_booking_slot_unit_price_id'])) {
                $builder->whereIn('tabsup.amenities_booking_slot_unit_price_id', $filterData['amenities_booking_slot_unit_price_id']);
            } else {
                $builder->where('tabsup.amenities_booking_slot_unit_price_id', $filterData['amenities_booking_slot_unit_price_id']);
            }
        }

        if(isset($filterData['amenities_id']) && !empty($filterData['amenities_id'])) {
            if (is_array($filterData['amenities_id'])) {
                $builder->whereIn('tabsup.amenities_id', $filterData['amenities_id']);
            } else {
                $builder->where('tabsup.amenities_id', $filterData['amenities_id']);
            }
        }
        if(isset($filterData['unit_id']) && !empty($filterData['unit_id'])) {
            if (is_array($filterData['unit_id'])) {
                $builder->whereIn('tabsup.unit_id', $filterData['unit_id']);
            } else {
                $builder->where('tabsup.unit_id', $filterData['unit_id']);
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();

            $builder->groupEnd();
        }

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function deleteVoucherUnitRecord($amenitiesUnitId)
	{
		$builder = $this->db->table('tbl_amenities_unit');
		$amenitiesUnitay = is_array($amenitiesUnitId) ? $amenitiesUnitId : array($amenitiesUnitId);
		$builder->whereIn('amenities_unit_id',$amenitiesUnitay);
		$builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}

    public function deleteVoucherUnit($amenitiesId)
	{
		$builder = $this->db->table('tbl_amenities_unit');
		$amenitiesIdArray = is_array($amenitiesId) ? $amenitiesId : array($amenitiesId);
		$builder->whereIn('amenities_id',$amenitiesIdArray);
		$builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}

    public function deleteVoucherBookingSlotUnitPrice($amenitiesId,$userId)
    {
        $builder = $this->db->table('tbl_amenities_booking_slot_unit_price');
        $amenitiesIdArray = is_array($amenitiesId) ? $amenitiesId : array($amenitiesId);
        $updateData = [
            'is_deleted' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
            // 'updated_by' => $this->data['userId']
            'updated_by' => $userId
        ];
        $builder->whereIn('amenities_id',$amenitiesIdArray);
        $builder->update($updateData);
        // $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
    
    public function getVoucherItemsData($filterData)
	{
		$builder = $this->db->table('tbl_voucher_items as tvi');
		$builder->select("tvi.*,tv.voucher_type,tv.society_id,tv.date");
		$builder->join("tbl_voucher as tv","tv.voucher_id = tvi.voucher_id","left");

		if(isset($filterData['voucher_items_id']) && !empty($filterData['voucher_items_id'])) {
			if (is_array($filterData['voucher_items_id'])) {
				$builder->whereIn('tvi.voucher_items_id', $filterData['voucher_items_id']);
			} else {
				$builder->where('tvi.voucher_items_id', $filterData['voucher_items_id']);
			}
		}

        if(isset($filterData['voucher_month']) && !empty($filterData['voucher_month'])) {
			if (is_array($filterData['voucher_month'])) {
				$builder->whereIn('DATE_FORMAT(tv.date,"%m-%Y")', $filterData['voucher_month']);
			} else {
				$builder->where('DATE_FORMAT(tv.date,"%m-%Y")', $filterData['voucher_month']);
			}
		}

		if(isset($filterData['voucher_id']) && !empty($filterData['voucher_id'])) {
			if (is_array($filterData['voucher_id'])) {
				$builder->whereIn('tvi.voucher_id', $filterData['voucher_id']);
			} else {
				$builder->where('tvi.voucher_id', $filterData['voucher_id']);
			}
		}

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();
			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

    public function deleteVoucherBookingSlotRecord($amenitiesBookingSlotId,$userId)
	{
		$builder = $this->db->table('tbl_amenities_booking_slot');
		$amenitiesBookingSlotay = is_array($amenitiesBookingSlotId) ? $amenitiesBookingSlotId : array($amenitiesBookingSlotId);
        $updateData = [
            'is_deleted' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
            // 'updated_by' => $this->data['userId']
            'updated_by' => $userId
        ];
		$builder->whereIn('amenities_booking_slot_id',$amenitiesBookingSlotay);
        $builder->update($updateData);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}

    public function deleteVoucherBookingSlot($amenitiesId,$userId)
	{
		$builder = $this->db->table('tbl_amenities_booking_slot');
		$amenitiesIdArray = is_array($amenitiesId) ? $amenitiesId : array($amenitiesId);
        $updateData = [
            'is_deleted' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' => $userId
        ];
		$builder->whereIn('amenities_id',$amenitiesIdArray);
        $builder->update($updateData);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}
    public function getVoucherSlotData($filterData)
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_amenities_time_slot as tats');
        $builder->select("tats.*");


        if(isset($filterData['amenities_time_slot_id']) && !empty($filterData['amenities_time_slot_id'])) {
            if (is_array($filterData['amenities_time_slot_id'])) {
                $builder->whereIn('tats.amenities_time_slot_id', $filterData['amenities_time_slot_id']);
            } else {
                $builder->where('tats.amenities_time_slot_id', $filterData['amenities_time_slot_id']);
            }
        }


        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }


    public function deleteRecord($voucherId)
    {
        $builder = $this->db->table('tbl_voucher');
        $voucherIdArray = is_array($voucherId) ? $voucherId : array($voucherId);
        $builder->whereIn('voucher_id', $voucherIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($voucherId)){
                foreach($voucherId as $voucher){
                    $deleteDataArray['module'] = 'Voucher';
                    $deleteDataArray['activity'] = "Voucher Deleted";
                    $deleteDataArray['module_id'] = $voucher;
                    logActivity('Voucher Deleted [VoucherID: ' . $voucher . ']',$this->ionAuth->getUserId(),'Voucher',$voucher,json_encode($deleteDataArray),'','Voucher',$voucher);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getVoucher($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        // $builder->start_cache();
        $builder = $this->db->table('tbl_amenities as ta');
        $builder->select("ta.amenities_id as id,ta.amenities_name as text");
        
        $builder->where("ta.is_active", 1);

        // if(isset($filterData['type']) && !empty($filterData['type'])) {
        //     if (is_array($filterData['type'])) {
        //         $builder->whereIn('ta.type', $filterData['type']);
        //     } else {
        //         $builder->where('ta.type', $filterData['type']);
        //     }
        // }
        
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("ta.amenities_name", $filterData['filter_param'], 'both');
            $builder->groupEnd();
        }
        accessFilter($builder, array("society" => "ta.society_id"));
        // $this->db->stop_cache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        // $this->db->flush_cache();
        return json_encode($result);
    }

    function getVoucherUnit($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        // $builder->start_cache();
        $builder = $this->db->table('tbl_amenities_unit as tau');
        $builder->select("tau.amenities_unit_id as id,tau.unit_name as text");
        
        if(isset($filterData['amenities_id']) && !empty($filterData['amenities_id'])) {
            if (is_array($filterData['amenities_id'])) {
                $builder->whereIn('tau.amenities_id', $filterData['amenities_id']);
            } else {
                $builder->where('tau.amenities_id', $filterData['amenities_id']);
            }
        } else {
            $builder->where('tau.amenities_id', '-1');
        }
        
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("tau.unit_name", $filterData['filter_param'], 'both');
            $builder->groupEnd();
        }
        // accessFilter($builder, array("society" => "tts.society_id"));
        // $this->db->stop_cache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        // $this->db->flush_cache();
        return json_encode($result);
    }

    public function getVoucherCommonAreaData($filterData)
    {
        $builder = $this->db->table('tbl_amenities_common_area as tacm');
        $builder->select("tacm.*");
        $builder->select("GROUP_CONCAT(tcm.common_area_name SEPARATOR ',') as common_area_name");
        $builder->join("tbl_common_area as tcm","tcm.common_area_id = tacm.common_area_id","left");

        
        if(isset($filterData['amenities_id']) && !empty($filterData['amenities_id'])) {
            if (is_array($filterData['amenities_id'])) {
                $builder->whereIn('tacm.amenities_id', $filterData['amenities_id']);
            } else {
                $builder->where('tacm.amenities_id', $filterData['amenities_id']);
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();

            $builder->groupEnd();
        }

        $builder->groupBy("tacm.amenities_common_area_id");
        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function deleteCommonAreaRecord($amenitiesId){

        $builder = $this->db->table('tbl_amenities_common_area');
        $amenitiesIdArray = is_array($amenitiesId) ? $amenitiesId : array($amenitiesId);
        $builder->whereIn('amenities_id', $amenitiesIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function getVoucherBookingSlotDayData($filterData)
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_amenities_booking_slot_day as trwd');
		$builder->select("trwd.*,trwd.amenities_booking_slot_day_id,trwd.amenities_id,trwd.amenities_booking_slot_id");
		$builder->join('tbl_amenities tr', 'tr.amenities_id = trwd.amenities_id', 'left');

		if(isset($filterData['amenities_id']) && !empty($filterData['amenities_id'])) {
            if (is_array($filterData['amenities_id'])) {
                $builder->whereIn('trwd.amenities_id', $filterData['amenities_id']);
            } else {
                $builder->where('trwd.amenities_id', $filterData['amenities_id']);
            }
        }
		if(isset($filterData['amenities_flat_id']) && !empty($filterData['amenities_flat_id'])) {
            if (is_array($filterData['amenities_flat_id'])) {
                $builder->whereIn('trwd.amenities_flat_id', $filterData['amenities_flat_id']);
            } else {
                $builder->where('trwd.amenities_flat_id', $filterData['amenities_flat_id']);
            }
        }
		if (isset($filterData['amenities_booking_slot_day_id']) && $filterData['amenities_booking_slot_day_id'] != '') {
			$builder->where("trwd.amenities_booking_slot_day_id", $filterData['amenities_booking_slot_day_id']);
		}

        // if(isset($filterData['is_deleted'])){
        //     $builder->where('trwd.is_deleted', $filterData['is_deleted']);
        // }

		$builder->orderBy("trwd.amenities_id");
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

    public function deleteVoucherBookingSlotDay($amenitiesId)
	{
		$amenitiesIdArray = is_array($amenitiesId) ? $amenitiesId : array($amenitiesId);
		$builder = $this->db->table('tbl_amenities_booking_slot_day');
		$builder->whereIn('amenities_id', $amenitiesIdArray);
		$builder->delete();
		if ($this->db->affectedRows()) {
			return true;
		}
		return false;
	}

    public function deleteVoucherBookingSlotDayRecord($amenitiesBookingSlotId)
	{
		$builder = $this->db->table('tbl_amenities_booking_slot_day');
		$amenitiesBookingSlotIdArray = is_array($amenitiesBookingSlotId) ? $amenitiesBookingSlotId : array($amenitiesBookingSlotId);	
		$builder->whereIn('amenities_booking_slot_id',$amenitiesBookingSlotIdArray);
		$builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}
    public function deleteVoucherBookingSlotUnitPriceRecord($amenitiesBookingSlotId,$userId)
	{
		$builder = $this->db->table('tbl_amenities_booking_slot_unit_price');
		$amenitiesBookingSlotIdArray = is_array($amenitiesBookingSlotId) ? $amenitiesBookingSlotId : array($amenitiesBookingSlotId);
        $updateData = [
            'is_deleted' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
            // 'updated_by' => $this->data['userId']
            'updated_by' => $userId
        ];
        $builder->whereIn('amenities_booking_slot_id',$amenitiesBookingSlotIdArray);
        $builder->update($updateData);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}
}