<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class VisitorModel extends BaseModel
{

	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getVisitorData($filterData = array())
	{
		$type = isset($filterData['type']) ? $filterData['type'] : '';
		$ownershipFlatMemberId = isset($filterData['ownership_flat_member_id']) ? $filterData['ownership_flat_member_id'] : '';
		$ownershipFlatId = isset($filterData['ownership_flat_id']) ? $filterData['ownership_flat_id'] : '';
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_visitor as tv');
        $builder->select("tv.*,COALESCE(tm.name,'') as name,COALESCE(tus.phone,'') as member_number,COALESCE(tofp.vehicle_no,'') as owner_vehicle_no,COALESCE(tofp.parking_slot_no,'') as parking_slot_no,COALESCE(tofp.token_no,'') as token_no,tm.member_image");
        $builder->select("CONCAT(COALESCE(tt.tower_name,''),' - ',COALESCE(tf.flat_no,'')) as tower_flat_name,tc.visitor_company_name,tc.visitor_company_image");
        $builder->select("CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,'')) as number");
        $builder->select("tus.phone as member_mobile_no");
        $builder->select("CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,'')) as parking_block_display");
        $builder->select("COALESCE(trname.resource_name,'') as updated_by_name,tr.resource_type_id,trt.resource_type_name,tr.resource_name");

        $builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tv.ownership_flat_member_id","left");
        $builder->join("tbl_ownership_flat_parking as tofp","tofp.ownership_flat_parking_id = tv.ownership_flat_parking_id","left");
        $builder->join("tbl_parking_slot as tpp","tpp.parking_slot_id = tv.parking_slot_id","left");
        $builder->join("tbl_parking_area as ta","ta.parking_area_id = tpp.parking_area_id","left");
        $builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");

		$builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tv.ownership_flat_id","left");
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.member_id AND tus.resource_type_id = tofm.resource_type_id AND tus.society_id = tof.society_id","left");
        $builder->join("tbl_flat as tf","tf.flat_id = tof.flat_id","left");
        $builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
        $builder->join("tbl_visitor_company as tc","tc.visitor_company_id = tv.visitor_company_id","left");
        $builder->join("tbl_resource as tr","tr.resource_id = tv.resource_id","left");
        $builder->join("tbl_resource_type as trt","trt.resource_type_id = tv.resource_type_id","left");
        // $builder->join("tbl_category as tcat","tcat.category_id = tr.category_id","left");
       	$builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tv.updated_by AND tupdate.society_id = tv.society_id","left");
       	$builder->join(MASTER_DB.".tbl_user_society as tusname","tusname.user_society_id = tv.updated_by","left");
       	$builder->join("tbl_resource as trname","trname.resource_id = tusname.type_id","left");
		if (isset($filterData['visitor_id']) && !empty($filterData['visitor_id'])) {
			if (is_array($filterData['visitor_id'])) {
				$builder->whereIn('tv.visitor_id', $filterData['visitor_id']);
			} else {
				$builder->where('tv.visitor_id', $filterData['visitor_id']);
			}
		}

		if (isset($filterData['is_today_date']) && !empty($filterData['is_today_date'])) {
			$builder->where('DATE(tv.created_at) = ', TODAY_DATE_YMD);
		}

		if (isset($filterData['show_entered_not_exited']) && !empty($filterData['show_entered_not_exited'])) {
			$builder->groupStart();
			$builder->where('tv.status', 'entered');
			$builder->orGroupStart();
			$builder->where('DATE(tv.expected_end_date_time) >= ', TODAY_DATE_YMD);
			$builder->groupEnd();
			$builder->groupEnd();
		}

		if (isset($filterData['resource_type_id']) && !empty($filterData['resource_type_id'])) {
			if (is_array($filterData['resource_type_id'])) {
				$builder->whereIn('tr.resource_type_id', $filterData['resource_type_id']);
			} else {
				$builder->where('tr.resource_type_id', $filterData['resource_type_id']);
			}
		}
		if (isset($filterData['resource_id']) && !empty($filterData['resource_id'])) {
			if (is_array($filterData['resource_id'])) {
				$builder->whereIn('tv.resource_id', $filterData['resource_id']);
			} else {
				$builder->where('tv.resource_id', $filterData['resource_id']);
			}
		}
		if (isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tv.type', $filterData['type']);
			} else {
				$builder->where('tv.type', $filterData['type']);
			}
		}
		if (isset($filterData['visitor_duration']) && !empty($filterData['visitor_duration'])) {
			if (is_array($filterData['visitor_duration'])) {
				$builder->whereIn('tv.visitor_duration', $filterData['visitor_duration']);
			} else {
				$builder->where('tv.visitor_duration', $filterData['visitor_duration']);
			}
		}
		if (isset($filterData['visitor_mobile_no']) && !empty($filterData['visitor_mobile_no'])) {
			if (is_array($filterData['visitor_mobile_no'])) {
				$builder->whereIn('tv.visitor_mobile_no', $filterData['visitor_mobile_no']);
			} else {
				$builder->where('tv.visitor_mobile_no', $filterData['visitor_mobile_no']);
			}
		}

		// if($type != 'resource') {
		// 	if (isset($filterData['user_id']) && !empty($filterData['user_id'])) {
		// 		if (is_array($filterData['user_id'])) {
		// 			$builder->whereIn('tv.created_by', $filterData['user_id']);
		// 		} else {
		// 			$builder->where('tv.created_by', $filterData['user_id']);
		// 		}
		// 	}
		// }

		if(isset($filterData['start_date']) && $filterData['start_date'] != $filterData['end_date']){
			if (isset($filterData['start_date']) && !empty($filterData['start_date'])) {
				if (is_array($filterData['start_date'])) {
					$builder->whereIn('DATE(tv.start_date)  >=', $filterData['start_date']);
				} else {
					$builder->where('DATE(tv.start_date)  >=', $filterData['start_date']);
					$builder->where('DATE(tv.end_date)  <=', $filterData['end_date']);
				}
			}
		}

		if(isset($filterData['start_date']) && $filterData['start_date'] == $filterData['end_date']){
			if (isset($filterData['start_date']) && !empty($filterData['start_date'])) {
				if (is_array($filterData['start_date'])) {
					$builder->whereIn('DATE(tv.start_date)', $filterData['start_date']);
				} else {
					$builder->where('DATE(tv.start_date)', $filterData['start_date']);
				}
			}
		}

		if (isset($filterData['expected_date']) && !empty($filterData['expected_date'])) {
			if (is_array($filterData['expected_date'])) {
				$builder->whereIn('DATE(tv.expected_start_date_time)  >= ', $filterData['expected_date']);
			} else {
				$builder->where('DATE(tv.expected_start_date_time)  >= ', $filterData['expected_date']);
			}
		}

		if (isset($filterData['today_date']) && !empty($filterData['today_date'])) {
			$builder->where("date_format(tv.expected_start_date_time,'" . DATE_FORMATE_MYSQL_YMD . "') <= ", $filterData['today_date']);
			$builder->where("date_format(tv.expected_end_date_time,'" . DATE_FORMATE_MYSQL_YMD . "') >= ", $filterData['today_date']);
		}		

		if (isset($filterData['qr_code_number']) && !empty($filterData['qr_code_number'])) {
			if (is_array($filterData['qr_code_number'])) {
				$builder->whereIn('tv.qr_code_number', $filterData['qr_code_number']);
			} else {
				$builder->where('tv.qr_code_number', $filterData['qr_code_number']);
			}
			$builder->where('tv.qr_code_number !=', 0);
		}

		if (isset($filterData['status']) && !empty($filterData['status'])) {
			if (is_array($filterData['status'])) {
				$builder->whereIn('tv.status', $filterData['status']);
			} else {
				$builder->where('tv.status', $filterData['status']);
			}
		}

		if (isset($filterData['parking_slot_id']) && !empty($filterData['parking_slot_id'])) {
			if (is_array($filterData['parking_slot_id'])) {
				$builder->whereIn('tv.parking_slot_id', $filterData['parking_slot_id']);
			} else {
				$builder->where('tv.parking_slot_id', $filterData['parking_slot_id']);
			}
		}

		if(empty($type)){
			$builder->join("tbl_resource_flat as trf","trf.resource_id = tr.resource_id","left");
			if (isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
				if (is_array($filterData['ownership_flat_member_id'])) {
					$builder->groupStart();
					$builder->whereIn('trf.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
					$builder->orWhereIn('trf.ownership_flat_id', isset($ownershipFlatId) ? $ownershipFlatId : 0);
					$builder->groupEnd();
					
				} else {
					$builder->groupStart();
					$builder->where('trf.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
					$builder->orwhere('trf.ownership_flat_id', isset($ownershipFlatId) ? $ownershipFlatId : 0);
					$builder->orWhere('tv.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
					$builder->groupEnd();
				}
			}
		}
		else{
			if($type != 'resource') {
				if (isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
					if (is_array($filterData['ownership_flat_member_id'])) {
						$builder->whereIn('tv.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
					} else {
						$builder->where('tv.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
					}
				}
			}

			if($type == 'resource') {
				$builder->join("tbl_resource_flat as trf","trf.resource_id = tr.resource_id","left");
				if (isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
					if (is_array($filterData['ownership_flat_member_id'])) {
						$builder->whereIn('trf.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
						$builder->orWhereIn('trf.ownership_flat_id', $filterData['ownership_flat_id']);
					} else {
						$builder->where('trf.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
						$builder->orWhere('trf.ownership_flat_id', $filterData['ownership_flat_id']);
					}
				}
			}
		}

		if (isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tv.type', $filterData['type']);
			} else {
				$builder->where('tv.type', $filterData['type']);
			}
		}
		if (isset($filterData['filtered_type']) && !empty($filterData['filtered_type']) && $filterData['filtered_type'] == 'visitor') {
			$builder->where("tv.resource_id",0);
		}
		if (isset($filterData['filtered_type']) && !empty($filterData['filtered_type']) && $filterData['filtered_type'] == 'resource') {
			$builder->where("tv.resource_id !=",0);
		}
		if(!isset($filterData['is_deleted_not'])){	
			$builder->where('tv.is_deleted', 0);
		}
		if(isset($filterData['collect_on_gate'])){
			$builder->where('tv.collect_on_gate', $filterData['collect_on_gate']);
		}
		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tv.society_id', $filterData['society_id']);
			} else {
				$builder->where('tv.society_id', $filterData['society_id']);
			}
		}
		if (isset($filterData['resource_id']) && !empty($filterData['resource_id'])) {
			if (is_array($filterData['resource_id'])) {
				$builder->whereIn('tv.resource_id', $filterData['resource_id']);
			} else {
				$builder->where('tv.resource_id', $filterData['resource_id']);
			}
		}
		if (isset($filterData['date_greater_than_equal_to']) && !empty($filterData['date_greater_than_equal_to'])) {
			if (is_array($filterData['date_greater_than_equal_to'])) {
				$builder->whereIn('DATE(tv.created_at) = ', $filterData['date_greater_than_equal_to']);
			} else {
				$builder->where('DATE(tv.created_at) = ', $filterData['date_greater_than_equal_to']);
			}
		}

		if (isset($filterData['order_by']) && !empty($filterData['order_by'])) {
			if (is_array($filterData['order_by'])) {
				foreach ($filterData['order_by'] as $key => $value) {
					foreach ($value as $orderKey => $orderValue) {
						$builder->orderBy($orderKey,$orderValue);
					}
				}
			}
		}

		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('tv.visitor_name', $filterData['search'], 'both');
			$builder->orLike('tv.type', $filterData['search'], 'both');
			$builder->orLike('tv.visitor_mobile_no', $filterData['search'], 'both');
			$builder->orLike("COALESCE(tm.name,'')", $filterData['search'], 'both');
			$builder->orLike("CONCAT(COALESCE(tt.tower_name,''),' - ',COALESCE(tf.flat_no,''))", $filterData['search'], 'both');
			$builder->groupEnd();
		}
		$builder->orderBy("tv.visitor_id",'desc');
		$builder->groupBy('tv.visitor_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}

		// lastQuery();
		return $queryData;
	}

	public function getVisitorCountData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$todayDate = isset($filterData['date_greater_than_equal_to']) ? $filterData['date_greater_than_equal_to'] : date('Y-m-d');
		$societyId = isset($filterData['society_id']) ? $filterData['society_id'] : 0;
	    $builder = $this->db->table('tbl_visitor as tv');
	    $builder->select("(SELECT COUNT(*) FROM tbl_visitor WHERE status = 'entered' AND is_deleted = 0 AND DATE(created_at) = '$todayDate' AND society_id = '". $societyId ."') AS visitor_entered");
	    $builder->select("(SELECT COUNT(*) FROM tbl_visitor WHERE status = 'exited' AND is_deleted = 0 AND DATE(created_at) = '$todayDate' AND society_id = '". $societyId ."') AS visitor_exited");
	    $builder->groupBy('tv.visitor_id');

	    if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tv.society_id', $filterData['society_id']);
			} else {
				$builder->where('tv.society_id', $filterData['society_id']);
			}
		}

		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function getVisitorResourceAttendanceData($filterData = array())
	{
		
		$limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_visitor as tv');
     	$builder->select('tv.resource_id, COUNT(*) as total_count,tv.created_at');
		if (isset($filterData['resource_id']) && !empty($filterData['resource_id'])) {
			if (is_array($filterData['resource_id'])) {
				$builder->whereIn('tv.resource_id', $filterData['resource_id']);
			} else {
				$builder->where('tv.resource_id', $filterData['resource_id']);
			}
		}
		if(isset($filterData['is_deleted'])){
			$builder->where('tv.is_deleted', $filterData['is_deleted']);
		}
		
		$builder->groupBy('tv.resource_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteRecord($visitorId)
	{
        $builder = $this->db->table('tbl_visitor');
        $builder->whereIn('visitor_id', $visitorId);
		$ids = is_array($visitorId) ? implode(',',$visitorId) : $visitorId;
		$builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($visitorId)){
				foreach($visitorId as $visitor){
					$deleteDataArray['module'] = 'Visitor';
            		$deleteDataArray['activity'] = "Visitor Deleted";
					$deleteDataArray['module_id'] = $visitor;
					logActivity('Visitor Deleted [VisitorID: ' . $visitor . ']',$this->ionAuth->getUserId(),'Visitor',$visitor,json_encode($deleteDataArray),'','Visitor',$visitor);
				}
			}
			$response['success'] = true;
			return $response;
		}
		$response['success'] = false;
		return $response;
	}

	public function getDocumentImageData($filterData)
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_document_image as tdi');
		$builder->select("tdi.document_image_id, tdi.document_image,tdi.document_type_id,tdi.document_type");
		if(isset($filterData['document_type_id']) && !empty($filterData['document_type_id'])) {
            if (is_array($filterData['document_type_id'])) {
                $builder->whereIn('tdi.document_type_id', $filterData['document_type_id']);
            } else {
                $builder->where('tdi.document_type_id', $filterData['document_type_id']);
            }
        }

        if(isset($filterData['document_type']) && !empty($filterData['document_type'])) {
            if (is_array($filterData['document_type'])) {
                $builder->whereIn('tdi.document_type', $filterData['document_type']);
            } else {
                $builder->where('tdi.document_type', $filterData['document_type']);
            }
        }
        if(isset($filterData['document_image_id']) && !empty($filterData['document_image_id'])) {
            if (is_array($filterData['document_image_id'])) {
                $builder->whereIn('tdi.document_image_id', $filterData['document_image_id']);
            } else {
                $builder->where('tdi.document_image_id', $filterData['document_image_id']);
            }
        }
		
		$builder->orderBy("tdi.document_image_id","desc");
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function deleteDocumentImage($documentImageId,$documentType,$documentTypeId = 0)
    {
        $builder = $this->db->table('tbl_document_image');
        $documentImageIdArray = is_array($documentImageId) ? $documentImageId : array($documentImageId);

        $ids = is_array($documentImageId) ? implode(',',$documentImageId) : $documentImageId;
        $builder->whereIn('document_image_id',$documentImageIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {

            $deleteDataArray['document_type'] = underscoreToUcWord($documentType).' Document Image';
            $deleteDataArray['activity'] = underscoreToUcWord($documentType)." Document Image Deleted";
            $deleteDataArray['document_type_id'] = $documentImageId;

            logActivity(underscoreToUcWord($documentType).' Document Image Deleted ['.underscoreToUcWord($documentType).'ID: ' . $ids . ']',$this->ionAuth->getUserId(),underscoreToUcWord($documentType).' Document Image',$ids,json_encode($deleteDataArray),'',underscoreToUcWord($documentType),$documentTypeId );
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

	public function getVisitorWorkingDayData($filterData)
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_visitor_working_day as tvwd');
		$builder->select("tvwd.visitor_working_day_id, tvwd.working_day_id, tvwd.working_day_name,tvwd.visitor_id");
		$builder->join('tbl_visitor tv', 'tv.visitor_id = tvwd.visitor_id', 'left');
		if(isset($filterData['visitor_id']) && !empty($filterData['visitor_id'])) {
            if (is_array($filterData['visitor_id'])) {
                $builder->whereIn('tvwd.visitor_id', $filterData['visitor_id']);
            } else {
                $builder->where('tvwd.visitor_id', $filterData['visitor_id']);
            }
        }
		if (isset($filterData['visitor_working_day_id']) && $filterData['visitor_working_day_id'] != '') {
			$builder->where("tvwd.visitor_working_day_id", $filterData['visitor_working_day_id']);
		}
		if (isset($filterData['working_day_name']) && $filterData['working_day_name'] != '') {
			$builder->where("tvwd.working_day_name", $filterData['working_day_name']);
		}
		$builder->orderBy("tvwd.visitor_id");
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function deleteRecordWorkingDay($visitorId,$userId = 0,$societyId = 0)
	{
		$visitorIdArray = is_array($visitorId) ? $visitorId : array($visitorId);
		$builder = $this->db->table('tbl_visitor_working_day');
        $builder->whereIn('visitor_id', $visitorIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($visitorId)){
				$deleteDataArray['module'] = 'Visitor Working Day';
				$deleteDataArray['activity'] = "Visitor Working Day Deleted";
				$deleteDataArray['module_id'] = $visitorId;
				$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
				logActivity('Visitor Working Day Deleted [VisitorID: ' . $visitorId . ']',$userId,'Visitor Working Day',$visitorId,json_encode($deleteDataArray),'','Visitor',$visitorId,$societyId);
			}
			return true;
		}
		return false;
	}

	public function deleteRecordDocumentImage($documentTypeId,$documentType,$userId = 0,$societyId = 0)
	{	
		$documentTypeIdArray = is_array($documentTypeId) ? $documentTypeId : array($documentTypeId);
		foreach ($documentTypeIdArray as $documentTypeIds){
			$getDocumentImageData = $this->getDocumentImageData(array("document_type_id" => $documentTypeIds,'document_type' => $documentType));
			$fileUrl = '';
			$thumbnailFileUrl = '';
			if(!empty($getDocumentImageData)){
				if($getDocumentImageData['document_image'] != '') {
					$fileUrl = DOCUMENT_IMAGE_PATH . $getDocumentImageData['document_image'];
					$thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $getDocumentImageData['document_image'];
				}
				if (file_exists($thumbnailFileUrl)) {
					unlink($thumbnailFileUrl);
				}
				if (file_exists($fileUrl)) {
					unlink($fileUrl);
				}
			}
			
		}
		$builder = $this->db->table('tbl_document_image');
		 $builder->Where('document_type', $documentType);
        $builder->whereIn('document_type_id', $documentTypeIdArray);
       
        $builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($documentTypeId)){
				$deleteDataArray['module'] = 'Document Image';
				$deleteDataArray['activity'] = "Document Image Deleted";
				$deleteDataArray['module_id'] = $documentTypeId;
				$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
				logActivity('Document Image Deleted [DocumentID: ' . $documentTypeId . ']',$userId,'Document Image',$documentTypeId,json_encode($deleteDataArray),'','Document',$documentTypeId,$societyId);
			}
			return true;
		}
		return false;
	}

	public function deleteVisitorRecord($filterData  = array())
    {
        $visitorId = isset($filterData['visitor_id']) ? $filterData['visitor_id'] : array();
        $userId = isset($filterData['user_id']) ? $filterData['user_id'] : 0;
        $builder = $this->db->table('tbl_visitor');
        $data = [
            'is_deleted' => 1,
            'updated_at'  => date("Y-m-d H:i:s"),
            'updated_by'  => $userId,
        ];

        $builder->where('visitor_id', $visitorId);
        $builder->update($data);

        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        }
        $response['success'] = false;
        return $response;
    }

    
}
?>
