<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class TagAssignModel extends BaseModel
{

    public function getTagAssignData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_tag_assign as tta');
        $builder->select("tta.*,tt.tag_no");
        $builder->select("concat(COALESCE(tto.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join("tbl_flat as tf","tf.flat_id = tta.flat_id","left");
        $builder->join("tbl_tag as tt","tt.tag_id = tta.tag_id","left");
        $builder->join("tbl_tower as tto","tto.tower_id = tf.tower_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tta.updated_by AND tupdate.society_id = tta.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tta.created_by AND tcreate.society_id = tta.society_id","left");

        if (isset($filterData['tag_assign_id']) && !empty($filterData['tag_assign_id'])) {
            if (is_array($filterData['tag_assign_id'])) {
                $builder->whereIn('tta.tag_assign_id', $filterData['tag_assign_id']);
            } else {
                $builder->where('tta.tag_assign_id', $filterData['tag_assign_id']);
            }
        }

        if (isset($filterData['tag_id']) && !empty($filterData['tag_id'])) {
            if (is_array($filterData['tag_id'])) {
                $builder->whereIn('tta.tag_id', $filterData['tag_id']);
            } else {
                $builder->where('tta.tag_id', $filterData['tag_id']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tta.society_id', $filterData['society_id']);
            } else {
                $builder->where('tta.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
            if (is_array($filterData['flat_id'])) {
                $builder->whereIn('tta.flat_id', $filterData['flat_id']);
            } else {
                $builder->where('tta.flat_id', $filterData['flat_id']);
            }
        }

        if (isset($filterData['tag_assign_id_not']) && !empty($filterData['tag_assign_id_not'])) {
            if (is_array($filterData['tag_assign_id_not'])) {
                $builder->whereNotIn('tta.tag_assign_id', $filterData['tag_assign_id_not']);
            } else {
                $builder->where('tta.tag_assign_id !=', $filterData['tag_assign_id_not']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if (isset($filterData['search']) && $filterData['search'] != '') {
            $builder->groupStart();
            $builder->like('tag_no', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tta.tag_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($tagAssignId)
    {
        $builder = $this->db->table('tbl_tag_assign');
        $tagAssignIdArray = is_array($tagAssignId) ? $tagAssignId : array($tagAssignId);
        $builder->whereIn('tag_assign_id', $tagAssignIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($tagAssignId)){
                foreach($tagAssignId as $tagAssign){
                    $deleteDataArray['module'] = 'Tag Assign';
                    $deleteDataArray['activity'] = "Tag Assign Deleted";
                    $deleteDataArray['module_id'] = $tagAssign;
                    logActivity('Tag Assign Deleted [TagAssignID: ' . $tagAssign . ']',$this->ionAuth->getUserId(),'Tag Assign',$tagAssign,json_encode($deleteDataArray),'','Tag Assign',$tagAssign);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getTagAssign($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_tag_assign as tta');
        //$builder->startCache();
        $builder->select("tta.tag_assign_id as id,tt.tag_no as text");
        $builder->join("tbl_tag as tt","tt.tag_id = tta.tag_id","left");

        if (isset($filterData['tag_assign_id']) && !empty($filterData['tag_assign_id'])) {
            if (is_array($filterData['tag_assign_id'])) {
                $builder->whereIn('tta.tag_assign_id', $filterData['tag_assign_id']);
            } else {
                $builder->where('tta.tag_assign_id', $filterData['tag_assign_id']);
            }
        }

        accessFilter($builder, array("society" => "tta.society_id"));
        $builder->groupBy("tta.tag_assign_id");
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("tt.tag_no", $filterData['filter_param'], 'both');
            $builder->groupEnd();
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}