<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class SocietyModel extends BaseModel
{

    public function getSocietyData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table(MASTER_DB.'.tbl_society as ts');
        $builder->select('ts.*');
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ts.updated_by AND tupdate.society_id = ts.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = ts.created_by AND tcreate.society_id = ts.society_id","left");

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('ts.society_id', $filterData['society_id']);
            } else {
                $builder->where('ts.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['society_name']) && !empty($filterData['society_name'])) {
            if (is_array($filterData['society_name'])) {
                $builder->whereIn('ts.society_name', $filterData['society_name']);
            } else {
                $builder->where('ts.society_name', $filterData['society_name']);
            }
        }

        if(isset($filterData['society_id_not']) && !empty($filterData['society_id_not'])) {
            if (is_array($filterData['society_id_not'])) {
                $builder->whereNotIn('ts.society_id', $filterData['society_id_not']);
            } else {
                $builder->where('ts.society_id !=', $filterData['society_id_not']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('ts.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('society_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('ts.society_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getSocietyImageData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table(MASTER_DB.'.tbl_society_image as tmi');
        $builder->select("tmi.society_image_id, tmi.society_image,tmi.society_id");
        $builder->join(MASTER_DB.'.tbl_society tm', 'tm.society_id = tmi.society_id', 'left');

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tmi.society_id', $filterData['society_id']);
            } else {
                $builder->where('tmi.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['society_image_id']) && $filterData['society_image_id'] != '') {
            $builder->where("tmi.society_image_id", $filterData['society_image_id']);
        }

        if (isset($filterData['is_order_by_society_id']) ) {
            $builder->orderBy("tmi.society_image_id","DESC");
        } else {
            $builder->orderBy("tmi.society_id");
        }



        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
//lastQuery();
        return $query;
    }


    public function deleteRecord($societyId)
    {
        $societyIdArray = is_array($societyId) ? $societyId : array($societyId);

        $builder = $this->db->table('tbl_society_image');
        $builder->whereIn('society_id', $societyIdArray);
        $builder->delete();

        $builder = $this->db->table('tbl_society');
        $builder->whereIn('society_id', $societyIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($societyId)){
                foreach($societyId as $society){
                    $deleteDataArray['module'] = 'Society';
                    $deleteDataArray['activity'] = "Society Deleted";
                    $deleteDataArray['module_id'] = $society;
                    logActivity('Society Deleted [SocietyID: ' . $society . ']',$this->ionAuth->getUserId(),'Society',$society,json_encode($deleteDataArray),'','Society',$society);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getSociety($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_society as ts');
        //$builder->startCache();
        $builder->select("ts.society_id as id,COALESCE(ts.society_name,'') as text");

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('ts.society_id', $filterData['society_id']);
            } else {
                $builder->where('ts.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(ts.society_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('ts.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function deleteSocietyImage($societyImageId)
    {
        $builder = $this->db->table('tbl_society_image');
        $societyImageIdArray = is_array($societyImageId) ? $societyImageId : array($societyImageId);
        $builder->whereIn('society_image_id', $societyImageIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}