<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class SettingModel extends BaseModel
{

	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getSettingData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_setting as ts');
        $builder->select("ts.*");
		if (isset($filterData['setting_id']) && !empty($filterData['setting_id'])) {
			if (is_array($filterData['setting_id'])) {
				$builder->whereIn('ts.setting_id', $filterData['setting_id']);
			} else {
				$builder->where('ts.setting_id', $filterData['setting_id']);
			}
		}
		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('ts.society_id', $filterData['society_id']);
			} else {
				$builder->where('ts.society_id', $filterData['society_id']);
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('inquiry_email', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		$builder->orderBy("ts.setting_id",'desc');
		$builder->groupBy('ts.setting_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}
}
?>
