<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ResourceTypeModel extends BaseModel
{
	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}

    public function updateUserGroupId($filterData = array())
    {
        // Use the constant
        $sql = "UPDATE " . MASTER_DB . ".tbl_users_groups AS tug
        LEFT JOIN " . MASTER_DB . ".tbl_users AS tu
        ON tu.slug = tug.slug
        SET tug.user_id = tu.id
        WHERE tug.slug IS NOT NULL AND tug.slug != ''";

        // Run the query
        $this->db->query($sql);
    }

    public function updateUserSocietyId($filterData = array())
    {
        // SQL query
        $sql = " UPDATE  " . MASTER_DB . ".tbl_user_society AS tus
            LEFT JOIN  " . MASTER_DB . ".tbl_users AS tu
            ON tu.slug = tus.slug
            SET tus.user_id = tu.id
            WHERE tus.slug IS NOT NULL AND tus.slug != ''";

        // Run the query
        $this->db->query($sql);
    }

    public function updateUserPermissionId($filterData = array())
    {
        // SQL query
        $sql = " UPDATE  " . MASTER_DB . ".tbl_user_permission AS tup
            LEFT JOIN  " . MASTER_DB . ".tbl_users AS tu
            ON tu.slug = tup.slug
            SET tup.user_id = tu.id
            WHERE tup.slug IS NOT NULL AND tup.slug != ''";

        // Run the query
        $this->db->query($sql);
    }

    public function updateUserPermissionSocietyId($filterData = array())
    {
        // SQL query
        $sql = " UPDATE  " . MASTER_DB . ".tbl_user_permission AS tup
            LEFT JOIN  " . MASTER_DB . ".tbl_user_society AS tus
            ON tus.society_slug = tup.society_slug
            SET tup.user_society_id = tus.user_society_id
            WHERE tup.society_slug IS NOT NULL AND tup.society_slug != ''";

        // Run the query
        $this->db->query($sql);
    }

    public function updateUserSocietyGroupId($filterData = array())
    {
        // SQL query
        $sql = " UPDATE  " . MASTER_DB . ".tbl_users_groups AS tug
            LEFT JOIN  " . MASTER_DB . ".tbl_user_society AS tus
            ON tus.society_slug = tug.society_slug
            SET tug.user_society_id = tus.user_society_id
            WHERE tug.society_slug IS NOT NULL AND tug.society_slug != ''";
        // Run the query
        $this->db->query($sql);
    }


	public function getResourceTypeData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_resource_type as trt');
        $builder->select("trt.*");
        
        if(isset($filterData['resource_type_id']) && !empty($filterData['resource_type_id'])) {
            if (is_array($filterData['resource_type_id'])) {
                $builder->whereIn('trt.resource_type_id', $filterData['resource_type_id']);
            } else {
                $builder->where('trt.resource_type_id', $filterData['resource_type_id']);
            }
        }

        if(isset($filterData['resource_type_name']) && !empty($filterData['resource_type_name'])) {
            if (is_array($filterData['resource_type_name'])) {
                $builder->whereIn('trt.resource_type_name', $filterData['resource_type_name']);
            } else {
                $builder->where('trt.resource_type_name', $filterData['resource_type_name']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('trt.society_id', $filterData['society_id']);
            } else {
                $builder->where('trt.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('trt.is_active', $filterData['is_active']);
        }

        if(isset($filterData['is_guard'])){
            $builder->where('trt.is_guard', $filterData['is_guard']);
        }

        if(isset($filterData['is_login'])){
            $builder->where('trt.is_login', $filterData['is_login']);
        }

        if(isset($filterData['is_helper'])){
            $builder->where('trt.is_helper', $filterData['is_helper']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('resource_type_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }
        $builder->groupBy('trt.resource_type_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getResourceTypeViewData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table(MASTER_DB.'.society_resource_type_view as trtv');
        $builder->select("trtv.*");
        
        if(isset($filterData['resource_type_id']) && !empty($filterData['resource_type_id'])) {
            if (is_array($filterData['resource_type_id'])) {
                $builder->whereIn('trtv.resource_type_id', $filterData['resource_type_id']);
            } else {
                $builder->where('trtv.resource_type_id', $filterData['resource_type_id']);
            }
        }

        if(isset($filterData['resource_type_name']) && !empty($filterData['resource_type_name'])) {
            if (is_array($filterData['resource_type_name'])) {
                $builder->whereIn('trtv.resource_type_name', $filterData['resource_type_name']);
            } else {
                $builder->where('trtv.resource_type_name', $filterData['resource_type_name']);
            }
        }

        if(isset($filterData['resource_type_name_not']) && !empty($filterData['resource_type_name_not'])) {
            if (is_array($filterData['resource_type_name_not'])) {
                $builder->whereNotIn('trtv.resource_type_name', $filterData['resource_type_name_not']);
            } else {
                $builder->where('trtv.resource_type_name !=', $filterData['resource_type_name_not']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('trtv.society_id', $filterData['society_id']);
            } else {
                $builder->where('trtv.society_id', $filterData['society_id']);
            }
        }
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
	

	public function deleteRecord($resourceTypeId)
    {
        $builder = $this->db->table('tbl_resource_type');
        $resourceTypeIdArray = is_array($resourceTypeId) ? $resourceTypeId : array($resourceTypeId);
        $builder->whereIn('resource_type_id', $resourceTypeIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($resourceTypeId)){
                foreach($resourceTypeId as $resourceType){
                    $deleteDataArray['module'] = 'Resource Type';
                    $deleteDataArray['activity'] = "Resource Type Deleted";
                    $deleteDataArray['module_id'] = $resourceType;
                    logActivity('Resource Type Deleted [ResourceTypeID: ' . $resourceType . ']',$this->ionAuth->getUserId(),'Resource Type',$resourceType,json_encode($deleteDataArray),'','Resource Type',$resourceType);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

	function getResourceType($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_resource_type as trt');
        //$builder->startCache();
        $builder->select("trt.resource_type_id as id,COALESCE(trt.resource_type_name,'') as text,trt.society_id,ts.society_name,trt.is_login,trt.group_id, trt.is_guard");
        $builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = trt.society_id","left");
        $builder->where("trt.is_show",0);
        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('trt.society_id', $filterData['society_id']);
            } else {
                $builder->where('trt.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['resource_type_id']) && !empty($filterData['resource_type_id'])) {
            if (is_array($filterData['resource_type_id'])) {
                $builder->whereIn('trt.resource_type_id', $filterData['resource_type_id']);
            } else {
                $builder->where('trt.resource_type_id', $filterData['resource_type_id']);
            }
        }
        accessFilter($builder, array("society" => "trt.society_id"));
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(trt.resource_type_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('trt.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}
?>
