<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class PollModel extends BaseModel
{

	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getPollData($filterData = array())
	{
		$limit = DATA_LIMIT;

		$builder = $this->db->table('tbl_poll as tp');
        $builder->select("tp.*");

        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");

        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tp.updated_by AND tupdate.society_id = tp.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tp.created_by AND tcreate.society_id = tp.society_id","left");

		if (isset($filterData['poll_id']) && !empty($filterData['poll_id'])) {
			if (is_array($filterData['poll_id'])) {
				$builder->whereIn('tp.poll_id', $filterData['poll_id']);
			} else {
				$builder->where('tp.poll_id', $filterData['poll_id']);
			}
		}
		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tp.society_id', $filterData['society_id']);
			} else {
				$builder->where('tp.society_id', $filterData['society_id']);
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('tp.poll_title', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		$builder->orderBy("tp.poll_id",'desc');
		$builder->groupBy('tp.poll_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function getPollOptionData($filterData = array())
	{
		$userId = isset($filterData['ownership_flat_member_id']) ? $filterData['ownership_flat_member_id'] : 0;
		$builder = $this->db->table('tbl_poll_option as tpo');
        $builder->select("tpo.*");
        $builder->select("(SELECT count(*) FROM tbl_poll_votes as tpv WHERE tpv.poll_option_id = tpo.poll_option_id AND tpv.poll_id = tpo.poll_id AND tpv.ownership_flat_member_id = '". $userId ."') as is_votes");
        $builder->select("(SELECT count(*) FROM tbl_poll_votes as tpv WHERE tpv.poll_option_id = tpo.poll_option_id AND tpv.poll_id = tpo.poll_id) as total_votes");
		if (isset($filterData['poll_id']) && !empty($filterData['poll_id'])) {
			if (is_array($filterData['poll_id'])) {
				$builder->whereIn('tpo.poll_id', $filterData['poll_id']);
			} else {
				$builder->where('tpo.poll_id', $filterData['poll_id']);
			}
		}
		$builder->groupBy(array('tpo.poll_option_id','tpo.poll_id'));
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		// echo $this->db->getLastQuery();
		return $queryData;
	}

	public function getPollVotesData($filterData = array())
	{
		$builder = $this->db->table('tbl_poll_votes as tpv');
        $builder->select("tpv.*");
		if (isset($filterData['poll_votes_id']) && !empty($filterData['poll_votes_id'])) {
			if (is_array($filterData['poll_votes_id'])) {
				$builder->whereIn('tpv.poll_votes_id', $filterData['poll_votes_id']);
			} else {
				$builder->where('tpv.poll_votes_id', $filterData['poll_votes_id']);
			}
		}
		if (isset($filterData['poll_option_id']) && !empty($filterData['poll_option_id'])) {
			if (is_array($filterData['poll_option_id'])) {
				$builder->whereIn('tpv.poll_option_id', $filterData['poll_option_id']);
			} else {
				$builder->where('tpv.poll_option_id', $filterData['poll_option_id']);
			}
		}
		if (isset($filterData['poll_id']) && !empty($filterData['poll_id'])) {
			if (is_array($filterData['poll_id'])) {
				$builder->whereIn('tpv.poll_id', $filterData['poll_id']);
			} else {
				$builder->where('tpv.poll_id', $filterData['poll_id']);
			}
		}
		if (isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
			if (is_array($filterData['ownership_flat_member_id'])) {
				$builder->whereIn('tpv.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			} else {
				$builder->where('tpv.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			}
		}
		$builder->groupBy('tpv.poll_votes_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function getTotalPollVotesData($filterData = array())
    {

        $builder = $this->db->table('tbl_poll_votes as tpv');
        $builder->select("COUNT(tpv.poll_votes_id) AS total_poll_votes");
        if (isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
            if (is_array($filterData['ownership_flat_member_id'])) {
                $builder->whereIn('tpv.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            } else {
                $builder->where('tpv.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            }
        }
        if (isset($filterData['poll_votes_id']) && !empty($filterData['poll_votes_id'])) {
			if (is_array($filterData['poll_votes_id'])) {
				$builder->whereIn('tpv.poll_votes_id', $filterData['poll_votes_id']);
			} else {
				$builder->where('tpv.poll_votes_id', $filterData['poll_votes_id']);
			}
		}
		if (isset($filterData['poll_id']) && !empty($filterData['poll_id'])) {
			if (is_array($filterData['poll_id'])) {
				$builder->whereIn('tpv.poll_id', $filterData['poll_id']);
			} else {
				$builder->where('tpv.poll_id', $filterData['poll_id']);
			}
		}
		if (isset($filterData['poll_option_id']) && !empty($filterData['poll_option_id'])) {
			if (is_array($filterData['poll_option_id'])) {
				$builder->whereIn('tpv.poll_option_id', $filterData['poll_option_id']);
			} else {
				$builder->where('tpv.poll_option_id', $filterData['poll_option_id']);
			}
		}
        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function deletePollVotesRecord($pollVotesId)
    {
        $pollVotesIdArray = is_array($pollVotesId) ? $pollVotesId : array($pollVotesId);
        $builder = $this->db->table('tbl_poll_votes');
        $builder->whereIn('poll_votes_id',$pollVotesIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }


	public function deleteRecord($pollId)
	{
		$pollIdArray = is_array($pollId) ? $pollId : array($pollId);
		$builderVotes = $this->db->table('tbl_poll_votes');
		$builderVotes->whereIn('poll_id', $pollIdArray);
		$builderVotes->delete();

		$builderItem = $this->db->table('tbl_poll_option');
		$builderItem->whereIn('poll_id', $pollIdArray);
		$builderItem->delete();

		$builder = $this->db->table('tbl_poll');
		$builder->whereIn('poll_id', $pollIdArray);
		$builder->delete();

		if ($this->db->affectedRows()) {

			if(!empty($pollId)){
				foreach($pollId as $documentElement){
					$deleteDataArray['module'] = 'Poll';
					$deleteDataArray['activity'] = "Poll Deleted";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('Poll Deleted [PollID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Poll',$documentElement,json_encode($deleteDataArray),'','Poll',$documentElement);
				}
			}
			return true;
		}
		return false;
	}


	public function deletePollOptionRecord($pollOptionId)
	{

		$pollOptionIdArray = is_array($pollOptionId) ? $pollOptionId : array($pollOptionId);
		$builderVotes = $this->db->table('tbl_poll_votes');
		$builderVotes->whereIn('poll_option_id', $pollOptionIdArray);
		$builderVotes->delete();

		$builder = $this->db->table('tbl_poll_option');
		$builder->whereIn('poll_option_id',$pollOptionIdArray);
		$builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}

	function getPoll($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }
        $builder = $this->db->table('tbl_poll as tp');
        $builder->select("tp.poll_id as id,COALESCE(tp.poll_title,'') as text");

        if(isset($filterData['poll_id']) && !empty($filterData['poll_id'])) {
            if (is_array($filterData['poll_id'])) {
                $builder->whereIn('tp.poll_id', $filterData['poll_id']);
            } else {
                $builder->where('tp.poll_id', $filterData['poll_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tp.poll_title,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    function getPollOption($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }
        $builder = $this->db->table('tbl_poll_option as tpo');
        $builder->select("tpo.poll_option_id as id,COALESCE(tpo.poll_option,'') as text");

        if(isset($filterData['poll_option_id']) && !empty($filterData['poll_option_id'])) {
            if (is_array($filterData['poll_option_id'])) {
                $builder->whereIn('tpo.poll_option_id', $filterData['poll_option_id']);
            } else {
                $builder->where('tpo.poll_option_id', $filterData['poll_option_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tpo.poll_option,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}
?>
