<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class OwnershipFlatModel extends BaseModel
{

	public function getOwnershipFlatData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_ownership_flat as tof');
		$builder->select("tof.*,tf.tower_id");
		$builder->select("COALESCE(ts.society_name,'') as society_name");
		$builder->select("COALESCE(tt.tower_name,'') as tower_name");
		$builder->select("COALESCE(tf.flat_no,'') as flat_nos,tf.bhk,tf.sqr_ft");
		$builder->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->select("COALESCE(ti.number,'') as intercom_no");
		$builder->select("(SELECT count(*) FROM tbl_ownership_flat_member as ctofm WHERE ctofm.ownership_flat_id = tof.ownership_flat_id AND ctofm.is_delete = 0 AND ctofm.type = 'ownership_flat') as total_member");
		$builder->select("IF(tof.purchased_from_id = '-1','".BUILDER."',COALESCE(tm.name,'')) as owner_name");
		$builder->select("GROUP_CONCAT(distinct(COALESCE(tbm.name,'')) SEPARATOR ', ') as buyer_name");
		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tof.society_id","left");
		$builder->join("tbl_flat as tf","tf.flat_id = tof.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tof.updated_by AND tupdate.society_id = tof.society_id","left");
		$builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tof.updated_by AND tcreate.society_id = tof.society_id","left");
		$builder->join("tbl_intercom as ti","ti.flat_id = tof.flat_id","left");
		$builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tof.purchased_from_id AND tofm.is_delete = 0","left");
        $builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.ownership_flat_member_id AND tus.resource_type_id = tofm.resource_type_id","left");

		$builder->join("tbl_ownership_flat_member as btofm","btofm.type_id = tof.ownership_flat_id AND btofm.type = 'ownership_flat' AND btofm.is_owner = 1 AND btofm.is_delete = 0","left");
        $builder->join(MASTER_DB.".tbl_member as tm","tm.member_id = tofm.member_id","left");
        $builder->join(MASTER_DB.".tbl_member as tbm","tbm.member_id = btofm.member_id","left");

		if (isset($filterData['ownership_flat_id']) && !empty($filterData['ownership_flat_id'])) {
			if (is_array($filterData['ownership_flat_id'])) {
				$builder->whereIn('tof.ownership_flat_id', $filterData['ownership_flat_id']);
			} else {
				$builder->where('tof.ownership_flat_id', $filterData['ownership_flat_id']);
			}
		}

		if (isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
			if (is_array($filterData['tower_id'])) {
				$builder->whereIn('tf.tower_id', $filterData['tower_id']);
			} else {
				$builder->where('tf.tower_id', $filterData['tower_id']);
			}
		}

		if (isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tof.type', $filterData['type']);
			} else {
				$builder->where('tof.type', $filterData['type']);
			}
		}

		if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tof.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tof.flat_id', $filterData['flat_id']);
			}
		}

		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tof.society_id', $filterData['society_id']);
			} else {
				$builder->where('tof.society_id', $filterData['society_id']);
			}
		}
		if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			//$this->db->like('member_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tof.is_active', $filterData['is_active']);
		}
		$builder->where('tof.is_delete', 0);
		// accessFilter($builder, array("society" => "tof.society_id"));
		$builder->groupBy('tof.ownership_flat_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}


    public function getOwnershipFlatApiData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_ownership_flat_member as tofm');
        $builder->select("tof.*,tus.phone as mobile_no");
        $builder->select("tof.*,tf.tower_id,tofm.is_owner,tofm.agreement_with");
        $builder->select("COALESCE(ttu.unit_group,'') as unit_group");
        $builder->select("COALESCE(tt.tower_name,'') as tower_name");
        $builder->select("COALESCE(tf.flat_no,'') as flat_nos,tf.bhk,tf.sqr_ft");
        $builder->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
        $builder->select("COALESCE(tm.name,'') as ownership_flat_name,tofm.type,tm.member_image");
        $builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
        $builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofm.ownership_flat_id","left");
        $builder->join("tbl_flat as tf","tf.flat_id = tof.flat_id","left");
        $builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
        $builder->join("tbl_tower_unit as ttu","ttu.tower_unit_id = tf.floor_id","left");
        $builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.member_id AND tus.resource_type_id = tofm.resource_type_id AND tus.society_id = tof.society_id","left");
        $builder->where('tofm.is_delete', 0);

        if (isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
            if (is_array($filterData['ownership_flat_member_id'])) {
                $builder->whereIn('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            } else {
                $builder->where('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            }
        }

        if (isset($filterData['ownership_flat_id']) && !empty($filterData['ownership_flat_id'])) {
            if (is_array($filterData['ownership_flat_id'])) {
                $builder->whereIn('tofm.ownership_flat_id', $filterData['ownership_flat_id']);
            } else {
                $builder->where('tofm.ownership_flat_id', $filterData['ownership_flat_id']);
            }
        }


        if (isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
            if (is_array($filterData['tower_id'])) {
                $builder->whereIn('tf.tower_id', $filterData['tower_id']);
            } else {
                $builder->where('tf.tower_id', $filterData['tower_id']);
            }
        }

        if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
            if (is_array($filterData['flat_id'])) {
                $builder->whereIn('tof.flat_id', $filterData['flat_id']);
            } else {
                $builder->where('tof.flat_id', $filterData['flat_id']);
            }
        }

        if(isset($filterData['is_active']) && !empty($filterData['is_active'])) {
			$builder->where('tofm.is_active', $filterData['is_active']);
		}

		if(isset($filterData['is_owner']) && !empty($filterData['is_owner'])) {
			$builder->where('tofm.is_owner', $filterData['is_owner']);
		}
		
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tof.society_id', $filterData['society_id']);
            } else {
                $builder->where('tof.society_id', $filterData['society_id']);
            }
        }
        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if (isset($filterData['search']) && $filterData['search'] != '') {
            $builder->groupStart();
            $builder->Like('concat(tt.tower_name," - ",tf.flat_no)', $filterData['search'], 'both');
            $builder->orLike("COALESCE(tm.name,'')", $filterData['search'], 'both');
            $builder->orLike("COALESCE(tus.phone,'')", $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tofm.ownership_flat_id');
        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

	public function deleteRecord($ownershipFlatId)
	{
		$data = [
			'is_delete' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $this->ionAuth->getUserId(),
		];

		$ownershipFlatIdArray = is_array($ownershipFlatId) ? $ownershipFlatId : array($ownershipFlatId);
		$builderModuleImage = $this->db->table('tbl_module_document_image');
		$builderModuleImage->whereIn('module_id', $ownershipFlatIdArray);
		$builderModuleImage->where('module', 'ownership_flat');
		$builderModuleImage->delete();


		$builderModule = $this->db->table('tbl_module_document');
		$builderModule->whereIn('module_id', $ownershipFlatIdArray);
		$builderModule->where('module', 'ownership_flat');
		$builderModule->delete();

		$builderModuleVehicleType = $this->db->table('tbl_module_access_card_token_vehicle_type');
		$builderModuleVehicleType->whereIn('type_id', $ownershipFlatIdArray);
		$builderModuleVehicleType->where('type', 'ownership_flat');
		$builderModuleVehicleType->update($data);
		// $builderModuleVehicleType->delete();

		$builderModuleAccessToken = $this->db->table('tbl_module_access_card_token');
		$builderModuleAccessToken->whereIn('type_id', $ownershipFlatIdArray);
		$builderModuleAccessToken->where('type', 'ownership_flat');
		$builderModuleAccessToken->update($data);
		// $builderModuleAccessToken->delete();


		$builderModuleEmergencyContact = $this->db->table('tbl_ownership_flat_emergency_contact');
		//$builderModuleEmergencyContact->whereIn('ownership_flat_id', $ownershipFlatIdArray);
		$builderModuleEmergencyContact->whereIn('type_id', $ownershipFlatIdArray);
		$builderModuleEmergencyContact->where('type', 'ownership_flat');
		$builderModuleEmergencyContact->update($data);
		// $builderModuleEmergencyContact->delete();

		$builderModuleMember = $this->db->table('tbl_ownership_flat_member');
		//$builderModuleMember->whereIn('ownership_flat_id', $ownershipFlatIdArray);
		$builderModuleMember->whereIn('type_id', $ownershipFlatIdArray);
		$builderModuleMember->where('type', 'ownership_flat');
		$builderModuleMember->update($data);
		// $builderModuleMember->delete();

		$builderModuleParking = $this->db->table('tbl_ownership_flat_parking');
		//$builderModuleParking->whereIn('ownership_flat_id', $ownershipFlatIdArray);
		$builderModuleParking->whereIn('type_id', $ownershipFlatIdArray);
		$builderModuleParking->where('type', 'ownership_flat');
		$builderModuleParking->update($data);
		// $builderModuleImage->delete();

		$builder = $this->db->table('tbl_ownership_flat');
		$builder->whereIn('ownership_flat_id', $ownershipFlatIdArray);
		$builder->update($data);
		// $builder->delete();

		if ($this->db->affectedRows()) {

			if(!empty($ownershipFlatId)){
				foreach($ownershipFlatId as $documentElement){
					$deleteDataArray['module'] = 'Ownership Flat';
					$deleteDataArray['activity'] = "Ownership Flat Deleted";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('Ownership Flat Deleted [OwnershipFlatID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Ownership Flat',$documentElement,json_encode($deleteDataArray),'','Ownership Flat',$documentElement);
				}
			}
			return true;
		}
		return false;
	}



	public function getOwnershipFlatMemberData($filterData = array())
	{
		if(isset($filterData['is_db_connect']) && $filterData['is_db_connect'] == 1){
			$this->setTenantDBFromFilter($filterData['society_id']);
		} 
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_ownership_flat_member as tofm');
		$builder->select("tofm.*,tof.flat_id,tf.tower_id,tof.society_id,ts.society_name,tm.*");
		$builder->select("tm.member_id,tm.is_otp_verified,tm.member_image");
		$builder->select("tus.phone as mobile_no");
		$builder->select("tus.user_society_id,tus.user_id");
		$builder->select("COALESCE(tt.tower_name,'') as tower_name");
		$builder->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
		if(isset($filterData['is_show_all_member']) && $filterData['is_show_all_member'] == 1){
			//$builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofm.type_id  ","left");
			$builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofm.ownership_flat_id ","left");
		} else {
			$builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofm.type_id AND tofm.type = 'ownership_flat'","left");
		}
		$builder->join("tbl_flat as tf","tf.flat_id = tof.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tf.society_id","left");
		$builder->join(MASTER_DB.".tbl_member as tm","tm.member_id = tofm.member_id","left");
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.member_id AND tus.resource_type_id = tofm.resource_type_id AND tus.society_id = tof.society_id","left");
		$builder->where('tofm.is_delete', 0);
		$builder->groupBy("tofm.ownership_flat_member_id");

		if(isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
			if (is_array($filterData['ownership_flat_member_id'])) {
				$builder->whereIn('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			} else {
				$builder->where('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			}
		}

		if(isset($filterData['member_id']) && !empty($filterData['member_id'])) {
			if (is_array($filterData['member_id'])) {
				$builder->whereIn('tofm.member_id', $filterData['member_id']);
			} else {
				$builder->where('tofm.member_id', $filterData['member_id']);
			}
		}

		if(isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
			if (is_array($filterData['tower_id'])) {
				$builder->whereIn('tt.tower_id', $filterData['tower_id']);
			} else {
				$builder->where('tt.tower_id', $filterData['tower_id']);
			}
		}


		if(isset($filterData['ownership_flat_member_id_not']) && !empty($filterData['ownership_flat_member_id_not'])) {
			if (is_array($filterData['ownership_flat_member_id_not'])) {
				$builder->whereNotIn('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id_not']);
			} else {
				$builder->where('tofm.ownership_flat_member_id !=', $filterData['ownership_flat_member_id_not']);
			}
		}

		if (isset($filterData['ownership_flat_member_id_not']) && !empty($filterData['ownership_flat_member_id_not'])) {
			if (is_array($filterData['ownership_flat_member_id_not'])) {
				$builder->whereNotIn('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id_not']);
			} else {
				$builder->where('tofm.ownership_flat_member_id !=', $filterData['ownership_flat_member_id_not']);
			}
		}
		
		if(isset($filterData['mobile_no']) && !empty($filterData['mobile_no'])) {
			if (is_array($filterData['mobile_no'])) {
				$builder->whereIn('tus.phone', $filterData['mobile_no']);
			} else {
				$builder->where('tus.phone', $filterData['mobile_no']);
			}
		}

		if(isset($filterData['member_id_not']) && !empty($filterData['member_id_not'])) {
            if (is_array($filterData['member_id_not'])) {
                $builder->whereNotIn('tofm.ownership_flat_member_id', $filterData['member_id_not']);
            } else {
                $builder->where('tofm.ownership_flat_member_id !=', $filterData['member_id_not']);
            }
        }

		if(isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tofm.type', $filterData['type']);
			} else {
				$builder->where('tofm.type', $filterData['type']);
			}
		}
		if(isset($filterData['type_id']) && !empty($filterData['type_id'])) {
			if (is_array($filterData['type_id'])) {
				$builder->whereIn('tofm.type_id', $filterData['type_id']);
			} else {
				$builder->where('tofm.type_id', $filterData['type_id']);
			}
		}

		if(isset($filterData['ownership_flat_id']) && !empty($filterData['ownership_flat_id'])) {
			if (is_array($filterData['ownership_flat_id'])) {
				$builder->whereIn('tofm.ownership_flat_id', $filterData['ownership_flat_id']);
			} else {
				$builder->where('tofm.ownership_flat_id', $filterData['ownership_flat_id']);
			}
		}

		if(isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tof.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tof.flat_id', $filterData['flat_id']);
			}
		}
		if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tof.society_id', $filterData['society_id']);
			} else {
				$builder->where('tof.society_id', $filterData['society_id']);
			}
		}

		if(isset($filterData['mobile_no']) && !empty($filterData['mobile_no'])) {
			if (is_array($filterData['mobile_no'])) {
				$builder->whereIn('tus.phone', $filterData['mobile_no']);
			} else {
				$builder->where('tus.phone', $filterData['mobile_no']);
			}
		}

		// if(isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
		// 	if (is_array($filterData['ownership_flat_member_id'])) {
		// 		$builder->whereIn('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
		// 	} else {
		// 		$builder->where('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
		// 	}
		// }

		if(isset($filterData['is_owner']) && !empty($filterData['is_owner'])) {
			$builder->where('tofm.is_owner', $filterData['is_owner']);
		}

		if(isset($filterData['is_active']) && !empty($filterData['is_active'])) {
			$builder->where('tof.is_active', $filterData['is_active']);
		}

		if(isset($filterData['is_latest']) && !empty($filterData['is_latest'])) {
			$builder->where('tof.is_latest', $filterData['is_latest']);
		}

		if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();
			$builder->Like('concat(tt.tower_name," - ",tf.flat_no)', $filterData['search'], 'both');
			$builder->orLike('tm.name', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function deleteOwnershipFlatMemberRecord($ownershipFlatMemberId)
	{
		$builder = $this->db->table('tbl_ownership_flat_member');
		// $ownershipFlatMemberIdArray = is_array($ownershipFlatMemberId) ? $ownershipFlatMemberId : array($ownershipFlatMemberId);
		$builder->whereIn('ownership_flat_member_id',$ownershipFlatMemberId);
		$data = [
			'is_delete' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $this->ionAuth->getUserId(),
		];
        $builder->update($data);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}

	public function getOwnershipFlatEmergencyData($filterData)
	{
		$builder = $this->db->table('tbl_ownership_flat_emergency_contact as tofec');
		$builder->select("tofec.*");

		if(isset($filterData['ownership_flat_id']) && !empty($filterData['ownership_flat_id'])) {
			if (is_array($filterData['ownership_flat_id'])) {
				$builder->whereIn('tofec.ownership_flat_id', $filterData['ownership_flat_id']);
			} else {
				$builder->where('tofec.ownership_flat_id', $filterData['ownership_flat_id']);
			}
		}


		if(isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tofec.type', $filterData['type']);
			} else {
				$builder->where('tofec.type', $filterData['type']);
			}
		}
		if(isset($filterData['type_id']) && !empty($filterData['type_id'])) {
			if (is_array($filterData['type_id'])) {
				$builder->whereIn('tofec.type_id', $filterData['type_id']);
			} else {
				$builder->where('tofec.type_id', $filterData['type_id']);
			}
		}

		if(isset($filterData['ownership_flat_emergency_contact_id']) && !empty($filterData['ownership_flat_emergency_contact_id'])) {
			if (is_array($filterData['ownership_flat_emergency_contact_id'])) {
				$builder->whereIn('tofec.ownership_flat_emergency_contact_id', $filterData['ownership_flat_emergency_contact_id']);
			} else {
				$builder->where('tofec.ownership_flat_emergency_contact_id', $filterData['ownership_flat_emergency_contact_id']);
			}
		}

		$builder->where('tofec.is_delete', 0);
		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}


	public function deleteOwnershipFlatContactRecord($ownershipFlatEmergencyContactId)
	{
		$builder = $this->db->table('tbl_ownership_flat_emergency_contact');
		$ownershipFlatEmergencyContactIdArray = is_array($ownershipFlatEmergencyContactId) ? $ownershipFlatEmergencyContactId : array($ownershipFlatEmergencyContactId);
		$builder->whereIn('ownership_flat_emergency_contact_id',$ownershipFlatEmergencyContactIdArray);
		$data = [
			'is_delete' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $this->ionAuth->getUserId(),
		];
        $builder->update($data);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}

	public function getOwnershipFlatParkingData($filterData)
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_ownership_flat_parking as tofp');
		$builder->select("tofp.*,tof.flat_id");
		$builder->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
		$builder->select("CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,'')) as parking_area,COALESCE(tpp.number,'') as number");
		$builder->join("tbl_parking_slot as tpp","tpp.parking_slot_id = tofp.parking_slot_id","left");
		$builder->join("tbl_parking_area as ta","ta.parking_area_id = tpp.parking_area_id","left");
		if(isset($filterData['is_show_all_parking']) && $filterData['is_show_all_parking'] == 1){
			$builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofp.ownership_flat_id","left");
		} else {
			$builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofp.type_id AND tofp.type='ownership_flat'","left");
		}
		
		$builder->join("tbl_flat as tf","tf.flat_id = tof.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$builder->where('tofp.is_delete', 0);
		$builder->groupBy("tofp.ownership_flat_parking_id");

		if(isset($filterData['ownership_flat_id']) && !empty($filterData['ownership_flat_id'])) {
			if (is_array($filterData['ownership_flat_id'])) {
				$builder->whereIn('tofp.ownership_flat_id', $filterData['ownership_flat_id']);
			} else {
				$builder->where('tofp.ownership_flat_id', $filterData['ownership_flat_id']);
			}
		}

		if(isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tofp.type', $filterData['type']);
			} else {
				$builder->where('tofp.type', $filterData['type']);
			}
		}
		if(isset($filterData['type_id']) && !empty($filterData['type_id'])) {
			if (is_array($filterData['type_id'])) {
				$builder->whereIn('tofp.type_id', $filterData['type_id']);
			} else {
				$builder->where('tofp.type_id', $filterData['type_id']);
			}
		}

		if(isset($filterData['parking_slot_id']) && !empty($filterData['parking_slot_id'])) {
			if (is_array($filterData['parking_slot_id'])) {
				$builder->whereIn('tofp.parking_slot_id', $filterData['parking_slot_id']);
			} else {
				$builder->where('tofp.parking_slot_id', $filterData['parking_slot_id']);
			}
		}

		if(isset($filterData['vehicle_type']) && !empty($filterData['vehicle_type'])) {
			if (is_array($filterData['vehicle_type'])) {
				$builder->whereIn('tofp.vehicle_type', $filterData['vehicle_type']);
			} else {
				$builder->where('tofp.vehicle_type', $filterData['vehicle_type']);
			}
		}

		if(isset($filterData['ownership_flat_parking_id']) && !empty($filterData['ownership_flat_parking_id'])) {
			if (is_array($filterData['ownership_flat_parking_id'])) {
				$builder->whereIn('tofp.ownership_flat_parking_id', $filterData['ownership_flat_parking_id']);
			} else {
				$builder->where('tofp.ownership_flat_parking_id', $filterData['ownership_flat_parking_id']);
			}
		}

		if(isset($filterData['parking_slot_id']) && !empty($filterData['parking_slot_id'])) {
			if (is_array($filterData['parking_slot_id'])) {
				$builder->whereIn('tofp.parking_slot_id', $filterData['parking_slot_id']);
			} else {
				$builder->where('tofp.parking_slot_id', $filterData['parking_slot_id']);
			}
		}

		if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();
			$builder->like("tofp.vehicle_no", $filterData['search'], 'both');
			$builder->orLike("tofp.vehicle_type", $filterData['search'], 'both');
			$builder->orLike("tpp.number", $filterData['search'], 'both');
			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}


	public function getModuleAccessCardData($filterData)
	{
		$builder = $this->db->table('tbl_module_access_card_token as tmact');
		$builder->select("COALESCE(ta.amenities_name,'') as amenities_name");
		$builder->select("tmact.*");
		$builder->join("tbl_amenities as ta","ta.amenities_id = tmact.amenities_id","left");
		if(isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tmact.type', $filterData['type']);
			} else {
				$builder->where('tmact.type', $filterData['type']);
			}
		}
		if(isset($filterData['type_id']) && !empty($filterData['type_id'])) {
			if (is_array($filterData['type_id'])) {
				$builder->whereIn('tmact.type_id', $filterData['type_id']);
			} else {
				$builder->where('tmact.type_id', $filterData['type_id']);
			}
		}

		if(isset($filterData['module_access_card_token_id']) && !empty($filterData['module_access_card_token_id'])) {
			if (is_array($filterData['module_access_card_token_id'])) {
				$builder->whereIn('tmact.module_access_card_token_id', $filterData['module_access_card_token_id']);
			} else {
				$builder->where('tmact.module_access_card_token_id', $filterData['module_access_card_token_id']);
			}
		}

		$builder->where('tmact.is_delete', 0);
		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function getModuleAccessCardVehicleTypeData($filterData)
	{
		$builder = $this->db->table('tbl_module_access_card_token_vehicle_type as tmactvt');
		$builder->select("tmactvt.*");

		if(isset($filterData['module_access_card_token_id']) && !empty($filterData['module_access_card_token_id'])) {
			if (is_array($filterData['module_access_card_token_id'])) {
				$builder->whereIn('tmactvt.module_access_card_token_id', $filterData['module_access_card_token_id']);
			} else {
				$builder->where('tmactvt.module_access_card_token_id', $filterData['module_access_card_token_id']);
			}
		}
		if(isset($filterData['module_access_card_token_vehicle_type_id']) && !empty($filterData['module_access_card_token_vehicle_type_id'])) {
			if (is_array($filterData['module_access_card_token_vehicle_type_id'])) {
				$builder->whereIn('tmactvt.module_access_card_token_vehicle_type_id', $filterData['module_access_card_token_vehicle_type_id']);
			} else {
				$builder->where('tmactvt.module_access_card_token_vehicle_type_id', $filterData['module_access_card_token_vehicle_type_id']);
			}
		}

		$builder->where('tmactvt.is_delete', 0);
		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function deleteOwnershipFlatParkingRecord($ownershipFlatParkingId)
	{
		$builder = $this->db->table('tbl_ownership_flat_parking');
		// $ownershipFlatParkingIdArray = is_array($ownershipFlatParkingId) ? $ownershipFlatParkingId : array($ownershipFlatParkingId);
		$builder->whereIn('ownership_flat_parking_id',$ownershipFlatParkingId);
		$data = [
			'is_delete' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $this->ionAuth->getUserId(),
		];
        $builder->update($data);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}


	public function deleteModuleAccessCardTokenRecord($moduleAccessCardTokenId)
	{

		$moduleAccessCardTokenIdArray = is_array($moduleAccessCardTokenId) ? $moduleAccessCardTokenId : array($moduleAccessCardTokenId);

		$builderModuleVehicleType = $this->db->table('tbl_module_access_card_token_vehicle_type');
		$builderModuleVehicleType->whereIn('module_access_card_token_id', $moduleAccessCardTokenIdArray);
		$builderModuleVehicleType->delete();



		$builder = $this->db->table('tbl_module_access_card_token');

		$builder->whereIn('module_access_card_token_id',$moduleAccessCardTokenIdArray);
		$builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}


	public function deleteModuleAccessCardTokenVehicleTypeRecord($filterArray = array())
	{
		$builderModuleVehicleType = $this->db->table('tbl_module_access_card_token_vehicle_type');
		$builderModuleVehicleType->where('type', $filterArray['type']);
		$builderModuleVehicleType->where('type_id', $filterArray['type_id']);
		$builderModuleVehicleType->delete();

		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}

	function getOwnershipFlatMember($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		//$this->db->start_cache();
		$builder = $this->db->table('tbl_ownership_flat_member as tofm');
		$builder->select("tofm.ownership_flat_member_id as id,tm.name as text,tus.phone as mobile_no");
		$builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofm.type_id AND tofm.type='ownership_flat'","left");
		$builder->join(MASTER_DB.".tbl_member as tm","tm.member_id = tofm.member_id","left");
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tm.member_id AND tof.society_id = tus.society_id","left");
		$builder->where("tofm.is_owner", 1);
		$builder->where('tofm.is_delete', 0);

		accessFilter($builder, array("society" => "tof.society_id"));
		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("tm.name", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}

		if(isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tof.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tof.flat_id', $filterData['flat_id']);
			}
		} else {
			$builder->where('tof.flat_id', '-9');
		}
		if(isset($filterData['parent_ownership_flat_id']) && !empty($filterData['parent_ownership_flat_id'])) {
			$builder->where("tofm.ownership_flat_id", $filterData['parent_ownership_flat_id']);
		} else {
			$builder->where("tof.is_latest", 1);
		}
		//$this->db->stop_cache();
		$totalRows = $builder->countAllResults(false);
		$builder->limit($filterData['limit'], $filterData['start']);
		$query = $builder->get();

		$result['result'] = $query->getResultArray();
		$result['totalRows'] = $totalRows;
		$result['page'] = $filterData['page'];
		//$this->db->flush_cache();
//		$query = $this->db->getLastQuery();
//		echo (string)$query;
		return json_encode($result);
	}


	function getOwnerMember($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		//$this->db->start_cache();
		$builder = $this->db->table('tbl_ownership_flat_member as tofm');
		$builder->select("tofm.ownership_flat_member_id as id,tm.name as text,tus.phone");
		
		$builder->join("tbl_ownership_flat as tof", "tof.ownership_flat_id = tofm.type_id AND tofm.type='ownership_flat'", "left");
		$builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id AND tofm.type='ownership_flat'", "left");
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.member_id AND tus.resource_type_id = tofm.resource_type_id AND tus.society_id = tof.society_id","left");
		$builder->where('tofm.is_delete', 0);

		if (isset($filterData['is_owner']) && !empty($filterData['is_owner'])) {
			$builder->where("tofm.is_owner", 1);
		}

		if (isset($filterData['is_latest']) && !empty($filterData['is_latest'])) {
			$builder->where("tof.is_latest", 1);
		}
		accessFilter($builder, array("society" => "tof.society_id"));
		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("tm.name", $filterData['filter_param'], 'both');
			$builder->orLike("tus.phone", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}

		if(isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tof.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tof.flat_id', $filterData['flat_id']);
			}
		} else {
			$builder->where('tof.flat_id', '-9');
		}
		
		//$this->db->stop_cache();
		$totalRows = $builder->countAllResults(false);
		$builder->limit($filterData['limit'], $filterData['start']);
		$query = $builder->get();

		$result['result'] = $query->getResultArray();
		$result['totalRows'] = $totalRows;
		$result['page'] = $filterData['page'];
		//$this->db->flush_cache();
//		$query = $this->db->getLastQuery();
//		echo (string)$query;
		return json_encode($result);
	}

	function getAllOwnershipFlatMember($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		//$this->db->start_cache();
		$builder = $this->db->table('tbl_ownership_flat_member as tofm');
		$builder->select("tofm.ownership_flat_member_id as id,tm.name as text,tus.phone");
		$builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofm.type_id AND tofm.type='ownership_flat'","left");
		$builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.member_id AND tus.resource_type_id = tofm.resource_type_id AND tus.society_id = tof.society_id","left");
		$builder->where('tofm.is_delete', 0);

		accessFilter($builder, array("society" => "tof.society_id"));
		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("tm.name", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}

		if(isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tof.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tof.flat_id', $filterData['flat_id']);
			}
		} 
		 
		//$this->db->stop_cache();
		$totalRows = $builder->countAllResults(false);
		$builder->limit($filterData['limit'], $filterData['start']);
		$query = $builder->get();

		$result['result'] = $query->getResultArray();
		$result['totalRows'] = $totalRows;
		$result['page'] = $filterData['page'];
		//$this->db->flush_cache();
//		$query = $this->db->getLastQuery();
//		echo (string)$query;
		return json_encode($result);
	}

	function getOwnershipFlatParking($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		//$this->db->start_cache();
		$builder = $this->db->table('tbl_ownership_flat_parking as tofm');
		$builder->select("tofm.ownership_flat_parking_id as id,tofm.vehicle_no as text,tof.flat_id");
		$builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofm.type_id","left");
		$builder->where("tofm.vehicle_no !=", '');
		$builder->where('tofm.is_delete', 0);


		$builder->groupStart();
		$builder->where('(tof.flat_id IN(SELECT tr.flat_id  FROM tbl_rentals as tr where rent_agreement_period_from  >= "'.TODAY_DATE_YMD.'" AND IF(rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) <= "'.TODAY_DATE_YMD.'"  ) OR (tof.flat_id NOT IN(SELECT tr.flat_id  FROM tbl_rentals as tr where status_id != (SELECT tstatus.status_id  FROM tbl_status as tstatus where tstatus.is_close = 1 AND tstatus.status_for="rentals") AND rent_agreement_period_from  <= "'.TODAY_DATE_YMD.'" AND IF(rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) >= "'.TODAY_DATE_YMD.'" )))',null,false);
		$builder->groupEnd();
		

		// accessFilter($builder, array("society" => "tof.society_id"));
		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("tofm.vehicle_no", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}

		if(isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tof.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tof.flat_id', $filterData['flat_id']);
			}
		} else {
			$builder->where('tof.flat_id', '-9');
		}

		if(isset($filterData['vehicle_type']) && !empty($filterData['vehicle_type'])) {
			if (is_array($filterData['vehicle_type'])) {
				$builder->whereIn('tofm.vehicle_type', $filterData['vehicle_type']);
			} else {
				$builder->where('tofm.vehicle_type', $filterData['vehicle_type']);
			}
		} else {
			$builder->where('tofm.vehicle_type', '-9');
		}
		
		//$this->db->stop_cache();
		$totalRows = $builder->countAllResults(false);
		$builder->limit($filterData['limit'], $filterData['start']);
		$query = $builder->get();

		$result['result'] = $query->getResultArray();
		$result['totalRows'] = $totalRows;
		$result['page'] = $filterData['page'];
		//$this->db->flush_cache();
//		$query = $this->db->getLastQuery();
//		echo (string)$query;
		return json_encode($result);
	}

	function getOwnershipFlat($filterData = array())
	{


		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		//$this->db->start_cache();
		$builder = $this->db->table('tbl_ownership_flat as tof');
		$builder->select("tf.flat_id as id,concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as text,tf.tower_id,tof.ownership_flat_id");
		$builder->join('tbl_flat as tf','tf.flat_id = tof.flat_id');
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$builder->where("tof.is_latest",'1');
		$builder->where("tof.is_delete",'0');
		accessFilter($builder, array("society" => "tof.society_id"));

		if(isset($filterData['is_active'])){
			$builder->where('tof.is_active', $filterData['is_active']);
		}

		if(isset($filterData['is_rental_flat']) && $filterData['is_rental_flat'] == 1) {
			if(isset($filterData['rental_id']) && !empty($filterData['rental_id'])) {
				$builder->where('tf.flat_id NOT IN(SELECT tr.flat_id  FROM tbl_rentals as tr WHERE tr.is_delete = 0 AND tr.rental_id !="'.$filterData['rental_id'].'" )',null,false);
			} else {
				$builder->groupStart();
				$builder->where('tf.flat_id NOT IN(SELECT tr.flat_id  FROM tbl_rentals as tr where tr.is_delete = 0)',null,false);
				//$this->db->or_where('(tf.flat_id IN(SELECT tr.flat_id  FROM tbl_rentals as tr where rent_agreement_period_to < "'.TODAY_DATE_YMD.'") OR (tf.flat_id NOT IN(SELECT tr.flat_id  FROM tbl_rentals as tr where status_id != (SELECT tstatus.status_id  FROM tbl_status as tstatus where tstatus.is_close = 1))))',null,false);
				$builder->orWhere('(tf.flat_id IN(SELECT tr.flat_id  FROM tbl_rentals as tr where rent_agreement_period_from  >= "'.TODAY_DATE_YMD.'" AND IF(rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) <= "'.TODAY_DATE_YMD.'"  ) OR (tf.flat_id NOT IN(SELECT tr.flat_id  FROM tbl_rentals as tr where status_id != (SELECT tstatus.status_id  FROM tbl_status as tstatus where tstatus.is_close = 1 AND tstatus.status_for="rentals") AND rent_agreement_period_from  <= "'.TODAY_DATE_YMD.'" AND IF(rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) >= "'.TODAY_DATE_YMD.'" )))',null,false);
				$builder->groupEnd();
			}
		}

		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') )", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}
		//$this->db->stop_cache();
		$totalRows = $builder->countAllResults(false);
		$builder->limit($filterData['limit'], $filterData['start']);
		$query = $builder->get();
		$result['result'] = $query->getResultArray();
		$result['totalRows'] = $totalRows;
		$result['page'] = $filterData['page'];
		//$this->db->flush_cache();
//		lastQuery();
		return json_encode($result);
	}


	public function checkFlatWiseIndexNoData($filterData = array())
	{
		$builder = $this->db->table('tbl_ownership_flat as tof');
		$builder->select("tof.*");
		$builder->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
		$builder->where('tof.is_active', 1);
		$builder->where('tof.is_delete', 0);
		$builder->join("tbl_flat as tf","tf.flat_id = tof.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		
		if (isset($filterData['ownership_flat_id']) && !empty($filterData['ownership_flat_id'])) {
			if (is_array($filterData['ownership_flat_id'])) {
				$builder->whereNotIn('tof.ownership_flat_id', $filterData['ownership_flat_id']);
			} else {
				$builder->where('tof.ownership_flat_id !=', $filterData['ownership_flat_id']);
			}
		}

		if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tof.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tof.flat_id', $filterData['flat_id']);
			}
		}

		if (isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
			if (is_array($filterData['tower_id'])) {
				$builder->whereIn('tt.tower_id', $filterData['tower_id']);
			} else {
				$builder->where('tt.tower_id', $filterData['tower_id']);
			}
		}


		if (isset($filterData['index_no']) && !empty($filterData['index_no'])) {
			if (is_array($filterData['index_no'])) {
				$builder->whereIn('tof.index_no', $filterData['index_no']);
			} else {
				$builder->where('tof.index_no', $filterData['index_no']);
			}
		}


		if (isset($filterData['is_latest']) && !empty($filterData['is_latest'])) {
			if (is_array($filterData['is_latest'])) {
				$builder->whereIn('tof.is_latest', $filterData['is_latest']);
			} else {
				$builder->where('tof.is_latest', $filterData['is_latest']);
			}
		}

		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tof.society_id', $filterData['society_id']);
			} else {
				$builder->where('tof.society_id', $filterData['society_id']);
			}
		}
		
		
		
		accessFilter($builder, array("society" => "tof.society_id"));
		$builder->groupBy('tof.ownership_flat_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteRecordOwnerManagement($managementCommitteeId)
	{
		$builder = $this->db->table('tbl_management_committee');
		$managementCommitteeIdArray = is_array($managementCommitteeId) ? $managementCommitteeId : array($managementCommitteeId);
		$builder->whereIn('management_committee_id',$managementCommitteeIdArray);
		$builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($managementCommitteeId)){
				foreach($managementCommitteeId as $documentElement){
					$deleteDataArray['module'] = 'Management Committee';
					$deleteDataArray['activity'] = "Owner Flat Module Owner change to Management Committee";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('Management Committee Deleted [ManagementCommitteeID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Management Committee',$documentElement,json_encode($deleteDataArray),'','Management Committee',$documentElement);
				}
			}
			return true;
		}
		return false;
	}


	public function getOwnershipFlatNotRentalsData($filterData = array()){

		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_ownership_flat as tof');
		$builder->select("tof.*,tf.tower_id,tofm.ownership_flat_member_id");
		$builder->select("COALESCE(tt.tower_name,'') as tower_name");
		$builder->select("COALESCE(tf.flat_no,'') as flat_nos,tf.bhk,tf.sqr_ft");
		$builder->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");

		$builder->join("tbl_flat as tf","tf.flat_id = tof.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$builder->join("tbl_ownership_flat_member as tofm","tofm.type_id = tof.ownership_flat_id AND tofm.type='ownership_flat' AND tofm.is_delete = 0","left");
		$builder->where('tof.is_delete', 0);

		if (isset($filterData['ownership_flat_id']) && !empty($filterData['ownership_flat_id'])) {
			if (is_array($filterData['ownership_flat_id'])) {
				$builder->whereIn('tof.ownership_flat_id', $filterData['ownership_flat_id']);
			} else {
				$builder->where('tof.ownership_flat_id', $filterData['ownership_flat_id']);
			}
		}

		if (isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
			if (is_array($filterData['tower_id'])) {
				$builder->whereIn('tf.tower_id', $filterData['tower_id']);
			} else {
				$builder->where('tf.tower_id', $filterData['tower_id']);
			}
		}

		if (isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tof.type', $filterData['type']);
			} else {
				$builder->where('tof.type', $filterData['type']);
			}
		}

		if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tof.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tof.flat_id', $filterData['flat_id']);
			}
		}

		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tof.society_id', $filterData['society_id']);
			} else {
				$builder->where('tof.society_id', $filterData['society_id']);
			}
		}
		if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tof.is_active', $filterData['is_active']);
		}
		if(isset($filterData['is_latest']) && $filterData['is_latest'] == 1){
			$builder->where('tof.is_latest', 1);
		}

		if(isset($filterData['check_flat_rent']) && $filterData['check_flat_rent'] == 1) {

			$builder->groupStart();
			$builder->where('tf.flat_id NOT IN(SELECT tr.flat_id  FROM tbl_rentals as tr)', null, false);
			$builder->orWhere('(tf.flat_id IN(SELECT tr.flat_id  FROM tbl_rentals as tr where rent_agreement_period_from  >= "' . TODAY_DATE_YMD . '" AND IF(rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) <= "' . TODAY_DATE_YMD . '"  ) OR (tf.flat_id NOT IN(SELECT tr.flat_id  FROM tbl_rentals as tr where status_id != (SELECT tstatus.status_id  FROM tbl_status as tstatus where tstatus.is_close = 1 AND tstatus.status_for="rentals") AND rent_agreement_period_from  <= "' . TODAY_DATE_YMD . '" AND IF(rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) >= "' . TODAY_DATE_YMD . '" )))', null, false);
			$builder->groupEnd();
		}
		$builder->groupBy('tofm.ownership_flat_member_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}


	public function getRentalsFlatData($filterData = array()){

		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_rentals as tr');
		$builder->select("tr.*,tf.tower_id,tofm.ownership_flat_member_id");
		$builder->select("COALESCE(tt.tower_name,'') as tower_name");
		$builder->select("COALESCE(tf.flat_no,'') as flat_nos,tf.bhk,tf.sqr_ft");
		$builder->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");

		$builder->join("tbl_flat as tf","tf.flat_id = tr.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$builder->join("tbl_ownership_flat_member as tofm","tofm.type_id = tr.rentals_id AND tofm.type='rentals' AND tofm.is_delete = 0","left");
		$builder->where('tr.is_delete', 0);
		

		if (isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
			if (is_array($filterData['tower_id'])) {
				$builder->whereIn('tf.tower_id', $filterData['tower_id']);
			} else {
				$builder->where('tf.tower_id', $filterData['tower_id']);
			}
		}

		if (isset($filterData['rentals_id']) && !empty($filterData['rentals_id'])) {
			if (is_array($filterData['rentals_id'])) {
				$builder->whereIn('tr.rentals_id', $filterData['rentals_id']);
			} else {
				$builder->where('tr.rentals_id', $filterData['rentals_id']);
			}
		}

		if (isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tofm.type', $filterData['type']);
			} else {
				$builder->where('tofm.type', $filterData['type']);
			}
		}

		if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tr.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tr.flat_id', $filterData['flat_id']);
			}
		}

		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tr.society_id', $filterData['society_id']);
			} else {
				$builder->where('tr.society_id', $filterData['society_id']);
			}
		}
		if(isset($filterData['start'])){
			if($filterData['start'] != '-1'){
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tr.is_active', $filterData['is_active']);
		}


		if(isset($filterData['check_flat_rent']) && $filterData['check_flat_rent'] == 1) {
			$builder->groupStart();
			$builder->Where('((tr.rent_agreement_period_from  >= "'.TODAY_DATE_YMD.'" AND IF(tr.rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) <= "'.TODAY_DATE_YMD.'")  OR (tr.status_id NOT IN(SELECT tstatus.status_id  FROM tbl_status as tstatus where tstatus.is_close = 1 AND tstatus.status_for="rentals") AND rent_agreement_period_from  <= "'.TODAY_DATE_YMD.'" AND IF(rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) >= "'.TODAY_DATE_YMD.'" ))',null,false);
			$builder->groupEnd();
		}
		$builder->groupBy('tofm.ownership_flat_member_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}


	public function getFlatMemberData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_ownership_flat_member as tofm');
		$builder->select("tofm.*");
		$builder->select('tus.phone as mobile_no');
		$builder->where('tofm.is_delete', 0);
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.ownership_flat_member_id AND tus.resource_type_id = tofm.resource_type_id AND tus.is_delete = 0","left");

		if (isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
			if (is_array($filterData['ownership_flat_member_id'])) {
				$builder->whereIn('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			} else {
				$builder->where('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			}
		}

		if (isset($filterData['ownership_flat_id']) && !empty($filterData['ownership_flat_id'])) {
			if (is_array($filterData['ownership_flat_id'])) {
				$builder->whereIn('tofm.ownership_flat_id', $filterData['ownership_flat_id']);
			} else {
				$builder->where('tofm.ownership_flat_id', $filterData['ownership_flat_id']);
			}
		}
		if (isset($filterData['ownership_flat_member_id_not']) && !empty($filterData['ownership_flat_member_id_not'])) {
			if (is_array($filterData['ownership_flat_member_id_not'])) {
				$builder->whereNotIn('tofm.ownership_flat_member_id', $filterData['ownership_flat_member_id_not']);
			} else {
				$builder->where('tofm.ownership_flat_member_id !=', $filterData['ownership_flat_member_id_not']);
			}
		}
		// if(isset($filterData['is_active']) && !empty($filterData['is_active'])) {
		// 	$builder->where('tofm.is_active', $filterData['is_active']);
		// }



		if(isset($filterData['start'])){
			if($filterData['start'] != '-1'){
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->groupEnd();
		}

		$builder->groupBy('tofm.ownership_flat_member_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteMemberRecord($filterData  = array())
    {
        $ownershipFlatMemberId = isset($filterData['member_id']) ? $filterData['member_id'] : array();
        $remarks = isset($filterData['remarks']) ? $filterData['remarks'] : array();
        $userId = isset($filterData['user_society_id']) ? $filterData['user_society_id'] : 0;
        $builder = $this->db->table('tbl_ownership_flat_member');
        $data = [
            'is_delete' => 1,
            'remarks' => $remarks,
            'updated_at'  => date("Y-m-d H:i:s"),
            'updated_by'  => $userId,
        ];

        $builder->where('ownership_flat_member_id', $ownershipFlatMemberId);
        $builder->update($data);

        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        }
        $response['success'] = false;
        return $response;
    }

    public function deleteVehicleRecord($filterData  = array())
    {
        $ownershipFlatParkingId = isset($filterData['ownership_flat_parking_id']) ? $filterData['ownership_flat_parking_id'] : array();
        $remarks = isset($filterData['remarks']) ? $filterData['remarks'] : array();
        $userId = isset($filterData['user_society_id']) ? $filterData['user_society_id'] : 0;
        $builder = $this->db->table('tbl_ownership_flat_parking');
        $data = [
            'is_delete' => 1,
            'remarks' => $remarks,
            'updated_at'  => date("Y-m-d H:i:s"),
            'updated_by'  => $userId,
        ];

        $builder->where('ownership_flat_parking_id', $ownershipFlatParkingId);
        $builder->update($data);

        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        }
        $response['success'] = false;
        return $response;
    }

	public function checkAssignedParking($filterData = array())
	{
		$builder = $this->db->table('tbl_ownership_flat_parking as tofp');
		$builder->select("tofp.*");
		$builder->select("CONCAT(COALESCE(ta.parking_area_name,''),'-',COALESCE(tpp.number,'')) as parking_area");
		$builder->join("tbl_parking_slot as tpp","tpp.parking_slot_id = tofp.parking_slot_id","left");
		$builder->join("tbl_parking_area as ta","ta.parking_area_id = tpp.parking_area_id","left");
		// $builder->join("tbl_rentals as tr","tr.rentals_id = tofp.type_id AND tofp.type='rentals'","left");
		// $builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tpp.ownership_flat_id","left");
		$builder->where('tofp.is_delete', 0);

		if(isset($filterData['parking_slot_id']) && !empty($filterData['parking_slot_id'])) {
			if (is_array($filterData['parking_slot_id'])) {
				$builder->whereIn('tofp.parking_slot_id', $filterData['parking_slot_id']);
			} else {
				$builder->where('tofp.parking_slot_id', $filterData['parking_slot_id']);
			}
		}

		// if (isset($filterData['check_rental_start'])) {
		// 	// Exclude closed rentals by adding the correct conditions
		// 	$builder->where('(
		// 		(tr.rent_agreement_period_from <= "'.TODAY_DATE_YMD.'" 
		// 		AND (tr.rent_agreement_period_to IS NULL OR tr.rent_agreement_period_to >= "'.TODAY_DATE_YMD.'")) 
		// 		OR (tr.status_id NOT IN (
		// 			SELECT tstatus.status_id 
		// 			FROM tbl_status as tstatus 
		// 			WHERE tstatus.is_close = 1 
		// 			AND tstatus.status_for="rentals"
		// 		))
		// 	)', null, false);
		// }

		// Check active rental period
		// if (isset($filterData['check_rental_start'])) {
		// 	$builder->where('(
		// 		(tr.rent_agreement_period_from <= "'.TODAY_DATE_YMD.'" 
		// 		AND (tr.rent_agreement_period_to IS NULL OR tr.rent_agreement_period_to >= "'.TODAY_DATE_YMD.'"))
		// 	)', null, false);

		// 	$builder->where('(tr.status_id IS NULL OR tr.status_id NOT IN (
		// 		SELECT tstatus.status_id 
		// 		FROM tbl_status as tstatus 
		// 		WHERE tstatus.is_close = 1 
		// 		AND tstatus.status_for="rentals"
		// 	))', null, false);
		// }

		// Check for rentals type
		// if (isset($filterData['check_rental_start'])) {
		// 	$builder->groupStart();  // Group the next conditions
		// 	$builder->where('tofp.type', 'rentals');  // Only apply this logic for rentals
	
		// 	// Check active rental period for rentals type
		// 	$builder->where('(
		// 		(tr.rent_agreement_period_from <= "'.TODAY_DATE_YMD.'" 
		// 		AND (tr.rent_agreement_period_to IS NULL OR tr.rent_agreement_period_to >= "'.TODAY_DATE_YMD.'"))
		// 	)', null, false);
	
		// 	// Exclude records with closed rental status
		// 	$builder->where('(tr.status_id IS NULL OR tr.status_id NOT IN (
		// 		SELECT tstatus.status_id 
		// 		FROM tbl_status as tstatus 
		// 		WHERE tstatus.is_close = 1 
		// 		AND tstatus.status_for="rentals"
		// 	))', null, false);
		// 	$builder->groupEnd();  // Close the grouped conditions
		// }

		if(isset($filterData['ownership_flat_parking_not_id']) && !empty($filterData['ownership_flat_parking_not_id'])) {
			if (is_array($filterData['ownership_flat_parking_not_id'])) {
				$builder->whereNotIn('tofp.ownership_flat_parking_id', $filterData['ownership_flat_parking_not_id']);
			} else {
				$builder->where('tofp.ownership_flat_parking_id !=', $filterData['ownership_flat_parking_not_id']);
			}
		}

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function checkAggrementClosed($filterData = array())
	{
		$builder = $this->db->table('tbl_rentals as tr');
		$builder->select("tr.*");
		
		$builder->where('tr.is_delete', 0);

		if(isset($filterData['rentals_id']) && !empty($filterData['rentals_id'])) {
			if (is_array($filterData['rentals_id'])) {
				$builder->whereIn('tr.rentals_id', $filterData['rentals_id']);
			} else {
				$builder->where('tr.rentals_id', $filterData['rentals_id']);
			}
		}

		// if (isset($filterData['check_rental_start'])) {
		// 	// Exclude closed rentals by adding the correct conditions
		// 	$builder->where('(
		// 		(tr.rent_agreement_period_from <= "'.TODAY_DATE_YMD.'" 
		// 		AND (tr.rent_agreement_period_to IS NULL OR tr.rent_agreement_period_to >= "'.TODAY_DATE_YMD.'")) 
		// 		OR (tr.status_id NOT IN (
		// 			SELECT tstatus.status_id 
		// 			FROM tbl_status as tstatus 
		// 			WHERE tstatus.is_close = 1 
		// 			AND tstatus.status_for="rentals"
		// 		))
		// 	)', null, false);
		// }

		// Check active rental period
		// if (isset($filterData['check_rental_start'])) {
		// 	$builder->where('(
		// 		(tr.rent_agreement_period_from <= "'.TODAY_DATE_YMD.'" 
		// 		AND (tr.rent_agreement_period_to IS NULL OR tr.rent_agreement_period_to >= "'.TODAY_DATE_YMD.'"))
		// 	)', null, false);

		// 	$builder->where('(tr.status_id IS NULL OR tr.status_id NOT IN (
		// 		SELECT tstatus.status_id 
		// 		FROM tbl_status as tstatus 
		// 		WHERE tstatus.is_close = 1 
		// 		AND tstatus.status_for="rentals"
		// 	))', null, false);
		// }

		// if (isset($filterData['check_rental_start'])) {

			// Check active rental period for rentals type
			// $builder->where('(
			// 	(tr.rent_agreement_period_to IS NULL OR tr.rent_agreement_period_to <= "'.TODAY_DATE_YMD.'")
			// )', null, false);
	
			// // Exclude records with closed rental status
			// // $builder->where('(tr.status_id IS NULL OR tr.status_id NOT IN (
			// // 	SELECT tstatus.status_id 
			// // 	FROM tbl_status as tstatus 
			// // 	WHERE tstatus.is_close = 1 
			// // 	AND tstatus.status_for="rentals"
			// // ))', null, false);
			// $builder->where('(tr.status_id IS NULL OR tr.status_id IN (
			// 	SELECT tstatus.status_id 
			// 	FROM tbl_status as tstatus 
			// 	WHERE tstatus.is_close = 1 
			// 	AND tstatus.status_for="rentals"
			// ))', null, false);
			$builder->groupStart() // Start the group
    				->where('(tr.rent_agreement_period_to IS NULL OR tr.rent_agreement_period_to <= "'.TODAY_DATE_YMD.'")', null, false)
    				->orWhere('(tr.status_id IS NULL OR tr.status_id IN (
			        SELECT tstatus.status_id 
			        FROM tbl_status as tstatus 
			        WHERE tstatus.is_close = 1 
			        AND tstatus.status_for="rentals"
			    ))', null, false)
			->groupEnd(); // End the group
		// }

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		// lastQuery();
		return $query;
	}

	public function getMemberData($filterData = array()){
		$builder = $this->db->table(MASTER_DB.'.tbl_member as tm');
		$builder->select("tm.*");
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tm.member_id","left");
		$builder->join(MASTER_DB.".society_resource_type_view as tsrtv","tus.resource_type_id = tsrtv.resource_type_id AND tsrtv.resource_type_name = 'member'","left");
		$builder->groupBy("tm.member_id");

		if(isset($filterData['member_id']) && !empty($filterData['member_id'])) {
			if (is_array($filterData['member_id'])) {
				$builder->whereIn('tm.member_id', $filterData['member_id']);
			} else {
				$builder->where('tm.member_id', $filterData['member_id']);
			}
		}

		if(isset($filterData['member_id_not']) && !empty($filterData['member_id_not'])) {
			if (is_array($filterData['member_id_not'])) {
				$builder->whereNotIn('tm.member_id', $filterData['member_id_not']);
			} else {
				$builder->where('tm.member_id !=', $filterData['member_id_not']);
			}
		}

		if(isset($filterData['phone']) && !empty($filterData['phone'])) {
			if (is_array($filterData['phone'])) {
				$builder->whereIn('tus.phone', $filterData['phone']);
			} else {
				$builder->where('tus.phone', $filterData['phone']);
			}
		}

		if(isset($filterData['status']) && !empty($filterData['status'])) {
			if (is_array($filterData['status'])) {
				$builder->whereIn('tm.status', $filterData['status']);
			} else {
				$builder->where('tm.status', $filterData['status']);
			}
		}

		if(isset($filterData['otp']) && !empty($filterData['otp'])) {
			if (is_array($filterData['otp'])) {
				$builder->whereIn('tm.otp', $filterData['otp']);
			} else {
				$builder->where('tm.otp', $filterData['otp']);
			}
		}

		if(isset($filterData['check_otp_validity']) && !empty($filterData['check_otp_validity'])) {
			$builder->where('tm.otp_validity >', date('Y-m-d H:i:s'));
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		// lastQuery();
		return $query;

	}

	public function updateMobileNoUsingMemberId($filterData = array()){
		if (!empty($filterData['member_id']) && is_array($filterData['member_id'])) {
			$memberIdArr = implode(',', array_map('intval', $filterData['member_id']));
	
			$updateQuery = "UPDATE tbl_ownership_flat_member ofm
				JOIN " . MASTER_DB . ".tbl_member m ON ofm.member_id = m.member_id
				SET ofm.mobile_no = m.mobile_no
				WHERE ofm.member_id IN ($memberIdArr)";
	
			// Execute the query
			$this->db->query($updateQuery);
		}
	}

	public function deleteUserRecords($filterData = array()){
		if (!empty($filterData['user_society_id']) && is_array($filterData['user_society_id'])) {
			// $userIdArr = implode(',', array_map('intval', $filterData['user_society_id']));
			
			// delete user records
			$builder = $this->db->table(MASTER_DB.'.tbl_users as tu');
			$builder->whereIn('id',$filterData['user_society_id']);
			$builder->delete();
			
			// delete user records
			$builder = $this->db->table(MASTER_DB.'.tbl_user_society as tus');
			$builder->whereIn('user_society_id',$filterData['user_society_id']);
			$builder->delete();
			
			// delete user records
			$builder = $this->db->table(MASTER_DB.'.tbl_users_groups as tug');
			$builder->whereIn('user_society_id',$filterData['user_society_id']);
			$builder->delete();
			
			// delete user records
			$builder = $this->db->table(MASTER_DB.'.tbl_user_permission as tup');
			$builder->whereIn('user_society_id',$filterData['user_society_id']);
			$builder->delete();
			

		} 
	}

	public function deleteMemberRecords($filterData = array()){
		if (!empty($filterData['member_id']) && is_array($filterData['member_id'])) {
			// delete memeber records
			$builder = $this->db->table(MASTER_DB.'.tbl_member as tm');
			$builder->whereIn('member_id',$filterData['member_id']);
			$builder->delete();
		} 
	}

	public function deleteOldUserRecords($filterData = array()){
		if (!empty($filterData['member_id']) && is_array($filterData['member_id'])) {
			
			// delete memeber records
			$builder = $this->db->table(MASTER_DB.'.tbl_member as tm');
			$builder->whereIn('member_id',$filterData['member_id']);
			$builder->delete();

			

		} 
	}

	public function updateMemberId($filterData = array())
    {
        // SQL query
        $sql = "UPDATE tbl_ownership_flat_member AS tofm
			    LEFT JOIN " . MASTER_DB . ".tbl_member AS tm
			    ON tm.member_slug = tofm.member_slug
			    SET tofm.member_id = tm.member_id";


        // Run the query
        $this->db->query($sql);
    }

	public function deleteUserIdRecords($filterData = array()){

		if(isset($filterData['member_id']) && !empty($filterData['member_id'])){

			if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
				$societyId = $filterData['society_id'];
			} else {
				$societyId = $this->session->get('society_id');
			}
			$builder = $this->db->table(MASTER_DB.'.tbl_user_society as tus');
			$builder->whereIn('type_id',$filterData['member_id']);
			// $builder->where('tus.society_id',$societyId);
			$builder->where("tus.resource_type_id IN (SELECT resource_type_id FROM ".MASTER_DB.".society_resource_type_view WHERE resource_type_name = '".RESOURCE_TYPE_MEMBER."')");
			$userSocietyData = $builder->get()->getResultArray();

			// for single data base and for multitanent we have to use view
			$memberBuilder = $this->db->table('tbl_ownership_flat_member as tofm');
			$memberBuilder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofm.type_id","left");
			$memberBuilder->whereIn('tofm.member_id',$filterData['member_id']);
			$memberBuilder->where('tof.society_id',$societyId);
			$ownershipFlatMemberData = $memberBuilder->get()->getResultArray();

			$deleteMemberIdArr = array();
			$memberIdCount = [];

			foreach ($ownershipFlatMemberData as $member) {
				if (!empty($member['member_id'])) {
					$memberId = $member['member_id'];
					if (!isset($memberIdCount[$memberId])) {
						$memberIdCount[$memberId] = 0;
					}
					$memberIdCount[$memberId]++;
				}
			}

			foreach ($memberIdCount as $memberId => $count) {
				if ($count === 1) {
					$deleteMemberIdArr[] = $memberId;
				}
			}

			$userSocietyDeleteArr = array();
			if(!empty($deleteMemberIdArr)){
				foreach($userSocietyData as $userSociety){
					if(in_array($userSociety['type_id'],$deleteMemberIdArr)){
						$userSocietyDeleteArr[] = $userSociety['user_society_id'];
					}
				}
			}

			
			$deleteUpdateArr = array(
				'is_delete' => 1,
				'updated_at'  => date("Y-m-d H:i:s"),
        		'updated_by'  => $this->ionAuth->getUserId(),
			);

			if(!empty($userSocietyDeleteArr)){
				$builder = $this->db->table(MASTER_DB.'.tbl_user_society as tus');
				$builder->whereIn('tus.user_society_id', $userSocietyDeleteArr);
				// $builder->where('tus.society_id',$societyId);
				$builder->where("tus.resource_type_id IN (SELECT resource_type_id FROM ".MASTER_DB.".society_resource_type_view WHERE resource_type_name = '".RESOURCE_TYPE_MEMBER."')");
        		$builder->update($deleteUpdateArr);
			}

			if(!empty($deleteMemberIdArr)){
				$builder = $this->db->table(MASTER_DB.'.tbl_member as tm');
				$builder->where('tm.member_id',$deleteMemberIdArr);
				$builder->update($deleteUpdateArr);
			}

			if ($this->db->affectedRows()) {
				return true;
			}
			return false;
		}
	}

}
?>
