<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class MenPowerAttendanceModel extends BaseModel
{
	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getMenPowerAttendanceData($filterData = array())
	{
		// printArray($filterData,1);
		$limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_men_power_attendance as tmpa');
        $builder->select("tmpa.*,ts.society_name,tresource.resource_name,trt.resource_type_name,tresource.resource_type_id");
		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tmpa.society_id","left");
		$builder->join("tbl_resource as tresource","tresource.resource_id = tmpa.resource_id","left");
		$builder->join("tbl_resource_type as trt","trt.resource_type_id = tresource.resource_type_id","left");
		if (isset($filterData['men_power_attendance_id']) && !empty($filterData['men_power_attendance_id'])) {
			if (is_array($filterData['men_power_attendance_id'])) {
				$builder->whereIn('tmpa.men_power_attendance_id', $filterData['men_power_attendance_id']);
			} else {
				$builder->where('tmpa.men_power_attendance_id', $filterData['men_power_attendance_id']);
			}
		}
		if (isset($filterData['resource_id']) && !empty($filterData['resource_id'])) {
			if (is_array($filterData['resource_id'])) {
				$builder->whereIn('tmpa.resource_id', $filterData['resource_id']);
			} else {
				$builder->where('tmpa.resource_id', $filterData['resource_id']);
			}
		}
		// if (isset($filterData['men_power_attendance_date']) && !empty($filterData['men_power_attendance_date'])) {
		// 	if (is_array($filterData['men_power_attendance_date'])) {
		// 		$builder->whereIn('tmpa.men_power_attendance_date', $filterData['men_power_attendance_date']);
		// 	} else {
		// 		$builder->where('tmpa.men_power_attendance_date', $filterData['men_power_attendance_date']);
		// 	}
		// }
		if (isset($filterData['in_time']) && !empty($filterData['in_time'])) {
			if (is_array($filterData['in_time'])) {
				$builder->whereIn('tmpa.in_time', $filterData['in_time']);
			} else {
				$builder->where('tmpa.in_time', $filterData['in_time']);
			}
		}
		if (isset($filterData['out_time']) && !empty($filterData['out_time'])) {
			if (is_array($filterData['out_time'])) {
				$builder->whereIn('tmpa.out_time', $filterData['out_time']);
			} else {
				$builder->where('tmpa.out_time', $filterData['out_time']);
			}
		}
		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tmpa.society_id', $filterData['society_id']);
			} else {
				$builder->where('tmpa.society_id', $filterData['society_id']);
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('tmpa.society_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tmpa.is_active', $filterData['is_active']);
		}
		$builder->groupBy('tmpa.men_power_attendance_id');
		// accessFilter($builder, array("society" => "tmpa.society_id"));
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteRecord($menPowerAttendanceId,$userId = 0,$societyId = 0)
	{
		$builder = $this->db->table('tbl_men_power_attendance');
        $menPowerAttendanceIdArray = is_array($menPowerAttendanceId) ? $menPowerAttendanceId : array($menPowerAttendanceId);
        $builder->whereIn('men_power_attendance_id', $menPowerAttendanceIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($menPowerAttendanceId)){
				foreach($menPowerAttendanceId as $menPowerAttendance){
					$deleteDataArray['module'] = 'Men Power Attendance';
            		$deleteDataArray['activity'] = "Men Power Attendance Deleted";
					$deleteDataArray['module_id'] = $menPowerAttendance;
					$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
					logActivity('Men Power Attendance Deleted [MenPowerAttendanceID: ' . $menPowerAttendance . ']',$this->ionAuth->getUserId(),'Men Power Attendance',$menPowerAttendance,json_encode($deleteDataArray),'','Men Power Attendance',$menPowerAttendance);
				}
			}
			return true;
		}
		return false;
	}
}
?>
