<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class MaterialModel extends BaseModel
{

	public function getMaterialData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_material as tm');
		$builder->select("tm.*");
		$builder->select("concat(tm.prefix,tm.series) as document_number");
		$builder->select("COALESCE(ts.society_name,'') as society_name,COALESCE(tca.common_area_name,'') as common_area_name");
		$builder->select("COALESCE(tfy.financial_year_prefix,'') as financial_year_prefix");

		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
		$builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->select("concat(COALESCE(tapprove.first_name,''),' ',COALESCE(tapprove.last_name,'')) as approved_by");


		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tm.society_id","left");
		$builder->join("tbl_common_area as tca","tca.common_area_id = tm.common_area_id","left");

		$builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tm.updated_by AND tupdate.society_id = tm.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tm.created_by AND tcreate.society_id = tm.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tapprove","tapprove.id = tm.approved_by AND tapprove.society_id = tm.society_id","left");
		$builder->join("tbl_financial_year as tfy","tfy.financial_year_id = tm.financial_year_id","left");


		if (isset($filterData['material_id']) && !empty($filterData['material_id'])) {
			if (is_array($filterData['material_id'])) {
				$builder->whereIn('tm.material_id', $filterData['material_id']);
			} else {
				$builder->where('tm.material_id', $filterData['material_id']);
			}
		}


		if (isset($filterData['common_area_id']) && !empty($filterData['common_area_id'])) {
			if (is_array($filterData['common_area_id'])) {
				$builder->whereIn('tm.common_area_id', $filterData['common_area_id']);
			} else {
				$builder->where('tm.common_area_id', $filterData['common_area_id']);
			}
		}


		if (isset($filterData['start'])) {
			if ($filterData['start'] != '1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			//$this->db->like('member_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}

		accessFilter($builder, array("society" => "tm.society_id"));
		$builder->groupBy('tm.material_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteRecord($materialId)
	{
		$materialIdArray = is_array($materialId) ? $materialId : array($materialId);
		$builderItem = $this->db->table('tbl_material_item');
		$builderItem->whereIn('material_id', $materialIdArray);
		$builderItem->delete();

		$builder = $this->db->table('tbl_material');
		$builder->whereIn('material_id', $materialIdArray);
		$builder->delete();

		if ($this->db->affectedRows()) {

			if(!empty($materialId)){
				foreach($materialId as $documentElement){
					$deleteDataArray['module'] = 'Material';
					$deleteDataArray['activity'] = "Material Deleted";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('Material Deleted [MaterialID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Material',$documentElement,json_encode($deleteDataArray),'','Material',$documentElement);
				}
			}
			return true;
		}
		return false;
	}



	public function getMaterialItemData($filterData)
	{
		$builder = $this->db->table('tbl_material_item as tmi');
		$builder->select("tmi.*,COALESCE(tmi.item_name,'') as material_item_name,CONCAT(COALESCE(tm.prefix,''),COALESCE(tm.series,'')) as material_return_number");
		$builder->select("COALESCE(ti.item_name,'') as item_name");

		$builder->join("tbl_item as ti","ti.item_id = tmi.item_id","left");

		$builder->join("tbl_material as tm","tm.material_id = tmi.document_type_id AND tmi.document_type = 'material_return'","left");

		if(isset($filterData['material_item_id']) && !empty($filterData['material_item_id'])) {
			if (is_array($filterData['rentals_id'])) {
				$builder->whereIn('tmi.material_item_id', $filterData['material_item_id']);
			} else {
				$builder->where('tmi.material_item_id', $filterData['material_item_id']);
			}
		}

		if(isset($filterData['material_id']) && !empty($filterData['material_id'])) {
			if (is_array($filterData['material_id'])) {
				$builder->whereIn('tmi.material_id', $filterData['material_id']);
			} else {
				$builder->where('tmi.material_id', $filterData['material_id']);
			}
		}

		if(isset($filterData['item_id']) && !empty($filterData['item_id'])) {
			if (is_array($filterData['item_id'])) {
				$builder->whereIn('tmi.item_id', $filterData['item_id']);
			} else {
				$builder->where('tmi.item_id', $filterData['item_id']);
			}
		}

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function deleteMaterialItemRecord($materialItemId)
	{
		$builder = $this->db->table('tbl_material_item');
		$materialItemIdArray = is_array($materialItemId) ? $materialItemId : array($materialItemId);
		$builder->whereIn('material_item_id',$materialItemIdArray);
		$builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}


	public function deleteMaterialItem($materialId)
	{
		$builder = $this->db->table('tbl_material_item');
		$materialIdArray = is_array($materialId) ? $materialId : array($materialId);
		$builder->whereIn('material_id',$materialIdArray);
		$builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}

	function getMaterialReturn($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		$builder = $this->db->table('tbl_material as tm');
		$builder->select("tm.material_id as id,CONCAT(COALESCE(tm.prefix,''),COALESCE(tm.series,'')) as text");
		$builder->where("tm.form_submit",'approved');

		if(isset($filterData['material_id']) && !empty($filterData['material_id'])) {
			if (is_array($filterData['material_id'])) {
				$builder->whereIn('tm.material_id', $filterData['material_id']);
			} else {
				$builder->where('tm.material_id', $filterData['material_id']);
			}
		}

		if(isset($filterData['material_type']) && !empty($filterData['material_type'])) {
			if (is_array($filterData['material_type'])) {
				$builder->whereIn('tm.material_type', $filterData['material_type']);
			} else {
				$builder->where('tm.material_type', $filterData['material_type']);
			}
		}

		if(isset($filterData['common_area_id']) && !empty($filterData['common_area_id'])) {
			if (is_array($filterData['common_area_id'])) {
				$builder->whereIn('tm.common_area_id', $filterData['common_area_id']);
			} else {
				$builder->where('tm.common_area_id', $filterData['common_area_id']);
			}
		} else {
			$builder->where('tm.common_area_id','-9');
		}

		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("CONCAT(COALESCE(tm.prefix,''),COALESCE(tm.series,''))", $filterData['filter_param']);
			$builder->groupEnd();
		}

		if(isset($filterData['material_id']) && !empty($filterData['material_id'])) {
			if (is_array($filterData['material_id'])) {
				$builder->whereIn('tm.material_id', $filterData['material_id']);
			} else {
				$builder->where('tm.material_id', $filterData['material_id']);
			}
		}


		$totalRows = $builder->countAllResults(false);
		$builder->limit($filterData['limit'], $filterData['start']);

		if(isset($filterData['material_id']) && $filterData['material_id'] != '') {
			$builder->having('(SELECT COALESCE(SUM(tmi.quantity),0) FROM tbl_material_item AS tmi where tmi.material_id = tm.material_id) - (SELECT COALESCE(SUM(tmir.quantity),0) from tbl_material_item as tmir where tmir.document_type_id = tm.material_id AND tmir.document_type_id != '.$filterData['material_id'].') > 0', null, false);
		}
		else {
			$builder->having('(SELECT COALESCE(SUM(tmi.quantity),0) FROM tbl_material_item AS tmi where tmi.material_id = tm.material_id) - (SELECT COALESCE(SUM(tmir.quantity),0) from tbl_material_item as tmir where tmir.document_type_id = tm.material_id) > 0', null, false);
		}


		$query = $builder->get();
		$result['result'] = $query->getResultArray();
		$result['totalRows'] = $totalRows;
		$result['page'] = $filterData['page'];
		return json_encode($result);
	}

	public function getMaterialItemPullMRData($filterData)
	{

		$builder = $this->db->table('tbl_material_item as tmp');
		$builder->select("tmp.*,(COALESCE(tmp.quantity,0) - COALESCE(SUM(tmpr.quantity),0)) as quantity");
		$builder->select("concat(ti.item_name) as item_name,COALESCE(ti.item_name,'') as material_item_name");
		$builder->join("tbl_item as ti","ti.item_id = tmp.item_id","left");



		if(isset($filterData['material_id']) && $filterData['material_id'] != '') {
			$builder->join('tbl_material_item as tmpr','tmpr.document_type_item_id = tmp.material_item_id  AND tmpr.document_type ="material_return" AND tmpr.material_id !=' .$filterData['material_id'],'left');
		} else {
			$builder->join('tbl_material_item as tmpr','tmpr.document_type_item_id = tmp.material_item_id  AND tmpr.document_type ="material_return" ','left');
		}

		if(isset($filterData['material_return_id']) && !empty($filterData['material_return_id'])) {
			if (is_array($filterData['material_return_id'])) {
				$builder->whereIn('tmp.material_id', $filterData['material_return_id']);
			} else {
				$builder->where('tmp.material_id', $filterData['material_return_id']);
			}
		}

		$builder->having('quantity > 0',null,false);
		$builder->groupBy("tmp.material_item_id");

		if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		}else{
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteMaterialReturnReference($materialId)
	{
		$builder = $this->db->table('tbl_material_reference');
		$materialIdArray = is_array($materialId) ? $materialId : array($materialId);
		$builder->whereIn('material_id',$materialIdArray);
		$builder->delete();
		if ($this->db->affectedRows()) {
			return true;
		}
		return false;
	}

	public function getMaterialReferenceData($filterData = array())
	{


		$builder = $this->db->table('tbl_material_reference as tmr');
		$builder->select("tmr.*,CONCAT(COALESCE(tm.prefix,''),COALESCE(tm.series,'')) as material_return_number");

		$builder->join("tbl_material as tm","tm.material_id = tmr.reference_type_id AND tmr.reference_type = 'material_return'","left");


		if(isset($filterData['material_id']) && !empty($filterData['material_id'])) {
			if (is_array($filterData['material_id'])) {
				$builder->whereIn('tmr.material_id', $filterData['material_id']);
			} else {
				$builder->where('tmr.material_id', $filterData['material_id']);
			}
		}

		if(isset($filterData['reference_type_id']) && !empty($filterData['reference_type_id'])) {
			if (is_array($filterData['reference_type_id'])) {
				$builder->whereIn('tmr.reference_type_id', $filterData['reference_type_id']);
			} else {
				$builder->where('tmr.reference_type_id', $filterData['reference_type_id']);
			}
		}

		if(isset($filterData['reference_type']) && !empty($filterData['reference_type'])) {
			if (is_array($filterData['reference_type'])) {
				$builder->whereIn('tmr.reference_type', $filterData['reference_type']);
			} else {
				$builder->where('tmr.reference_type', $filterData['reference_type']);
			}
		}

		if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		}else{
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}


}
?>
