<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ManagementCommitteeModel extends BaseModel
{

    public function getManagementCommitteeData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_management_committee as tmc');
        $builder->select("tmc.*,ts.society_name,tf.flat_no,tt.tower_name,concat(tt.tower_name,' - ',tf.flat_no) as tower_flat_name,tfy.financial_year_prefix,tm.name as member_name,tm.member_id as user_member_id,tofm.ownership_flat_member_id");
        $builder->select("GROUP_CONCAT(distinct(tm.management_committee_responsibilities_name) SEPARATOR ', ') as responsibilities");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tmc.society_id","left");
		$builder->join("tbl_financial_year as tfy","tfy.financial_year_id = tmc.financial_year_id","left");
		$builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tmc.member_id","left");
        $builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
		$builder->join("tbl_flat as tf","tf.flat_id = tmc.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tmc.updated_by AND tupdate.society_id = tmc.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tmc.created_by AND tcreate.society_id = tmc.society_id","left");
        // $builder->join("tbl_management_committee_responsibilities as tm","tm.management_committee_responsibilities_id = tmc.management_committee_responsibilities_id","left");
        $builder->join('tbl_management_committee_muliple_responsibilities tmcmr', 'tmcmr.management_committee_id = tmc.management_committee_id', 'left');
		$builder->join("tbl_management_committee_responsibilities as tm","tm.management_committee_responsibilities_id = tmcmr.management_committee_responsibilities_id","left");

		if (isset($filterData['management_committee_id']) && !empty($filterData['management_committee_id'])) {
			if (is_array($filterData['management_committee_id'])) {
				$builder->whereIn('tmc.management_committee_id', $filterData['management_committee_id']);
			} else {
				$builder->where('tmc.management_committee_id', $filterData['management_committee_id']);
			}
		}

		if (isset($filterData['financial_year_id']) && !empty($filterData['financial_year_id'])) {
			if (is_array($filterData['financial_year_id'])) {
				$builder->whereIn('tmc.financial_year_id', $filterData['financial_year_id']);
			} else {
				$builder->where('tmc.financial_year_id', $filterData['financial_year_id']);
			}
		}

        if (isset($filterData['management_committee_responsibilities_id']) && !empty($filterData['management_committee_responsibilities_id'])) {
            if (is_array($filterData['management_committee_responsibilities_id'])) {
                $builder->whereIn('tmcmr.management_committee_responsibilities_id', $filterData['management_committee_responsibilities_id']);
            } else {
                $builder->where('tmcmr.management_committee_responsibilities_id', $filterData['management_committee_responsibilities_id']);
            }
        }

		if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tmc.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tmc.flat_id', $filterData['flat_id']);
			}
		}


		if (isset($filterData['management_committee_id_not']) && !empty($filterData['management_committee_id_not'])) {
			if (is_array($filterData['management_committee_id_not'])) {
				$builder->whereNotIn('tmc.management_committee_id', $filterData['management_committee_id_not']);
			} else {
				$builder->where('tmc.management_committee_id !=', $filterData['management_committee_id_not']);
			}
		}


		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like("COALESCE(tmc.designation,'')", $filterData['search'], 'both');
			$builder->orLike("COALESCE(tmc.mobile_no,'')", $filterData['search'], 'both');
			$builder->orLike("COALESCE(tm.name,'')", $filterData['search'], 'both');
			$builder->orLike("CONCAT(tt.tower_name,' - ',tf.flat_no)", $filterData['search'], 'both');
			$builder->orLike("COALESCE(tm.management_committee_responsibilities_name,'')", $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tmc.is_active', $filterData['is_active']);
		}

        if(isset($filterData['is_api'])){
            accessFilter($builder, array("society" => "tmc.society_id"),1,array("society_id" => isset($filterData['society_id']) ? $filterData['society_id'] : 0));
        } else  {
            accessFilter($builder, array("society" => "tmc.society_id"));
        }


		$builder->groupBy('tmc.management_committee_id');

		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
    }


    public function deleteRecord($managementCommitteeId)
    {
        $builder = $this->db->table('tbl_management_committee');
        $managementCommitteeIdArray = is_array($managementCommitteeId) ? $managementCommitteeId : array($managementCommitteeId);
        $builder->whereIn('management_committee_id', $managementCommitteeIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($managementCommitteeId)){
                foreach($managementCommitteeId as $documentElement){
                    $deleteDataArray['module'] = 'Management Committee';
                    $deleteDataArray['activity'] = "Management Committee Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Management Committee Deleted [ManagementCommitteeID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Management Committee',$documentElement,json_encode($deleteDataArray),'','Management Committee',$documentElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getFlatMember($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        //$this->db->start_cache();
        $builder = $this->db->table('tbl_ownership_flat_member as tofm');
        $builder->select("tofm.ownership_flat_member_id as id,tm.name as text,tus.phone");
        $builder->select("concat(tt.tower_name,' - ',tf.flat_no) as tower_flat_name,tof.flat_id");
        $builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofm.ownership_flat_id","left");
        $builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
        $builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.member_id AND tus.resource_type_id = tofm.resource_type_id AND tus.society_id = tof.society_id","left");
        $builder->where("tofm.is_owner", 1);
        $builder->where("tof.is_latest", 1);

        $builder->join("tbl_flat as tf","tf.flat_id = tof.flat_id","left");
        $builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");

        accessFilter($builder, array("society" => "tof.society_id"));
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("tm.name", $filterData['filter_param'], 'both');
            $builder->groupEnd();
        }


        //$this->db->stop_cache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
        $query = $builder->get();

        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$this->db->flush_cache();
//		$query = $this->db->getLastQuery();
//		echo (string)$query;
        return json_encode($result);
    }

    public function getManagementCommitteeResponsibilitiesData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_management_committee_muliple_responsibilities as tmcmr');
        $builder->select("tmcmr.management_committee_muliple_responsibilities_id,tmcmr.	management_committee_responsibilities_id,tmcmr.management_committee_id");
        $builder->select("tmcr.management_committee_responsibilities_name");
        $builder->join('tbl_management_committee tmc', 'tmc.management_committee_id = tmcmr.management_committee_id', 'left');
        $builder->join('tbl_management_committee_responsibilities tmcr', 'tmcr.management_committee_responsibilities_id = tmcmr.management_committee_responsibilities_id', 'left');

        if(isset($filterData['management_committee_id']) && !empty($filterData['management_committee_id'])) {
            if (is_array($filterData['management_committee_id'])) {
                $builder->whereIn('tmcmr.management_committee_id', $filterData['management_committee_id']);
            } else {
                $builder->where('tmcmr.management_committee_id', $filterData['management_committee_id']);
            }
        }

        // if (isset($filterData['management_committee_image_id']) && $filterData['management_committee_image_id'] != '') {
        //     $builder->where("tmi.management_committee_image_id", $filterData['management_committee_image_id']);
        // }

        $builder->orderBy("tmcmr.management_committee_id");

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }

        return $query;
    }

    public function deleteResponsibilitiesRecord($managementcommitteeId){
        $builder = $this->db->table('tbl_management_committee_muliple_responsibilities');
        $managementcommitteeIdArray = is_array($managementcommitteeId) ? $managementcommitteeId : array($managementcommitteeId);
        $builder->whereIn('management_committee_id', $managementcommitteeIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}