<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class MakeModel extends BaseModel
{

    public function getMakeData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_make as tm');
        $builder->select("tm.*");

        if(isset($filterData['make_id']) && !empty($filterData['make_id'])) {
            if (is_array($filterData['make_id'])) {
                $builder->whereIn('tm.make_id', $filterData['make_id']);
            } else {
                $builder->where('tm.make_id', $filterData['make_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tm.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('make_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tm.make_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($makeId)
    {
        $builder = $this->db->table('tbl_make');
        $makeIdArray = is_array($makeId) ? $makeId : array($makeId);
        $builder->whereIn('make_id', $makeIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($makeId)){
                foreach($makeId as $make){
                    $deleteDataArray['module'] = 'Make';
                    $deleteDataArray['activity'] = "Make Deleted";
                    $deleteDataArray['module_id'] = $make;
                    logActivity('Make Deleted [MakeID: ' . $make . ']',$this->ionAuth->getUserId(),'Make',$make,json_encode($deleteDataArray),'','Make',$make);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getMake($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_make as tm');
        //$builder->startCache();
        $builder->select("tm.make_id as id,COALESCE(tm.make_name,'') as text");

        if(isset($filterData['make_id']) && !empty($filterData['make_id'])) {
            if (is_array($filterData['make_id'])) {
                $builder->whereIn('tm.make_id', $filterData['make_id']);
            } else {
                $builder->where('tm.make_id', $filterData['make_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tm.society_id', $filterData['society_id']);
            } else {
                $builder->where('tm.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tm.make_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tm.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResultm(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}