<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ItemModel extends BaseModel
{

    public function getItemData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_item as ti');
        $builder->select("ti.*,COALESCE(tm.manufacturer_name,'') as manufacturer_name,COALESCE(tca.common_area_name,'') as common_area_name");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join("tbl_manufacturer as tm","tm.manufacturer_id = ti.manufacturer_id","left");
        $builder->join("tbl_common_area as tca","tca.common_area_id = ti.common_area_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ti.updated_by AND tupdate.society_id = ti.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = ti.created_by AND tcreate.society_id = ti.society_id","left");

        if (isset($filterData['item_id']) && !empty($filterData['item_id'])) {
            if (is_array($filterData['item_id'])) {
                $builder->whereIn('ti.item_id', $filterData['item_id']);
            } else {
                $builder->where('ti.item_id', $filterData['item_id']);
            }
        }
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('ti.society_id', $filterData['society_id']);
            } else {
                $builder->where('ti.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('ti.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if (isset($filterData['search']) && $filterData['search'] != '') {
            $builder->groupStart();
            $builder->like('ti.item_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('ti.item_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($itemId)
    {

        $itemIdArray = is_array($itemId) ? $itemId : array($itemId);
        $builder = $this->db->table('tbl_item_image');
        $builder->whereIn('item_id', $itemIdArray);
        $builder->delete();

        $builder = $this->db->table('tbl_item');
        $builder->whereIn('item_id', $itemIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($itemId)){
                foreach($itemId as $item){
                    $deleteDataArray['module'] = 'Item';
                    $deleteDataArray['activity'] = "Item Deleted";
                    $deleteDataArray['module_id'] = $item;
                    logActivity('Item Deleted [ItemID: ' . $item . ']',$this->ionAuth->getUserId(),'Item',$item,json_encode($deleteDataArray),'','Item',$item);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getItem($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_item as ti');
        //$builder->startCache();
        $builder->select("ti.item_id as id,COALESCE(ti.item_name,'') as text,COALESCE(tm.manufacturer_name,'') as manufacturer_name,ti.manufacturer_id,date_format(ti.warranty_period_to,'".DATE_FORMATE_MYSQL."') as warranty_period_to,date_format(ti.warranty_period_from,'".DATE_FORMATE_MYSQL."') as warranty_period_from");
        $builder->select("COALESCE(ti.item_name,'') as item_name");
        $builder->join("tbl_manufacturer as tm","tm.manufacturer_id = ti.manufacturer_id","left");

        if (isset($filterData['item_id']) && !empty($filterData['item_id'])) {
            if (is_array($filterData['item_id'])) {
                $builder->whereIn('ti.item_id', $filterData['item_id']);
            } else {
                $builder->where('ti.item_id', $filterData['item_id']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('ti.society_id', $filterData['society_id']);
            } else {
                $builder->where('ti.society_id', $filterData['society_id']);
            }
        }

        accessFilter($builder, array("society" => "ti.society_id"));
        $builder->groupBy("ti.item_id");
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(ti.item_name,'')", $filterData['filter_param'], 'both');
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('ti.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function getItemImageData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_item_image as tii');
        $builder->select("tii.item_image_id, tii.item_image,tii.item_id");
        $builder->join('tbl_item tm', 'tm.item_id = tii.item_id', 'left');

        if(isset($filterData['item_id']) && !empty($filterData['item_id'])) {
            if (is_array($filterData['item_id'])) {
                $builder->whereIn('tii.item_id', $filterData['item_id']);
            } else {
                $builder->where('tii.item_id', $filterData['item_id']);
            }
        }

        if (isset($filterData['item_image_id']) && $filterData['item_image_id'] != '') {
            $builder->where("tii.item_image_id", $filterData['item_image_id']);
        }

        $builder->orderBy("tii.item_id");

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }

        return $query;
    }

    public function deleteItemImage($itemImageId)
    {
        $builder = $this->db->table('tbl_item_image');
        $itemImageIdArray = is_array($itemImageId) ? $itemImageId : array($itemImageId);
        $builder->whereIn('item_image_id', $itemImageIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}