<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;

class ItemLedgerModel extends BaseModel{

    public function getItemLedgerData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_item_ledger as til');
        $builder->select("til.*");

        if(isset($filterData['item_ledger_id']) && !empty($filterData['item_ledger_id'])) {
            if (is_array($filterData['item_ledger_id'])) {
                $builder->whereIn('til.item_ledger_id', $filterData['item_ledger_id']);
            } else {
                $builder->where('til.item_ledger_id', $filterData['item_ledger_id']);
            }
        }

        if(isset($filterData['item_id']) && !empty($filterData['item_id'])) {
            if (is_array($filterData['item_id'])) {
                $builder->whereIn('til.item_id', $filterData['item_id']);
            } else {
                $builder->where('til.item_id', $filterData['item_id']);
            }
        }

        if(isset($filterData['common_area_id']) && !empty($filterData['common_area_id'])) {
            if (is_array($filterData['common_area_id'])) {
                $builder->whereIn('til.common_area_id', $filterData['common_area_id']);
            } else {
                $builder->where('til.common_area_id', $filterData['common_area_id']);
            }
        }

        if (isset($filterData['is_quantity_check'])){
            $builder->where('til.actual_quantity >', '0');

        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('item_id', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
    
}