<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;

class ItemBalanceModel extends BaseModel{

    public function getItemBalanceData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_item_balance as tib');
        $builder->select("tib.*");
        $builder->select("ti.item_name");
        $builder->select("tca.common_area_name");
        $builder->join("tbl_item as ti","ti.item_id = tib.item_id","left");
        $builder->join("tbl_common_area as tca","tca.common_area_id = tib.common_area_id","left");

        if(isset($filterData['item_balance_id']) && !empty($filterData['item_balance_id'])) {
            if (is_array($filterData['item_balance_id'])) {
                $builder->whereIn('tib.item_balance_id', $filterData['item_balance_id']);
            } else {
                $builder->where('tib.item_balance_id', $filterData['item_balance_id']);
            }
        }

        if(isset($filterData['item_id']) && !empty($filterData['item_id'])) {
            if (is_array($filterData['item_id'])) {
                $builder->whereIn('tib.item_id', $filterData['item_id']);
            } else {
                $builder->where('tib.item_id', $filterData['item_id']);
            }
        }

        if(isset($filterData['common_area_id']) && !empty($filterData['common_area_id'])) {
            if (is_array($filterData['common_area_id'])) {
                $builder->whereIn('tib.common_area_id', $filterData['common_area_id']);
            } else {
                $builder->where('tib.common_area_id', $filterData['common_area_id']);
            }
        }

        if (isset($filterData['is_quantity_check'])){
            $builder->where('tib.actual_quantity >', '0');

        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('item_id', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
    
}