<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class IntercomModel extends BaseModel
{

    public function getIntercomData($filterData = array())
    {
    	$limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_intercom as ti');
        $builder->select("ti.*,ts.society_name,tf.flat_no,tt.tower_id,tt.tower_name,tca.common_area_name,concat(tt.tower_name,' - ',tf.flat_no) as tower_flat_name");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = ti.society_id","left");
		$builder->join("tbl_flat as tf","tf.flat_id = ti.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ti.updated_by AND tupdate.society_id = ti.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = ti.created_by AND tcreate.society_id = ti.society_id","left");
		$builder->join("tbl_common_area as tca","tca.common_area_id = ti.common_area_id","left");

        if(isset($filterData['intercom_id']) && !empty($filterData['intercom_id'])) {
            if (is_array($filterData['intercom_id'])) {
                $builder->whereIn('ti.intercom_id', $filterData['intercom_id']);
            } else {
                $builder->where('ti.intercom_id', $filterData['intercom_id']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('ti.society_id', $filterData['society_id']);
			} else {
				$builder->where('ti.society_id', $filterData['society_id']);
			}
		}

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('ts.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('intercom_type', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        accessFilter($builder, array("society" => "ti.society_id"));
        $builder->groupBy('ti.intercom_id');

        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($intercomId)
    {
        $builder = $this->db->table('tbl_intercom');
        $intercomIdArray = is_array($intercomId) ? $intercomId : array($intercomId);
        $builder->whereIn('intercom_id', $intercomIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($intercomId)){
                foreach($intercomId as $documentElement){
                    $deleteDataArray['module'] = 'Intercom';
                    $deleteDataArray['activity'] = "Intercom Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Intercom Deleted [IntercomID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Intercom',$documentElement,json_encode($deleteDataArray),'','Intercom',$documentElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function checkFlatIntercomNumberData($filterData = array())
	{
		
		$builder = $this->db->table('tbl_intercom as ti');
		$builder->select("(CASE 
								WHEN  
									ti.intercom_type ='flat' THEN concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') )
								WHEN
									ti.intercom_type ='common_area' THEN tca.common_area_name	
							END) as intercom_type_name");
		// $builder->from("tbl_intercom as ti");
		//$this->db->where('ti.is_active', 1);
		

		$builder->join("tbl_flat as tf","tf.flat_id = ti.flat_id AND ti.intercom_type='flat'","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		
		$builder->join("tbl_common_area as tca","tca.common_area_id = ti.common_area_id AND ti.intercom_type='common_area'","left");



		if (isset($filterData['intercom_id']) && !empty($filterData['intercom_id'])) {
			if (is_array($filterData['intercom_id'])) {
				$builder->whereNotIn('ti.intercom_id', $filterData['intercom_id']);
			} else {
				$builder->where('ti.intercom_id !=', $filterData['intercom_id']);
			}
		}

		if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('ti.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('ti.flat_id', $filterData['flat_id']);
			}
		}

		if (isset($filterData['common_area_id']) && !empty($filterData['common_area_id'])) {
			if (is_array($filterData['common_area_id'])) {
				$builder->whereIn('ti.common_area_id', $filterData['common_area_id']);
			} else {
				$builder->where('ti.common_area_id', $filterData['common_area_id']);
			}
		}


		if (isset($filterData['intercom_type']) && !empty($filterData['intercom_type'])) {
			if (is_array($filterData['intercom_type'])) {
				$builder->whereIn('ti.intercom_type', $filterData['intercom_type']);
			} else {
				$builder->where('ti.intercom_type', $filterData['intercom_type']);
			}
		}

		// if (isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
		// 	if (is_array($filterData['tower_id'])) {
		// 		$this->db->whereIn('tt.tower_id', $filterData['tower_id']);
		// 	} else {
		// 		$this->db->where('tt.tower_id', $filterData['tower_id']);
		// 	}
		// }


		if (isset($filterData['number']) && !empty($filterData['number'])) {
			if (is_array($filterData['number'])) {
				$builder->whereIn('ti.number', $filterData['number']);
			} else {
				$builder->where('ti.number', $filterData['number']);
			}
		}


	
		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('ti.society_id', $filterData['society_id']);
			} else {
				$builder->where('ti.society_id', $filterData['society_id']);
			}
		}
		
		accessFilter($builder, array("society" => "ti.society_id"));

		$builder->groupBy('ti.intercom_id');
        
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

}