<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class FinancialYearModel extends BaseModel
{

    public function getFinancialYearData($filterData = array())
    {

        $builder = $this->db->table('tbl_financial_year as tfy');
        $builder->select("tfy.*");

        if (isset($filterData['financial_year_id']) && !empty($filterData['financial_year_id'])) {
			if (is_array($filterData['financial_year_id'])) {
				$builder->whereIn('tfy.financial_year_id', $filterData['financial_year_id']);
			} else {
				$builder->where('tfy.financial_year_id', $filterData['financial_year_id']);
			}
		}

		if ( (isset($filterData['start_date']) && !empty($filterData['start_date']) )  && (isset($filterData['end_date']) && !empty($filterData['end_date']) )  ) {
			$builder->where("date_format(tfy.start_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$filterData['start_date']);
			$builder->where("date_format(tfy.end_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$filterData['end_date']);
		}

		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tfy.is_active', $filterData['is_active']);
		}
        
		$builder->groupBy('tfy.financial_year_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}
    
}