<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class FaqModel extends BaseModel
{

	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getFaqData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_faq as tf');
        $builder->select("tf.*,tc.category_name");
        $builder->join("tbl_category as tc","tc.category_id = tf.category_id","left");
		if (isset($filterData['faq_id']) && !empty($filterData['faq_id'])) {
			if (is_array($filterData['faq_id'])) {
				$builder->whereIn('tf.faq_id', $filterData['faq_id']);
			} else {
				$builder->where('tf.faq_id', $filterData['faq_id']);
			}
		}
		if (isset($filterData['category_id']) && !empty($filterData['category_id'])) {
			if (is_array($filterData['category_id'])) {
				$builder->whereIn('tf.category_id', $filterData['category_id']);
			} else {
				$builder->where('tf.category_id', $filterData['category_id']);
			}
		}
		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tf.society_id', $filterData['society_id']);
			} else {
				$builder->where('tf.society_id', $filterData['society_id']);
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('tf.faq_title', $filterData['search'], 'both');
			$builder->orLike('tc.category_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		$builder->orderBy("tf.sort_order",'desc');
		$builder->groupBy('tf.faq_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function getMediaData($filterData = array())
    {
    	$limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_media as tm');
        $builder->select("tm.*");
        $builder->join("tbl_faq as tf","tf.faq_id = tm.media_for_id AND tm.media_for = 'faq'","left");
        if(isset($filterData['media_id']) && $filterData['media_id'] != '') {
            if(is_array($filterData['media_id'])){
                $builder->whereIn('tm.media_id', $filterData['media_id']);
            } else {
                $builder->where('tm.media_id', $filterData['media_id']);
            }
        }
        if(isset($filterData['society_id']) && $filterData['society_id'] != '') {
            if(is_array($filterData['society_id'])){
                $builder->whereIn('tf.society_id', $filterData['society_id']);
            } else {
                $builder->where('tf.society_id', $filterData['society_id']);
            }
        }
        if(isset($filterData['category_id']) && $filterData['category_id'] != '') {
            if(is_array($filterData['category_id'])){
                $builder->whereIn('tf.category_id', $filterData['category_id']);
            } else {
                $builder->where('tf.category_id', $filterData['category_id']);
            }
        }
        if(isset($filterData['media_for']) && $filterData['media_for'] != '') {
            if(is_array($filterData['media_for'])){
                $builder->whereIn('tm.media_for', $filterData['media_for']);
            } else {
                $builder->where('tm.media_for', $filterData['media_for']);
            }
        }
        if(isset($filterData['media_for_id']) && $filterData['media_for_id'] != '') {
            if(is_array($filterData['media_for_id'])){
                $builder->whereIn('tm.media_for_id', $filterData['media_for_id']);
            } else {
                $builder->where('tm.media_for_id', $filterData['media_for_id']);
            }
        }
        if (isset($filterData['search']) && $filterData['search'] != '') {
            $builder->groupStart();
            $builder->like('tm.media_title', $filterData['search'], 'both');
            $builder->groupEnd();
        }
        if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
        $builder->orderBy("tm.media_sort_order",'desc');
        $builder->groupBy('tm.media_id');
        $query = $builder->get();
        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)) {
            $result = $query->getResultArray();
        } else {
            $result = $query->getRowArray();
        }
        return $result;
    }

    public function deleteRecord($faqId)
    {
        $faqIdArray = is_array($faqId) ? $faqId : array($faqId);
        $builder = $this->db->table('tbl_faq');
        $builder->whereIn('faq_id', $faqIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($faqId)){
                foreach($faqId as $faqElement){
                    $deleteDataArray['module'] = 'Faq';
                    $deleteDataArray['activity'] = "Faq Deleted";
                    $deleteDataArray['module_id'] = $faqElement;
                    logActivity('Faq Deleted [FaqID: ' . $faqElement . ']',$this->ionAuth->getUserId(),'Faq',$faqElement,json_encode($deleteDataArray),'','Faq',$faqElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}
?>
