<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;

class EmergencyContactModel extends BaseModel{

    public function getEmergencyContactData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_emergency_number as ten');
        $builder->select("ten.*,ts.society_name");

        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ten.updated_by AND tupdate.society_id = ten.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = ten.created_by AND tcreate.society_id = ten.society_id","left");
        $builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = ten.society_id","left");

        if(isset($filterData['emergency_number_id']) && !empty($filterData['emergency_number_id'])) {
            if (is_array($filterData['emergency_number_id'])) {
                $builder->whereIn('ten.emergency_number_id', $filterData['emergency_number_id']);
            } else {
                $builder->where('ten.emergency_number_id', $filterData['emergency_number_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('ten.society_id', $filterData['society_id']);
            } else {
                $builder->where('ten.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['is_active'])){
            $builder->where('ten.is_active', $filterData['is_active']);
        }

        if(isset($filterData['is_deleted'])){
            $builder->where('ten.is_deleted', $filterData['is_deleted']);
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
    
    public function deleteRecord($emergencyNumberId,$userId)
	{
		$builder = $this->db->table('tbl_emergency_number');
        $emergencyNumberIdArray = is_array($emergencyNumberId) ? $emergencyNumberId : array($emergencyNumberId);
        $builder->whereIn('emergency_number_id', $emergencyNumberIdArray);
        $data = [
			'is_deleted' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $userId,
		];
        $builder->update($data);
		if ($this->db->affectedRows()) {
			if(!empty($emergencyNumberId)){
				foreach($emergencyNumberId as $documentElement){
					$deleteDataArray['module'] = 'Emergency Contact';
					$deleteDataArray['activity'] = "Emergency Contact Deleted";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('EmergencyContact Deleted [EmergencyContactID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'EmergencyContact',$documentElement,json_encode($deleteDataArray),'','EmergencyContact',$documentElement);
				}
			}
			return true;
		}
		return false;
	}
}