<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class DocumentModel extends BaseModel
{
    public function getDocumentData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_document as td');
        $builder->select("td.*");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = td.updated_by AND tupdate.society_id = td.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = td.created_by AND tcreate.society_id = td.society_id","left");
        $builder->join("tbl_document_for as tdf","tdf.document_id = td.document_id","left");
        accessFilter($builder, array("society" => "td.society_id"));
        if (isset($filterData['document_id']) && !empty($filterData['document_id'])) {
            if (is_array($filterData['document_id'])) {
                $builder->whereIn('td.document_id', $filterData['document_id']);
            } else {
                $builder->where('td.document_id', $filterData['document_id']);
            }
        }
        if (isset($filterData['document_for']) && !empty($filterData['document_for'])) {
            if (is_array($filterData['document_for'])) {
                $builder->whereIn('tdf.document_for', $filterData['document_for']);
            } else {
                $builder->where('tdf.document_for', $filterData['document_for']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('td.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('document_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('td.document_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($documentId)
    {
        $builder = $this->db->table('tbl_document');
        $documentIdArray = is_array($documentId) ? $documentId : array($documentId);
        $builder->whereIn('document_id', $documentIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($documentId)){
                foreach($documentId as $document){
                    $deleteDataArray['module'] = 'Document';
                    $deleteDataArray['activity'] = "Document Deleted";
                    $deleteDataArray['module_id'] = $document;
                    logActivity('Document Deleted [DocumentID: ' . $document . ']',$this->ionAuth->getUserId(),'Document',$document,json_encode($deleteDataArray),'','Document',$document);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getDocument($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_document as td');
        //$builder->startCache();
        $builder->select("td.document_id as id,COALESCE(td.document_name,'') as text");

        if(isset($filterData['document_id']) && !empty($filterData['document_id'])) {
            if (is_array($filterData['document_id'])) {
                $builder->whereIn('td.document_id', $filterData['document_id']);
            } else {
                $builder->where('td.document_id', $filterData['document_id']);
            }
        }

        if(isset($filterData['document_for']) && !empty($filterData['document_for'])) {
            if (is_array($filterData['document_for'])) {
                $builder->whereIn('td.document_for', $filterData['document_for']);
            } else {
                $builder->whereIn('td.document_for', $filterData['document_for']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(td.document_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('td.is_active', $filterData['is_active']);
        }
        accessFilter($builder, array("society" => "td.society_id"));
        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function getDocumentForData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_document_for as tdf');
        $builder->select("tdf.document_for_id, tdf.document_id,tdf.document_for");
        $builder->join('tbl_document td','td.document_id = tdf.document_id','left');
        if (isset($filterData['document_id']) && !empty($filterData['document_id'])) {
            if (is_array($filterData['document_id'])) {
                $builder->whereIn('tdf.document_id', $filterData['document_id']);
            } else {
                $builder->where('tdf.document_id', $filterData['document_id']);
            }
        }

        $builder->orderBy('tdf.document_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function deleteDocumentForRecord($documentId)
    {
        $builder = $this->db->table('tbl_document_for');
        $documentIdArray = is_array($documentId) ? $documentId : array($documentId);
        $builder->whereIn('document_id', $documentIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}