<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class DocumentFolderModel extends BaseModel
{
    public function getDocumentFolderData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_document_folder as tdf');
        $builder->select("tdf.*");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tdf.updated_by AND tupdate.society_id = tdf.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tdf.created_by AND tcreate.society_id = tdf.society_id","left");
        $builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tdf.society_id","left");
        if (isset($filterData['document_folder_id']) && !empty($filterData['document_folder_id'])) {
            if (is_array($filterData['document_folder_id'])) {
                $builder->whereIn('tdf.document_folder_id', $filterData['document_folder_id']);
            } else {
                $builder->where('tdf.document_folder_id', $filterData['document_folder_id']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tdf.society_id', $filterData['society_id']);
            } else {
                $builder->where('tdf.society_id', $filterData['society_id']);
            }
        }
        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        
        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }
        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('tdf.folder_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }
        $builder->groupBy('tdf.document_folder_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getDocumentFolderItemData($filterData)
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_document_folder_item as trwd');
        $builder->select("trwd.*");
        $builder->select("tdi.document_image as document_image");
        $builder->join("tbl_document_image as tdi","tdi.document_type_id = trwd.document_folder_item_id AND tdi.document_type = 'document_folder'","left");
       
        if(isset($filterData['document_folder_id']) && !empty($filterData['document_folder_id'])) {
            if (is_array($filterData['document_folder_id'])) {
                $builder->whereIn('trwd.document_folder_id', $filterData['document_folder_id']);
            } else {
                $builder->where('trwd.document_folder_id', $filterData['document_folder_id']);
            }
        }

        if(isset($filterData['document_folder_item_id']) && !empty($filterData['document_folder_item_id'])) {
            if (is_array($filterData['document_folder_item_id'])) {
                $builder->whereIn('trwd.document_folder_item_id', $filterData['document_folder_item_id']);
            } else {
                $builder->where('trwd.document_folder_item_id', $filterData['document_folder_item_id']);
            }
        }
        $builder->orderBy("trwd.document_folder_item_id");
        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function deleteRecord($documentFolderId) {

        $documentFolderIdArray = is_array($documentFolderId) ? $documentFolderId : array($documentFolderId);

        $builderDocumentFolderItem = $this->db->table('tbl_document_folder_item');
        $builderDocumentFolderItem->whereIn('document_folder_id', $documentFolderIdArray);
        $builderDocumentFolderItem->delete();

        $builder = $this->db->table('tbl_document_folder');
		$builder->whereIn('document_folder_id', $documentFolderIdArray);
		$builder->delete();

        if ($this->db->affectedRows()) {

			if(!empty($documentFolderId)){
				foreach($documentFolderId as $documentElement){
					$deleteDataArray['module'] = 'Document Folder';
					$deleteDataArray['activity'] = "Document Folder Deleted";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('Document Folder Deleted [DocumentFolderID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Document Folder',$documentElement,json_encode($deleteDataArray),'','Document Folder',$documentElement);
				}
			}
			return true;
		}
		return false;
    }

    public function deleteDocumentFolderItemRecord($documentFolderItemId) {

        $documentFolderItemIdArray = is_array($documentFolderItemId) ? $documentFolderItemId : array($documentFolderItemId);

        $builder = $this->db->table('tbl_document_folder_item');
		$builder->whereIn('document_folder_item_id', $documentFolderItemIdArray);
		$builder->delete();

        if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
    }
}