<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class CommonAreaModel extends BaseModel
{

    public function getCommonAreaData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_common_area as tca');
        $builder->select("tca.*");

        if(isset($filterData['common_area_id']) && !empty($filterData['common_area_id'])) {
            if (is_array($filterData['common_area_id'])) {
                $builder->whereIn('tca.common_area_id', $filterData['common_area_id']);
            } else {
                $builder->where('tca.common_area_id', $filterData['common_area_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tca.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('common_area_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tca.common_area_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($commonAreaId)
    {
        $builder = $this->db->table('tbl_common_area');
        $commonAreaIdArray = is_array($commonAreaId) ? $commonAreaId : array($commonAreaId);
        $builder->whereIn('common_area_id', $commonAreaIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($commonAreaId)){
                foreach($commonAreaId as $commonArea){
                    $deleteDataArray['module'] = 'Common Area';
                    $deleteDataArray['activity'] = "Common Area Deleted";
                    $deleteDataArray['module_id'] = $commonArea;
                    logActivity('Common Area Deleted [SocietyID: ' . $commonArea . ']',$this->ionAuth->getUserId(),'Common Area',$commonArea,json_encode($deleteDataArray),'','Common Area',$commonArea);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getCommonArea($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_common_area as tca');
        //$builder->startCache();
        $builder->select("tca.common_area_id as id,COALESCE(tca.common_area_name,'') as text");

        if(isset($filterData['common_area_id']) && !empty($filterData['common_area_id'])) {
            if (is_array($filterData['common_area_id'])) {
                $builder->whereIn('tca.common_area_id', $filterData['common_area_id']);
            } else {
                $builder->where('tca.common_area_id', $filterData['common_area_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tca.common_area_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tca.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResultca(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}