<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ChargesModel extends BaseModel
{

    public function getChargesData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_charges as tc');
        $builder->select("tc.*,tt.tax_name");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join("tbl_tax as tt","tt.tax_id = tc.tax_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tc.updated_by AND tupdate.society_id = tc.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tc.created_by AND tcreate.society_id = tc.society_id","left");

        if (isset($filterData['charges_id']) && !empty($filterData['charges_id'])) {
            if (is_array($filterData['charges_id'])) {
                $builder->whereIn('tc.charges_id', $filterData['charges_id']);
            } else {
                $builder->where('tc.charges_id', $filterData['charges_id']);
            }
        }
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tc.society_id', $filterData['society_id']);
            } else {
                $builder->where('tc.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tc.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        $builder->groupBy('tc.charges_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($chargesId)
    {
        $builder = $this->db->table('tbl_charges');
        $chargesIdArray = is_array($chargesId) ? $chargesId : array($chargesId);
        $builder->whereIn('charges_id', $chargesIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($chargesId)){
                foreach($chargesId as $charges){
                    $deleteDataArray['module'] = 'Charges';
                    $deleteDataArray['activity'] = "Charges Deleted";
                    $deleteDataArray['module_id'] = $charges;
                    logActivity('Charges Deleted [ChargesID: ' . $charges . ']',$this->ionAuth->getUserId(),'Charges',$charges,json_encode($deleteDataArray),'','Charges',$charges);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function checkChargesNameExist($filterData = array())
    {

        $builder = $this->db->table('tbl_charges as tc');
        $builder->select("tc.*");

        if(isset($filterData['charges_id']) && !empty($filterData['charges_id'])) {
            if (is_array($filterData['charges_id'])) {
                $builder->whereNotIn('tc.charges_id', $filterData['charges_id']);
            } else {
                $builder->where('tc.charges_id !=', $filterData['charges_id']);
            }
        }
        if(isset($filterData['fee_type']) && !empty($filterData['fee_type'])) {
            if (is_array($filterData['fee_type'])) {
                $builder->whereIn('tc.fee_type', $filterData['fee_type']);
            } else {
                $builder->where('tc.fee_type', $filterData['fee_type']);
            }
        }
        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tc.society_id', $filterData['society_id']);
            } else {
                $builder->where('tc.society_id', $filterData['society_id']);
            }
        }
        if(isset($filterData['charges_name']) && !empty($filterData['charges_name'])) {
            if (is_array($filterData['charges_name'])) {
                $builder->whereIn('tc.charges_name', $filterData['charges_name']);
            } else {
                $builder->where('tc.charges_name', $filterData['charges_name']);
            }
        }
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
}