<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class CategoryModel extends BaseModel
{
	public function getCategoryData($filterData = array())
	{
		$societyId = isset($filterData['society_id']) ? $filterData['society_id'] : 0;
		$limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_category as tc');
        $builder->select("tc.*");
        // $builder->select("(select count(*) from tbl_resource as tr where tr.category_id = tc.category_id AND tr.society_id = '". $societyId ."') as resource_count");

		if(isset($filterData['category_id']) && !empty($filterData['category_id'])) {
			if (is_array($filterData['category_id'])) {
				$builder->whereIn('tc.category_id', $filterData['category_id']);
			} else {
				$builder->where('tc.category_id', $filterData['category_id']);
			}
		}

		if(isset($filterData['category_for']) && !empty($filterData['category_for'])) {
			if (is_array($filterData['category_for'])) {
				$builder->whereIn('tc.category_for', $filterData['category_for']);
			} else {
				$builder->where('tc.category_for', $filterData['category_for']);
			}
		}

		if(isset($filterData['category_name']) && !empty($filterData['category_name'])) {
			if (is_array($filterData['category_name'])) {
				$builder->whereIn('tc.category_name', $filterData['category_name']);
			} else {
				$builder->where('tc.category_name', $filterData['category_name']);
			}
		}

		if(isset($filterData['start'])){
			if($filterData['start'] != '-1'){
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if(isset($filterData['is_active'])){
			$builder->where('tc.is_active', $filterData['is_active']);
		}
		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();
			$builder->like('tc.category_name', $filterData['search'], 'both');
			$builder->groupEnd();

		}

		$builder->groupBy('tc.category_id');

		if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		}else{
			$queryData = $builder->get()->getRowArray();
		}
		//lastQuery();

		return $queryData;
	}



	function getCategory($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_category as tc');
        //$builder->startCache();
        $builder->select("tc.category_id as id,COALESCE(tc.category_name,'') as text");

        if(isset($filterData['category_id']) && !empty($filterData['category_id'])) {
            if (is_array($filterData['category_id'])) {
                $builder->whereIn('tc.category_id', $filterData['category_id']);
            } else {
                $builder->where('tc.category_id', $filterData['category_id']);
            }
        }

        if(isset($filterData['category_for']) && !empty($filterData['category_for'])) {
            if (is_array($filterData['category_for'])) {
                $builder->whereIn('tc.category_for', $filterData['category_for']);
            } else {
                $builder->where('tc.category_for', $filterData['category_for']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tc.category_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tc.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function checkCategoryNameExist($filterData = array())
    {

        $builder = $this->db->table('tbl_category as tc');
        $builder->select("tc.*");

        if(isset($filterData['category_id']) && !empty($filterData['category_id'])) {
            if (is_array($filterData['category_id'])) {
                $builder->whereNotIn('tc.category_id', $filterData['category_id']);
            } else {
                $builder->where('tc.category_id !=', $filterData['category_id']);
            }
        }
        if(isset($filterData['category_for']) && !empty($filterData['category_for'])) {
            if (is_array($filterData['category_for'])) {
                $builder->whereIn('tc.category_for', $filterData['category_for']);
            } else {
                $builder->where('tc.category_for', $filterData['category_for']);
            }
        }
        if(isset($filterData['category_name']) && !empty($filterData['category_name'])) {
            if (is_array($filterData['category_name'])) {
                $builder->whereIn('tc.category_name', $filterData['category_name']);
            } else {
                $builder->where('tc.category_name', $filterData['category_name']);
            }
        }
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function deleteRecord($categoryId)
	{
		$builder = $this->db->table('tbl_category');
        $categoryIdArray = is_array($categoryId) ? $categoryId : array($categoryId);
        $builder->whereIn('category_id', $categoryIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {

			if(!empty($categoryId)){
				foreach($categoryId as $category){
					$deleteDataArray['module'] = 'Category';
            		$deleteDataArray['activity'] = "Category Deleted";
					$deleteDataArray['module_id'] = $category;
					logActivity('Category Deleted [CategoryID: ' . $category . ']',$this->ionAuth->getUserId(),'Category',$category,json_encode($deleteDataArray),'','Category',$category);
				}
			}
			return true;
		}
		return false;
	}
}
?>
