<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class BookingModel extends BaseModel
{
	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getBookingData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_booking as tb');
		//$builder->select("tb.*,concat(tt.tower_name,' - ',tf.flat_no) as tower_flat_name, ta.amenities_name, tts.time_slot_name");
		$builder->select("tb.*,concat(tt.tower_name,' - ',tf.flat_no) as tower_flat_name,COALESCE(tau.unit_name,'') as amenities_unit_name,ta.amenities_name,tb.status,ta.contact_person_name,ta.contact_phone_number,tca.common_area_name,ta.payment_required,ta.cancel_before,ta.cancel_before_type");
		$builder->select("concat(DATE_FORMAT(tb.start_time, '%H:%i'), ' - ', DATE_FORMAT(tb.end_time, '%H:%i')) as time_slot_name,tm.name,tau.unit_name");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
       		$builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->join("tbl_flat as tf","tf.flat_id = tb.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tb.ownership_flat_member_id","left");
		$builder->join("tbl_amenities as ta","ta.amenities_id = tb.amenities_id","left");
		$builder->join("tbl_amenities_common_area as taca","taca.amenities_id = ta.amenities_id","left");
		$builder->join("tbl_common_area as tca","tca.common_area_id = taca.common_area_id","left");
		$builder->join("tbl_amenities_unit as tau","tau.amenities_unit_id = tb.amenities_unit_id","left");
		//$builder->join("tbl_time_slot as tts","tts.time_slot_id = tb.time_slot_id","left");
		$builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tb.updated_by AND tupdate.society_id = tb.society_id","left");
        	$builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tb.created_by AND tcreate.society_id = tb.society_id","left");
        	$builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
        
		if (isset($filterData['booking_id']) && !empty($filterData['booking_id'])) {
			if (is_array($filterData['booking_id'])) {
				$builder->whereIn('tb.booking_id', $filterData['booking_id']);
			} else {
				$builder->where('tb.booking_id', $filterData['booking_id']);
			}
		}
		if (isset($filterData['time_slot_id']) && !empty($filterData['time_slot_id'])) {
			if (is_array($filterData['time_slot_id'])) {
				$builder->whereIn('tb.time_slot_id', $filterData['time_slot_id']);
			} else {
				$builder->where('tb.time_slot_id', $filterData['time_slot_id']);
			}
		}
		if (isset($filterData['booking_id_not']) && !empty($filterData['booking_id_not'])) {
			if (is_array($filterData['booking_id_not'])) {
				$builder->whereNotIn('tb.booking_id', $filterData['booking_id_not']);
			} else {
				$builder->where('tb.booking_id !=', $filterData['booking_id_not']);
			}
		}
		if (isset($filterData['booking_date']) && !empty($filterData['booking_date'])) {
			if (is_array($filterData['booking_date'])) {
				$builder->whereIn('tb.booking_date', $filterData['booking_date']);
			} else {
				$builder->where('tb.booking_date', $filterData['booking_date']);
			}
		}
		if (isset($filterData['current_date_time']) && !empty($filterData['current_date_time'])) {
			$builder->where("CONCAT(tb.booking_date, ' ', tb.end_time) < ", $filterData['current_date_time']);
		}
		if (isset($filterData['amenities_unit_id']) && !empty($filterData['amenities_unit_id'])) {
			if (is_array($filterData['amenities_unit_id'])) {
				$builder->whereIn('tb.amenities_unit_id', $filterData['amenities_unit_id']);
			} else {
				$builder->where('tb.amenities_unit_id', $filterData['amenities_unit_id']);
			}
		}

		if(isset($filterData['start_date']) && $filterData['start_date'] != $filterData['end_date']){
			if (isset($filterData['start_date']) && !empty($filterData['start_date'])) {
				if (is_array($filterData['start_date'])) {
					$builder->whereIn('tb.booking_date  >=', $filterData['start_date']);
				} else {
					$builder->where('tb.booking_date  >=', $filterData['start_date']);
					$builder->where('tb.booking_date  <=', $filterData['end_date']);
				}
			}
		}

		if(isset($filterData['start_date']) && $filterData['start_date'] == $filterData['end_date']){
			if (isset($filterData['start_date']) && !empty($filterData['start_date'])) {
				if (is_array($filterData['start_date'])) {
					$builder->whereIn('tb.booking_date', $filterData['start_date']);
				} else {
					$builder->where('tb.booking_date', $filterData['start_date']);
				}
			}
		}

		if(isset($filterData['start_month']) && $filterData['start_month'] != '') {
			$builder->where('month(tb.booking_date)', $filterData['start_month']);
		}

		if(isset($filterData['start_year']) && $filterData['start_year'] != '') {
			$builder->where('year(tb.booking_date)', $filterData['start_year']);
		}

		if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tb.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tb.flat_id', $filterData['flat_id']);
			}
		}
		if (isset($filterData['amenities_id']) && !empty($filterData['amenities_id'])) {
			if (is_array($filterData['amenities_id'])) {
				$builder->whereIn('tb.amenities_id', $filterData['amenities_id']);
			} else {
				$builder->where('tb.amenities_id', $filterData['amenities_id']);
			}
		}

		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tb.society_id', $filterData['society_id']);
			} else {
				$builder->where('tb.society_id', $filterData['society_id']);
			}
		}

		if (isset($filterData['start_time']) && !empty($filterData['start_time'])) {
			if (is_array($filterData['start_time'])) {
				$builder->whereIn('tb.start_time', $filterData['start_time']);
			} else {
				$builder->where('tb.start_time', $filterData['start_time']);
			}
		}

		if (isset($filterData['end_time']) && !empty($filterData['end_time'])) {
			if (is_array($filterData['end_time'])) {
				$builder->whereIn('tb.end_time', $filterData['end_time']);
			} else {
				$builder->where('tb.end_time', $filterData['end_time']);
			}
		}
		
		if (isset($filterData['status']) && !empty($filterData['status'])) {
			if (is_array($filterData['status'])) {
				$builder->whereIn('tb.status', $filterData['status']);
			} else {
				$builder->where('tb.status', $filterData['status']);
			}
		}

		// if (isset($filterData['start_time']) && isset($filterData['end_time'])) {
		// 	$builder->where(" ((tb.start_time >='".$filterData['start_time']."' AND tb.start_time <='".$filterData['end_time']."') OR (tb.end_time >='".$filterData['start_time']."' AND tb.end_time <='".$filterData['end_time']."') OR (tb.start_time <='".$filterData['start_time']."' AND tb.end_time >='".$filterData['end_time']."'))",null,false );
		// }

		if (isset($filterData['start'])) {
			if ($filterData['start'] != '1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('tb.booking_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tb.is_active', $filterData['is_active']);
		}
		$builder->groupBy('tb.booking_id');
		if(isset($filterData['is_api'])){
			accessFilter($builder, array("society" => "tb.society_id"),1,array("society_id" => isset($filterData['society_id']) ? $filterData['society_id'] : 0));
		} else  {
			accessFilter($builder, array("society" => "tb.society_id"));
		}

		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
//		 lastQuery();
		return $queryData;
	}


	public function getMyBookingData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_booking as tb');
		$builder->select("tb.*, COALESCE(ta.amenities_name,'') as amenities_name,GROUP_CONCAT(tcm.common_area_name SEPARATOR ',') as common_area_name,ta.contact_person_name,ta.contact_phone_number,ta.admin_approval_required");
		$builder->select("COALESCE(tau.unit_name,'') as amenities_unit_name,COALESCE(tm.name,'') as member_name,COALESCE(tus.phone,'') as member_contact_no,concat(tt.tower_name,' - ',tf.flat_no) as tower_flat_name");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as update_by_name");
		//$builder->join("tbl_amenities as ta","ta.amenities_id = tb.amenities_id AND ta.type = 'amenities'","left");
		$builder->join("tbl_amenities as ta","ta.amenities_id = tb.amenities_id ","left");
		$builder->join("tbl_amenities_common_area as tacm","tacm.amenities_id = ta.amenities_id","left");
		$builder->join("tbl_common_area as tcm","tcm.common_area_id = tacm.common_area_id","left");
		$builder->join("tbl_amenities_unit as tau","tau.amenities_unit_id = tb.amenities_unit_id","left");
		$builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tb.ownership_flat_member_id","left");
		$builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tb.updated_by AND tupdate.society_id = tb.society_id","left");
		$builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
		$builder->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tofm.ownership_flat_id ","left");
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.type_id = tofm.member_id AND tus.resource_type_id = tofm.resource_type_id AND tus.society_id = tof.society_id","left");
		$builder->join("tbl_flat as tf","tf.flat_id = tb.flat_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");


		if (isset($filterData['booking_id']) && !empty($filterData['booking_id'])) {
			if (is_array($filterData['booking_id'])) {
				$builder->whereIn('tb.booking_id', $filterData['booking_id']);
			} else {
				$builder->where('tb.booking_id', $filterData['booking_id']);
			}
		}

		// if (isset($filterData['status']) && !empty($filterData['status'])) {
		// 	if($filterData['status'] == 'confirmed'){
		// 		$builder->where('tb.approved_by', $filterData['arrproved_by']);
		// 	} else {
		// 		$builder->where('tb.status', $filterData['status']);
		// 	}
		// }

		if (isset($filterData['status']) && !empty($filterData['status'])) {
			if (is_array($filterData['status'])) {
				$builder->whereIn('tb.status', $filterData['status']);
			} else {
				$builder->where('tb.status', $filterData['status']);
			}
		}


		if (isset($filterData['admin_approval_required']) && $filterData['admin_approval_required'] != 0) {
			if (is_array($filterData['admin_approval_required'])) {
				$builder->whereIn('ta.admin_approval_required', $filterData['admin_approval_required']);
			} else {
				$builder->where('ta.admin_approval_required', $filterData['admin_approval_required']);
			}
		}

		if (isset($filterData['booking_date']) && !empty($filterData['booking_date'])) {
			if (is_array($filterData['booking_date'])) {
				$builder->whereIn('tb.booking_date', $filterData['booking_date']);
			} else {
				$builder->where('tb.booking_date', $filterData['booking_date']);
			}
		}

		if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
			if (is_array($filterData['flat_id'])) {
				$builder->whereIn('tb.flat_id', $filterData['flat_id']);
			} else {
				$builder->where('tb.flat_id', $filterData['flat_id']);
			}
		}

		
		// if (isset($filterData['date_greater_than_equal_to']) && !empty($filterData['date_greater_than_equal_to'])) {
		// 	if (is_array($filterData['date_greater_than_equal_to'])) {
		// 		$builder->whereIn('DATE(tb.booking_date)  >= ', $filterData['date_greater_than_equal_to']);
		// 	} else {
		// 		$builder->where('DATE(tb.booking_date)  >= ', $filterData['date_greater_than_equal_to']);
		// 	}
		// }

		if (isset($filterData['amenities_id']) && !empty($filterData['amenities_id'])) {
			if (is_array($filterData['amenities_id'])) {
				$builder->whereIn('tb.amenities_id', $filterData['amenities_id']);
			} else {
				$builder->where('tb.amenities_id', $filterData['amenities_id']);
			}
		}

		if (isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
			if (is_array($filterData['ownership_flat_member_id'])) {
				$builder->whereIn('tb.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			} else {
				$builder->where('tb.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			}
		}
		if(isset($filterData['start_date']) && $filterData['start_date'] != $filterData['end_date']){
			if (isset($filterData['start_date']) && !empty($filterData['start_date'])) {
				if (is_array($filterData['start_date'])) {
					$builder->whereIn('tb.booking_date  >=', $filterData['start_date']);
				} else {
					$builder->where('tb.booking_date  >=', $filterData['start_date']);
					$builder->where('tb.booking_date  <=', $filterData['end_date']);
				}
			}
		}

		if(isset($filterData['start_date']) && $filterData['start_date'] == $filterData['end_date']){
			if (isset($filterData['start_date']) && !empty($filterData['start_date'])) {
				if (is_array($filterData['start_date'])) {
					$builder->whereIn('tb.booking_date', $filterData['start_date']);
				} else {
					$builder->where('tb.booking_date', $filterData['start_date']);
				}
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('booking_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tb.is_active', $filterData['is_active']);
		}
		$builder->orderBy('tb.booking_id','DESC');
		$builder->groupBy('tb.booking_id');
		accessFilter($builder, array("society" => "tb.society_id"),1,array('society_id' => $filterData['society_id']));
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
//		 lastQuery();
		return $queryData;
	}

	public function deleteRecord($bookingId)
	{
		$builder = $this->db->table('tbl_booking');
	        $bookingIdArray = is_array($bookingId) ? $bookingId : array($bookingId);
	        $builder->whereIn('booking_id', $bookingIdArray);
	        $builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($bookingId)){
				foreach($bookingId as $documentElement){
					$deleteDataArray['module'] = 'Booking';
					$deleteDataArray['activity'] = "Booking Deleted ";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('Booking Deleted [BookingID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Booking',$documentElement,json_encode($deleteDataArray),'','Booking',$documentElement);
				}
			}
			return true;
		}
		return false;
	}

	function getBooking($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		// $this->db->start_cache();
		$builder = $this->db->table('tbl_booking as tb');
		$builder->select("tb.booking_id as id,tb.booking_name as text,tb.booking_phone_number");
		$builder->where("tb.is_active", 1);
		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("tb.booking_name", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}
		// $builder->stop_cache();
		$totalRows = $builder->countAllResults(false);
        	$builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
		// $builder->flush_cache();
		return json_encode($result);
	}
}
?>
