<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ActivityLogModel extends BaseModel
{
    public function __construct()
    {
        parent::__construct();
        // Your own constructor code
    }

    public function deleteRecord($activityLogId)
    {

        $builder = $this->db->table('tbl_activity_log');
        $activityLogIdArray = is_array($activityLogId) ? $activityLogId : array($activityLogId);
        $builder->whereIn('activity_log_id', $activityLogIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }

    }

    public function getActivityLogData($filterData = array())
    {
        if(isset($filterData['limit'])){
            $limit = $filterData['limit'];
        } else {
            $limit = DATA_LIMIT;
        }
        $builder = $this->db->table('tbl_activity_log as tal');
        $builder->select("tal.*");
        if (isset($filterData['activity_log_id']) && !empty($filterData['activity_log_id'])) {
            if (is_array($filterData['activity_log_id'])) {
                $builder->whereIn('tal.activity_log_id', $filterData['activity_log_id']);
            } else {
                $builder->where('tal.activity_log_id', $filterData['activity_log_id']);
            }
        }
        if (isset($filterData['date']) && !empty($filterData['date'])) {
            list($fromDate, $toDate) = explode(" - ", $filterData['date']);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if (strtotime($fromDate) != strtotime($toDate)) {
                $builder->where("date_format(tal.date,'" . DATE_FORMATE_MYSQL_YMD . "') >= ", $fromDate);
                $builder->where("date_format(tal.date,'" . DATE_FORMATE_MYSQL_YMD . "') <= ", $toDate);
            } else {
                $builder->where("date_format(tal.date,'" . DATE_FORMATE_MYSQL_YMD . "') = ", $toDate);
            }
        }
        if (isset($filterData['module']) && !empty($filterData['module'])) {
            if (is_array($filterData['module'])) {
                $builder->whereIn('tal.module', $filterData['module']);
            } else {
                $builder->where('tal.module', $filterData['module']);
            }
        }
        if (isset($filterData['user_id']) && !empty($filterData['user_id'])) {
            if (is_array($filterData['user_id'])) {
                $builder->whereIn('tal.user_id', $filterData['user_id']);
            } else {
                $builder->where('tal.user_id', $filterData['user_id']);
            }
        }
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tal.society_id', $filterData['society_id']);
            } else {
                $builder->where('tal.society_id', $filterData['society_id']);
            }
        }
        if (isset($filterData['start'])) {
            if ($filterData['start'] != '-1') {
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        accessFilter($builder, array("society" => "tal.society_id"));
        $builder->orderBy("tal.activity_log_id",'desc');
        $builder->groupBy('tal.activity_log_id');
        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function writeCsvZipExport($name, $headerArr, $dataRows)
    {
//        printArray($dataRows,1);

        // create your zip file
        $zipname = $name.'.zip';
        $zippath = $zipname;
        $zip = new ZipArchive;
        $zip->open($zippath, ZipArchive::CREATE);

        $fd = fopen('php://temp/maxmemory:1048576', 'w');
        if (false === $fd) {
            die('Failed to create temporary file');
        }


        //$out = fopen('php://output', 'w');
        fwrite($fd, "\xEF\xBB\xBF");
        fputcsv($fd, $headerArr);

        foreach ($dataRows as $rowElem){
            fputcsv($fd, $rowElem);
        }

        rewind($fd);

        $zip->addFromString($name.'.csv', stream_get_contents($fd));
        //close the file
        fclose($fd);
        $zip->close();
        return $file = $zipname;

//        header('Content-Type: application/zip');
//        header('Content-disposition: attachment; filename='.$zipname);
//        header('Content-Length: ' . filesize($zippath));
//        return readfile($zippath);

        // remove the zip archive
        // you could also use the temp file method above for this.
        //unlink($zipname);
    }
}

?>