<?php
namespace App\Libraries;
use Mpdf\Mpdf;

class Dt_mpdf
{

	public function generate($content, $name = 'download.pdf', $output_type = null, $footer = null, $margin_bottom = null, $header = null, $margin_top = null, $orientation = 'P',$extraPage = '',$filePath = '',$protectionPassword = '') {
		if (!$output_type) {
			$output_type = 'D';
		}

		//        if (!$margin_top) {
		//           // $margin_top = 20;
		//        }

		//$mpdf = new Mpdf('utf-8', 'A4-' . $orientation, '13', '', 10, 10, $margin_top, $margin_bottom, 9, 9);
		if($orientation == 'L'){
			$mpdf = new Mpdf(['orientation' => 'L']);
		} else {
			$mpdf = new Mpdf();
		}
		$mpdf->debug = (ENVIRONMENT == 'development');
		$mpdf->autoScriptToLang = true;
		$mpdf->autoLangToFont = true;
		$mpdf->setAutoBottomMargin = 'stretch';
		$mpdf->setAutoTopMargin = 'stretch';
		$mpdf->simpleTables = true;
//		$mpdf->SetWatermarkImage(
//			'smartblast-logo.png',
//			0.20,
//			'',
//			'C'
//		);
//		$mpdf->showWatermarkImage = true;
		if ($protectionPassword != '') {
			$mpdf->SetProtection(array(), $protectionPassword, '');
		}
		// if you need to add protection to pdf files, please uncomment the line below or modify as you need.
		// $mpdf->SetProtection(array('print')); // You pass 2nd arg for user password (open) and 3rd for owner password (edit)
		// $mpdf->SetProtection(array('print', 'copy')); // Comment above line and uncomment this to allow copying of content
		if (isset($margin_top) && $margin_top != '') {
			$mpdf->margin_header = $margin_top;
		} else {
			$mpdf->margin_header = 4;
		}
		if (isset($margin_bottom) && $margin_bottom != '') {
			$mpdf->margin_footer = $margin_bottom;
		} else {
			$mpdf->margin_footer = 4;
		}

		$mpdf->SetDisplayMode(100);

		if (is_array($content)) {
			$mpdf->SetHeader("FREDUN".'||{PAGENO}/{nbpg}', '', TRUE); // For simple text header
			$as = sizeof($content);
			$r = 1;
			foreach ($content as $page) {
				$mpdf->WriteHTML($page['content']);
				if (!empty($page['footer'])) {
					$mpdf->SetHTMLFooter('<p class="text-center">' . $page['footer'] . '</p>', '', true);
				}
				if ($as != $r) {
					$mpdf->AddPage();
				}
				$r++;
			}

		} else {

			if ($header != '') {
				$mpdf->SetHTMLHeader('<p class="text-center" style="margin:0px!important">' . $header . '</p>', '', true);
				//$mpdf->SetHTMLHeader('<p class="text-center">' . $header . '</p>', '', true);
			}
			if ($footer != '') {
				$mpdf->SetHTMLFooter('<p class="text-center" style="margin:0px!important">' . $footer . '</p>', '', true);
				//$mpdf->SetHTMLFooter('<p class="text-center">' . $footer . '</p>', '', true);
			}
			//echo $content;
			//exit;

			$mpdf->WriteHTML($content);

		}

		if ($output_type == 'S') {
			return $mpdf->Output($name, 'S');

//			//echo "if"; die();
//			$file_content   = $mpdf->Output('', 'S');
//
//			write_file($filePath. $name, $file_content);
//			//write_file('assets/uploads/' . $name, $file_content);
//			return $filePath. $name;
//			//return 'assets/uploads/' . $name;
//
////            $file_content = $mpdf->Output('', 'S');
//			// write_file(UPLOADPATH . $name, $file_content);
////            //write_file('assets/uploads/' . $name, $file_content);
////            return UPLOADPATH . $name;
//			//return 'assets/uploads/' . $name;

		}
		else {
			$mpdf->Output($name, $output_type);
		}
	}
}
