<?php

namespace App\Libraries;

class Dt_ci_acl
{
    private $permitableMethodsArray = array(
        "Society" =>
            array(
                array("index" => "View Society"),
                array("manage" => "Add Edit Society"),
                array("delete" => "Delete Society"),
                array("pdf" => "Society Pdf"),
                array("deleteImage" => "Delete Society Image"),
                // array("submitForm" => "Approve Society"),
            ),
        "Charges" =>
            array(
                array("index" => "View Charges"),
                array("manage" => "Add Edit Charges"),
                array("delete" => "Delete Charges"),
            ),
        "CommonArea" =>
            array(
                array("index" => "View Common Area"),
                array("addEdit" => "Add Edit Common Area"),
                array("delete" => "Delete Common Area"),
            ),
        "ParkingArea" =>
            array(
                array("index" => "View Parking Area"),
                array("manage" => "Add Edit Parking Area"),
                array("delete" => "Delete Parking Area"),
            ),
        "Manufacturer" =>
            array(
                array("index" => "View Manufacturer"),
                array("addEdit" => "Add Edit Manufacturer"),
                array("delete" => "Delete Manufacturer"),
            ),
        "Tax" =>
            array(
                array("index" => "View Tax"),
                array("addEdit" => "Add Edit Tax"),
                array("delete" => "Delete Tax"),
            ),
        "ManagementCommitteeResponsibilities" =>
            array(
                array("index" => "View MCR"),
                array("addEdit" => "Add Edit MCR"),
                array("delete" => "Delete MCR"),
            ),
        "Amenities" =>
            array(
                array("index" => "View Amenities"),
                array("manage" => "Add Edit Amenities"),
                array("delete" => "Delete Amenities"),
                array("approve" => "Approve Amenities"),
                array("reject" => "Reject Amenities"),
            ),
        "Voucher" =>
            array(
                array("index" => "View Voucher"),
                array("manage" => "Add Edit Voucher"),
                array("delete" => "Delete Voucher"),
            ),
        "Receipt" =>
            array(
                array("index" => "View Receipt"),
                array("manage" => "Add Edit Receipt"),
                array("delete" => "Delete Receipt"),
            ),
        "CashBook" =>
            array(
                array("index" => "View CashBook"),
            ),    
        "Flat" =>
            array(
                array("index" => "View Flat"),
                array("manage" => "Add Edit Flat"),
                array("delete" => "Delete Flat"),
                array("pdf" => "View Flat Pdf"),
            ),
        "Category" =>
            array(
                array("index" => "View Category"),
                array("manage" => "Add Edit Category"),
                array("delete" => "Delete Category"),
            ),
        "Generator" =>
            array(
                array("index" => "View Generator"),
                array("manage" => "Add Edit Generator"),
                array("delete" => "Delete Generator"),
            ),
        "GeneratorReading" =>
            array(
                array("index" => "View Generator Reading"),
                array("manage" => "Add Edit Generator Reading"),
                array("delete" => "Delete Generator Reading"),
            ),
        "LetterHead" =>
            array(
                array("index" => "View Letter Head"),
                array("manage" => "Add Edit Letter Head"),
                array("delete" => "Delete Letter Head"),
            ),
        "Account" =>
            array(
                array("index" => "View Account"),
                array("manage" => "Add Edit Account"),
                array("delete" => "Delete Account"),
            ),
        "SubAccount" =>
            array(
                array("index" => "View Sub Account"),
                array("manage" => "Add Edit Sub Account"),
                array("delete" => "Delete Sub Account"),
            ),
        "Budget" =>
            array(
                array("index" => "View Budget"),
                array("manage" => "Add Edit Budget"),
                array("delete" => "Delete Budget"),
                array("pdf" => "Budget Pdf"),
            ),
        "OrganicWasteRecord" =>
            array(
                array("index" => "View Organic Waste Record"),
                array("manage" => "Add Edit Organic Waste Record"),
                array("delete" => "Delete Organic Waste Record"),
                array("pdf" => "Organic Waste Record Pdf"),
            ),
        "Event" =>
            array(
                array("index" => "View Event"),
                array("manage" => "Add Edit Event"),
                array("delete" => "Delete Event"),
            ),
        "EventBooking" =>
            array(
                array("index" => "View Event Booking"),
                array("manage" => "Add Event Booking"),
                // array("delete" => "Delete Event"),
            ),
        "Gate" =>
        array(
            array("index" => "View Gate"),
            array("manage" => "Add Edit Gate"),
            array("delete" => "Delete Gate"),
        ),
        "Sos" =>
        array(
            array("index" => "View Sos"),
            array("manage" => "Add Edit Sos"),
            array("delete" => "Delete Sos"),
        ),
        "TagAssign" =>
        array(
            array("index" => "View Tag Assign"),
            array("manage" => "Add Edit Tag Assign"),
            array("delete" => "Delete Tag Assign"),
        ),
        "EmergencyContact" =>
        array(
            array("index" => "View Emergency Contact"),
            array("manage" => "Add Edit Emergency Contact"),
            array("delete" => "Delete Emergency Contact"),
        ),
        "Notice" =>
        array(
            array("index" => "View Notice"),
            array("manage" => "Add Edit Notice"),
            array("delete" => "Delete Notice"),
        ),
        "Faq" =>
        array(
            array("index" => "View Faq"),
            array("manage" => "Add Edit Faq"),
            array("delete" => "Delete Faq"),
        ),
        "Tag" =>
        array(
            array("index" => "View Tag"),
            array("manage" => "Add Edit Tag"),
            array("delete" => "Delete Tag"),
        ),
        "Item" =>
            array(
                array("index" => "View Item"),
                array("manage" => "Add Edit Item"),
                array("delete" => "Delete Item"),
                array("deleteImage" => "Delete Item Image"),
            ),
        "ItemBalance" =>
            array(
                array("index" => "View Item Balance"),
                array("pdf" => "Item Balance Pdf"),
            ),
        "ItemLedger" =>
            array(
                array("index" => "View Item Ledger"),
            ),
        "Visitor" =>
            array(
                array("index" => "View Visitor"),
            ),
        "Notification" =>
            array(
                array("index" => "View Notification"),
            ),
        "Comment" =>
            array(
                array("index" => "View Comment"),
            ),
        "Vehicle" =>
            array(
                array("index" => "View Vehicle"),
            ),
        "SosEmergency" =>
            array(
                array("index" => "View Sos Emergency"),
            ),
        "PollVotes" =>
            array(
                array("index" => "View Poll Votes"),
            ),
        "PollVotesDetail" =>
            array(
                array("index" => "View Poll Votes Detail"),
            ),
        "Forum" =>
            array(
                array("index" => "View Forum"),
                array("manage" => "Add Edit Forum"),
                array("delete" => "Delete Forum"),
                array("deleteImage" => "Delete Forum Image")
            ),
        "Material" =>
            array(
                array("index" => "View Material"),
                array("manage" => "Add Edit Rentals"),
                array("delete" => "Delete Material"),
                array("deleteItem" => "Delete Material Item"),
                array("submitForm" => "Approve Material"),
                array("materialButNotReturnDetailed" => "Material But Not Return Detailed Report"),
                array("pdf" => "Material PDF"),
            ),
        "MobileCustomerApp" =>
            array(
                array("addVisitor" => "Add Visitor"),
                array("viewBanner" => "View Banner"),
                array("viewQuickAccess" => "View Quick Access"),
                array("viewVisitor" => "View Visitor"),
                array("viewForum" => "View Forum"),
                array("viewPoll" => "View Poll"),
                array("viewResidentDirectory" => "View Resident Directory"),
                array("viewServiceDirectory" => "View Service Directory"),
                array("viewSocietyCommittee" => "View Society Committee"),
                array("viewEmergencyDirectory" => "View Emergency Directory"),
                array("viewGuardDirectory" => "View Guard Directory"),
                array("viewNotice" => "View Notice"),
                array("viewResource" => "View Resource"),
                array("viewParking" => "View Parking"),
                array("viewAmenities" => "View Amenities"),
                array("viewSos" => "View SOS"),
                array("viewEmergency" => "View Emergency"),
                array("viewComplainTicket" => "View Complain Ticket"),
                array("viewNotification" => "View Notification"),
                array("viewNotificationSetting" => "View Notification Setting"),
                array("viewMaintenance" => "View Maintenance"),
                array("viewStatement" => "View Statement"),
                array("viewPaymentHistory" => "View Payment History"),
                array("viewMember" => "View Member"),
                array("viewVehicle" => "View Vehicle"),
                array("viewMyMember" => "View My Member"),
                array("viewMyVehicle" => "View My Vehicle"),
                array("addResource" => "Add Resource"),
                array("addPreApproveCab" => "Add Pre Approve Cab"),
                array("addPreApproveDeliveryBoy" => "Add Pre Approve Delivery Boy"),
                array("addPreApproveGuest" => "Add Pre Approve Guest"),
                array("addVehicle" => "Add Vehicle"),
                array("addMember" => "Add Member"),
                array("viewEvents" => "View Events"),
                array("viewDocument" => "View Document"),
            ),
            "MobileGatekeeperApp" =>
            array(
                array("addVisitor" => "Add Visitor"),
                array("addGuest" => "Add Guest"),
                array("addDeliveryBoy" => "Add Delivery Boy"),
                array("addCab" => "Add Cab"),
                array("viewVisitor" => "View Visitor"),
                array("viewHistory" => "View History"),
                array("viewResident" => "View Resident"),
                array("viewResource" => "View Resource"),
                array("viewParking" => "View Parking"),
                array("viewSos" => "View SOS"),
                array("viewEvents" => "View Events"),
                array("viewScanner" => "View Scanner"),
                array("viewNotification" => "View Notification"),
            ),
            "MobileManagerApp" =>
            array(
                array("viewComplainTicket" => "View Complain Ticket"),
                array("viewOrganicWaste" => "View Organic Waste"),
                array("viewWaterMeterReading" => "View Water Meter Reading"),
                array("viewGenerator" => "View Generator"),
                array("viewDocument" => "View Document"),
                array("viewParking" => "View Parking"),
                array("viewEvents" => "View Events"),
                array("viewNotification" => "View Notification"),
                array("viewSos" => "View SOS"),
                array("viewAmenities" => "View Amenities"),
                array("viewVisitor" => "View Visitor"),
                array("viewBanner" => "View Banner"),
                array("viewResource" => "View Resource"),
                array("viewResidentDirectory" => "View Resident Directory"),
                array("viewHistory" => "View History"),
                array("addResource" => "Add Resource"),
                array("addComplainTicket" => "Add Complain Ticket"),
                array("viewServiceDirectory" => "View Service Directory"),
                array("viewSocietyCommitte" => "View Society Committee"),
                array("viewEmergencyDirectory" => "View Emergency Directory"),
            ),
        // "Member" =>
        // 	array(
        // 		array("index" => "View Member"),
        // 		array("manage" => "Add Edit Member"),
        // 		array("delete" => "Delete Member"),
        // 	),
        "Meeting" =>
            array(
                array("index" => "View Meeting"),
                array("manage" => "Add Edit Meeting"),
                array("delete" => "Delete Meeting"),
                array("meetingRecordDelete" => "Delete Meeting Record"),
            ),
        "Tower" =>
            array(
                array("index" => "View Tower"),
                array("manage" => "Add Edit Tower"),
                array("delete" => "Delete Tower"),
                array("deleteItem" => "Delete Tower Unit"),
            ),
        "VisitorCompany" =>
            array(
                array("index" => "View Visitor Company"),
                array("addEdit" => "Add Edit Visitor Company"),
                array("delete" => "Delete Visitor Company"),
            ),
        "WaterTank" =>
            array(
                array("index" => "View Water Tank"),
                array("addEdit" => "Add Edit Water Tank"),
                array("delete" => "Delete Water Tank"),
            ),
        "ResourceType" =>
            array(
                array("index" => "View Resource Type"),
                array("addEdit" => "Add Edit Resource Type"),
                array("delete" => "Delete Resource Type"),
            ),
        "TimeSlot" =>
            array(
                array("index" => "View Time Slot"),
                array("manage" => "Add Edit Time Slot"),
                array("delete" => "Delete Time Slot"),
            ),
        "ParkingSlot" =>
            array(
                array("index" => "View Parking Slot"),
                array("addEdit" => "Add Edit Parking Slot"),
                array("delete" => "Delete Parking Slot"),
            ),
        "Bank" =>
            array(
                array("index" => "View Bank"),
                array("addEdit" => "Add Edit Bank"),
                array("delete" => "Delete Bank"),
            ),
        "BankAccount" =>
            array(
                array("index" => "View Bank Account"),
                array("manage" => "Add Edit Bank Account"),
                array("delete" => "Delete Bank Account"),
            ),
        "Broker" =>
            array(
                array("index" => "View Broker"),
                array("manage" => "Add Edit Broker"),
                array("delete" => "Delete Broker"),
            ),
        "Booking" =>
            array(
                array("index" => "View Booking"),
                array("manage" => "Add Edit Booking"),
                array("delete" => "Delete Booking"),
                array("previousDelete" => "Delete Previous Date Booking"),
                array("previousEdit" => "Edit Previous Date Booking")
            ),
        "BookingCalendar" =>
            array(
                array("index" => "View Booking Calendar"),
            ),
        "Complain" =>
            array(
                array("index" => "View Complain"),
                array("manage" => "Add Edit Complain"),
                array("delete" => "Delete Complain"),
                array("complaintImageDelete" => "Delete Complain Image"),
            ),
        "CommonKeys" =>
            array(
                array("index" => "View Common Keys"),
                array("manage" => "Add Edit Common Keys"),
                array("delete" => "Delete Common Keys"),
                array("deleteCommonKeyAvailability" => "Delete Common Keys Availability"),
                array("pdf" => "Common Keys PDF"),
            ),
        "KeyIssue" =>
            array(
                array("index" => "View Key Issue"),
                array("manage" => "Add Edit Key Issue"),
                array("delete" => "Delete Key Issue"),
                array("submitForm" => "Approve Key Issue"),
            ),
        "Resource" =>
            array(
                array("index" => "View Resource"),
                array("manage" => "Add Edit Resource"),
                array("deleteFlat" => "Delete Resource Flat"),
//                array("delete" => "Delete Resource"),
                //array("pdf" => "Common Keys PDF"),
            ),

        "Poll" =>
            array(
                array("index" => "View Poll"),
                array("manage" => "Add Edit Poll"),
                array("delete" => "Delete Poll"),
                array("deletePollAnswer" => "Delete Poll Answer"),
            ),


        "Warranty" =>
            array(
                array("index" => "View Warranty"),
                array("manage" => "Add Edit Warranty"),
                array("delete" => "Delete Warranty"),
                array("pdf" => "Warranty PDF"),
            ),
        "Intercom" =>
            array(
                array("index" => "View Intercom"),
                array("manage" => "Add Edit Intercom"),
                array("delete" => "Delete Intercom"),
                array("pdf" => "Intercom PDF"),
            ),
        "Investments" =>
            array(
                array("index" => "View Investments"),
                array("manage" => "Add Edit Investments"),
                array("delete" => "Delete Investments"),
                array("pdf" => "Investments PDF"),
            ),
        "ManagementCommittee" =>
            array(
                array("index" => "View Management Committee"),
                array("manage" => "Add Edit Management Committee"),
                array("delete" => "Delete Management Committee"),
                array("pdf" => "Management Committee PDF"),
            ),
        "Staff" =>
            array(
                array("index" => "View Staff"),
                array("manage" => "Add Edit Staff"),
                array("delete" => "Delete Staff"),
                array("deleteImage" => "Delete Staff Image"),
                array("pdf" => "Staff PDF"),
            ),
        "Banner" =>
            array(
                array("index" => "View Banner"),
                array("manage" => "Add Edit Banner"),
                array("delete" => "Delete Banner"),
                array("deleteImage" => "Delete Banner Image"),
            ),
        "Status" =>
            array(
                array("index" => "View Status"),
                array("manage" => "Add Edit Status"),
                array("delete" => "Delete Status"),
            ),
        "Rentals" =>
            array(
                array("index" => "View Rentals"),
                array("manage" => "Add Edit Rentals"),
                array("delete" => "Delete Rentals"),
                // array("editDate" => "Amend Document Date"),
                array("deleteMember" => "Delete Rentals Member"),
                array("deleteEmergencyContact" => "Delete Rentals Emergency Contact"),
                array("deleteParkingDetail" => "Delete Rentals Parking Detail"),
                array("deleteAccessCardDetail" => "Delete Rentals Access Card Detail"),
                array("changeStatus" => "Rental Changes Status"),
                array("pdf" => "Rental PDF"),
            ),
        "OwnershipFlat" =>
            array(
                array("index" => "View Ownership Flat"),
                array("manage" => "Add Edit Ownership Flat"),
                array("delete" => "Delete Ownership Flat"),
                array("deleteMember" => "Delete Ownership Flat Member"),
                array("deleteEmergencyContact" => "Delete Ownership Flat Emergency Contact"),
                array("deleteParkingDetail" => "Delete Ownership Flat Parking Detail"),
                array("deleteAccessCardDetail" => "Delete Ownership Flat Access Card Detail"),
                array("pdf" => "Ownership Flat PDF"),

            ),
        "TransferredFlat" =>
            array(
                array("index" => "View Transferred Flat"),
                array("manage" => "Add Edit Transferred Flat"),
                // array("delete" => "Delete Transferred Flat"),
                array("pdf" => "Transferred Flat PDF"),
            ),
        "WaterMeterReading" =>
            array(
                array("index" => "View Water Meter Reading"),
                array("manage" => "Add Edit Water Meter Reading"),
                array("delete" => "Delete Water Meter Reading"),
                array("pdf" => "Water Meter Reading PDF"),

            ),
        "SinkingFund" =>
            array(
                array("index" => "View Sinking Fund"),
                array("manage" => "Add Edit Sinking Fund"),
                array("delete" => "Delete Sinking Fund"),
                array("addInvestment" => "Add Investment"),
                array("addWithdrawn" => "Add Withdrawn"),
            ),
        "MenPowerAttendance" =>
            array(
                array("index" => "View Men Power Attendance"),
                array("manage" => "Add Edit Men Power Attendance"),
                array("delete" => "Delete Men Power Attendance"),
            ),
        "Service" =>
            array(
                array("index" => "View Service"),
                array("manage" => "Add Edit Service"),
                array("delete" => "Delete Service"),
            ),
        "Document" =>
            array(
                array("index" => "View Document"),
                array("manage" => "Add Edit Document"),
                array("delete" => "Delete Document"),
            ),
        "DocumentFolder" =>
            array(
                array("index" => "View Document Folder"),
                array("manage" => "Add Edit Document Folder"),
                array("delete" => "Delete Document Folder"),
            ),
        "Document Folder" =>
            array(
                array("index" => "View Document Folder"),
                array("manage" => "Add Edit Document Folder"),
                array("delete" => "Delete Document Folder"),
                array("deleteItem" => "Delete Document Folder Item"),
            ),
        "FlatSquareFeetArea" =>
            array(
                array("index" => "View Flat Square Feet Area"),
                array("manage" => "Add Edit Flat Square Feet Area"),
                array("delete" => "Delete Flat Square Feet Area"),
                array("pdf" => "Flat Square Feet Area PDF"),
            ),
        "Vendor" =>
            array(
                array("index" => "View Vendor"),
                array("manage" => "Add Edit Vendor"),
                array("delete" => "Delete Vendor"),
                array("deleteMobile" => "Delete Vendor Mobile"),
                array("pdf" => "Vendor PDF"),
            ),
        "AMC" =>
            array(
                array("index" => "View AMC Detail"),
                array("manage" => "Add Edit AMC Detail"),
                array("delete" => "Delete AMC Detail"),
                array("pdf" => "AMC Detail PDF"),
            ),
        "Invoice" =>
            array(
                array("index" => "View Invoice Detail"),
                array("manage" => "Add Edit Invoice Detail"),
                array("delete" => "Delete Invoice Detail"),
                array("pdf" => "Invoice Detail PDF"),
            ),
        "Visit" =>
            array(
                array("index" => "View Visit Detail"),
                array("manage" => "Add Edit Visit Detail"),
                array("delete" => "Delete Visit Detail"),
                array("pdf" => "Visit PDF"),
            ),
        "ActivityLog" =>
            array(
                array("index" => "View Activity Log"),
            ),
        "Auth" =>
            array(
                array("edit_group" => "Modify Groups"),
                array("manage_groups" => "View Groups"),
                array("index" => "View Users"),
                array("edit_user" => "Modify Users"),
                array("deleteGroup" => "Delete Group(s)"),
                array("deleteUser" => "Delete User(s)")
            )
    );

    private $friendlyControllerNames = array(
        "auth" => "User access"
    );

    // Construct
    function __construct()
    {
        // Get Codeigniter instance
        $this->ionAuth    = new \App\Libraries\IonAuth();
    }

    public function checkAdmin()
    {
        return $this->ionAuth->isAdmin();
    }

    public function checkAccess($requiredPermission)
    {
        if ($this->ionAuth->isAdmin()) {
            return true;
        }

        $requiredPermissionArr = explode("|", $requiredPermission);
        $requiredPClass = $requiredPermissionArr[0];
        $requiredPMethod = $requiredPermissionArr[1];


        //        echo "<pre>"; print_r($requiredPermission);
        //		 echo "<br/>";
        //       print_r($requiredPMethod);

        // die();
        if (isset($this->permitableMethodsArray[$requiredPClass]) && $this->checkArray($requiredPMethod, $this->permitableMethodsArray[$requiredPClass])) {
            $currentPermission = $this->ionAuth->getCurrentUserPermission();
            // $currentPermission = $this->ionAuth->getCurrentUserPermissionUserWise();

            if (in_array(strtolower($requiredPermission), ($currentPermission))) {
                return true;
            } else {
                return false;
            }
        } else {
            return true;
        }
    }

    private function checkArray($needle, $haystack)
    {
        foreach ($haystack as $item) {
            if ($item == $needle) {
                return true;
            } else if (is_array($item)) {
                reset($item);
                if (key($item) == $needle) {
                    return true;
                }
            }
        }
        return false;
    }

    public function getPermissableMethods()
    {
        return $this->permitableMethodsArray;
    }

    //	public function getActiveMenu($path, $class = 'active')
    //	{
    //
    //		printArray($path);
    //		echo "<br/>";
    //		echo uri_string();
    //		echo "<br/>";
    //		if ($path == uri_string()) {
    //			return "class='$class'";
    //		}
    //	}

    // public function getActiveMenu($path, $activeClass = 'active')
    // {
    //     $router = service('router');
    //     $class =  class_basename($router->controllerName());
    //     $method = $router->methodName();

    //     //		echo 'cclass =='.$class;
    //     //		echo '<br/>';
    //     //		echo 'methodmethod === '.$method;
    //     //		echo '<br/>';
    //     if (is_string($path)) {
    //         $path = array($path);
    //     }
    //     if ($method == 'index') {
    //         $method = '';
    //     } else {
    //         $method = "/" . $method;
    //     }
    //     $path = array_map('strtolower', $path);

    //     //		printArray($path);
    //     if (in_array(strtolower($class . $method), $path)) {
    //         return $activeClass;
    //     }
    // }

    public function getActiveMenu($path, $activeClass = 'active')
    {
        $router = service('router');
        $class  = class_basename($router->controllerName());
        $method = $router->methodName();

        if (is_string($path)) {
            $path = [$path];
        }

        $method = ($method === 'index') ? '' : '/' . $method;
        $currentPath = strtolower($class . $method);
        $path = array_map('strtolower', $path);

        // Check if the path matches based on class and method
        if (in_array($currentPath, $path)) {
            return $activeClass;
        }

        // Optional: Also check URI segments if your route path is different (like SuperAdmin/Society)
        $uri = service('uri');


        $uriPath = strtolower(implode('/', $uri->getSegments()));

        foreach ($path as $p) {
            if (strpos($uriPath, strtolower($p)) !== false) {
                return $activeClass;
            }
        }

        return '';
    }



    public function checkPermission()
    {
        //$router = service('router');

        $router = \Config\Services::router();
        $callingClass = class_basename($router->controllerName());
        $callingMethod  = $router->methodName();
        $requiredPermission = $callingClass . "|" . $callingMethod;
        //echo $requiredPermission; die();
        $accessStatus = $this->checkAccess($requiredPermission);
        $data['assets'] = base_url() . 'assets/';
        if (!$accessStatus) {
            echo view('errors/custom/no_permission', $data);
            exit;
        }
    }
}
