<?php
namespace App\Controllers\Api;
use App\Controllers\Admin\Gate;
use App\Models\NotesModel;
use CodeIgniter\RESTful\ResourceController;
use App\Models;
use App\Models\ComplainModel;
use App\Models\CommonWebServiceModel;
use App\Models\SocietyModel;
use App\Models\FlatModel;
use App\Models\TowerModel;
use App\Models\VisitorCompanyModel;
use App\Models\CategoryModel;
use App\Models\MeetingModel;
use App\Models\OwnershipFlatModel;
use App\Models\ParkingSlotModel;
use App\Models\VisitorModel;
use App\Models\ResourceModel;
use App\Models\NoticeModel;
use App\Models\StatusModel;
use App\Models\PollModel;
use App\Models\AmenitiesModel;
use App\Models\BannerModel;
use App\Models\DocumentFolderModel;
use App\Models\ManagementCommitteeModel;
use App\Models\NotificationModel;
use App\Models\SettingModel;
use App\Models\FaqModel;
use App\Models\mediaModel;
use App\Models\EventModel;
use App\Models\GeneratorModel;
use App\Models\WaterTankModel;
use App\Models\ResourceTypeModel;
use Firebase\JWT\JWT;
use CodeIgniter\HTTP\IncomingRequest;
use DateTime;
helper('text');

class SocietyApi extends ResourceController
{
    protected $complainModel;
    protected $amenitiesModel;
    protected $commonWebserviceModel;
    protected $ownershipFlatModel;
    protected $parkingSlotModel;
    protected $flatModel;
    protected $towerModel;
    protected $visitorCompanyModel;
    protected $categoryModel;
    protected $societyModel;
    protected $meetingModel;
    protected $statusModel;
    protected $visitorModel;
    protected $resourceModel;
    protected $noticeModel;
    protected $pollModel;
    protected $eventModel;
    protected $bannerModel;
    protected $managementCommitteeModel;
    protected $settingModel;
    protected $notificationModel;
    protected $documentFolderModel;
    protected $faqModel;
    protected $forumModel;
    protected $generatorModel;
    protected $waterTankModel;
    protected $resourceTypeModel;
    protected $managementCommitteeResponsibilitiesModel;
    protected $dt_ci_acl;

    public function __construct()
    {
        $this->managementCommitteeModel = new ManagementCommitteeModel();
        $this->complainModel = new ComplainModel();
        $this->amenitiesModel = new AmenitiesModel();
        $this->flatModel = new FlatModel();
        $this->meetingModel = new MeetingModel();
        $this->resourceTypeModel = new ResourceTypeModel();
        $this->towerModel = new TowerModel();
        $this->visitorCompanyModel = new VisitorCompanyModel();
        $this->categoryModel = new CategoryModel();
        $this->eventModel = new EventModel();
        $this->visitorModel = new VisitorModel();
        $this->resourceModel = new ResourceModel();
        $this->noticeModel = new NoticeModel();
        $this->pollModel = new PollModel();
        $this->commonWebserviceModel = new CommonWebServiceModel();
        $this->statusModel = new StatusModel();
        $this->societyModel = new SocietyModel();
        $this->ownershipFlatModel = new OwnershipFlatModel();
        $this->rentalModel = new Models\RentalsModel();
        $this->parkingSlotModel = new ParkingSlotModel();
        $this->notificationModel = new NotificationModel();
        $this->amenitiesModel = new Models\AmenitiesModel();
        $this->bookingModel = new Models\BookingModel();
        $this->vendorModel = new Models\VendorModel();
        $this->managementCommitteeModel = new Models\ManagementCommitteeModel();
        $this->managementCommitteeResponsibilitiesModel = new Models\ManagementCommitteeResponsibilitiesModel();
        $this->sosModel = new Models\SosModel();
        $this->staffModel = new Models\StaffModel();
        $this->bannerModel = new Models\BannerModel();
        $this->documentFolderModel = new Models\DocumentFolderModel();
        $this->settingModel = new Models\SettingModel();
        $this->faqModel = new Models\FaqModel();
        $this->forumModel = new Models\ForumModel();
        $this->mediaModel = new Models\MediaModel();
        $this->parkingAreaModel = new Models\ParkingAreaModel();
        $this->ionAuthModel = new Models\IonAuthModel();
        $this->generatorModel = new Models\GeneratorModel();
        $this->waterTankModel = new Models\WaterTankModel();
        $this->dt_ci_acl    = new \App\Libraries\Dt_ci_acl();
        helper('Dt_ci_site_helper');
        helper('tenant');


        $this->db = getTenantDb();
        $this->validation = \Config\Services::validation();
        $this->startRtime = microtime(TRUE);
        checkAndCreatePath(CATEGORY_IMAGE_PATH);
        checkAndCreatePath(DOCUMENT_IMAGE_PATH);
        checkAndCreatePath(QR_CODE_IMAGE_PATH);
        checkAndCreatePath(VEHICLE_IMAGE_PATH);
        checkAndCreatePath(EVENT_QR_CODE_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_MEDIA_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_EVENT_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_STAFF_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_ID_PROOF_PATH);
        checkAndCreatePath(THUMBNAIL_CATEGORY_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_DOCUMENT_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_COMPLAIN_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_CATEGORY_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_VEHICLE_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_VISITOR_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_RENTALS_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_ITEM_IMAGE_PATH);
    }

    public function __destruct()
    {
        // Get the current timestamp
        $this->endRtime = microtime(TRUE);
        // Log the loading time to the log table
        if (REST_ENABLE_LOGGING == TRUE) {
            $this->logAccessTime();
        }
    }

    public function getEventList()
    {
        $search = $this->request->getVar('search');
        $eventId = $this->request->getVar('event_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $isShowAllEvent = $this->request->getVar('is_show_all_event');
        $categoryId = $this->request->getVar('category_id[]');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        // $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'form_submit' => 'approved',
                'search' => $search,
                'event_id' => $eventId,
                'society_id' => $societyId,
                'category_id' => $categoryId,
                'user_society_id' => $userSocietyId,
            );
            if(empty($isShowAllEvent)){
                $filterArray['date_greater_than_equal_to'] = TODAY_DATE_YMD;
            }
            $eventData = $this->eventModel->getEventData($filterArray);
            $categoryData = $this->categoryModel->getCategoryData(array(
                'category_for' => 'event',
                'is_multiple' => 1,
                'is_active' => 1,
            ));
            $eventIdArray = array();
            $eventImageDataWise = array();
            $eventRateDataWise = array();
            $eventCategoryDataWise = array();
            if (!empty($eventData)) {
                foreach ($eventData as $skey => $eventElement) {
                    $eventIdArray[] = $eventElement['event_id'];
                }
            }
            $eventImageData = $this->eventModel->getEventImageData(array(
                "event_id" => $eventIdArray,
                "is_multiple" => 1
            ));
            $eventRateData = $this->eventModel->getEventRateData(array(
                "event_id" => $eventIdArray,
                "is_multiple" => 1
            ));
            $eventCategoryData = $this->eventModel->getEventCategoryData(array(
                "event_id" => $eventIdArray,
                "is_multiple" => 1
            ));
            if (!empty($eventRateData)) {
                    foreach ($eventRateData as $siKey => $eventRateElement) {
                    $eventRateDataWise[$eventRateElement['event_id']][] = $eventRateElement;
                }
            }
            if (!empty($eventCategoryData)) {
                    foreach ($eventCategoryData as $siKey => $eventCategoryElement) {
                    $eventCategoryDataWise[$eventCategoryElement['event_id']][] = $eventCategoryElement;
                }
            }
            if (!empty($eventImageData)) {
                    foreach ($eventImageData as $siKey => $eventImageElement) {
                    $paths = SITE_URL('uploads/no_image.png');
                    $thumbnailPaths = SITE_URL('uploads/no_image.png');
                    if (file_exists(EVENT_IMAGE_PATH . $eventImageElement['event_image'])) {
                        $paths = site_url() . EVENT_IMAGE_PATH . $eventImageElement['event_image'];
                    }
                    $eventImageElement['event_thumbnail_image'] = $paths;
                    if (file_exists(THUMBNAIL_EVENT_IMAGE_PATH . $eventImageElement['event_thumbnail_image'])) {
                        $paths = site_url() . THUMBNAIL_EVENT_IMAGE_PATH . $eventImageElement['event_thumbnail_image'];
                    }
                    $eventImageElement['thumbnail_event_image'] = $paths;
                    $eventImageDataWise[$eventImageElement['event_id']][] = $eventImageElement;
                }
            }
            if (!empty($eventData)) {
                foreach ($eventData as $skey => $eventElement) {
                    $eventData[$skey]['created_at'] = isValidDate($eventElement['created_at']) ? YMDToDMY($eventElement["created_at"], true) : "";
                    $eventData[$skey]['updated_at'] = isValidDate($eventElement['updated_at']) ? YMDToDMY($eventElement["updated_at"], true) : "";
                    $eventData[$skey]['created_at_display'] = time_elapsed_string($eventElement['created_at']);
                    $eventData[$skey]['updated_at_display'] = time_elapsed_string($eventElement['updated_at']);
                    $eventData[$skey]["start_date_display"] = isValidDate($eventElement['start_date']) ? date('d F, Y h:i A', strtotime($eventElement["start_date"])) : "";
                    $eventData[$skey]["end_date_display"] = isValidDate($eventElement['end_date']) ? date('d F, Y h:i A', strtotime($eventElement["end_date"])) : "";
                    $eventData[$skey]["date_start_display"] = isValidDate($eventElement['start_date']) ? date('d M, Y', strtotime($eventElement["start_date"])) : "";
                    $eventData[$skey]["date_end_display"] = isValidDate($eventElement['end_date']) ? date('d M, Y', strtotime($eventElement["end_date"])) : "";

                    $eventData[$skey]["start_date_name_display"] = isValidDate($eventElement['start_date']) ? date('D jS F Y', strtotime($eventElement["start_date"])) : "";
                    $eventData[$skey]["end_date_name_display"] = isValidDate($eventElement['end_date']) ? date('D jS F Y', strtotime($eventElement["end_date"])) : "";

                    $eventElement["start_date_display"] = isValidDate($eventElement['start_date']) ? date('d F, Y', strtotime($eventElement["start_date"])) : "";
                    $eventElement["end_date_display"] = isValidDate($eventElement['end_date']) ? date('d F, Y', strtotime($eventElement["end_date"])) : "";

                    if($eventElement["start_date_display"] == $eventElement["end_date_display"]){
                        $eventData[$skey]["is_same_date"] = 1;
                    }
                    else{
                        $eventData[$skey]["is_same_date"] = 0;
                    }
                    $eventData[$skey]["start_date_time_display"] = isValidDate($eventElement['start_date']) ? date('h:i A', strtotime($eventElement["start_date"])) : "";
                    $eventData[$skey]["end_date_time_display"] = isValidDate($eventElement['end_date']) ? date('h:i A', strtotime($eventElement["end_date"])) : "";

                    $eventImagePath = SITE_URL('uploads/no_image.png');
                    if ($eventElement['event_thumbnail_image'] != '' && file_exists(THUMBNAIL_EVENT_IMAGE_PATH . $eventElement['event_thumbnail_image'])) {
                        $eventImagePath = site_url() . THUMBNAIL_EVENT_IMAGE_PATH . $eventElement['event_thumbnail_image'];
                    }
                    $eventData[$skey]['event_thumbnail_image'] = $eventImagePath;
                    $eventData[$skey]['event_image_data'] = array_key_exists($eventElement['event_id'],$eventImageDataWise) ? $eventImageDataWise[$eventElement['event_id']]: array();
                    $eventData[$skey]['event_rate_data'] = array_key_exists($eventElement['event_id'],$eventRateDataWise) ? $eventRateDataWise[$eventElement['event_id']]: array();
                    $eventData[$skey]['event_category_data'] = array_key_exists($eventElement['event_id'],$eventCategoryDataWise) ? $eventCategoryDataWise[$eventElement['event_id']]: array();
                }
            }
            if (!empty($eventData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.event_listing_successfully'),
                    'data' => $eventData,
                    'category_data' => $categoryData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $eventData,
                    'category_data' => $categoryData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getEventBookingList()
    {
        $search = $this->request->getVar('search');
        $eventId = $this->request->getVar('event_id');
        $eventBookingId = $this->request->getVar('event_booking_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $societyId = $this->request->getVar('society_id');
        $categoryId = $this->request->getVar('category_id[]');
        $userSocietyId = $this->request->getVar('user_society_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        // $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $categoryData = $this->categoryModel->getCategoryData(array(
                'category_for' => 'event',
                'is_multiple' => 1,
                'is_active' => 1,
            ));
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'search' => $search,
                'event_id' => $eventId,
                'society_id' => $societyId,
                'user_society_id' => $userSocietyId,
                'category_id' => $categoryId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            );
            $eventBookingData = $this->eventModel->getEventBookingData($filterArray);
            // printArray($eventBookingData,1);
            if (!empty($eventBookingData)) {
                foreach ($eventBookingData as $eKey => $eventBookingElement) {
                    $startDate = new DateTime($eventBookingElement['start_date']);
                    $endDate = new DateTime($eventBookingElement['end_date']);
                    $dateDiff = $startDate->diff($endDate)->days + 1;
                    $bookingDaysDisplay = $dateDiff . ($dateDiff === 1 ? " Day" : " Days");
                    $eventBookingData[$eKey]["booking_date_display"] = isValidDate($eventBookingElement['created_at']) ? date('d F, Y', strtotime($eventBookingElement["created_at"])) : "";
                    $eventBookingData[$eKey]["event_start_display"] = isValidDate($eventBookingElement['start_date']) ? date('d F, Y', strtotime($eventBookingElement["start_date"])) : "";
                    $eventBookingData[$eKey]["event_end_display"] = isValidDate($eventBookingElement['end_date']) ? date('d F, Y', strtotime($eventBookingElement["end_date"])) : "";
                    $eventBookingData[$eKey]["booking_days_display"] =  $bookingDaysDisplay;
                    $eventBookingData[$eKey]["booking_status_display"] = (isset($eventBookingElement['is_cancel']) && $eventBookingElement['is_cancel'] != 0) ? "Cancel" : "Success";
                    $eventBookingData[$eKey]["payment_status_display"] =  "Paid";

                    if($eventBookingData[$eKey]["event_start_display"] == $eventBookingData[$eKey]["event_end_display"]){
                        $eventBookingData[$eKey]["is_same_date"] = 1;
                    }
                    else{
                        $eventBookingData[$eKey]["is_same_date"] = 0;
                    }
                    $eventImagePath = SITE_URL('uploads/no_image.png');
                    if ($eventBookingElement['event_thumbnail_image'] != '' && file_exists(THUMBNAIL_EVENT_IMAGE_PATH . $eventBookingElement['event_thumbnail_image'])) {
                        $eventImagePath = site_url() . THUMBNAIL_EVENT_IMAGE_PATH . $eventBookingElement['event_thumbnail_image'];
                    }
                    $eventBookingData[$eKey]['event_thumbnail_image'] = $eventImagePath;
                }
            }
            if (!empty($eventBookingData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.event_booking_listing_successfully'),
                    'category_data' => $categoryData,
                    'data' => $eventBookingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'category_data' => $categoryData,
                    'data' => $eventBookingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getMyEventBookingList()
    {
        $search = $this->request->getVar('search');
        $eventId = $this->request->getVar('event_id');
        $eventBookingId = $this->request->getVar('event_booking_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        // $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('event_booking_id', lang('CommonWebService.event_booking_id'), 'required');
        
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'is_active' => 1,
                'search' => $search,
                'event_id' => $eventId,
                'society_id' => $societyId,
                'user_society_id' => $userSocietyId,
                'event_booking_id' => $eventBookingId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            );
            $adultRate = 0;
            $childRate = 0;
            $guestRate = 0;
            $eventBookingData = $this->eventModel->getEventBookingData($filterArray);
            if (!empty($eventBookingData)) {
                $startDate = new DateTime($eventBookingData['start_date']);
                $endDate = new DateTime($eventBookingData['end_date']);
                $dateDiff = $startDate->diff($endDate)->days + 1;
                $bookingDaysDisplay = $dateDiff . ($dateDiff === 1 ? " Day" : " Days");
                $eventBookingData["booking_date_display"] = isValidDate($eventBookingData['created_at']) ? date('d F, Y', strtotime($eventBookingData["created_at"])) : "";
                $eventBookingData["event_start_display"] = isValidDate($eventBookingData['start_date']) ? date('d F, Y', strtotime($eventBookingData["start_date"])) : "";
                $eventBookingData["event_end_display"] = isValidDate($eventBookingData['end_date']) ? date('d F, Y', strtotime($eventBookingData["end_date"])) : "";
                $eventBookingData["booking_days_display"] =  $bookingDaysDisplay;
                $eventBookingData["booking_status_display"] = (isset($eventBookingData['is_cancel']) && $eventBookingData['is_cancel'] != 0) ? "Cancel" : "Success";
                $eventBookingData["payment_status_display"] =  "Payment Paid";
                $paymentMethod =  "cash";
                $paymentMethodDisplay = getFunctionKeyValue($paymentMethod, paymentMethod());
                $eventBookingData["payment_method_status_display"] =  $paymentMethodDisplay;
                if($eventBookingData["event_start_display"] == $eventBookingData["event_end_display"]){
                    $eventBookingData["is_same_date"] = 1;
                }
                else{
                    $eventBookingData["is_same_date"] = 0;
                }

                $eventImagePath = SITE_URL('uploads/no_image.png');
                if ($eventBookingData['event_thumbnail_image'] != '' && file_exists(THUMBNAIL_EVENT_IMAGE_PATH . $eventBookingData['event_thumbnail_image'])) {
                    $eventImagePath = site_url() . THUMBNAIL_EVENT_IMAGE_PATH . $eventBookingData['event_thumbnail_image'];
                }
                $eventBookingData['event_thumbnail_image'] = $eventImagePath;

                $eventBookingRegistrationData = $this->eventModel->getEventBookingRegistrationData(array(
                    'event_booking_id' => $eventBookingId,
                    'is_multiple' => 1
                ));
                $imageData = array();
                if(!empty($eventBookingRegistrationData)) {
                    foreach ($eventBookingRegistrationData as $eventBookingRegistrationElement) {
                        $eventBookingRegistrationElement["type_display"] = strtoupper($eventBookingRegistrationElement['type']);
                        if ($eventBookingRegistrationElement["qr_code_image"] == '') {
                            $eventBookingRegistrationElement["qr_code_image"] = SITE_URL('uploads/no_image.png');
                        } else {
                            $eventBookingRegistrationElement["qr_code_image"] = SITE_URL() . EVENT_QR_CODE_IMAGE_PATH . $eventBookingRegistrationElement["qr_code_image"];
                        }
                        $imageData[] = $eventBookingRegistrationElement;
                    }
                }

                if($eventBookingData['booking_type'] == 'event_wise'){
                    $filterEventArray = array(
                        'event_id' => $eventBookingData['event_id'],
                        'is_multiple' => 1,
                    );
                }
                else {
                    $filterEventArray = array(
                        'start_date' => $eventBookingData['start_date'],
                        'end_date' => $eventBookingData['end_date'],
                        'event_id' => $eventBookingData['event_id'],
                        'is_multiple' => 1,
                    );
                }

                $eventRateData = $this->eventModel->getEventRateData($filterEventArray);

                if(!empty($eventRateData)){
                    foreach($eventRateData as $eventElement){
                        $adultRate += $eventElement['adult_rate'];
                        $childRate += $eventElement['child_rate'];
                        $guestRate += $eventElement['guest_rate'];
                    }
                }
                $summaryDetail = array(
                    'adult' => 'Adult (' . $eventBookingData['total_adult'] . ' * ' . $adultRate .' )', 
                    'child' => 'Child (' . $eventBookingData['total_child'] . ' * ' . $childRate .' )', 
                    'total_adult_price' => ($eventBookingData['total_adult'] * $adultRate),
                    'total_child_price' => ($eventBookingData['total_child'] * $childRate),
                );
                if($eventBookingData['is_guest_allowed'] == 1){
                    $summaryDetail['guest'] = 'Guest (' . $eventBookingData['total_guest'] . ' * ' . $guestRate .' )';
                    $summaryDetail['total_guest_price'] = ($eventBookingData['total_guest'] * $guestRate);
                }
                $eventBookingData["summary_data"] =  $summaryDetail;
                $eventBookingData["my_passes"] =  $imageData;
            }
            if (!empty($eventBookingData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.event_booking_listing_successfully'),
                    'data' => $eventBookingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $eventBookingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getEventDetailList()
    {
        $search = $this->request->getVar('search');
        $eventId = $this->request->getVar('event_id');
        $startDate = $this->request->getVar('start_date');
        $endDate = $this->request->getVar('end_date');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('event_id', lang('CommonWebService.event_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'is_multiple' => 1,
                'search' => $search,
                'event_id' => $eventId,
                'society_id' => $societyId,
                'user_society_id' => $userSocietyId,
            );
            if (!empty($startDate)) {
                $filterArray['start_date'] = DMYToYMD($startDate);
            }
            if (!empty($endDate)) {
                $filterArray['end_date'] = DMYToYMD($endDate);
            }
            $eventRateData = $this->eventModel->getEventRateData($filterArray);
            $adultRate = 0;
            $childRate = 0;
            $guestRate = 0;
            if(!empty($eventRateData)){
                foreach($eventRateData as $eKey => $eventRateElement){
                    $eventRateData[$eKey]['date_display'] = isValidDate($eventRateElement['date']) ? date('d M, Y', strtotime($eventRateElement["date"])) : "";
                    $paymentMethod =  "cash";
                    $paymentMethodDisplay = getFunctionKeyValue($paymentMethod, paymentMethod());

                    $eventRateData[$eKey]["payment_method_status_display"] =  $paymentMethodDisplay;
                    $isGuestAllowed = $eventRateElement['is_guest_allowed'];
                    $adultRate += $eventRateElement['adult_rate'];
                    $childRate += $eventRateElement['child_rate'];
                    $guestRate += $eventRateElement['guest_rate'];
                }
            }
            $displayArray = array(
                'adult_display' => 'Adult (Rs.'.$adultRate. ')',
                'child_display' => 'Child (Rs.'.$childRate. ')',
                'adult_amount' => $adultRate,
                'child_amount' => $childRate,
            );
            if(!empty($isGuestAllowed)){
                $displayArray['guest_display'] = 'Guest (Rs.'.$guestRate. ')';
                $displayArray['guest_amount'] = $guestRate;
            }
            if (!empty($eventRateData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.event_detail_listing_successfully'),
                    'display_rate' => $displayArray,
                    'data' => $eventRateData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'display_rate' => $displayArray,
                    'data' => $eventRateData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function enterMemberEvent()
    {
        $search = $this->request->getVar('search');
        $eventBookingRegistrationId = $this->request->getVar('event_booking_registration_id');
        
        $this->validation->setRule('event_booking_registration_id', lang('CommonWebService.event_booking_registration_id'), 'required');
        
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $eventRegistrationArray = array(
                'event_booking_registration_id' => $eventBookingRegistrationId,
                'is_enter' => 1
            );

            $evenRegistrationInsertData = $this->commonWebserviceModel->insertUpdateRecord($eventRegistrationArray, 'event_booking_registration_id', 'tbl_event_booking_registration', 1);
            
            $eventRegistrationData = $this->eventModel->getEventBookingRegistrationData(array(
                'event_booking_registration_id' => $eventBookingRegistrationId,
            ));
            if(!empty($eventRegistrationData)){
                $totalPass = ($eventRegistrationData['total_adult'] + $eventRegistrationData['total_child'] + $eventRegistrationData['total_guest']);
                $eventRegistrationData['total_pass'] = $totalPass;
                $enterMember = $eventRegistrationData['enter'];
                $eventRegistrationData['remaining'] = ($totalPass - $enterMember);
            }
            if (!empty($eventRegistrationData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.member_enter_successfully'),
                    'data' => $eventRegistrationData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $eventRegistrationData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditEventBooking()
    {
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $eventBookingId = $this->request->getVar('event_booking_id');
        $eventId = $this->request->getVar('event_id');
        $startDate = $this->request->getVar('start_date');
        $endDate = $this->request->getVar('end_date');
        $totalAdult = $this->request->getVar('total_adult');
        $totalGuest = $this->request->getVar('total_guest');
        $totalChild = $this->request->getVar('total_child');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $userId = $this->request->getVar('user_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $totalPayment = $this->request->getVar('total_payment');
        $eventType = $this->request->getVar('event_type');

        $this->validation->setRule('event_type', lang('CommonWebService.event_type'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('total_adult', lang('CommonWebService.total_adult'), 'required');
        $this->validation->setRule('total_child', lang('CommonWebService.total_child'), 'required');
        // $this->validation->setRule('total_guest', lang('CommonWebService.total_guest'), 'required');
        $this->validation->setRule('event_id', lang('CommonWebService.event_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $eventData = $this->eventModel->getEventData(array(
                'event_id' => $eventId,
            ));

            if(!empty($eventData)){
                $endDate = $eventData['end_date'];
                $bookingDeadline = date('Y-m-d H:i:s', strtotime($endDate . ' -15 minutes'));
                $currentTime = date('Y-m-d H:i:s');

                if ($currentTime > $bookingDeadline) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 400,
                        'message' => lang('CommonWebService.booking_is_no_longer_allowed') . date('d-m-Y H:i:s A', strtotime($endDate . ' -15 minutes')),
                        'data' => null
                    ), 400);
                }
            }
            if(!empty($eventData)){
                $isGuestAllowed = $eventData['is_guest_allowed'];
                $maxGuestAllowed = $eventData['max_guest_allowed'];
            }
            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            ));
            $memberName = [];
            $totalStoreAdultCount = 0;
            $totalStoreChildCount = 0;
            $totalStoreAdultChildCount = 0;
            $totalStoreGuestCount = 0;
            $totalMember = 0;

            if(!empty($ownershipFlatMemberData)){
                if($ownershipFlatMemberData['type'] == 'ownership_flat'){
                    $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatData(array(
                        'ownership_flat_id' => $ownershipFlatMemberData['type_id'],
                    ));
                }
                elseif($ownershipFlatMemberData['type'] == 'rentals'){
                    $ownershipFlatData = $this->rentalModel->getRentalsData(array(
                        'rentals_id' => $ownershipFlatMemberData['type_id'],
                        'is_api_call' => 1
                    ));
                }

                if(!empty($ownershipFlatData)){
                    $ownershipFlatMemberMultipleData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'type_id' => $ownershipFlatMemberData['type_id'],
                        'type' => $ownershipFlatMemberData['type'],
                        'is_show_all_member' => 1,
                        'is_multiple' => 1,
                    ));

                     // printArray($ownershipFlatMemberMultipleData,1);
                    $ownershipFlatMemberIdArray = array();
                    if(!empty($ownershipFlatMemberMultipleData)){
                        foreach($ownershipFlatMemberMultipleData as $ownershipFlat){
                            $ownershipFlatMemberIdArray[] = $ownershipFlat['ownership_flat_member_id'];
                        }
                    }

                    $eventFilterArray = array(
                        'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                        'event_id' => $eventId,
                        'is_cancel' => 0,
                        'is_multiple' => 1,
                    );

                    if(!empty($startDate)){
                        $eventFilterArray['start_date'] = DMYToYMD($startDate);
                    }

                    if(!empty($endDate)){
                        $eventFilterArray['end_date'] = DMYToYMD($endDate);
                    }
                    $eventBookingData = $this->eventModel->getEventBookingData($eventFilterArray);
                    
                    
                    if(!empty($eventBookingData)){
                        foreach($eventBookingData as $eventBooking){
                            $adult = $eventBooking['total_adult'];
                            $child = $eventBooking['total_child'];
                            $guest = $eventBooking['total_guest'];
                            $memberName[] = $eventBooking['member_name'];
                            // $totalStoreAdultChildCount += ($adult + $child);
                            $totalStoreGuestCount += ($guest);
                            $totalStoreAdultCount += ($adult);
                            $totalStoreChildCount += ($child);
                        }
                    }
                    $totalMember = $ownershipFlatData['total_member'];
                }
            }
            $uniqueMemberNames = array_unique($memberName);
            
            $totalStoreAdultChildCount = ($totalStoreAdultCount + $totalStoreChildCount);
            $countAdultChild = $totalAdult + $totalChild;
            if(!empty($countAdultChild)){
                if($totalStoreAdultChildCount >= $totalMember){
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 400,
                        'message' => 'Your Event Is Already Booked By ' . implode(", ", $uniqueMemberNames) ,
                        'data' => null
                    ), 400);
                }
                $countAdult = abs($totalStoreAdultChildCount + $countAdultChild);

                if($countAdult > $totalMember){
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 400,
                        'message' => 'You can add only '. abs($totalMember - $totalStoreAdultChildCount ) . " Child or Member",
                        'data' => null
                    ), 400);
                }
            }
            $currentGuestAllowed = abs($totalStoreGuestCount + $totalGuest);
            if($isGuestAllowed == 1 && !empty($totalGuest)){

                if(($totalStoreGuestCount >= $maxGuestAllowed)){
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 400,
                        'message' => 'You Already Add Guest',
                        'data' => null
                    ), 400);
                }

                if($currentGuestAllowed > $maxGuestAllowed){
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 400,
                        'message' => 'You can add only '. abs($maxGuestAllowed - $totalStoreGuestCount ) . " Guest",
                        'data' => null
                    ), 400);
                }
                
            }

            if($eventData['booking_type'] == 'event_wise'){
                $filterEventArray = array(
                    'event_id' => $eventId,
                    'is_multiple' => 1,
                );
            }
            else {
                $filterEventArray = array(
                    'start_date' => DMYToYMD($startDate),
                    'end_date' => DMYToYMD($endDate),
                    'event_id' => $eventId,
                    'is_multiple' => 1,
                );
            }

            $eventRateData = $this->eventModel->getEventRateData($filterEventArray);
            $adultRate = 0;
            $childRate = 0;
            $guestRate = 0;
            if(!empty($eventRateData)){
                foreach($eventRateData as $eventElement){
                    $adultRate += ($eventElement['adult_rate'] * $totalAdult);
                    $childRate += ($eventElement['child_rate'] * $totalChild);
                    $guestRate += ($eventElement['guest_rate'] * $totalGuest);
                }
            }

            $totalRate = $adultRate + $childRate + $guestRate;

            // if($totalRate != $totalPayment){
            //     return $this->response(array(
            //         'status' => false,
            //         'response_code' => 404,
            //         'message' => lang('CommonWebService.your_payment_is_incorrect_it_should_be_') . roundNumber($totalRate),
            //         'data' => null
            //     ), 404);
            // }
            

            $eventBookingArray = array(
                'event_booking_id' => $eventBookingId,
                'event_id' => $eventId,
                'total_adult' => $totalAdult,
                'total_guest' => $totalGuest,
                'total_child' => $totalChild,
                'society_id' => $societyId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'type' => $ownershipFlatMemberData['type'],
                'type_id' => $ownershipFlatMemberData['type_id'],
                'total_payment' => $totalPayment,
                'event_type' => $eventType,
            );
            if (!empty($startDate)) {
                $eventBookingArray['start_date'] = DMYToYMD($startDate);
            }
            if (!empty($endDate)) {
                $eventBookingArray['end_date'] = DMYToYMD($endDate);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $eventBookingData = $this->commonWebserviceModel->insertUpdateRecord($eventBookingArray, 'event_booking_id', 'tbl_event_booking', 1, '', array(), $extraData);
            $lastEventBookingId = $eventBookingData['lastInsertedId'];

            $eventBookingDisplayData = $this->eventModel->getEventBookingData(array(
                'event_booking_id' => $lastEventBookingId,
            ));
                        

            $batchArray = array();
            if(!empty($totalAdult)){
                for($i = 0; $i< $eventBookingDisplayData['total_adult']; $i++){
                    $dataArray = array(
                        'event_booking_registration_id' =>   '',
                        'event_id' => $eventId,
                        'event_booking_id' => $lastEventBookingId,
                        'type' => 'adult',
                        'qr_code_number' => GenRandomNumber(6),

                    );
                    $combineQRCodeType = $dataArray['qr_code_number'];
                    $codeContents = $combineQRCodeType;
                    qrcodeEvent('text', $codeContents, 4, '', $combineQRCodeType);
                    $dataArray['qr_code_image'] = $combineQRCodeType . '.png';
                    array_push($batchArray, $dataArray);
                }
            }
            if(!empty($totalChild)){
                for($i = 0; $i< $eventBookingDisplayData['total_child']; $i++){
                    $dataArray = array(
                        'event_booking_registration_id' =>   '',
                        'event_id' => $eventId,
                        'event_booking_id' => $lastEventBookingId,
                        'type' => 'child',
                        'qr_code_number' => GenRandomNumber(6),

                    );
                    $combineQRCodeType = $dataArray['qr_code_number'];
                    $codeContents = $combineQRCodeType;
                    qrcodeEvent('text', $codeContents, 4, '', $combineQRCodeType);
                    $dataArray['qr_code_image'] = $combineQRCodeType . '.png';

                    array_push($batchArray, $dataArray);
                }
            }

            if(!empty($totalGuest)){
                for($i = 0; $i< $eventBookingDisplayData['total_guest']; $i++){
                    $dataArray = array(
                        'event_booking_registration_id' =>   '',
                        'event_id' => $eventId,
                        'event_booking_id' => $lastEventBookingId,
                        'type' => 'guest',
                        'qr_code_number' => GenRandomNumber(6),

                    );
                    $combineQRCodeType = $dataArray['qr_code_number'];
                    $codeContents = $combineQRCodeType;
                    qrcodeEvent('text', $codeContents, 4, '', $combineQRCodeType);
                    $dataArray['qr_code_image'] = $combineQRCodeType . '.png';
                    array_push($batchArray, $dataArray);
                }
            }

            if (!empty($batchArray)) {
                $this->eventModel->batchInsert($batchArray, 'tbl_event_booking_registration');
            }


            $eventBookingFilterArray = array(
                'event_booking_id' => $lastEventBookingId,
            );
            $eventBookingInsertData = $this->eventModel->getEventBookingData($eventBookingFilterArray);
            if (!empty($eventBookingInsertData)) {
                $startDate = new DateTime($eventBookingInsertData['start_date']);
                $endDate = new DateTime($eventBookingInsertData['end_date']);
                $dateDiff = $startDate->diff($endDate)->days + 1;
                $bookingDaysDisplay = $dateDiff . ($dateDiff === 1 ? " Day" : " Days");
                $eventBookingInsertData["booking_date_display"] = isValidDate($eventBookingInsertData['created_at']) ? date('d F, Y', strtotime($eventBookingInsertData["created_at"])) : "";
                $eventBookingInsertData["event_start_display"] = isValidDate($eventBookingInsertData['start_date']) ? date('d F, Y', strtotime($eventBookingInsertData["start_date"])) : "";
                $eventBookingInsertData["event_end_display"] = isValidDate($eventBookingInsertData['end_date']) ? date('d F, Y', strtotime($eventBookingInsertData["end_date"])) : "";
                $eventBookingInsertData["booking_days_display"] =  $bookingDaysDisplay;
                $eventBookingInsertData["booking_status_display"] = (isset($eventBookingInsertData['is_cancel']) && $eventBookingInsertData['is_cancel'] != 0) ? "Cancel" : "Success";
                $eventBookingInsertData["payment_status_display"] =  "Paid";

                if($eventBookingInsertData["event_start_display"] == $eventBookingInsertData["event_end_display"]){
                    $eventBookingInsertData["is_same_date"] = 1;
                }
                else{
                    $eventBookingInsertData["is_same_date"] = 0;
                }
                $eventImagePath = SITE_URL('uploads/no_image.png');
                if ($eventBookingInsertData['event_thumbnail_image'] != '' && file_exists(THUMBNAIL_EVENT_IMAGE_PATH . $eventBookingInsertData['event_thumbnail_image'])) {
                    $eventImagePath = site_url() . THUMBNAIL_EVENT_IMAGE_PATH . $eventBookingInsertData['event_thumbnail_image'];
                }
                $eventBookingInsertData['event_thumbnail_image'] = $eventImagePath;
            }


            // printArray($batchArray,1);
            if (isset($eventBookingId) && !empty($eventBookingId)) {
                if (isset($eventBookingData['success']) && $eventBookingData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.event_booking')),
                        'data' => $eventBookingInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.event_booking')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($eventBookingData['success']) && $eventBookingData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.event_booking')),
                        'data' => $eventBookingInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.event_booking')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function cancelEvent()
    {
        $eventBookingId = $this->request->getVar('event_booking_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $userId = $this->request->getVar('user_id');
        $cancelReason = $this->request->getVar('cancel_reason');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        
        // Validation
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('event_booking_id', lang('CommonWebService.event_booking_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $eventBookingData = $this->eventModel->getEventBookingData(array(
                'event_booking_id' => $eventBookingId,
                'society_id' => $societyId,
            ));

            $eventBookingRegistrationData = $this->eventModel->getEventBookingRegistrationData(array(
                'event_booking_id' => $eventBookingId,
                'is_enter' => 1,
            ));

            if(!empty($eventBookingRegistrationData)){
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.you_already_entered_in_event_now_you_not_cancel'),
                    'data' => null
                ), 404);
            }

            if($eventBookingData['is_cancel'] == 1){
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.your_event_booking_is_already_cancel'),
                    'data' => null
                ), 404);
            }
            $filterArray = array(
                'is_active' => 1,
                'event_id' => $eventBookingData['event_id'],
                'society_id' => $societyId,
            );
            $eventData = $this->eventModel->getEventData($filterArray);
            $todayDateTime = date('Y-m-d H:i:s');
            
            $todayDate = date('Y-m-d');
            if($todayDate > $eventBookingData['end_date']){
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.no_cancellation_allowed'),
                    'data' => null
                ), 404);
            }

            // printArray($eventData,1);
            $todayDateTimeStamp = strtotime($todayDateTime);
            // Calculate allowed cancellation time (event start time - before minutes)
            $eventStartTimeStamp = strtotime($eventData['start_date']);
            $bookingStartDateTime = ($eventBookingData['start_date']);
            $bookingEndtDateTime = ($eventBookingData['end_date']);

            $beforeMinutes = (int)($eventData['before_minutes']); // Event start time
            $allowedCancelTimeStamp = $eventStartTimeStamp - ($beforeMinutes * 60);

            // if(!empty($eventBookingData['is_cancel'] == 1)){
            //     $data = array(
            //         'status' => false,
            //         'message' => lang('CommonWebService.your_event_booking_is_already_cancelled'),
            //         'data' => null,
            //         'response_code' => 404,
            //     );
            //     return $this->response($data, 404);
            // }

            // printArray(date('d-m-Y H:i:s',$todayDateTimeStamp));
            // printArray(date('d-m-Y H:i:s',$eventStartTimeStamp));
            // printArray(date('d-m-Y H:i:s',$allowedCancelTimeStamp));

            // die();
            
            if ($eventData['is_cancellation_allowed'] != 0) {
                if ($todayDateTimeStamp > $eventStartTimeStamp) {
                    $data = array(
                        'status' => false,
                        'message' => lang('CommonWebService.no_cancellation_allowed'),
                        'data' => null,
                        'response_code' => 404,
                    );
                    return $this->response($data, 404);
                } elseif ($todayDateTimeStamp > $allowedCancelTimeStamp) {
                    $data = array(
                        'status' => false,
                        'message' => lang('CommonWebService.cancellation_time_passed') . 
                        " " . date('d-m-Y H:i:s', $allowedCancelTimeStamp),
                        'data' => null,
                        'response_code' => 400,
                    );
                    return $this->response($data, 400);
                }
            } 

            $eventBookingArray = array(
                'event_booking_id' => $eventBookingId,
                'is_cancel' => 1,
                'cancel_reason' => $cancelReason,
            );
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $eventBookingData = $this->commonWebserviceModel->insertUpdateRecord($eventBookingArray, 'event_booking_id', 'tbl_event_booking', 1, '', array(), $extraData);
            $lastEventBookingId = $eventBookingData['lastInsertedId'];

            if (isset($eventBookingId) && !empty($eventBookingId)) {
                if (isset($eventBookingData['success']) && $eventBookingData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => lang('CommonWebService.event_cancelled_successfully'),
                        'data' => null
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => lang('CommonWebService.event_not_cancelled'),
                        'data' => null
                    ), 404);
                }
            }
        }
    }

    public function scanEventBooking()
    {
        $qrCodeNumber = $this->request->getVar('qr_code_number');
        $eventId = $this->request->getVar('event_id');
        // $societyId = $this->request->getVar('society_id');
        // $userId = $this->request->getVar('user_id');
        // $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        // $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('qr_code_number', lang('CommonWebService.qr_code_number'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $filterArray = array(
                'qr_code_number' => $qrCodeNumber,
                'event_id' => $eventId,
            );
            $eventBookingData = $this->eventModel->getEventBookingRegistrationData($filterArray);
            // printArray($eventBookingData,1);
            $totalPass = 0;
            if(!empty($eventBookingData)){
                if($eventBookingData['is_cancel'] == 1){
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => lang('CommonWebService.your_event_booking_is_cancel'),
                        'data' => null
                    ), 404);
                }
                if($eventBookingData['is_enter'] == 1){
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => lang('CommonWebService.you_already_entered_in_event'),
                        'data' => null
                    ), 404);
                }
                $totalPass = ($eventBookingData['total_adult'] + $eventBookingData['total_child'] + $eventBookingData['total_guest']);
                $eventBookingData['total_pass'] = $totalPass;
                $enterMember = $eventBookingData['enter'];
                $eventBookingData['remaining'] = ($totalPass - $enterMember);
                $eventStartDate = $eventBookingData['event_start_date'];
                $eventEndDate = $eventBookingData['event_end_date'];
                $bookingStartDate = $eventBookingData['booking_start_date'];
                $bookingEndDate = $eventBookingData['booking_end_date'];
                $eventStartTimeStamp = strtotime($eventStartDate);
                $eventEndTimeStamp = strtotime($eventEndDate);
                $currentTimeStamp = time(); // Current time
                $scanStartTime = $eventStartTimeStamp - (BEFORE_MINUTES_SCAN * 60); 
                $scanEndTime = $eventEndTimeStamp - (BEFORE_MINUTES_SCAN * 60);

                $today = date('Y-m-d');
                $todayScanStart = strtotime($today . ' ' . date('H:i:s', $scanStartTime));
                $todayScanEnd = strtotime($today . ' ' . date('H:i:s', $scanEndTime));
                if ($today < $bookingStartDate || $today > $bookingEndDate) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => lang('CommonWebService.invalid_date_booking_is_available_from') . YMDToDMY($bookingStartDate) . ' to ' . YMDToDMY($bookingEndDate),
                        'data' => null
                    ), 404);
                }
                // if ($currentTimeStamp < $todayScanStart || $currentTimeStamp > $todayScanEnd) {
                //     return $this->response(array(
                //         'status' => false,
                //         'response_code' => 404,
                //         'message' => lang('CommonWebService.event_scan_not_available_at_this_moment'),
                //         'data' => null
                //     ), 404);
                // }
                // printArray($currentTimeStamp);
                // // printArray(date('Y-m-d H:i:s', $scanStartTime));
                // // printArray(date('Y-m-d H:i:s', $scanEndTime));
                
                // die();
                if ($currentTimeStamp < $scanStartTime || $currentTimeStamp > $scanEndTime) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => lang('CommonWebService.event_scan_not_available_outside_of_event_range'),
                        'data' => null
                    ), 404);
                }
                

                
                // $bookingRegistrationUpdateDataArray = array(
                //     'event_booking_registration_id' => $eventBookingData['event_booking_registration_id'],
                //     'is_enter' => 1
                // );
                // $extraData = array();
                // $extraObj['api_user_id'] = $userId;
                // $extraObj['society_id'] = $societyId;
                // $extraData['is_api_data'] = $extraObj;
                // $bookingRegistrationUpdateData = $this->commonWebserviceModel->insertUpdateRecord($bookingRegistrationUpdateDataArray, 'event_booking_registration_id', 'tbl_event_booking_registration', 1, '', array(), $extraData);
                // $lastEventBookingId = $bookingRegistrationUpdateData['lastInsertedId'];
            }
            if (isset($eventBookingData) && !empty($eventBookingData)) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.event_registration_successfully'),
                    'data' => $eventBookingData
                ), 200);
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.invalid_event_pass'),
                    'data' => $eventBookingData
                ), 404);
            }
            
        }
    }

    function getComplainTicketList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $towerId = $this->request->getVar('tower_id');
        $societyId = $this->request->getVar('society_id');
        $categoryId = $this->request->getVar('category_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $complainId = $this->request->getVar('complain_id');
        $complainType = $this->request->getVar('complain_type');
        $isUrgent = $this->request->getVar('is_urgent');
        $statusId = $this->request->getVar('status_id[]');
        $complainTitle = $this->request->getVar('complain_title');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $complainIdArray = array();
            $complainMediaDataWise = array();
            $complainHistoryDataWise = array();
            $complainHistoryMediaDataWise = array();
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'tower_id' => $towerId,
                'society_id' => $societyId,
                'complain_id' => $complainId,
                'category_id' => $categoryId,
                'complain_type' => $complainType,
                'status_id' => $statusId,
                'complain_title' => $complainTitle,
                'is_urgent' => $isUrgent,
            );
            $statusData = $this->statusModel->getStatusData(array(
                'status_for' => 'complain',
                'is_multiple' => 1,
                'is_active' => 1,
            ));
            $complainData = $this->complainModel->getComplainData($filterArray);
            // printArray($statusData,1);
            $objectFilterData = array(
                'tower_id' => array('tower_id', 'tower_name'),
                'category_id' => array('category_id', 'category_name'),
                'status_id' => array('status_id', 'status_name'),
                'flat_id' => array('flat_id', 'flat_no','tower_flat_name'),
            );
            if (!empty($complainData)) {
                foreach ($complainData as $bkey => $complain) {
                    $complainIdArray[] = $complain['complain_id'];
                }
            }
            // printArray($complainIdArray,1);
            if(!empty($complainIdArray)){
                $complainHistoryData = $this->complainModel->getComplainHistoryData(array(
                    'complain_id'=> $complainIdArray,
                    'is_multiple' => 1,
                ));
                // printArray($complainHistoryData,1);
                if(!empty($complainHistoryData)){
                    foreach($complainHistoryData as $chKey => $complainHistory){
                        $complainHistoryIdArray[] = $complainHistory['complain_history_id'];
                    }
                }
                if(!empty($complainHistoryIdArray)){
                    $complainHistoryMediaData = $this->complainModel->getComplainHistoryImageData(array(
                        "complain_history_id" => $complainHistoryIdArray,
                        "is_multiple" => 1,
                    ));
                    if(!empty($complainHistoryMediaData)) {
                        foreach ($complainHistoryMediaData as $complainHistoryMediaElement) {
                            if ($complainHistoryMediaElement["complain_image"] == '') {
                                $complainHistoryMediaElement["complain_image"] = SITE_URL('uploads/no_image.png');
                                $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                if($complainHistoryMediaElement['media_type'] == 'image'){
                                    $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $complainHistoryMediaElement["complain_image"];
                                }
                                else{
                                    $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL('uploads/no_image.png');
                                }
                                $complainHistoryMediaElement["complain_image"] = SITE_URL() . MEDIA_IMAGE_PATH . $complainHistoryMediaElement["complain_image"];
                            }
                            $complainHistoryMediaDataWise[$complainHistoryMediaElement['complain_history_id']][] = $complainHistoryMediaElement;
                        }
                    }  
                }
                if(!empty($complainHistoryData)) {
                    foreach ($complainHistoryData as $chKey => $complainHistoryElement) {
                        $complainHistoryData[$chKey]['created_at_display'] = time_elapsed_string($complainHistoryElement['created_at']);
                        $complainHistoryData[$chKey]['updated_at_display'] = time_elapsed_string($complainHistoryElement['updated_at']);
                        $complainHistoryData[$chKey]['complain_history_image_data'] = array_key_exists($complainHistoryElement['complain_history_id'],$complainHistoryMediaDataWise) ? $complainHistoryMediaDataWise[$complainHistoryElement['complain_history_id']]: array();                    
                    }
                }
                if(!empty($complainHistoryData)) {
                    foreach ($complainHistoryData as $complainHistoryElement) {
                        $complainHistoryDataWise[$complainHistoryElement['complain_id']][] = $complainHistoryElement; 
                    }
                }
                $mediaData = $this->complainModel->getMediaData(array(
                    "media_for_id" => $complainIdArray,
                    "media_for" => 'complain',
                    "is_multiple" => 1,
                ));
                if(!empty($mediaData)) {
                    foreach ($mediaData as $mediaElement) {
                        if ($mediaElement["media_file"] == '') {
                            $mediaElement["media_file"] = SITE_URL('uploads/no_image.png');
                            if($mediaElement['media_type'] == 'image'){
                                $mediaElement["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                            }
                        } else {
                            if($mediaElement['media_type'] == 'image'){ 
                                $mediaElement["thumbnail_media_file"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $mediaElement["media_file"];
                            }
                            else{
                                $mediaElement["thumbnail_media_file"] = SITE_URL('uploads/no_image.png'); 
                            }
                            $mediaElement["media_file"] = SITE_URL() . MEDIA_IMAGE_PATH . $mediaElement["media_file"];
                            
                            
                        }
                        $complainMediaDataWise[$mediaElement['media_for_id']][] = $mediaElement;
                    }
                }
            }

            $isUrgentCount = 0;
            if (!empty($complainData)) {
                foreach ($complainData as $bkey => $complain) {
                    $complainData[$bkey] = getModuleObjectData($objectFilterData, $complain);
                    $complainData[$bkey]['created_at'] = YMDToDMY($complain["created_at"], true);
                    $complainData[$bkey]['updated_at'] = YMDToDMY($complain["updated_at"], true);
                    $complainData[$bkey]['created_at_display'] = time_elapsed_string($complain['created_at']);
                    $complainData[$bkey]['updated_at_display'] = time_elapsed_string($complain['updated_at']);
                    $complainData[$bkey]['complain_image_data'] = array_key_exists($complain['complain_id'], $complainMediaDataWise) ? $complainMediaDataWise[$complain['complain_id']] : array();
                    $complainData[$bkey]['complain_history_data'] = array_key_exists($complain['complain_id'],$complainHistoryDataWise) ? $complainHistoryDataWise[$complain['complain_id']]: array();
                    $complainData[$bkey]['complainant_name'] = (isset($complain['complainant_name']) && $complain['complainant_name'] != "") ? $complain['complainant_name'] : $complain['created_by'];

                    if($complainData[$bkey]['complain_created_by'] == $userSocietyId){
                        $complainData[$bkey]['is_complain_created_by_me'] = 1;
                    } else {
                        $complainData[$bkey]['is_complain_created_by_me'] = 0;
                    }
                    if($complain['is_urgent'] == 1){
                        $isUrgentCount++;
                    }
                }
            }
            if (!empty($complainData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.complain_listing_successfully'),
                    'status_data' => $statusData,
                    'data' => $complainData,
                    'is_urgent_count' => $isUrgentCount,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                //return $this->respond($data,200);
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'status_data' => $statusData,
                    'data' => $complainData,
                    'is_urgent_count' => $isUrgentCount,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                //return $this->respond($data,404);
                return $this->response($data, 404);
            }
        }
    }

    function getAmenitiesList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $amenitiesId = $this->request->getVar('amenities_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'society_id' => $societyId,
                'amenities_id' => $amenitiesId,
                // 'status' => array('approved')
            );
            $amenitiesData = $this->amenitiesModel->getAmenitiesData($filterArray);

            // printARRAY($amenitiesData,1);
            if (!empty($amenitiesData)) {
                foreach ($amenitiesData as $akey => $amenities) {
                    $amenitiesData[$akey]['timings'] = date('h:i A', strtotime($amenities['from_hour'])) . ' - ' . date('h:i A', strtotime($amenities['to_hour']));
                    if ((strtotime(date('H:i:s')) >= strtotime($amenities['from_hour'])) && (strtotime(date('H:i:s')) <= strtotime($amenities['to_hour']))) {
                        $amenitiesData[$akey]['amenities_status'] = 'Open';
                    } else {
                        $amenitiesData[$akey]['amenities_status'] = 'Closed';
                    }
                    $amenitiesData[$akey]['created_at'] = YMDToDMY($amenities["created_at"], true);
                    $amenitiesData[$akey]['updated_at'] = YMDToDMY($amenities["updated_at"], true);
                    $amenitiesData[$akey]['created_at_display'] = time_elapsed_string($amenities['created_at']);
                    $amenitiesData[$akey]['updated_at_display'] = time_elapsed_string($amenities['updated_at']);
                }
            }
            if (!empty($amenitiesData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.amenities_listing_successfully'),
                    'data' => $amenitiesData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                //return $this->respond($data,200);
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $amenitiesData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                //return $this->respond($data,404);
                return $this->response($data, 404);
            }
        }
    }

    

    public function getAmenitiesDetails()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $amenitiesId = $this->request->getVar('amenities_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $pickDate = $this->request->getVar('pick_date'); // Pick date parameter
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('amenities_id', lang('Amenities.amenities_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('pick_date', lang('CommonWebService.pick_date'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response([
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ], 400);
        } else {
            $isToday = (date('Y-m-d') === date('Y-m-d', strtotime($pickDate)));
            $pickDataDay = date('l', strtotime($pickDate));
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = [
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'society_id' => $societyId,
                'amenities_id' => $amenitiesId,
            ];
            $amenitiesData = $this->amenitiesModel->getAmenitiesData($filterArray);
            $amenitiesIdArray = [];
            if ($amenitiesData) {
                foreach ($amenitiesData as $amenitiesElement) {
                    array_push($amenitiesIdArray, $amenitiesElement['amenities_id']);
                }
            }
            $amenitiesUnitDataAmenitiesIdWise = [];
            if (!empty($amenitiesIdArray)) {
                $amenitiesUnitData = $this->amenitiesModel->getAmenitiesUnitData([
                    "amenities_id" => $amenitiesIdArray,
                    'is_multiple' => 1
                ]);
                if (!empty($amenitiesUnitData)) {
                    foreach ($amenitiesUnitData as $amenitiesUnitElement) {
                        $amenitiesUnitDataAmenitiesIdWise[$amenitiesUnitElement['amenities_id']][] = $amenitiesUnitElement;
                    }
                }
            }
            $amenitiesBookingSlotDataAmenitiesIdWise = [];
            $amenitiesBookingSlotData = $this->amenitiesModel->getAmenitiesBookingSlotData([
                "amenities_id" => $amenitiesIdArray,
                'is_multiple' => 1
            ]);
            $amenitiesBookingSlotDayData = $this->amenitiesModel->getAmenitiesBookingSlotDayData([
                "amenities_id" => $amenitiesIdArray,
                'is_multiple' => 1,
            ]);
            $bookingSlotDataAmenitiesIdWise = [];
            if (!empty($amenitiesBookingSlotDayData)) {
                foreach ($amenitiesBookingSlotDayData as $amenitiesBookingSlotDayElement) {
                    $bookingSlotDataAmenitiesIdWise[$amenitiesBookingSlotDayElement['amenities_id']][] = $amenitiesBookingSlotDayElement;
                }
            }
            if (!empty($amenitiesBookingSlotData)) {
                foreach ($amenitiesBookingSlotData as $absKey => $amenitiesBookingSlots) {
                    $startTime = $amenitiesBookingSlots['start_time'] ?? ''; // 'HH:mm' format
                    $endTime = $amenitiesBookingSlots['end_time'] ?? ''; // 'HH:mm' format
                    $hours = $amenitiesBookingSlots['hour'] ?? 1; // slot duration in hours
                    $minutes = $amenitiesBookingSlots['minutes'] ?? 0; // slot duration in minutes
                    $currentTime = date('H:i'); // current real time in 'HH:mm'
                    $currentTimestamp = strtotime($currentTime); // current real time as a timestamp
                    $timeSlots = [];
                    $startTimestamp = strtotime($startTime);
                    $endTimestamp = strtotime($endTime);
                    $interval = ($hours * 3600) + ($minutes * 60); // slot interval in seconds
                    if ($isToday) {
                        $current = max($currentTimestamp, $startTimestamp);
                        $roundedCurrent = ceil(($current - $startTimestamp) / $interval) * $interval + $startTimestamp;
                        $current = max($startTimestamp, $roundedCurrent); // Use rounded start time
                    } else {
                        $current = $startTimestamp; // If not today, start from the beginning
                    }
                    while ($current < $endTimestamp) {
                        $slotStartTimestamp = $current;
                        $slotEndTimestamp = $current + $interval;
                        if ($slotEndTimestamp > $endTimestamp) {
                            $slotEndTimestamp = $endTimestamp;
                        }
                        $slotStart = date('h:i A', $slotStartTimestamp);
                        $slotEnd = date('h:i A', $slotEndTimestamp);
                        $timeSlots[] = $slotStart . ' - ' . $slotEnd; // add the time slot to the array
                        $current += $interval;
                    }
                    $amenitiesBookingSlotData[$absKey]['time_slots'] = $timeSlots;
                    $amenitiesBookingSlotData[$absKey]['booking_slot_timings'] = date('h:i A', strtotime($amenitiesBookingSlots['start_time'])) . ' - ' . date('h:i A', strtotime($amenitiesBookingSlots['end_time']));
                }
            }
            if (!empty($amenitiesBookingSlotData)) {
                foreach ($amenitiesBookingSlotData as $absKey => $amenitiesBookingSlots) {
                    $amenitiesBookingSlotDataAmenitiesIdWise[$amenitiesBookingSlots['amenities_id']][] = $amenitiesBookingSlots;
                }
            }
            if ($amenitiesData) {
                foreach ($amenitiesData as $aKey => $amenitiesDataElement) {
                    $amenitiesData[$aKey]['timings'] = date('h:i A', strtotime($amenitiesDataElement['from_hour'])) . ' - ' . date('h:i A', strtotime($amenitiesDataElement['to_hour']));
                    if ((strtotime(date('H:i:s')) >= strtotime($amenitiesDataElement['from_hour'])) && (strtotime(date('H:i:s')) <= strtotime($amenitiesDataElement['to_hour']))) {
                        $amenitiesData[$aKey]['amenities_status'] = 'Open';
                    } else {
                        $amenitiesData[$aKey]['amenities_status'] = 'Closed';
                    }
                    $amenitiesData[$aKey]['amenities_unit_data'] = array_key_exists($amenitiesDataElement['amenities_id'], $amenitiesUnitDataAmenitiesIdWise) ? $amenitiesUnitDataAmenitiesIdWise[$amenitiesDataElement['amenities_id']] : [];
                    $amenitiesData[$aKey]['amenities_booking_slot_data'] = array_key_exists($amenitiesDataElement['amenities_id'], $amenitiesBookingSlotDataAmenitiesIdWise) ? $amenitiesBookingSlotDataAmenitiesIdWise[$amenitiesDataElement['amenities_id']] : [];
                }
            }
            if (!empty($amenitiesData)) {
                $data = [
                    'status' => true,
                    'message' => lang('CommonWebService.amenities_details_listing_successfully'),
                    'data' => $amenitiesData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                ];
                return $this->response($data, 200);
            } else {
                $data = [
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $amenitiesData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                ];
                return $this->response($data, 404);
            }
        }
    }

    public function addEditBooking()
    {
        $bookingId = $this->request->getVar('booking_id');
        $amenitiesUnitId = $this->request->getVar('amenities_unit_id');
        $bookingDate = $this->request->getVar('booking_date');
        $amenitiesId = $this->request->getVar('amenities_id');
        $startTime = $this->request->getVar('start_time');
        $endTime = $this->request->getVar('end_time');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $userId = $this->request->getVar('user_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('booking_date', lang('CommonWebService.booking_date'), 'required');
        $this->validation->setRule('amenities_id', lang('CommonWebService.amenities_id'), 'required');
        $this->validation->setRule('amenities_unit_id', lang('CommonWebService.amenities_unit_id'), 'required');
        $this->validation->setRule('start_time', lang('CommonWebService.start_time'), 'required');
        $this->validation->setRule('end_time', lang('CommonWebService.end_time'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            $amenitiesData = $this->amenitiesModel->getAmenitiesData(array(
            'amenities_id' => $amenitiesId
            ));
            
            if(!empty($amenitiesData)){
                if(isset($amenitiesData['admin_approval_required']) && $amenitiesData['admin_approval_required'] != 0){
                    $adminApprovalRequired = 1;
                } else {
                    $adminApprovalRequired = 0;
                }
            }

            $dbFlatId = 0;
            $getOwnershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array('ownership_flat_member_id' => $ownershipFlatMemberId, 'is_show_all_member' => 1,'is_active' => 1));
            $dbFlatId = isset($getOwnershipFlatMemberData['flat_id']) ? $getOwnershipFlatMemberData['flat_id'] : 0;
            $bookingDateFilter = array(
                'booking_date' => DMYToYMD($bookingDate),
                'amenities_id' => $amenitiesId,
                'start_time' => $startTime,
                'end_time' => $endTime,
                'booking_id_not' => $bookingId,
                'amenities_unit_id' => $amenitiesUnitId,
                'society_id' => $societyId,
                'is_api' => 1,
                'is_multiple' => 1
            );
            $bookingAmenitiesData = $this->bookingModel->getBookingData($bookingDateFilter);
            // lastQuery();
            // printArray($bookingAmenitiesData,1);
            if (!empty($bookingAmenitiesData)) {
                foreach ($bookingAmenitiesData as $key => $bookingAmenities) {
                    if($bookingAmenities['cancel_by'] == 0){
                        return $this->response(array(
                                'status' => FALSE,
                                'message' => 'Amenities ' . $bookingAmenities['amenities_name'] . lang('Booking.amenities_already_booked_for_this_time_slot'),
                                'data' => null,
                                'response_code' => 400,
                            )
                            , 400);
                        exit();
                    }
                }
            }
            $isPaymentRequired = 0;
            $taxId = 0;
            $taxRate = 0;
            $amenitiesData = $this->amenitiesModel->getAmenitiesData(array('amenities_id' => $amenitiesId));
            if (!empty($amenitiesData)) {
                $isPaymentRequired = isset($amenitiesData['payment_required']) ? $amenitiesData['payment_required'] : 0;
                $taxId = isset($amenitiesData['tax_id']) ? $amenitiesData['tax_id'] : 0;
                $taxRate = isset($amenitiesData['tax_rate']) ? $amenitiesData['tax_rate'] : 0;
            }
            $unitPrice = 0;
            $amenitiesBookingSlotUnitPriceId = 0;
            $getAmenitiesBookingSlotUnitPriceData = $this->amenitiesModel->getAmenitiesBookingSlotUnitPriceData(array('amenities_id' => $amenitiesId, 'unit_id' => $amenitiesUnitId));
            if (!empty($getAmenitiesBookingSlotUnitPriceData)) {
                $unitPrice = isset($getAmenitiesBookingSlotUnitPriceData['price']) ? $getAmenitiesBookingSlotUnitPriceData['price'] : 0;
                $amenitiesBookingSlotUnitPriceId = isset($getAmenitiesBookingSlotUnitPriceData['amenities_booking_slot_unit_price_id']) ? $getAmenitiesBookingSlotUnitPriceData['amenities_booking_slot_unit_price_id'] : 0;
            }
            $amount = 0;
            if ($unitPrice != 0) {
                $unitTaxAmount = $unitPrice * $taxRate / 100;
                $amount = $unitPrice + roundNumber($unitTaxAmount, 2);
            }
            $bookingUpdateArray = array();
            $bookingArray = array(
                'booking_id' => $bookingId,
                'amenities_unit_id' => $amenitiesUnitId,
                'booking_date' => DMYToYMD($bookingDate),
                'amenities_id' => $amenitiesId,
                'start_time' => $startTime,
                'end_time' => $endTime,
                'flat_id' => $dbFlatId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'amenities_booking_slot_unit_price_id' => $amenitiesBookingSlotUnitPriceId,
                'unit_price' => $unitPrice,
                'tax_id' => $taxId,
                'amount' => $amount,
                // 'status' => $adminApprovalRequired != 0,
                'society_id' => $societyId,
                'is_active' => 1,
            );

            if($adminApprovalRequired == 0){
                $bookingArray['status'] = 'confirmed';   
            } else {
                $bookingArray['status'] = 'pending';
            }

            if (!empty($bookingId)) {
                $bookingUpdateArray = $this->bookingModel->getBookingData(array(
                    'booking_id' => $bookingId,
                    'is_api' => 1,
                    'society_id' => $societyId,
                ));
                $bookingUpdateArray = compareArray($bookingArray, $bookingUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $bookingData = $this->commonWebserviceModel->insertUpdateRecord($bookingArray, 'booking_id', 'tbl_booking', 1, '', array(), $extraData, $bookingUpdateArray);
            $lastBookingId = $bookingData['lastInsertedId'];

            if (($bookingId == '') && ($adminApprovalRequired == 1)) {
                $memberIdArray = array();
                $notificationDataArray = array();
                $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                    'resource_type_name' => RESOURCE_TYPE_MANAGER,
                    'society_id' => $societyId,
                ));
                $userManagerData = $this->commonWebserviceModel->getUserSocietyData(array(
                    'society_id' => $societyId,
                    'resource_type_id' => $resourceTypeData['resource_type_id'],
                    'is_active' => 1,
                    'is_multiple' => 1
                ));
                // printArray($userManagerData,1);
                $userDeviceUserIdArray = [];
                $userDeviceUserTypeIdArray = [];
                $userDeviceUserTypeArray = [];
                if (!empty($userManagerData)) {
                    foreach ($userManagerData as $userManagerElement) {
                        $userDeviceUserIdArray[] = isset($userManagerElement['user_society_id']) ? $userManagerElement['user_society_id'] : 0;
                    }
                    $userDevice = $this->commonWebserviceModel->deviceData(array(
                        "user_society_id" => $userDeviceUserIdArray,
                        "user_type" => MANAGER_APP,
                        "is_latest" => 1,
                        "is_multiple" => 1
                    ));
                    if (!empty($userDevice)) {
                        foreach ($userDevice as $userDeviceElement) {
                            if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
                                $notificationArray = array(
                                    'ownership_flat_id' => 0,
                                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                                    'type' => 'amenities',
                                    'status' => 'amenities',
                                    'type_id' => $lastBookingId,
                                    'user_society_id' => $userSocietyId,
                                    'member_name' => $getOwnershipFlatMemberData['name'],
                                    'society_id' => $societyId,
                                    'notification_title' => 'New Amenities Booking',
                                    'description' => 'A new amenities booking has been registered by '.$getOwnershipFlatMemberData['name'].' regarding ',
                                    'module' => 'amenities',
                                    'action_type' => 'sent',
                                    'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                    'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                    'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                    'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
                                    // 'app_url' => MEMBER_URL .'ticket_detail_page/' . $lastBookingId,
                                );

                                if ($appType == MEMBER_APP) {
                                    $notificationArray['send_for_notification'] = $appType;
                                    $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                    $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                    $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                }
                                $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                array_push($notificationDataArray, $notificationArray);
                            }
                        }
                    }
            
                }
                if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                    sendNotificationComplainAndroid($notificationDataArray);
                }
            }
            if (isset($bookingId) && !empty($bookingId)) {
                if (isset($bookingData['success']) && $bookingData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.booking')),
                        'data' => null
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.booking')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($bookingData['success']) && $bookingData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.booking')),
                        'data' => null
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.booking')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function approveAmenitiesBooking()
    {
        $bookingId = $this->request->getVar('booking_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $userId = $this->request->getVar('user_id');
        $this->validation->setRule('booking_id', lang('Booking.booking_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            $bookingUpdateArray = array();
            $bookingArray = array(
                'booking_id' => $bookingId,
                'status' => 'confirmed',
                'approved_by' => $userId,
                'approved_at' => DATE_TIME_DATABASE,
                'updated_by' => $userId,
                'updated_at' => DATE_TIME_DATABASE
            );
            if (!empty($bookingId)) {
                $bookingUpdateArray = $this->bookingModel->getBookingData(array(
                    'booking_id' => $bookingId,
                    'society_id' => $societyId,
                    'is_api' => 1,
                ));
                $bookingUpdateArray = compareArray($bookingArray, $bookingUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $bookingData = $this->commonWebserviceModel->insertUpdateRecord($bookingArray, 'booking_id', 'tbl_booking', 1, '', array(), $extraData, $bookingUpdateArray);
            $lastBookingId = $bookingData['lastInsertedId'];


            $bookingStoreData = $this->bookingModel->getBookingData(array(
                'booking_id' => $bookingId,
                'society_id' => $societyId,
                'is_api' => 1,
            ));

            $userSocietyIdArray = array();
            $memberIdArray = array();
            $customerData = array();
            $batchNotificationDataArray = array();
            $sendNotificationDataArray = array();
            $notificationArray = array(
                'notification_title' => 'Amenities Approve',
                'description' => 'A new Amenities Approve '.$bookingStoreData['amenities_name'],
            );
            $deviceIdArray = array();
            $iosDeviceIdArray = array();
            $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
            $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
            $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                'resource_type_name' => RESOURCE_TYPE_MEMBER,
                'society_id' => $this->session->get('society_id'),
            ));
            $userTypeId = isset($bookingStoreData['ownership_flat_member_id']) ? $bookingStoreData['ownership_flat_member_id'] : 0;

            if(!empty($userTypeId)){
                $userDeviceArray = $this->common_web_service_model->deviceData(array(
                    "user_type_id" => $userTypeId,
                    'user_type' => MEMBER_APP,
                    "is_latest" => 1,
                    "is_multiple" => 1,
                ));
            }
            if(!empty($userDeviceArray)){
                foreach($userDeviceArray as $userDevice){
                    $notificationOtherArray = array(
                        'notification_id' => '',
                        'society_id' => $this->session->get('society_id'),
                        'notification_date' => TODAY_DATE_YMD,
                        'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                        'type' => 'amenities',
                        'type_id' => $bookingId,
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId'],
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                    $notificationOtherArray['send_for_notification'] = 'manager';
                    $notificationOtherArray['send_for_notification_id'] = $this->data['userId'];
                    $notificationOtherArray['receive_for_notification'] = $userDevice['user_type'];
                    $notificationOtherArray['receive_for_notification_id'] = $userDevice['user_type_id'];
                    if(!empty($notificationArray)){
                        $notificationArray = array_merge($notificationArray,$notificationOtherArray);
                        $extraDataJsonArray = $notificationArray;
                        $extraDataJsonArray['module'] = 'amenities';
                        $extraDatajson = json_encode($extraDataJsonArray);
                        $notificationArray['extra_data'] = $extraDatajson;
                        $customerData['extra_data'] = $extraDatajson;
                        //send notification data
                        $deviceToken = $userDevice['one_signal_id'];
                        $deviceId = $userDevice['device_id'];
                        $batchNotificationDataArray[] = $notificationArray;

                        $sendNotificationDataArray[] = array(
                            'notification_title' => 'Amenities Approve',
                            'description' => 'A new Amenities Approve '.$bookingStoreData['amenities_name'],
                            'extra_data_json' => $extraDatajson,
                            'app_url' => MEMBER_URL .'my_booking/' . $bookingId,
                            'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                            'device_id' => $userDevice['device_id'],
                            'type' => 'amenities',
                        );
                    }
                }
            }
            if(!empty($batchNotificationDataArray)){
                $this->ownership_flat_model->batchInsert($batchNotificationDataArray,'tbl_notification');
            }
            if(!empty($sendNotificationDataArray)){
                sendNotification($sendNotificationDataArray);
            }

            if (isset($bookingId) && !empty($bookingId)) {
                if (isset($bookingData['success']) && $bookingData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => lang('Booking.booking_approved'),
                        'data' => $bookingStoreData,
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => lang('Booking.booking_approved_failed'),
                        'data' => null
                    ), 404);
                }
            }
        }
    }

    public function cancelBooking()
    {
        $bookingId = $this->request->getVar('booking_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $userId = $this->request->getVar('user_id');
        $this->validation->setRule('booking_id', lang('CommonWebService.booking_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $bookingData = $this->bookingModel->getBookingData(array('booking_id' => $bookingId, 'is_api' => 1,
                'society_id' => $societyId));
            if (empty($bookingData)) {
                return $this->response(array(
                        'status' => FALSE,
                        'message' => lang('CommonWebService.no_data_found'),
                        'data' => null,
                        'response_code' => 400,
                    )
                    , 400);
            }
            $dbBookingStatus = '';
            $dbStartTime = '';
            $dbEndTime = '';
            if (!empty($bookingData)) {
                $dbBookingStatus = isset($bookingData['status']) ? $bookingData['status'] : '';
                $dbStartTime = isset($bookingData['start_time']) ? $bookingData['start_time'] : '';
                $dbEndTime = isset($bookingData['end_time']) ? $bookingData['end_time'] : '';
                $paymentRequired = isset($bookingData['payment_required']) ? $bookingData['payment_required'] : '';
                if ($dbBookingStatus == 'cancelled') {
                    return $this->response(array(
                            'status' => FALSE,
                            'message' => 'Booking Status Already Cancelled',
                            'data' => null,
                            'response_code' => 400,
                        )
                        , 400);
                }
                // $currentDateTime = new DateTime();
                // $bookingDateTime = new DateTime($bookingData['booking_date'] . ' ' . $dbStartTime);
                // $currentDateTime = date('Y-m-d H:i:s');
                // $bookingDateTime = $bookingData['booking_date'] . ' ' . $dbStartTime; // Booking date and start time
                $currentDateTime = strtotime(date('Y-m-d H:i:s')); // Current date and time as a timestamp
                $bookingDateTime = strtotime($bookingData['booking_date'] . ' ' . $dbStartTime); // Booking date and start time as a timestamp

                // printArray($bookingDateTime,1);
                if ($currentDateTime >= $bookingDateTime) {
                    return $this->response(array(
                        'status' => false,
                        'message' => 'Sorry, this booking has already started and cannot be cancelled.',
                        'data' => null,
                        'response_code' => 400,
                    ), 400);
                }

                if (isset($paymentRequired) && $paymentRequired != 0) {
                    $cancelBefore = isset($bookingData['cancel_before']) ? (int)$bookingData['cancel_before'] : 0;
                    $cancelBeforeType = isset($bookingData['cancel_before_type']) ? $bookingData['cancel_before_type'] : '';
                    // if ($cancelBeforeType === 'minutes') {
                    //     $bookingDateTime->modify('-' . $cancelBefore . ' minutes');
                    // } elseif ($cancelBeforeType === 'hours') {
                    //     $bookingDateTime->modify('-' . $cancelBefore . ' hours');
                    // }
                    if ($cancelBeforeType === 'minutes') {
                        $adjustedBookingTime = $bookingDateTime - ($cancelBefore * 60);
                    } elseif ($cancelBeforeType === 'hours') {
                        $adjustedBookingTime = $bookingDateTime - ($cancelBefore * 3600);
                    }
                    // printArray($adjustedBookingTime,1);
                    if ($currentDateTime > $adjustedBookingTime) {
                        return $this->response(array(
                            'status' => false,
                            'message' => 'Cancellations Must Be Made Atleast '. $cancelBefore .' '. $cancelBeforeType .' ago',
                            'data' => null,
                            'response_code' => 400,
                        ), 400);
                    }
                }
            }
            $bookingUpdateArray = array();
            $bookingArray = array(
                'booking_id' => $bookingId,
                'status' => 'cancelled',
                'cancel_at' => date('Y-m-d H:i:s'),
                'cancel_by' => $userId,
            );
            if (!empty($bookingId)) {
                $bookingUpdateArray = $this->bookingModel->getBookingData(array(
                    'booking_id' => $bookingId,
                    'is_api' => 1,
                    'society_id' => $societyId,
                ));
                $bookingUpdateArray = compareArray($bookingArray, $bookingUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $bookingData = $this->commonWebserviceModel->insertUpdateRecord($bookingArray, 'booking_id', 'tbl_booking', 1, '', array(), $extraData, $bookingUpdateArray);

            $bookingStoreData = $this->bookingModel->getBookingData(array(
                'booking_id' => $bookingId,
                'society_id' => $societyId,
                'is_api' => 1,
            ));

            $userSocietyIdArray = array();
            $memberIdArray = array();
            $customerData = array();
            $batchNotificationDataArray = array();
            $sendNotificationDataArray = array();
            $notificationArray = array(
                'notification_title' => 'Amenities Approve',
                'description' => 'A new Amenities Approve '.$bookingStoreData['amenities_name'],
            );
            $deviceIdArray = array();
            $iosDeviceIdArray = array();
            $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
            $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
            $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                'resource_type_name' => RESOURCE_TYPE_MEMBER,
                'society_id' => $this->session->get('society_id'),
            ));
            $userTypeId = isset($bookingStoreData['ownership_flat_member_id']) ? $bookingStoreData['ownership_flat_member_id'] : 0;

            if(!empty($userTypeId)){
                $userDeviceArray = $this->common_web_service_model->deviceData(array(
                    "user_type_id" => $userTypeId,
                    'user_type' => MEMBER_APP,
                    "is_latest" => 1,
                    "is_multiple" => 1,
                ));
            }
            if(!empty($userDeviceArray)){
                foreach($userDeviceArray as $userDevice){
                    $notificationOtherArray = array(
                        'notification_id' => '',
                        'society_id' => $this->session->get('society_id'),
                        'notification_date' => TODAY_DATE_YMD,
                        'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                        'type' => 'amenities',
                        'type_id' => $bookingId,
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId'],
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                    $notificationOtherArray['send_for_notification'] = 'manager';
                    $notificationOtherArray['send_for_notification_id'] = $this->data['userId'];
                    $notificationOtherArray['receive_for_notification'] = $userDevice['user_type'];
                    $notificationOtherArray['receive_for_notification_id'] = $userDevice['user_type_id'];
                    if(!empty($notificationArray)){
                        $notificationArray = array_merge($notificationArray,$notificationOtherArray);
                        $extraDataJsonArray = $notificationArray;
                        $extraDataJsonArray['module'] = 'amenities';
                        $extraDatajson = json_encode($extraDataJsonArray);
                        $notificationArray['extra_data'] = $extraDatajson;
                        $customerData['extra_data'] = $extraDatajson;
                        //send notification data
                        $deviceToken = $userDevice['one_signal_id'];
                        $deviceId = $userDevice['device_id'];
                        $batchNotificationDataArray[] = $notificationArray;

                        $sendNotificationDataArray[] = array(
                            'notification_title' => 'Amenities Approve',
                            'description' => 'A new Amenities Approve '.$bookingStoreData['amenities_name'],
                            'extra_data_json' => $extraDatajson,
                            'app_url' => MEMBER_URL .'my_booking/' . $bookingId,
                            'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                            'device_id' => $userDevice['device_id'],
                            'type' => 'amenities',
                        );
                    }
                }
            }
            if(!empty($batchNotificationDataArray)){
                $this->ownership_flat_model->batchInsert($batchNotificationDataArray,'tbl_notification');
            }
            if(!empty($sendNotificationDataArray)){
                sendNotification($sendNotificationDataArray);
            }

            $bookingListData = $this->bookingModel->getBookingData(array(
                'booking_id' => $bookingId,
                'society_id' => $societyId,
                'is_api' => 1,
                'is_multiple' => 1,
            ));
            if (!empty($bookingListData)) {
                foreach ($bookingListData as $bkey => $bookingList) {
                    $bookingListData[$bkey]['start_time_display'] = isset($bookingList['start_time']) ? date("h:i A", strtotime($bookingList['start_time'])) : '';
                    $bookingListData[$bkey]['end_time_display'] = isset($bookingList['end_time']) ? date("h:i A", strtotime($bookingList['end_time'])) : '';
                    $bookingListData[$bkey]['start_and_end_time_display'] = $bookingListData[$bkey]['start_time_display'] . ' - ' . $bookingListData[$bkey]['end_time_display'];
                    $bookingListData[$bkey]["booking_date_display"] = isValidDate($bookingList['booking_date']) ? date('d M, Y', strtotime($bookingList["booking_date"])) : "";
                    $bookingListData[$bkey]['created_at'] = YMDToDMY($bookingList["created_at"], true);
                    $bookingListData[$bkey]['updated_at'] = YMDToDMY($bookingList["updated_at"], true);
                    $bookingListData[$bkey]['created_at_display'] = time_elapsed_string($bookingList['created_at']);
                    $bookingListData[$bkey]['updated_at_display'] = time_elapsed_string($bookingList['created_at']);
                    $bookingListData[$bkey]['display_status'] = underscoreToUcWord($bookingList['status']);
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $bookingListData[$bkey]['share_data'] = $shareData;
                }
            }
            if (isset($bookingData['success']) && $bookingData['success']) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => "Booking Cancelled Successfully",
                    'data' => $bookingListData,
                ), 200);
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => 'Failed To Cancel Booking',
                    'data' => $bookingListData,
                ), 404);
            }
        }
    }

    function checkPin()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $pin = $this->request->getVar('pin');
        $appType = $this->request->getVar('app_type');
        // $societyId = $this->request->getVar('society_id');
        $permissionsArray = [];
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('pin', lang('CommonWebService.pin'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'user_society_id' => $userSocietyId,
            );
            $userData = $this->commonWebserviceModel->getUserSocietyData($filterArray);

            if($appType == GATE_KEEPER){
                $permissionsToCheck = gatekeeperAppPermission();

                $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                    'user_society_id' => $userSocietyId,
                    // 'society_id' => $societyId,
                ));
                if(!empty($userDataPermissionFilter)){
                    $permissions = $userDataPermissionFilter['permissions'];
                    $unserializedData = unserialize($permissions);
                    
                    foreach ($permissionsToCheck as $key => $value) {
                        if(!empty($unserializedData)){
                            if (in_array("MobileGatekeeperApp|$key", $unserializedData)) {
                                $permissionsArray[] = $key;
                            }
                        }
                    }                                    
                }
            }

            $dbPin = isset($userData['pin']) ? $userData['pin'] : 0;
            if (password_verify($pin, $dbPin)) {
                $responseData = true;
            } else {
                $responseData = false;
            }
            if ($responseData) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.pin_verified_successfully'),
                    'data' => null,
                    'user_permission_array' => $permissionsArray,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.invalid_pin'),
                    'data' => null,
                    'user_permission_array' => null,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    function changePin()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $userId = $this->request->getVar('user_id');
        $oldPin = $this->request->getVar('old_pin');
        $newPin = $this->request->getVar('new_pin');
        $confirmPin = $this->request->getVar('confirm_pin');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('old_pin', lang('CommonWebService.old_pin'), 'required|numeric|exact_length[4]');
        $this->validation->setRule('new_pin', lang('CommonWebService.new_pin'), 'required|numeric|exact_length[4]');
        $this->validation->setRule('confirm_pin', lang('CommonWebService.confirm_pin'), 'required|numeric|exact_length[4]');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'user_society_id' => $userSocietyId,
            );
            $userData = $this->commonWebserviceModel->getUserSocietyData($filterArray);
            $dbPin = isset($userData['pin']) ? $userData['pin'] : 0;
            if (password_verify($oldPin, $dbPin)) {
                if ($oldPin == $newPin) {
                    $data = array(
                        'status' => false,
                        'message' => lang('CommonWebService.new_pin_should_be_different_from_old_pin'),
                        'data' => null,
                        'response_code' => 404,
                    );
                    return $this->response($data, 404);
                } else {
                    if ($newPin == $confirmPin) {
                        $filterPin = $this->ionAuthModel->hashPassword($confirmPin);
                        $userPinArray['pin'] = $filterPin;
                        $userPinArray['updated_at'] = date('Y-m-d H:i:s');
                        $userPinArray['updated_by'] = $userId;
                        $responseData = $this->commonWebserviceModel->updateData($userPinArray, 'tbl_user_society', 'user_society_id', $userData['user_society_id']);
                    } else {
                        $data = array(
                            'status' => false,
                            'message' => lang('CommonWebService.confirm_pin_mismatch_new_pin'),
                            'data' => null,
                            'response_code' => 404,
                        );
                        return $this->response($data, 404);
                    }
                }
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.invalid_old_pin'),
                    'data' => null,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
            if ($responseData) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.pin_change_successfully'),
                    'data' => null,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.error_while_changing_pin'),
                    'data' => null,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    function getSettingList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'start' => $start,
                'search' => $search,
                'society_id' => $societyId,
            );
            $settingData = $this->settingModel->getSettingData($filterArray);
            if (!empty($settingData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.setting_listing_successfully'),
                    'data' => $settingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                //return $this->respond($data,200);
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $settingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                //return $this->respond($data,404);
                return $this->response($data, 404);
            }
        }
    }

    public function getFaqList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $faqId = $this->request->getVar('faq_id');
        $categoryId = $this->request->getVar('category_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'faq_id' => $faqId,
                'category_id' => $categoryId,
                'user_society_id' => $userSocietyId,
                'society_id' => $societyId
            );
            $faqData = $this->faqModel->getFaqData($filterArray);
            $faqIdArray = array();
            $faqMediaDataWise = array();
            if (!empty($faqData)) {
                foreach ($faqData as $faqElement) {
                    $faqIdArray[] = $faqElement['faq_id'];
                }

                if (!empty($faqIdArray)) {
                    $faqMediaData = $this->mediaModel->getMediaData(array(
                        "media_for_id" => $faqIdArray,
                        "media_for" => 'faq',
                        "is_multiple" => 1
                    ));
                    if (!empty($faqMediaData)) {
                        foreach ($faqMediaData as $faqMediaElement) {
                            $faqMediaElement['media_title'] = underscoreToUcWord($faqMediaElement['media_title']);
                            if ($faqMediaElement["media_file"] == '') {
                                $faqMediaElement["media_file"] = SITE_URL('uploads/no_image.png');
                                $faqMediaElement["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                            } else {
                                if($faqMediaElement['media_type'] == 'image'){
                                    $faqMediaElement["thumbnail_media_file"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $faqMediaElement["media_file"];
                                }
                                else{
                                   $faqMediaElement["thumbnail_media_file"] = SITE_URL('uploads/no_image.png'); 
                                }
                                $faqMediaElement["media_file"] = SITE_URL() . MEDIA_IMAGE_PATH . $faqMediaElement["media_file"];
                            }
                            $faqMediaDataWise[$faqMediaElement['media_for_id']][] = $faqMediaElement;
                        }
                    }
                }
            }
            if (!empty($faqData)) {
                foreach ($faqData as $fkey => $faq) {
                    $faqData[$fkey]['category_name_display'] = underscoreToUcWord($faq["category_name"]);
                    $faqData[$fkey]['created_at'] = YMDToDMY($faq["created_at"], true);
                    $faqData[$fkey]['updated_at'] = YMDToDMY($faq["updated_at"], true);
                    $faqData[$fkey]['created_at_display'] = time_elapsed_string($faq['created_at']);
                    $faqData[$fkey]['updated_at_display'] = time_elapsed_string($faq['created_at']);
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $faqData[$fkey]['share_data'] = $shareData;
                    $faqData[$fkey]['faq_media_data'] = array_key_exists($faq['faq_id'], $faqMediaDataWise) ? $faqMediaDataWise[$faq['faq_id']] : array();
                }
            }

            $faqMediaArray = array(
                'is_multiple' => 1,
                'category_id' => $categoryId,
                "media_for" => 'faq',
            );
            $faqMediaData = $this->faqModel->getMediaData($filterArray);
            if (!empty($faqMediaData)) {
                foreach ($faqMediaData as $fKey => $faqMediaElement) {
                    $faqMediaData[$fKey]['media_title'] = underscoreToUcWord($faqMediaElement['media_title']);
                    if ($faqMediaElement["media_file"] == '') {
                        $faqMediaData[$fKey]["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                        $faqMediaData[$fKey]["media_file"] = SITE_URL('uploads/no_image.png');
                    } else {
                        if($faqMediaElement['media_type'] == 'image'){
                            $faqMediaData[$fKey]["thumbnail_media_file"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $faqMediaElement["media_file"];
                        }
                        else{
                           $faqMediaData[$fKey]["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                        }
                                
                        
                        $faqMediaData[$fKey]["media_file"] = SITE_URL() . MEDIA_IMAGE_PATH . $faqMediaElement["media_file"];
                    }
                }
            }

            if (!empty($faqData) || !empty($faqMediaData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.faq_listing_successfully'),
                    'data' => $faqData,
                    'media_data' => $faqMediaData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $faqData,
                    'media_data' => $faqMediaData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getFaqMediaList()
    {
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $categoryId = $this->request->getVar('category_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                // 'is_active' => 1,
                'start' => $start,
                'search' => $search,
                // 'faq_id' => $faqId,
                'category_id' => $categoryId,
                'user_society_id' => $userSocietyId,
                'society_id' => $societyId,
                "media_for" => 'faq',
            );
            $faqMediaData = $this->faqModel->getMediaData($filterArray);
            if (!empty($faqMediaData)) {
                foreach ($faqMediaData as $fKey => $faqMediaElement) {
                    $faqMediaData[$fKey]['media_title'] = underscoreToUcWord($faqMediaElement['media_title']);
                    if ($faqMediaElement["media_file"] == '') {
                        $faqMediaData[$fKey]["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                        $faqMediaData[$fKey]["media_file"] = SITE_URL('uploads/no_image.png');
                    } else {
                        if($faqMediaElement['media_type'] == 'image'){
                            $faqMediaData[$fKey]["thumbnail_media_file"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $faqMediaElement["media_file"];
                        }
                        else{
                            $faqMediaData[$fKey]["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                        }
                                
                        
                        $faqMediaData[$fKey]["media_file"] = SITE_URL() . MEDIA_IMAGE_PATH . $faqMediaElement["media_file"];
                    }
                }
            }
            if (!empty($faqMediaData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.faq_media_listing_successfully'),
                    'data' => $faqMediaData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $faqMediaData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getFaqTopicList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                // 'user_society_id' => $userSocietyId,
                'society_id' => $societyId
            );
            $faqData = $this->faqModel->getFaqData($filterArray);
            $uniqueFaqData = [];
            $categoryWiseFaqData = [];
            if (!empty($faqData)) {
                foreach ($faqData as $fkey => $faq) {
                    if (!in_array($faq["category_id"], $categoryWiseFaqData)) {
                        $faq['category_name_display'] = underscoreToUcWord($faq["category_name"]);
                        $faq['created_at'] = YMDToDMY($faq["created_at"], true);
                        $faq['updated_at'] = YMDToDMY($faq["updated_at"], true);
                        $faq['created_at_display'] = time_elapsed_string($faq['created_at']);
                        $faq['updated_at_display'] = time_elapsed_string($faq['updated_at']);
                        $uniqueFaqData[] = $faq;
                        $categoryWiseFaqData[] = $faq["category_id"];
                    }
                }
            }
            $faqMediaArray = array(
                'is_multiple' => 1,
                'start' => 0,
                'limit' => 10,
                "media_for" => 'faq',
            );
            $faqMediaData = $this->faqModel->getMediaData($filterArray);
            if (!empty($faqMediaData)) {
                foreach ($faqMediaData as $fKey => $faqMediaElement) {
                    $faqMediaData[$fKey]['media_title'] = underscoreToUcWord($faqMediaElement['media_title']);
                    if ($faqMediaElement["media_file"] == '') {
                        $faqMediaData[$fKey]["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                        $faqMediaData[$fKey]["media_file"] = SITE_URL('uploads/no_image.png');
                    } else {
                        if($faqMediaElement['media_type'] == 'image'){
                            $faqMediaData[$fKey]["thumbnail_media_file"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $faqMediaElement["media_file"];
                        }
                        else{
                           $faqMediaData[$fKey]["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                        }
                                
                        
                        $faqMediaData[$fKey]["media_file"] = SITE_URL() . MEDIA_IMAGE_PATH . $faqMediaElement["media_file"];
                    }
                }
            }
            if (!empty($uniqueFaqData) || !empty($faqMediaData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.faq_listing_successfully'),
                    'data' => $uniqueFaqData,
                    'media_data' => $faqMediaData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $uniqueFaqData,
                    'media_data' => $faqMediaData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditComplainTicket()
    {
        $this->db->transStart();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $complainId = $this->request->getVar('complain_id');
        $complainTitle = $this->request->getVar('complain_title');
        $complainType = $this->request->getVar('complain_type');
        $categoryId = $this->request->getVar('category_id');
        $towerId = $this->request->getVar('tower_id');
        $description = $this->request->getVar('description');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $userId = $this->request->getVar('user_id');
        $appType = $this->request->getVar('app_type');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $isUrgent = $this->request->getVar('is_urgent');
        $complainImage = $this->request->getVar('complain_image[]');
        $complainRecord = $this->request->getVar('complain_record[]');
        $flatId = $this->request->getVar('flat_id');
        $mediaIdArray = $this->request->getVar('media_id_array');
        $this->validation->setRule('complain_type', lang('CommonWebService.complain_type'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('description', lang('CommonWebService.description'), 'required');
        $this->validation->setRule('category_id', lang('CommonWebService.category_id'), 'required');
        // $this->validation->setRule('tower_id', lang('CommonWebService.tower_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        // $this->validation->setRule('flat_id', lang('CommonWebService.flat_id'), 'required');
        if($appType != MANAGER_APP){
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $complainImageDocument = array();
            if (isset($_FILES["complain_image"])) {
                $complainImagePath = MEDIA_IMAGE_PATH;
                $complainImageDocument = $dt_ci_file_upload->UploadMultipleFile('complain_image', MAX_IMAGE_SIZE_LIMIT, $complainImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($complainImageDocument['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($complainImageDocument['message']),
                        'data' => null
                    ), 404);
                }
                else{
                    unset($complainImageDocument['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailMultipleUploadFile($complainImageDocument, MEDIA_IMAGE_PATH, THUMBNAIL_MEDIA_IMAGE_PATH);
                }
            }
            $complainRecordDocument = array();
            if (isset($_FILES["complain_record"])) {
                $complainRecordPath = MEDIA_IMAGE_PATH;
                $complainRecordDocument = $dt_ci_file_upload->UploadMultipleFile('complain_record', MAX_IMAGE_SIZE_LIMIT, $complainRecordPath, true, true, array('mp3', 'mp4'));
                if ($complainRecordDocument['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($complainRecordDocument['message']),
                        'data' => null
                    ), 404);
                }
            }
            if ($complainType == 'personal' && $appType == MEMBER_APP) {
                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_active' => 1,
                    'is_show_all_member' => 1
                ));
                if (!empty($ownershipFlatMemberData)) {
                    if ($ownershipFlatMemberData['tower_id'] != $towerId) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => 'Select Your Own Tower ' . $ownershipFlatMemberData['tower_name'],
                            'data' => null
                        ), 404);
                    }
                }
            }
            $statusId = 0;
            $statusData = $this->statusModel->getStatusData(array(
                'is_default' => 1,
                'status_for' => 'complain',
                'is_active' => 1,
            ));
            if (empty($statusData)) {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => 'Status Master Complain Is Default Status Not Defined',
                    'data' => null
                ), 404);
            }
            if (!empty($statusData)) {
                $statusId = isset($statusData['status_id']) ? $statusData['status_id'] : 0;
            }
            if(empty($complainId)){

                $centralDB = \Config\Database::connect();

                $society = $centralDB->table('tbl_society')
                    ->where('society_id', $societyId)
                    ->get()
                    ->getRowArray();

                $nextSeries  = $this->rentalModel->getNextSeries('complaint', COMPLAIN_PREFIX, $society['db_name']);
            }

            

            $complainUpdateArray = array();
            $complainArray = array(
                'complain_id' => $complainId,
                'complain_type' => $complainType,
                'complain_title' => $complainTitle,
                'category_id' => $categoryId,
                'tower_id' => $towerId,
                'description' => $description,
                'remarks' => $description,
                'society_id' => $societyId,
                'is_active' => 1,
                'status_id' => $statusId,
                'is_urgent' => $isUrgent,
                'complainant' => $appType,
            );
            if ($complainType == 'personal' && $appType == MEMBER_APP) {
                $ownershipFlatMembersData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                ));
                $complainArray['flat_id'] = $ownershipFlatMembersData['flat_id'];
                $complainArray['complainant_id'] = $ownershipFlatMemberId;
            }

            if($appType == MANAGER_APP){
                if ($complainType == 'personal'){
                    $complainArray['flat_id'] = $flatId;
                    $complainArray['complainant_id'] = $userSocietyId;
                }
            }

            if ($complainId == '') {
                $complainArray['prefix'] = COMPLAIN_PREFIX;
                $complainArray['series'] = $nextSeries;
            }
            if (!empty($complainId)) {
                $complainUpdateData = $this->complainModel->getComplainData(array(
                    'complain_id' => $complainId,
                ));
                $complainUpdateArray = compareArray($complainArray, $complainUpdateData);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $complainData = $this->commonWebserviceModel->insertUpdateRecord($complainArray, 'complain_id', 'tbl_complain', 1, '', array('series'), $extraData, $complainUpdateArray);
            $lastComplainId = $complainData['lastInsertedId'];
            if ($lastComplainId != '') {
                if (isset($complainImageDocument) && count($complainImageDocument) > 0) {
                    $batchArray = array();
                    unset($complainImageDocument['success']);
                    foreach ($complainImageDocument as $key => $imageData) {
                        $dataArray = array(
                            'media_id' => '',
                            'media_for_id' => $lastComplainId,
                            'media_for' => 'complain',
                            'media_type' => 'image',
                            'media_file' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                            'created_by' => $userSocietyId,
                            'updated_by' => $userSocietyId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $complainExtraDataArray = array();
                    $complainExtraDataArray['module_id'] = $lastComplainId;
                    $complainExtraDataArray['module'] = 'Complain Media Image';
                    $complainExtraDataArray['type'] = 'Complain';
                    $complainExtraDataArray['old_data'] = '';
                    $complainExtraDataArray['user_id'] = $userSocietyId;
                    $complainExtraDataArray['society_id'] = $societyId;
                    $this->complainModel->batchInsert($batchArray, 'tbl_media', $complainExtraDataArray);
                }
                if (isset($complainRecordDocument) && count($complainRecordDocument) > 0) {
                    $batchArray = array();
                    unset($complainRecordDocument['success']);
                    foreach ($complainRecordDocument as $key => $RecordData) {
                        $dataArray = array(
                            'media_id' => '',
                            'media_for_id' => $lastComplainId,
                            'media_for' => 'complain',
                            'media_type' => 'audio',
                            'media_file' => isset($RecordData['file_name']) ? $RecordData['file_name'] : "",
                            'created_by' => $userSocietyId,
                            'updated_by' => $userSocietyId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $complainExtraDataArray = array();
                    $complainExtraDataArray['module_id'] = $lastComplainId;
                    $complainExtraDataArray['module'] = 'Complain Media Record';
                    $complainExtraDataArray['type'] = 'Complain';
                    $complainExtraDataArray['old_data'] = '';
                    $complainExtraDataArray['user_id'] = $userSocietyId;
                    $complainExtraDataArray['society_id'] = $societyId;
                    $this->complainModel->batchInsert($batchArray, 'tbl_media', $complainExtraDataArray);
                }
            }
            if(isset($mediaIdArray) && !empty($mediaIdArray)){
                $this->complainModel->deleteMediaRecord($mediaIdArray);
            }
            $complainRecord = $this->complainModel->getComplainData(array(
                'complain_id' => $lastComplainId,
            ));
            if ($complainId == '') {
               $memberIdArray = array();
               $notificationDataArray = array();

               $complainForName = (isset($complainRecord['complainant_name']) && $complainRecord['complainant_name'] != "") ? $complainRecord['complainant_name'] : $complainRecord['created_by'];
                $userDeviceUserSocietyIdArray = array();
                $userDeviceUserTypeIdArray = array();
                $userManagerDevice = array();
                $userDeviceManagerIdArray = array();
                $userDeviceManagerTypeIdArray = array();
                $userDeviceManagerTypeArray = array();
                $userDeviceUserTypeArray = array();
                $ownershipFlatMemberIdArray = array();
                $memberIdArray = array();
                $managementCommitteeData = $this->managementCommitteeModel->getManagementCommitteeData(array(
                    'society_id' => $societyId,
                    'is_api' => 1,
                    'is_active' => 1,
                    'is_multiple' => 1
                ));

                if (!empty($managementCommitteeData)) {
                    foreach ($managementCommitteeData as $managementCommitteeElement) {
                        $ownershipFlatMemberIdArray[] = $managementCommitteeElement['member_id'];
                    }
                }

                if(!empty($ownershipFlatMemberIdArray)){
                    $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                        'is_show_all_member' => 1,
                        'is_multiple' => 1,
                        'is_active' => 1
                    ));

                
                    if(!empty($ownershipFlatMemberData)){
                        foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                            $memberIdArray[] = $ownershipFlatMember['member_id'];
                        }
                    }
                }
                if(!empty($memberIdArray)){

                    $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                        'resource_type_name' => RESOURCE_TYPE_MEMBER,
                        'society_id' => $societyId,
                    ));

                    $userSocietyCommitteeData = $this->commonWebserviceModel->getUserSocietyData(array(
                        'society_id' => $societyId,
                        'resource_type_id' => $resourceTypeData['resource_type_id'],
                        'type_id' => $memberIdArray,
                        'user_society_id_not' => $userSocietyId,
                        'is_multiple' => 1
                    ));

                    if (!empty($userSocietyCommitteeData)) {
                        foreach ($userSocietyCommitteeData as $userSocietyCommitteeElement) {
                            $userDeviceUserSocietyIdArray[] = isset($userSocietyCommitteeElement['user_society_id']) ? $userSocietyCommitteeElement['user_society_id'] : 0;
                        }


                        $userMemberDevice = $this->commonWebserviceModel->deviceData(array(
                            "user_society_id" => $userDeviceUserSocietyIdArray,
                            "user_type" => MEMBER_APP,
                            "is_latest" => 1,
                            "is_multiple" => 1
                        ));
                        $resourceTypeManagerData = $this->resourceTypeModel->getResourceTypeData(array(
                            'resource_type_name' => RESOURCE_TYPE_MANAGER,
                            'society_id' => $societyId,
                        ));
                        
                        $userManagerData = $this->commonWebserviceModel->getUserSocietyData(array(
                            'society_id' => $societyId,
                            'user_society_id_not' => $userSocietyId,
                            'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
                            'is_active' => 1,
                            'is_multiple' => 1
                        ));

                        // printArray($userManagerData,1);

                        if (!empty($userManagerData)) {
                            foreach ($userManagerData as $userManagerCommittee) {
                                $userDeviceManagerIdArray[] = isset($userManagerCommittee['user_society_id']) ? $userManagerCommittee['user_society_id'] : 0;
                            }

                            $userManagerDevice = $this->commonWebserviceModel->deviceData(array(
                                "user_society_id" => $userDeviceManagerIdArray,
                                "user_type" => MANAGER_APP,
                                "is_latest" => 1,
                                "is_multiple" => 1
                            ));
                        }
                        $userMergeArray = array_merge($userMemberDevice,$userManagerDevice);

                        // printArray($userSocietyCommitteeData,1);
                        if (!empty($userMergeArray)) {
                            foreach ($userMergeArray as $userDeviceElement) {
                                if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
                                    $notificationArray = array(
                                        'ownership_flat_id' => 0,
                                        'ownership_flat_member_id' => isset($userDeviceElement['type_id']) ? $userDeviceElement['type_id'] : 0,
                                        'type' => 'complain',
                                        'status' => 'complain',
                                        'type_id' => $lastComplainId,
                                        'user_society_id' => $userSocietyId,
                                        'complain_title' => $complainRecord['complain_title'],
                                        'complain_number' => $complainRecord['complain_number'],
                                        'description' => $complainRecord['description'],
                                        'member_name' => $complainRecord['complainant_name'],
                                        'society_id' => $societyId,
                                        'notification_title' => 'New Complain Registered',
                                        'description' => 'A new complain has been registered by '.$complainForName.' regarding '.$complainTitle.'. Please review the details and take appropriate action.',
                                        'module' => 'complain',
                                        'action_type' => 'sent',
                                        'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                        'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                        'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                        'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
                                        // 'app_url' => MEMBER_URL .'ticket_detail_page/' . $lastComplainId,
                                    );

                                    if ($appType == MANAGER_APP) {
                                        $notificationArray['send_for_notification'] = $appType;
                                        $notificationArray['send_for_notification_id'] = $userSocietyId;
                                        $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                        $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                        $notificationArray['app_url'] = MANAGER_URL .'ticket_detail_page/' . $lastComplainId ;
                                    }

                                    if ($appType == MEMBER_APP) {
                                        $notificationArray['send_for_notification'] = $appType;
                                        $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                        $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                        $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                        $notificationArray['app_url'] = MEMBER_URL .'ticket_detail_page/' . $lastComplainId ;
                                    }
                                    $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                    array_push($notificationDataArray, $notificationArray);
                                }
                            }
                        }
                    }

                    if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                        sendNotificationComplainAndroid($notificationDataArray);
                    }
                }
                
            }
            if (!empty($complainRecord)) {
                $complainRecord["complain_number"] = $complainRecord['prefix'] . $complainRecord['series'];
            }



            $complainMediaDataWise = array();
            $complainHistoryDataWise = array();
            $complainHistoryMediaDataWise = array();
            $complainFilterArray = array(
                'complain_id' => $lastComplainId,
            );
            $complainInsertData = $this->complainModel->getComplainData($complainFilterArray);
            $objectFilterData = array(
                'tower_id' => array('tower_id', 'tower_name'),
                'category_id' => array('category_id', 'category_name'),
                'status_id' => array('status_id', 'status_name'),
                'flat_id' => array('flat_id', 'flat_no','tower_flat_name'),
            );
            
            if(!empty($complainInsertData)){
                $complainHistoryData = $this->complainModel->getComplainHistoryData(array(
                    'complain_id'=> $lastComplainId,
                    'is_multiple' => 1,
                ));
                if(!empty($complainHistoryData)){
                    foreach($complainHistoryData as $chKey => $complainHistory){
                        $complainHistoryIdArray[] = $complainHistory['complain_history_id'];
                    }
                }
                if(!empty($complainHistoryIdArray)){
                    $complainHistoryMediaData = $this->complainModel->getComplainHistoryImageData(array(
                        "complain_history_id" => $complainHistoryIdArray,
                        "is_multiple" => 1,
                    ));
                    if(!empty($complainHistoryMediaData)) {
                        foreach ($complainHistoryMediaData as $complainHistoryMediaElement) {
                            if ($complainHistoryMediaElement["complain_image"] == '') {
                                $complainHistoryMediaElement["complain_image"] = SITE_URL('uploads/no_image.png');
                                $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                if($complainHistoryMediaElement['media_type'] == 'image'){
                                    $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $complainHistoryMediaElement["complain_image"];
                                }
                                else{
                                    $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL('uploads/no_image.png');
                                }
                                $complainHistoryMediaElement["complain_image"] = SITE_URL() . MEDIA_IMAGE_PATH . $complainHistoryMediaElement["complain_image"];
                            }
                            $complainHistoryMediaDataWise[$complainHistoryMediaElement['complain_history_id']][] = $complainHistoryMediaElement;
                        }
                    }  
                }
                if(!empty($complainHistoryData)) {
                    foreach ($complainHistoryData as $chKey => $complainHistoryElement) {
                        $complainHistoryData[$chKey]['created_at_display'] = time_elapsed_string($complainHistoryElement['created_at']);
                        $complainHistoryData[$chKey]['updated_at_display'] = time_elapsed_string($complainHistoryElement['updated_at']);
                        $complainHistoryData[$chKey]['complain_history_image_data'] = array_key_exists($complainHistoryElement['complain_history_id'],$complainHistoryMediaDataWise) ? $complainHistoryMediaDataWise[$complainHistoryElement['complain_history_id']]: array();                    
                    }
                }
                if(!empty($complainHistoryData)) {
                    foreach ($complainHistoryData as $complainHistoryElement) {
                        $complainHistoryDataWise[$complainHistoryElement['complain_id']][] = $complainHistoryElement; 
                    }
                }
                $mediaData = $this->complainModel->getMediaData(array(
                    "media_for_id" => $lastComplainId,
                    "media_for" => 'complain',
                    "is_multiple" => 1,
                ));
                if(!empty($mediaData)) {
                    foreach ($mediaData as $mediaElement) {
                        if ($mediaElement["media_file"] == '') {
                            $mediaElement["media_file"] = SITE_URL('uploads/no_image.png');
                            $mediaElement["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                        } else {
                            $mediaElement["thumbnail_media_file"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $mediaElement["media_file"];
                            $mediaElement["media_file"] = SITE_URL() . MEDIA_IMAGE_PATH . $mediaElement["media_file"];
                        }
                        $complainMediaDataWise[$mediaElement['media_for_id']][] = $mediaElement;
                    }
                }
            }
            if (!empty($complainInsertData)) {
                $complainInsertData = getModuleObjectData($objectFilterData, $complainInsertData);
                $complainInsertData['created_at'] = YMDToDMY($complainInsertData["created_at"], true);
                $complainInsertData['updated_at'] = YMDToDMY($complainInsertData["updated_at"], true);
                $complainInsertData['created_at_display'] = time_elapsed_string($complainInsertData['created_at']);
                $complainInsertData['updated_at_display'] = time_elapsed_string($complainInsertData['updated_at']);
                $complainInsertData['complain_image_data'] = array_key_exists($complainInsertData['complain_id'], $complainMediaDataWise) ? $complainMediaDataWise[$complainInsertData['complain_id']] : array();
                $complainInsertData['complain_history_data'] = array_key_exists($complainInsertData['complain_id'],$complainHistoryDataWise) ? $complainHistoryDataWise[$complainInsertData['complain_id']]: array();

                if($complainInsertData['complain_created_by'] == $userSocietyId){
                    $complainInsertData['is_complain_created_by_me'] = 1;
                } else {
                    $complainInsertData['is_complain_created_by_me'] = 0;
                }
            }
            $transactionStatus = $this->db->transCommit();
            if (isset($complainId) && !empty($complainId)) {
                if ((isset($complainData['success']) && $complainData['success']) && ($transactionStatus == 1)) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.complain')),
                        'data' => $complainInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.complain')),
                        'data' => null
                    ), 404);
                }
            } else {
                if ((isset($complainData['success']) && $complainData['success']) && ($transactionStatus == 1)) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.complain')),
                        'data' => $complainInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.complain')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function addEditComplainHistory()
    {
        $this->db->transStart();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $complainId = $this->request->getVar('complain_id');
        $statusId = $this->request->getVar('status_id');
        $societyId = $this->request->getVar('society_id');
        $remarks = $this->request->getVar('remarks');
        $appType = $this->request->getVar('app_type');
        $userSocietyId = $this->request->getVar('user_society_id');
        $complainImage = $this->request->getVar('complain_image[]');
        
        $this->validation->setRule('remarks', lang('CommonWebService.remarks'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $complainImageDocument = array();
            if (isset($_FILES["complain_image"])) {
                $complainImagePath = MEDIA_IMAGE_PATH;
                $complainImageDocument = $dt_ci_file_upload->UploadMultipleFile('complain_image', MAX_IMAGE_SIZE_LIMIT, $complainImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($complainImageDocument['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($complainImageDocument['message']),
                        'data' => null
                    ), 404);
                }
                else{
                    unset($complainImageDocument['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailMultipleUploadFile($complainImageDocument, MEDIA_IMAGE_PATH, THUMBNAIL_MEDIA_IMAGE_PATH);
                }
            }
            $complainData = $this->complainModel->getComplainData(array(
                'complain_id' => $complainId,
            ));
            $complainImageData = $this->mediaModel->getMediaData(array(
                "media_for" => 'complain',
                "media_for_id" => $complainId,
                'is_multiple' => 1
            ));
            if(!empty($complainData)){
                $complainStatusId = isset($complainData['status_id']) ? $complainData['status_id'] : 0;
                $complainRemarks = isset($complainData['remarks']) ? $complainData['remarks'] :'';
            }
            $statusData = $this->statusModel->getStatusData(array(
                'status_id' => $complainStatusId,
            ));
            if($statusData['is_close']){
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => "Complain Already Closed",
                    'data' => null
                ), 404);
            }
            $complainUpdateArray = array();
            $complainHistoryUpdateArray = array();
            $complainUpdateArray = array();
            $complainArray = array(
                'complain_id' => $complainId,
                'status_id' => $statusId,
                'remarks' => $remarks,
                'complainant' => $appType,
                'complainant_id' => $userSocietyId,
            );
            if (!empty($complainId)) {
                $complainUpdateData = $this->complainModel->getComplainData(array(
                    'complain_id' => $complainId,
                ));
                $complainUpdateArray = compareArray($complainArray, $complainUpdateData);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $complainInsertData = $this->commonWebserviceModel->insertUpdateRecord($complainArray, 'complain_id', 'tbl_complain', 1, '', array(), $extraData, $complainUpdateArray);
            // printArray($complainData,1);
            $complainHistoryArray = array(
                'complain_history_id' => '',
                'complain_id' => $complainId,
                'status_id' => $complainStatusId,
                'remarks' => $complainRemarks,
                'complainant' => $complainData['complainant'],
                'complainant_id' => $complainData['complainant_id'],
                'created_at' => $complainData['created_at'],
                'created_by' => $complainData['created_by'],
                'updated_at' => $complainData['updated_at'],
                'updated_by' => $complainData['updated_by'],
            );
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $complainHistoryData = $this->commonWebserviceModel->insertUpdate($complainHistoryArray, 'complain_history_id', 'tbl_complain_history', 1,$complainHistoryUpdateArray);
            // printArray("jfg",1);
            $lastComplainHistoryId = $complainHistoryData['lastInsertedId'];
            // printArray($lastComplainHistoryId,1);
           
            if (isset($complainImageDocument) && count($complainImageDocument) > 0) {
                $batchArray = array();
                unset($complainImageDocument['success']);
                foreach ($complainImageDocument as $key => $imageData) {
                    $dataArray = array(
                        'media_id' => '',
                        'media_for_id' => $complainId,
                        'media_for' => 'complain',
                        'media_type' => 'image',
                        'media_file' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                        'created_by' => $userSocietyId,
                        'updated_by' => $userSocietyId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                    array_push($batchArray, $dataArray);
                }
                $complainExtraDataArray = array();
                $complainExtraDataArray['module_id'] = $complainId;
                $complainExtraDataArray['module'] = 'Complain Media Image';
                $complainExtraDataArray['type'] = 'Complain';
                $complainExtraDataArray['old_data'] = '';
                $complainExtraDataArray['user_id'] = $userSocietyId;
                $complainExtraDataArray['society_id'] = $societyId;
                $this->complainModel->batchInsert($batchArray, 'tbl_media', $complainExtraDataArray);
            }
            $mediaIdArray = array();
            if(!empty($complainImageData)){
                $imageBatchArray = array();
                foreach($complainImageData as $complainImageHistory){
                    $mediaIdArray[] = $complainImageHistory['media_id'];
                    $imageHistoryArray = array(
                        'complain_history_image_id' => '',
                        'complain_history_id' => $lastComplainHistoryId,
                        'complain_id' => $complainImageHistory['media_for_id'],
                        'complain_image' => $complainImageHistory['media_file'],
                        'media_type' => $complainImageHistory['media_type'],
                        'created_by' => $userSocietyId,
                        'updated_by' => $userSocietyId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                    array_push($imageBatchArray, $imageHistoryArray);
                }
                // printArray($imageBatchArray,1);
                $this->complainModel->batchInsert($imageBatchArray, 'tbl_complain_history_image');
                $mediaData = $this->complainModel->deleteComplainMediaRecord($mediaIdArray);
            }

            $complainNotificationData = $this->complainModel->getComplainData(array('complain_id'=>$complainId));
            // if($complainNotificationData['is_resolved'] == 1){
                $ownershipFlatMemberIdArray = array();
                $notificationDataArray = array();
                $notificationMergeArray = array();
                $userDeviceUserSocietyIdArray = array();
                $userDeviceUserTypeIdArray = array();
                $userDeviceUserTypeArray = array();
                $userManagerDevice = array();
                $userDeviceManagerIdArray = array();
                $userDeviceManagerTypeIdArray = array();
                $userDeviceManagerTypeArray = array();
                $memberIdArray = array();
                $managementCommitteeData = $this->managementCommitteeModel->getManagementCommitteeData(array(
                    'society_id' => $societyId,
                    'is_api' => 1,
                    'is_active' => 1,
                    'is_multiple' => 1
                ));

                if (!empty($managementCommitteeData)) {
                    foreach ($managementCommitteeData as $managementCommitteeElement) {
                        $ownershipFlatMemberIdArray[] = $managementCommitteeElement['member_id'];
                    }
                }

                if(!empty($ownershipFlatMemberIdArray)){
                    $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                        'is_show_all_member' => 1,
                        'is_multiple' => 1,
                        'is_active' => 1
                    ));

                
                    if(!empty($ownershipFlatMemberData)){
                        foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                            $memberIdArray[] = $ownershipFlatMember['member_id'];
                        }
                    }
                }
                if(!empty($memberIdArray)){

                    $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                        'resource_type_name' => RESOURCE_TYPE_MEMBER,
                        'society_id' => $societyId,
                    ));

                    $userSocietyCommitteeData = $this->commonWebserviceModel->getUserSocietyData(array(
                        'society_id' => $societyId,
                        'resource_type_id' => $resourceTypeData['resource_type_id'],
                        'type_id' => $memberIdArray,
                        'user_society_id_not' => $userSocietyId,
                        'is_multiple' => 1
                    ));

                    if (!empty($userSocietyCommitteeData)) {
                        foreach ($userSocietyCommitteeData as $userSocietyCommitteeElement) {
                            $userDeviceUserSocietyIdArray[] = isset($userSocietyCommitteeElement['user_society_id']) ? $userSocietyCommitteeElement['user_society_id'] : 0;
                        }

                        $userMemberDevice = $this->commonWebserviceModel->deviceData(array(
                            "user_society_id" => $userDeviceUserSocietyIdArray,
                            "user_type" => MEMBER_APP,
                            "is_latest" => 1,
                            "is_multiple" => 1
                        ));
                        $resourceTypeManagerData = $this->resourceTypeModel->getResourceTypeData(array(
                            'resource_type_name' => RESOURCE_TYPE_MANAGER,
                            'society_id' => $societyId,
                        ));
                        
                        $userManagerData = $this->commonWebserviceModel->getUserSocietyData(array(
                            'society_id' => $societyId,
                            'user_society_id_not' => $userSocietyId,
                            'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
                            'is_active' => 1,
                            'is_multiple' => 1
                        ));

                        // printArray($userManagerData,1);

                        if (!empty($userManagerData)) {
                            foreach ($userManagerData as $userManagerCommittee) {
                                $userDeviceManagerIdArray[] = isset($userManagerCommittee['user_society_id']) ? $userManagerCommittee['user_society_id'] : 0;
                            }

                            $userManagerDevice = $this->commonWebserviceModel->deviceData(array(
                                "user_society_id" => $userDeviceManagerIdArray,
                                "user_type" => MANAGER_APP,
                                "is_latest" => 1,
                                "is_multiple" => 1
                            ));
                        }

                        $userMergeArray = array_merge($userMemberDevice,$userManagerDevice);
                        if (!empty($userMergeArray)) {
                            foreach ($userMergeArray as $userDeviceElement) {
                                if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
                                    $notificationArray = array(
                                        'ownership_flat_id' => 0,
                                        'ownership_flat_member_id' => isset($userDeviceElement['type_id']) ? $userDeviceElement['type_id'] : 0,
                                        'type' => 'complain',
                                        'status' => 'complain',
                                        'type_id' => $complainId,
                                        'user_society_id' => $userSocietyId,
                                        'complain_title' => $complainNotificationData['complain_title'],
                                        'complain_number' => $complainNotificationData['complain_number'],
                                        'description' => $complainNotificationData['description'],
                                        'member_name' => $complainNotificationData['complainant_name'],
                                        'society_id' => $societyId,
                                        'notification_title' => 'Complain Status Updated '.$complainNotificationData['complain_number'],
                                        'description' => 'Your complain regarding '.$complainNotificationData['complain_title'].' has been updated. Please check the app for the latest details and status.',
                                        'module' => 'complain',
                                        'action_type' => 'sent',
                                        'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                        'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                        'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                        'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
                                        // 'app_url' => MEMBER_URL .'ticket_detail_page/' . $complainId,
                                    );

                                    if ($appType == MANAGER_APP) {
                                        $notificationArray['send_for_notification'] = $appType;
                                        $notificationArray['send_for_notification_id'] = $userSocietyId;
                                        $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                        $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                        // $notificationArray['app_url'] = MANAGER_URL .'ticket_detail_page/' . $complainId ;
                                    }

                                    if ($appType == MEMBER_APP) {
                                        $notificationArray['send_for_notification'] = $appType;
                                        $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                        $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                        $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                        // $notificationArray['app_url'] = MEMBER_URL .'ticket_detail_page/' . $complainId;
                                    }
                                    $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                    array_push($notificationDataArray, $notificationArray);
                                }
                            }
                        }
                    }

                    if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                        sendNotificationComplainAndroid($notificationDataArray);
                    }
                }   
            // }
                
            $complainIdArray = array();
            $complainMediaDataWise = array();
            $complainHistoryDataWise = array();
            $complainHistoryMediaDataWise = array();
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'complain_id' => $complainId,
            );
            $complainRecordData = $this->complainModel->getComplainData($filterArray);
            $objectFilterData = array(
                'tower_id' => array('tower_id', 'tower_name'),
                'category_id' => array('category_id', 'category_name'),
                'status_id' => array('status_id', 'status_name'),
                'flat_id' => array('flat_id', 'flat_no','tower_flat_name'),
            );
            if (!empty($complainRecordData)) {
                foreach ($complainRecordData as $bkey => $complain) {
                    $complainIdArray[] = $complain['complain_id'];
                }
            }
            if(!empty($complainIdArray)){
                $complainHistoryData = $this->complainModel->getComplainHistoryData(array(
                    'complain_id'=> $complainIdArray,
                    'is_multiple' => 1,
                ));
                if(!empty($complainHistoryData)){
                    foreach($complainHistoryData as $chKey => $complainHistory){
                        $complainHistoryIdArray[] = $complainHistory['complain_history_id'];
                    }
                }
                if(!empty($complainHistoryIdArray)){
                    $complainHistoryMediaData = $this->complainModel->getComplainHistoryImageData(array(
                        "complain_history_id" => $complainHistoryIdArray,
                        "is_multiple" => 1,
                    ));
                    if(!empty($complainHistoryMediaData)) {
                        foreach ($complainHistoryMediaData as $complainHistoryMediaElement) {
                            if ($complainHistoryMediaElement["complain_image"] == '') {
                                $complainHistoryMediaElement["complain_image"] = SITE_URL('uploads/no_image.png');
                                $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                if($complainHistoryMediaElement['media_type'] == 'image'){
                                    $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $complainHistoryMediaElement["complain_image"];
                                }
                                else{
                                    $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL('uploads/no_image.png');
                                }
                                $complainHistoryMediaElement["complain_image"] = SITE_URL() . MEDIA_IMAGE_PATH . $complainHistoryMediaElement["complain_image"];
                            }
                            $complainHistoryMediaDataWise[$complainHistoryMediaElement['complain_history_id']][] = $complainHistoryMediaElement;
                        }
                    }  
                }
                if(!empty($complainHistoryData)) {
                    foreach ($complainHistoryData as $chKey => $complainHistoryElement) {
                        $complainHistoryData[$chKey]['created_at_display'] = time_elapsed_string($complainHistoryElement['created_at']);
                        $complainHistoryData[$chKey]['updated_at_display'] = time_elapsed_string($complainHistoryElement['updated_at']);
                        $complainHistoryData[$chKey]['complain_history_image_data'] = array_key_exists($complainHistoryElement['complain_history_id'],$complainHistoryMediaDataWise) ? $complainHistoryMediaDataWise[$complainHistoryElement['complain_history_id']]: array();                    
                    }
                }
                if(!empty($complainHistoryData)) {
                    foreach ($complainHistoryData as $complainHistoryElement) {
                        $complainHistoryDataWise[$complainHistoryElement['complain_id']][] = $complainHistoryElement; 
                    }
                }
                $mediaData = $this->complainModel->getMediaData(array(
                    "media_for_id" => $complainIdArray,
                    "media_for" => 'complain',
                    "is_multiple" => 1,
                ));
                if(!empty($mediaData)) {
                    foreach ($mediaData as $mediaElement) {
                        if ($mediaElement["media_file"] == '') {
                            $mediaElement["media_file"] = SITE_URL('uploads/no_image.png');
                            $mediaElement["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                        } else {
                            $mediaElement["thumbnail_media_file"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $mediaElement["media_file"];
                            $mediaElement["media_file"] = SITE_URL() . MEDIA_IMAGE_PATH . $mediaElement["media_file"];
                        }
                        $complainMediaDataWise[$mediaElement['media_for_id']][] = $mediaElement;
                    }
                }
            }
            if (!empty($complainRecordData)) {
                foreach ($complainRecordData as $bkey => $complain) {
                    $complainRecordData[$bkey] = getModuleObjectData($objectFilterData, $complain);
                    $complainRecordData[$bkey]['created_at'] = YMDToDMY($complain["created_at"], true);
                    $complainRecordData[$bkey]['updated_at'] = YMDToDMY($complain["updated_at"], true);
                    $complainRecordData[$bkey]['created_at_display'] = time_elapsed_string($complain['created_at']);
                    $complainRecordData[$bkey]['updated_at_display'] = time_elapsed_string($complain['updated_at']);
                    $complainRecordData[$bkey]['complain_image_data'] = array_key_exists($complain['complain_id'], $complainMediaDataWise) ? $complainMediaDataWise[$complain['complain_id']] : array();
                    $complainRecordData[$bkey]['complain_history_data'] = array_key_exists($complain['complain_id'],$complainHistoryDataWise) ? $complainHistoryDataWise[$complain['complain_id']]: array();
                }
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($complainId) && !empty($complainId)) {
                if ((isset($complainInsertData['success']) && $complainInsertData['success']) && ($transactionStatus == 1)) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.complain')),
                        'data' => $complainRecordData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.complain')),
                        'data' => null
                    ), 404);
                }
            } else {
                if ((isset($complainInsertData['success']) && $complainInsertData['success']) && ($transactionStatus == 1)) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.complain')),
                        'data' => $complainRecordData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.complain')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function deleteComplainTicketRecording()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $complainId = $this->request->getVar('complain_id');
        $mediaId = $this->request->getVar('media_id');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('media_id', lang('CommonWebService.media_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transStart();
            $mediaId = ($mediaId != '') ? explode(",", $mediaId) : '';
            $mediaData = $this->complainModel->deleteMediaRecord($mediaId);
            $transactionStatus = $this->db->transComplete();
            if (($mediaData['success']) && ($transactionStatus == 1)) {
                if (!empty($mediaId)) {
                    foreach ($mediaId as $media) {
                        $deleteDataArray['module'] = 'Complain';
                        $deleteDataArray['activity'] = "Complain Media Deleted";
                        $deleteDataArray['module_id'] = $media;
                        logActivity('Complain Media Deleted [ComplainID: ' . $media . ']', $userSocietyId, 'Complain', $media, json_encode($deleteDataArray), '', 'Complain', $media);
                    }
                }
                
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.complain_ticket_recording')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.complain_ticket_recording')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function deleteMeetingRecording()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $meetingId = $this->request->getVar('meeting_id');
        $meetingRecordId = $this->request->getVar('meeting_record_id');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('meeting_record_id', lang('CommonWebService.meeting_record_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $meetingRecordId = ($meetingRecordId != '') ? explode(",", $meetingRecordId) : '';
            $meetingRecordData = $this->meetingModel->deleteMeetingRecord($meetingRecordId);
            if ($meetingRecordData['success']) {
                if (!empty($meetingRecordId)) {
                    foreach ($meetingRecordId as $meetingRecord) {
                        $deleteDataArray['module'] = 'Meeting Record';
                        $deleteDataArray['activity'] = "Meeting Record Deleted";
                        $deleteDataArray['module_id'] = $meetingRecord;
                        logActivity('Meeting Record Deleted [MeetingID: ' . $meetingRecord . ']', $userSocietyId, 'Meeting', $meetingRecord, json_encode($deleteDataArray), '', 'Meeting', $meetingRecord);
                    }
                }
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.meeting_record')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.meeting_record')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }


    public function getServiceDirectoryList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $vendorId = $this->request->getVar('vendor_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $categoryId = $this->request->getVar('category_id[]');
        $appType = $this->request->getVar('app_type');

        if($appType != MANAGER_APP){
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        // $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'vendor_id' => $vendorId,
                'society_id' => $societyId,
                'category_id' => $categoryId,
                'user_society_id' => $userSocietyId,
                'is_api' => 1,
            );
            $categoryData = $this->categoryModel->getCategoryData(array(
                'category_for' => 'vendor',
                'is_multiple' => 1,
                'is_active' => 1,
            ));
            $vendorData = $this->vendorModel->getVendorData($filterArray);
            if (!empty($vendorData)) {
                foreach ($vendorData as $vkey => $vendor) {
                    $vendorData[$vkey]['created_at'] = YMDToDMY($vendor["created_at"], true);
                    $vendorData[$vkey]['updated_at'] = YMDToDMY($vendor["updated_at"], true);
                    $vendorData[$vkey]['created_at_display'] = time_elapsed_string($vendor['created_at']);
                    $vendorData[$vkey]['updated_at_display'] = time_elapsed_string($vendor['created_at']);
                    $mobileNumbers = explode(', ', $vendor['vendor_mobile_no']);
                    $personNames = explode(', ', $vendor['vendor_person_name']);
                    $designations = explode(', ', $vendor['vendor_designation']);
                    $contactInfo = [];
                    foreach ($mobileNumbers as $index => $mobile) {
                        $contactInfo[] = [
                            'mobile_no' => $mobile,
                            'person_name' => $personNames[$index] ?? null,
                            'designation' => $designations[$index] ?? null
                        ];
                    }
                    $vendorData[$vkey]['contact_info'] = $contactInfo;
                    $vendorData[$vkey]['vendor_category_name'] = explode(', ', $vendor['vendor_category_name']);
                    $vendorData[$vkey]['vendor_category_id'] = explode(', ', $vendor['vendor_category_id']);
                    $shareData = [
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        'share_link' => 'https://digitattva.in/',
                    ];
                    $vendorData[$vkey]['share_data'] = $shareData;
                }
            }

            if (!empty($vendorData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.service_directory_listing_successfully'),
                    'category_data' => $categoryData,
                    'data' => $vendorData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'category_data' => $categoryData,
                    'data' => $vendorData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }


    public function getSocietyCommiteeList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $vendorId = $this->request->getVar('vendor_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $getManagementCommitteeResponsibilitiesId = $this->request->getVar('management_committee_responsibilities_id[]');
        $appType = $this->request->getVar('app_type');

        if($appType != MANAGER_APP){
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        // $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } 
        else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'vendor_id' => $vendorId,
                'society_id' => $societyId,
                'user_society_id' => $userSocietyId,
                'management_committee_responsibilities_id' => $getManagementCommitteeResponsibilitiesId,
                'is_api' => 1,
            );
            $committeeData = $this->managementCommitteeModel->getManagementCommitteeData($filterArray);

            // printArray($committeeData,1);
            $responsibilityData = $this->managementCommitteeResponsibilitiesModel->getManagementCommitteeResponsibilitiesData(array(
                'is_multiple' => 1,
                'is_active' => 1,
            ));

            $responsibilitiesDataCmmitteeIdWise = array();
            // if (!empty($amenitiesIdArray)) {
            //     $amenitiesUnitData = $this->managementCommitteeModel->getAmenitiesUnitData(array(
            //         "amenities_id" => $amenitiesIdArray,
            //         'is_multiple' => 1
            //     ));
            //     if (!empty($amenitiesUnitData)) {
            //         foreach ($amenitiesUnitData as $amenitiesUnitElement) {
            //             $responsibilitiesDataCmmitteeIdWise[$amenitiesUnitElement['amenities_id']][] = $amenitiesUnitElement;
            //         }
            //     }
            // }
            if (!empty($committeeData)) {
                foreach ($committeeData as $ckey => $committee) {
                    $committeeData[$ckey]['created_at'] = YMDToDMY($committee["created_at"], true);
                    $committeeData[$ckey]['updated_at'] = YMDToDMY($committee["updated_at"], true);
                    $committeeData[$ckey]['created_at_display'] = time_elapsed_string($committee['created_at']);
                    $committeeData[$ckey]['updated_at_display'] = time_elapsed_string($committee['created_at']);
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $committeeData[$ckey]['share_data'] = $shareData;

                    // if (!empty($amenitiesIdArray)) {
                    $responsibilitiesData = $this->managementCommitteeModel->getManagementCommitteeResponsibilitiesData(array(
                        "management_committee_id" => $committee['management_committee_id'],
                        'is_multiple' => 1
                    ));
                    if (!empty($responsibilitiesData)) {
                        foreach ($responsibilitiesData as $responsibilitiesElement) {
                            $responsibilitiesDataCmmitteeIdWise[$responsibilitiesElement['management_committee_id']][] = $responsibilitiesElement;
                        }
                    }
                    // }

                    $committeeData[$ckey]['responsibilites_data'] = array_key_exists($committee['management_committee_id'], $responsibilitiesDataCmmitteeIdWise) ? $responsibilitiesDataCmmitteeIdWise[$committee['management_committee_id']] : array();
                }
            }
            if (!empty($committeeData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.society_commitee_listing_successfully'),
                    'responsibilities_data' => $responsibilityData,
                    'data' => $committeeData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'responsibilities_data' => $responsibilityData,
                    'data' => $committeeData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getGuardDirectoryList()
    {
        $search = $this->request->getVar('search');
        $resourceId = $this->request->getVar('resource_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $appType = $this->request->getVar('app_type');

        if($appType != MANAGER_APP){
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }

        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        // $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'is_multiple' => 1,
                'is_helper' => 1,
                'search' => $search,
                'resource_id' => $resourceId,
                'society_id' => $societyId,
                'user_society_id' => $userSocietyId,
            );
            $resourceData = $this->resourceModel->getResourceData($filterArray);
            
            $resourceIdArray = array();
            $resourceImageDataWise = array();
            if (!empty($resourceData)) {
                foreach ($resourceData as $skey => $resourceElement) {
                     $resourceIdArray[] = $resourceElement['resource_id'];
                }
            }
            if (!empty($resourceData)) {
                foreach ($resourceData as $skey => $resourceElement) {
                    $resourceImagePath = SITE_URL('uploads/no_image.png');
                    $resourceThumbanilImagePath = SITE_URL('uploads/no_image.png');
                    if ($resourceElement['resource_image'] != '' && file_exists(DOCUMENT_IMAGE_PATH . $resourceElement['resource_image'])) {
                        $resourceImagePath = site_url() . DOCUMENT_IMAGE_PATH . $resourceElement['resource_image'];
                    }
                    if ($resourceElement['resource_image'] != '' && file_exists(THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceElement['resource_image'])) {
                        $resourceThumbanilImagePath = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceElement['resource_image'];
                    }
                    $resourceData[$skey]['date_of_birth'] = isset($resourceElement['date_of_birth']) ? YMDToDMY($resourceElement["date_of_birth"]) : "";
                    $resourceData[$skey]['resource_image'] = $resourceImagePath;
                    $resourceData[$skey]['thumbnail_resource_image'] = $resourceThumbanilImagePath;
                    $resourceData[$skey]['resource_image_data'] = array_key_exists($resourceElement['resource_id'],$resourceImageDataWise) ? $resourceImageDataWise[$resourceElement['resource_id']]: array();
                }
            }
            // printArray($resourceData,1);
            $insideOutsideGuardData = array();
            if (!empty($resourceData)) {
                foreach ($resourceData as $skey => $resourceElement) {
                    // if ($resourceElement['gate_type'] == 'inside') {
                    //     $insideOutsideGuardData['inside_guard'][$resourceElement['tower_name']][] = $resourceElement;
                    // } else {
                    //     $insideOutsideGuardData['outside_guard'][] = $resourceElement;
                    // }
                    $gateTypes = explode(',', $resourceElement['gate_type']);
                    foreach ($gateTypes as $gateType) {
                        $gateType = trim($gateType);
                        if ($gateType == 'inside') {
                            $insideOutsideGuardData['inside_guard'][$resourceElement['tower_name']][] = $resourceElement;
                        } elseif ($gateType == 'outside') {
                            $insideOutsideGuardData['outside_guard'][] = $resourceElement;
                        }
                    }
                }
            }
            if (empty($insideOutsideGuardData['inside_guard'])) {
                $insideOutsideGuardData['inside_guard'] = [];
            }
            if (empty($insideOutsideGuardData['outside_guard'])) {
                $insideOutsideGuardData['outside_guard'] = [];
            }
            if (!empty($insideOutsideGuardData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.guard_directory_listing_successfully'),
                    'data' => $insideOutsideGuardData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $insideOutsideGuardData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    function deviceInfo()
    {
        $deviceId = $this->request->getVar('device_id');
        $deviceToken = $this->request->getVar('device_token');
        $oneSignalId = $this->request->getVar('one_signal_id');
        $deviceType = $this->request->getVar('device_type');
        $deviceModel = $this->request->getVar('device_model');
        $deviceVersion = $this->request->getVar('device_version');
        $playerId = $this->request->getVar('player_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('device_id', lang('CommonWebService.device_id'), 'required');
        // $this->validation->setRule('device_token', lang('CommonWebService.device_token'), 'required');
        $this->validation->setRule('device_type', lang('CommonWebService.device_type'), 'required');
        $this->validation->setRule('device_model', lang('CommonWebService.device_model'), 'required');
        $this->validation->setRule('device_version', lang('CommonWebService.device_version'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $userDeviceData = $this->commonWebserviceModel->userDevice('', $deviceId, $appType);
            $userDeviceResponse = '';
            if (!empty($userDeviceData) && count($userDeviceData) > 0) {
                $this->commonWebserviceModel->updateData(array('is_latest' => 0), 'tbl_user_device_info', 'device_id', $deviceId);
                if ($deviceId != '' && $deviceId != 'undefined') {
                    $userDevice = array(
                        'device_id' => $deviceId,
                        'device_type' => $deviceType,
                        'device_token' => $deviceToken,
                        'one_signal_id' => $oneSignalId,
                        'device_model' => $deviceModel,
                        'device_version' => $deviceVersion,
                        'player_id' => $playerId,
                        'user_type' => $appType,
                        'is_latest' => 1,
                        'updated_at' => date('Y-m-d H:i:s'),
                    );
                    $userDeviceResponse = $this->commonWebserviceModel->updateData($userDevice, 'tbl_user_device_info', 'user_device_info_id', $userDeviceData[0]['user_device_info_id']);
                }

            } else {
                if ($deviceId != '' && $deviceId != 'undefined') {
                    $userDevice = array(
                        'device_id' => $deviceId,
                        'device_type' => $deviceType,
                        'device_token' => $deviceToken,
                        'one_signal_id' => $oneSignalId,
                        'device_model' => $deviceModel,
                        'device_version' => $deviceVersion,
                        'player_id' => $playerId,
                        'user_type' => $appType,
                        'is_latest' => 1,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                    );
                    $userDeviceResponse = $this->commonWebserviceModel->insertData($userDevice, 'tbl_user_device_info');
                }
            }
            if (isset($userDeviceResponse) && !empty($userDeviceResponse)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.device_info_store_successfully'),
                    'data' => $userDevice,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);

            } else {
                // Display an error response
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.device_info_not_store'),
                    'data' => $userDevice,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function updateUserDeviceInfo()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $deviceId = $this->request->getVar('device_id');
        $appType = $this->request->getVar('app_type');
        $deviceType = $this->request->getVar('device_type');
        $deviceModel = $this->request->getVar('device_model');
        $deviceVersion = $this->request->getVar('device_version');
        $oneSignalId = $this->request->getVar('one_signal_id');
        $playerId = $this->request->getVar('player_id');
        $userTypeId = $this->request->getVar('user_type_id');
        $userId = $this->request->getVar('user_id');

        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('device_id', lang('CommonWebService.device_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        $this->validation->setRule('user_type_id', lang('CommonWebService.user_type_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            $deviceUserType = '';
            if ($appType == GATE_KEEPER) {
                $deviceUserType = GATE_KEEPER;
            } 
            else if ($appType == MEMBER_APP) {
                $deviceUserType = MEMBER_APP;
            }
            else{
                $deviceUserType = MANAGER_APP;
            }
            $userDeviceData = $this->commonWebserviceModel->userDevice('', $deviceId, $appType);
            // printArray($userDeviceData,1);
            if (!empty($userDeviceData) && count($userDeviceData) > 0) {
                $userDeviceArray = array(
                    'tbl_name' => 'tbl_user_device_info',
                    'user_society_id' => $userSocietyId,
                    'user_type_id' => $userTypeId,
                    // 'user_type' => $deviceUserType,
                );


                $this->commonWebserviceModel->updateUserDeviceData($userDeviceArray);
                $editUserDevice = array(
                    'device_id' => $deviceId,
                    'user_society_id' => $userSocietyId,
                    'user_type' => $deviceUserType,
                    'user_type_id' => $userTypeId,
                    'device_type' => $deviceType,
                    'one_signal_id' => $oneSignalId,
                    'device_model' => $deviceModel,
                    'device_version' => $deviceVersion,
                    'player_id' => $playerId,
                    'is_latest' => 1,
                    'updated_by' => $userId,
                    'updated_at' => date('Y-m-d H:i:s'),
                );
                $userDeviceResponse = $this->commonWebserviceModel->updateData($editUserDevice, 'tbl_user_device_info', 'user_device_info_id', $userDeviceData[0]['user_device_info_id']);
            } else {

                $userDeviceArray = array(
                    'tbl_name' => 'tbl_user_device_info',
                    'user_society_id' => $userSocietyId,
                    'user_type_id' => $userTypeId,
                    // 'user_type' => $deviceUserType,
                );
                $this->commonWebserviceModel->updateUserDeviceData($userDeviceArray);

                $userDevice = array(
                    'device_id' => $deviceId,
                    'user_society_id' => $userSocietyId,
                    'user_type' => $deviceUserType,
                    'user_type_id' => $userTypeId,
                    'device_type' => $deviceType,
                    'one_signal_id' => $oneSignalId,
                    'device_model' => $deviceModel,
                    'device_version' => $deviceVersion,
                    'player_id' => $playerId,
                    'is_latest' => 1,
                    'created_by' => $userId,
                    'updated_by' => $userId,
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                );
                $userDeviceResponse = $this->commonWebserviceModel->insertData($userDevice, 'tbl_user_device_info');
            }
            if (isset($userDeviceResponse) && !empty($userDeviceResponse)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.device_info_store_successfully'),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);

            } else {
                // Display an error response
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.device_info_not_store'),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getForumList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $forumId = $this->request->getVar('forum_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $appType = $this->request->getVar('app_type');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');

        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'forum_id' => $forumId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                // 'user_society_id' => $userSocietyId,
                'society_id' => $societyId,
            );
            $forumData = $this->commonWebserviceModel->getForumData($filterArray);
            $forumIdArray = array();
            $forumDocumentDataWise = array();
            if (!empty($forumData)) {
                foreach ($forumData as $forumElement) {
                    $forumIdArray[] = $forumElement['forum_id'];
                }

                if (!empty($forumIdArray)) {
                    $forumImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $forumIdArray,
                        "document_type" => 'forum',
                        "is_multiple" => 1
                    ));

                    if (!empty($forumImageData)) {
                        foreach ($forumImageData as $forumImageElement) {
                            if ($forumImageElement["document_image"] == '') {
                                $forumImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $forumImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $forumImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $forumImageElement["document_image"];
                                $forumImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $forumImageElement["document_image"];
                            }
                            $forumDocumentDataWise[$forumImageElement['document_type_id']][] = $forumImageElement;
                        }
                    }
                }
            }


            if (!empty($forumData)) {
                foreach ($forumData as $fkey => $forum) {
                    if (($forum['type_id'] == $ownershipFlatMemberId) && ($forum['type'] == 'member')) {
                        $forumData[$fkey]['is_editable'] = 1;
                    } else {
                        $forumData[$fkey]['is_editable'] = 0;
                    }
                    $forumData[$fkey]['forum_date'] = YMDToDMY($forum["forum_date"]);
                    $forumData[$fkey]['created_at'] = YMDToDMY($forum["created_at"], true);
                    $forumData[$fkey]['updated_at'] = YMDToDMY($forum["updated_at"], true);
                    $forumData[$fkey]['created_at_display'] = time_elapsed_string($forum['created_at']);
                    $forumData[$fkey]['updated_at_display'] = time_elapsed_string($forum['created_at']);
                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($forum['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $forum['member_image'])) {
                        $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $forum['member_image'];
                    }
                    if ($forum['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $forum['member_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $forum['member_image'];
                    }
                    $forumData[$fkey]['member_image'] = $path;
                    $forumData[$fkey]['thumbnail_member_image'] = $thumbnailPath;

                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $forumData[$fkey]['share_data'] = $shareData;
                    $forumData[$fkey]['forum_image_data'] = array_key_exists($forum['forum_id'], $forumDocumentDataWise) ? $forumDocumentDataWise[$forum['forum_id']] : array();
                }
            }

            if (!empty($forumData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.forum_listing_successfully'),
                    'data' => $forumData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $forumData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditForum()
    {
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $forumId = $this->request->getVar('forum_id');
        $title = $this->request->getVar('title');
        $description = $this->request->getVar('description');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $documentImage = $this->request->getVar('document_image[]');
        $documentImageId = $this->request->getVar('document_image_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $appType = $this->request->getVar('app_type');
        $userId = $this->request->getVar('user_id');

        $this->validation->setRule('title', lang('CommonWebService.common_title'), 'required');
        $this->validation->setRule('description', lang('CommonWebService.common_description'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $documentImageData = array();
            if (isset($_FILES["document_image"])) {
                $documentImagePath = DOCUMENT_IMAGE_PATH;
                $documentImageData = $dt_ci_file_upload->UploadMultipleFile('document_image', MAX_IMAGE_SIZE_LIMIT, $documentImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($documentImageData['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($documentImageData['message']),
                        'data' => null
                    ), 404);
                }
                else{
                    unset($documentImageData['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailMultipleUploadFile($documentImageData, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
            }

            $forumUpdateArray = array();
            $forumArray = array(
                'forum_id' => $forumId,
                'title' => $title,
                'description' => $description,
                'society_id' => $societyId,
                'type' => RESOURCE_TYPE_MEMBER,
                'type_id' => $ownershipFlatMemberId,
                'forum_date' => date('Y-m-d'),
                'is_active' => 1,
            );
            if (!empty($forumId)) {
                $forumUpdateArray = $this->commonWebserviceModel->getForumData(array(
                    'forum_id' => $forumId,
                ));
                $forumUpdateArray = compareArray($forumArray, $forumUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $forumData = $this->commonWebserviceModel->insertUpdateRecord($forumArray, 'forum_id', 'tbl_forum', 1, '', array(), $extraData, $forumUpdateArray);
            $lastForumId = $forumData['lastInsertedId'];

            // Forum Multiple Image Store
            if ($lastForumId != '') {
                if (isset($documentImageData) && count($documentImageData) > 0) {
                    $batchArray = array();
                    unset($documentImageData['success']);
                    foreach ($documentImageData as $key => $imageData) {
                        $dataArray = array(
                            'document_image_id' => '',
                            'document_type' => 'forum',
                            'document_type_id' => $lastForumId,
                            'document_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                            'created_by' => $userId,
                            'updated_by' => $userId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $forumExtraDataArray = array();
                    $forumExtraDataArray['module_id'] = $lastForumId;
                    $forumExtraDataArray['module'] = 'Forum Image';
                    $forumExtraDataArray['type'] = 'Forum';
                    $forumExtraDataArray['old_data'] = '';
                    $forumExtraDataArray['user_id'] = $userId;
                    $forumExtraDataArray['society_id'] = $societyId;
                    $this->commonWebserviceModel->batchInsert($batchArray, 'tbl_document_image', $forumExtraDataArray);
                }
            }

            if (!empty($documentImageId)) {
                $documentImageId = ($documentImageId != '') ? explode(",", $documentImageId) : '';
                if(!empty($documentImageId)){
                    $imageData = $this->visitorModel->getDocumentImageData(array(
                        "document_image_id" => $documentImageId,
                        "is_multiple" => 1
                    ));

                    if(is_array($imageData) && !empty($imageData)){
                        foreach ($imageData as $image){
                            $FileUrl = '';
                            if(isset($image['document_image']) && $image['document_image'] != '') {
                                $FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
                            }
                            if (file_exists($FileUrl)) {
                                unlink($FileUrl);
                            }
                            $thumbnailFileUrl = '';
                            if(isset($image['document_image']) && $image['document_image'] != '') {
                                $thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
                            }
                            if (file_exists($thumbnailFileUrl)) {
                                unlink($thumbnailFileUrl);
                            }
                        }
                    }
                }
                $documentImageData = $this->commonWebserviceModel->deleteForumImageRecord($documentImageId);
                if ($documentImageData['success']) {
                    if (!empty($documentImageId)) {
                        foreach ($documentImageId as $documentImage) {
                            $deleteDataArray['module'] = 'Forum Image';
                            $deleteDataArray['activity'] = "Forum Image Deleted";
                            $deleteDataArray['module_id'] = $documentImage;
                            logActivity('Forum Image Deleted [ForumImageID: ' . $documentImage . ']', $userSocietyId, 'Forum', $documentImage, json_encode($deleteDataArray), '', 'Forum Image', $documentImage);
                        }
                    }
                }
            }

            if ($forumId == '') {
                $userSocietyIdArray = array();
                $customerDataArray = array();
                $batchNotificationDataArray = array();
                $memberIdArray = array();
                $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                    'resource_type_name' => RESOURCE_TYPE_MEMBER,
                    'society_id' => $societyId,
                ));
                $notificationArray = array(
                    'notification_title' => 'New Forum Published',
                    'description' => 'A new Forum titled '.$title.' has been published by the management. Please check the app to read the full details.',
                );
                $deviceIdArray = array();
                $iosDeviceIdArray = array();
                $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
                $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";

                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'society_id' => $societyId,
                    'is_active' => 1,
                    'is_multiple' => 1
                ));
                if(!empty($ownershipFlatMemberData)){
                    foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                        $memberIdArray[] = $ownershipFlatMember['member_id'];
                    }
                }
                if(!empty($memberIdArray)){
                    $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                        "type_id" => $memberIdArray,
                        "resource_type_id" => $resourceTypeData['resource_type_id'],
                        'society_id' => $societyId,
                        'is_multiple' => 1
                    ));
                    if(!empty($userSocietyData)){
                        foreach ($userSocietyData as $userElement) {
                            $userSocietyIdArray[] = $userElement['user_society_id'];
                        }
                    }


                    if(!empty($userSocietyIdArray)){
                        $userDeviceArray = $this->commonWebserviceModel->deviceData(array(
                            "user_society_id" => $userSocietyIdArray,
                            'user_type' => MEMBER_APP,
                            'user_type_id_not' => $ownershipFlatMemberId,
                            "is_latest" => 1,
                            "is_multiple" => 1,
                        ));
                    }

                //printArray($userSocietyData,1);
                    $sendNotificationDataArray = array();
                    if(!empty($userDeviceArray)){
                        foreach($userDeviceArray as $userDevice){
                            $notificationOtherArray = array(
                                'notification_id' => '',
                                'society_id' => $societyId,
                                'notification_date' => TODAY_DATE_YMD,
                                'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                'type' => 'forum',
                                'type_id' => $lastForumId,
                                // 'module' => 'poll',
                                'created_by' => $userId,
                                'updated_by' => $userId,
                                'created_at' => date("Y-m-d H:i:s"),
                                'updated_at' => date("Y-m-d H:i:s"),
                            );
                            $notificationOtherArray['send_for_notification'] = $appType;
                            $notificationOtherArray['send_for_notification_id'] = $userId;
                            $notificationOtherArray['receive_for_notification'] = $userDevice['user_type'];
                            $notificationOtherArray['receive_for_notification_id'] = $userDevice['user_type_id'];
                            if(!empty($notificationArray)){
                                $notificationArray = array_merge($notificationArray,$notificationOtherArray);
                                $extraDataJsonArray = $notificationArray;
                                $extraDataJsonArray['module'] = 'forum';
                                $extraDatajson = json_encode($extraDataJsonArray);
                                $notificationArray['extra_data'] = $extraDatajson;
                                $customerData['extra_data'] = $extraDatajson;

                                $sendNotificationDataArray[] = array(
                                    'notification_title' => 'New Forum Published',
                                    'description' => 'A new Forum titled '.$title.' has been published by the management. Please check the app to read the full details.',
                                    'extra_data_json' => $extraDatajson,
                                    'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                    'device_id' => isset($userDevice['device_id']) ? $userDevice['device_id'] : '',
                                    'type' => 'forum',
                                );
                                //send notification data
                                // $deviceToken = $userDevice['one_signal_id'];
                                // $deviceId = $userDevice['device_id'];
                                // $batchNotificationDataArray[] = $notificationArray;
                                // if(strtolower($userDevice['device_type']) == 'android'){
                                //     if (!empty($deviceId)) {
                                //         array_push($deviceIdArray,$deviceId);
                                //     }
                                // } else {
                                //     if (!empty($deviceId)) {
                                //         array_push($iosDeviceIdArray,$deviceId);
                                //     }
                                // }
                            }
                        }
                    }
                    if(!empty($batchNotificationDataArray)){
                        $this->commonWebserviceModel->batchInsert($batchNotificationDataArray,'tbl_notification');
                    }
                    // $sendNotificationData = array();
                    // if(!empty($deviceIdArray)){
                    //     $customerData['device_id'] = $deviceIdArray;
                    //     $customerData['app_url'] = MEMBER_URL .'forum_detail/' . $lastForumId;
                    //     $sendNotificationData = $customerData;
                    //     sendNotificationAndroid($sendNotificationData);
                    // }
                    // $sendNotificationIOSData = array();
                    // if(!empty($iosDeviceIdArray)){
                    //     $customerData['device_id'] = $iosDeviceIdArray;
                    //     $sendNotificationIOSData = $customerData;
                    //     sendNotificationIOS($sendNotificationIOSData);
                    // }

                    if(!empty($sendNotificationDataArray)){
                        sendNotification($sendNotificationDataArray,true);
                    }
                }
            }
            $forumFilterArray = array(
                'forum_id' => $lastForumId,
            );
            $forumInsertData = $this->commonWebserviceModel->getForumData($forumFilterArray);
            $forumDocumentDataWise = array();
            if (!empty($forumInsertData)) {
                $forumImageData = $this->visitorModel->getDocumentImageData(array(
                    "document_type_id" => $lastForumId,
                    "document_type" => 'forum',
                    "is_multiple" => 1
                ));

                if (!empty($forumImageData)) {
                    foreach ($forumImageData as $forumImageElement) {
                        if ($forumImageElement["document_image"] == '') {
                            $forumImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                            $forumImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                        } else {
                            $forumImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $forumImageElement["document_image"];
                            $forumImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $forumImageElement["document_image"];
                        }
                        $forumDocumentDataWise[$forumImageElement['document_type_id']][] = $forumImageElement;
                    }
                }   
            }
            if (!empty($forumInsertData)) {
                if (($forumInsertData['type_id'] == $ownershipFlatMemberId) && ($forumInsertData['type'] == 'member')) {
                    $forumInsertData['is_editable'] = 1;
                } else {
                    $forumInsertData['is_editable'] = 0;
                }
                $forumInsertData['forum_date'] = YMDToDMY($forumInsertData["forum_date"]);
                $forumInsertData['created_at'] = YMDToDMY($forumInsertData["created_at"], true);
                $forumInsertData['updated_at'] = YMDToDMY($forumInsertData["updated_at"], true);
                $forumInsertData['created_at_display'] = time_elapsed_string($forumInsertData['created_at']);
                $forumInsertData['updated_at_display'] = time_elapsed_string($forumInsertData['created_at']);
                $path = site_url('uploads/no_image.png');
                $thumbnailPath = site_url('uploads/no_image.png');

                if($forumInsertData['type'] == 'member'){
                    if ($forumInsertData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $forumInsertData['member_image'])) {
                        $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $forumInsertData['member_image'];
                    }
                    if ($forumInsertData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $forumInsertData['member_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $forumInsertData['member_image'];
                    }
                }

                if($forumInsertData['type'] == 'admin'){
                    if ($forumInsertData['member_image'] != '' && file_exists(USER_IMAGE_PATH . $forumInsertData['member_image'])) {
                        $path = site_url() . USER_IMAGE_PATH . $forumInsertData['member_image'];
                    }
                    if ($forumInsertData['member_image'] != '' && file_exists(THUMBNAIL_USER_IMAGE_PATH . $forumInsertData['member_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_USER_IMAGE_PATH . $forumInsertData['member_image'];
                    }
                }

                $forumInsertData['member_image'] = $path;
                $forumInsertData['thumbnail_member_image'] = $thumbnailPath;

                $shareData = array(
                    'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                    'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                    'share_image' => base_url('uploads/no_image.png'),
                    "share_link" => "https://digitattva.in/",
                );
                $forumInsertData['share_data'] = $shareData;
                $forumInsertData['forum_image_data'] = array_key_exists($forumInsertData['forum_id'], $forumDocumentDataWise) ? $forumDocumentDataWise[$forumInsertData['forum_id']] : array();
            }
            if (isset($forumId) && !empty($forumId)) {
                if (isset($forumData['success']) && $forumData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.forum')),
                        'data' => $forumInsertData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.forum')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($forumData['success']) && $forumData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.forum')),
                        'data' => $forumInsertData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.forum')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function deleteForum()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $forumId = $this->request->getVar('forum_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('forum_id', lang('CommonWebService.forum_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transBegin();
            $forumId = ($forumId != '') ? explode(",", $forumId) : '';
            $imageData = $this->visitorModel->getDocumentImageData(array(
                "document_type_id" => $forumId,
                "document_type" => 'forum',
                "is_multiple" => 1
            ));

            if(is_array($imageData) && !empty($imageData)){
                foreach ($imageData as $image){
                    $FileUrl = '';
                    if(isset($image['document_image']) && $image['document_image'] != '') {
                        $FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
                    }
                    if (file_exists($FileUrl)) {
                        unlink($FileUrl);
                    }
                    $thumbnailFileUrl = '';
                    if(isset($image['document_image']) && $image['document_image'] != '') {
                        $thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
                    }
                    if (file_exists($thumbnailFileUrl)) {
                        unlink($thumbnailFileUrl);
                    }
                }
            }

            $forumData = $this->commonWebserviceModel->deleteForumRecord($forumId, $userSocietyId);
            if ($forumData['success']) {
                if (!empty($forumId)) {
                    foreach ($forumId as $forum) {
                        $deleteDataArray['module'] = 'Forum';
                        $deleteDataArray['activity'] = "Forum Deleted";
                        $deleteDataArray['module_id'] = $forum;
                        logActivity('Forum Deleted [ForumID: ' . $forum . ']', $userSocietyId, 'Forum', $forum, json_encode($deleteDataArray), '', 'Forum', $forum);
                    }
                }
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.forum')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.forum')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function deleteForumImage()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $documentImageId = $this->request->getVar('document_image_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('document_image_id', lang('CommonWebService.document_image_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transBegin();
            $documentImageId = ($documentImageId != '') ? explode(",", $documentImageId) : '';
            $imageData = $this->visitorModel->getDocumentImageData(array(
                "document_image_id" => $documentImageId,
                "is_multiple" => 1
            ));

            if(is_array($imageData) && !empty($imageData)){
                foreach ($imageData as $image){
                    $FileUrl = '';
                    if(isset($image['document_image']) && $image['document_image'] != '') {
                        $FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
                    }
                    if (file_exists($FileUrl)) {
                        unlink($FileUrl);
                    }
                    $thumbnailFileUrl = '';
                    if(isset($image['document_image']) && $image['document_image'] != '') {
                        $thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
                    }
                    if (file_exists($thumbnailFileUrl)) {
                        unlink($thumbnailFileUrl);
                    }
                }
            }
            $documentImageData = $this->commonWebserviceModel->deleteForumImageRecord($documentImageId);
            if ($documentImageData['success']) {
                if (!empty($documentImageId)) {
                    foreach ($documentImageId as $documentImage) {
                        $deleteDataArray['module'] = 'Forum Image';
                        $deleteDataArray['activity'] = "Forum Image Deleted";
                        $deleteDataArray['module_id'] = $documentImage;
                        logActivity('Forum Image Deleted [ForumImageID: ' . $documentImage . ']', $userSocietyId, 'Forum', $documentImage, json_encode($deleteDataArray), '', 'Forum Image', $documentImage);
                    }
                }
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.forum_image')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.forum_image')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditLikes()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $isLike = $this->request->getVar('is_like');
        $societyId = $this->request->getVar('society_id');
        $type = $this->request->getVar('type');
        $typeId = $this->request->getVar('type_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');

        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('type', lang('CommonWebService.type'), 'required|alpha');
        $this->validation->setRule('type_id', lang('CommonWebService.type_id'), 'required|numeric');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'is_multiple' => 1,
                'type' => $type,
                'type_id' => $typeId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            );

            $likesData = $this->commonWebserviceModel->getLikesData($filterArray);
            $likesIdArray = array();
            if (!empty($likesData)) {
                foreach ($likesData as $likesElement) {
                    array_push($likesIdArray, $likesElement['likes_id']);
                }
            }

            if (!empty($likesIdArray)) {
                $this->commonWebserviceModel->deleteLikesRecord($likesIdArray);
            }
            if ($isLike == 0) {
                $totalLikesData = $this->commonWebserviceModel->getTotalLikesData(array(
                    'type' => $type,
                    'type_id' => $typeId,
                ));
                $totalLikes = isset($totalLikesData['total_likes']) ? $totalLikesData['total_likes'] : 0;
                $this->db->transCommit();

                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.dis_likes')),
                    'data' => null,
                    'total_likes' => (int)$totalLikes
                ), 200);
            } else {
                $likesArray = array(
                    'likes_id' => '',
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'type' => $type,
                    'type_id' => $typeId,
                    'society_id' => $societyId
                );

                $extraData = array();
                $extraObj['api_user_id'] = $userSocietyId;
                $extraObj['society_id'] = $societyId;
                $extraData['is_api_data'] = $extraObj;
                $likesData = $this->commonWebserviceModel->insertUpdateRecord($likesArray, 'likes_id', 'tbl_likes', 1, '', array(), $extraData);
                $lastLikesId = $likesData['lastInsertedId'];

                $totalLikesData = $this->commonWebserviceModel->getTotalLikesData(array(
                    'type' => $type,
                    'type_id' => $typeId,
                ));

                $totalLikes = isset($totalLikesData['total_likes']) ? $totalLikesData['total_likes'] : 0;

                if (isset($likesData['success']) && $likesData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.like')),
                        'data' => null,
                        'total_likes' => (int)$totalLikes
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed'), lang('CommonWebService.like')),
                        'data' => null,
                        'total_likes' => (int)$totalLikes
                    ), 400);
                }
            }

        }
    }

    public function addEditComment()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $societyId = $this->request->getVar('society_id');
        $type = $this->request->getVar('type');
        $appType = $this->request->getVar('app_type');
        $typeId = $this->request->getVar('type_id');
        $message = $this->request->getVar('message');
        $parentCommentId = $this->request->getVar('parent_comment_id');
        $commentId = $this->request->getVar('comment_id');

        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('type', lang('CommonWebService.type'), 'required|alpha');
        $this->validation->setRule('type_id', lang('CommonWebService.type_id'), 'required|numeric');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('message', lang('CommonWebService.message'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $commentArray = array(
                'comment_id' => $commentId,
                'type' => $type,
                'type_id' => $typeId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'message' => $message,
                'parent_comment_id' => $parentCommentId,
                'is_deleted' => 0,
                'society_id' => $societyId
            );
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $commentData = $this->commonWebserviceModel->insertUpdateRecord($commentArray, 'comment_id', 'tbl_comment', 1, '', array(), $extraData);
            $lastCommentId = $commentData['lastInsertedId'];
            $commentInsertData = $this->commonWebserviceModel->getCommentData(array(
                'comment_id' => $lastCommentId,
            ));

            $path = site_url('uploads/no_image.png');
            $thumbnailPath = site_url('uploads/no_image.png');
            if ($commentInsertData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $commentInsertData['member_image'])) {
                $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $commentInsertData['member_image'];
            }
            $commentInsertData['thumbnail_member_image'] = $thumbnailPath;

            if ($commentInsertData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $commentInsertData['member_image'])) {
                $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $commentInsertData['member_image'];
            }
            $commentInsertData['member_image'] = $path;

            if($commentInsertData['comment_created_by'] == $userSocietyId){
                $commentInsertData['is_comment_created_by_me'] = 1;
            } else {
                $commentInsertData['is_comment_created_by_me'] = 0;
            }

            $commentInsertData['created_at_display'] = time_elapsed_string($commentInsertData['created_at']);
            $commentInsertData['updated_at_display'] = time_elapsed_string($commentInsertData['updated_at']);

            // Notification Forum comment
            if($commentId == '' && strtolower($type) == 'forum'){
                $ownershipFlatMemberIdArray = array();
                $customerDataArray = array();
                $batchNotificationDataArray = array();
                $notificationArray = array(
                    'notification_title' => 'Forum Comment',
                    'description' => 'A Forum titled has been commented by the member. Please check the app to read the full comment.',
                );
                $deviceIdArray = array();
                $iosDeviceIdArray = array();
                $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
                $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
                $forumFollowedData = $this->commonWebserviceModel->getFollowData(array(
                    'type_id' => $typeId,
                    'type' => $type,
                    'society_id' => $societyId,
                    'is_multiple' => 1,
                ));
                
                $forumData = $this->forumModel->getForumData(array(
                    'forum_id' => $typeId,  
                ));
                // printArray($forumData,1);
                if(!empty($forumFollowedData)){
                    foreach($forumFollowedData as $forumFollow){
                        $ownershipFlatMemberIdArray[] = $forumFollow['followed_id']; // Change member_id join in tbl_member
                    }
                }
                if(!empty($forumData)){
                    if($forumData['type'] == 'member'){
                        $ownershipFlatMemberIdArray[] = $forumData['type_id'];
                    }
                }
                if (($key = array_search($ownershipFlatMemberId, $ownershipFlatMemberIdArray)) !== false) {
                    unset($ownershipFlatMemberIdArray[$key]);
                }
                $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                    'resource_type_name' => RESOURCE_TYPE_MEMBER,
                    'society_id' => $societyId,
                ));
                if(!empty($ownershipFlatMemberIdArray)){
                    $userDeviceArray = $this->commonWebserviceModel->deviceData(array(
                        "user_type" => MEMBER_APP,
                        'user_type_id' => $ownershipFlatMemberIdArray,
                        "is_latest" => 1,
                        "is_multiple" => 1,
                    ));
                    if(!empty($userDeviceArray)){
                        foreach($userDeviceArray as $userDevice){

                            $notificationOtherArray = array(
                                'notification_id' => '',
                                'society_id' => $societyId,
                                'notification_date' => TODAY_DATE_YMD,
                                'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                'type' => 'forum',
                                'type_id' => $typeId,
                                // 'module' => 'poll',
                                'created_by' => $userSocietyId,
                                'updated_by' => $userSocietyId,
                                'created_at' => date("Y-m-d H:i:s"),
                                'updated_at' => date("Y-m-d H:i:s"),
                            );
                            $notificationOtherArray['send_for_notification'] = $appType;
                            $notificationOtherArray['send_for_notification_id'] = $userSocietyId;
                            $notificationOtherArray['receive_for_notification'] = $userDevice['user_type'];
                            $notificationOtherArray['receive_for_notification_id'] = $userDevice['user_type_id'];
                            if(!empty($notificationArray)){
                                $notificationArray = array_merge($notificationArray,$notificationOtherArray);
                                $extraDataJsonArray = $notificationArray;
                                $extraDataJsonArray['module'] = 'forum';
                                $extraDatajson = json_encode($extraDataJsonArray);
                                $notificationArray['extra_data'] = $extraDatajson;
                                $customerData['extra_data'] = $extraDatajson;

                                $sendNotificationDataArray[] = array(
                                    'notification_title' => 'Forum Comment',
                                    'description' => 'A Forum titled has been commented by the member. Please check the app to read the full comment.',
                                    'extra_data_json' => $extraDatajson,
                                    'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                    'device_id' => isset($userDevice['device_id']) ? $userDevice['device_id'] : '',
                                    'type' => 'forum',
                                );

                                //send notification data
                                // $deviceToken = $userDevice['one_signal_id'];
                                // $deviceId = $userDevice['device_id'];
                                // $batchNotificationDataArray[] = $notificationArray;
                                // if(strtolower($userDevice['device_type']) == 'android'){
                                //     if (!empty($deviceId)) {
                                //         array_push($deviceIdArray,$deviceId);
                                //     }
                                // } else {
                                //     if (!empty($deviceId)) {
                                //         array_push($iosDeviceIdArray,$deviceId);
                                //     }
                                // }
                            }
                        }
                    }
                    if(!empty($batchNotificationDataArray)){
                        $this->commonWebserviceModel->batchInsert($batchNotificationDataArray,'tbl_notification');
                    }
                    // $sendNotificationData = array();
                    // if(!empty($deviceIdArray)){
                    //     $customerData['device_id'] = $deviceIdArray;
                    //     $customerData['app_url'] = MEMBER_URL .'forum_detail/' . $typeId;
                    //     $sendNotificationData = $customerData;
                    //     sendNotificationAndroid($sendNotificationData);
                    // }
                    // $sendNotificationIOSData = array();
                    // if(!empty($iosDeviceIdArray)){
                    //     $customerData['device_id'] = $iosDeviceIdArray;
                    //     $sendNotificationIOSData = $customerData;
                    //     sendNotificationIOS($sendNotificationIOSData);
                    // }   

                    if(!empty($sendNotificationDataArray)){
                        sendNotification($sendNotificationDataArray,true);
                    }
                }
            }
            if (isset($commentId) && !empty($commentId)) {
                if (isset($commentData['success']) && $commentData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.comment')),
                        'data' => $commentInsertData,
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed'), lang('CommonWebService.comment')),
                        'data' => $commentInsertData,
                    ), 404);
                }
            } else {
                if (isset($commentData['success']) && $commentData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.comment')),
                        'data' => $commentInsertData,
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed'), lang('CommonWebService.comment')),
                        'data' => $commentInsertData,
                    ), 400);
                }
            }
        }
    }

    public function getCommentList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $commentId = $this->request->getVar('comment_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $type = $this->request->getVar('type');
        $typeId = $this->request->getVar('type_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');

        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_db_connect' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'comment_id' => $commentId,
                'user_society_id' => $userSocietyId,
                'type' => $type,
                'type_id' => $typeId,
                'is_deleted' => 0,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            );
            $commentData = $this->commonWebserviceModel->getCommentData($filterArray);
            // Step 1: Create an array to store comments with comment_id as the key
            $commentTree = [];

            // Step 2: Loop through the comments and add them to the array
            if (!empty($commentData)) {
                foreach ($commentData as $comment) {
                    $comment['created_at'] = YMDToDMY($comment["created_at"], true);
                    $comment['updated_at'] = YMDToDMY($comment["updated_at"], true);
                    $comment['created_at_display'] = time_elapsed_string($comment['created_at']);
                    $comment['updated_at_display'] = time_elapsed_string($comment['updated_at']);

                    if($comment['comment_created_by'] == $userSocietyId){
                        $comment['is_comment_created_by_me'] = 1;
                    } else {
                        $comment['is_comment_created_by_me'] = 0;
                    }

                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($comment['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $comment['member_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $comment['member_image'];
                    }
                    $comment['thumbnail_member_image'] = $thumbnailPath;

                    if ($comment['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $comment['member_image'])) {
                        $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $comment['member_image'];
                    }
                    $comment['member_image'] = $path;
                    $commentTree[$comment['comment_id']] = $comment;  // Store comment by its comment_id
                }
            }

            // Step 3: Organize the comments into a nested structure by assigning replies to their parent
            if (!empty($commentTree)) {
                foreach ($commentTree as $comment_id => $comment) {
                    if ($comment['parent_comment_id'] != 0) {
                        // This is a reply, so add it to its parent comment's replies array
                        // $commentTree[$comment['parent_comment_id']]['parent_comment_data'][] = $comment;
                        // if (!isset($commentTree[$comment['parent_comment_id']]['parent_comment_data'])) {
                        //     $commentTree[$comment['parent_comment_id']]['parent_comment_data'] = [];
                        // }
                        $commentTree[$comment['parent_comment_id']]['parent_comment_data'][] = $comment;
                        $commentTree[$comment['parent_comment_id']]['parent_comment_data'] = array_reverse($commentTree[$comment['parent_comment_id']]['parent_comment_data']);
                        // Now we can remove this reply from the top-level array, as it's nested under its parent
                        unset($commentTree[$comment_id]);
                    }
                }
            }

            if (!empty($commentTree)) {
                $commentTree = array_values($commentTree);
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.comment_listing_successfully'),
                    'data' => $commentTree,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $commentTree,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }


    public function deleteComment()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $commentId = $this->request->getVar('comment_id');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('comment_id', lang('CommonWebService.comment_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transBegin();
            $commentId = ($commentId != '') ? explode(",", $commentId) : '';
            $commentData = $this->commonWebserviceModel->deleteCommentRecord(array('comment_id' => $commentId, 'user_society_id' => $userSocietyId));
            if ($commentData['success']) {
                if (!empty($commentId)) {
                    foreach ($commentId as $comment) {
                        $deleteDataArray['module'] = 'Comment';
                        $deleteDataArray['activity'] = "Comment Deleted";
                        $deleteDataArray['module_id'] = $comment;
                        logActivity('Comment Deleted [CommentID: ' . $comment . ']', $userSocietyId, 'Comment', $comment, json_encode($deleteDataArray), '', 'Comment', $comment);
                    }
                }
                $this->db->transCommit();
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.comment')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $this->db->transRollback();
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.comment')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function deleteResource()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $resourceId = $this->request->getVar('resource_id');
        $resourceFlatId = $this->request->getVar('resource_flat_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('resource_id', lang('CommonWebService.resource_id'), 'required');
        $this->validation->setRule('resource_flat_id', lang('CommonWebService.resource_flat_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transBegin();
            $resourceId = ($resourceId != '') ? explode(",", $resourceId) : '';
            $resourceFlatId = ($resourceFlatId != '') ? explode(",", $resourceFlatId) : '';
            $this->resourceModel->deleteResourceFaltWorkingDayRecord(array('resource_flat_id' => $resourceFlatId, 'resource_id' => $resourceId, 'user_society_id' => $userSocietyId));
            $resourceData = $this->resourceModel->deleteResourceFaltRecord(array('resource_flat_id' => $resourceFlatId, 'resource_id' => $resourceId, 'user_society_id' => $userSocietyId));
            $start = 0;
            if(!empty($ownershipFlatMemberId)){
                $ownershipMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                ));
                $ownershipFlatId = $ownershipMemberFlatData['ownership_flat_id'];
            }
            else{
                $ownershipFlatId = 0;
            }
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                // 'search' => $search,
                'society_id' => $societyId,
                'resource_id' => $resourceId,
                'user_society_id' => $userSocietyId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'ownership_flat_id' => $ownershipFlatId,
                'is_deleted' => 0,
            );
            if (!empty($isMyResource)) {
                $resourceIdArray = array();
                $ownershipMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_show_all_member' => 1,
                    'is_active' => 1
                ));
                if (!empty($ownershipMemberFlatData)) {
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        'ownership_flat_id' => $ownershipMemberFlatData['ownership_flat_id'],
                        'is_deleted' => 0,
                        'is_multiple' => 1,
                        'is_helper' => 1,
                    ));
                }
                if (!empty($resourceFlatData)) {
                    foreach ($resourceFlatData as $resourceElement) {
                        $resourceIdArray[] = $resourceElement['resource_id'];
                    }
                }
                if (!empty($resourceIdArray)) {
                    $rData = $this->resourceModel->getResourceData(array(
                        'resource_id' => $resourceIdArray,
                        'ownership_flat_id' => $ownershipFlatId,
                        'start' => $start,
                        // 'search' => $search,
                        'is_multiple' => 1,
                        'is_helper' => 1,
                    ));
                }
            } else {
                $rData = $this->resourceModel->getResourceData($filterArray);
            }
            $objectFilterData = array(
                'resource_type_id' => array('resource_type_id', 'resource_type_name'),
            );
            $resourceFlatDataWise = array();
            $resourceFlatAlreadyDataWise = array();
            $resourceDocumentDataWise = array();
            $resourceWorkingDayDataWise = array();
            $resourceIdArray = array();
            if (!empty($rData)) {
                foreach ($rData as $resourceElement) {
                    $resourceIdArray[] = $resourceElement['resource_id'];
                }
                if (!empty($resourceIdArray)) {
                    $resourceFlatAlreadyAddedData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'is_deleted' => 0,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatAlreadyAddedData)) {
                        foreach ($resourceFlatAlreadyAddedData as $resourceFlataddedElement) {
                            $resourceFlatAlreadyDataWise[$resourceFlataddedElement['resource_id']][] = $resourceFlataddedElement;
                        }
                    }
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'is_deleted' => 0,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlatElement) {
                            $resourceFlatDataWise[$resourceFlatElement['resource_id']][] = $resourceFlatElement;
                        }
                    }
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceIdArray,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $resourceImageElement) {
                            if ($resourceImageElement["document_image"] == '') {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                            }
                            $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                        }
                    }
                }
            }
            if (!empty($rData)) {
                foreach ($rData as $vKey => $resource) {
                    $rData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                    $rData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                    $rData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                    $rData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                    // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                    // $rData[$vKey]['resource_type'] = $formattedResourceType;
                    $rData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                    $rData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                    $rData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                    $path = '';
                    if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                        $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                    }
                    $rData[$vKey]['qr_code_image'] = $path;
                    $resourceImagePath = site_url('uploads/no_image.png');
                    if ($resource['resource_image'] != '' && file_exists(DOCUMENT_IMAGE_PATH . $resource['resource_image'])) {
                        $resourceImagePath = site_url() . DOCUMENT_IMAGE_PATH . $resource['resource_image'];
                    }
                    $rData[$vKey]['resource_image'] = $resourceImagePath;
                    $rData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_id']] : array();
                    $rData[$vKey]['resource_flat_already_added_data'] = array_key_exists($resource['resource_id'], $resourceFlatAlreadyDataWise) ? $resourceFlatAlreadyDataWise[$resource['resource_id']] : array();
                    $rData[$vKey]['resource_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                        "share_qr_code_image" => $path,
                    );
                    $rData[$vKey]['share_data'] = $shareData;
                }
            }

            if ($resourceData['success']) {
                if (!empty($resourceId)) {
                    foreach ($resourceId as $resource) {
                        $deleteDataArray['module'] = 'Resource';
                        $deleteDataArray['activity'] = "Resource Deleted";
                        $deleteDataArray['module_id'] = $resource;
                        logActivity('Resource Deleted [ResourceID: ' . $resource . ']', $userSocietyId, 'Resource', $resource, json_encode($deleteDataArray), '', 'Resource', $resource);
                    }
                }
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.resource')),
                    'response_code' => 200,
                    'data' => $rData,);

                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.resource')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditFollow()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $isFollow = $this->request->getVar('is_follow');
        $societyId = $this->request->getVar('society_id');
        $type = $this->request->getVar('type');
        $typeId = $this->request->getVar('type_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');

        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('type', lang('CommonWebService.type'), 'required|alpha');
        $this->validation->setRule('type_id', lang('CommonWebService.type_id'), 'required|numeric');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'is_multiple' => 1,
                'type' => $type,
                'type_id' => $typeId,
                'followed_id' => $ownershipFlatMemberId,
            );

            $followData = $this->commonWebserviceModel->getFollowData($filterArray);
            $followIdArray = array();
            if (!empty($followData)) {
                foreach ($followData as $followElement) {
                    array_push($followIdArray, $followElement['follow_id']);
                }
            }

            if (!empty($followIdArray)) {
                $this->commonWebserviceModel->deleteFollowRecord($followIdArray);
            }
            if ($isFollow == 0) {
                $this->db->transCommit();

                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.unfollow')),
                    'data' => null,
                ), 200);
            } else {
                $followArray = array(
                    'follow_id' => '',
                    'followed_id' => $ownershipFlatMemberId,
                    'followed_at' => date("Y-m-d H:i:s"),
                    'type' => $type,
                    'type_id' => $typeId,
                    'society_id' => $societyId
                );

                $extraData = array();
                $extraObj['api_user_id'] = $userSocietyId;
                $extraObj['society_id'] = $societyId;
                $extraData['is_api_data'] = $extraObj;
                $followsData = $this->commonWebserviceModel->insertUpdateRecord($followArray, 'follow_id', 'tbl_follow', 1, '', array(), $extraData);
                $lastFollowId = $followsData['lastInsertedId'];

                $followFilterArray = array(
                    'follow_id' => $lastFollowId,
                );

                $followInsertData = $this->commonWebserviceModel->getFollowData($followFilterArray);
                if (isset($followsData['success']) && $followsData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.following')),
                        'data' => $followInsertData,
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed'), lang('CommonWebService.following')),
                        'data' => null,
                    ), 400);
                }
            }

        }
    }

    public function getEmergencyList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $emergencyNumberId = $this->request->getVar('emergency_number_id');
        $appType = $this->request->getVar('app_type');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');

        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if ($appType == MEMBER_APP) {
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }

        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'is_deleted' => 0,
                'start' => $start,
                'search' => $search,
                'emergency_number_id' => $emergencyNumberId,
                'user_society_id' => $userSocietyId
            );
            $emergencyData = $this->commonWebserviceModel->getEmergencyData($filterArray);
            $emergencyIdArray = array();
            $emergencyDocumentDataWise = array();
            if (!empty($emergencyData)) {
                foreach ($emergencyData as $emergencyElement) {
                    $emergencyIdArray[] = $emergencyElement['emergency_number_id'];
                }

                if (!empty($emergencyIdArray)) {
                    $emergencyImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $emergencyIdArray,
                        "document_type" => 'emergency_contact',
                        "is_multiple" => 1
                    ));

                    if (!empty($emergencyImageData)) {
                        foreach ($emergencyImageData as $emergencyImageElement) {
                            if ($emergencyImageElement["document_image"] == '') {
                                $emergencyImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $emergencyImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $emergencyImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $emergencyImageElement["document_image"];
                                $emergencyImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $emergencyImageElement["document_image"];
                            }
                            $emergencyDocumentDataWise[$emergencyImageElement['document_type_id']][] = $emergencyImageElement;
                        }
                    }
                }
            }

            if (!empty($emergencyData)) {
                foreach ($emergencyData as $ekey => $emergency) {
                    $emergencyData[$ekey]['created_at'] = YMDToDMY($emergency["created_at"], true);
                    $emergencyData[$ekey]['updated_at'] = YMDToDMY($emergency["updated_at"], true);
                    $emergencyData[$ekey]['created_at_display'] = time_elapsed_string($emergency['created_at']);
                    $emergencyData[$ekey]['updated_at_display'] = time_elapsed_string($emergency['created_at']);
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $emergencyData[$ekey]['share_data'] = $shareData;
                    $emergencyData[$ekey]['emergency_image_data'] = array_key_exists($emergency['emergency_number_id'], $emergencyDocumentDataWise) ? $emergencyDocumentDataWise[$emergency['emergency_number_id']] : array();
                }
            }

            if (!empty($emergencyData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.emergency_listing_successfully'),
                    'data' => $emergencyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $emergencyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getBookingList()
    {
        // printArray($_POST,1);
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $amenitiesId = $this->request->getVar('amenities_id');
        $bookingId = $this->request->getVar('booking_id');
        $societyId = $this->request->getVar('society_id');
        $startDate = $this->request->getVar('start_date');
        $endDate = $this->request->getVar('end_date');
        $userSocietyId = $this->request->getVar('user_society_id');
        $statusArray = $this->request->getVar('status');
        $isShowAllBooking = $this->request->getVar('is_show_all_booking');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');

        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        // $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'booking_id' => $bookingId,
                'amenities_id' => $amenitiesId,
                'society_id' => $societyId,
                'user_society_id' => $userSocietyId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            );

            if (!empty($startDate)) {
                $filterArray['start_date'] = DMYToYMD($startDate);
            }
            if (!empty($endDate)) {
                $filterArray['end_date'] = DMYToYMD($endDate);
            }
            
            // if(empty($isShowAllBooking) && empty($ownershipFlatMemberId)){
            //     $filterArray['date_greater_than_equal_to'] = TODAY_DATE_YMD;
            // }

            if(empty($ownershipFlatMemberId)){
                $filterArray['admin_approval_required'] = 1;
                $filterArray['status'] = $statusArray;
                // $filterArray['arrproved_by'] = $userSocietyId;
            }

            // if(!empty($isShowAllBooking)){
            //     $filterArray['admin_approval_required'] = 1;
            // }
            
            $bookingData = $this->bookingModel->getMyBookingData($filterArray);
            // lastQuery();
            if (!empty($bookingData)) {
                foreach ($bookingData as $bkey => $booking) {
                    $bookingData[$bkey]['start_time_display'] = isset($booking['start_time']) ? date("h:i A", strtotime($booking['start_time'])) : '';
                    $bookingData[$bkey]['end_time_display'] = isset($booking['end_time']) ? date("h:i A", strtotime($booking['end_time'])) : '';
                    $bookingData[$bkey]['start_and_end_time_display'] = $bookingData[$bkey]['start_time_display'] . ' - ' . $bookingData[$bkey]['end_time_display'];
                    $bookingData[$bkey]["booking_date_display"] = isValidDate($booking['booking_date']) ? date('d M, Y', strtotime($booking["booking_date"])) : "";
                    $bookingData[$bkey]['created_at'] = YMDToDMY($booking["created_at"], true);
                    $bookingData[$bkey]['updated_at'] = YMDToDMY($booking["updated_at"], true);
                    $bookingData[$bkey]['created_at_display'] = time_elapsed_string($booking['created_at']);
                    $bookingData[$bkey]['updated_at_display'] = time_elapsed_string($booking['created_at']);
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $bookingData[$bkey]['share_data'] = $shareData;
                }
            }

            $amenitiesData = $this->amenitiesModel->getAmenitiesData(array(
                'admin_approval_required' => 1,
                'is_multiple' => 1
            ));

            $bookingStatusArray = array(
                'pending' => 'Pending',
                'confirmed' => 'Confirmed',
                'cancelled' => 'Cancelled',
            );

            $newArray = [];
            foreach ($bookingStatusArray as $key => $value) {
                $newArray[] = [
                    'key' => $key,
                    'value' => $value,
                ];
            }
            if (!empty($bookingData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.booking_listing_successfully'),
                    'amenitiesData' => $amenitiesData,
                    'data' => $bookingData,
                    'bookingStatusData' => $newArray,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'amenitiesData' => $amenitiesData,
                    'data' => $bookingData,
                    'bookingStatusData' => $newArray,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    function getFlatList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $flatId = $this->request->getVar('flat_id');
        $towerId = $this->request->getVar('tower_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'flat_id' => $flatId,
                'tower_id' => $towerId,
                'society_id' => $societyId,
                'is_active' => 1,
            );
            $flatData = $this->flatModel->getFlatData($filterArray);
            if (isset($flatId) && count($flatId) == 1) {
                $flatData = isset($flatData[0]) ? $flatData[0] : array();
            }
            if (!empty($flatData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.flat_listing_successfully'),
                    'data' => $flatData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                //return $this->respond($data,200);
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $flatData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                //return $this->respond($data,404);
                return $this->response($data, 404);
            }
        }
    }

    function getSocietyList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'society_id' => $societyId,
                'is_active' => 1,
            );
            $societyData = $this->societyModel->getSocietyData($filterArray);
            if (isset($societyId) && count($societyId) == 1) {
                $societyData = isset($societyData[0]) ? $societyData[0] : array();
            }
            if (!empty($societyData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.society_listing_successfully'),
                    'data' => $societyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                //return $this->respond($data,200);
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $societyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                //return $this->respond($data,404);
                return $this->response($data, 404);
            }
        }
    }

    public function deleteComplain()
    {
        //printArray($_POST);
        $complainId = $this->request->getVar('complain_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('complain_id', lang('CommonWebService.complain_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            $complainData = $this->complainModel->getComplainData(array(
                "complain_id" => $complainId
            ));
            if(!empty($complainData)){
                $statusData = $this->statusModel->getStatusData(array(
                    "status_id" => $complainData['status_id']
                ));
                if(!empty($statusData)){
                    if(!$statusData['is_open']){
                        $data = array(
                            'status' => False,
                            'message' => lang("CommonMessage.change_status_error"),
                            'response_code' => 404,
                            'data' => null,
                        );
                        return $this->response($data, 404);
                    }
                }
            }
            $complainId = ($complainId != '') ? explode(",", $complainId) : '';
            $complainData = $this->complainModel->deleteRecord($complainId, $userSocietyId, $societyId);
            if (isset($complainId) && $complainId != '') {
                if ($complainData > 0) {
                    $this->db->transCommit();
                    $data = array(
                        'status' => TRUE,
                        'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.complain')),
                        'response_code' => 200,
                        'data' => null,);

                    return $this->response($data, 200);
                } else {
                    $this->db->transRollback();
                    $data = array(
                        'status' => False,
                        'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.complain')),
                        'response_code' => 404,
                        'data' => null,
                    );
                    return $this->response($data, 404);
                }
            }
        }
    }

    public function deleteMeeting()
    {
        //printArray($_POST);
        $meetingId = $this->request->getVar('meeting_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('meeting_id', lang('CommonWebService.meeting_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $meetingId = ($meetingId != '') ? explode(",", $meetingId) : '';
            $meetingData = $this->meetingModel->deleteRecord($meetingId, $userSocietyId, $societyId);
            if (isset($meetingId) && $meetingId != '') {
                if ($meetingData > 0) {
                    $this->db->transCommit();
                    $data = array(
                        'status' => TRUE,
                        'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.meeting')),
                        'response_code' => 200,
                        'data' => null,);

                    return $this->response($data, 200);
                } else {
                    $this->db->transRollback();
                    $data = array(
                        'status' => False,
                        'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.meeting')),
                        'response_code' => 404,
                        'data' => null,
                    );
                    return $this->response($data, 404);
                }
            }
        }
    }

    public function addEditMeeting()
    {
        // $myfilePost = fopen("registractionPost3.json", "a") or die("Unable to open file!");
        // fwrite($myfilePost, json_encode($_POST));
        // fclose($myfilePost);

        // $myfilePostA = fopen("registractionPost3.json", "a") or die("Unable to open file!");
        // fwrite($myfilePostA, json_encode($_FILES));
        // fclose($myfilePostA);
        // die();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $meetingId = $this->request->getVar('meeting_id');
        $meetingDateTime = $this->request->getVar('meeting_date_time');
        $meetingAgenda = $this->request->getVar('meeting_agenda');
        $meetingTitle = $this->request->getVar('meeting_title');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $meetingRecord = $this->request->getVar('meeting_record[]');
        $meetingRecordIdArray = $this->request->getVar('meeting_record_id_array');
        $this->validation->setRule('meeting_date_time', lang('Meeting.meeting_date_time'), 'required');
        $this->validation->setRule('meeting_agenda', lang('Meeting.meeting_agenda'), 'required');
        $this->validation->setRule('meeting_title', lang('Meeting.meeting_title'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            // if (isset($meetingId) && $meetingId != '') {
            //     $meetingData = $this->meetingModel->deleteRecordMeetingRecord($meetingId, $userSocietyId, $societyId);
            // }

            $meetingRecord = array();
            if (isset($_FILES["meeting_record"])) {
                $meetingRecordPath = MEETING_RECORD_PATH;
                $meetingRecord = $dt_ci_file_upload->UploadMultipleFile('meeting_record', MAX_IMAGE_SIZE_LIMIT, $meetingRecordPath, true, true, array('mp3','mp4', 'ogg', 'pdf', 'jpg', 'jpeg' , 'png'));
                if ($meetingRecord['success'] == false) {
                    return $this->response(array(
                       'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($meetingRecord['message']),
                        'data' => null
                    ), 404);
                }
            }


            $meetingUpdateArray = array();
            $meetingArray = array(
                'meeting_id' => $meetingId,
                'meeting_title' => $meetingTitle,
                'meeting_agenda' => $meetingAgenda,
                'meeting_date_time' => DMYToYMD($meetingDateTime, true, true),
                'society_id' => $societyId,
                'is_active' => 1,
            );
            if (!empty($meetingId)) {
                $meetingUpdateData = $this->meetingModel->getMeetingData(array(
                    'meeting_id' => $meetingId,
                ));
                $meetingUpdateArray = compareArray($meetingArray, $meetingUpdateData);
            }


            $extraData = array();
            $extraObj['is_api_call'] = 1;
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $meetingData = $this->commonWebserviceModel->insertUpdateRecord($meetingArray, 'meeting_id', 'tbl_meeting', 1, '', array(), $extraData, $meetingUpdateArray);
            $lastMeetingId = $meetingData['lastInsertedId'];
            if($lastMeetingId != ''){
                if(isset($meetingRecord) && count($meetingRecord) > 0){
                    $batchArray = array();
                    unset($meetingRecord['success']);
                    foreach ($meetingRecord as $key => $recordData) {
                        $dataArray = array(
                            'meeting_record_id' =>   '',
                            'meeting_id' => $lastMeetingId,
                            'meeting_record' => isset($recordData['file_name']) ? $recordData['file_name'] : "",
                            'created_by' => $userSocietyId,
                            'updated_by' => $userSocietyId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($batchArray, $dataArray);
                    }

                    $meetingExtraDataArray = array();
                    $meetingExtraDataArray['module_id'] = $lastMeetingId;
                    $meetingExtraDataArray['module'] = 'Meeting Record';
                    $meetingExtraDataArray['type'] = 'Meeting';
                    $meetingExtraDataArray['old_data'] = array();
                    $meetingExtraDataArray['user_id'] = $userSocietyId;
                    $meetingExtraDataArray['society_id'] = $societyId;
                    $this->meetingModel->batchInsert($batchArray, 'tbl_meeting_record',$meetingExtraDataArray);
                }
            }
            if(isset($meetingRecordIdArray) && !empty($meetingRecordIdArray)){
                $this->meetingModel->deleteMeetingRecord($meetingRecordIdArray,$userSocietyId,$societyId);
            }
            $meeetingFilterArray = array(
                'meeting_id' => $lastMeetingId,
            );
            $meetingInsertData = $this->meetingModel->getMeetingData($meeetingFilterArray);
            if (!empty($meetingInsertData)) {
                $meetingInsertData['created_at'] = YMDToDMY($meetingInsertData["created_at"], true);
                $meetingInsertData['updated_at'] = YMDToDMY($meetingInsertData["updated_at"], true);
                $meetingInsertData['created_at_display'] = time_elapsed_string($meetingInsertData['created_at']);
                $meetingInsertData['updated_at_display'] = time_elapsed_string($meetingInsertData['updated_at']);
                $meetingInsertData["display_meeting_date_time"] = YMDToDMY($meetingInsertData["meeting_date_time"], true);
                $meetingInsertData["meeting_date_display"] = isValidDate($meetingInsertData['meeting_date_time']) ? date('d M, Y', strtotime($meetingInsertData["meeting_date_time"])) : "";
                $meetingInsertData["meeting_time_display"] = isValidDate($meetingInsertData['meeting_date_time']) ? date('h:i A', strtotime($meetingInsertData["meeting_date_time"])) : "";
                $path = site_url('uploads/no_image.png');

                $meetingRecordData = $this->meetingModel->getMeetingRecordData(array(
                    "meeting_id" => isset($meetingInsertData['meeting_id']) ? $meetingInsertData['meeting_id'] : "",
                    "is_multiple" => 1,
                ));
                $imageData = array();
                $audioData = array();
                $pdfData = array();
                $videoData = array();
                if (!empty($meetingRecordData)) {
                    foreach ($meetingRecordData as $iData) {
                        if ($iData['meeting_record'] == '') {
                            $iData["meeting_record"] = site_url('uploads/no_image.png');
                        } else {
                            $iData["meeting_record"] = SITE_URL() . MEETING_RECORD_PATH . $iData["meeting_record"];
                        }
                        $fileExtension = pathinfo($iData['meeting_record'], PATHINFO_EXTENSION);
                        $iData['media_type'] = $fileExtension;
                        if(in_array($fileExtension, ['jpg', 'jpeg', 'png'])){
                            $imageData[] = $iData;
                        } else if($fileExtension == 'mp3' || $fileExtension == 'ogg'){
                            $audioData[] = $iData;
                        } else if($fileExtension == 'pdf'){
                            $pdfData[] = $iData;
                        } else if($fileExtension == 'mp4') {
                            $videoData[] = $iData;
                        }
                    }
                }
                $meetingInsertData['meeting_image_data'] = $imageData;
                $meetingInsertData['meeting_audio_data'] = $audioData;
                $meetingInsertData['meeting_pdf_data'] = $pdfData;
                $meetingInsertData['meeting_video_data'] = $videoData;
            }

            if (isset($meetingId) && !empty($meetingId)) {
                if (isset($meetingData['success']) && $meetingData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.meeting')),
                        'data' => $meetingInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.meeting')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($meetingData['success']) && $meetingData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.meeting')),
                        'data' => $meetingInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.meeting')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    function getMeetingList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $meetingId = $this->request->getVar('meeting_id');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'society_id' => $societyId,
                'meeting_id' => $meetingId,
                'is_active' => 1,
            );
            $meetingData = $this->meetingModel->getMeetingData($filterArray);
            // printArray($meetingData,1);
            if (!empty($meetingData)) {
                foreach ($meetingData as $bkey => $meeting) {
                    $meetingData[$bkey]['created_at'] = YMDToDMY($meeting["created_at"], true);
                    $meetingData[$bkey]['updated_at'] = YMDToDMY($meeting["updated_at"], true);
                    $meetingData[$bkey]['created_at_display'] = time_elapsed_string($meeting['created_at']);
                    $meetingData[$bkey]['updated_at_display'] = time_elapsed_string($meeting['updated_at']);
                    $meetingData[$bkey]["display_meeting_date_time"] = YMDToDMY($meeting["meeting_date_time"], true);
                    $meetingData[$bkey]["meeting_date_display"] = isValidDate($meeting['meeting_date_time']) ? date('d M, Y', strtotime($meeting["meeting_date_time"])) : "";
                    $meetingData[$bkey]["meeting_time_display"] = isValidDate($meeting['meeting_date_time']) ? date('h:i A', strtotime($meeting["meeting_date_time"])) : "";
                    $path = site_url('uploads/no_image.png');

                    $meetingRecordData = $this->meetingModel->getMeetingRecordData(array(
                        "meeting_id" => isset($meeting['meeting_id']) ? $meeting['meeting_id'] : "",
                        "is_multiple" => 1,
                    ));
                    $imageData = array();
                    $audioData = array();
                    $pdfData = array();
                    // $videoData = array();
                    if (!empty($meetingRecordData)) {
                        foreach ($meetingRecordData as $iData) {
                            if ($iData['meeting_record'] == '') {
                                $iData["meeting_record"] = site_url('uploads/no_image.png');
                            } else {
                                $iData["meeting_record"] = SITE_URL() . MEETING_RECORD_PATH . $iData["meeting_record"];
                            }
                            $fileExtension = pathinfo($iData['meeting_record'], PATHINFO_EXTENSION);
                            $iData['media_type'] = $fileExtension;
                            if(in_array($fileExtension, ['jpg', 'jpeg', 'png'])){
                                $imageData[] = $iData;
                            } else if($fileExtension == 'mp3' || $fileExtension == 'ogg' || $fileExtension == 'mp4'){
                                $audioData[] = $iData;
                            } else if($fileExtension == 'pdf'){
                                $pdfData[] = $iData;
                            } 
                            // else if($fileExtension == 'mp4') {
                            //     $videoData[] = $iData;
                            // }
                        }
                    }
                    $meetingData[$bkey]['meeting_image_data'] = $imageData;
                    $meetingData[$bkey]['meeting_audio_data'] = $audioData;
                    $meetingData[$bkey]['meeting_pdf_data'] = $pdfData;
                    // $meetingData[$bkey]['meeting_video_data'] = $videoData;
                }
            }
            if (!empty($meetingData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.meeting_listing_successfully'),
                    'data' => $meetingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                //return $this->respond($data,200);
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $meetingData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                //return $this->respond($data,404);
                return $this->response($data, 404);
            }
        }
    }

    public function getEditResourceList()
    {
        $societyId = $this->request->getVar('society_id');
        $resourceId = $this->request->getVar('resource_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $resourceTypeId = $this->request->getVar('resource_type_id');
        $userSocietyId = $this->request->getVar('user_society_id');

        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('resource_id', lang('CommonWebService.resource_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {

            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'is_helper' => 1,
                'resource_type_id' => $resourceTypeId,
                'society_id' => $societyId,
                'resource_id' => $resourceId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'user_society_id' => $userSocietyId,
                'is_deleted' => 0,
            );
            $resourceData = $this->resourceModel->getResourceFlatData($filterArray);
            $objectFilterData = array(
                'flat_id' => array('flat_id', 'tower_flat_name'),
                'ownership_flat_member_id' => array('ownership_flat_member_id', 'name'),
                'resource_type_id' => array('resource_type_id', 'resource_type_name'),
            );
            $resourceDocumentDataWise = array();
            $resourceWorkingDayDataWise = array();
            $resourceFlatIdArray = array();
            $resourceIdArray = array();
            if (!empty($resourceData)) {
                foreach ($resourceData as $resourceElement) {
                    $resourceFlatIdArray[] = $resourceElement['resource_flat_id'];
                    $resourceIdArray[] = $resourceElement['resource_id'];
                }

                if (!empty($resourceFlatIdArray)) {
                    $resourceWorkingDayData = $this->resourceModel->getResourceWorkingDayData(array(
                        "resource_flat_id" => $resourceFlatIdArray,
                        "resource_id" => $resourceIdArray,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceWorkingDayData)) {
                        foreach ($resourceWorkingDayData as $resourceWorkingElement) {
                            $resourceWorkingDayDataWise[$resourceWorkingElement['resource_id']][] = $resourceWorkingElement;
                        }
                    }
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceIdArray,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $resourceImageElement) {
                            if ($resourceImageElement["document_image"] == '') {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                            }
                            $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                        }
                    }

                }
            }
            if (!empty($resourceData)) {
                foreach ($resourceData as $vKey => $resource) {
                    // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                    $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);

                    $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                    $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                    $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                    // $resourceData[$vKey]['resource_type'] = $formattedResourceType;
                    $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                    $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                    $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                    $resourceData[$vKey]['resource_working_day_data'] = array_key_exists($resource['resource_id'], $resourceWorkingDayDataWise) ? $resourceWorkingDayDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['resource_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $resourceData[$vKey]['share_data'] = $shareData;
                    $resourceData[$vKey]['share_data'] = $shareData;
                }
            }
            if (!empty($resourceData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.resource_listing_successfully'),
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditResource()
    {
        // printArray($_POST,1);
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $resourceId = $this->request->getVar('resource_id');
        $resourceFlatId = $this->request->getVar('resource_flat_id');
        $resourceName = $this->request->getVar('resource_name');
        $resourceMobileNo = $this->request->getVar('resource_mobile_no');
        $status = $this->request->getVar('status');
        $resourceInTime = $this->request->getVar('resource_in_time');
        $resourceOutTime = $this->request->getVar('resource_out_time');
        // $address = $this->request->getVar('address');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');
        // $categoryId = $this->request->getVar('category_id');
        $resourceWeekDay = $this->request->getVar('resource_week_day');
        $towerId = $this->request->getVar('tower_id');
        $flatId = $this->request->getVar('flat_id');
        $type = $this->request->getVar('type');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $documentImage = $this->request->getVar('document_image[]');
        $idProof = $this->request->getVar('id_proof');
        $isStatusUpdate = $this->request->getVar('is_status_update');
        $isNotificationSend = $this->request->getVar('is_notification_send');
        $appType = $this->request->getVar('app_type');
        $fatherName = $this->request->getVar('father_name');
        $dateOfBirth = $this->request->getVar('date_of_birth');
        $gender = $this->request->getVar('gender');
        $work = $this->request->getVar('work');
        $presentAddress = $this->request->getVar('present_address');
        $permanentAddress = $this->request->getVar('permanent_address');
        $reference = $this->request->getVar('reference');
        $isOutsourced = $this->request->getVar('is_outsourced');
        $vendorId = $this->request->getVar('vendor_id');
        $resourceTypeId = $this->request->getVar('resource_type_id');

        // $resourceInTime = $this->request->getVar('resource_in_time');
        // $resourceOutTime = $this->request->getVar('resource_out_time');
        $this->validation->setRule('resource_type_id', lang('CommonWebService.resource_type'), 'required');
        $this->validation->setRule('resource_name', lang('CommonWebService.resource_name'), 'required');
        $this->validation->setRule('resource_in_time', lang('CommonWebService.resource_in_time'), 'required');
        $this->validation->setRule('resource_out_time', lang('CommonWebService.resource_out_time'), 'required');
        $this->validation->setRule('resource_week_day', lang('CommonWebService.resource_week_day'), 'required');
        $this->validation->setRule('resource_mobile_no', lang('CommonWebService.resource_mobile_no'), 'required|max_length[10]|min_length[10]');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {

            // Json Decode for resource Name and Mobile No
            $resourceWeekDayArray = json_decode($resourceWeekDay, true);
            if (empty($resourceWeekDayArray)) {
                return $this->response(array(
                    'status' => FALSE,
                    'message' => "Weekdays Are Required",
                    'data' => null,
                    'response_code' => 400,
                ), 400);
            }

             $resourceData = $this->resourceModel->getResourceData(array(
                'resource_mobile_no' => $resourceMobileNo,
                'resource_id_not' => $resourceId,
                'society_id' => $societyId,
            ));

            $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                'resource_type_name' => array(RESOURCE_TYPE_MANAGER,RESOURCE_TYPE_MEMBER),
                'is_multiple' => 1
            ));

            $resourceTypeIdArray = array_column($resourceTypeData,'resource_type_id');

            $userData = $this->commonWebserviceModel->getUserSocietyData(array(
                'phone' => $resourceMobileNo,
                'resource_type_id' => $resourceTypeIdArray,
                'society_id' => $societyId,
            ));

            if((!empty($resourceData)) || (!empty($userData))){
                return $this->response(array(
                    'status' => FALSE,
                    'message' => lang("Resource.mobile_no_already_exist"),
                    'data' => null,
                    'response_code' => 400,
                ), 400);
            }


            if($appType != MANAGER_APP){
                $towerId = 0;
                $flatId = 0;
                $ownershipFlatId = 0;
                $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_active' => 1,
                    'is_show_all_member' => 1
                ));

                if (!empty($ownershipFlatData)) {
                    $flatId = isset($ownershipFlatData['flat_id']) ? $ownershipFlatData['flat_id'] : 0;
                    $ownershipFlatId = isset($ownershipFlatData['ownership_flat_id']) ? $ownershipFlatData['ownership_flat_id'] : 0;
                    $type = isset($ownershipFlatData['type']) ? $ownershipFlatData['type'] : 0;
                    $towerId = isset($ownershipFlatData['tower_id']) ? $ownershipFlatData['tower_id'] : 0;
                }
            }
            else{
                $ownershipFlatArray = array(
                    'tower_id' => $towerId,
                    'flat_id' => $flatId,
                    'ownership_flat_id' => $ownershipFlatId,
                    'type' => $type,
                    'is_active' => 1,
                    'is_show_all_member' => 1
                );
                if($type == 'ownership_flat'){
                    $ownershipFlatArray['is_owner'] = 1;
                }
                else{
                    $ownershipFlatArray['agreement_with'] = 1;
                }
                $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData($ownershipFlatArray);
                if (!empty($ownershipFlatData)) {
                    $ownershipFlatMemberId = isset($ownershipFlatData['ownership_flat_member_id']) ? $ownershipFlatData['ownership_flat_member_id'] : 0;
                }
            }

            $resourceFlatDataArray  = $this->resourceModel->getResourceFlatData(array(
                'resource_type_id' => $resourceTypeId,
                'resource_name' => $resourceName,
                'resource_mobile_no' => $resourceMobileNo,
                'resource_id' => $resourceId,
                // 'ownership_flat_member_id' =>  $ownershipFlatMemberId,
                'ownership_flat_id' =>  $ownershipFlatId,
                'is_helper' => 1,
                'is_deleted' => 0
            ));

            if(!empty($resourceFlatDataArray)){
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => ($resourceFlatDataArray['resource_type_name']) .' '. lang('CommonWebService.already_added_to_this_flat'),
                    'data' => null
                ), 404);
            }
            
            if (isset($resourceId) && $resourceId != '') {
                if (isset($resourceFlatId) && $resourceFlatId != '') {
                    $this->resourceModel->deleteRecordResourceFlat($resourceFlatId, $resourceId, $userSocietyId, $societyId);
                    $this->resourceModel->deleteRecordWorkingDay($resourceFlatId, $resourceId, $userSocietyId, $societyId);
                }
            }
            $documentImageData = array();
            if (isset($_FILES["document_image"])) {
                $documentImagePath = DOCUMENT_IMAGE_PATH;
                $documentImageData = $dt_ci_file_upload->UploadMultipleFile('document_image', MAX_IMAGE_SIZE_LIMIT, $documentImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($documentImageData['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($documentImageData['message']),
                        'data' => null
                    ), 404);
                }
                else{
                    unset($documentImageData['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailMultipleUploadFile($documentImageData, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
            }
            // Json Decode for resource Name and Mobile No
            // $resourceWeekDayArray = json_decode($resourceWeekDay, true);
            $resourceUpdateArray = array();
            $resourceArray = array(
                'resource_id' => $resourceId,
                'resource_name' => $resourceName,
                'resource_mobile_no' => $resourceMobileNo,
                'society_id' => $societyId,
                // 'category_id' => $categoryId,
                // 'address' => $address,
                // 'category_id' => $categoryId,
                'father_name' => $fatherName,
                'date_of_birth' => DMYToYMD($dateOfBirth),
                'gender' => $gender,
                'work' => $work,
                'present_address' => $presentAddress,
                'permanent_address' => $permanentAddress,
                'reference' => $reference,
                'resource_type_id' => $resourceTypeId,
                'is_outsourced' => isset($isOutsourced) ? 1 : 0,
            );
            if(isset($isOutsourced)){
                $resourceArray['vendor_id'] = $vendorId;
            } else {
                $resourceArray['vendor_id'] = 0;
            }
            if ($resourceId == '') {
                $resourceArray['status'] = 'approved';
                $resourceArray['qr_code_number'] = GenRandomNumber(6);
                //$combineQRCodeType  =$resourceArray['qr_code_number'] . '_' .'resource';
                $combineQRCodeType = $resourceArray['qr_code_number'];
//              $codeContents  = "BEGIN:VCARD\n";
//              $codeContents .= "VERSION:2.1\n";
//              // $codeContents .= 'N:' . $visitorId . "\n";
//              $codeContents .= "FN:$combineQRCodeType \n";
//              $codeContents .= "END:VCARD";
                $codeContents = $combineQRCodeType;
                qrcode('text', $codeContents, 4, '', $combineQRCodeType);
                $resourceArray['qr_code_image'] = $combineQRCodeType . '.png';
                // $visitorUpdateArray = compareArray($visitorArray,$visitorUpdateData);
            }
            if (!empty($resourceId)) {
                $resourceUpdateData = $this->resourceModel->getResourceData(array(
                    'resource_id' => $resourceId,
                ));
                $resourceUpdateArray = compareArray($resourceArray, $resourceUpdateData);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $resourceData = $this->commonWebserviceModel->insertUpdateRecord($resourceArray, 'resource_id', 'tbl_resource', 1, '', array(), $extraData, $resourceUpdateArray);
            $lastResourceId = $resourceData['lastInsertedId'];
            $resourceFlatArray = array(
                'resource_flat_id' => '',
                'resource_id' => $lastResourceId,
                'tower_id' => $towerId,
                'flat_id' => $flatId,
                'ownership_flat_id' => $ownershipFlatId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'resource_in_time' => $resourceInTime,
                'resource_out_time' => $resourceOutTime,
            );
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $resourceFlatData = $this->commonWebserviceModel->insertUpdateRecord($resourceFlatArray, 'resource_flat_id', 'tbl_resource_flat', 1, '', array(), $extraData);
            $lastResourceFlatId = $resourceFlatData['lastInsertedId'];
            // Working Day Store
            if (is_array($resourceWeekDayArray)) {
                foreach ($resourceWeekDayArray as $workingDay) {
                    $workingDayArray = array(
                        'resource_working_day_id' => '',
                        'resource_id' => $lastResourceId,
                        'resource_flat_id' => $lastResourceFlatId,
                        'working_day_id' => $workingDay['working_day_id'],
                        'working_day_name' => $workingDay['working_day_name'],
                        'resource_in_time' => $resourceInTime,
                        'resource_out_time' => $resourceOutTime,
                    );
                    $workingDayData = array();
                    $workingDayUpdateArray = array();
                    $workingDayObj['api_user_id'] = $userSocietyId;
                    $workingDayObj['society_id'] = $societyId;
                    $workingDayData['is_api_data'] = $workingDayObj;
                    $resourceWorkingDayData = $this->commonWebserviceModel->insertUpdateRecord($workingDayArray, 'resource_working_day_id', 'tbl_resource_working_day', 1, '', array(), $workingDayData, $workingDayUpdateArray);
                    $lastResourceWorkingDayDataId = $resourceWorkingDayData['lastInsertedId'];
                }
            }

            // resource Multiple Image Store
            if ($lastResourceId != '') {
                if (isset($documentImageData) && count($documentImageData) > 0) {
                    $batchArray = array();
                    unset($documentImageData['success']);
                    foreach ($documentImageData as $key => $imageData) {
                        $dataArray = array(
                            'document_image_id' => '',
                            'document_type' => 'resource',
                            'document_type_id' => $lastResourceId,
                            'document_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                            'created_by' => $userSocietyId,
                            'updated_by' => $userSocietyId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $resourceExtraDataArray = array();
                    $resourceExtraDataArray['module_id'] = $lastResourceId;
                    $resourceExtraDataArray['module'] = 'Resource Image';
                    $resourceExtraDataArray['type'] = 'Resource';
                    $resourceExtraDataArray['old_data'] = '';
                    $resourceExtraDataArray['user_id'] = $userSocietyId;
                    $resourceExtraDataArray['society_id'] = $societyId;
                    $this->resourceModel->batchInsert($batchArray, 'tbl_document_image', $resourceExtraDataArray);
                }
            }


            if($isNotificationSend == 1){
                if (!empty($ownershipFlatData)) {
                    $ownershipFlatMemberIdArray = array();
                    $memberIdArray = array();
                    $notificationDataArray = array();
                    $userDeviceUserSocietyIdArray = array();
                    $userDeviceUserTypeIdArray = array();
                    $userDeviceUserTypeArray = array();
                    
                    if($appType != MANAGER_APP){
                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_id' => $ownershipFlatId,
                            'type' => $type,
                            'is_multiple' => 1,
                            'ownership_flat_member_id_not' => $ownershipFlatMemberId
                        ));
                    } else {
                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_id' => $ownershipFlatId,
                            'type' => $type,
                            'is_multiple' => 1,
                        ));
                    }
                    $resourceSendData = $this->resourceModel->getResourceData(array(
                        'resource_id' => $resourceId,
                        'is_helper' => 1,
                    ));
                    $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceId,
                        "document_type" => 'resource',
                    ));
                    $visitorImagePath = SITE_URL('uploads/no_image.png');
                    if (!empty($visitorImageData)) {
                        if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                            $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                        }
                    }
                    if(!empty($ownershipFlatMemberData)){
                        foreach($ownershipFlatMemberData as $ownershipFlatMember){
                            $ownershipFlatMemberIdArray[] = $ownershipFlatMember['ownership_flat_member_id'];
                            $memberIdArray[] = $ownershipFlatMember['member_id'];
                        }
                    }
                    $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                        'resource_type_name' => RESOURCE_TYPE_MEMBER,
                        'society_id' => $societyId,
                    ));
                    if (!empty($ownershipFlatMemberIdArray)) {
                        $userSocietyFamilyData = $this->commonWebserviceModel->getUserSocietyData(array(
                            'society_id' => $societyId,
                            'resource_type_id' => $resourceTypeData['resource_type_id'],
                            'type_id' => $memberIdArray,
                            'user_society_id_not' => $userSocietyId,
                            'is_multiple' => 1
                        ));

                        if (!empty($userSocietyFamilyData)) {
                            foreach ($userSocietyFamilyData as $userSocietyFamilyElement) {
                                $userDeviceUserSocietyIdArray[] = isset($userSocietyFamilyElement['user_society_id']) ? $userSocietyFamilyElement['user_society_id'] : 0;
                            }
                            $userDevice = $this->commonWebserviceModel->deviceData(array(
                                "user_society_id" => $userDeviceUserSocietyIdArray,
                                "user_type" => MEMBER_APP,
                                "is_latest" => 1,
                                "is_multiple" => 1,
                            ));

                            $userDeviceIdArray = array();

                            if(!empty($userDevice)){
                                foreach($userDevice as $userDeviceElement){
                                    $userDeviceIdArray[] = $userDeviceElement['device_id'];
                                }
                            }

                            $notificationType = $this->commonWebserviceModel->getNotificationTypeData(array(
                                'notification_type' => ucwords('resources'),
                            ));

                            $notificationTypeDevice = $this->commonWebserviceModel->getNotificationStoreList(array(
                                'notification_type_id' => $notificationType['notification_type_id'],
                                'device_id' => $userDeviceIdArray,
                                'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                                'is_multiple' => 1,
                            ));

                            if(!empty($userDevice)){
                                foreach ($userDevice as &$device) {
                                    foreach ($notificationTypeDevice as $notification) {
                                        if ($device['device_id'] == $notification['device_id'] && $device['user_type_id'] == $notification['ownership_flat_member_id']) {
                                            $device['is_enabled'] = $notification['is_enabled'];
                                        }
                                    }
                                }
                            }

                            if (!empty($userDevice)) {
                                foreach ($userDevice as $userDeviceElement) {
                                    if ($userDeviceElement['is_enabled'] == 1) {
                                        if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
                                            $resourceType = $resourceSendData['resource_type_name'];
                                            $notificationArray = array(
                                                'ownership_flat_id' => 0,
                                                'ownership_flat_member_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'type' => 'resource',
                                                'status' => 'new_resource',
                                                'notification_date' => TODAY_DATE_YMD,
                                                'type_id' => $resourceId,
                                                'society_id' => $societyId,
                                                'visitor_name' => $resourceSendData['resource_name'],
                                                'user_society_id' => $userSocietyId,
                                                'notification_title' => $resourceType . ' Added To Your Flat : ' . $resourceSendData['resource_name'],
                                                'description' => $resourceSendData['resource_name'] . ', your ' . $resourceType . ', has been added to your flat by the ' . $resourceSendData['updated_by_name'] . '.',
                                                'module' => 'resource',
                                                'category_name' => $resourceType,
                                                'guard' => $resourceSendData['updated_by_name'],
                                                'mobile_no' => $resourceSendData['resource_mobile_no'],
                                                'display_status' => underscoreToUcWord('entered'),
                                                'image' => $visitorImagePath,
                                                'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
                                                'receive_for_notification' => isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : '',
                                                'app_type' => $appType,
                                            );

                                            // if ($appType == GATE_KEEPER) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                // $notificationArray['receive_for_notification'] = MEMBER_APP;
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            // }
                                            $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                            array_push($notificationDataArray, $notificationArray);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (!empty($notificationDataArray)) {
                        sendNotificationResourceAndroid($notificationDataArray);
                    }
                }
            }

            // $categoryData = $this->categoryModel->getCategoryData(array(
            //     'category_for' => 'resource',
            //     'is_multiple' => 1,
            //     'is_active' => 1,
            // ));
            
            $start = 0;
            if(!empty($ownershipFlatMemberId)){
                $ownershipMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                ));
                $ownershipFlatId = $ownershipMemberFlatData['ownership_flat_id'];
            }
            else{
                $ownershipFlatId = 0;
            }
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                // 'search' => $search,
                // 'category_id' => $categoryId,
                // 'category_name' => $categoryName,
                'resource_type_id' => $resourceTypeId,
                'society_id' => $societyId,
                'resource_id' => $lastResourceId,
                'user_society_id' => $userSocietyId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'ownership_flat_id' => $ownershipFlatId,
                'is_deleted' => 0,
                'is_helper' => 1,
            );
            if (!empty($isMyResource)) {
                $resourceIdArray = array();
                $ownershipMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_show_all_member' => 1,
                    'is_active' => 1
                ));
                if (!empty($ownershipMemberFlatData)) {
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        'ownership_flat_id' => $ownershipMemberFlatData['ownership_flat_id'],
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        'is_multiple' => 1
                    ));
                }
                if (!empty($resourceFlatData)) {
                    foreach ($resourceFlatData as $resourceElement) {
                        $resourceIdArray[] = $resourceElement['resource_id'];
                    }
                }
                if (!empty($resourceIdArray)) {
                    $rData = $this->resourceModel->getResourceData(array(
                        'resource_id' => $resourceIdArray,
                        'ownership_flat_id' => $ownershipFlatId,
                        'start' => $start,
                        // 'search' => $search,
                        // 'category_id' => $categoryId,
                        // 'category_name' => $categoryName,
                        'resource_type_id' => $resourceTypeId,
                        'is_multiple' => 1
                    ));
                }
            } else {
                $rData = $this->resourceModel->getResourceData($filterArray);
            }
            $objectFilterData = array(
                'resource_type_id' => array('resource_type_id', 'resource_type_name'),
            );
            $resourceFlatDataWise = array();
            $resourceFlatAlreadyDataWise = array();
            $resourceDocumentDataWise = array();
            $resourceWorkingDayDataWise = array();
            $resourceIdArray = array();
            if (!empty($rData)) {
                foreach ($rData as $resourceElement) {
                    $resourceIdArray[] = $resourceElement['resource_id'];
                }
                if (!empty($resourceIdArray)) {
                    $resourceFlatAlreadyAddedData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'is_deleted' => 0,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatAlreadyAddedData)) {
                        foreach ($resourceFlatAlreadyAddedData as $resourceFlataddedElement) {
                            $resourceFlatAlreadyDataWise[$resourceFlataddedElement['resource_id']][] = $resourceFlataddedElement;
                        }
                    }
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'is_deleted' => 0,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlatElement) {
                            $resourceFlatDataWise[$resourceFlatElement['resource_id']][] = $resourceFlatElement;
                        }
                    }
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceIdArray,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $resourceImageElement) {
                            if ($resourceImageElement["document_image"] == '') {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                            }
                            $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                        }
                    }
                }
            }
            if (!empty($rData)) {
                foreach ($rData as $vKey => $resource) {
                    $rData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                    // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                    $rData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                    $rData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                    $rData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                    $rData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                    // $rData[$vKey]['resource_type'] = $formattedResourceType;
                    $rData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                    $rData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                    $path = '';
                    if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                        $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                    }
                    $rData[$vKey]['qr_code_image'] = $path;
                    $resourceImagePath = site_url('uploads/no_image.png');
                    if ($resource['resource_image'] != '' && file_exists(DOCUMENT_IMAGE_PATH . $resource['resource_image'])) {
                        $resourceImagePath = site_url() . DOCUMENT_IMAGE_PATH . $resource['resource_image'];
                    }
                    $rData[$vKey]['resource_image'] = $resourceImagePath;
                    $rData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_id']] : array();
                    $rData[$vKey]['resource_flat_already_added_data'] = array_key_exists($resource['resource_id'], $resourceFlatAlreadyDataWise) ? $resourceFlatAlreadyDataWise[$resource['resource_id']] : array();
                    $rData[$vKey]['resource_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                        "share_qr_code_image" => $path,
                    );
                    $rData[$vKey]['share_data'] = $shareData;
                }
            }

                    
            if (isset($resourceId) && !empty($resourceId)) {
                if (isset($resourceData['success']) && $resourceData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.resource')),
                        'data' => $rData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.resource')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($resourceData['success']) && $resourceData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.resource')),
                        'data' => $rData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.resource')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function resourceExited()
    {
        $visitorId = $this->request->getVar('visitor_id');
        $status = $this->request->getVar('status');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('visitor_id', lang('CommonWebService.visitor_id'), 'required');
        $this->validation->setRule('status', lang('CommonWebService.status'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $visitorUpdateArray = array();
            $visitorUpdateData = $this->visitorModel->getVisitorData(array(
                'visitor_id' => $visitorId,
            ));
            $isInsertUpdate = 1;
            if (!empty($visitorUpdateData)) {
                if ($visitorUpdateData['status'] == 'exited') {
                    $isInsertUpdate = 0;
                }

                if ($isInsertUpdate == 1) {
                    $visitorArray = array(
                        'visitor_id' => $visitorId,
                        'status' => $status,
                    );
                    if ($status == 'exited') {
                        $visitorArray['end_date'] = date("Y-m-d H:i:s");
                    }
                    $extraData = array();
                    $extraObj['api_user_id'] = $userSocietyId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $visitorUpdateArray = compareArray($visitorArray, $visitorUpdateData);

                    $visitorData = $this->commonWebserviceModel->insertUpdateRecord($visitorArray, 'visitor_id', 'tbl_visitor', 1, '', array(), $extraData, $visitorUpdateArray);

                    $resourceData = $this->resourceModel->getResourceData(array(
                        'resource_id' => $visitorUpdateData['resource_id'],
                        'is_helper' => 1,
                        'is_deleted' => 0,
                    ));
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        'resource_id' => $visitorUpdateData['resource_id'],
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        'is_multiple' => 1
                    ));
                    $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $visitorUpdateData['resource_id'],
                        "document_type" => 'resource',
                    ));
                    $visitorImagePath = SITE_URL('uploads/no_image.png');
                    if (!empty($visitorImageData)) {
                        if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                            $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                        }
                    }

                    $ownershipFlatMemberIdArray = array();
                    $memberIdArray = array();
                    $ownershipFlatIdWiseArray = array();
                    $ownershipTypeWiseArray = array();
                    $notificationDataArray = array();
                    $notificationArray = array();

                    $userDeviceUserSocietyIdArray = array();
                    $userDeviceUserTypeIdArray = array();
                    $userDeviceUserTypeArray = array();


                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlat) {
                            $ownershipFlatIdWiseArray[] = $resourceFlat['ownership_flat_id'];
                            $ownershipTypeWiseArray[] = $resourceFlat['type'];
                        }
                    }
                    
                    $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'ownership_flat_id' => $ownershipFlatIdWiseArray,
                        'type' => $ownershipTypeWiseArray,
                        'is_active' => 1,
                        'is_multiple' => 1
                    ));
                        

                    if (!empty($ownershipFlatMemberData)) {
                        foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                            $memberIdArray[] = $ownershipFlatMember['member_id'];
                            $ownershipFlatMemberIdArray[] = $ownershipFlatMember['ownership_flat_member_id'];
                        }
                    }
                    $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                        'resource_type_name' => RESOURCE_TYPE_MEMBER,
                        'society_id' => $societyId,
                    ));
                    if (!empty($memberIdArray)) {
                        $userSocietyFamilyData = $this->commonWebserviceModel->getUserSocietyData(array(
                            'society_id' => $societyId,
                            'resource_type_id' => $resourceTypeData['resource_type_id'],
                            'type_id' => $memberIdArray,
                            // 'is_user_device_token_get' => 1,
                            'is_multiple' => 1
                        ));

                        if (!empty($userSocietyFamilyData)) {
                            foreach ($userSocietyFamilyData as $userSocietyFamilyElement) {
                                $userDeviceUserSocietyIdArray[] = isset($userSocietyFamilyElement['user_society_id']) ? $userSocietyFamilyElement['user_society_id'] : 0;
                                $userDeviceUserTypeIdArray[] = isset($userSocietyFamilyElement['type_id']) ? $userSocietyFamilyElement['type_id'] : 0;
                                $userDeviceUserTypeArray[] = $resourceTypeData['resource_type_id'];
                            }
                            $userDevice = $this->commonWebserviceModel->deviceData(array(
                                "user_society_id" => $userDeviceUserSocietyIdArray,
                                "app_type" => MEMBER_APP,
                                // "resource_type_id" => $userDeviceUserTypeArray,
                                "is_latest" => 1,
                                "is_multiple" => 1,
                            ));

                            $userDeviceIdArray = array();

                            if(!empty($userDevice)){
                                foreach($userDevice as $userDeviceElement){
                                    $userDeviceIdArray[] = $userDeviceElement['device_id'];
                                }
                            }

                            $notificationType = $this->commonWebserviceModel->getNotificationTypeData(array(
                                'notification_type' => ucwords('resources'),
                            ));

                            $notificationTypeDevice = $this->commonWebserviceModel->getNotificationStoreList(array(
                                'notification_type_id' => $notificationType['notification_type_id'],
                                'device_id' => $userDeviceIdArray,
                                'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                                'is_multiple' => 1,
                            ));

                            if(!empty($userDevice)){
                                foreach ($userDevice as &$device) {
                                    foreach ($notificationTypeDevice as $notification) {
                                        if ($device['device_id'] == $notification['device_id'] && $device['user_type_id'] == $notification['ownership_flat_member_id']) {
                                            $device['is_enabled'] = $notification['is_enabled'];
                                        }
                                    }
                                }
                            }

                            if (!empty($userDevice)) {
                                foreach ($userDevice as $userDeviceElement) {
                                    if ($userDeviceElement['is_enabled'] == 1) {
                                        if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
                                            $resourceType = $visitorUpdateData['resource_type_name'];
                                            $notificationArray = array(
                                                'ownership_flat_id' => 0,
                                                'ownership_flat_member_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'type' => 'resource',
                                                'status' => 'exited',
                                                'notification_date' => TODAY_DATE_YMD,
                                                'type_id' => $visitorUpdateData['resource_id'],
                                                'society_id' => $societyId,
                                                'visitor_name' => $visitorUpdateData['visitor_name'],
                                                'user_society_id' => $userSocietyId,
                                                'notification_title' => $resourceType . ' Exited: ' . $visitorUpdateData['visitor_name'],
                                                'description' => $visitorUpdateData['visitor_name'] . ', your ' . $resourceType . ', has exited the premises. Their visit has concluded, and they have left the location.',
                                                'module' => 'resource',
                                                'category_name' => $resourceType,
                                                'guard' => $visitorUpdateData['updated_by_name'],
                                                'mobile_no' => $visitorUpdateData['visitor_mobile_no'],
                                                'display_status' => underscoreToUcWord('exited'),
                                                'image' => $visitorImagePath,
                                                'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
                                                'app_type' => $appType,
                                            );

                                            if ($appType == GATE_KEEPER) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                $notificationArray['receive_for_notification'] = $userDeviceElement['user_type'];
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                            array_push($notificationDataArray, $notificationArray);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if($resourceData['notification_to_all'] && empty($resourceFlatData)){
                        if (!empty($notificationDataArray)) {
                            sendNotificationResourceAndroid($notificationDataArray);
                        }
                    }else if(!empty($resourceFlatData)) {
                        if (!empty($notificationDataArray)) {
                            sendNotificationResourceAndroid($notificationDataArray);
                        }
                    }
                }
                $filterArray = array(
                    'is_multiple' => 1,
                    'resource_id' => $visitorUpdateData['resource_id'],
                    'is_helper' => 1,
                    'is_deleted' => 0,
                );
                $resourceData = $this->resourceModel->getResourceData($filterArray);
                $objectFilterData = array(
                    'resource_type_id' => array('resource_type_id', 'resource_type_name'),
                );
                $resourceFlatDataWise = array();
                $resourceFlatAlreadyDataWise = array();
                $resourceDocumentDataWise = array();
                $resourceWorkingDayDataWise = array();
                $resourceIdArray = array();
                if (!empty($resourceData)) {
                    foreach ($resourceData as $resourceElement) {
                        $resourceIdArray[] = $resourceElement['resource_id'];
                    }
                    if (!empty($resourceIdArray)) {
                        $resourceFlatAlreadyAddedData = $this->resourceModel->getResourceFlatData(array(
                            "resource_id" => $resourceIdArray,
                            'ownership_flat_member_id' => $userSocietyId,
                            'is_deleted' => 0,
                            "is_multiple" => 1
                        ));
                        if (!empty($resourceFlatAlreadyAddedData)) {
                            foreach ($resourceFlatAlreadyAddedData as $resourceFlataddedElement) {
                                $resourceFlatAlreadyDataWise[$resourceFlataddedElement['resource_id']][] = $resourceFlataddedElement;
                            }
                        }
                        $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                            "resource_id" => $resourceIdArray,
                            'is_deleted' => 0,
                            "is_multiple" => 1
                        ));
                        if (!empty($resourceFlatData)) {
                            foreach ($resourceFlatData as $resourceFlatElement) {
                                $resourceFlatDataWise[$resourceFlatElement['resource_id']][] = $resourceFlatElement;
                            }
                        }
                        $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                            "document_type_id" => $resourceIdArray,
                            "document_type" => 'resource',
                            "is_multiple" => 1
                        ));
                        if (!empty($resourceImageData)) {
                            foreach ($resourceImageData as $resourceImageElement) {
                                if ($resourceImageElement["document_image"] == '') {
                                    $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                    $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                                } else {
                                    $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                    $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                }
                                $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                            }
                        }
                    }
                }
                if (!empty($resourceData)) {
                    foreach ($resourceData as $vKey => $resource) {
                        // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                        $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                        
                        $endDateStatus = isValidDate($resource['end_date']) ? date('Y-m-d', strtotime($resource['end_date'])) : '';
                        if ($resource['visitor_status'] == 'exited' && $endDateStatus != TODAY_DATE_YMD) {
                            $status = 'approved';
                            $visitorStatus = 'approved';
                        } else {
                            $status = $resource['visitor_status'];
                            $visitorStatus = $resource['visitor_status'];
                        }


                        $startDate = isValidDate($resource['start_date']) ? $resource['start_date'] : date("Y-m-d H:i:s");
                        $endDate = isValidDate($resource['end_date']) ? $resource['end_date'] : date("Y-m-d H:i:s");
                        $resourceData[$vKey]['difference_start_end_date'] = calculateDateTimeDifference($startDate, $endDate);
                        $resourceData[$vKey]["start_date_time_display"] = date('d M, Y h:i A', strtotime($startDate));
                        $resourceData[$vKey]["end_date_time_display"] = date('d M, Y h:i A', strtotime($endDate));
                        $resourceData[$vKey]["start_date_display"] = date('d M, Y', strtotime($startDate));
                        $resourceData[$vKey]["end_date_display"] = date('d M, Y', strtotime($endDate));
                        $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                        // $resourceData[$vKey]["status"] = (isset($resource['status']) && $resource['status'] === 'approved') ? 'Not Arrived Yet' : $status;
                        $resourceData[$vKey]["visitor_status_display"] = (isset($resource['visitor_status']) && !empty($resource['visitor_status'])) ? underscoreToUcWord($status) : 'approved';
                        $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                        $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                        $path = '';
                        if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                            $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                        }
                        $resourceData[$vKey]['visitor_status'] = $visitorStatus;
                        $resourceData[$vKey]['qr_code_image'] = $path;
                        // $resourceData[$vKey]['resource_type'] = $formattedResourceType;
                        $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                        $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                        $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                        $resourceData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_id']] : array();
                        $resourceData[$vKey]['resource_flat_already_added_data'] = array_key_exists($resource['resource_id'], $resourceFlatAlreadyDataWise) ? $resourceFlatAlreadyDataWise[$resource['resource_id']] : array();
                        $resourceData[$vKey]['visitor_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                        $shareData = array(
                            'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                            'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                            'share_image' => base_url('uploads/no_image.png'),
                            "share_link" => "https://digitattva.in/",
                            "share_qr_code_image" => $path,
                        );
                        $resourceData[$vKey]['share_data'] = $shareData;
                    }
                }
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.resource_exited_unsuccessfully'),
                    'data' => null
                ), 400);
            }
            if ($isInsertUpdate == 0) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.this_visitor_is_already') . underscoreToUcWord($status),
                    'data' => $resourceData
                ), 200);
            }
            if (isset($visitorData['success']) && $visitorData['success']) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.resource_exited_successfully'),
                    'data' => $resourceData
                ), 200);
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.resource_exited_unsuccessfully'),
                    'data' => $resourceData
                ), 400);
            }
        }
    }

    public function resourceEntered()
    {
        $resourceId = $this->request->getVar('resource_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('resource_id', lang('CommonWebService.resource_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $resourceData = $this->resourceModel->getResourceData(array(
                'resource_id' => $resourceId,
                'is_helper' => 1,
                'is_deleted' => 0,
            ));
            // $resourceFlatDataArray = $this->resourceModel->getResourceFlatData(array(
            //  'resource_id' => $resourceId,
            //  'is_multiple' => 1,
            // ));
            $isInsertUpdate = 1;
            $visitorUpdateArray = array();
            if (!empty($resourceData)) {
                if ($resourceData['visitor_status'] == 'entered') {
                    $isInsertUpdate = 0;
                }
                if ($isInsertUpdate == 1) {
                    $visitorArray = array(
                        'visitor_id' => '',
                        'visitor_name' => $resourceData['resource_name'],
                        'visitor_mobile_no' => $resourceData['resource_mobile_no'],
                        'society_id' => $resourceData['society_id'],
                        'resource_id' => $resourceData['resource_id'],
                        'resource_type_id' => $resourceData['resource_type_id'],
                        // 'category_id'=> $resourceData['category_id'],
                        'type' => 'resource',
                        'ownership_flat_member_id' => $userSocietyId,
                        'address' => $resourceData['address'],
                        'expected_start_date_time' => date("Y-m-d H:i:s"),
                        'status' => 'entered',
                        'start_date' => date("Y-m-d H:i:s"),
                    );
                    $extraData = array();
                    $extraObj['api_user_id'] = $userSocietyId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $visitorData = $this->commonWebserviceModel->insertUpdateRecord($visitorArray, 'visitor_id', 'tbl_visitor', 1, '', array(), $extraData, $visitorUpdateArray);

                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        'resource_id' => $resourceId,
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        'is_multiple' => 1
                    ));
                    $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceId,
                        "document_type" => 'resource',
                    ));
                    $visitorImagePath = SITE_URL('uploads/no_image.png');
                    if (!empty($visitorImageData)) {
                        if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                            $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                        }
                    }
                    $memberIdArray = array();
                    $ownershipFlatMemberIdArray = array();
                    $ownershipFlatIdWiseArray = array();
                    $ownershipTypeWiseArray = array();
                    $notificationDataArray = array();

                    $userDeviceUserSocietyIdArray = array();
                    $userDeviceUserTypeIdArray = array();
                    $userDeviceUserTypeArray = array();



                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlat) {
                            $ownershipFlatIdWiseArray[] = $resourceFlat['ownership_flat_id'];
                            $ownershipTypeWiseArray[] = $resourceFlat['type'];


                        }
                    }

                    $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'ownership_flat_id' => $ownershipFlatIdWiseArray,
                        'type' => $ownershipTypeWiseArray,
                        'is_active' => 1,
                        'is_multiple' => 1
                    ));
                        
                    if (!empty($ownershipFlatMemberData)) {
                        foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                            $memberIdArray[] = $ownershipFlatMember['member_id'];
                            $ownershipFlatMemberIdArray[] = $ownershipFlatMember['ownership_flat_member_id'];

                        }
                    }

                    $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                        'resource_type_name' => RESOURCE_TYPE_MEMBER,
                        'society_id' => $societyId,
                    ));

                    if (!empty($ownershipFlatMemberIdArray)) {
                        $userSocietyFamilyData = $this->commonWebserviceModel->getUserSocietyData(array(
                            'society_id' => $societyId,
                            'resource_type_id' => $resourceTypeData['resource_type_id'],
                            'type_id' => $memberIdArray,
                            'is_multiple' => 1
                        ));

                        if (!empty($userSocietyFamilyData)) {
                            foreach ($userSocietyFamilyData as $userSocietyFamilyElement) {
                                $userDeviceUserSocietyIdArray[] = isset($userSocietyFamilyElement['user_society_id']) ? $userSocietyFamilyElement['user_society_id'] : 0;
                                // $userDeviceUserTypeIdArray[] = isset($userSocietyFamilyElement['type_id']) ? $userSocietyFamilyElement['type_id'] : 0;
                                // $userDeviceUserTypeArray[] = $resourceTypeData['resource_type_id'];
                            }

                            // printArray($userDeviceUserTypeIdArray);
                            // printArray($ownershipFlatMemberIdArray);
                            $userDevice = $this->commonWebserviceModel->deviceData(array(
                                "user_society_id" => $userDeviceUserSocietyIdArray,
                                "app_type" => MEMBER_APP,
                                // "resource_type_id" => $userDeviceUserTypeArray,
                                "is_latest" => 1,
                                "is_multiple" => 1,

                            ));
                            

                            $userDeviceIdArray = array();

                            if(!empty($userDevice)){
                                foreach($userDevice as $userDeviceElement){
                                    $userDeviceIdArray[] = $userDeviceElement['device_id'];
                                }
                            }

                            $notificationType = $this->commonWebserviceModel->getNotificationTypeData(array(
                                'notification_type' => ucwords('resources'),
                            ));

                            $notificationTypeDevice = $this->commonWebserviceModel->getNotificationStoreList(array(
                                'notification_type_id' => $notificationType['notification_type_id'],
                                'device_id' => $userDeviceIdArray,
                                'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                                'is_multiple' => 1,
                            ));

                            // printArray($userDevice);
                            // printArray($notificationTypeDevice,1);
                            if (!empty($userDevice)) {
                                foreach ($userDevice as $key => $device) {
                                    $isEnabled = 0; // Default value
                                    foreach ($notificationTypeDevice as $notification) {
                                        if (
                                            $device['device_id'] == $notification['device_id'] &&
                                            $device['user_type_id'] == $notification['ownership_flat_member_id']
                                        ) {
                                            $isEnabled = $notification['is_enabled'];
                                            break; // match mil gaya, aur loop ka koi fayda nahi
                                        }
                                    }
                                    $userDevice[$key]['is_enabled'] = $isEnabled;
                                }
                            }

                            // printArray($userDevice,1);
                            if (!empty($userDevice)) {
                                foreach ($userDevice as $userDeviceElement) {
                                    if ($userDeviceElement['is_enabled'] == 1) {
                                        if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
                                            $resourceType = $resourceData['resource_type_name'];
                                            $notificationArray = array(
                                                'ownership_flat_id' => 0,
                                                'ownership_flat_member_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'type' => 'resource',
                                                'status' => 'entered',
                                                'notification_date' => TODAY_DATE_YMD,
                                                'type_id' => $resourceId,
                                                'society_id' => $societyId,
                                                'visitor_name' => $resourceData['resource_name'],
                                                'user_society_id' => $userSocietyId,
                                                'notification_title' => $resourceType . ' Entered: ' . $resourceData['resource_name'],
                                                // 'description' => $resourceData['resource_name'] . ', your ' . $resourceType . ', has been allowed entry by the ' . $resourceData['updated_by_name'] . ' and is now at the location. Please be aware of their presence during their visit.',
                                                'description' => $resourceData['resource_name'] . ', your ' . $resourceType . ', has been entered the premisis. Please be aware of their presence during their visit.',
                                                'module' => 'resource',
                                                'category_name' => $resourceType,
                                                'guard' => $resourceData['updated_by_name'],
                                                'mobile_no' => $resourceData['resource_mobile_no'],
                                                'display_status' => underscoreToUcWord('entered'),
                                                'image' => $visitorImagePath,
                                                'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
                                                'app_type' => $appType,
                                            );

                                            if ($appType == GATE_KEEPER) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                $notificationArray['receive_for_notification'] = $userDeviceElement['user_type'];
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                            array_push($notificationDataArray, $notificationArray);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    if($resourceData['notification_to_all'] && empty($resourceFlatData)){
                        if (!empty($notificationDataArray)) {
                            sendNotificationResourceAndroid($notificationDataArray);
                        }
                    }else if(!empty($resourceFlatData)) {
                        if (!empty($notificationDataArray)) {
                            sendNotificationResourceAndroid($notificationDataArray);
                        }
                    }

                }
            }

            $filterArray = array(
                'is_multiple' => 1,
                'resource_id' => $resourceId,
                'is_helper' => 1,
                'is_deleted' => 0,
            );
            $resourceData = $this->resourceModel->getResourceData($filterArray);
            $objectFilterData = array(
                'resource_type_id' => array('resource_type_id', 'resource_type_name'),
            );
            $resourceFlatDataWise = array();
            $resourceFlatAlreadyDataWise = array();
            $resourceDocumentDataWise = array();
            $resourceWorkingDayDataWise = array();
            $resourceIdArray = array();
            if (!empty($resourceData)) {
                foreach ($resourceData as $resourceElement) {
                    $resourceIdArray[] = $resourceElement['resource_id'];
                }
                if (!empty($resourceIdArray)) {
                    $resourceFlatAlreadyAddedData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'ownership_flat_member_id' => $userSocietyId,
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatAlreadyAddedData)) {
                        foreach ($resourceFlatAlreadyAddedData as $resourceFlataddedElement) {
                            $resourceFlatAlreadyDataWise[$resourceFlataddedElement['resource_id']][] = $resourceFlataddedElement;
                        }
                    }
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'is_deleted' => 0,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlatElement) {
                            $resourceFlatDataWise[$resourceFlatElement['resource_id']][] = $resourceFlatElement;
                        }
                    }
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceIdArray,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $resourceImageElement) {
                            if ($resourceImageElement["document_image"] == '') {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                            }
                            $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                        }
                    }
                }
            }
            if (!empty($resourceData)) {
                foreach ($resourceData as $vKey => $resource) {
                    $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                    // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                    $endDateStatus = isValidDate($resource['end_date']) ? date('Y-m-d', strtotime($resource['end_date'])) : '';
                    if ($resource['visitor_status'] == 'exited' && $endDateStatus != TODAY_DATE_YMD) {
                        $status = 'approved';
                        $visitorStatus = 'approved';
                    } else {
                        $status = $resource['visitor_status'];
                        $visitorStatus = $resource['visitor_status'];
                    }
                    $startDate = isValidDate($resource['start_date']) ? $resource['start_date'] : date("Y-m-d H:i:s");
                    $endDate = isValidDate($resource['end_date']) ? $resource['end_date'] : date("Y-m-d H:i:s");
                    $resourceData[$vKey]['difference_start_end_date'] = calculateDateTimeDifference($startDate, $endDate);
                    $resourceData[$vKey]["start_date_time_display"] = date('d M, Y h:i A', strtotime($startDate));
                    $resourceData[$vKey]["end_date_time_display"] = date('d M, Y h:i A', strtotime($endDate));
                    $resourceData[$vKey]["start_date_display"] = date('d M, Y', strtotime($startDate));
                    $resourceData[$vKey]["end_date_display"] = date('d M, Y', strtotime($endDate));
                    $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                    // $resourceData[$vKey]["status"] = (isset($resource['status']) && $resource['status'] === 'approved') ? 'Not Arrived Yet' : $status;
                    $resourceData[$vKey]["visitor_status_display"] = (isset($resource['visitor_status']) && !empty($resource['visitor_status'])) ? underscoreToUcWord($status) : 'approved';
                    $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                    $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                    $path = '';
                    if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                        $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                    }
                    $resourceData[$vKey]['qr_code_image'] = $path;
                    // $resourceData[$vKey]['resource_type'] = $formattedResourceType;
                    $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                    $resourceData[$vKey]['visitor_status'] = $visitorStatus;
                    $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                    $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                    $resourceData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['resource_flat_already_added_data'] = array_key_exists($resource['resource_id'], $resourceFlatAlreadyDataWise) ? $resourceFlatAlreadyDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['visitor_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                        "share_qr_code_image" => $path,
                    );
                    $resourceData[$vKey]['share_data'] = $shareData;
                }
            }

            if ($isInsertUpdate == 0) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.this_visitor_is_already') . "Entered",
                    'data' => $resourceData
                ), 200);
            }
            if (isset($visitorData['success']) && $visitorData['success']) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.resource_entered_successfully'),
                    'data' => $resourceData
                ), 200);
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.resource_entered_unsuccessfully'),
                    'data' => $resourceData
                ), 400);
            }
        }
    }

    public function getResourceList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $resourceId = $this->request->getVar('resource_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        // $categoryId = $this->request->getVar('category_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        // $categoryName = $this->request->getVar('category_name');
        $isMyResource = $this->request->getVar('is_my_resource');
        $appType = $this->request->getVar('app_type');
        $resourceTypeId = $this->request->getVar('resource_type_id');

        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        // $this->validation->setRule('category_id', lang('CommonWebService.category_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if($appType != MANAGER_APP){
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                'society_id' => $societyId,
                'is_multiple' => 1,
                'is_helper' => 1,
                'is_active' => 1,
            ));
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);

            if(!empty($ownershipFlatMemberId)){
                $ownershipMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                ));
                $ownershipFlatId = $ownershipMemberFlatData['ownership_flat_id'];
            }
            else{
                $ownershipFlatId = 0;
            }
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                // 'category_id' => $categoryId,
                // 'category_name' => $categoryName,
                'society_id' => $societyId,
                'resource_id' => $resourceId,
                'user_society_id' => $userSocietyId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'ownership_flat_id' => $ownershipFlatId,
                'resource_type_id' => $resourceTypeId,
                // 'resource_type_array' => $resourceTypeArray,
                'is_deleted' => 0,
                'is_helper' => 1,
            );
            if (!empty($isMyResource)) {
                $resourceIdArray = array();
                $ownershipMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_show_all_member' => 1,
                    'is_active' => 1
                ));
                if (!empty($ownershipMemberFlatData)) {
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        'ownership_flat_id' => $ownershipMemberFlatData['ownership_flat_id'],
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        'is_multiple' => 1
                    ));
                }
                if (!empty($resourceFlatData)) {
                    foreach ($resourceFlatData as $resourceElement) {
                        $resourceIdArray[] = $resourceElement['resource_id'];
                    }
                }
                if (!empty($resourceIdArray)) {
                    $resourceData = $this->resourceModel->getResourceData(array(
                        'resource_id' => $resourceIdArray,
                        'ownership_flat_id' => $ownershipFlatId,
                        'start' => $start,
                        'search' => $search,
                        // 'category_id' => $categoryId,
                        // 'category_name' => $categoryName,
                        'resource_type_id' => $resourceTypeId,
                        'is_helper' => 1,
                        // 'resource_type_array' => $resourceTypeArray,
                        'is_multiple' => 1
                    ));
                }
            } else {
                $resourceData = $this->resourceModel->getResourceData($filterArray);
            }
            $objectFilterData = array(
                //'flat_id' => array('flat_id','tower_flat_name'),
                //'ownership_flat_member_id' => array('ownership_flat_member_id','name'),
                'resource_type_id' => array('resource_type_id', 'resource_type_name'),
                //'ownership_flat_parking_id' => array('ownership_flat_parking_id','parking_slot_no','number'),
            );
            $resourceFlatDataWise = array();
            $resourceFlatAlreadyDataWise = array();
            $resourceDocumentDataWise = array();
            $resourceWorkingDayDataWise = array();
            $resourceImageDataWise = array();
            $resourceIdArray = array();
            if (!empty($resourceData)) {
                foreach ($resourceData as $resourceElement) {
                    $resourceIdArray[] = $resourceElement['resource_id'];
                }
                if (!empty($resourceIdArray)) {
                    $resourceFlatAlreadyAddedData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatAlreadyAddedData)) {
                        foreach ($resourceFlatAlreadyAddedData as $resourceFlataddedElement) {
                            $resourceFlatAlreadyDataWise[$resourceFlataddedElement['resource_id']][] = $resourceFlataddedElement;
                        }
                    }
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlatElement) {
                            $resourceFlatDataWise[$resourceFlatElement['resource_id']][] = $resourceFlatElement;
                        }
                    }
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceIdArray,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $resourceImageElement) {
                            if ($resourceImageElement["document_image"] == '') {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                            }
                            $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                        }
                    }
                }
            }
            if (!empty($resourceData)) {
                foreach ($resourceData as $vKey => $resource) {
                    $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                    //                  if($resource['status'] == 'entered' || $resource['status'] == 'exited'){
                    //                      $endDate = isValidDate($resource['end_date']) ? $resource['end_date'] : date("Y-m-d H:i:s");
                    //                      $resourceData[$vKey]['difference_start_end_date'] = $this->calculateDateTimeDifference($resource['start_date'],$endDate);
                    //                  }

                    $resourceImagePath = site_url('uploads/no_image.png');
                    if ($resource['resource_image'] != '' && file_exists(DOCUMENT_IMAGE_PATH . $resource['resource_image'])) {
                        $resourceImagePath = site_url() . DOCUMENT_IMAGE_PATH . $resource['resource_image'];
                    }
                    $resourceData[$vKey]['resource_image'] = $resourceImagePath;
                    $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";

                    $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                    $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                    $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                    $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                    $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                    $path = '';
                    if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                        $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                    }
                    $resourceData[$vKey]['qr_code_image'] = $path;
                    // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                    // $resourceData[$vKey]['resource_type'] = $formattedResourceType;
                    //                  $path = site_url('uploads/no_image.png');
                    // if ($resource['id_proof'] != '' && file_exists(ID_PROOF_PATH . $resource['id_proof'])) {
                    //  $path = site_url() . ID_PROOF_PATH . $resource['id_proof'];
                    // }
                    // $resourceData[$vKey]['id_proof'] = $path;
                    $resourceData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['resource_flat_already_added_data'] = array_key_exists($resource['resource_id'], $resourceFlatAlreadyDataWise) ? $resourceFlatAlreadyDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['resource_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();

                    //                  if ($resource['ownership_flat_member_id'] == $userId) {
                    //                      $resourceData[$vKey]['is_added'] = 1;
                    //                  } else {
                    //                      $resourceData[$vKey]['is_added'] = 0;
                    //                  }
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                        "share_qr_code_image" => $path,
                    );
                    $resourceData[$vKey]['share_data'] = $shareData;
                }
            }
            if (!empty($resourceData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.resource_listing_successfully'),
                    'resource_type_data' => $resourceTypeData,
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'resource_type_data' => $resourceTypeData,
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getSosEmergencyList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $sosEmergencyId = $this->request->getVar('sos_emergency_id');
        $categoryId = $this->request->getVar('category_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'category_id' => $categoryId,
                'sos_emergency_id' => $sosEmergencyId,
                'society_id' => $societyId,
            );
            $sosEmergencyData = $this->sosModel->getSosEmergencyData($filterArray);
            $objectFilterData = array(
                'category_id' => array('category_id', 'category_name'),
                'status_id' => array('status_id', 'status_name', 'is_resolved'),
            );
            $sosEmergencyNotificationDataWise = array();
            $sosEmergencyRecordDataWise = array();
            $sosEmergencyIdArray = array();
            if (!empty($sosEmergencyData)) {
                foreach ($sosEmergencyData as $sosEmergencyElement) {
                    $sosEmergencyIdArray[] = $sosEmergencyElement['sos_emergency_id'];
                }
                if (!empty($sosEmergencyIdArray)) {
                    $sosEmergencyNotificationData = $this->sosModel->getSosEmergencyNotificationData(array(
                        "sos_emergency_id" => $sosEmergencyIdArray,
                        "is_multiple" => 1
                    ));
                    if (!empty($sosEmergencyNotificationData)) {
                        foreach ($sosEmergencyNotificationData as $sosEmergencyNotificationKey => &$sosEmergencyNotificationElement) {
                            $sosEmergencyNotificationData[$sosEmergencyNotificationKey]['sos_emergency_type_display'] = underscoreToUcWord($sosEmergencyNotificationElement["sos_emergency_type"]);
                            $sosEmergencyNotificationDataWise[$sosEmergencyNotificationElement['sos_emergency_id']][] = $sosEmergencyNotificationElement;
                        }
                    }
                    $sosEmergencyRecordData = $this->sosModel->getSosEmergencyRecordData(array(
                        "sos_emergency_id" => $sosEmergencyIdArray,
                        "is_multiple" => 1
                    ));
                    if (!empty($sosEmergencyRecordData)) {
                        foreach ($sosEmergencyRecordData as $sosEmergencyRecordElement) {
                            if ($sosEmergencyRecordElement["sos_record"] == '') {
                                $sosEmergencyRecordElement["sos_record"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $sosEmergencyRecordElement["sos_record"] = SITE_URL() . CATEGORY_IMAGE_PATH . $sosEmergencyRecordElement["sos_record"];
                            }
                            $sosEmergencyRecordDataWise[$sosEmergencyRecordElement['sos_emergency_id']][] = $sosEmergencyRecordElement;
                        }
                    }
                }
            }
            if (!empty($sosEmergencyData)) {
                foreach ($sosEmergencyData as $vKey => $sosEmergency) {
                    $sosEmergencyData[$vKey] = getModuleObjectData($objectFilterData, $sosEmergency);
                    $sosEmergencyData[$vKey]['created_at'] = isValidDate($sosEmergency['created_at']) ? YMDToDMY($sosEmergency["created_at"], true) : "";
                    $sosEmergencyData[$vKey]['updated_at'] = isValidDate($sosEmergency['updated_at']) ? YMDToDMY($sosEmergency["updated_at"], true) : "";
                    $sosEmergencyData[$vKey]['status_display'] = underscoreToUcWord($sosEmergency["status"]);
                    $sosEmergencyData[$vKey]['created_at_display'] = time_elapsed_string($sosEmergency['created_at']);
                    $sosEmergencyData[$vKey]['updated_at_display'] = time_elapsed_string($sosEmergency['updated_at']);
                    $sosEmergencyData[$vKey]['sos_emergency_notification_data'] = array_key_exists($sosEmergency['sos_emergency_id'], $sosEmergencyNotificationDataWise) ? $sosEmergencyNotificationDataWise[$sosEmergency['sos_emergency_id']] : array();
                    $sosEmergencyData[$vKey]['sos_emergency_record_data'] = array_key_exists($sosEmergency['sos_emergency_id'], $sosEmergencyRecordDataWise) ? $sosEmergencyRecordDataWise[$sosEmergency['sos_emergency_id']] : array();
                    if ($sosEmergency["category_image"] == '') {
                        $sosEmergencyData[$vKey]["category_image"] = SITE_URL('uploads/no_image.png');
                        $sosEmergencyData[$vKey]["sos_image"] = SITE_URL('uploads/no_image.png');
                        $sosEmergencyData[$vKey]["thumbnail_category_image"] = SITE_URL('uploads/no_image.png');
                        $sosEmergencyData[$vKey]["thumbnail_sos_image"] = SITE_URL('uploads/no_image.png');
                    } else {
                        $sosEmergencyData[$vKey]["thumbnail_category_image"] = SITE_URL() . THUMBNAIL_CATEGORY_IMAGE_PATH . $sosEmergency["category_image"];
                        $sosEmergencyData[$vKey]["thumbnail_sos_image"] = SITE_URL() . THUMBNAIL_CATEGORY_IMAGE_PATH . $sosEmergency["category_image"];
                        $sosEmergencyData[$vKey]["category_image"] = SITE_URL() . CATEGORY_IMAGE_PATH . $sosEmergency["category_image"];
                        $sosEmergencyData[$vKey]["sos_image"] = SITE_URL() . CATEGORY_IMAGE_PATH . $sosEmergency["category_image"];
                    }
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $sosEmergencyData[$vKey]['share_data'] = $shareData;
                }
            }
            if (!empty($sosEmergencyData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.sos_emergency_listing_successfully'),
                    'sos_type_list' => sosTypeAPI(),
                    'data' => $sosEmergencyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'sos_type_list' => sosTypeAPI(),
                    'data' => $sosEmergencyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }


    public function getSosEmergencyNotificationList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $type = $this->request->getVar('type');
        $typeId = $this->request->getVar('type_id');

        $userSocietyId = $this->request->getVar('user_society_id');
        $appType = $this->request->getVar('app_type');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if($appType == MEMBER_APP){
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'search' => $search,
                'type' => $type,
                'type_id' => $typeId,
                'society_id' => $societyId,
            );
            $getNotificationData = $this->notificationModel->getNotificationData($filterArray);


            if (!empty($getNotificationData)) {
                foreach ($getNotificationData as $nKey => $getNotificationElement) {

                    $getNotificationData[$nKey]['created_at'] = isValidDate($getNotificationElement['created_at']) ? YMDToDMY($getNotificationElement["created_at"], true) : "";
                    $getNotificationData[$nKey]['updated_at'] = isValidDate($getNotificationElement['updated_at']) ? YMDToDMY($getNotificationElement["updated_at"], true) : "";

                    $getNotificationData[$nKey]['created_at_display'] = time_elapsed_string($getNotificationElement['created_at']);
                    $getNotificationData[$nKey]['updated_at_display'] = time_elapsed_string($getNotificationElement['updated_at']);
                    $getNotificationData[$nKey]['action_type_display'] = underscoreToUcWord($getNotificationElement['action_type']);

                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $getNotificationData[$nKey]['share_data'] = $shareData;
                }
            }
            if (!empty($getNotificationData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.sos_emergency_notification_listing_successfully'),
                    'data' => $getNotificationData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $getNotificationData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }
    
    public function acceptRejectNotification()
    {
        $notificationId = $this->request->getVar('notification_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $actionType = $this->request->getVar('action_type');
        $appType = $this->request->getVar('app_type');

        $this->validation->setRule('notification_id', lang('CommonWebService.notification_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        $this->validation->setRule('action_type', lang('CommonWebService.action_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $notificationData = $this->notificationModel->getNotificationData(array(
                'notification_id' => $notificationId,
            ));
            if(strtolower($notificationData['action_type']) != 'sent'){
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.sos_status_already_updated') . underscoreToUcWord($notificationData['action_type']),
                    'data' => null
                ), 404);
            }
            $notificationUpdateArray = array(
                'notification_id' => $notificationId,
                'action_type' => $actionType,
                'is_action_perform' => 1,
            );
            $notificationUpdateData = $this->commonWebserviceModel->insertUpdateRecord($notificationUpdateArray, 'notification_id', 'tbl_notification', 1, '', array());

            if (isset($notificationUpdateData['success']) && $notificationUpdateData['success']) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => "Notification ". underscoreToUcWord($actionType) . " Successfully",
                    'data' => null
                ), 200);
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.notification')),
                    'data' => null
                ), 404);
            }

        }
    }

    public function getResourceGateKeeperList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $resourceId = $this->request->getVar('resource_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        // $categoryId = $this->request->getVar('category_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        // $categoryName = $this->request->getVar('category_name');
        $status = $this->request->getVar('filtered_status');
        $isTodayExitVisitor = $this->request->getVar('is_today_exit_visitor');
        $isTodayEnterVisitor = $this->request->getVar('is_today_enter_visitor');
        $resourceTypeId = $this->request->getVar('resource_type_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        // $this->validation->setRule('category_id', lang('CommonWebService.category_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                'society_id' => $societyId,
                'is_multiple' => 1,
                'is_helper' => 1,
                'is_active' => 1,
            ));

            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);

            $resourceTypes = resourceType();
            $resourceTypeArray = [];
            foreach ($resourceTypes as $resource) {
                if (isset($resource['is_login']) && $resource['is_login'] == 0) {
                    $resourceTypeArray[] = $resource['name'];
                }
            }
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                // 'resource_type_array' => $resourceTypeArray,
                'society_id' => $societyId,
                'resource_id' => $resourceId,
                'user_society_id' => $userSocietyId,
                'status' => $status,
                'resource_type_id' => $resourceTypeId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'is_deleted' => 0,
                'is_today_exit_visitor' => $isTodayExitVisitor,
                'is_today_enter_visitor' => $isTodayEnterVisitor,
                'is_helper' => 1,
            );
            $resourceData = $this->resourceModel->getResourceData($filterArray);
            // printArray($resourceData,1);
            $objectFilterData = array(
                //'flat_id' => array('flat_id','tower_flat_name'),
                //'ownership_flat_member_id' => array('ownership_flat_member_id','name'),
                'resource_type_id' => array('resource_type_id', 'resource_type_name'),
                //'ownership_flat_parking_id' => array('ownership_flat_parking_id','parking_slot_no','number'),
            );
            $resourceFlatDataWise = array();
            $resourceFlatAlreadyDataWise = array();
            $resourceDocumentDataWise = array();
            $resourceWorkingDayDataWise = array();
            $resourceIdArray = array();
            if (!empty($resourceData)) {
                foreach ($resourceData as $resourceElement) {
                    $resourceIdArray[] = $resourceElement['resource_id'];
                }
                if (!empty($resourceIdArray)) {
                    $resourceFlatAlreadyAddedData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatAlreadyAddedData)) {
                        foreach ($resourceFlatAlreadyAddedData as $resourceFlataddedElement) {
                            $resourceFlatAlreadyDataWise[$resourceFlataddedElement['resource_id']][] = $resourceFlataddedElement;
                        }
                    }
                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        'is_deleted' => 0,
                        'is_helper' => 1,
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlatElement) {
                            $resourceFlatDataWise[$resourceFlatElement['resource_id']][] = $resourceFlatElement;
                        }
                    }
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceIdArray,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $resourceImageElement) {
                            if ($resourceImageElement["document_image"] == '') {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                            }
                            $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                        }
                    }
                }
            }
            if (!empty($resourceData)) {
                foreach ($resourceData as $vKey => $resource) {
                    $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                    $endDateStatus = isValidDate($resource['end_date']) ? date('Y-m-d', strtotime($resource['end_date'])) : '';
                    if ($resource['visitor_status'] == 'exited' && $endDateStatus != TODAY_DATE_YMD) {
                        $status = 'approved';
                        $visitorStatus = 'approved';
                    } else {
                        $status = $resource['visitor_status'];
                        $visitorStatus = $resource['visitor_status'];
                    }
                    $startDate = isValidDate($resource['start_date']) ? $resource['start_date'] : date("Y-m-d H:i:s");
                    $endDate = isValidDate($resource['end_date']) ? $resource['end_date'] : date("Y-m-d H:i:s");
                    $resourceData[$vKey]['difference_start_end_date'] = calculateDateTimeDifference($startDate, $endDate);
                    $resourceData[$vKey]["start_date_time_display"] = date('d M, Y h:i A', strtotime($startDate));
                    $resourceData[$vKey]["end_date_time_display"] = date('d M, Y h:i A', strtotime($endDate));
                    $resourceData[$vKey]["start_date_display"] = date('d M, Y', strtotime($startDate));
                    $resourceData[$vKey]["end_date_display"] = date('d M, Y', strtotime($endDate));
                    $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                    // $resourceData[$vKey]["status"] = (isset($resource['status']) && $resource['status'] === 'approved') ? 'Not Arrived Yet' : $status;
                    $resourceData[$vKey]["visitor_status_display"] = (isset($resource['visitor_status']) && !empty($resource['visitor_status'])) ? underscoreToUcWord($status) : 'approved';
                    $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                    $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                    $path = '';
                    if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                        $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                    }
                    $resourceData[$vKey]['visitor_status'] = $visitorStatus;
                    $resourceData[$vKey]['qr_code_image'] = $path;
                    // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                    // $resourceData[$vKey]['resource_type'] = $formattedResourceType;
                    $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                    $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                    $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                    $resourceData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['resource_flat_already_added_data'] = array_key_exists($resource['resource_id'], $resourceFlatAlreadyDataWise) ? $resourceFlatAlreadyDataWise[$resource['resource_id']] : array();
                    $resourceData[$vKey]['visitor_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                        "share_qr_code_image" => $path,
                    );
                    $resourceData[$vKey]['share_data'] = $shareData;
                }
            }
            if (!empty($resourceData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.resource_listing_successfully'),
                    'resource_type_data' => $resourceTypeData,
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'resource_type_data' => $resourceTypeData,
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getResourceDetailList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $resourceId = $this->request->getVar('resource_id');
        $resourceTypeId = $this->request->getVar('resource_type_id');
        // $categoryId = $this->request->getVar('category_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('resource_id', lang('CommonWebService.resource_id'), 'required');
        // $this->validation->setRule('category_id', lang('CommonWebService.category_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'resource_type_id' => $resourceTypeId,
                // 'category_id' => $categoryId,
                'society_id' => $societyId,
                'resource_id' => $resourceId,
                'is_helper' => 1,
                'is_deleted' => 0,
            );
            $resourceData = $this->resourceModel->getResourceData($filterArray);
            $objectFilterData = array(
                //'flat_id' => array('flat_id','tower_flat_name'),
                //'ownership_flat_member_id' => array('ownership_flat_member_id','name'),
                'resource_type_id' => array('resource_type_id', 'resource_type_name'),
                //'ownership_flat_parking_id' => array('ownership_flat_parking_id','parking_slot_no','number'),
            );
            $resourceDocumentDataWise = array();
            $resourceWorkingDayDataWise = array();
            $resourceAttendanceDataWise = array();
            $resourceFlatDataWise = array();
            $resourceFlatDataWise = array();
            $resourceIdArray = array();
            // $categoryIdArray = array();
            $resourceNameArray = array();
            $resourceTypeArray = array();
            $totalFlatCount = 0;
            $durationInMinutes = 0;
            $lastAttendanceChecked = 0;
            $maxDuration = -1;
            $maxAttendanceDuration = -1;
            $longestDurationResource = '';
            $longestAttendanceDuration = '';
            if (!empty($resourceData)) {
                foreach ($resourceData as $resourceElement) {
                    $resourceIdArray[] = $resourceElement['resource_id'];
                    $resourceNameArray[] = $resourceElement['resource_name'];
                    $resourceTypeArray[] = $resourceElement['resource_type_id'];
                }
                if (!empty($resourceIdArray)) {
                    $resourceAttendanceData = $this->visitorModel->getVisitorResourceAttendanceData(array(
                        "resource_id" => $resourceIdArray,
                        'is_deleted' => 0,
                        "is_multiple" => 1
                    ));

                    if (!empty($resourceAttendanceData)) {
                        foreach ($resourceAttendanceData as $resourceAttendanceElement) {
                            $resourceAttendanceElement['current_month_days'] = date("t", mktime(0, 0, 0, date("n"), 1, date("Y")));
                            $resourceAttendanceElement['last_attendance_year'] = time_elapsed_string($resourceAttendanceElement['created_at']);
                            $lastAttendanceChecked = convertDurationToMinute($resourceAttendanceElement['last_attendance_year']);

                            if ($lastAttendanceChecked > $maxAttendanceDuration) {
                                $maxAttendanceDuration = $lastAttendanceChecked;
                                $longestAttendanceDuration = $resourceAttendanceElement['last_attendance_year'];
                            }
                            $resourceAttendanceDataWise[$resourceAttendanceElement['resource_id']][] = $resourceAttendanceElement;
                        }
                    }

                    $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                        "resource_id" => $resourceIdArray,
                        //"category_id" => $categoryIdArray,
                        "resource_type_id" => $resourceTypeArray,
                        "is_multiple" => 1,
                        'is_helper' => 1,
                        'is_deleted' => 0,
                    ));
                    if (!empty($resourceFlatData)) {
                        foreach ($resourceFlatData as $resourceFlatElement) {
                            $totalFlatCount++;
                            $resourceFlatElement['flat_work_duration_year'] = time_elapsed_string($resourceFlatElement['created_at']);
                            $durationInMinutes = convertDurationToMinute($resourceFlatElement['flat_work_duration_year']);
                            // Track the maximum duration and corresponding resource
                            if ($durationInMinutes > $maxDuration) {
                                $maxDuration = $durationInMinutes;
                                $longestDurationResource = $resourceFlatElement['flat_work_duration_year'];
                            }
                            $resourceFlatDataWise[$resourceFlatElement['resource_type_id']][] = $resourceFlatElement;
                        }
                    }
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $resourceIdArray,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $resourceImageElement) {
                            if ($resourceImageElement["document_image"] == '') {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                            }
                            $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                        }
                    }
                }
            }
            if (!empty($resourceData)) {
                foreach ($resourceData as $vKey => $resource) {
                    $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                    $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                    $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                    $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                    $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                    $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                    $resourceData[$vKey]['gender_display'] = underscoreToUcWord($resource["gender"]);
                    $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                    $path = '';
                    if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                        $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                    }
                    $resourceData[$vKey]['qr_code_image'] = $path;
                    // $formattedResourceType = getResourceKeyValue($resource['resource_type']);
                    // $resourceData[$vKey]['resource_type'] = $formattedResourceType;
                    $resourceData[$vKey]['work_in_total_house'] = $totalFlatCount;
                    $resourceData[$vKey]['work_in_house_year'] = $longestDurationResource;
                    $resourceData[$vKey]['last_attendance_checked'] = $longestAttendanceDuration;
                    $resourceData[$vKey]['resource_attendance_data'] = array_key_exists($resource['resource_id'], $resourceAttendanceDataWise) ? $resourceAttendanceDataWise[$resource['resource_id']] : array();
                    $resourceImagePath = site_url('uploads/no_image.png');
                    if ($resource['resource_image'] != '' && file_exists(DOCUMENT_IMAGE_PATH . $resource['resource_image'])) {
                        $resourceImagePath = site_url() . DOCUMENT_IMAGE_PATH . $resource['resource_image'];
                    }
                    $resourceData[$vKey]['resource_image'] = $resourceImagePath;
                    $resourceData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_type_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_type_id']] : array();
                    $resourceData[$vKey]['resource_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                    //$resourceData[$vKey]['resource_working_day_data'] = array_key_exists($resource['resource_id'],$resourceWorkingDayDataWise) ? $resourceWorkingDayDataWise[$resource['resource_id']]: array();
                    $resourceData[$vKey]['resource_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                        "share_qr_code_image" => $path,
                    );
                    $resourceData[$vKey]['share_data'] = $shareData;
                }
            }
            if (!empty($resourceData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.resource_listing_successfully'),
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $resourceData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }
    public function getTowerList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $towerId = $this->request->getVar('tower_id');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'tower_id' => $towerId,
                'society_id' => $societyId,
                'is_active' => 1,
            );
            $towerData = $this->towerModel->getTowerData($filterArray);
            if (isset($towerId) && count($towerId) == 1) {
                $towerData = isset($towerData[0]) ? $towerData[0] : array();
            }
            if (!empty($towerData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.tower_listing_successfully'),
                    'data' => $towerData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $towerData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getOwnershipFlatList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $towerId = $this->request->getVar('tower_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        //  $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            //$start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);

            $legendsData = array(
                array(
                    'type' => 'ownership_flat',
                    'name' => 'Ownership Flat',
                    'color_code' => FLAT_OWNER_COLOR_CODE,
                ),
                array(
                    'type' => 'rentals',
                    'name' => 'Rentals',
                    'color_code' => VISITOR_COLOR_CODE,
                ),
            );

            $legendsDataIdWise = array();
            if (!empty($legendsData)) {
                foreach ($legendsData as $legendsElement) {
                    $legendsDataIdWise[$legendsElement['type']] = $legendsElement;
                }
            }
            // printArray($legendsDataIdWise,1);
            $ownershipFlatMemberIdArray = array();
            $flatFilterArray = array(
                'is_multiple' => 1,
                'society_id' => $societyId,
                'is_active' => 1,
                'is_latest' => 1,
                //'check_flat_rent' => 1
            );

            $getOwnerFlatData = $this->ownershipFlatModel->getOwnershipFlatNotRentalsData($flatFilterArray);

            if (!empty($getOwnerFlatData)) {
                foreach ($getOwnerFlatData as $getOwnerFlatElement) {
                    array_push($ownershipFlatMemberIdArray, $getOwnerFlatElement['ownership_flat_member_id']);
                }
            }

            $rentFlatFilterArray = array(
                'is_multiple' => 1,
                'society_id' => $societyId,
                'is_active' => 1,
                'check_flat_rent' => 1
            );
            $getRentalsFlatData = $this->ownershipFlatModel->getRentalsFlatData($rentFlatFilterArray);
            if (!empty($getRentalsFlatData)) {
                foreach ($getRentalsFlatData as $geRentalsFlatElement) {
                    array_push($ownershipFlatMemberIdArray, $geRentalsFlatElement['ownership_flat_member_id']);
                }
            }

            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                'is_show_all_member' => 1,
                'is_multiple' => 1,
            ));

            $filteredData = [];
            $rentalIds = [];
            foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                if ($ownershipFlatMember['type'] === 'rentals') {
                    $rentalIds[] = $ownershipFlatMember['ownership_flat_id'];
                }
            }
            foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                if ( ($ownershipFlatMember['type'] === 'ownership_flat' && in_array($ownershipFlatMember['ownership_flat_id'], $rentalIds)) || 
                    $ownershipFlatMember['is_owner'] === 0 ) 
                {
                    continue; // Skip this entry
                }
                $filteredData[] = $ownershipFlatMember; // Keep other entries
            }
            $ownershipFlatMemberIdNewArray = array();
            $ownershipFlatMemberData = $filteredData;
            if(!empty($ownershipFlatMemberData)){
                foreach($ownershipFlatMemberData as $ownershipFlatMemberList){
                    $ownershipFlatMemberIdNewArray[] = $ownershipFlatMemberList['ownership_flat_member_id'];
                }
            }
            // printArray($ownershipFlatMemberIdNewArray,1);
            $filterArray = array(
                'is_multiple' => 1,
                //  'start' => $start,
                'search' => $search,
                'tower_id' => $towerId,
                'ownership_flat_id' => $ownershipFlatId,
                'ownership_flat_member_id' => $ownershipFlatMemberIdNewArray,
                'society_id' => $societyId,
                'is_active' => 1,
                'is_latest' => 1,
                // 'is_owner' => 1,
            );
            $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatApiData($filterArray);
            // printArray($ownershipFlatData,1);
            if (!empty($ownershipFlatData)) {
                foreach ($ownershipFlatData as $vKey => $ownershipFlat) {
                    $ownershipFlatData[$vKey]['color_code'] = array_key_exists($ownershipFlat['type'], $legendsDataIdWise) ? $legendsDataIdWise[$ownershipFlat['type']]['color_code'] : '';
                    $ownershipFlatData[$vKey]['created_at'] = isValidDate($ownershipFlat['created_at']) ? YMDToDMY($ownershipFlat["created_at"], true) : "";
                    $ownershipFlatData[$vKey]['updated_at'] = isValidDate($ownershipFlat['updated_at']) ? YMDToDMY($ownershipFlat["updated_at"], true) : "";
                    $ownershipFlatData[$vKey]['created_at_display'] = time_elapsed_string($ownershipFlat['created_at']);
                    $ownershipFlatData[$vKey]['updated_at_display'] = time_elapsed_string($ownershipFlat['updated_at']);

                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($ownershipFlat['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $ownershipFlat['member_image'])) {
                        $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $ownershipFlat['member_image'];
                    }
                    if ($ownershipFlat['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlat['member_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlat['member_image'];
                    }
                    $ownershipFlatData[$vKey]['thumbnail_member_image'] = $thumbnailPath;
                    $ownershipFlatData[$vKey]['member_image'] = $path;

                }
            }
            $unitGroupResult = [];
            if (!empty($ownershipFlatData)) {
                foreach ($ownershipFlatData as $ownershipFlatElement) {
                    $unitGroup = $ownershipFlatElement['unit_group'];
                    if (!isset($unitGroupResult[$unitGroup])) {
                        $unitGroupResult[$unitGroup] = [
                            'floor' => $unitGroup,
                            'ownership_flat_data' => []
                        ];
                    }
                    $unitGroupResult[$unitGroup]['ownership_flat_data'][] = $ownershipFlatElement;
                }
            }
            // Convert the associative array to a numerical array
            $unitGroupResult = array_values($unitGroupResult);
            $ownershipFlatData = $unitGroupResult;
            if (!empty($ownershipFlatData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.ownership_flat_listing_successfully'),
                    "legends" => $legendsData,
                    'data' => $ownershipFlatData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    "legends" => $legendsData,
                    'data' => $ownershipFlatData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getOwnershipFlatMemberList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $flatId = $this->request->getVar('flat_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $type = $this->request->getVar('type');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                //'ownership_flat_member_id' => $ownershipFlatMemberId,
                'ownership_flat_id' => $ownershipFlatId,
                'flat_id' => $flatId,
                'is_show_all_member' => 1,
                'society_id' => $societyId,
                'type' => $type,
                'is_active' => 1,
            );
            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData($filterArray);
            if (!empty($ownershipFlatMemberData)) {
                $filteredOwnershipFlatMemberData = []; // New array to hold filtered data

                foreach ($ownershipFlatMemberData as $vKey => $ownershipFlatMemberElement) {
                    if ($ownershipFlatMemberElement['type'] == 'rentals') {
                        $rentalsData = $this->rentalModel->getRentalsMemberData(array(
                            'rentals_id' => $ownershipFlatMemberElement['type_id'],
                            'check_rental_start' => 1,
                        ));

                        // printArray($rentalsData,1);

                        // If rentalsData is not empty, add the element to the filtered array
                        if (!empty($rentalsData)) {
                            $filteredOwnershipFlatMemberData[] = $ownershipFlatMemberElement;
                        }
                    } else {
                        // If the type is not rentals, keep the element as is
                        $filteredOwnershipFlatMemberData[] = $ownershipFlatMemberElement;
                    }
                }

                // Update ownershipFlatMemberData with filtered results
                $ownershipFlatMemberData = $filteredOwnershipFlatMemberData;
            }
//          lastQuery();
            if (!empty($ownershipFlatMemberData)) {
                foreach ($ownershipFlatMemberData as $vKey => $ownershipFlatMemberElement) {
                    if (IS_SHOW_MOBILE_NO == 1) {
                        $lastFourDigits = substr($ownershipFlatMemberElement['mobile_no'], -4);
                        $phoneLength = strlen($ownershipFlatMemberElement['mobile_no']);
                        // $ownershipFlatMemberData[$vKey]['mobile_no'] = str_repeat('✕', $phoneLength - 4) . $lastFourDigits;
                        $repeatCount = $phoneLength - 4;
                        if ($repeatCount < 0) {
                            $repeatCount = 0;
                        }
                        $ownershipFlatMemberData[$vKey]['mobile_no'] = str_repeat('✕', $repeatCount) . $lastFourDigits;
                    }
                    $ownershipFlatMemberData[$vKey]['relation'] = underscoreToUcWord($ownershipFlatMemberElement['relation']);
                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($ownershipFlatMemberElement['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberElement['member_image'])) {
                        $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberElement['member_image'];
                    }
                    if ($ownershipFlatMemberElement['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberElement['member_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberElement['member_image'];
                    }
                    $ownershipFlatMemberData[$vKey]['thumbnail_member_image'] = $thumbnailPath;
                    $ownershipFlatMemberData[$vKey]['member_image'] = $path;
                }
            }

//          if(isset($ownershipFlatMemberId) && !empty($ownershipFlatMemberId)){
//              $ownershipFlatMemberData = isset($ownershipFlatMemberData[0]) ? $ownershipFlatMemberData[0] : array();
//          }
            if (!empty($ownershipFlatMemberData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.ownership_flat_member_listing_successfully'),
                    'data' => $ownershipFlatMemberData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $ownershipFlatMemberData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function checkVersion()
    {
        $versionCode = $this->request->getVar('version_code');
        $platform = $this->request->getVar('platform');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('version_code', lang('CommonWebService.version_code'), 'required');
        $this->validation->setRule('platform', lang('CommonWebService.platform'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        }
        $appVersion = $this->commonWebserviceModel->getAppVersionData(array(
            'platform' => $platform,
            'app_type' => $appType,
        ));
        if (!empty($appVersion)) {
            if ($versionCode == $appVersion['version_code']) {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_updated_version'),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } elseif ($versionCode < $appVersion['version_code']) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.version_list_successfully'),
                    'data' => $appVersion,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_updated_version'),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            }
        } else {
            $data = array(
                'status' => false,
                'message' => lang('CommonWebService.no_updated_version'),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 200,
            );
            return $this->response($data, 200);
        }
    }

    public function getOwnershipFlatParkingList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $parkingSlotId = $this->request->getVar('parking_slot_id');
        $parkingAreaId = $this->request->getVar('parking_area_id');
        $societyId = $this->request->getVar('society_id');
        $vehicleType = $this->request->getVar('vehicle_type');
        $isVisitorParking = $this->request->getVar('is_visitor_parking');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $legendsData = array(
                array(
                    'id' => 'flat_owner',
                    'name' => 'Flat',
                    'color_code' => FLAT_OWNER_COLOR_CODE,
                ),
                array(
                    'id' => 'visitor',
                    'name' => 'Visitor',
                    'color_code' => VISITOR_COLOR_CODE,
                ),
                array(
                    'id' => 'free_slot',
                    'name' => 'Free Slot',
                    'color_code' => FREE_SLOT_COLOR_CODE,
                )
            );

            $legendsDataIdWise = array();
            if (!empty($legendsData)) {
                foreach ($legendsData as $legendsElement) {
                    $legendsDataIdWise[$legendsElement['id']] = $legendsElement;
                }
            }

            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'ownership_flat_parking_id' => $ownershipFlatParkingId,
                'ownership_flat_id' => $ownershipFlatId,
                'parking_slot_id' => $parkingSlotId,
                'vehicle_type' => $vehicleType,
                'society_id' => $societyId,
                'is_active' => 1,
            );
//          $parkingPlaceData = $this->parkingPlaceModel->getParkingPlaceData(array(
//              'is_active' => 1,
//              'society_id' => $societyId,
//              'is_multiple' => 1,
//          ));
            $parkingVehicleDataWise = array();
            $parkingAreaData = $this->parkingAreaModel->getParkingAreaData(array(
                'is_active' => 1,
                'society_id' => $societyId,
                'vehicle_type' => $vehicleType,
                'is_multiple' => 1,
                'start' => -1
            ));
            if (!empty($parkingAreaData)) {
                foreach ($parkingAreaData as $parkingAreaElement) {
                    $parkingAreaIdArray[] = $parkingAreaElement['parking_area_id'];
                }

                if(!empty($parkingAreaIdArray)){
                    $parkingVehicleData = $this->parkingAreaModel->getParkingVehicleData(array(
                        "parking_area_id" => $parkingAreaIdArray,
                        'vehicle_type' => $vehicleType,
                        "is_multiple" => 1
                    ));
                    if(!empty($parkingVehicleData)) {
                        foreach ($parkingVehicleData as $parkingVehicleElement) {
                            $parkingVehicleDataWise[$parkingVehicleElement['parking_area_id']][] = $parkingVehicleElement;
                        }
                    }
                    
                }
            }
            if (!empty($parkingAreaData)) {
                foreach ($parkingAreaData as $pKey => $parkingArea) {
                    $parkingAreaData[$pKey]['parking_vehicle_data'] = array_key_exists($parkingArea['parking_area_id'],$parkingVehicleDataWise) ? $parkingVehicleDataWise[$parkingArea['parking_area_id']]: array();
                }
            }
            // lastQuery();
            $availableParkingData = $this->parkingSlotModel->getParkingSlotData(array(
                'is_available_flat' => 1,
                'society_id' => $societyId,
                //'is_visitor_parking' => $isVisitorParking,
                'is_visitor_parking' => 1,
                'is_flat_owner' => 1,
                'is_available_visitor_approval_pending' => 1,
                'vehicle_type' => $vehicleType,
                'parking_area_id' => $parkingAreaId,
                'is_multiple' => 1,
                'search' => $search,
                'start' => -1
            ));

            if (!empty($availableParkingData)) {
                foreach ($availableParkingData as $key => $availableParkingElement) {
                    $availableParkingData[$key]['color_code'] = array_key_exists('free_slot', $legendsDataIdWise) ? $legendsDataIdWise['free_slot']['color_code'] : '';
                }
            }
            if (!empty($availableParkingData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.ownership_flat_parking_listing_successfully'),
                    'parking_slot_data' => $parkingAreaData,
                    'data' => $availableParkingData,
                    'limit' => DATA_LIMIT,
                    "legends" => $legendsData,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'parking_slot_data' => $parkingAreaData,
                    'data' => $availableParkingData,
                    'limit' => DATA_LIMIT,
                    "legends" => $legendsData,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }


    public function getParkingList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $parkingSlotId = $this->request->getVar('parking_slot_id');
        $parkingAreaId = $this->request->getVar('parking_area_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $flatId = $this->request->getVar('flat_id');
        //$this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $legendsData = array(
                array(
                    'id' => 'flat_owner',
                    'name' => 'Flat',
                    'color_code' => FLAT_OWNER_COLOR_CODE,
                ),
                array(
                    'id' => 'visitor',
                    'name' => 'Visitor',
                    'color_code' => VISITOR_COLOR_CODE,
                ),
                array(
                    'id' => 'free_slot',
                    'name' => 'Free Slot',
                    'color_code' => FREE_SLOT_COLOR_CODE,
                )
            );

            $legendsDataIdWise = array();
            if (!empty($legendsData)) {
                foreach ($legendsData as $legendsElement) {
                    $legendsDataIdWise[$legendsElement['id']] = $legendsElement;
                }
            }
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                //'start' => $start,
                'search' => $search,
                'parking_slot_id' => $parkingSlotId,
                'society_id' => $societyId,
                'is_active' => 1,
            );

            $parkingAreaData = $this->parkingAreaModel->getParkingAreaData(array(
                'is_active' => 1,
                'society_id' => $societyId,
                'is_multiple' => 1,
            ));
            if (!empty($parkingAreaData)) {
                foreach ($parkingAreaData as $parkingAreaElement) {
                    $parkingAreaIdArray[] = $parkingAreaElement['parking_area_id'];
                }

                if(!empty($parkingAreaIdArray)){
                    $parkingVehicleData = $this->parkingAreaModel->getParkingVehicleData(array(
                        "parking_area_id" => $parkingAreaIdArray,
                        "is_multiple" => 1
                    ));
                    if(!empty($parkingVehicleData)) {
                        foreach ($parkingVehicleData as $parkingVehicleElement) {
                            $parkingVehicleDataWise[$parkingVehicleElement['parking_area_id']][] = $parkingVehicleElement;
                        }
                    }
                    
                }
            }
            if (!empty($parkingAreaData)) {
                foreach ($parkingAreaData as $pKey => $parkingArea) {
                    $parkingAreaData[$pKey]['parking_vehicle_data'] = array_key_exists($parkingArea['parking_area_id'],$parkingVehicleDataWise) ? $parkingVehicleDataWise[$parkingArea['parking_area_id']]: array();
                }
            }

            $allOwnerParkingData = $this->parkingSlotModel->getAllOwnerParkingData(array(
                'society_id' => $societyId,
                'parking_area_id' => $parkingAreaId,
                'flat_id' => $flatId,
                //'start' => $start,
                'search' => $search,
                'is_multiple' => 1,
            ));
            // 

            // if (!empty($allOwnerParkingData)) {
            //     $filteredOwnershipFlatMemberData = [];
            //     foreach ($allOwnerParkingData as $vKey => $allOwnerParkingData) {
            //         if ($allOwnerParkingData['type'] == 'rentals') {
            //             $rentalsData = $this->rentalModel->getRentalsMemberData(array(
            //                 'rentals_id' => $allOwnerParkingData['type_id'],
            //                 'check_rental_start' => 1,
            //             ));
            //             if (!empty($rentalsData)) {
            //                 $filteredOwnershipFlatMemberData[] = $allOwnerParkingData;
            //             }
            //         } else {
            //             $filteredOwnershipFlatMemberData[] = $allOwnerParkingData;
            //         }
            //     }
            //     $allOwnerParkingData = $filteredOwnershipFlatMemberData;
            // }
            $objectFilterData = array(
                'parking_slot_id' => array('parking_slot_id', 'number', 'display_block', 'parking_block_display'),
                'flat_id' => array('flat_id', 'flat_no'),
            );

            if (!empty($allOwnerParkingData)) {
                foreach ($allOwnerParkingData as $aoKey => $allOwnerParkingElement) {
                    $allOwnerParkingData[$aoKey] = getModuleObjectData($objectFilterData, $allOwnerParkingElement);
                    $allOwnerParkingData[$aoKey]['color_code'] = array_key_exists($allOwnerParkingElement['allocated_parking'], $legendsDataIdWise) ? $legendsDataIdWise[$allOwnerParkingElement['allocated_parking']]['color_code'] : '';
                }
            }

            if (!empty($allVisitorParkingData)) {
                foreach ($allVisitorParkingData as $avKey => $allVisitorParkingElement) {
                    $allVisitorParkingData[$avKey] = getModuleObjectData($objectFilterData, $allVisitorParkingElement);
                }
            }

            if (!empty($allOwnerParkingData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.parking_listing_successfully'),
                    'data' => $allOwnerParkingData,
                    //'visitor_data' => $allVisitorParkingData,
                    'parking_slot_data' => $parkingAreaData,
                    'limit' => DATA_LIMIT,
                    "legends" => $legendsData,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $allOwnerParkingData,
                    //'visitor_data' => $allVisitorParkingData,
                    'parking_slot_data' => $parkingAreaData,
                    'limit' => DATA_LIMIT,
                    "legends" => $legendsData,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getStaticDropdownList()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $sosTypeArray = sosTypeAPI();

            if ($appType === GATE_KEEPER) {
                foreach ($sosTypeArray as $index => $item) {
                    if ($item['key'] === 'family') {
                        unset($sosTypeArray[$index]);
                    }
                }
            }
            $sosTypeArray = array_values($sosTypeArray);

            $staticTypeAsArray = array(
                'sos' => $sosTypeArray,
                'week_days' => weekDays(),
                'complain_type' => complainTypeApi(),
                'food_like' => foodLikeApi(),
                'vehicle_type' => vehicleTypeApi(),
                'blood_group_type' => bloodGroupTypeAPI(),
                'relation' => relationAPI(),
                'source' => sourceAPI(),
                'reading_type' => readingTypeAPI(),
            );
            // if (!empty($staticDropdownType) && $search != '' ) {
            //     foreach ($staticDropdownType as $staticDropdownTypeElement){
            //         if(strpos(strtolower($staticDropdownTypeElement['value']),strtolower($search)) !== false){
            //             $tempObjArray = array();
            //             $tempObjArray[$type] = $staticDropdownTypeElement['key'];
            //             $tempObjArray['display_'.$type] = $staticDropdownTypeElement['value'];
            //             array_push($staticTypeAsArray,$tempObjArray);
            //         }
            //     }
            // }else {
            //     foreach ($staticDropdownType as $staticDropdownTypeElement){
            //         $tempObjArray = array();
            //         $tempObjArray[$type] = $staticDropdownTypeElement['key'];
            //         $tempObjArray['display_'.$type] = $staticDropdownTypeElement['value'];
            //         array_push($staticTypeAsArray,$tempObjArray);
            //     }
            // }
            if (!empty($staticTypeAsArray)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.dropdown_listing_successfully'),
                    'data' => $staticTypeAsArray,
                    'response_code' => 200,
                );
                //return $this->respond($data,200);
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $staticTypeAsArray,
                    'response_code' => 404,
                );
                //return $this->respond($data,404);
                return $this->response($data, 404);
            }
        }

    }

    public function getVisitorCompanyList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $visitorCompanyId = $this->request->getVar('visitor_company_id');
        $visitorCompanyType = $this->request->getVar('visitor_company_type');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'visitor_company_id' => $visitorCompanyId,
                'visitor_company_type' => $visitorCompanyType,
                'is_active' => 1,
            );
            $visitorCompanyData = $this->visitorCompanyModel->getVisitorCompanyData($filterArray);
            if (!empty($visitorCompanyData)) {
                foreach ($visitorCompanyData as $bkey => $visitorCompany) {
                    $visitorCompanyData[$bkey]['created_at'] = YMDToDMY($visitorCompany["created_at"], true);
                    $visitorCompanyData[$bkey]['updated_at'] = YMDToDMY($visitorCompany["updated_at"], true);
                    $visitorCompanyData[$bkey]['visitor_company_type_display'] = underscoreToUcWord($visitorCompany["visitor_company_type"]);
                    $visitorCompanyData[$bkey]['created_at_display'] = time_elapsed_string($visitorCompany['created_at']);
                    $visitorCompanyData[$bkey]['updated_at_display'] = time_elapsed_string($visitorCompany['created_at']);
                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($visitorCompany['visitor_company_image'] != '' && file_exists(VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
                        $path = site_url() . VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
                    }
                    if ($visitorCompany['visitor_company_image'] != '' && file_exists(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
                    }
                    $visitorCompanyData[$bkey]['thumbnail_visitor_company_image'] = $thumbnailPath;
                    $visitorCompanyData[$bkey]['visitor_company_image'] = $path;
                }
            }
            if (!empty($visitorCompanyData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.visitor_company_listing_successfully'),
                    'data' => $visitorCompanyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $visitorCompanyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getCategoryList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $categoryId = $this->request->getVar('category_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $categoryFor = $this->request->getVar('category_for');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            if(!empty($start)){
                $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            }
            else{
                $start = -1;
            }
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'category_id' => $categoryId,
                'category_for' => $categoryFor,
                'society_id' => $societyId,
                'is_active' => 1,
            );
            $categoryData = $this->categoryModel->getCategoryData($filterArray);
            if (!empty($categoryData)) {
                foreach ($categoryData as $bkey => $category) {
                    $categoryData[$bkey]['created_at'] = YMDToDMY($category["created_at"], true);
                    $categoryData[$bkey]['updated_at'] = YMDToDMY($category["updated_at"], true);
                    $categoryData[$bkey]['created_at_display'] = time_elapsed_string($category['created_at']);
                    $categoryData[$bkey]['updated_at_display'] = time_elapsed_string($category['created_at']);
                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($category['category_image'] != '' && file_exists(CATEGORY_IMAGE_PATH . $category['category_image'])) {
                        $path = site_url() . CATEGORY_IMAGE_PATH . $category['category_image'];
                    }
                    if ($category['category_image'] != '' && file_exists(THUMBNAIL_CATEGORY_IMAGE_PATH . $category['category_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_CATEGORY_IMAGE_PATH . $category['category_image'];
                    }
                    $categoryData[$bkey]['thumbnail_category_image'] = $thumbnailPath;
                    $categoryData[$bkey]['category_image'] = $path;
                    if(isset($category['category_for']) && !empty($category['category_for'])){
                        $categoryData[$bkey][$category['category_for'].'_image'] = $path;
                    }
                }
            }
            if (!empty($categoryData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.category_listing_successfully'),
                    'data' => $categoryData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $categoryData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getStatusList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $statusId = $this->request->getVar('status_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $statusFor = $this->request->getVar('status_for');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'status_id' => $statusId,
                'status_for' => $statusFor,
                'is_active' => 1,
            );
            $statusData = $this->statusModel->getStatusData($filterArray);
            if (!empty($statusData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.status_listing_successfully'),
                    'data' => $statusData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $statusData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function sendVisitorApprovalNotification()
    {
        $visitorId = $this->request->getVar('visitor_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $isStatusChange = $this->request->getVar('is_status_change');
        $appType = $this->request->getVar('app_type');

        $this->validation->setRule('visitor_id', lang('CommonWebService.visitor_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'visitor_id' => $visitorId,
                'is_deleted_not' => 1,
            );
            $visitorData = $this->visitorModel->getVisitorData($filterArray);
            if (!empty($visitorData)) {
                if($visitorData['is_deleted'] == 1){
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => lang('CommonWebService.visitor_deleted'),
                        'data' => null
                    ), 404);
                }
                if (!empty($isStatusChange)) {
                    $visitorArray = array(
                        'visitor_id' => $visitorId,
                        'status' => 'waiting_for_approval',
                    );
                    $extraData = array();
                    $extraObj['api_user_id'] = $userSocietyId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $visitorInsertData = $this->commonWebserviceModel->insertUpdateRecord($visitorArray, 'visitor_id', 'tbl_visitor', 1, '', array(), $extraData);
                }
                $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                    "document_type_id" => $visitorId,
                    "document_type" => 'visitor',
                ));
                $visitorImagePath = SITE_URL('uploads/no_image.png');
                if (!empty($visitorImageData)) {
                    if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                        $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                    }
                }

                $filterArray = array(
                    'visitor_id' => $visitorId,
                );

                if($visitorData['status'] == 'entered' || $visitorData['status'] == 'exited'){
                    $endDate = isValidDate($visitorData['end_date']) ? $visitorData['end_date'] : date("Y-m-d H:i:s");
                    $differenecStartEndDate = calculateDateTimeDifference($visitorData['start_date'],$endDate);
                }

                // $visitorNotificationData = visitorListData($filterArray, $userSocietyId);
                $notificationArray = array(
                    'ownership_flat_member_id' => $visitorData['ownership_flat_member_id'],
                    'ownership_flat_id' => $visitorData['ownership_flat_id'],
                    'status' => 'waiting_for_approval',
                    'type' => $visitorData['type'],
                    'type_display' => underscoreToUcWord($visitorData['type']),
                    'society_id' => $societyId,
                    'user_society_id' => $userSocietyId,
                    'type_id' => $visitorData['visitor_id'],
                    'visitor_name' => $visitorData['visitor_name'],
                    'module' => 'visitor',
                    'app_type' => GATE_KEEPER,
                    'mobile_no' => $visitorData['visitor_mobile_no'],
                    'display_status' => underscoreToUcWord('waiting_for_approval'),
                    'image' => $visitorImagePath,
                    'no_of_parcel' => $visitorData['no_of_parcel'],
                    'visitor_company_name' => $visitorData['visitor_company_name'],
                    'no_of_visitor' => $visitorData['no_of_visitor'],
                    'visitor_purpose' => $visitorData['visitor_purpose'],
                    'flat_number' => $visitorData['tower_flat_name'],
                    'flat_name' => $visitorData['tower_flat_name']." ".$visitorData['name'],
                    'member_name' => $visitorData['name'],
                    'vehicle_no' => $visitorData['vehicle_no'],
                    'name' => $visitorData['name'],
                    'visitor_image_data' => $visitorImagePath,
                    'visitor_mobile_no' => $visitorData['visitor_mobile_no'],
                    'expected_start_date_time_display' => isValidDate($visitorData['expected_start_date_time']) ? date('d M,Y h:i A', strtotime($visitorData["expected_start_date_time"])) : "",
                    'expected_end_date_time_display' => isValidDate($visitorData['expected_end_date_time']) ? date('d M,Y h:i A', strtotime($visitorData["expected_end_date_time"])) : "",
                    'delivery_date_time_display' => isValidDate($visitorData['delivery_date']) ? date('d M, Y h:i A', strtotime($visitorData["delivery_date"])) : "",
                    'start_date_time_display' => isValidDate($visitorData['start_date']) ? date('d M, Y h:i A', strtotime($visitorData["start_date"])) : "",
                    'end_date_time_display' => isValidDate($visitorData['end_date']) ? date('d M, Y h:i A', strtotime($visitorData["end_date"])) : "",
                    'member_number' => $visitorData['member_number'],
                    'resource_type_name' => $visitorData['resource_type_name'],
                    'difference_start_end_date' => isset($differenecStartEndDate) ? $differenecStartEndDate : "",
                    // 'vehcal_data' => $visitorNotificationData,
                    // 'visitor_type_color_code' => $visitorTypeData[$visitorData['type']] ?? null,

                );
                $extraDatajson = json_encode($notificationArray);
                $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                    'resource_type_name' => RESOURCE_TYPE_MEMBER,
                    'society_id' => $societyId,
                ));

                if ($appType == GATE_KEEPER) {
                    $notificationArray['send_for_notification'] = $appType;
                    $notificationArray['send_for_notification_id'] = $userSocietyId;
                    $notificationArray['receive_for_notification'] = $resourceTypeData['resource_type_id'];
                    $notificationArray['receive_for_notification_id'] = $visitorData['ownership_flat_member_id'];
                }

                if ($appType == MEMBER_APP) {
                    $notificationArray['send_for_notification'] = $appType;
                    $notificationArray['send_for_notification_id'] = $visitorData['ownership_flat_member_id'];
                    $notificationArray['receive_for_notification'] = $resourceTypeData['resource_type_id'];
                    $notificationArray['receive_for_notification_id'] = 0;
                }

                sendNotificationDataList($notificationArray, $extraDatajson);
            }
            $filterArray = array(
                'visitor_id' => $visitorId,
                'is_multiple' => 1,
                'is_deleted' => 0,
            );
            $visitorListData = visitorListData($filterArray, $userSocietyId);
            if (!empty($visitorData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.notification_send_successfully'),
                    'data' => $visitorListData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function deleteVisitor()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $visitorId = $this->request->getVar('visitor_id');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('visitor_id', lang('CommonWebService.visitor_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $visitorId = ($visitorId != '') ? explode(",", $visitorId) : '';
            $visitorRecordData = $this->visitorModel->getVisitorData(array(
                'visitor_id' => $visitorId,
            ));

            if (!empty($visitorRecordData)) {
                if ($visitorRecordData['status'] == 'entered' || $visitorRecordData['status'] == 'exited') {
                    $data = array(
                        'status' => False,
                        'message' => lang('CommonWebService.you_cant_delete_these_visitor') . underscoreToUcWord($visitorRecordData['status']),
                        'response_code' => 404,
                        'data' => null,
                    );
                    return $this->response($data, 404);
                }
            }
            $visitorData = $this->visitorModel->deleteVisitorRecord(array('visitor_id' => $visitorId, 'user_society_id' => $userSocietyId));
            if ($visitorData['success']) {
                if (!empty($visitorId)) {
                    foreach ($visitorId as $visitor) {
                        $deleteDataArray['module'] = 'Visitor';
                        $deleteDataArray['activity'] = "Visitor Deleted";
                        $deleteDataArray['module_id'] = $visitor;
                        logActivity('Visitor Deleted [VisitorID: ' . $visitor . ']', $userSocietyId, 'Visitor', $visitor, json_encode($deleteDataArray), '', 'Visitor', $visitor);
                    }
                }
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.visitor')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.visitor')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function deleteMember()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $memberId = $this->request->getVar('member_id');
        $remarks = $this->request->getVar('remarks');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('member_id', lang('CommonWebService.member_id'), 'required');
        $this->validation->setRule('remarks', lang('CommonWebService.remarks'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transBegin();
            $memberId = ($memberId != '') ? explode(",", $memberId) : '';


            $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                'type' => RESOURCE_TYPE_MEMBER,
                'type_id' => $memberId,
                'society_id' => $societyId,
            ));

            // printArray($userSocietyData['user_society_id'],1);
            if(!empty($userSocietyData)){  
                // if(count($userSocietyData) == 1){
                    $this->commonWebserviceModel->deleteUserSocietyFlatRecord($userSocietyData['user_society_id'],$userSocietyId);
                // }
            }

            $ownershipFlatMemberDeleteData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $memberId,
                'is_multiple' => 1
            ));

            if(is_array($ownershipFlatMemberDeleteData) && !empty($ownershipFlatMemberDeleteData)){
                foreach ($ownershipFlatMemberDeleteData as $image){
                    $FileUrl = '';
                    if(isset($image['member_image']) && $image['member_image'] != '') {
                        $FileUrl = FLAT_MEMBER_IMAGE_PATH . $image['member_image'];
                    }
                    if (file_exists($FileUrl)) {
                        unlink($FileUrl);
                    }

                    $thumbnailFileUrl = '';
                    if(isset($image['member_image']) && $image['member_image'] != '') {
                        $thumbnailFileUrl = THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $image['member_image'];
                    }
                    if (file_exists($thumbnailFileUrl)) {
                        unlink($thumbnailFileUrl);
                    }
                }
            }
            
            $memberRecordData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $memberId,
            ));
            $memberData = $this->ownershipFlatModel->deleteMemberRecord(array('member_id' => $memberId, 'user_society_id' => $userSocietyId, 'remarks' => $remarks));
            if ($memberData['success']) {
                if (!empty($memberId)) {
                    foreach ($memberId as $member) {
                        $deleteDataArray['module'] = 'Ownership Flat Member';
                        $deleteDataArray['activity'] = "Ownership Flat Member Deleted";
                        $deleteDataArray['module_id'] = $member;
                        logActivity('Ownership Flat Member Deleted [OwnershipFlatMemberID: ' . $member . ']', $userSocietyId, 'Ownership Flat Member', $member, json_encode($deleteDataArray), '', 'Ownership Flat Member', $member);
                    }
                }
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.member')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.member')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function deleteVehicle()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');
        $remarks = $this->request->getVar('remarks');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('ownership_flat_parking_id', lang('CommonWebService.ownership_flat_parking_id'), 'required');
        $this->validation->setRule('remarks', lang('CommonWebService.remarks'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $this->db->transBegin();
            $ownershipFlatParkingId = ($ownershipFlatParkingId != '') ? explode(",", $ownershipFlatParkingId) : '';
            $ownershipFlatParkingDeleteData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                'ownership_flat_parking_id' => $ownershipFlatParkingId,
                'is_multiple' => 1
            ));

            if(is_array($ownershipFlatParkingDeleteData) && !empty($ownershipFlatParkingDeleteData)){
                foreach ($ownershipFlatParkingDeleteData as $image){
                    $FileUrl = '';
                    if(isset($image['vehicle_image']) && $image['vehicle_image'] != '') {
                        $FileUrl = VEHICLE_IMAGE_PATH . $image['vehicle_image'];
                    }
                    if (file_exists($FileUrl)) {
                        unlink($FileUrl);
                    }

                    $thumbnailFileUrl = '';
                    if(isset($image['vehicle_image']) && $image['vehicle_image'] != '') {
                        $thumbnailFileUrl = THUMBNAIL_VEHICLE_IMAGE_PATH . $image['vehicle_image'];
                    }
                    if (file_exists($thumbnailFileUrl)) {
                        unlink($thumbnailFileUrl);
                    }
                }
            }
            $vehicleData = $this->ownershipFlatModel->deleteVehicleRecord(array('ownership_flat_parking_id' => $ownershipFlatParkingId, 'user_society_id' => $userSocietyId, 'remarks' => $remarks));
            if ($vehicleData['success']) {
                if (!empty($vehicleId)) {
                    foreach ($vehicleId as $vehicle) {
                        $deleteDataArray['module'] = 'Ownership Flat Vehicle';
                        $deleteDataArray['activity'] = "Ownership Flat Vehicle Deleted";
                        $deleteDataArray['module_id'] = $vehicle;
                        logActivity('Ownership Flat Vehicle Deleted [OwnershipFlatVehicleID: ' . $vehicle . ']', $userSocietyId, 'Ownership Flat Vehicle', $vehicle, json_encode($deleteDataArray), '', 'Ownership Flat Vehicle', $vehicle);
                    }
                }
                $data = array(
                    'status' => TRUE,
                    'message' => sprintf(lang('CommonMessage.delete_record'), lang('CommonWebService.vehicle')),
                    'response_code' => 200,
                    'data' => null,);

                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => False,
                    'message' => sprintf(lang('CommonMessage.error_delete_record'), lang('CommonWebService.vehicle')),
                    'response_code' => 404,
                    'data' => null,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getNoticeList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $noticeId = $this->request->getVar('notice_id');
        $isRead = $this->request->getVar('is_read');
        $isBookmark = $this->request->getVar('is_bookmark');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $type = $this->request->getVar('type');
        $categoryId = $this->request->getVar('category_id[]');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        // $this->validation->setRule('type', lang('CommonWebService.type'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {

            $categoryData = $this->categoryModel->getCategoryData(array(
                'category_for' => 'notice',
                'is_multiple' => 1,
                'is_active' => 1,
            ));

            if (!empty($isRead) && !empty($noticeId)) {
                $noticeReadData = $this->commonWebserviceModel->getDocumentReadData(array(
                    "type" => 'notice',
                    "type_id" => $noticeId,
                    "ownership_flat_member_id" => $ownershipFlatMemberId,
                ));

                if (empty($noticeReadData)) {
                    $documentReadArray = array(
                        'document_read_id' => '',
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        "type" => 'notice',
                        'type_id' => $noticeId,
                    );
                    $extraData = array();
                    $extraObj['api_user_id'] = $ownershipFlatMemberId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $documentReadData = $this->commonWebserviceModel->insertUpdateRecord($documentReadArray, 'document_read_id', 'tbl_document_read', 1, '', array(), $extraData);
                }
            }
            $totalBookmarkData = $this->commonWebserviceModel->getTotalBookmarkData(array(
                'type' => 'notice',
                'ownership_flat_member_id' => $ownershipFlatMemberId
            ));
            $totalBookmark = isset($totalBookmarkData['total_bookmark']) ? $totalBookmarkData['total_bookmark'] : 0;
            $totalUnreadData = $this->commonWebserviceModel->getTotalUnreadData(array(
                'type' => 'notice',
                'society_id' => $societyId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            ));
            $totalUnread = isset($totalUnreadData['total_unread']) ? $totalUnreadData['total_unread'] : 0;
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'type' => $type,
                'society_id' => $societyId,
                'notice_id' => $noticeId,
                'category_id' => $categoryId,
                'is_bookmark' => $isBookmark,
                'is_check_expiry_date' => date("Y-m-d"),
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            );
            $noticeData = $this->noticeModel->getNoticeData($filterArray);
            $noticeDocumentDataWise = array();
            $noticeCategoryDataWise = array();
            $noticeBookmarkDataWise = array();
            $noticeIdArray = array();
            if (!empty($noticeData)) {
                foreach ($noticeData as $noticeElement) {
                    $noticeIdArray[] = $noticeElement['notice_id'];
                }
                if (!empty($noticeIdArray)) {
                    $noticeCategoryData = $this->noticeModel->getNoticeCategoryData(array(
                        "notice_id" => $noticeIdArray,
                        "is_multiple" => 1
                    ));
                    if (!empty($noticeCategoryData)) {
                        foreach ($noticeCategoryData as $noticeCategoryElement) {
                            $noticeCategoryDataWise[$noticeCategoryElement['notice_id']][] = $noticeCategoryElement;
                        }
                    }
                    $noticeBookmarkData = $this->noticeModel->getBookmarkData(array(
                        "type" => 'notice',
                        "type_id" => $noticeIdArray,
                        "ownership_flat_member_id" => $ownershipFlatMemberId,
                        "is_multiple" => 1,
                        "is_bookmark" => 1,
                    ));
                    if (!empty($noticeBookmarkData)) {
                        foreach ($noticeBookmarkData as $noticeBookmarkElement) {
                            $noticeBookmarkDataWise[$noticeBookmarkElement['type_id']][] = $noticeBookmarkElement;
                        }
                    }
                    $noticeImageData = $this->mediaModel->getMediaData(array(
                        "media_for_id" => $noticeIdArray,
                        "media_for" => 'notice',
                        "is_multiple" => 1
                    ));
                    if (!empty($noticeImageData)) {
                        foreach ($noticeImageData as $noticeImageElement) {
                            if ($noticeImageElement["media_file"] == '') {
                                $noticeImageElement["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                                $noticeImageElement["media_file"] = SITE_URL('uploads/no_image.png');
                            } else {
                                if($noticeImageElement['media_type'] == 'image'){
                                    $noticeImageElement["thumbnail_media_file"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $noticeImageElement["media_file"];
                                }
                                else{
                                    $noticeImageElement["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                                }
                                $noticeImageElement["media_file"] = SITE_URL() . MEDIA_IMAGE_PATH . $noticeImageElement["media_file"];
                            }
                            $noticeDocumentDataWise[$noticeImageElement['media_for_id']][] = $noticeImageElement;
                        }
                    }
                }
            }
            if (!empty($noticeData)) {
                foreach ($noticeData as $nKey => $notice) {
                    //$noticeData[$nKey]["notice_date_display"] = isValidDate($notice['notice_date']) ? date('d M Y, H:i A', strtotime($notice["notice_date"])) : "";
                    $noticeData[$nKey]["notice_date_display"] = isValidDate($notice['notice_date']) ? date('d M Y', strtotime($notice["notice_date"])) : "";
                    $noticeData[$nKey]['created_at'] = isValidDate($notice['created_at']) ? YMDToDMY($notice["created_at"], true) : "";
                    $noticeData[$nKey]['updated_at'] = isValidDate($notice['updated_at']) ? YMDToDMY($notice["updated_at"], true) : "";
                    $noticeData[$nKey]['created_at_display'] = time_elapsed_string($notice['created_at']);
                    $noticeData[$nKey]['updated_at_display'] = time_elapsed_string($notice['updated_at']);
                    $noticeData[$nKey]['notice_bookmark_data'] = array_key_exists($notice['notice_id'], $noticeBookmarkDataWise) ? $noticeBookmarkDataWise[$notice['notice_id']] : array();
                    $noticeData[$nKey]['notice_category_data'] = array_key_exists($notice['notice_id'], $noticeCategoryDataWise) ? $noticeCategoryDataWise[$notice['notice_id']] : array();
                    $noticeData[$nKey]['notice_image_data'] = array_key_exists($notice['notice_id'], $noticeDocumentDataWise) ? $noticeDocumentDataWise[$notice['notice_id']] : array();
                    $shareData = array(
                        'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                        'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                        'share_image' => base_url('uploads/no_image.png'),
                        "share_link" => "https://digitattva.in/",
                    );
                    $noticeData[$nKey]['share_data'] = $shareData;
                }
            }
            if (!empty($noticeData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.notice_listing_successfully'),
                    'total_bookmark_count' => $totalBookmark,
                    'total_unread_count' => $totalUnread,
                    'category_data' => $categoryData,
                    'data' => $noticeData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'total_bookmark_count' => $totalBookmark,
                    'total_unread_count' => $totalUnread,
                    'category_data' => $categoryData,
                    'data' => $noticeData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getNotificationList()
    {
        $appType = $this->request->getVar('app_type');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $notificationId = $this->request->getVar('notification_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $userId = $this->request->getVar('user_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        // $this->validation->setRule('type', lang('CommonWebService.type'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if ($appType == MEMBER_APP) {
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $userSocietyIdData = $this->commonWebserviceModel->getUserSocietyData(array(
                'user_society_id' => $userSocietyId,
            ));
            $filterArray = array(
                'is_multiple' => 1,
                'start' => $start,
                'search' => $search,
                'society_id' => $societyId,
                'notification_id' => $notificationId,
                //'type' => 'notification',
            );
            if ($appType == GATE_KEEPER) {
                $filterArray['receive_for_notification'] = GATE_KEEPER;
                $filterArray['receive_for_notification_id'] = $userSocietyIdData['type_id'];
            }
            if ($appType == MEMBER_APP) {
                $filterArray['receive_for_notification'] = MEMBER_APP;
                $filterArray['receive_for_notification_id'] = $ownershipFlatMemberId;
            }

            if ($appType == MANAGER_APP) {
                $filterArray['receive_for_notification'] = MANAGER_APP;
                $filterArray['receive_for_notification_id'] = $userId;
            }

            $notificationData = $this->notificationModel->getNotificationData($filterArray);
            $notificationDocumentDataWise = array();
            $notificationIdArray = array();
            if (!empty($notificationData)) {
                foreach ($notificationData as $notificationElement) {
                    $notificationIdArray[] = $notificationElement['notification_id'];
                }
                if (!empty($notificationIdArray)) {
                    $notificationImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $notificationIdArray,
                        "document_type" => 'notification',
                        "is_multiple" => 1
                    ));
                    if (!empty($notificationImageData)) {
                        foreach ($notificationImageData as $notificationImageElement) {
                            if ($notificationImageElement["document_image"] == '') {
                                $notificationImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $notificationImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $notificationImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $notificationImageElement["document_image"];
                                $notificationImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $notificationImageElement["document_image"];
                            }
                            $notificationDocumentDataWise[$notificationImageElement['document_type_id']][] = $notificationImageElement;
                        }
                    }
                }
            }
            if (!empty($notificationData)) {
                foreach ($notificationData as $vKey => $notification) {
                    $notificationData[$vKey]['created_at'] = isValidDate($notification['created_at']) ? YMDToDMY($notification["created_at"], true) : "";
                    $notificationData[$vKey]['updated_at'] = isValidDate($notification['updated_at']) ? YMDToDMY($notification["updated_at"], true) : "";
                    $notificationData[$vKey]['notifiation_time_display'] = isValidDate($notification['created_at']) ? date("h:i A", strtotime($notification['created_at'])) : "";

                    $notificationData[$vKey]["notification_date_display"] = isValidDate($notification['notification_date']) ? date('d M Y', strtotime($notification["notification_date"])) : "";
                    $notificationData[$vKey]['created_at_display'] = time_elapsed_string($notification['created_at']);
                    $notificationData[$vKey]['updated_at_display'] = time_elapsed_string($notification['updated_at']);
                    $notificationData[$vKey]['notification_image_data'] = array_key_exists($notification['notification_id'], $notificationDocumentDataWise) ? $notificationDocumentDataWise[$notification['notification_id']] : array();
                }
            }
            if (!empty($notificationData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.notification_listing_successfully'),
                    'data' => $notificationData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $notificationData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditBookmark()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $isBookmark = $this->request->getVar('is_bookmark');
        $societyId = $this->request->getVar('society_id');
        $type = $this->request->getVar('type');
        $typeId = $this->request->getVar('type_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('type', lang('CommonWebService.type'), 'required|alpha');
        $this->validation->setRule('type_id', lang('CommonWebService.type_id'), 'required|numeric');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $filterArray = array(
                'is_multiple' => 1,
                'type' => $type,
                'type_id' => $typeId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            );
            $bookmarkData = $this->noticeModel->getBookmarkData($filterArray);
            $bookmarkIdArray = array();
            if (!empty($bookmarkData)) {
                foreach ($bookmarkData as $bookmarkElement) {
                    array_push($bookmarkIdArray, $bookmarkElement['bookmark_id']);
                }
            }
            if (!empty($bookmarkIdArray)) {
                $this->noticeModel->deleteBookmarkRecord($bookmarkIdArray);
            }
            if ($isBookmark == 0) {
                $totalBookmarkData = $this->commonWebserviceModel->getTotalBookmarkData(array(
                    'type' => $type,
                    'type_id' => $typeId,
                ));
                $totalBookmark = isset($totalBookmarkData['total_bookmark']) ? $totalBookmarkData['total_bookmark'] : 0;
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.un_bookmark')),
                    'data' => null,
                    'total_bookmark' => (int)$totalBookmark
                ), 200);
            } else {
                $bookmarkArray = array(
                    'bookmark_id' => '',
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'type' => $type,
                    'type_id' => $typeId,
                    'society_id' => $societyId
                );
                $extraData = array();
                $extraObj['api_user_id'] = $userSocietyId;
                $extraObj['society_id'] = $societyId;
                $extraData['is_api_data'] = $extraObj;
                $bookmarkData = $this->commonWebserviceModel->insertUpdateRecord($bookmarkArray, 'bookmark_id', 'tbl_bookmark', 1, '', array(), $extraData);
                $lastBookmarkId = $bookmarkData['lastInsertedId'];
                $totalBookmarkData = $this->commonWebserviceModel->getTotalBookmarkData(array(
                    'type' => $type,
                    'type_id' => $typeId,
                ));
                $totalBookmark = isset($totalBookmarkData['total_bookmark']) ? $totalBookmarkData['total_bookmark'] : 0;
                if (isset($bookmarkData['success']) && $bookmarkData['success']) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.bookmark')),
                        'data' => null,
                        'total_bookmark' => (int)$totalBookmark
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed'), lang('CommonWebService.bookmark')),
                        'data' => null,
                        'total_bookmark' => (int)$totalBookmark
                    ), 400);
                }
            }

        }
    }

    public function addEditPollVotes()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $pollOptionIdArray = $this->request->getVar('poll_option_id');
        $pollId = $this->request->getVar('poll_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('poll_id', lang('CommonWebService.poll_id'), 'required|numeric');
        $this->validation->setRule('poll_option_id.*', lang('CommonWebService.poll_option_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $pollData = $this->pollModel->getPollData(array(
                'poll_id' => $pollId,
            ));
            $todayDate = date('Y-m-d');
            if (!empty($pollData)) {
                $pollEndDate = $pollData['end_date'];
                if ($pollEndDate < $todayDate) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 400,
                        'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.poll_ended')),
                        'data' => null,
                    ), 400);
                }
            }

            $filterArray = array(
                'is_multiple' => 1,
                // 'poll_option_id' => $pollOptionIdArray,
                'poll_id' => $pollId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
            );
            $pollVotesData = $this->pollModel->getPollVotesData($filterArray);
            $pollVotesIdArray = array();
            if (!empty($pollVotesData)) {
                foreach ($pollVotesData as $pollVotesElement) {
                    array_push($pollVotesIdArray, $pollVotesElement['poll_votes_id']);
                }
            }
            if (!empty($pollVotesIdArray)) {
                $this->pollModel->deletePollVotesRecord($pollVotesIdArray);
            }
            $pollOptionIdDataArray = implode(',', $pollOptionIdArray);
            $pollOptionIdDataArray = explode(',', $pollOptionIdDataArray);
            if (!empty($pollOptionIdDataArray)) {
                foreach ($pollOptionIdDataArray as $pollOptionId) {
                    $pollVotesArray = array(
                        'poll_votes_id' => '',
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'poll_option_id' => $pollOptionId,
                        'poll_id' => $pollId,
                    );
                    $extraData = array();
                    $extraObj['api_user_id'] = $userSocietyId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $pollVotesData = $this->commonWebserviceModel->insertUpdateRecord($pollVotesArray, 'poll_votes_id', 'tbl_poll_votes', 1, '', array(), $extraData);
                    $lastPollVotesId = $pollVotesData['lastInsertedId'];
                }
            }
            $totalPollVotesData = $this->pollModel->getTotalPollVotesData(array(
                'poll_id' => $pollId,
                // 'type_id' => $typeId,
            ));
            $totalPollVotes = isset($totalPollVotesData['total_poll_votes']) ? $totalPollVotesData['total_poll_votes'] : 0;
            if (isset($pollVotesData['success']) && $pollVotesData['success']) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => sprintf(lang('CommonWebService.successfully'), lang('CommonWebService.poll_votes')),
                    'data' => null,
                    'total_poll_votes' => (int)$totalPollVotes
                ), 200);
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => sprintf(lang('CommonWebService.failed'), lang('CommonWebService.poll_votes')),
                    'data' => null,
                    'total_poll_votes' => (int)$totalPollVotes
                ), 400);
            }
        }
    }

    public function addEditVisitorCompany()
    {
        $this->db->transStart();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $validation = \Config\Services::validation();
        $visitorCompanyId = $this->request->getVar('visitor_company_id');
        $visitorCompanyType = $this->request->getVar('visitor_company_type');
        $societyId = $this->request->getVar('society_id');
        $visitorCompanyName = $this->request->getVar('visitor_company_name');
        $visitorCompanyImage = $this->request->getVar('visitor_company_image');
        $userSocietyId = $this->request->getVar('user_society_id');
        $this->validation->setRule('visitor_company_name', lang('CommonWebService.visitor_company_name'), 'required');
        $this->validation->setRule('visitor_company_type', lang('CommonWebService.visitor_company_type'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {

            $visitorCompanyForNameCheck = $this->visitorCompanyModel->checkVisitorCompanyNameExist(array('visitor_company_id' => $visitorCompanyId, 'visitor_company_name' => $visitorCompanyName, 'visitor_company_type' => $visitorCompanyType));

            if (!empty($visitorCompanyForNameCheck)) {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => "This Visitor Company Type " . underscoreToUcWord($visitorCompanyForNameCheck['visitor_company_type']) . " Visitor Company Name " . $visitorCompanyName . " Already Exists",
                    'data' => null
                ), 404);
            }

            
            if (isset($_FILES["visitor_company_image"])) {
                $visitorCompanyImagePath = VISITOR_COMPANY_IMAGE_PATH;
                $visitorCompanyImageResult = $dt_ci_file_upload->uploadFile('visitor_company_image', MAX_IMAGE_SIZE_LIMIT, $visitorCompanyImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($visitorCompanyImageResult['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($visitorCompanyImageResult['message']),
                        'data' => null
                    ), 404);
                } else {
                    $visitorCompanyImageRecord = $visitorCompanyImageResult['file_name'];
                    unset($visitorCompanyImageResult['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailUploadFile($visitorCompanyImageResult, VISITOR_COMPANY_IMAGE_PATH, THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH);
                }
            }    
            $visitorCompanyUpdateArray = array();
            $visitorCompanyArray = array(
                'visitor_company_id' => $visitorCompanyId,
                'visitor_company_type' => $visitorCompanyType,
                'visitor_company_name' => $visitorCompanyName,
                'is_active' => 1,
            );
            if (isset($_FILES["visitor_company_image"])) {
                if ($visitorCompanyId != '') {
                    $visitorCompanyData = $this->visitorCompanyModel->getVisitorCompanyData(array('visitor_company_id' => $visitorCompanyId));
                    if ($visitorCompanyData['visitor_company_image'] != '' && file_exists(VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyData['visitor_company_image'])) {
                        unlink(VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyData['visitor_company_image']);
                    }
                    if ($visitorCompanyData['visitor_company_image'] != '' && file_exists(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyData['visitor_company_image'])) {
                        unlink(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyData['visitor_company_image']);
                    }
                }
                $visitorCompanyArray['visitor_company_image'] = $visitorCompanyImageResult['file_name'];
            }
            if (!empty($visitorCompanyId)) {
                $visitorCompanyUpdateData = $this->visitorCompanyModel->getVisitorCompanyData(array(
                    'visitor_company_id' => $visitorCompanyId,
                ));
                $visitorCompanyUpdateArray = compareArray($visitorCompanyArray, $visitorCompanyUpdateData);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $visitorCompanyData = $this->commonWebserviceModel->insertUpdateRecord($visitorCompanyArray, 'visitor_company_id', 'tbl_visitor_company', 1, '', array(), $extraData, $visitorCompanyUpdateArray);
            $lastVisitorCompanyId = $visitorCompanyData['lastInsertedId'];
            $visitorCompanyListData = $this->visitorCompanyModel->getVisitorCompanyData(array(
                'visitor_company_id' => $lastVisitorCompanyId,
                'is_multiple' => 1,
            ));


            if (!empty($visitorCompanyListData)) {
                foreach ($visitorCompanyListData as $bkey => $visitorCompanyList) {
                    $visitorCompanyListData[$bkey]['created_at'] = YMDToDMY($visitorCompanyList["created_at"], true);
                    $visitorCompanyListData[$bkey]['updated_at'] = YMDToDMY($visitorCompanyList["updated_at"], true);
                    $visitorCompanyListData[$bkey]['visitor_company_type_display'] = underscoreToUcWord($visitorCompanyList["visitor_company_type"]);
                    $visitorCompanyListData[$bkey]['created_at_display'] = time_elapsed_string($visitorCompanyList['created_at']);
                    $visitorCompanyListData[$bkey]['updated_at_display'] = time_elapsed_string($visitorCompanyList['created_at']);
                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($visitorCompanyList['visitor_company_image'] != '' && file_exists(VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyList['visitor_company_image'])) {
                        $path = site_url() . VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyList['visitor_company_image'];
                    }
                    if ($visitorCompanyList['visitor_company_image'] != '' && file_exists(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyList['visitor_company_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompanyList['visitor_company_image'];
                    }
                    $visitorCompanyListData[$bkey]['visitor_company_image'] = $path;
                    $visitorCompanyListData[$bkey]['thumbnail_visitor_company_image'] = $thumbnailPath;
                }
            }

             // printArray($visitorCompanyListData,1);
            $transactionStatus = $this->db->transComplete();
            if (isset($visitorCompanyId) && !empty($visitorCompanyId)) {
                if ((isset($visitorCompanyData['success']) && $visitorCompanyData['success']) && ($transactionStatus == 1)) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.visitor_company')),
                        'data' => $visitorCompanyListData,
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.visitor_company')),
                        'data' => null,
                    ), 404);
                }
            } else {
                if ((isset($visitorCompanyData['success']) && $visitorCompanyData['success']) && ($transactionStatus == 1)) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.visitor_company')),
                        'data' => $visitorCompanyListData,
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.visitor_company')),
                        'data' => null,
                    ), 400);
                }
            }
        }
    }

    public function getPollList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $pollId = $this->request->getVar('poll_id');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $pollType = $this->request->getVar('poll_type');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'poll_id' => $pollId,
                'society_id' => $societyId,
            );
            $pollData = $this->pollModel->getPollData($filterArray);
            $pollOptionDataWise = array();
            $pollVotesDataWise = array();
            $pollIdArray = array();
            if (!empty($pollData)) {
                foreach ($pollData as $pollElement) {
                    $pollIdArray[] = $pollElement['poll_id'];
                }
                if (!empty($pollIdArray)) {
                    $pollOptionData = $this->pollModel->getPollOptionData(array(
                        "poll_id" => $pollIdArray,
                        "ownership_flat_member_id" => $ownershipFlatMemberId,
                        "is_multiple" => 1
                    ));
                    if (!empty($pollOptionData)) {
                        foreach ($pollOptionData as $pollOptionElement) {
                            $pollOptionDataWise[$pollOptionElement['poll_id']][] = $pollOptionElement;
                        }
                    }
                    $pollVotesData = $this->pollModel->getPollVotesData(array(
                        "poll_id" => $pollIdArray,
                        "ownership_flat_member_id" => $ownershipFlatMemberId,
                        "is_multiple" => 1,
                    ));
                    if (!empty($pollVotesData)) {
                        foreach ($pollVotesData as $pollVotesElement) {
                            $pollVotesDataWise[$pollVotesElement['poll_id']][] = $pollVotesElement;
                        }
                    }
                }
            }
            if (!empty($pollData)) {
                foreach ($pollData as $pKey => $poll) {
                    $pollData[$pKey]["start_date_display"] = isValidDate($poll['start_date']) ? date('d M Y', strtotime($poll["start_date"])) : "";
                    $pollData[$pKey]["end_date_display"] = isValidDate($poll['end_date']) ? date('d M Y', strtotime($poll["end_date"])) : "";
                    $pollData[$pKey]['created_at'] = YMDToDMY($poll["created_at"], true);
                    $pollData[$pKey]['updated_at'] = YMDToDMY($poll["updated_at"], true);
                    $pollData[$pKey]['created_at_display'] = time_elapsed_string($poll['created_at']);
                    $pollData[$pKey]['updated_at_display'] = time_elapsed_string($poll['updated_at']);
                    $pollData[$pKey]['poll_option_data'] = array_key_exists($poll['poll_id'], $pollOptionDataWise) ? $pollOptionDataWise[$poll['poll_id']] : array();
                    $pollData[$pKey]['poll_votes_data'] = array_key_exists($poll['poll_id'], $pollVotesDataWise) ? $pollVotesDataWise[$poll['poll_id']] : array();
                }
            }
            $currentCompletedPollWiseData = array();
            $completedPoll = array();
            $currentPoll = array();
            if (!empty($pollData)) {
                foreach ($pollData as $key => $pollElement) {
                    // if($pollType == 'completed_poll'){
                        if (strtotime(TODAY_DATE) > strtotime($pollElement['end_date'])) {
                            $pollElement['poll_status'] = 'Ended';
                            array_push($completedPoll, $pollElement);
                        } else {
                    // }
                    // if($pollType == 'current_poll') {
                        $pollElement['poll_status'] = 'Ongoing';
                        array_push($currentPoll, $pollElement);
                        }
                    // }
                }
            }
            if($pollType == 'current_poll'){
                $currentCompletedPollWiseData = $currentPoll;
            }
            if($pollType == 'completed_poll'){
                $currentCompletedPollWiseData = $completedPoll;
            }
            if (!empty($currentCompletedPollWiseData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.poll_listing_successfully'),
                    'data' => $currentCompletedPollWiseData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $currentCompletedPollWiseData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getDocumentFolderList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $documentFolderId = $this->request->getVar('document_folder_id');
        $isFolderDetail = $this->request->getVar('is_folder_detail');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $appType = $this->request->getVar('app_type');

        if($appType != MANAGER_APP){
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        // $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'society_id' => $societyId,
                'document_folder_id' => $documentFolderId,
            );
            $documentFolderData = $this->documentFolderModel->getDocumentFolderData($filterArray);
            $documentFolderDocumentDataWise = array();
            $documentFolderItemDataWise = array();
            $documentFolderIdArray = array();
            $documentFolderItemIdArray = array();
            if (!empty($isFolderDetail)) {
                if (!empty($documentFolderData)) {
                    foreach ($documentFolderData as $documentFolderElement) {
                        $documentFolderIdArray[] = $documentFolderElement['document_folder_id'];
                    }
                    if (!empty($documentFolderIdArray)) {
                        $documentFolderItemData = $this->documentFolderModel->getDocumentFolderItemData(array(
                            "document_folder_id" => $documentFolderIdArray,
                            "is_multiple" => 1,
                        ));
                        if (!empty($documentFolderItemData)) {
                            foreach ($documentFolderItemData as $documentFolderItemElement) {
                                $documentFolderItemIdArray[] = $documentFolderItemElement['document_folder_item_id'];
                            }
                        }
                        if (!empty($documentFolderItemIdArray)) {
                            $documentFolderImageData = $this->visitorModel->getDocumentImageData(array(
                                "document_type_id" => $documentFolderItemIdArray,
                                "document_type" => 'document_folder',
                                "is_multiple" => 1
                            ));
                            if (!empty($documentFolderImageData)) {
                                foreach ($documentFolderImageData as $documentFolderImageElement) {

                                    $extension = explode('.', $documentFolderImageElement["document_image"]);
                                    if (!empty($extension)) {
                                        foreach ($extension as $extensionElement) {
                                            if ($extensionElement == 'pdf') {
                                                $documentFolderImageElement["icon_image"] = site_url('uploads/pdf_image.jpg');
                                            } else {
                                                $documentFolderImageElement["icon_image"] = site_url('uploads/no_image.png');
                                            }
                                        }
                                    }
                                    if ($documentFolderImageElement["document_image"] == '') {
                                        $documentFolderImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                        $documentFolderImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                                    } else {
                                        if (!empty($extension)) {
                                            foreach ($extension as $extensionElement) {
                                                if ($extensionElement == 'pdf') {

                                                    $documentFolderImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                                }
                                                else{
                                                    $documentFolderImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $documentFolderImageElement["document_image"];
                                                }
                                            }
                                        }
                                        $documentFolderImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $documentFolderImageElement["document_image"];
                                    }
                                    $documentFolderDocumentDataWise[$documentFolderImageElement['document_type_id']][] = $documentFolderImageElement;
                                }
                            }
                        }
                    }
                }
                if (!empty($documentFolderItemData)) {
                    foreach ($documentFolderItemData as $vKey => $documentFolderItem) {
                        $documentFolderItemData[$vKey]['document_folder_item_image_data'] = array_key_exists($documentFolderItem['document_folder_item_id'], $documentFolderDocumentDataWise) ? $documentFolderDocumentDataWise[$documentFolderItem['document_folder_item_id']] : array();
                    }
                }
                if (isset($documentFolderItemData) && !empty($documentFolderItemData)) {
                    foreach ($documentFolderItemData as $documentFolderItemElement) {
                        $documentFolderItemElement['effective_date_display'] = isValidDate($documentFolderItemElement['effective_date']) ? date("d F, Y", strtotime($documentFolderItemElement['effective_date'])) : "";
                        $documentFolderItemElement['effective_time_display'] = isValidDate($documentFolderItemElement['created_at']) ? date("h:i A", strtotime($documentFolderItemElement['created_at'])) : "";
                        $documentFolderItemDataWise[$documentFolderItemElement['document_folder_id']][] = $documentFolderItemElement;
                    }
                }
            }
            if (!empty($documentFolderData)) {
                foreach ($documentFolderData as $vKey => $documentFolder) {
                    $documentFolderData[$vKey]['created_at'] = isValidDate($documentFolder['created_at']) ? YMDToDMY($documentFolder["created_at"], true) : "";
                    $documentFolderData[$vKey]['updated_at'] = isValidDate($documentFolder['updated_at']) ? YMDToDMY($documentFolder["updated_at"], true) : "";
                    $documentFolderData[$vKey]['created_at_display'] = time_elapsed_string($documentFolder['created_at']);
                    $documentFolderData[$vKey]['updated_at_display'] = time_elapsed_string($documentFolder['updated_at']);
                    $documentFolderData[$vKey]['document_folder_item_data'] = array_key_exists($documentFolder['document_folder_id'], $documentFolderItemDataWise) ? $documentFolderItemDataWise[$documentFolder['document_folder_id']] : array();
                }
            }
            if (!empty($documentFolderData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.document_folder_listing_successfully'),
                    'data' => $documentFolderData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $documentFolderData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getBannerList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $bannerId = $this->request->getVar('banner_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        // $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'start' => $start,
                'search' => $search,
                'society_id' => $societyId,
                'banner_id' => $bannerId,
                'date_greater_than_equal_to' => TODAY_DATE_YMD,
            );
            $bannerData = $this->bannerModel->getBannerData($filterArray);
            $bannerImageDataWise = array();
            $bannerIdArray = array();
            if (!empty($bannerData)) {
                foreach ($bannerData as $bannerElement) {
                    $bannerIdArray[] = $bannerElement['banner_id'];
                }
                if (!empty($bannerIdArray)) {
                    $bannerImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $bannerIdArray,
                        "document_type" => 'banner',
                        "is_multiple" => 1
                    ));
                    if (!empty($bannerImageData)) {
                        foreach ($bannerImageData as $bannerImageElement) {
                            if ($bannerImageElement["document_image"] == '') {
                                $bannerImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                $bannerImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                $bannerImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $bannerImageElement["document_image"];
                                $bannerImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $bannerImageElement["document_image"];
                            }
                            $bannerImageDataWise[$bannerImageElement['document_type_id']][] = $bannerImageElement;
                        }
                    }
                }
            }
            if (!empty($bannerData)) {
                foreach ($bannerData as $vKey => $banner) {
                    $bannerData[$vKey]['created_at'] = isValidDate($banner['created_at']) ? YMDToDMY($banner["created_at"], true) : "";
                    $bannerData[$vKey]['updated_at'] = isValidDate($banner['updated_at']) ? YMDToDMY($banner["updated_at"], true) : "";
                    $bannerData[$vKey]['created_at_display'] = time_elapsed_string($banner['created_at']);
                    $bannerData[$vKey]['updated_at_display'] = time_elapsed_string($banner['updated_at']);
                    $bannerData[$vKey]["start_date_display"] = isValidDate($banner['start_date']) ? date('d F, Y', strtotime($banner["start_date"])) : "";
                    $bannerData[$vKey]["end_date_display"] = isValidDate($banner['end_date']) ? date('d F, Y', strtotime($banner["end_date"])) : "";
                    $bannerData[$vKey]['banner_image_data'] = array_key_exists($banner['banner_id'], $bannerImageDataWise) ? $bannerImageDataWise[$banner['banner_id']] : array();
                }
            }
            if (!empty($bannerData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.banner_listing_successfully'),
                    'data' => $bannerData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $bannerData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getDashboardData()
    {
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $isCustomerApp = $this->request->getVar('is_customer_app');
        $appType = $this->request->getVar('app_type');
        $deviceId = $this->request->getVar('device_id');
        $filterType = $this->request->getVar('filter_type');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {

            if(empty($filterType)){
                $filterType = 'all';
            }

            // banner Data
            if(($filterType == 'all') || ($filterType == 'banner_data') ){
                if(($appType == MEMBER_APP) || ($appType == MANAGER_APP) ){
                    $filterArray = array(
                        'is_multiple' => 1,
                        'is_active' => 1,
                        'society_id' => $societyId,
                        'date_greater_than_equal_to' => TODAY_DATE_YMD,
                    );
                    $bannerData = $this->bannerModel->getBannerData($filterArray);
                    $bannerImageDataWise = array();
                    $bannerIdArray = array();
                    $ownershipMemberFlatData = array();
                    if (!empty($bannerData)) {
                        foreach ($bannerData as $bannerElement) {
                            $bannerIdArray[] = $bannerElement['banner_id'];
                        }
                        if (!empty($bannerIdArray)) {
                            $bannerImageData = $this->visitorModel->getDocumentImageData(array(
                                "document_type_id" => $bannerIdArray,
                                "document_type" => 'banner',
                                "is_multiple" => 1
                            ));
                            if (!empty($bannerImageData)) {
                                foreach ($bannerImageData as $bannerImageElement) {
                                    if ($bannerImageElement["document_image"] == '') {
                                        $bannerImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                        $bannerImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                                    } else {
                                        $bannerImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $bannerImageElement["document_image"];
                                        $bannerImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $bannerImageElement["document_image"];
                                    }
                                    $bannerImageDataWise[$bannerImageElement['document_type_id']][] = $bannerImageElement;
                                }
                            }
                        }
                    }
                    if (!empty($bannerData)) {
                        foreach ($bannerData as $vKey => $banner) {
                            $bannerData[$vKey]['created_at'] = isValidDate($banner['created_at']) ? YMDToDMY($banner["created_at"], true) : "";
                            $bannerData[$vKey]['updated_at'] = isValidDate($banner['updated_at']) ? YMDToDMY($banner["updated_at"], true) : "";
                            $bannerData[$vKey]['created_at_display'] = time_elapsed_string($banner['created_at']);
                            $bannerData[$vKey]['updated_at_display'] = time_elapsed_string($banner['updated_at']);
                            $bannerData[$vKey]["start_date_display"] = isValidDate($banner['start_date']) ? date('d F, Y', strtotime($banner["start_date"])) : "";
                            $bannerData[$vKey]["end_date_display"] = isValidDate($banner['end_date']) ? date('d F, Y', strtotime($banner["end_date"])) : "";
                            $bannerData[$vKey]['banner_image_data'] = array_key_exists($banner['banner_id'], $bannerImageDataWise) ? $bannerImageDataWise[$banner['banner_id']] : array();
                        }
                    }
                    $data['banner_data'] = $bannerData;
                }
            }

            // legend Data
            if(($filterType == 'all') || ($filterType == 'legend_data') || ($filterType == 'my_visitor')){
                if($appType == MEMBER_APP){

                    $legendsData = array(
                        array(
                            'id' => 'entered',
                            'name' => 'Entered',
                            'color_code' => ENTERED_COLOR_CODE,
                        ),
                        array(
                            'id' => 'entry_pre_approve',
                            'name' => 'Entry Pre Approve',
                            'color_code' => ENTERED_COLOR_CODE,
                        ),
                        array(
                            'id' => 'collected',
                            'name' => 'Collected',
                            'color_code' => ENTERED_COLOR_CODE,
                        ),
                        array(
                            'id' => 'delivered',
                            'name' => 'Delivered',
                            'color_code' => EXITED_COLOR_CODE,
                        ),
                        array(
                            'id' => 'exited',
                            'name' => 'Exited',
                            'color_code' => EXITED_COLOR_CODE,
                        ),
                        array(
                            'id' => 'approval_rejected',
                            'name' => 'Approval Rejected',
                            'color_code' => EXITED_COLOR_CODE,
                        ),
                        array(
                            'id' => 'approval_pending',
                            'name' => 'APPROVAL Pending',
                            'color_code' => PENDING_COLOR_CODE,
                        )
                    );

                    $legendsDataIdWise = array();
                    if (!empty($legendsData)) {
                        foreach ($legendsData as $legendsElement) {
                            $legendsDataIdWise[$legendsElement['id']] = $legendsElement;
                        }
                    }
                    $visitorFilterArray = array(
                        'is_multiple' => 1,
                        'is_deleted' => 0,
                        'date_greater_than_equal_to' => TODAY_DATE_YMD,
                    );

                    if (!empty($isCustomerApp)) {
                        $visitorFilterArray['ownership_flat_member_id'] = $ownershipFlatMemberId;
                        $visitorFilterArray['ownership_flat_id'] = $ownershipFlatId;
                        $ownershipMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'is_active' => 1
                        ));
                    }
                    $visitorData = $this->visitorModel->getVisitorData($visitorFilterArray);
                    $objectFilterData = array(
                        'flat_id' => array('flat_id', 'tower_flat_name'),
                        'ownership_flat_member_id' => array('ownership_flat_member_id', 'name'),
                        'ownership_flat_parking_id' => array('ownership_flat_parking_id', 'parking_slot_no', 'number'),
                        'visitor_company_id' => array('visitor_company_id', 'visitor_company_name'),
                    );
                    $visitorDocumentDataWise = array();
                    $visitorWorkingDayDataWise = array();
                    $visitorIdArray = array();
                    if (!empty($visitorData)) {
                        foreach ($visitorData as $visitorElement) {
                            $visitorIdArray[] = $visitorElement['visitor_id'];
                        }
                        if (!empty($visitorIdArray)) {
                            $visitorWorkingDayData = $this->visitorModel->getVisitorWorkingDayData(array(
                                "visitor_id" => $visitorIdArray,
                                "is_multiple" => 1
                            ));
                            if (!empty($visitorWorkingDayData)) {
                                foreach ($visitorWorkingDayData as $visitorWorkingElement) {
                                    $visitorWorkingDayDataWise[$visitorWorkingElement['visitor_id']][] = $visitorWorkingElement;
                                }
                            }
                            $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                                "document_type_id" => $visitorIdArray,
                                "document_type" => 'visitor',
                                "is_multiple" => 1
                            ));
                            if (!empty($visitorImageData)) {
                                foreach ($visitorImageData as $visitorImageElement) {
                                    if ($visitorImageElement["document_image"] == '') {
                                        $visitorImageElement["thumbnail_document_image"] = '';
                                        $visitorImageElement["document_image"] = '';
                                    } else {
                                        $visitorImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $visitorImageElement["document_image"];
                                        $visitorImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageElement["document_image"];
                                    }
                                    $visitorDocumentDataWise[$visitorImageElement['document_type_id']][] = $visitorImageElement;
                                }
                            }
                        }
                    }
                    if (!empty($visitorData)) {
                        foreach ($visitorData as $vKey => $visitor) {
                            $visitorData[$vKey] = getModuleObjectData($objectFilterData, $visitor);
                            $visitorData[$vKey]['color_code'] = array_key_exists($visitor['status'], $legendsDataIdWise) ? $legendsDataIdWise[$visitor['status']]['color_code'] : '';
                            if ($visitor['status'] == 'entered' || $visitor['status'] == 'exited') {
                                $endDate = isValidDate($visitor['end_date']) ? $visitor['end_date'] : date("Y-m-d H:i:s");
                                $visitorData[$vKey]['difference_start_end_date'] = calculateDateTimeDifference($visitor['start_date'], $endDate);
                            }
                            $visitorData[$vKey]['created_at'] = isValidDate($visitor['created_at']) ? YMDToDMY($visitor["created_at"], true) : "";
                            $visitorData[$vKey]['updated_at'] = isValidDate($visitor['updated_at']) ? YMDToDMY($visitor["updated_at"], true) : "";
                            $visitorData[$vKey]['visitor_type_display'] = underscoreToUcWord($visitor["type"]);
                            $visitorData[$vKey]['status_display'] = underscoreToUcWord($visitor["status"]);
                            $visitorData[$vKey]['created_at_display'] = time_elapsed_string($visitor['created_at']);
                            $visitorData[$vKey]['updated_at_display'] = time_elapsed_string($visitor['updated_at']);
                            $visitorData[$vKey]["expected_start_date_time_display"] = isValidDate($visitor['expected_start_date_time']) ? date('d M, Y h:i A', strtotime($visitor["expected_start_date_time"])) : "";
                            $visitorData[$vKey]["expected_end_date_time_display"] = isValidDate($visitor['expected_end_date_time']) ? date('d M,Y h:i A', strtotime($visitor["expected_end_date_time"])) : "";
                            $visitorData[$vKey]["start_date_time_display"] = isValidDate($visitor['start_date']) ? date('d M, Y h:i A', strtotime($visitor["start_date"])) : "";
                            $visitorData[$vKey]["end_date_time_display"] = isValidDate($visitor['end_date']) ? date('d M, Y h:i A', strtotime($visitor["end_date"])) : "";
                            $visitorData[$vKey]["expected_start_date_display"] = isValidDate($visitor['expected_start_date_time']) ? date('d M, Y', strtotime($visitor["expected_start_date_time"])) : "";
                            $visitorData[$vKey]["expected_end_date_display"] = isValidDate($visitor['expected_end_date_time']) ? date('d M, Y', strtotime($visitor["expected_end_date_time"])) : "";
                            $visitorData[$vKey]["start_date_display"] = isValidDate($visitor['start_date']) ? date('d M, Y', strtotime($visitor["start_date"])) : "";
                            $visitorData[$vKey]["end_date_display"] = isValidDate($visitor['end_date']) ? date('d M, Y', strtotime($visitor["end_date"])) : "";
                            $path = site_url('uploads/no_image.png');
                            if ($visitor['id_proof'] != '' && file_exists(ID_PROOF_PATH . $visitor['id_proof'])) {
                                $path = site_url() . ID_PROOF_PATH . $visitor['id_proof'];
                            }
                            $visitorData[$vKey]['id_proof'] = $path;
                            $qrCodePath = '';
                            if ($visitor['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $visitor['qr_code_image'])) {
                                $qrCodePath = site_url() . QR_CODE_IMAGE_PATH . $visitor['qr_code_image'];
                            }
                            $visitorData[$vKey]['qr_code_image'] = $qrCodePath;
                            $visitorData[$vKey]['visitor_working_day_data'] = array_key_exists($visitor['visitor_id'], $visitorWorkingDayDataWise) ? $visitorWorkingDayDataWise[$visitor['visitor_id']] : array();
                            $visitorData[$vKey]['visitor_image_data'] = array_key_exists($visitor['visitor_id'], $visitorDocumentDataWise) ? $visitorDocumentDataWise[$visitor['visitor_id']] : array();
                            $shareData = array(
                                'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                                'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                                'share_image' => base_url('uploads/no_image.png'),
                                "share_link" => "https://digitattva.in/",
                                "share_qr_code_image" => $qrCodePath,
                            );
                            $visitorData[$vKey]['share_data'] = $shareData;
                        }
                    }
                    $data['my_visitor'] = $visitorData;

                    $notificationDevice = $this->commonWebserviceModel->getNotificationStoreList(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'society_id' => $societyId,
                        'device_id' => $deviceId,
                    ));

                    // printArray($societyId);
                    // printArray($notificationDevice,1);

                    if(empty($notificationDevice)){
                        $notificationTypeData = $this->commonWebserviceModel->getNotificationTypeData(array(
                            'is_multiple' => 1,
                        ));

                        if(!empty($notificationTypeData)){
                            $notificationArray = array();
                            foreach($notificationTypeData as $notificationElement){
                                $notificationTypeArray = array(
                                    'user_device_notification_config_id' => '',
                                    'device_id' => $deviceId,
                                    'society_id' => $societyId,
                                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                                    'notification_type_id' => $notificationElement['notification_type_id'],
                                    'is_enabled' => 1,
                                    'created_by' => $userSocietyId,
                                    'updated_by' => $userSocietyId,
                                    'created_at' => date("Y-m-d H:i:s"),
                                    'updated_at' => date("Y-m-d H:i:s"),
                                );
                                array_push($notificationArray, $notificationTypeArray);
                            }
                            // printArray($notificationArray);
                            $this->commonWebserviceModel->batchInsert($notificationArray, 'tbl_user_device_notification_config');
                        }
                    }
                }
            }

            // Visitor Data
            if (($filterType == 'all') || ($filterType == 'total_visitor')) {
                if($appType == GATE_KEEPER){
                    $visitorCountData = $this->visitorModel->getVisitorCountData(array('date_greater_than_equal_to' => TODAY_DATE_YMD, 'society_id' => $societyId));
                    $data['total_visitor'] = $visitorCountData;
                }
            }

            if (($filterType == 'all') || ($filterType == 'society_data')) {
                $societyData = $this->societyModel->getSocietyData(array('society_id' => $societyId));
                
                $societyImageData = $this->societyModel->getSocietyImageData(array(
                    "society_id" => $societyId,
                    "is_multiple" => 1
                ));
                $societyImagePath = site_url('uploads/no_image.png');
                if(!empty($societyImageData)){
                    foreach($societyImageData as $societyImage){
                        $societyImagePath = site_url('uploads/no_image.png');
                        if ($societyImage['society_image'] != '' && file_exists(site_url() . THUMBNAIL_SOCIETY_IMAGE_PATH . $societyImage['society_image'])) {
                            $societyImagePath = site_url() . THUMBNAIL_SOCIETY_IMAGE_PATH . $societyImage['society_image'];
                        }
                        $societyImageArr[] = array(
                            'society_iamge' => $societyImagePath
                        );
                    }
                }else {
                    $societyImageArr = [
                        'society_iamge' => $societyImagePath
                    ];
                }
                $societyData['society_image_data'] = $societyImageArr;
                $data['society_data'] = $societyData;
            }

            if (($filterType == 'all') || ($filterType == 'company_data')) {
                if ($appType == MEMBER_APP || $appType == GATE_KEEPER) {

                    // Company Data
                $visitorCompanyFilterArray = array(
                    'is_multiple' => 1,
                    'start' => 0,
                    'visitor_company_type' => 'taxi',
                    'is_active' => 1,
                );
                $visitorCompanyData = $this->visitorCompanyModel->getVisitorCompanyData($visitorCompanyFilterArray);
                $deliveryboyVisitorCompanyData = array();
                $taxiVisitorCompanyData = array();
                if (!empty($visitorCompanyData)) {
                    foreach ($visitorCompanyData as $bkey => $visitorCompany) {
                        $visitorCompanyData[$bkey]['created_at'] = YMDToDMY($visitorCompany["created_at"], true);
                        $visitorCompanyData[$bkey]['updated_at'] = YMDToDMY($visitorCompany["updated_at"], true);
                        $visitorCompanyData[$bkey]['visitor_company_type_display'] = underscoreToUcWord($visitorCompany["visitor_company_type"]);
                        $visitorCompanyData[$bkey]['created_at_display'] = time_elapsed_string($visitorCompany['created_at']);
                        $visitorCompanyData[$bkey]['updated_at_display'] = time_elapsed_string($visitorCompany['created_at']);
                        $path = site_url('uploads/no_image.png');
                        $thumbnailPath = site_url('uploads/no_image.png');
                        if ($visitorCompany['visitor_company_image'] != '' && file_exists(VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
                            $path = site_url() . VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
                        }
                        if ($visitorCompany['visitor_company_image'] != '' && file_exists(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
                            $thumbnailPath = site_url() . THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
                        }
                        $visitorCompanyData[$bkey]['thumbnail_visitor_company_image'] = $thumbnailPath;
                        $visitorCompanyData[$bkey]['visitor_company_image'] = $path;

                            // if($companyData[$bkey]['company_type'] == 'delivery_boy'){
                            //     $deliveryboyCompanyData[] = $companyData[$bkey];
                            // } else {
                            //     $taxiCompanyData[] = $companyData[$bkey];
                            // }
                        }
                        $data['taxi_visitor_company_data'] = $visitorCompanyData;
                    }

                    $visitorCompanyFilterArray = array(
                        'is_multiple' => 1,
                        'start' => 0,
                        'visitor_company_type' => 'delivery_boy',
                        'is_active' => 1,
                    );
                    $visitorCompanyData = $this->visitorCompanyModel->getVisitorCompanyData($visitorCompanyFilterArray);
                    $deliveryboyVisitorCompanyData = array();
                    $taxiVisitorCompanyData = array();
                    if (!empty($visitorCompanyData)) {
                        foreach ($visitorCompanyData as $bkey => $visitorCompany) {
                            $visitorCompanyData[$bkey]['created_at'] = YMDToDMY($visitorCompany["created_at"], true);
                            $visitorCompanyData[$bkey]['updated_at'] = YMDToDMY($visitorCompany["updated_at"], true);
                            $visitorCompanyData[$bkey]['visitor_company_type_display'] = underscoreToUcWord($visitorCompany["visitor_company_type"]);
                            $visitorCompanyData[$bkey]['created_at_display'] = time_elapsed_string($visitorCompany['created_at']);
                            $visitorCompanyData[$bkey]['updated_at_display'] = time_elapsed_string($visitorCompany['created_at']);
                            $path = site_url('uploads/no_image.png');
                            $thumbnailPath = site_url('uploads/no_image.png');
                            if ($visitorCompany['visitor_company_image'] != '' && file_exists(VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
                                $path = site_url() . VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
                            }
                            if ($visitorCompany['visitor_company_image'] != '' && file_exists(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'])) {
                                $thumbnailPath = site_url() . THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH . $visitorCompany['visitor_company_image'];
                            }
                            $visitorCompanyData[$bkey]['thumbnail_visitor_company_image'] = $thumbnailPath;
                            $visitorCompanyData[$bkey]['visitor_company_image'] = $path;
                        }
                        $data['delivery_boy_visitor_company_data'] = $visitorCompanyData;
                    }
                }
            }

            // User Society Flat Data
            if ($appType == MEMBER_APP) {
                $filterArray = array(
                    'user_society_id' => $userSocietyId,
                );
                $userData = $this->commonWebserviceModel->getUserSocietyData($filterArray);
                if (!empty($userData)) {   
                    $phoneNumber = isset($userData['phone']) ? $userData['phone'] : -9;
                    $ownershipFlatMemberData = array();
                    $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'mobile_no' => $phoneNumber,
                    ));
                    if (!empty($flatMemberFoundData)) {
                        $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                        $ownershipFlatMemberIdFound = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;
                        if ($moduleType == 'ownership_flat') {
                            $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                'ownership_flat_member_id' => $ownershipFlatMemberIdFound,
                                'is_latest' => 1,
                                'is_active' => 1
                            ));
                            if (!empty($ownershipFlatMemberFoundData)) {
                                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                    'mobile_no' => $phoneNumber,
                                    'society_id' => $societyId,
                                    'is_latest' => 1,
                                    'is_multiple' => 1,
                                    'is_active' => 1
                                ));
                            }
                        } else if ($moduleType == 'rentals') {
                            $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                                'ownership_flat_member_id' => $ownershipFlatMemberIdFound,
                                'check_rental_start' => 1,
                                'is_active' => 1
                            ));
                            if (!empty($rentalMemberFoundData)) {
                                $ownershipFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
                                    'mobile_no' => $phoneNumber,
                                    'society_id' => $societyId,
                                    'is_multiple' => 1,
                                    'is_active' => 1
                                ));
                            }
                        }
                    }
                }
                $data['user_society_flat_data'] = $ownershipFlatMemberData;
            }

            if (($appType == MEMBER_APP) || ($appType == MANAGER_APP)) {
                $recordData = array(
                    'no_of_recording' => NO_OF_RECORDING,
                    'recording_limit' => RECORDING_LIMIT,
                );
                $data['record_data'] = $recordData;
            }

            if (($appType == GATE_KEEPER) || ($appType == MANAGER_APP)) {
                $societyData = $this->societyModel->getSocietyData(array(
                    'society_id' => $societyId,
                ));
                $data['user_logged_society'] = $societyData;
            }

            if ($appType == MEMBER_APP) {
                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'society_id' => $societyId,
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                ));
                $data['user_logged_society'] = $ownershipFlatMemberData;
            }

            // Tower Data
            // if(($filterType == 'all') || ($filterType == 'tower_data') ) {
            //     if($appType == MEMBER_APP){
            //         $start = 0;
            //         $filterArray = array(
            //             'is_multiple' => 1,
            //             'start' => $start,
            //             'society_id' => $societyId,
            //             'is_active' => 1,
            //         );
            //         $towerData = $this->towerModel->getTowerData($filterArray);
            //         $data['tower_data'] = $towerData;
            //     }
            // }

            // food Data
            if(($filterType == 'all') || ($filterType == 'food_data')) {
                if($appType == MEMBER_APP){
                    $data['food_data'] = foodLikeApi();
                }
            }

            // vehicle Data
            if(($filterType == 'all') || ($filterType == 'vehicle_type_data')) {
                if($appType == MEMBER_APP){
                    $data['vehicle_type_data'] = vehicleTypeApi();
                }
            }

            // Blood Group Type Data
            if(($filterType == 'all') || ($filterType == 'blood_group_type_data')) {
                if($appType == MEMBER_APP){
                    $data['blood_group_type_data'] = bloodGroupTypeAPI();
                }
            }

            // Relation Type Data
            if(($filterType == 'all') || ($filterType == 'relation_type_data')) {
                if($appType == MEMBER_APP){
                    $data['relation_type_data'] = relationAPI();
                }
            }

            // Source Type Data
            if(($filterType == 'all') || ($filterType == 'source_type_data')) {
                if($appType == MANAGER_APP){
                    $data['source_type_data'] = sourceAPI();
                }
            }

            // Complain category Data
            if(($filterType == 'all') || ($filterType == 'complain_category_data')) {
                // $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
                $filterArray = array(
                    'is_multiple' => 1,
                    'start' => -1,
                    // 'search' => $search,
                    'category_for' => "complain",
                    'society_id' => $societyId,
                    'is_active' => 1,
                );
                $categoryData = $this->categoryModel->getCategoryData($filterArray);
                if (!empty($categoryData)) {
                    foreach ($categoryData as $bkey => $category) {
                        $categoryData[$bkey]['created_at'] = YMDToDMY($category["created_at"], true);
                        $categoryData[$bkey]['updated_at'] = YMDToDMY($category["updated_at"], true);
                        $categoryData[$bkey]['created_at_display'] = time_elapsed_string($category['created_at']);
                        $categoryData[$bkey]['updated_at_display'] = time_elapsed_string($category['created_at']);
                        $path = site_url('uploads/no_image.png');
                        $thumbnailPath = site_url('uploads/no_image.png');
                        if ($category['category_image'] != '' && file_exists(CATEGORY_IMAGE_PATH . $category['category_image'])) {
                            $path = site_url() . CATEGORY_IMAGE_PATH . $category['category_image'];
                        }
                        if ($category['category_image'] != '' && file_exists(THUMBNAIL_CATEGORY_IMAGE_PATH . $category['category_image'])) {
                            $thumbnailPath = site_url() . THUMBNAIL_CATEGORY_IMAGE_PATH . $category['category_image'];
                        }
                        $categoryData[$bkey]['thumbnail_category_image'] = $thumbnailPath;
                        $categoryData[$bkey]['category_image'] = $path;
                    }
    
                    $data['complain_category_data'] = $categoryData;
                }
            }

            // Status Data
            $statusArray = array(
                'is_multiple' => 1,
                'start' => -1,
                'is_active' => 1,
            );
            $statusData = $this->statusModel->getStatusData($statusArray);

            $complainStatusData = [];
            $sosEmergencyStatusData = [];
            $rentalsStatusData = [];

            if(!empty($statusData)){
                foreach ($statusData as $statusElement) {
                    if ($statusElement['status_for'] === 'complain') {
                        $complainStatusData[] = $statusElement;
                    } elseif ($statusElement['status_for'] === 'sos_emergency') {
                        $sosEmergencyStatusData[] = $statusElement;
                    } elseif ($statusElement['status_for'] === 'rentals') {
                        $rentalsStatusData[] = $statusElement;
                    }
                }
            }

            $data['complain_status_data'] = $complainStatusData;
            $data['sos_emergency_status_data'] = $sosEmergencyStatusData;
            $data['rentals_status_data'] = $rentalsStatusData;

            if(($filterType == 'all') || ($filterType == 'generator_data')) {
                if($appType == MANAGER_APP){
                    $filterArray = array(
                        'is_multiple' => 1,
                        'is_active' => 1,
                        'start' => 0,
                        // 'search' => $search,
                        // 'generator_id' => $generatorId,
                        'society_id' => $societyId,
                        'user_society_id' => $userSocietyId,
                    );
                    $generatorData = $this->generatorModel->getGeneratorData($filterArray);
                    if (!empty($generatorData)) {
                        foreach ($generatorData as $gKey => $generatorElement) {
                            $generatorData[$gKey]['created_at'] = isValidDate($generatorElement['created_at']) ? YMDToDMY($generatorElement["created_at"], true) : "";
                            $generatorData[$gKey]['updated_at'] = isValidDate($generatorElement['updated_at']) ? YMDToDMY($generatorElement["updated_at"], true) : "";
                            $generatorData[$gKey]['created_at_display'] = time_elapsed_string($generatorElement['created_at']);
                            $generatorData[$gKey]['updated_at_display'] = time_elapsed_string($generatorElement['updated_at']);
                        }
                    }
                    $data['generator_data'] = $generatorData;
                }
            }

            if(($filterType == 'all') || ($filterType == 'water_tank_data')) {
                if($appType == MANAGER_APP){
                    $filterArray = array(
                        'is_multiple' => 1,
                        'start' => 0,
                        // 'search' => $search,
                        // 'water_tank_id' => $waterTankId,
                        // 'water_meter_reading_id' => $waterMeterReadingId,
                        'society_id' => $societyId,
                        'is_active' => 1,
                        // 'is_api' => 1,
                    );
                    $waterTankData = $this->waterTankModel->getWaterTankData($filterArray);
                    $data['water_tank_data'] = $waterTankData;
                }
            }

            if(($filterType == 'all') || ($filterType == 'resource_type')) {
                $resourceTypeData = $this->resourceModel->getResourceCountData(array(
                    'society_id' => $societyId,
                    'is_multiple' => 1,
                    'is_helper' => 1,
                    'is_active' => 1,
                ));
                
                $data['resource_type'] = $resourceTypeData;
            }
            if($filterType == 'all'){
                $data['request_timer'] = REQUEST_TIMER;
            }
            
            if (!empty($data)) {
                $dashboardData = array(
                    'status' => true,
                    'message' => lang('CommonWebService.dashboard_listing_successfully'),
                    'data' => $data,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($dashboardData, 200);
            } else {
                $dashboardData = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => array(),
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($dashboardData, 404);
            }
        }
    }

    public function getProfileList() // Not
    {
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $profileData = array();
            $resourceTypeGuardData = $this->resourceTypeModel->getResourceTypeData(array(
                'is_guard' => 1,
                'is_multiple' => 1,
                'is_login' => 1,
                'is_active' => 1,
                'society_id' => $societyId,
            ));
            $resourceTypeIdArray = [];
            if (!empty($resourceTypeGuardData)) {
                foreach ($resourceTypeGuardData as $resourceTypeElement) {
                    $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                }
            }
            $type = '';
            $typeId = '';
            $filterArray = array(
                'society_id' => $societyId,
                'user_society_id' => $userSocietyId,
                'resource_type_id' => $resourceTypeIdArray,
            );
            $userSocietyData = $this->ionAuthModel->getUserSocietyWiseData($filterArray);

            $type = isset($userSocietyData['type']) ? $userSocietyData['type'] : '';
            $typeId = isset($userSocietyData['type_id']) ? $userSocietyData['type_id'] : '';
            if ($type == GATE_KEEPER) {
                $profileData = $this->resourceModel->getResourceData(array("resource_id" => $typeId, 'society_id' => $societyId,'is_helper' => 1));
                if (!empty($profileData)) {
                    $profileData['date_of_birth'] = isset($profileData['date_of_birth']) ? YMDToDMY($profileData["date_of_birth"]) : "";
                    $profileData['working_hours'] = "10:00 AM To 07:00 PM";
                    $profileData['support_number'] = "-";
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $typeId,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $siKey => $resourceImageElement) {
                            $paths = '';
                            $thumbnailPaths = '';
                            if (file_exists(THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'])) {
                                $paths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'];
                            }
                            if (file_exists(THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'])) {
                                $thumbnailPaths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'];
                            }
                            $resourceImageData[$siKey]['thumbnail_document_image'] = $thumbnailPaths;
                            $resourceImageData[$siKey]['document_image'] = $paths;
                        }
                    }
                    $profileData['resource_image_data'] = $resourceImageData;
                }
            }
            if (!empty($profileData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.profile_listing_successfully'),
                    'data' => $profileData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $profileData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }


    public function editProfile() // Not
    {
        $this->db->transStart();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $resourceId = $this->request->getVar('resource_id');
        $resourceName = $this->request->getVar('resource_name');
        $resourceImage = $this->request->getVar('resource_image[]');
        $this->validation->setRule('resource_id', lang('CommonWebService.resource_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $resourceImageData = array();
            if (isset($_FILES["resource_image"])) {
                $resourceImagePath = DOCUMENT_IMAGE_PATH;
                $resourceImageData = $dt_ci_file_upload->UploadMultipleFile('resource_image', MAX_IMAGE_SIZE_LIMIT, $resourceImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($resourceImageData['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($resourceImageData['message']),
                        'data' => null
                    ), 404);
                }
                else{
                    unset($resourceImageData['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($resourceImageData, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
            }

            $resourceUpdateArray = array();
            $resourceArray = array(
                'resource_id' => $resourceId,
                'resource_name' => $resourceName,
                'is_guard' => 1,
                'is_active' => 1,
            );
            if (!empty($resourceId)) {
                $resourceUpdateArray = $this->resourceModel->getResourceData(array(
                    'resource_id' => $resourceId,
                ));
                $resourceUpdateArray = compareArray($resourceArray, $resourceUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $resourceData = $this->commonWebserviceModel->insertUpdateRecord($resourceArray, 'resource_id', 'tbl_resource', 1, '', array(), $extraData, $resourceUpdateArray);
            $lastResourceId = $resourceData['lastInsertedId'];


            $userUpdateArray = array();
            $userArray = array(
                'user_society_id' => $userSocietyId,
                'first_name' => $resourceName,
            );
            if (!empty($userSocietyId)) {
                $userUpdateArray = $this->commonWebserviceModel->getUserSocietyData(array(
                    'user_society_id' => $userSocietyId,
                ));
                $userUpdateArray = compareArray($userArray, $userUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $userData = $this->commonWebserviceModel->insertUpdateRecord($userArray, 'user_society_id', 'tbl_user_society', 1, '', array(), $extraData, $userUpdateArray);
            $lastUserSocietyId = $userData['lastInsertedId'];


            // resource Multiple Image Store
            if ($lastResourceId != '') {
                if (isset($resourceImageData) && count($resourceImageData) > 0) {
                    $batchArray = array();
                    unset($resourceImageData['success']);
                    foreach ($resourceImageData as $key => $imageData) {
                        $dataArray = array(
                            'document_image_id' => '',
                            'document_type' => 'resource',
                            'document_type_id' => $lastResourceId,
                            'document_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                            'created_by' => $userSocietyId,
                            'updated_by' => $userSocietyId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $resourceExtraDataArray = array();
                    $resourceExtraDataArray['module_id'] = $lastResourceId;
                    $resourceExtraDataArray['module'] = 'Resource Image';
                    $resourceExtraDataArray['type'] = 'Resource';
                    $resourceExtraDataArray['old_data'] = '';
                    $resourceExtraDataArray['user_society_id'] = $userSocietyId;
                    $resourceExtraDataArray['society_id'] = $societyId;
                    $this->commonWebserviceModel->batchInsert($batchArray, 'tbl_document_image', $resourceExtraDataArray);
                }
            }
            $transactionStatus = $this->db->transComplete();
            if ((isset($resourceData['success']) && $resourceData['success']) && ($transactionStatus == 1)) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.edit_profile')),
                    'data' => null
                ), 200);
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.edit_profile')),
                    'data' => null
                ), 404);
            }
        }
    }

    public function addEditVehicle()
    {
        $this->db->transStart();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');
        $vehicleType = $this->request->getVar('vehicle_type');
        $vehicleNo = $this->request->getVar('vehicle_no');
        $parkingSlotId = $this->request->getVar('parking_slot_id');
        $tokenNo = $this->request->getVar('token_no');
        $isElectric = $this->request->getVar('is_electric');
        $vehicleImage = $this->request->getVar('vehicle_image');

        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('vehicle_type', lang('CommonWebService.vehicle_type'), 'required');
        $this->validation->setRule('vehicle_no', lang('CommonWebService.vehicle_no'), 'required');
        $this->validation->setRule('is_electric', lang('CommonWebService.is_electric'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            if (isset($_FILES["vehicle_image"])) {
                $vehicleImagePath = VEHICLE_IMAGE_PATH;
                $vehicleImageResult = $dt_ci_file_upload->uploadFile('vehicle_image', MAX_IMAGE_SIZE_LIMIT, $vehicleImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($vehicleImageResult['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($vehicleImageResult['message']),
                        'data' => null
                    ), 404);
                } else {
                    $vehicleImageRecord = $vehicleImageResult['file_name'];
                    // else{
                        unset($vehicleImageResult['success']);
                        $thumbnailResult =  $dt_ci_file_upload->ThumbnailUploadFile($vehicleImageResult, VEHICLE_IMAGE_PATH, THUMBNAIL_VEHICLE_IMAGE_PATH);
                    // }
                }
            }

            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'is_show_all_member' => 1,
                'is_active' => 1
            ));

            $type = isset($ownershipFlatMemberData['type']) ? $ownershipFlatMemberData['type'] : '';
            $typeId = isset($ownershipFlatMemberData['type_id']) ? $ownershipFlatMemberData['type_id'] : 0;
            $ownershipFlatId = isset($ownershipFlatMemberData['ownership_flat_id']) ? $ownershipFlatMemberData['ownership_flat_id'] : 0;

            $ownershipFlatParkingUpdateArray = array();
            $ownershipFlatParkingArray = array(
                'ownership_flat_parking_id' => $ownershipFlatParkingId,
                'type' => $type,
                'type_id' => $typeId,
                'vehicle_type' => $vehicleType,
                'vehicle_no' => $vehicleNo,
                'parking_slot_id' => $parkingSlotId,
                'token_no' => $tokenNo,
                'is_electric' => $isElectric,
                'ownership_flat_id' => $ownershipFlatId,
            );
            if (isset($vehicleImageRecord)) {
                if ($ownershipFlatParkingId != '') {
                    $ownershipFlatParkingData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array('ownership_flat_parking_id' => $ownershipFlatParkingId,'is_show_all_parking' => 1));
                    if ($ownershipFlatParkingData['vehicle_image'] != '' && file_exists(VEHICLE_IMAGE_PATH . $ownershipFlatParkingData['vehicle_image'])) {
                        unlink(VEHICLE_IMAGE_PATH . $ownershipFlatParkingData['vehicle_image']);
                    }
                    if ($ownershipFlatParkingData['vehicle_image'] != '' && file_exists(THUMBNAIL_VEHICLE_IMAGE_PATH . $ownershipFlatParkingData['vehicle_image'])) {
                        unlink(THUMBNAIL_VEHICLE_IMAGE_PATH . $ownershipFlatParkingData['vehicle_image']);
                    }
                }
                $ownershipFlatParkingArray['vehicle_image'] = $vehicleImageRecord;
            }
            if (!empty($ownershipFlatParkingId)) {
                $ownershipFlatParkingUpdateArray = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                    'ownership_flat_parking_id' => $ownershipFlatParkingId,
                    'is_show_all_parking' => 1
                ));
                $ownershipFlatParkingUpdateArray = compareArray($ownershipFlatParkingArray, $ownershipFlatParkingUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;

            // printArray($ownershipFlatParkingArra,1);
            $ownershipFlatParkingData = $this->commonWebserviceModel->insertUpdateRecord($ownershipFlatParkingArray, 'ownership_flat_parking_id', 'tbl_ownership_flat_parking', 1, '', array(), $extraData, $ownershipFlatParkingUpdateArray);
            $lastOwnershipFlatParkingId = $ownershipFlatParkingData['lastInsertedId'];


            $vehicleInsertData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                'ownership_flat_parking_id' => $lastOwnershipFlatParkingId,
            ));

            if (!empty($vehicleInsertData)) {
                $formattedVehicleType = getFunctionKeyValue($vehicleInsertData['vehicle_type'], vehicleType());
                $vehiclePath = site_url('uploads/no_image.png');
                $vehicleThumbnailPath = site_url('uploads/no_image.png');
                if ($vehicleInsertData['vehicle_image'] != '' && file_exists(VEHICLE_IMAGE_PATH . $vehicleInsertData['vehicle_image'])) {
                    $vehiclePath = site_url() . VEHICLE_IMAGE_PATH . $vehicleInsertData['vehicle_image'];
                }
                if ($vehicleInsertData['vehicle_image'] != '' && file_exists(THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicleInsertData['vehicle_image'])) {
                    $vehicleThumbnailPath = site_url() . THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicleInsertData['vehicle_image'];
                }
                $vehicleInsertData['vehicle_image'] = $vehiclePath;
                $vehicleInsertData['thumbnail_vehicle_image'] = $vehicleThumbnailPath;
                $vehicleInsertData['vehicle_type_display'] = underscoreToUcWord($vehicleInsertData["vehicle_type"]);
                $vehicleInsertData['vehicle_type'] = $formattedVehicleType;
                
            }

            $transactionStatus = $this->db->transComplete();

            if (isset($ownershipFlatParkingId) && !empty($ownershipFlatParkingId)) {
                if ((isset($ownershipFlatParkingData['success']) && $ownershipFlatParkingData['success']) && ($transactionStatus == 1)) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.vehicle')),
                        'data' => $vehicleInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.vehicle')),
                        'data' => null
                    ), 404);
                }
            } else {
                if ((isset($ownershipFlatParkingData['success']) && $ownershipFlatParkingData['success']) && ($transactionStatus == 1)) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.vehicle')),
                        'data' => $vehicleInsertData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.vehicle')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function getVehicleList()
    {
        $appType = $this->request->getVar('app_type');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $start = $this->request->getVar('start');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $type = $this->request->getVar('type');
        $appType = $this->request->getVar('app_type');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');

        if($appType == MEMBER_APP){
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        else {
            $this->validation->setRule('ownership_flat_id', lang('CommonWebService.ownership_flat_id'), 'required');
            $this->validation->setRule('type', lang('CommonWebService.type'), 'required');
        }
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);

            if($appType == MEMBER_APP){
                $filterArray = array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_show_all_member' => 1,
                    'is_active' => 1,
                );
                $vehicleData = array();
                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData($filterArray);
                if (!empty($ownershipFlatMemberData)) {
                    $type = isset($ownershipFlatMemberData['type']) ? $ownershipFlatMemberData['type'] : '';
                    $typeId = isset($ownershipFlatMemberData['type_id']) ? $ownershipFlatMemberData['type_id'] : 0;
                    $vehicleData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                        'search' => $search,
                        'type' => $type,
                        'type_id' => $typeId,
                        'start' => $start,
                        'ownership_flat_parking_id' => $ownershipFlatParkingId,
                        'is_multiple' => 1,
                        'is_show_all_parking' => 1
                    ));
                }
            }
            else{
                $vehicleData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                    'search' => $search,
                    'type' => $type,
                    'type_id' => $ownershipFlatId,
                    'start' => $start,
                    'ownership_flat_parking_id' => $ownershipFlatParkingId,
                    'is_multiple' => 1,
                    'is_show_all_parking' => 1
                ));
            }

            if (!empty($vehicleData)) {
                foreach ($vehicleData as $vKey => $vehicle) {
                    $formattedVehicleType = getFunctionKeyValue($vehicle['vehicle_type'], vehicleType());
                    $vehiclePath = site_url('uploads/no_image.png');
                    $vehicleThumbnailPath = site_url('uploads/no_image.png');
                    if ($vehicle['vehicle_image'] != '' && file_exists(VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'])) {
                        $vehiclePath = site_url() . VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'];
                    }
                    if ($vehicle['vehicle_image'] != '' && file_exists(THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'])) {
                        $vehicleThumbnailPath = site_url() . THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'];
                    }
                    $vehicleData[$vKey]['vehicle_image'] = $vehiclePath;
                    $vehicleData[$vKey]['thumbnail_vehicle_image'] = $vehicleThumbnailPath;
                    $vehicleData[$vKey]['vehicle_type_display'] = underscoreToUcWord($vehicle["vehicle_type"]);
                    $vehicleData[$vKey]['vehicle_type'] = $formattedVehicleType;
                }
            }

            if (!empty($vehicleData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.vehicle_listing_successfully'),
                    'data' => $vehicleData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $vehicleData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getMyVehicleList()
    {
        $appType = $this->request->getVar('app_type');
        $search = $this->request->getVar('search');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $start = $this->request->getVar('start');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $type = $this->request->getVar('type');
        $appType = $this->request->getVar('app_type');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');

        // if($appType == MEMBER_APP){
        //     $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        // }
        // else {
            $this->validation->setRule('ownership_flat_id', lang('CommonWebService.ownership_flat_id'), 'required');
            $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
            $this->validation->setRule('type', lang('CommonWebService.type'), 'required');
        // }
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $vehicleData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                'search' => $search,
                'type' => $type,
                'ownership_flat_id' => $ownershipFlatId,
                'start' => $start,
                'ownership_flat_parking_id' => $ownershipFlatParkingId,
                'is_multiple' => 1,
                'is_show_all_parking' => 1,
            ));
            $parkingSlotIdArray = [];
            $filteredParkingSlotData = [];
            if (!empty($vehicleData)) {
                foreach ($vehicleData as $vKey => $vehicle) {
                    $parkingSlotIdArray[] = $vehicle['parking_slot_id'];
                    $formattedVehicleType = getFunctionKeyValue($vehicle['vehicle_type'], vehicleType());
                    $vehiclePath = site_url('uploads/no_image.png');
                    $vehicleThumbnailPath = site_url('uploads/no_image.png');
                    if ($vehicle['vehicle_image'] != '' && file_exists(VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'])) {
                        $vehiclePath = site_url() . VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'];
                    }
                    if ($vehicle['vehicle_image'] != '' && file_exists(THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'])) {
                        $vehicleThumbnailPath = site_url() . THUMBNAIL_VEHICLE_IMAGE_PATH . $vehicle['vehicle_image'];
                    }
                    $vehicleData[$vKey]['vehicle_image'] = $vehiclePath;
                    $vehicleData[$vKey]['thumbail_vehicle_image'] = $vehicleThumbnailPath;
                    $vehicleData[$vKey]['vehicle_type_display'] = underscoreToUcWord($vehicle["vehicle_type"]);
                    $vehicleData[$vKey]['vehicle_type'] = $formattedVehicleType;
                }
            }

            if($type == 'ownership_flat'){
                $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatData(array(
                    'ownership_flat_id' => $ownershipFlatId,
                ));
            }
            else{
                $ownershipFlatData = $this->rentalModel->getRentalsData(array(
                    'ownership_flat_id' => $ownershipFlatId,
                ));
            }

            // if(!empty($ownershipFlatData)){
            //     $parkingPlaceData = $this->parkingPlaceModel->getParkingPlaceData(array(
            //         'flat_id' => $ownershipFlatData['flat_id'],
            //         'is_multiple' => 1
            //     ));

            //     if(!empty($parkingPlaceData)){
            //         foreach ($parkingPlaceData as $parkingPlaceElement) {
            //             if (!in_array($parkingPlaceElement['parking_place_id'], $parkingPlaceIdArray)) {
            //                 $filteredParkingPlaceData[] = $parkingPlaceElement;
            //             }
            //         }
            //     }
            // }
            $vehicleDataMerge = array_merge($vehicleData,$filteredParkingSlotData);
            if (!empty($vehicleDataMerge)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.vehicle_listing_successfully'),
                    'data' => $vehicleDataMerge,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $vehicleDataMerge,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getMemberList()
    {
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $search = $this->request->getVar('search');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $memberId = $this->request->getVar('member_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                
                'is_show_all_member' => 1,
                'is_active' => 1
            );
            $memberData = array();
            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData($filterArray);
            if (!empty($ownershipFlatMemberData)) {
                $memberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'type' => $ownershipFlatMemberData['type'],
                    'type_id' => $ownershipFlatMemberData['type_id'],
                    'member_id' => $memberId,
                    'ownership_flat_member_id_not' => $ownershipFlatMemberId,
                    'search' => $search,
                    'is_show_all_member' => 1,
                    'is_active' => 1,
                    'is_multiple' => 1
                ));
            }
            if (!empty($memberData)) {
                foreach ($memberData as $vKey => $member) {
                    $formattedRelation = getFunctionKeyValue($member['relation'], relation());
                    $formattedFoodLike = getFunctionKeyValue($member['food_like'], foodLike());
                    $formattedBloodGroup = getFunctionKeyValue($member['blood_group'], bloodGroupType());
                    $memberPath = site_url('uploads/no_image.png');
                    $memberThumbnailPath = site_url('uploads/no_image.png');
                    if ($member['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $memberPath = site_url() . FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    if ($member['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $memberThumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    $memberData[$vKey]['member_image'] = $memberPath;
                    $memberData[$vKey]['thumbnail_member_image'] = $memberThumbnailPath;
                    $memberData[$vKey]['gender_display'] = underscoreToUcWord($member["gender"]);
                    $memberData[$vKey]['relation'] = $formattedRelation;
                    $memberData[$vKey]['food_like'] = $formattedFoodLike;
                    $memberData[$vKey]['blood_group'] = $formattedBloodGroup;
                    $memberData[$vKey]['relation_display'] = underscoreToUcWord($member["relation"]);
                    $memberData[$vKey]['food_like_display'] = underscoreToUcWord($member["food_like"]);
                    $memberData[$vKey]['birth_date_display'] = isValidDate($member['birth_date']) ? YMDToDMY($member["birth_date"]) : "";
                }
            }
            if (!empty($memberData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.member_listing_successfully'),
                    'data' => $memberData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $memberData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function scanQRCode()
    {
        $qrCodeNumber = $this->request->getVar('qr_code_number');
        //$type = $this->request->getVar('type');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('qr_code_number', lang('CommonWebService.qr_code_number'), 'required');
        //$this->validation->setRule('type', lang('CommonWebService.type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {

            $type = '';
            $resourceData = array();
            $visitorData = $this->visitorModel->getVisitorData(array(
                'type' => $type,
                'qr_code_number' => $qrCodeNumber,
                'society_id' => $societyId,
            ));

            if (!empty($visitorData)) {
                $type = $visitorData['type'];
            }
            if (empty($visitorData)) {
                $resourceData = $this->resourceModel->getResourceData(array(
                    'qr_code_number' => $qrCodeNumber,
                    'society_id' => $societyId,
                    'is_helper' => 1,
                    'is_multiple' => 1
                ));
                if (!empty($resourceData)) {
                    $type = 'resource';
                }
            }

            $scanQRCodeData = array();

            if ($type == 'resource') {
                $resourceData = $this->resourceModel->getResourceData(array(
                    'qr_code_number' => $qrCodeNumber,
                    'society_id' => $societyId,
                    'is_helper' => 1,
                    'is_multiple' => 1
                ));
                // $objectFilterData = array(
                //     'category_id' => array('category_id', 'category_name'),
                // );
                $resourceFlatDataWise = array();
                // $resourceFlatAlreadyDataWise = array();
                $resourceDocumentDataWise = array();
                $resourceWorkingDayDataWise = array();
                $resourceIdArray = array();
                if (!empty($resourceData)) {
                    foreach ($resourceData as $resourceElement) {
                        $resourceIdArray[] = $resourceElement['resource_id'];
                    }
                    if (!empty($resourceIdArray)) {
                        // $resourceFlatAlreadyAddedData = $this->resourceModel->getResourceFlatData(array(
                        //     "resource_id" => $resourceIdArray,
                        //  'ownership_flat_member_id' => $ownershipFlatMemberId,
                        //  'is_deleted' => 0,
                        //     "is_multiple" => 1
                        // ));
                        // if(!empty($resourceFlatAlreadyAddedData)) {
                        //     foreach ($resourceFlatAlreadyAddedData as $resourceFlataddedElement) {
                        //         $resourceFlatAlreadyDataWise[$resourceFlataddedElement['resource_id']][] = $resourceFlataddedElement;
                        //     }
                        // }
                        $resourceFlatData = $this->resourceModel->getResourceFlatData(array(
                            "resource_id" => $resourceIdArray,
                            'is_deleted' => 0,
                            'is_helper' => 1,
                            "is_multiple" => 1
                        ));
                        if (!empty($resourceFlatData)) {
                            foreach ($resourceFlatData as $resourceFlatElement) {
                                $resourceFlatDataWise[$resourceFlatElement['resource_id']][] = $resourceFlatElement;
                            }
                        }
                        $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                            "document_type_id" => $resourceIdArray,
                            "document_type" => 'resource',
                            "is_multiple" => 1
                        ));
                        if (!empty($resourceImageData)) {
                            foreach ($resourceImageData as $resourceImageElement) {
                                if ($resourceImageElement["document_image"] == '') {
                                    $resourceImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                    $resourceImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                                } else {
                                    $resourceImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                    $resourceImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $resourceImageElement["document_image"];
                                }
                                $resourceDocumentDataWise[$resourceImageElement['document_type_id']][] = $resourceImageElement;
                            }
                        }
                    }
                }
                if (!empty($resourceData)) {
                    foreach ($resourceData as $vKey => $resource) {
                        // $resourceData[$vKey] = getModuleObjectData($objectFilterData, $resource);
                        $endDateStatus = isValidDate($resource['end_date']) ? date('Y-m-d', strtotime($resource['end_date'])) : '';
                        if ($resource['visitor_status'] == 'exited' && $endDateStatus != TODAY_DATE_YMD) {
                            $status = 'approved';
                            $visitorStatus = 'approved';
                        } else {
                            $status = $resource['visitor_status'];
                            $visitorStatus = $resource['visitor_status'];
                        }
                        $startDate = isValidDate($resource['start_date']) ? $resource['start_date'] : date("Y-m-d H:i:s");
                        $endDate = isValidDate($resource['end_date']) ? $resource['end_date'] : date("Y-m-d H:i:s");
                        $resourceData[$vKey]['difference_start_end_date'] = calculateDateTimeDifference($startDate, $endDate);
                        $resourceData[$vKey]["start_date_time_display"] = date('d M, Y h:i A', strtotime($startDate));
                        $resourceData[$vKey]["end_date_time_display"] = date('d M, Y h:i A', strtotime($endDate));
                        $resourceData[$vKey]["start_date_display"] = date('d M, Y', strtotime($startDate));
                        $resourceData[$vKey]["end_date_display"] = date('d M, Y', strtotime($endDate));
                        $resourceData[$vKey]['date_of_birth'] = isset($resource['date_of_birth']) ? YMDToDMY($resource["date_of_birth"]) : "";
                        // $resourceData[$vKey]["status"] = (isset($resource['status']) && $resource['status'] === 'approved') ? 'Not Arrived Yet' : $status;
                        $resourceData[$vKey]["visitor_status_display"] = (isset($resource['visitor_status']) && !empty($resource['visitor_status'])) ? underscoreToUcWord($status) : 'approved';
                        $resourceData[$vKey]['created_at'] = isValidDate($resource['created_at']) ? YMDToDMY($resource["created_at"], true) : "";
                        $resourceData[$vKey]['updated_at'] = isValidDate($resource['updated_at']) ? YMDToDMY($resource["updated_at"], true) : "";
                        $path = '';
                        if ($resource['qr_code_image'] != '' && file_exists(QR_CODE_IMAGE_PATH . $resource['qr_code_image'])) {
                            $path = site_url() . QR_CODE_IMAGE_PATH . $resource['qr_code_image'];
                        }
                        $resourceData[$vKey]['visitor_status'] = $visitorStatus;
                        $resourceData[$vKey]['qr_code_image'] = $path;
                        $resourceData[$vKey]['status_display'] = underscoreToUcWord($resource["status"]);
                        $resourceData[$vKey]['created_at_display'] = time_elapsed_string($resource['created_at']);
                        $resourceData[$vKey]['updated_at_display'] = time_elapsed_string($resource['updated_at']);
                        $resourceData[$vKey]['resource_flat_data'] = array_key_exists($resource['resource_id'], $resourceFlatDataWise) ? $resourceFlatDataWise[$resource['resource_id']] : array();
                        // $resourceData[$vKey]['resource_flat_already_added_data'] = array_key_exists($resource['resource_id'],$resourceFlatAlreadyDataWise) ? $resourceFlatAlreadyDataWise[$resource['resource_id']]: array();
                        $resourceData[$vKey]['visitor_image_data'] = array_key_exists($resource['resource_id'], $resourceDocumentDataWise) ? $resourceDocumentDataWise[$resource['resource_id']] : array();
                        $shareData = array(
                            'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                            'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                            'share_image' => base_url('uploads/no_image.png'),
                            "share_link" => "https://digitattva.in/",
                            "share_qr_code_image" => $path,
                        );
                        $resourceData[$vKey]['share_data'] = $shareData;
                    }
                }
                $scanQRCodeData = $resourceData;
            } else {
                $filterArray = array(
                    'type' => $type,
                    'qr_code_number' => $qrCodeNumber,
                    'society_id' => $societyId,
                    'is_multiple' => 1
                );
                $visitorData = visitorListData($filterArray, $userSocietyId);
                $scanQRCodeData = $visitorData;
            }

            if (!empty($type) && $type != 'resource') {
                $type = 'visitor';
            }
            if (!empty($scanQRCodeData)) {

                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.qr_code_scan_succesfully'),
                    'data' => $scanQRCodeData,
                    'limit' => DATA_LIMIT,
                    'type' => $type,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'type' => $type,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getNotificationTypeList()
    {
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {

            $filterArray = array(
                'is_multiple' => 1
            );
            $notificationTypeData = $this->commonWebserviceModel->getNotificationTypeData($filterArray);

            $notificationStoreArray = array(
                'society_id' => $societyId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'is_multiple' => 1
            );
            $notificationStoreData = $this->commonWebserviceModel->getNotificationStoreList($notificationStoreArray);

            $enabledMapping = array();
            if (!empty($notificationStoreData)) {
                foreach ($notificationStoreData as $store) {
                    $enabledMapping[$store['notification_type_id']] = $store['is_enabled'];
                }
            }

            // Update notification type data
            if (!empty($notificationTypeData)) {
                foreach ($notificationTypeData as &$notification) {
                    $notificationId = $notification['notification_type_id'];
                    if (isset($enabledMapping[$notificationId])) {
                        $notification['is_enabled'] = $enabledMapping[$notificationId];
                    } else {
                        $notification['is_enabled'] = 1;
                    }
                }
            }


            // printArray($notificationStoreData,1);
            if (!empty($notificationTypeData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.notification_type_listing_successfully'),
                    'data' => $notificationTypeData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $notificationTypeData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function notificationStore()
    {
        $this->db->transStart();
        $userSocietyId = $this->request->getVar('user_society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $societyId = $this->request->getVar('society_id');
        $deviceId = $this->request->getVar('device_id');
        $notificationTypeId = $this->request->getVar('notification_type_id');
        $isEnabled = $this->request->getVar('is_enabled');
        $notificationSettings = $this->request->getVar('notification_settings');

        $this->validation->setRule('notification_type_id', lang('CommonWebService.notification_type_id'), 'required');
        $this->validation->setRule('device_id', lang('CommonWebService.device_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            $notificationTypeIdArray =  array();
            $isEnabledArray =  array();
            if(isset($notificationSettings) && !empty($notificationSettings)){
                $notificationSettingsArr = json_decode($notificationSettings,true);
                // printArray($notificationSettingsArr,1);
                if(!empty($notificationSettingsArr)){
                    foreach ($notificationSettingsArr as $key => $notificationSettings){
                        $notificationTypeIdArray[] = $key;
                        $isEnabledArray[$key] = $notificationSettings;
                    }
                }
            }

            // printArray($isEnabledArray,1);

            $nsArray = array(
                'device_id' => $deviceId,
                // 'notification_type_id' => $notificationTypeId,
                'notification_type_id' => $notificationTypeIdArray,
                'society_id' => $societyId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'is_multiple' => 1
            );

            $notificationStoreData = $this->commonWebserviceModel->getNotificationStoreList($nsArray);

            // printArray($notificationStoreData,1);
            $userDeviceNotificationStoreIdArray = array();
            if (!empty($notificationStoreData)) {
                foreach ($notificationStoreData as $nsElement) {
                    $userDeviceNotificationStoreIdArray[] = $nsElement['user_device_notification_config_id'];
                }

                if (!empty($userDeviceNotificationStoreIdArray)) {
                    $this->commonWebserviceModel->deleteNotificationStoreRecord($userDeviceNotificationStoreIdArray, $userSocietyId, $societyId);
                }
            }

            $notificationConfigUpdateArray = array();
            $notificationConfigInsertArray = array();
            foreach($notificationTypeIdArray as $notiTypeId) {
                $notificationConfigInsertArray[] = array(
                    'user_device_notification_config_id' => '',
                    'device_id' => $deviceId,
                    'notification_type_id' => $notiTypeId,
                    'society_id' => $societyId,
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_enabled' => isset($isEnabledArray[$notiTypeId]) ? $isEnabledArray[$notiTypeId] : 1,
                );
            }

            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $notificationConfigData = $this->commonWebserviceModel->batchInsert($notificationConfigInsertArray, 'tbl_user_device_notification_config', array());

            $filterArray = array(
                'is_multiple' => 1
            );
            $notificationTypeData = $this->commonWebserviceModel->getNotificationTypeData($filterArray);

            $notificationStoreArray = array(
                'society_id' => $societyId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'is_multiple' => 1
            );
            $notificationStoreData = $this->commonWebserviceModel->getNotificationStoreList($notificationStoreArray);

            $enabledMapping = array();
            if (!empty($notificationStoreData)) {
                foreach ($notificationStoreData as $store) {
                    $enabledMapping[$store['notification_type_id']] = $store['is_enabled'];
                }
            }

            if (!empty($notificationTypeData)) {
                foreach ($notificationTypeData as &$notification) {
                    $notificationId = $notification['notification_type_id'];
                    if (isset($enabledMapping[$notificationId])) {
                        $notification['is_enabled'] = $enabledMapping[$notificationId];
                    } else {
                        $notification['is_enabled'] = 1;
                    }
                }
            }
            $transactionStatus = $this->db->transComplete();
            if ((isset($notificationConfigData['success']) && $notificationConfigData['success']) && ($transactionStatus == 1)) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.notification_store_successfully'),
                    'data' => $notificationTypeData,
                ), 200);
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.notification_store_unsuccessfully'),
                    'data' => null,
                ), 404);
            }
        }
    }

    public function getAppLoadData(){
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $filterType = $this->request->getVar('filter_type');
        $appType = $this->request->getVar('app_type');
        $permissionsArray = array();
        if($appType == MEMBER_APP){
            $permissionsToCheck = customerAppPermission();
        }

        if($appType == GATE_KEEPER){
            $permissionsToCheck = gatekeeperAppPermission();

            $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                'user_society_id' => $userSocietyId,
                'society_id' => $societyId,
            ));
            if(!empty($userDataPermissionFilter)){
                $permissions = $userDataPermissionFilter['permissions'];
                $unserializedData = unserialize($permissions);
                $permissionsArray = [];
                foreach ($permissionsToCheck as $key => $value) {
                    if(!empty($unserializedData)){
                        if (in_array("MobileGatekeeperApp|$key", $unserializedData)) {
                            $permissionsArray[] = $key;
                        }
                    }
                }                                    
            }
        }

        if($appType == MANAGER_APP){
            $permissionsToCheck = managerAppPermission();
            $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                'user_society_id' => $userSocietyId,
                'society_id' => $societyId,
            ));
            if(!empty($userDataPermissionFilter)){
                $permissions = $userDataPermissionFilter['permissions'];
                $unserializedData = unserialize($permissions);
                $permissionsArray = [];
                foreach ($permissionsToCheck as $key => $value) {
                    if(!empty($unserializedData)){
                        if (in_array("MobileManagerApp|$key", $unserializedData)) {
                            $permissionsArray[] = $key;
                        }
                    }
                }                                    
            }
        }

        if($appType == MEMBER_APP){
            $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                'resource_type_name' => RESOURCE_TYPE_MEMBER,
                'society_id' => $societyId,
            ));
            $userDataSocietyFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                'user_society_id' => $userSocietyId,
                'society_id' => $societyId,
                'resource_type_id' => $resourceTypeData['resource_type_id'],
                // 'type_id' => $ownershipFlatMemberId,
            ));

            $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                'user_society_id' => $userSocietyId,
                // 'society_id' => $societyId,
            ));

            // printArray($userDataPermissionFilter,1);
            if(!empty($userDataPermissionFilter)){
                $permissions = $userDataPermissionFilter['permissions'];
                $unserializedData = unserialize($permissions);
                $permissionsArray = [];
                foreach ($permissionsToCheck as $key => $value) {
                    if(!empty($unserializedData)){
                        if (in_array("MobileCustomerApp|$key", $unserializedData)) {
                            $permissionsArray[] = $key;
                        }
                    }
                }                                    
            }
        }


        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        // $this->validation->setRule('filter_type', lang('CommonWebService.filter_type'), 'required');

        if(empty($filterType) && $filterType == ''){
            $filterType = 'all';
        }

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {


            if(($filterType == 'resident') || ($filterType == 'all') || ($filterType == 'society_directory')){

                $legendsData = array(
                    array(
                        'type' => 'ownership_flat',
                        'name' => 'Ownership Flat',
                        'color_code' => FLAT_OWNER_COLOR_CODE,
                    ),
                    array(
                        'type' => 'rentals',
                        'name' => 'Rentals',
                        'color_code' => VISITOR_COLOR_CODE,
                    ),
                );

                $legendsDataIdWise = array();
                if (!empty($legendsData)) {
                    foreach ($legendsData as $legendsElement) {
                        $legendsDataIdWise[$legendsElement['type']] = $legendsElement;
                    }
                }

                $towerData = $this->towerModel->getTowerData(array(
                    "society_id" => $societyId,
                    "is_multiple" => 1,
                    "is_active" => 1
                ));

                $towerFloorData = $this->towerModel->getTowerUnitData(array(
                    "society_id" => $societyId,
                    "is_multiple" => 1,
                    "is_active" => 1
                ));

                $flatData = $this->flatModel->getFlatData(array(
                    "society_id" => $societyId,
                    "is_multiple" => 1,
                    "is_active" => 1
                ));

                $flatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    "society_id" => $societyId,
                    "is_multiple" => 1,
                    "is_show_all_member" => 1,
                ));

                // printArray($flatMemberData,1);

                $rentalsWiseData = array();

                if(!empty($flatMemberData)){
                    foreach($flatMemberData as $flatMemberElement){
                        if($flatMemberElement['type'] == 'rentals'){
                            $rentalsWiseData[] = $flatMemberElement['type_id'];
                        }
                    }
                }
                // printArray($rentalsWiseData);
                $rentalsAgreementPeriodCheck = $this->rentalModel->getRentalsData(array(
                    'rentals_id' => $rentalsWiseData,
                    'is_api_call' => 1,
                    'check_flat_rent' => 1,
                    "society_id" => $societyId,
                    'is_multiple' => 1
                ));

                $flatMemberVehicleData = $this->ownershipFlatModel->getOwnershipFlatParkingData(array(
                    "society_id" => $societyId,
                    "is_multiple" => 1,
                    "is_show_all_parking" => 1,
                ));

                $rentalsVehicleWiseData = array();
                if(!empty($flatMemberVehicleData)){
                    foreach($flatMemberVehicleData as $flatMemberVehicleElement){
                        if($flatMemberVehicleElement['type'] == 'rentals'){
                            $rentalsVehicleWiseData[] = $flatMemberVehicleElement['type_id'];
                        }
                    }
                }

                if (!empty($flatMemberData)) {
                    if (!empty($rentalsAgreementPeriodCheck)) {
                        $validRentalsAgreementPeriod = array_column($rentalsAgreementPeriodCheck, 'rentals_id');
                        foreach ($flatMemberData as $key => $flatMemberElement) {
                            if ($flatMemberElement['type'] == 'rentals' && !in_array($flatMemberElement['type_id'], $validRentalsAgreementPeriod)) {
                                unset($flatMemberData[$key]); // Agar agreement me nahi hai toh remove karo
                            }
                        }
                        $flatMemberData = array_values($flatMemberData);
                    } else {
                        // Agr rentalsAgreementPeriodCheck empty hai, toh koi bhi rentals nahi ana chahiye
                        foreach ($flatMemberData as $key => $flatMemberElement) {
                            if ($flatMemberElement['type'] == 'rentals') {
                                unset($flatMemberData[$key]);
                            }
                        }
                        $flatMemberData = array_values($flatMemberData);
                    }
                }

                if (!empty($flatMemberVehicleData)) {
                    if (!empty($rentalsAgreementPeriodCheck)) {
                        $validRentalsParkingPeriod = array_column($rentalsAgreementPeriodCheck, 'rentals_id');
                        foreach ($flatMemberVehicleData as $key => $flatMemberElement) {
                            if ($flatMemberElement['type'] == 'rentals' && !in_array($flatMemberElement['type_id'], $validRentalsParkingPeriod)) {
                                unset($flatMemberVehicleData[$key]); // Agar Parking me nahi hai toh remove karo
                            }
                        }
                        $flatMemberVehicleData = array_values($flatMemberVehicleData);
                    } else {
                        // Agr rentalsAgreementPeriodCheck empty hai, toh koi bhi rentals nahi ana chahiye
                        foreach ($flatMemberVehicleData as $key => $flatMemberElement) {
                            if ($flatMemberElement['type'] == 'rentals') {
                                unset($flatMemberVehicleData[$key]);
                            }
                        }
                        $flatMemberVehicleData = array_values($flatMemberVehicleData);
                    }
                }

                $memberGrouped = [];
                foreach ($flatMemberData as $member) {
                    $flatId = $member['flat_id'];
                    $type = $member['type']; // 'ownership_flat' or 'rentals'
                    $path = site_url('uploads/no_image.png');
                    $thumbnailPath = site_url('uploads/no_image.png');
                    if ($member['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    if ($member['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    $member['thumbnail_member_image'] = $thumbnailPath;
                    $member['member_image'] = $path;

                    if (!isset($memberGrouped[$flatId])) {
                        $memberGrouped[$flatId] = ['ownership_flat' => [], 'rentals' => []];
                    }
                    // if ($member['type'] === 'ownership_flat' && $member['is_owner'] != 1) {
                    //     continue; // Skip non-owners in ownership_flat
                    // }
                    $memberGrouped[$flatId][$type][] = $member;
                }

                $vehicleGrouped = [];
                foreach ($flatMemberVehicleData as $vehicle) {
                    $flatId = $vehicle['flat_id'];
                    $type = $vehicle['type']; // 'ownership_flat' or 'rentals'
                    if (!isset($vehicleGrouped[$flatId])) {
                        $vehicleGrouped[$flatId] = ['ownership_flat' => [], 'rentals' => []];
                    }
                    $vehicleGrouped[$flatId][$type][] = $vehicle;
                }

                $floorGrouped = [];
                foreach ($flatData as $flat) {
                    $flatId = $flat['flat_id'];
                    $floorId = $flat['floor_id'];
                    $flat['member_data'] = $memberGrouped[$flatId] ?? ['ownership_flat' => [], 'rentals' => []];
                    $flat['vehicle_data'] = $vehicleGrouped[$flatId] ?? ['ownership_flat' => [], 'rentals' => []];
                    $flat['ownership_flat_name'] = '';
                    if (!empty($flat['member_data']['rentals'])) {
                        $flat['color_code'] = $legendsDataIdWise['rentals']['color_code'];
                        $flat['type'] = 'rentals';
                        foreach ($flat['member_data']['rentals'] as $rentalsElement) {
                            if (!empty($rentalsElement['agreement_with'])) {
                                $flat['ownership_flat_name'] = $rentalsElement['name'];
                                $flat['member_image'] = $rentalsElement['member_image'];
                                break; // Stop checking once rentals is found
                            }
                        }
                    } else {
                        $flat['color_code'] = $legendsDataIdWise['ownership_flat']['color_code'];
                        $flat['type'] = 'ownership_flat';
                    }

                    if (empty($flat['ownership_flat_name']) && !empty($flat['member_data']['ownership_flat'])) {
                        foreach ($flat['member_data']['ownership_flat'] as $owner) {
                            if ($owner['is_owner'] == 1) {
                                $flat['ownership_flat_name'] = $owner['name'];
                                $flat['member_image'] = $owner['member_image'];
                                break; // Stop checking once owner is found
                            }
                        }
                    }
                    // Add flat to floor grouping
                    if (!isset($floorGrouped[$floorId])) {
                        $floorGrouped[$floorId] = [];
                    }
                    if(!empty($flat['ownership_flat_name'])){
                        $floorGrouped[$floorId][] = $flat;
                    }
                }

                $towerGrouped = [];
                foreach ($towerFloorData as $floor) {
                    $towerId = $floor['tower_id'];
                    $floorId = $floor['tower_unit_id'];
                    $floor['flat_data'] = $floorGrouped[$floorId] ?? [];
                    if (!isset($towerGrouped[$towerId])) {
                        $towerGrouped[$towerId] = [];
                    }
                    if(!empty($floor['flat_data'])){
                        $towerGrouped[$towerId][] = $floor;
                    }
                }
                // printARray($towerGrouped,1);
                $finalTowerArray = [];
                foreach ($towerData as $tower) {
                    $towerId = $tower['tower_id'];
                    $tower['floor_data'] = $towerGrouped[$towerId] ?? [];
                    $finalTowerArray[] = $tower;
                }
                $data['legends_data'] = $legendsData;
                $data['residence_data'] = $finalTowerArray;

            }

            if(($filterType == 'profile') || ($filterType == 'all')){
                $profileData = new \stdClass();
                $type = '';
                $typeId = '';
                // Get Member Profile
                if ($appType == MEMBER_APP) {
                    $profileData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'is_active' => 1,
                        'is_show_all_member' => 1
                    ));
                    if (!empty($profileData)) {
                        $path = site_url('uploads/no_image.png');
                        $thumbnailPath = site_url('uploads/no_image.png');
                        if ($profileData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $profileData['member_image'])) {
                            $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $profileData['member_image'];
                        }
                        if ($profileData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $profileData['member_image'])) {
                            $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $profileData['member_image'];
                        }
                        $profileData['thumbnail_member_image'] = $thumbnailPath;
                        $profileData['member_image'] = $path;
                    }
                }
                // Get Gate Keeper Profile
                if ($appType == GATE_KEEPER) {
                    $resourceTypeGuardData = $this->resourceTypeModel->getResourceTypeData(array(
                        'is_guard' => 1,
                        'is_multiple' => 1,
                        'is_login' => 1,
                        'is_active' => 1,
                        'society_id' => $societyId,
                    ));
                    $resourceTypeIdArray = [];
                    if (!empty($resourceTypeGuardData)) {
                        foreach ($resourceTypeGuardData as $resourceTypeElement) {
                            $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                        }
                    }
                    $profileFilterArray = array(
                        'society_id' => $societyId,
                        'user_society_id' => $userSocietyId,
                        'resource_type_id' => $resourceTypeIdArray
                    );
                    $userSocietyData = $this->commonWebserviceModel->getUserSocietyData($profileFilterArray);
                    $type = isset($userSocietyData['type']) ? $userSocietyData['type'] : '';
                    $typeId = isset($userSocietyData['type_id']) ? $userSocietyData['type_id'] : '';
                    if ($appType == GATE_KEEPER) {
                        $profileData = $this->resourceModel->getResourceData(array("resource_id" => $typeId, 'society_id' => $societyId,'is_login' => 1,'is_active' => 1,'is_guard' => 1));

                        // printArray($profileData,1);
                        if (!empty($profileData)) {
                            $profileData['date_of_birth'] = isset($profileData['date_of_birth']) ? YMDToDMY($profileData["date_of_birth"]) : "";
                            $profileData['working_hours'] = "10:00 AM To 07:00 PM";
                            $profileData['resource_type_display'] = underscoreToUcWord($profileData['resource_type_display']);
                            $profileData['support_number'] = isset($profileData['support_number']) ? $profileData["support_number"] : "-";
                            $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                                "document_type_id" => $typeId,
                                "document_type" => 'resource',
                                "is_multiple" => 1
                            ));
                            if (!empty($resourceImageData)) {
                                foreach ($resourceImageData as $siKey => $resourceImageElement) {
                                    $paths = '';
                                    $thumbnailPaths = '';
                                    if (file_exists(THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'])) {
                                        $paths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'];
                                    }
                                    if (file_exists(THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'])) {
                                        $thumbnailPaths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'];
                                    }
                                    $resourceImageData[$siKey]['thumbnail_document_image'] = $thumbnailPaths;
                                    $resourceImageData[$siKey]['document_image'] = $paths;
                                    $resourceImageData[$siKey]['resource_image'] = $paths;
                                }
                            }
                            $profileData['resource_image_data'] = $resourceImageData;
                        }
                    } 
                }
                // Get Manager Profile
                if($appType == MANAGER_APP){
                    $profileData = $this->commonWebserviceModel->getUserSocietyData(array(
                        'user_society_id' => $userSocietyId,
                    ));
                }
                // printArray($profileData,1);
                $data['profile_data'] = $profileData;
            }

            if(($filterType == 'settings_data') || ($filterType == 'all')){
                $settingFilterArray = array(
                    'society_id' => $societyId,
                );
                $settingData = $this->settingModel->getSettingData($settingFilterArray);
                // printArray($settingData,1);
                $data['setting_data'] = $settingData;
            }

            if(($filterType == 'society_directory') || ($filterType == 'all')){
                
                // service_directory
                $filterArray = array(
                    'is_multiple' => 1,
                    'is_active' => 1,
                    'start' => -1,
                    'society_id' => $societyId,
                    'user_society_id' => $userSocietyId,
                    'is_api' => 1,
                );
                $categoryData = $this->categoryModel->getCategoryData(array(
                    'category_for' => 'vendor',
                    'is_multiple' => 1,
                    'is_active' => 1,
                ));
                $vendorData = $this->vendorModel->getVendorData($filterArray);
                if (!empty($vendorData)) {
                    foreach ($vendorData as $vkey => $vendor) {
                        $vendorData[$vkey]['created_at'] = YMDToDMY($vendor["created_at"], true);
                        $vendorData[$vkey]['updated_at'] = YMDToDMY($vendor["updated_at"], true);
                        $vendorData[$vkey]['created_at_display'] = time_elapsed_string($vendor['created_at']);
                        $vendorData[$vkey]['updated_at_display'] = time_elapsed_string($vendor['created_at']);
                        $mobileNumbers = explode(', ', $vendor['vendor_mobile_no']);
                        $personNames = explode(', ', $vendor['vendor_person_name']);
                        $designations = explode(', ', $vendor['vendor_designation']);
                        $contactInfo = [];
                        foreach ($mobileNumbers as $index => $mobile) {
                            $contactInfo[] = [
                                'mobile_no' => $mobile,
                                'person_name' => $personNames[$index] ?? null,
                                'designation' => $designations[$index] ?? null
                            ];
                        }
                        $vendorData[$vkey]['contact_info'] = $contactInfo;
                        $vendorData[$vkey]['vendor_category_name'] = explode(', ', $vendor['vendor_category_name']);
                        $vendorData[$vkey]['vendor_category_id'] = explode(', ', $vendor['vendor_category_id']);
                        $shareData = [
                            'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                            'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                            'share_image' => base_url('uploads/no_image.png'),
                            'share_link' => 'https://digitattva.in/',
                        ];
                        $vendorData[$vkey]['share_data'] = $shareData;
                    }
                }
                $data['category_data'] = $categoryData;

                // society_committee
                $filterArray = array(
                    'is_multiple' => 1,
                    'is_active' => 1,
                    'start' => -1,
                    'society_id' => $societyId,
                    'user_society_id' => $userSocietyId,
                    'is_api' => 1,
                );
                $committeeData = $this->managementCommitteeModel->getManagementCommitteeData($filterArray);
    
                $responsibilityData = $this->managementCommitteeResponsibilitiesModel->getManagementCommitteeResponsibilitiesData(array(
                    'is_multiple' => 1,
                    'is_active' => 1,
                ));
    
                $responsibilitiesDataCmmitteeIdWise = array();
                if (!empty($committeeData)) {
                    foreach ($committeeData as $ckey => $committee) {
                        $committeeData[$ckey]['created_at'] = YMDToDMY($committee["created_at"], true);
                        $committeeData[$ckey]['updated_at'] = YMDToDMY($committee["updated_at"], true);
                        $committeeData[$ckey]['created_at_display'] = time_elapsed_string($committee['created_at']);
                        $committeeData[$ckey]['updated_at_display'] = time_elapsed_string($committee['created_at']);
                        $shareData = array(
                            'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                            'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                            'share_image' => base_url('uploads/no_image.png'),
                            "share_link" => "https://digitattva.in/",
                        );
                        $committeeData[$ckey]['share_data'] = $shareData;
                        $responsibilitiesData = $this->managementCommitteeModel->getManagementCommitteeResponsibilitiesData(array(
                            "management_committee_id" => $committee['management_committee_id'],
                            'is_multiple' => 1
                        ));
                        if (!empty($responsibilitiesData)) {
                            foreach ($responsibilitiesData as $responsibilitiesElement) {
                                $responsibilitiesDataCmmitteeIdWise[$responsibilitiesElement['management_committee_id']][] = $responsibilitiesElement;
                            }
                        }
                        $committeeData[$ckey]['responsibilites_data'] = array_key_exists($committee['management_committee_id'], $responsibilitiesDataCmmitteeIdWise) ? $responsibilitiesDataCmmitteeIdWise[$committee['management_committee_id']] : array();
                    }
                }
                $data['responsibility_data'] = $responsibilityData;
                // emergency_directory
                $filterArray = array(
                    'is_multiple' => 1,
                    'is_active' => 1,
                    'is_deleted' => 0,
                    'start' => -1,
                    'user_society_id' => $userSocietyId,
                    'society_id' => $societyId
                );
                $emergencyData = $this->commonWebserviceModel->getEmergencyData($filterArray);
                // printArray($emergencyData,1);
                $emergencyIdArray = array();
                $emergencyDocumentDataWise = array();
                if (!empty($emergencyData)) {
                    foreach ($emergencyData as $emergencyElement) {
                        $emergencyIdArray[] = $emergencyElement['emergency_number_id'];
                    }
    
                    if (!empty($emergencyIdArray)) {
                        $emergencyImageData = $this->visitorModel->getDocumentImageData(array(
                            "document_type_id" => $emergencyIdArray,
                            "document_type" => 'emergency_contact',
                            "is_multiple" => 1
                        ));
    
                        if (!empty($emergencyImageData)) {
                            foreach ($emergencyImageData as $emergencyImageElement) {
                                if ($emergencyImageElement["document_image"] == '') {
                                    $emergencyImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                                    $emergencyImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                                } else {
                                    $emergencyImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $emergencyImageElement["document_image"];
                                    $emergencyImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $emergencyImageElement["document_image"];
                                }
                                $emergencyDocumentDataWise[$emergencyImageElement['document_type_id']][] = $emergencyImageElement;
                            }
                        }
                    }
                }
    
                if (!empty($emergencyData)) {
                    foreach ($emergencyData as $ekey => $emergency) {
                        $emergencyData[$ekey]['created_at'] = YMDToDMY($emergency["created_at"], true);
                        $emergencyData[$ekey]['updated_at'] = YMDToDMY($emergency["updated_at"], true);
                        $emergencyData[$ekey]['created_at_display'] = time_elapsed_string($emergency['created_at']);
                        $emergencyData[$ekey]['updated_at_display'] = time_elapsed_string($emergency['created_at']);
                        $shareData = array(
                            'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                            'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                            'share_image' => base_url('uploads/no_image.png'),
                            "share_link" => "https://digitattva.in/",
                        );
                        $emergencyData[$ekey]['share_data'] = $shareData;
                        $emergencyData[$ekey]['emergency_image_data'] = array_key_exists($emergency['emergency_number_id'], $emergencyDocumentDataWise) ? $emergencyDocumentDataWise[$emergency['emergency_number_id']] : array();
                    }
                }


                $data['society_directory'] = array(
                    'residence_data' => (isset($data['residence_data']) && !empty($data['residence_data'])) ? $data['residence_data'] : array(),
                    'service_directory' => (isset($vendorData) && !empty($vendorData)) ? $vendorData : array(),
                    'society_committee' => (isset($committeeData) && !empty($committeeData)) ? $committeeData : array(),
                    'emergency_directory' => (isset($emergencyData) && !empty($emergencyData)) ? $emergencyData : array(),
                );
            }


            $sosTypeArray = sosTypeAPI();

            if ($appType === GATE_KEEPER) {
                foreach ($sosTypeArray as $index => $item) {
                    if ($item['key'] === 'family') {
                        unset($sosTypeArray[$index]);
                    }
                }
            }
            $sosTypeArray = array_values($sosTypeArray);
            $data['sos'] = $sosTypeArray; 
            $data['week_days'] = weekDays(); 
            $data['complain_type'] = complainTypeApi(); 
            $data['reading_type'] = readingTypeAPI();

            if($filterType == 'all'){
                $data['request_timer'] = REQUEST_TIMER;
            }


            if (!empty($data))
            {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.app_loaded_data_successfully'),
                    'data' => $data,
                    'user_permission_array' => $permissionsArray,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => null,
                    'user_permission_array' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getVisitorList()
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $status = $this->request->getVar('filtered_status');
        $societyId = $this->request->getVar('society_id');
        $visitorId = $this->request->getVar('visitor_id');
        // $categoryId = $this->request->getVar('category_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $appType = $this->request->getVar('app_type');
        $resourceTypeId = $this->request->getVar('resource_type_id');
        $type = $this->request->getVar('type');
        $collectOnGate = $this->request->getVar('collect_on_gate');
        $filteredType = $this->request->getVar('filtered_type');
        $isTodayDate = $this->request->getVar('is_today_date');
        $startDate = $this->request->getVar('start_date');
        $endDate = $this->request->getVar('end_date');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $expectedDate = $this->request->getVar('expected_date');
        $showEnteredNotExited = $this->request->getVar('show_entered_not_exited');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        // $this->validation->setRule('type', lang('CommonWebService.type'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'limit' => DATA_LIMIT,
                'response_code' => 400,
            ), 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'is_deleted' => 0,
                'start' => $start,
                'status' => strtolower($status),
                'filtered_type' => strtolower($filteredType),
                'search' => $search,
                'type' => $type,
                'society_id' => $societyId,
                'visitor_id' => $visitorId,
                // 'category_id' => $categoryId,
                'resource_type_id' => $resourceTypeId,
                'collect_on_gate' => $collectOnGate,
                'is_today_date' => $isTodayDate,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'ownership_flat_id' => $ownershipFlatId,
                'show_entered_not_exited' => $showEnteredNotExited,
                //'start_date' => DMYToYMD($startDate),
                //'end_date' => DMYToYMD($endDate),
            );
            if ($appType == MEMBER_APP) {
                $filterArray['user_society_id'] = $userSocietyId;
            }
            if (!empty($startDate)) {
                $filterArray['start_date'] = DMYToYMD($startDate);
            }
            if (!empty($endDate)) {
                $filterArray['end_date'] = DMYToYMD($endDate);
            }
            if (!empty($expectedDate)) {
                // $filterArray['expected_date'] = DMYToYMD($expectedDate);
            }
            $visitorData = visitorListData($filterArray, $userSocietyId);
            // $objectFilterData = array(
            //     'flat_id' => array('flat_id','tower_flat_name'),
            //     'ownership_flat_member_id' => array('ownership_flat_member_id','name','flat_number','flat_name','member_image','member_number'),
            //     'ownership_flat_parking_id' => array('ownership_flat_parking_id','parking_slot_no','number'),
            //     'company_id' => array('company_id','company_name'),
            //     'category_id' => array('category_id','category_name'),
            //  'parking_place_id' => array('parking_place_id','number','parking_block_display'),
            // );


            $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                'society_id' => $societyId,
                'is_multiple' => 1,
                'is_helper' => 1,
                'is_active' => 1,
            ));
            if (!empty($visitorData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.visitor_listing_successfully'),
                    'resource_type_data' => $resourceTypeData,
                    'data' => $visitorData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'resource_type_data' => $resourceTypeData,
                    'data' => $visitorData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }
    public function addEditVisitor()
    {

        $this->db->transStart();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $visitorId = $this->request->getVar('visitor_id');
        $visitorNameMobileNo = $this->request->getVar('visitor_name_mobile_no');
        $visitorPurpose = $this->request->getVar('visitor_purpose');
        $visitorDuration = $this->request->getVar('visitor_duration');
        $vehicleType = $this->request->getVar('vehicle_type');
        $vehicleNo = $this->request->getVar('vehicle_no');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatParkingId = $this->request->getVar('ownership_flat_parking_id');
        $type = $this->request->getVar('type');
        $visitorCompanyId = $this->request->getVar('visitor_company_id');
        $visitorCompanyName = $this->request->getVar('visitor_company_name');
        $noOfParcel = $this->request->getVar('no_of_parcel');
        $collectOnGate = $this->request->getVar('collect_on_gate');
        $status = $this->request->getVar('status');
        $parkingSlotId = $this->request->getVar('parking_slot_id');
        $resourceInTime = $this->request->getVar('resource_in_time');
        $resourceOutTime = $this->request->getVar('resource_out_time');
        $address = $this->request->getVar('address');
        $workingDayName = $this->request->getVar('working_day_name');
        $userSocietyId = $this->request->getVar('user_society_id');
        $documentImage = $this->request->getVar('document_image[]');
        $idProof = $this->request->getVar('id_proof');
        $noOfVisitor = $this->request->getVar('no_of_visitor');
        $isStatusUpdate = $this->request->getVar('is_status_update');
        $expectedStartDateTime = $this->request->getVar('expected_start_date_time');
        $expectedEndDateTime = $this->request->getVar('expected_end_date_time');
        $anyTimeDuringTheDay = $this->request->getVar('anytime_during_the_day');
        $isDeliveredToMember = $this->request->getVar('is_delivered_to_member');
        $otp = $this->request->getVar('otp');
        $appType = $this->request->getVar('app_type');
        $deliveryReferenceName = $this->request->getVar('reference_name');
        $deliveryReferenceMobile = $this->request->getVar('reference_mobile');
        $visitorNameMobileNoArray = json_decode($visitorNameMobileNo, true);
        $workingDayNameArray = json_decode($workingDayName, true);
        $visitorValidationData = array();
        $lastVisitorIdArray = array();

        $userData = $this->commonWebserviceModel->getUserSocietyData(array(
            'user_society_id' => $userSocietyId,
        ));
        $resourceTypeId = $userData['resource_type_id'];


        if(!empty($parkingPlaceId)){
            $visitorParkingStoreData = $this->visitorModel->getVisitorData(array(
                'parking_slot_id' => $parkingSlotId, // 2
                'status' => array("approval_pending","waiting_for_approval","entry_pre_approve","entered"),
            ));

            if(!empty($visitorParkingStoreData)){
                return $this->response(array(
                    'status' => FALSE,
                    'message' => "This Parking Slot Is Already Assigned",
                    'data' => null,
                    'response_code' => 400,
                ), 400);
            }

            // $parkingPlaceData = $this->parkingPlaceModel->getParkingPlaceData(array(
            //     "parking_place_id" => $parkingPlaceId
            // ));

            // if(!empty($parkingPlaceData)){
            //     if($parkingPlaceData['vehicle_type']){
            //         return $this->response(array(
            //             'status' => FALSE,
            //             'message' => "This Parking Slot Is Already Assigned",
            //             'data' => null,
            //             'response_code' => 400,
            //         ), 400);
            //     }
            // }
        }

        if ($type != 'delivery_boy' && empty($visitorId)) {
            if (is_array($visitorNameMobileNoArray)) {
                foreach ($visitorNameMobileNoArray as $visitor) {
                    $visitorValidationData['visitor_name'][] = isset($visitor['visitor_name']) ? $visitor['visitor_name'] : '';
                    $visitorValidationData['visitor_mobile_no'][] = isset($visitor['visitor_mobile_no']) ? $visitor['visitor_mobile_no'] : '';
                }
            }

            $visitorValidationData['type'] = $type;
            $visitorValidationData['society_id'] = $societyId;

            $rules = [
                'visitor_name.*' => 'required',
                'visitor_mobile_no.*' => 'required',
                'type' => 'required',
                'society_id' => 'required|numeric',
            ];

            $messages = [
                'visitor_name.*' => [
                    'required' => 'The visitor name is required.',
                ],
                'visitor_mobile_no.*' => [
                    'required' => 'The mobile number is required.',
                    // 'numeric' => 'The mobile number must be numeric.',
                    //'exact_length[10]' => 'Mobile number should be bew',
                ],
                'type' => [
                    'required' => 'The Type is required.',
                ],
                'society_id' => [
                    'required' => 'The Society id is required.',
                ],
            ];
            $this->validation->setRules($rules, $messages);

            if (!$this->validation->run($visitorValidationData)) {
                // validation failed
                $errors = $this->validation->getErrors();
                return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                ), 400);
            }
        }

        // $currentTimeStamp = strtotime(date("Y-m-d H:i:s"));
        // $expectedStartDateTimeStamp = strtotime($expectedStartDateTime);
        // if($expectedStartDateTimeStamp < $currentTimeStamp){
        //     return $this->response(array(
        //         'status' => FALSE,
        //         'message' => "Expected Start Date-Time Can't Be Earlier Than Current Time.",
        //         'data' => null,
        //         'response_code' => 400,
        //     ), 400);
        // } 

        $expectedStartDateTimeStamp = strtotime($expectedStartDateTime);
        $expectedEndDateTimeStamp = strtotime($expectedEndDateTime);
        if ($expectedEndDateTimeStamp <= $expectedStartDateTimeStamp) {
            return $this->response(array(
                'status' => FALSE,
                'message' => "End Time Must Be Greater Than Start Time.",
                'data' => null,
                'response_code' => 400,
            ), 400);
        }
        $visitorRecordData = $this->visitorModel->getVisitorData(array(
            'visitor_id' => $visitorId,
        ));

        // printArray($visitorRecordData,1);

        $visitorUpdateArray = array();
        $visitorStatusUpdateArray = array();
        if (!empty($isDeliveredToMember) && !empty($visitorId)) {
            // echo "fdgdfgfdg";
            $filterArray = array(
                'visitor_id' => $visitorId,
            );
            $visitorOtpData = $this->visitorModel->getVisitorData($filterArray);
            if (!empty($visitorOtpData)) {
                $otpValidityTime = strtotime($visitorOtpData['otp_validity']);
                $currentTime = strtotime(date("Y-m-d H:i:s"));
                if ($otp != $visitorOtpData['otp']) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => lang('CommonWebService.invalid_otp_code'),
                        'data' => null
                    ), 400);
                }
                // else if ($currentTime > $otpValidityTime) {
                //  return $this->response(array(
                //         'status' => false,
                //         'response_code' => 404,
                //         'message' => lang('CommonWebService.otp_code_expired'),
                //         'data' => null
                //     ), 400);
                // }
                else {
                    $visitorArray = array(
                        'visitor_id' => $visitorId,
                        'status' => $status,
                        // 'otp' => $otp,
                        'delivery_reference_name' => $deliveryReferenceName,
                        'delivery_reference_mobile' => $deliveryReferenceMobile,
                    );
                    // if($status == 'collected'){
                    //  $visitorArray['delivery_date'] = date("Y-m-d H:i:s");
                    // }
                    $visitorUpdateData = $this->visitorModel->getVisitorData(array(
                        'visitor_id' => $visitorId,
                    ));
                    // printArray($visitorUpdateData,1);
                    $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $visitorId,
                        "document_type" => 'visitorId',
                    ));
                    $visitorImagePath = SITE_URL('uploads/no_image.png');
                    if (!empty($visitorImageData)) {
                        if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                            $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                        }
                    }
                    
                    $visitorUpdateArray = compareArray($visitorArray, $visitorUpdateData);
                    $extraData = array();
                    $extraObj['api_user_id'] = $userSocietyId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $visitorData = $this->commonWebserviceModel->insertUpdateRecord($visitorArray, 'visitor_id', 'tbl_visitor', 1, '', array(), $extraData, $visitorUpdateArray);
                    $lastVisitorId = $visitorData['lastInsertedId'];
                    array_push($lastVisitorIdArray,$lastVisitorId);
                    $visitorStatusArray = array(
                        'visitor_status_history_id' => '',
                        'visitor_id' => $visitorUpdateData['visitor_id'],
                        'status' => $visitorUpdateData['status'],
                    );
                    $visitorStatusData = $this->commonWebserviceModel->insertUpdateRecord($visitorStatusArray, 'visitor_status_history_id', 'tbl_visitor_status_history', 1, '', array(), $extraData, $visitorStatusUpdateArray);

                    $visitorStoreUpdateData = $this->visitorModel->getVisitorData(array(
                        'visitor_id' => $visitorId,
                    ));
                    
                    $filterArray = array(
                        'visitor_id' => $visitorId,
                    );

                // $visitorNotificationData = visitorListData($filterArray, $userSocietyId);

                    // $visitorNotificationData = visitorListData($filterArray, $userSocietyId);

                    if($visitorStoreUpdateData['status'] == 'entered' || $visitorStoreUpdateData['status'] == 'exited'){
                        $endDate = isValidDate($visitorStoreUpdateData['end_date']) ? $visitorStoreUpdateData['end_date'] : date("Y-m-d H:i:s");
                        $differenecStartEndDate = calculateDateTimeDifference($visitorStoreUpdateData['start_date'],$endDate);
                    }

                    $notificationArray = array(
                        'ownership_flat_member_id' => $visitorStoreUpdateData['ownership_flat_member_id'],
                        'ownership_flat_id' => $visitorStoreUpdateData['ownership_flat_id'],
                        'status' => $status,
                        'type' => $visitorStoreUpdateData['type'],
                        'type_display' => underscoreToUcWord($visitorStoreUpdateData['type']),
                        'society_id' => $societyId,
                        'user_society_id' => $userSocietyId,
                        'type_id' => $visitorId,
                        'visitor_name' => $visitorStoreUpdateData['visitor_name'],
                        'mobile_no' => $visitorStoreUpdateData['visitor_mobile_no'],
                        'display_status' => underscoreToUcWord($status),
                        'image' => $visitorImagePath,
                        'collect_on_gate' => $visitorStoreUpdateData['collect_on_gate'],
                        'vehicle_no' => $visitorStoreUpdateData['vehicle_no'],
                        'visitor_company_name' => $visitorStoreUpdateData['visitor_company_name'],
                        'no_of_parcel' => $visitorStoreUpdateData['no_of_parcel'],
                        'guard' => $visitorStoreUpdateData['updated_by_name'],
                        'module' => 'visitor',
                        'app_type' => $appType,
                        'member_name' => $visitorStoreUpdateData['name'],
                        'no_of_visitor' => $visitorStoreUpdateData['no_of_visitor'],
                        'visitor_purpose' => $visitorStoreUpdateData['visitor_purpose'],
                        'flat_number' => $visitorStoreUpdateData['tower_flat_name'],
                        'flat_name' => $visitorStoreUpdateData['tower_flat_name']." ".$visitorStoreUpdateData['name'],
                        'name' => $visitorStoreUpdateData['name'],
                        'visitor_image_data' => $visitorImagePath,
                        'visitor_mobile_no' => $visitorStoreUpdateData['visitor_mobile_no'],
                        'expected_start_date_time_display' => isValidDate($visitorStoreUpdateData['expected_start_date_time']) ? date('d M,Y h:i A', strtotime($visitorStoreUpdateData["expected_start_date_time"])) : "",
                        'expected_end_date_time_display' => isValidDate($visitorStoreUpdateData['expected_end_date_time']) ? date('d M,Y h:i A', strtotime($visitorStoreUpdateData["expected_end_date_time"])) : "",
                        'delivery_date_time_display' => isValidDate($visitorStoreUpdateData['delivery_date']) ? date('d M, Y h:i A', strtotime($visitorStoreUpdateData["delivery_date"])) : "",
                        'start_date_time_display' => isValidDate($visitorStoreUpdateData['start_date']) ? date('d M, Y h:i A', strtotime($visitorStoreUpdateData["start_date"])) : "",
                        'end_date_time_display' => isValidDate($visitorStoreUpdateData['end_date']) ? date('d M, Y h:i A', strtotime($visitorStoreUpdateData["end_date"])) : "",
                        'member_number' => $visitorStoreUpdateData['member_number'],
                        'resource_type_name' => $visitorStoreUpdateData['resource_type_name'],
                        'difference_start_end_date' => isset($differenecStartEndDate) ? $differenecStartEndDate : "",
                        
                        // 'vehcal_data' => $visitorNotificationData,
                        // 'visitor_type_color_code' => $visitorTypeDataColorCodeData[[$visitorStoreUpdateData['type']]] ?? null,

                    );
                    $extraDatajson = json_encode($notificationArray);
                    if ($appType == GATE_KEEPER) {
                        $notificationArray['send_for_notification'] = $appType;
                        $notificationArray['send_for_notification_id'] = $userSocietyId;
                        $notificationArray['receive_for_notification'] = MEMBER_APP;
                        $notificationArray['receive_for_notification_id'] = $visitorStoreUpdateData['ownership_flat_member_id'];
                    }

                    if ($appType == MEMBER_APP) {
                        $notificationArray['send_for_notification'] = $appType;
                        $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                        $notificationArray['receive_for_notification'] = GATE_KEEPER;
                        $notificationArray['receive_for_notification_id'] = 0;
                    }

                    // printArray($notificationArray,1);
                    sendNotificationDataList($notificationArray, $extraDatajson);
                    //     return $this->response(array(
                    //     'status' => true,
                    //     'response_code' => 200,
                    //     'message' => lang('CommonWebService.otp_verified_successfully'),
                    //     'data' => null
                    // ), 200);
                }
            }
        } else {

            $documentImageData = array();
            if (isset($_FILES["document_image"])) {
                $documentImagePath = DOCUMENT_IMAGE_PATH;
                $documentImageData = $dt_ci_file_upload->UploadMultipleFile('document_image', MAX_IMAGE_SIZE_LIMIT, $documentImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($documentImageData['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($documentImageData['message']),
                        'data' => null
                    ), 404);
                }
                else{
                    unset($documentImageData['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailMultipleUploadFile($documentImageData, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
            }
            if (isset($_FILES["id_proof"])) {
                $idProofPath = ID_PROOF_PATH;
                $ownershipFlatId = $this->request->getVar('ownership_flat_id');
                $idProofResult = $dt_ci_file_upload->uploadFile('id_proof', MAX_IMAGE_SIZE_LIMIT, $idProofPath, true, true, array('jpeg', 'png', 'jpg'));
                if ($idProofResult['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($idProofResult['message']),
                        'data' => null
                    ), 404);
                } else {
                    $idProofRecord = $idProofResult['file_name'];
                    unset($idProofResult['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailUploadFile($idProofResult, ID_PROOF_PATH, THUMBNAIL_ID_PROOF_PATH);
                }
            }

            if (isset($visitorId) && $visitorId != '') {
                if (isset($documentImageData) && count($documentImageData) > 0) {
                    $visitorData = $this->visitorModel->deleteRecordDocumentImage($visitorId,array('visitor'),$userSocietyId,$societyId);
                }
                $this->visitorModel->deleteRecordWorkingDay($visitorId, $userSocietyId, $societyId);
            }

            // Json Decode for Visitor Name and Mobile No
            $ownershipFlatMemberUpdateArray = array();
            if (is_array($visitorNameMobileNoArray)) {
                foreach ($visitorNameMobileNoArray as $visitor) {
                    $visitorArray = array(
                        'visitor_id' => $visitorId,
                        'visitor_name' => $visitor['visitor_name'],
                        'visitor_mobile_no' => $visitor['visitor_mobile_no'],
                        'visitor_purpose' => $visitorPurpose,
                        'vehicle_type' => $vehicleType,
                        'vehicle_no' => $vehicleNo,
                        'society_id' => $societyId,
                        'type' => $type,
                        'ownership_flat_id' => $ownershipFlatId,
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'ownership_flat_parking_id' => $ownershipFlatParkingId,
                        'visitor_company_id' => $visitorCompanyId,
                        // 'company_name'=> $companyName,
                        'no_of_parcel' => $noOfParcel,
                        'collect_on_gate' => $collectOnGate,
                        'resource_in_time' => $resourceInTime,
                        'resource_out_time' => $resourceOutTime,
                        'address' => $address,
                        'no_of_visitor' => $noOfVisitor,
                        'anytime_during_the_day' => $anyTimeDuringTheDay,
                        'parking_slot_id' => $parkingSlotId,
                        'visitor_duration' => $visitorDuration
                    );
                    if ($visitorId == '' && $appType == MEMBER_APP && $type == 'visitor') {
                        $visitorArray['no_of_visitor'] = $noOfVisitor;
                    }

                    if ($visitorId == '') {
                        $visitorArray['status'] = (isset($status) && (!empty($status))) ? $status : 'approval_pending';
                        $visitorArray['qr_code_number'] = GenRandomNumber(6);
                        $combineQRCodeType = $visitorArray['qr_code_number'];

                        $codeContents = $combineQRCodeType;
                        qrcode('text', $codeContents, 4, '', $combineQRCodeType);
                        $visitorArray['qr_code_image'] = $combineQRCodeType . '.png';
                    }
                    if (isset($expectedStartDateTime)) {
                        $visitorArray['expected_start_date_time'] = DMYToYMD($expectedStartDateTime, true, true);
                    }
                    if (isset($expectedEndDateTime)) {
                        $visitorArray['expected_end_date_time'] = DMYToYMD($expectedEndDateTime, true, true);
                    }
                    if ($visitorId != '' && $type == 'delivery_boy') {
                        $visitorArray['status'] = $status;
                    }
                    if ($status == 'collected') {
                        $visitorArray['delivery_date'] = date("Y-m-d H:i:s");
                        if (!empty($visitorId)) {
                            $visitorUpdateData = $this->visitorModel->getVisitorData(array(
                                'visitor_id' => $visitorId,
                                'is_deleted' => 0,
                            ));
                            $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                                "document_type_id" => $visitorId,
                                "document_type" => 'visitorId',
                            ));
                            $visitorImagePath = SITE_URL('uploads/no_image.png');
                            if (!empty($visitorImageData)) {
                                if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                                    $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                                }
                            }

                        }
                    }
                    // Delivery Boy If Collect On Gate generate OTP and store in Ownership Flat Member Table
                    if (!empty($collectOnGate) && !empty($ownershipFlatMemberId)) {
                        $ownershipFlatMemberUpdateData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'is_active' => 1
                        ));
                        $otp = DELIVERY_OTP_CODE;
                        if (DEV_ENVIRONMENT == 'production') {
                            if (isset($ownershipFlatMemberUpdateData['mobile_no']) && $ownershipFlatMemberUpdateData['mobile_no'] == '8976677224') {
                                $otp = DELIVERY_OTP_CODE;
                            } else {
                                $otp = GenRandomNumber(6);
                            }
                        }
                        $otpValidity = date('Y-m-d H:i:s', strtotime(' +15 minutes'));
                        $visitorArray['otp'] = $otp;
                        $visitorArray['otp_validity'] = $otpValidity;
                    }

                    if (!empty($visitorId)) {
                        $visitorUpdateData = $this->visitorModel->getVisitorData(array(
                            'visitor_id' => $visitorId,
                            'is_deleted' => 0,
                        ));
                        if (isset($idProofRecord)) {
                            if ($visitorUpdateData['id_proof'] != '' && file_exists(ID_PROOF_PATH . $visitorUpdateData['id_proof'])) {
                                unlink(ID_PROOF_PATH . $visitorUpdateData['id_proof']);
                            }
                            $visitorArray['id_proof'] = $idProofRecord;
                        }
                        $visitorUpdateArray = compareArray($visitorArray, $visitorUpdateData);
                    } else {
                        if (isset($idProofRecord)) {
                            $visitorArray['id_proof'] = $idProofRecord;
                        }
                    }
                    $extraData = array();
                    $extraObj['api_user_id'] = $userSocietyId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;

                    // printArray($extraData,1);
                    $visitorData = $this->commonWebserviceModel->insertUpdateRecord($visitorArray, 'visitor_id', 'tbl_visitor', 1, '', array(), $extraData, $visitorUpdateArray);
                    $lastVisitorId = $visitorData['lastInsertedId'];
                    array_push($lastVisitorIdArray,$lastVisitorId);
                    //Notification
                    if ($status == 'collected') {
                        if (!empty($visitorId)) {
                            $visitorStoreUpdateData = $this->visitorModel->getVisitorData(array(
                                'visitor_id' => $lastVisitorId,
                            ));

                            $filterArray = array(
                    'visitor_id' => $visitorId,
                );

                // $visitorNotificationData = visitorListData($filterArray, $userSocietyId);

                            // printArray($visitorStoreUpdateData,1);

                            if($visitorStoreUpdateData['status'] == 'entered' || $visitorStoreUpdateData['status'] == 'exited'){
                                $endDate = isValidDate($visitorStoreUpdateData['end_date']) ? $visitorStoreUpdateData['end_date'] : date("Y-m-d H:i:s");
                                $differenecStartEndDate = calculateDateTimeDifference($visitorStoreUpdateData['start_date'],$endDate);
                            }

                            $notificationArray = array(
                                'ownership_flat_member_id' => $ownershipFlatMemberId,
                                'ownership_flat_id' => $ownershipFlatId,
                                'status' => $status,
                                'type' => $type,
                                'type_display' => underscoreToUcWord($type),
                                'society_id' => $societyId,
                                'user_society_id' => $userSocietyId,
                                'type_id' => $visitorStoreUpdateData['visitor_id'],
                                'visitor_name' => $visitorStoreUpdateData['visitor_name'],
                                'mobile_no' => $visitorStoreUpdateData['visitor_mobile_no'],
                                'display_status' => underscoreToUcWord($status),
                                'image' => $visitorImagePath,
                                'collect_on_gate' => $collectOnGate,
                                'visitor_company_name' => $visitorStoreUpdateData['visitor_company_name'],
                                'vehicle_no' => $visitorStoreUpdateData['vehicle_no'],
                                'no_of_parcel' => $noOfParcel,
                                'guard' => $visitorStoreUpdateData['updated_by_name'],
                                'module' => 'visitor',
                                'app_type' => $appType,
                                'member_name' => $visitorStoreUpdateData['name'],
                                'no_of_visitor' => $visitorStoreUpdateData['no_of_visitor'],
                                'visitor_purpose' => $visitorStoreUpdateData['visitor_purpose'],
                                'flat_number' => $visitorStoreUpdateData['tower_flat_name'],
                                'flat_name' => $visitorStoreUpdateData['tower_flat_name']." ".$visitorStoreUpdateData['name'],
                                'name' => $visitorStoreUpdateData['name'],
                                'visitor_image_data' => $visitorImagePath,
                                'visitor_mobile_no' => $visitorStoreUpdateData['visitor_mobile_no'],
                                'expected_start_date_time_display' => isValidDate($visitorStoreUpdateData['expected_start_date_time']) ? date('d M,Y h:i A', strtotime($visitorStoreUpdateData["expected_start_date_time"])) : "",
                                'expected_end_date_time_display' => isValidDate($visitorStoreUpdateData['expected_end_date_time']) ? date('d M,Y h:i A', strtotime($visitorStoreUpdateData["expected_end_date_time"])) : "",
                                'delivery_date_time_display' => isValidDate($visitorStoreUpdateData['delivery_date']) ? date('d M, Y h:i A', strtotime($visitorStoreUpdateData["delivery_date"])) : "",
                                'start_date_time_display' => isValidDate($visitorStoreUpdateData['start_date']) ? date('d M, Y h:i A', strtotime($visitorStoreUpdateData["start_date"])) : "",
                                'end_date_time_display' => isValidDate($visitorStoreUpdateData['end_date']) ? date('d M, Y h:i A', strtotime($visitorStoreUpdateData["end_date"])) : "",
                                'member_number' => $visitorStoreUpdateData['member_number'],
                                'resource_type_name' => $visitorStoreUpdateData['resource_type_name'],
                                'difference_start_end_date' => isset($differenecStartEndDate) ? $differenecStartEndDate : "",
                                // 'vehcal_data' => $visitorNotificationData,
                                // 'visitor_type_color_code' => $visitorTypeDataColorCodeData[[$visitorStoreUpdateData['type']]] ?? null,

                            );

                            $extraDatajson = json_encode($notificationArray);
                            if ($appType == GATE_KEEPER) {
                                $notificationArray['send_for_notification'] = $appType;
                                $notificationArray['send_for_notification_id'] = $userSocietyId;
                                $notificationArray['receive_for_notification'] = MEMBER_APP;
                                $notificationArray['receive_for_notification_id'] = $ownershipFlatMemberId;
                            }

                            if ($appType == MEMBER_APP) {
                                $notificationArray['send_for_notification'] = $appType;
                                $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                $notificationArray['receive_for_notification'] = GATE_KEEPER;
                                $notificationArray['receive_for_notification_id'] = 0;
                            }
                            sendNotificationDataList($notificationArray, $extraDatajson);
                        }
                    }

                    if ($visitorId == '') {
                        $visitorMemberNameData = $this->visitorModel->getVisitorData(array(
                            // 'visitor_id' => $visitorId,
                            'visitor_id' => $lastVisitorId,
                        ));
                        if (isset($documentImageData) && count($documentImageData) > 0) {
                            $batchArray = array();
                            unset($documentImageData['success']);
                            foreach ($documentImageData as $key => $imageData) {
                                $documentImage = isset($imageData['file_name']) ? $imageData['file_name'] : "";
                            }
                        } else {
                            $documentImage = '';
                        }

                        if ($documentImage == '') {
                            $visitorImageData = SITE_URL('uploads/no_image.png');
                        } else {
                            $visitorImageData = SITE_URL() . DOCUMENT_IMAGE_PATH . $documentImage;
                        }
                        $visitorStatus = (isset($status) && (!empty($status))) ? $status : 'approval_pending';

                        $filterArray = array(
                            'visitor_id' => $lastVisitorId,
                            'is_multiple' => 1,
                        );

                // $visitorNotificationData = visitorListData($filterArray, $userSocietyId);

                        if($status == 'entered' || $status == 'exited'){
                            $endDate = isValidDate($visitorStoreUpdateData['end_date']) ? $visitorStoreUpdateData['end_date'] : date("Y-m-d H:i:s");
                            $differenecStartEndDate = calculateDateTimeDifference($visitorStoreUpdateData['start_date'],$endDate);
                        }

                        $notificationArray = array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'ownership_flat_id' => $ownershipFlatId,
                            'status' => (isset($status) && (!empty($status))) ? $status : 'approval_pending',
                            'type' => $type,
                            'type_display' => underscoreToUcWord($type),
                            'society_id' => $societyId,
                            'user_society_id' => $userSocietyId,
                            'type_id' => $lastVisitorId,
                            'visitor_name' => $visitor['visitor_name'],
                            'collect_on_gate' => $collectOnGate,
                            'vehicle_no' => $vehicleNo,
                            'module' => 'visitor',
                            'app_type' => $appType,
                            'mobile_no' => $visitor['visitor_mobile_no'],
                            'display_status' => underscoreToUcWord($visitorStatus),
                            'image' => $visitorImageData,
                            'member_name' => $visitorMemberNameData['name'],
                            'visitor_company_name' => $visitorCompanyName,
                            'resource_type_id' => $resourceTypeId,
                            'no_of_visitor' => $visitorMemberNameData['no_of_visitor'],
                            'no_of_parcel' => $visitorMemberNameData['no_of_parcel'],
                            'visitor_purpose' => $visitorMemberNameData['visitor_purpose'],
                            'flat_number' => $visitorMemberNameData['tower_flat_name'],
                            'flat_name' => $visitorMemberNameData['tower_flat_name']." ".$visitorMemberNameData['name'],
                            'name' => $visitorMemberNameData['name'],
                            'visitor_image_data' => $visitorImageData,
                            'visitor_mobile_no' => $visitorMemberNameData['visitor_mobile_no'],
                            'expected_start_date_time_display' => isValidDate($visitorMemberNameData['expected_start_date_time']) ? date('d M,Y h:i A', strtotime($visitorMemberNameData["expected_start_date_time"])) : "",
                            'expected_end_date_time_display' => isValidDate($visitorMemberNameData['expected_end_date_time']) ? date('d M,Y h:i A', strtotime($visitorMemberNameData["expected_end_date_time"])) : "",
                            'delivery_date_time_display' => isValidDate($visitorMemberNameData['delivery_date']) ? date('d M, Y h:i A', strtotime($visitorMemberNameData["delivery_date"])) : "",
                            'start_date_time_display' => isValidDate($visitorMemberNameData['start_date']) ? date('d M, Y h:i A', strtotime($visitorMemberNameData["start_date"])) : "",
                            'end_date_time_display' => isValidDate($visitorMemberNameData['end_date']) ? date('d M, Y h:i A', strtotime($visitorMemberNameData["end_date"])) : "",
                            'member_number' => $visitorMemberNameData['member_number'],
                            'resource_type_name' => $visitorMemberNameData['resource_type_name'],
                            'difference_start_end_date' => isset($differenecStartEndDate) ? $differenecStartEndDate : "",

                            // 'vehcal_data' => array("hi" => 1),
                            // 'visitor_type_color_code' => $visitorTypeDataColorCodeData[$type] ?? null,

                        );
                        if ($appType == GATE_KEEPER) {
                            $notificationArray['send_for_notification'] = $appType;
                            $notificationArray['send_for_notification_id'] = $userSocietyId;
                            $notificationArray['receive_for_notification'] = MEMBER_APP;
                            $notificationArray['receive_for_notification_id'] = $ownershipFlatMemberId;
                        }

                        if ($appType == MEMBER_APP) {
                            $notificationArray['send_for_notification'] = $appType;
                            $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                            $notificationArray['receive_for_notification'] = GATE_KEEPER;
                            $notificationArray['receive_for_notification_id'] = 0;
                        }

                        $extraDatajson = json_encode($notificationArray);
//                          printArray($notificationArray,1);
                        sendNotificationDataList($notificationArray, $extraDatajson);
                    }

                    // Working Day Store
                    if (is_array($workingDayNameArray)) {
                        foreach ($workingDayNameArray as $workingDay) {
                            $workingDayArray = array(
                                'visitor_working_day_id' => '',
                                'working_day_id' => $workingDay['working_day_id'],
                                'working_day_name' => $workingDay['working_day_name'],
                                'visitor_id' => $lastVisitorId,
                            );
                            $workingDayData = array();
                            $workingDayUpdateArray = array();
                            $workingDayObj['api_user_id'] = $userSocietyId;
                            $workingDayObj['society_id'] = $societyId;
                            $workingDayData['is_api_data'] = $workingDayObj;
                            $visitorWorkingDayData = $this->commonWebserviceModel->insertUpdateRecord($workingDayArray, 'visitor_working_day_id', 'tbl_visitor_working_day', 1, '', array(), $workingDayData, $workingDayUpdateArray);
                            $lastvisitorWorkingDayDataId = $visitorWorkingDayData['lastInsertedId'];
                        }
                    }
                    // Visitor Multiple Image Store
                    if ($lastVisitorId != '') {
                        if (isset($documentImageData) && count($documentImageData) > 0) {
                            $batchArray = array();
                            unset($documentImageData['success']);
                            foreach ($documentImageData as $key => $imageData) {
                                $dataArray = array(
                                    'document_image_id' => '',
                                    'document_type' => 'visitor',
                                    'document_type_id' => $lastVisitorId,
                                    'document_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                                    'created_by' => $userSocietyId,
                                    'updated_by' => $userSocietyId,
                                    'created_at' => date("Y-m-d H:i:s"),
                                    'updated_at' => date("Y-m-d H:i:s"),
                                );
                                array_push($batchArray, $dataArray);
                            }
                            $visitorExtraDataArray = array();
                            $visitorExtraDataArray['module_id'] = $lastVisitorId;
                            $visitorExtraDataArray['module'] = 'Visitor Image';
                            $visitorExtraDataArray['type'] = 'Visitor';
                            $visitorExtraDataArray['old_data'] = '';
                            $visitorExtraDataArray['user_id'] = $userSocietyId;
                            $visitorExtraDataArray['society_id'] = $societyId;
                            $this->visitorModel->batchInsert($batchArray, 'tbl_document_image', $visitorExtraDataArray);
                        }
                    }
                }
            }
        }

        $filterArray = array(
            'visitor_id' => $lastVisitorIdArray,
            'is_multiple' => 1,
            'is_deleted' => 0,
        );
        $visitorListData = visitorListData($filterArray, $userSocietyId);
        $transactionStatus = $this->db->transComplete();
        if (isset($visitorId) && !empty($visitorId)) {
            if ((isset($visitorData['success']) && $visitorData['success']) && ($transactionStatus == 1)) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.visitor')),
                    'data' => $visitorListData
                ), 200);
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.visitor')),
                    'data' => null
                ), 404);
            }
        } else {
            if ((isset($visitorData['success']) && $visitorData['success']) && ($transactionStatus == 1)) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.visitor')),
                    'data' => $visitorListData
                ), 200);
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.visitor')),
                    'data' => null
                ), 400);
            }
        }
    }


    public function visitorFetchDetail()
    {
        $visitorMobileNo = $this->request->getVar('visitor_mobile_no');
        $societyId = $this->request->getVar('society_id');

        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('visitor_mobile_no', lang('CommonWebService.visitor_mobile_no'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        }

        $visitorRecordData = $this->visitorModel->getVisitorData(array(
            'visitor_mobile_no' => $visitorMobileNo,
            'society_id' => $societyId,
        ));
        if(!empty($visitorRecordData)){
            $visitorRecordData['visitor_type_display'] = underscoreToUcWord($visitorRecordData["type"]);
            $visitorRecordData['status_display'] = underscoreToUcWord($visitorRecordData["status"]);
            $visitorRecordData['created_at_display'] = time_elapsed_string($visitorRecordData['created_at']);
            $visitorRecordData['updated_at_display'] = time_elapsed_string($visitorRecordData['updated_at']);
        }
        if(!empty($visitorRecordData)){
            return $this->response(array(
                'status' => true,
                'response_code' => 200,
                'message' => lang('CommonWebService.visitor_listing_successfully'),
                'data' => $visitorRecordData
            ), 200);
        }
        else 
        {
            return $this->response(array(
                'status' => false,
                'response_code' => 404,
                'message' => lang('CommonWebService.no_data_found'),
                'data' => null
            ), 400);
        }
    }

    public function sendNotification()
    {
        $this->db->transStart();
        $userSocietyId = $this->request->getVar('user_society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $appType = $this->request->getVar('app_type');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            if($appType == MEMBER_APP){
                $userDevice = $this->commonWebserviceModel->deviceData(array(
                    "user_type_id" => $ownershipFlatMemberId,
                    "user_type" => $appType,
                    "is_latest" => 1,
                ));
            }
            else{
                $userDevice = $this->commonWebserviceModel->deviceData(array(
                    "user_society_id" => $userSocietyId,
                    "user_type" => $appType,
                    "is_latest" => 1,
                ));
            }
            $notificationResponse = array();
            if (!empty($userDevice)) {
                if ($userDevice['one_signal_id'] != '' && $userDevice['device_id'] != '') {
                    $notificationArray = array(
                        'ownership_flat_id' => 0,
                        'ownership_flat_member_id' => isset($userDevice['user_type_id']) ? $userDevice['user_type_id'] : 0,
                        'type' => 'test_notification',
                        'status' => 'test_notification',
                        'society_id' => $societyId,
                        'user_society_id' => $userSocietyId,
                        'notification_title' =>  ' Test Notification',
                        'description' => 'Test Notification',
                        'module' => 'test_notification',
                        'device_type' => isset($userDevice['device_type']) ? strtolower($userDevice['device_type']) : '',
                        'notification_for' => isset($userDevice['device_type']) ? strtolower($userDevice['device_type']) : '',
                        'one_signal_id' => isset($userDevice['one_signal_id']) ? $userDevice['one_signal_id'] : '',
                        'device_id' => isset($userDevice['device_id']) ? $userDevice['device_id'] : '',
                        'receive_for_notification' => isset($userDevice['resource_type_id']) ? $userDevice['resource_type_id'] : '',
                        'app_type' => $appType,
                    );
                    $notificationOtherArray = array(
                        'notification_id' => '',
                        'ownership_flat_member_id' => $notificationArray['ownership_flat_member_id'],
                        'society_id' => $societyId,
                        'notification_title' =>  $notificationArray['notification_title'],
                        'description' => $notificationArray['description'],
                        'type' => 'test_notification',
                        'notification_for' => isset($userDevice['device_type']) ? strtolower($userDevice['device_type']) : '',
                        'notification_date' => TODAY_DATE_YMD,
                    );
                    if ($appType == GATE_KEEPER) {
                        $notificationOtherArray['send_for_notification'] = $appType;
                        $notificationOtherArray['send_for_notification_id'] = $userSocietyId;
                        $notificationOtherArray['receive_for_notification'] = GATE_KEEPER;
                        $notificationOtherArray['receive_for_notification_id'] = $userSocietyId;
                    }
                    if ($appType == MEMBER_APP) {
                        $notificationOtherArray['send_for_notification'] = $appType;
                        $notificationOtherArray['send_for_notification_id'] = $ownershipFlatMemberId;
                        $notificationOtherArray['receive_for_notification'] = MEMBER_APP;
                        $notificationOtherArray['receive_for_notification_id'] = $ownershipFlatMemberId;
                    }
                    if ($appType == MANAGER_APP) {
                        $notificationOtherArray['send_for_notification'] = $appType;
                        $notificationOtherArray['send_for_notification_id'] = $userSocietyId;
                        $notificationOtherArray['receive_for_notification'] = MANAGER_APP;
                        $notificationOtherArray['receive_for_notification_id'] = $userSocietyId;
                    }
                    $notificationOtherArray['extra_data'] = json_encode($notificationArray);
                    $customerData['extra_data_json'] = json_encode($notificationArray);
                    $customerData['description'] = 'Test Notification';
                    $customerData['notification_title'] = 'Test Notification';
                    $customerData['device_id'] = array($userDevice['device_id']);
                    $customerData['one_signal_id'] = $userDevice['one_signal_id'];
                    $customerData['device_token'] = $userDevice['device_token'];
                    $customerData['type'] = 'test_notification';
                    $customerData['notification_for'] = isset($userDevice['device_type']) ? strtolower($userDevice['device_type']) : '';
                    $extraData = array();
                    $extraObj['api_user_id'] = $userSocietyId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $notificationResponse = $this->notificationModel->insertUpdateRecord($notificationOtherArray, 'notification_id', 'tbl_notification', 1, '', array(), $extraData);
                     //send notification data
                    // if(strtolower($userDevice['device_type']) == 'android'){
                        $sendNotificationData[] = $customerData;
                        sendNotification($sendNotificationData,true);
                    // }
                    // else{
                    //     $sendNotificationData = $customerData;
                    //     sendNotificationIOS($sendNotificationData);
                    // }
                }   
            }
            $transactionStatus = $this->db->transComplete();
            if ((isset($notificationResponse['success']) && $notificationResponse['success']) && ($transactionStatus == 1)) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.notification_send_successfully'),
                    'data' => null
                ), 200);
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.notification_send_unsuccessfully'),
                    'data' => null
                ), 404);
            }
        }
    }


    public function visitorStatusChange()
    {

        $this->db->transStart();
        $visitorId = $this->request->getVar('visitor_id');
        $societyId = $this->request->getVar('society_id');
        $status = $this->request->getVar('status');
        $userSocietyId = $this->request->getVar('user_society_id');
        $isSelfApproved = $this->request->getVar('is_self_approved');
        $appType = $this->request->getVar('app_type');
        $isNotificationStatus = $this->request->getVar('is_notification_status');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('status', lang('CommonWebService.status'), 'required');
        $this->validation->setRule('visitor_id', lang('CommonWebService.visitor_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if ($appType == MEMBER_APP) {
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $visitorUpdateArray = array();
            $visitorStatusUpdateArray = array();
            $isInsertUpdate = 1;

            if (!empty($isSelfApproved)) {
                $visitorSelfApprovedData = $this->visitorModel->getVisitorData(array(
                    'order_by' => array(array("tv.self_approved_at" => "desc")),
                ));

                if (isValidDate($visitorSelfApprovedData['self_approved_at'])) {
                    $scanValidityTime = strtotime($visitorSelfApprovedData['self_approved_at'], strtotime("-30 seconds"));
                    $currentTime = strtotime(date("Y-m-d H:i:s", strtotime("-30 seconds")));

                    if ($currentTime < $scanValidityTime) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.wait_second_for_approval'),
                            'data' => null
                        ), 400);
                    }
                }
            }
            $visitorUpdateData = $this->visitorModel->getVisitorData(array(
                'visitor_id' => $visitorId,
                'is_deleted_not' => 1,
            ));

            // printArray($visitorUpdateData,1);

            $userData = $this->commonWebserviceModel->getUserSocietyData(array(
                'user_society_id' => $userSocietyId,
            ));
            $resourceTypeId = $userData['resource_type_id'];

            if (!empty($visitorUpdateData)) {
                if($visitorUpdateData['is_deleted'] == 1){
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => lang('CommonWebService.visitor_deleted'),
                        'data' => null
                    ), 404);
                }

                if ($visitorUpdateData['status'] == $status) {
                    $isInsertUpdate = 0;
                }
                if ($isInsertUpdate == 1) {

                    if ($status == 'entered' && $visitorUpdateData['type'] != 'resource' && $visitorUpdateData['visitor_duration'] != 'frequent') {
                        if ($visitorUpdateData['anytime_during_the_day'] == 0) {
                            $currentDateTime = date('Y-m-d H:i:s');
                            $startTime = $visitorUpdateData['expected_start_date_time'];
                            $endTime = $visitorUpdateData['expected_end_date_time'];
                            $currentDateTimeStamp = strtotime($currentDateTime);
                            $startTimeStamp = strtotime($startTime);
                            $endTimeStamp = strtotime($endTime);
                            if ($currentDateTimeStamp < $startTimeStamp || $currentDateTimeStamp > $endTimeStamp) {
                                return $this->response(array(
                                    'status' => false,
                                    'response_code' => 404,
                                    'message' => lang('CommonWebService.you_can_enter_between') . date('d M, Y h:i A', $startTimeStamp) . ' - ' . date('d M, Y h:i A', $endTimeStamp),
                                    'data' => null
                                ), 404);
                            }
                        }
                    }
                    $collectOnGate = isset($visitorUpdateData['collect_on_gate']) ? $visitorUpdateData['collect_on_gate'] : 0;

                    if($collectOnGate == 0){
                        if($status == 'entry_pre_approve'){
                            $status = 'entered';
                        }
                    }
                    $visitorArray = array(
                        'visitor_id' => $visitorId,
                        'status' => $status,
                    );
                    if (!empty($isSelfApproved)) {
                        $visitorArray['self_approved_at'] = date("Y-m-d H:i:s");
                        $visitorArray['self_approved_by'] = $userSocietyId;
                    }
                    $visitorImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $visitorId,
                        "document_type" => 'visitorId',
                    ));
                    $visitorImagePath = SITE_URL('uploads/no_image.png');
                    if (!empty($visitorImageData)) {
                        if (file_exists(DOCUMENT_IMAGE_PATH . $visitorImageData['document_image'])) {
                            $visitorImagePath = SITE_URL() . DOCUMENT_IMAGE_PATH . $visitorImageData["document_image"];
                        }
                    }
                    // $notificationArray = array(
                    //     'ownership_flat_member_id' => $visitorUpdateData['ownership_flat_member_id'],
                    //     'ownership_flat_id' => $visitorUpdateData['ownership_flat_id'],
                    //     'status' => $status,
                    //     'type' => $visitorUpdateData['type'],
                    //     'society_id' => $societyId,
                    //     'user_society_id' => $userSocietyId,
                    //     'type_id' => $visitorId,
                    //     'visitor_name' => $visitorUpdateData['visitor_name'],
                    //     'visitor_company_name' => $visitorUpdateData['visitor_company_name'],
                    //     'collect_on_gate' => $visitorUpdateData['collect_on_gate'],
                    //     'guard' => $visitorUpdateData['updated_by_name'],
                    //     'vehicle_no' => $visitorUpdateData['vehicle_no'],
                    //     'module' => 'visitor',
                    //     'app_type' => $appType,
                    //     'mobile_no' => $visitorUpdateData['visitor_mobile_no'],
                    //     'display_status' => underscoreToUcWord($status),
                    //     'image' => $visitorImagePath,
                    //     'member_name' => $visitorUpdateData['name'],
                    //     'is_self_approved' => $isSelfApproved,
                    // );
                    // if ($appType == GATE_KEEPER) {
                    //     $notificationArray['send_for_notification'] = $appType;
                    //     $notificationArray['send_for_notification_id'] = $userSocietyId;
                    //     $notificationArray['receive_for_notification'] = MEMBER_APP;
                    //     $notificationArray['receive_for_notification_id'] = $visitorUpdateData['ownership_flat_member_id'];
                    // }

                    // if ($appType == MEMBER_APP) {
                    //     $notificationArray['send_for_notification'] = $appType;
                    //     $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                    //     $notificationArray['receive_for_notification'] = GATE_KEEPER;
                    //     $notificationArray['receive_for_notification_id'] = 0;
                    // }

                    // // printArray($notificationArray,1);
                    // $extraDatajson = json_encode($notificationArray);
                    // sendNotificationDataList($notificationArray, $extraDatajson);


                    if ($status == 'entered') {
                        $visitorArray['start_date'] = date("Y-m-d H:i:s");
                    }
                    if (!empty($isNotificationStatus)) {
                        $visitorArray['expected_start_date_time'] = date("Y-m-d H:i:s");
                        $visitorArray['expected_end_date_time'] = date("Y-m-d H:i:s", strtotime('+2 hours'));
                        $visitorArray['is_visitor_approved'] = 1;
                        $visitorArray['is_visitor_approved_at'] = date("Y-m-d H:i:s");
                        $visitorArray['is_visitor_approved_by'] = $userSocietyId;
                    }
                    if ($status == 'exited') {
                        $visitorArray['end_date'] = date("Y-m-d H:i:s");

                    }
                    if ($status == 'collected') {
                        $visitorArray['delivery_date'] = date("Y-m-d H:i:s");
                    }
                    $visitorUpdateArray = compareArray($visitorArray, $visitorUpdateData);
                    $extraData = array();
                    $extraObj['api_user_id'] = $userSocietyId;
                    $extraObj['society_id'] = $societyId;
                    $extraData['is_api_data'] = $extraObj;
                    $visitorData = $this->commonWebserviceModel->insertUpdateRecord($visitorArray, 'visitor_id', 'tbl_visitor', 1, '', array(), $extraData, $visitorUpdateArray);
                    $lastVisitorId = $visitorData['lastInsertedId'];
                    $visitorStatusArray = array(
                        'visitor_status_history_id' => '',
                        'visitor_id' => $visitorUpdateData['visitor_id'],
                        'status' => $visitorUpdateData['status'],
                    );
                    $visitorStatusData = $this->commonWebserviceModel->insertUpdateRecord($visitorStatusArray, 'visitor_status_history_id', 'tbl_visitor_status_history', 1, '', array(), $extraData, $visitorStatusUpdateArray);
                    $visitorUpdateData = $this->visitorModel->getVisitorData(array(
                        'visitor_id' => $visitorId,
                        'is_deleted_not' => 1,
                    ));

                    $filterArray = array(
                        'visitor_id' => $visitorId,
                    );
                    // $visitorNotificationData = visitorListData($filterArray, $userSocietyId);

                    if($visitorUpdateData['status'] == 'entered' || $visitorUpdateData['status'] == 'exited'){
                        $endDate = isValidDate($visitorUpdateData['end_date']) ? $visitorUpdateData['end_date'] : date("Y-m-d H:i:s");
                        $differenecStartEndDate = calculateDateTimeDifference($visitorUpdateData['start_date'],$endDate);
                    }

                    $notificationArray = array(
                        'ownership_flat_member_id' => $visitorUpdateData['ownership_flat_member_id'],
                        'ownership_flat_id' => $visitorUpdateData['ownership_flat_id'],
                        'status' => $status,
                        'type' => $visitorUpdateData['type'],
                        'society_id' => $societyId,
                        'user_society_id' => $userSocietyId,
                        'type_id' => $visitorId,
                        'visitor_name' => $visitorUpdateData['visitor_name'],
                        'visitor_company_name' => $visitorUpdateData['visitor_company_name'],
                        'collect_on_gate' => $visitorUpdateData['collect_on_gate'],
                        'guard' => $visitorUpdateData['updated_by_name'],
                        'vehicle_no' => $visitorUpdateData['vehicle_no'],
                        'module' => 'visitor',
                        'app_type' => $appType,
                        'mobile_no' => $visitorUpdateData['visitor_mobile_no'],
                        'display_status' => underscoreToUcWord($status),
                        'status_display' => underscoreToUcWord($status),
                        'image' => $visitorImagePath,
                        'member_name' => $visitorUpdateData['name'],
                        'is_self_approved' => $isSelfApproved,
                        'name' => $visitorUpdateData['name'],
                        'visitor_image_data' => $visitorImagePath,
                        'visitor_mobile_no' => $visitorUpdateData['visitor_mobile_no'],
                        'expected_start_date_time_display' => isValidDate($visitorUpdateData['expected_start_date_time']) ? date('d M,Y h:i A', strtotime($visitorUpdateData["expected_start_date_time"])) : "",
                        'expected_end_date_time_display' => isValidDate($visitorUpdateData['expected_end_date_time']) ? date('d M,Y h:i A', strtotime($visitorUpdateData["expected_end_date_time"])) : "",
                        'delivery_date_time_display' => isValidDate($visitorUpdateData['delivery_date']) ? date('d M, Y h:i A', strtotime($visitorUpdateData["delivery_date"])) : "",
                        'start_date_time_display' => isValidDate($visitorUpdateData['start_date']) ? date('d M, Y h:i A', strtotime($visitorUpdateData["start_date"])) : "",
                        'end_date_time_display' => isValidDate($visitorUpdateData['end_date']) ? date('d M, Y h:i A', strtotime($visitorUpdateData["end_date"])) : "",
                        'member_number' => $visitorUpdateData['member_number'],
                        'resource_type_name' => $visitorUpdateData['resource_type_name'],
                        'difference_start_end_date' => isset($differenecStartEndDate) ? $differenecStartEndDate : "",
                        // 'visitor_data' => $visitorNotificationData,
                    );
                    if ($appType == GATE_KEEPER) {
                        $notificationArray['send_for_notification'] = $appType;
                        $notificationArray['send_for_notification_id'] = $userSocietyId;
                        $notificationArray['receive_for_notification'] = MEMBER_APP;
                        $notificationArray['receive_for_notification_id'] = $visitorUpdateData['ownership_flat_member_id'];
                    }

                    if ($appType == MEMBER_APP) {
                        $notificationArray['send_for_notification'] = $appType;
                        $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                        $notificationArray['receive_for_notification'] = GATE_KEEPER;
                        $notificationArray['receive_for_notification_id'] = 0;
                    }

                    // printArray($notificationArray,1);
                    $extraDatajson = json_encode($notificationArray);
                    sendNotificationDataList($notificationArray, $extraDatajson);
                }

                $filterArray = array(
                    'visitor_id' => $visitorId,
                    'is_multiple' => 1,
                    'is_deleted' => 0,
                );
                $visitorListData = visitorListData($filterArray, $userSocietyId);


            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.status_change_unsuccessfully'),
                    'data' => null
                ), 404);
            }

            if ($isInsertUpdate == 0) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.this_visitor_is_already') . underscoreToUcWord($status),
                    'data' => $visitorListData
                ), 200);
            }
            $transactionStatus = $this->db->transComplete();
            if ((isset($visitorData['success']) && $visitorData['success']) && ($transactionStatus == 1)) {
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.status_change_successfully'),
                    'data' => $visitorListData
                ), 200);
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.status_change_unsuccessfully'),
                    'data' => null
                ), 404);
            }
        }
    }

    public function userLogin()
    {
        $mobileNo = $this->request->getVar('mobile_no');
        $deviceId = $this->request->getVar('device_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('mobile_no', lang('CommonWebService.mobile_no'), 'required|max_length[10]|min_length[10]');
        $this->validation->setRule('device_id', lang('CommonWebService.device_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            if($appType == MEMBER_APP){
                $resourceTypeData = $this->resourceTypeModel->getResourceTypeViewData(array(
                    'resource_type_name' => RESOURCE_TYPE_MEMBER,
                    'is_multiple' => 1
                ));
            }
            if($appType == MANAGER_APP){
                $resourceTypeData = $this->resourceTypeModel->getResourceTypeViewData(array(
                    'resource_type_name' => RESOURCE_TYPE_MANAGER,
                    'is_multiple' => 1
                ));

            }
            if($appType == GATE_KEEPER){
                $resourceTypeData = $this->resourceTypeModel->getResourceTypeViewData(array(
                    'resource_type_name_not' => array(RESOURCE_TYPE_MANAGER,RESOURCE_TYPE_MEMBER),
                    'is_multiple' => 1,
                    'is_login' => 1,
                    'is_guard' => 1,
                    'is_active' => 1,
                ));

            }

            // printArray($resourceTypeData,1);
            
            $resourceTypeIdArray = [];
            if(!empty($resourceTypeData)){
                foreach ($resourceTypeData as $resourceTypeElement) {
                    $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                }
            }
            
            $userFilterArray = array(
                'phone' => $mobileNo,
                'resource_type_id' => $resourceTypeIdArray,
                'is_active' => 1,
                'is_multiple' => 1
            );
            if($appType == MEMBER_APP){
                $userFilterArray['is_member_login'] = 1;
            }
            $userSocietyData = $this->commonWebserviceModel->getUserSocietyData($userFilterArray);


            // printArray($resourceTypeData,1);
            if (empty($userSocietyData)) {
                return $this->response(array(
                    'status' => FALSE,
                    'message' => lang('CommonWebService.kindly_contact_society_admin'),
                    'data' => null,
                    'response_code' => 200
                ), 200);
            }
            if (!empty($userSocietyData)) {
                if (isset($userSocietyData['active']) && $userSocietyData['active'] != 1) {
                    //return $this->respond(array(
                    return $this->response(array(
                        'status' => FALSE,
                        'message' => lang('CommonWebService.user_account_is_inactive'),
                        'data' => null,
                        'response_code' => 200
                    ), 200);
                }
            }
            $isUserMultipleSociety = count($userSocietyData);
            $isSocietySelectRequired = 0;
            $isFlatSelectRequired = 0;
            if ($isUserMultipleSociety > 1) {
                $isSocietySelectRequired = 1;
                if (!empty($userSocietyData)) {
                    $data = array(
                        'status' => TRUE,
                        'message' => lang('CommonWebService.login_successfully'),
                        'society_data' => $userSocietyData,
                        'is_society_selection_required' => $isSocietySelectRequired,
                        'response_code' => 200,
                    );
                    return $this->response($data, 200);
                } else {
                    $data = array(
                        'status' => false,
                        'message' => lang('CommonWebService.no_data_found'),
                        'data' => $userSocietyData,
                        'response_code' => 404,
                    );
                    return $this->response($data, 404);
                } 
            }
            else{

                if($appType == MEMBER_APP){
                    $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                        'phone' => $mobileNo,
                        'resource_type_id' => $resourceTypeIdArray,
                    ));

                    if(!empty($userSocietyData)){
                        $ownershipFlatMemberMobileData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'member_id' => $userSocietyData['type_id'],
                            'society_id' => $userSocietyData['society_id'],
                            'is_active' => 1,
                            'is_db_connect' => 1,
                            'is_multiple' => 1,
                        ));
                        $rentalMemberMobileData = $this->rentalModel->getRentalsMemberData(array(
                            'member_id' => $userSocietyData['type_id'],
                            'society_id' => $userSocietyData['society_id'],
                            'is_active' => 1,
                            'is_db_connect' => 1,
                            'is_multiple' => 1,
                        ));
                        $ownershipFlatMemberData = array_merge($ownershipFlatMemberMobileData,$rentalMemberMobileData);
                        $isUserMultipleFlat = count($ownershipFlatMemberData);
                        if($isUserMultipleFlat > 1){
                            $isFlatSelectRequired = 1;
                            $userSocietyData['user_society_flat_data'] = $ownershipFlatMemberData;
                        }
                        else{
                            // printArray($userSocietyData,1);
                            $password = PASSWORD;
                            $userSocietyArray = [];
                            if (!empty($userSocietyData)) {
                                $otpValidity = date('Y-m-d H:i:s', strtotime('+15 minutes'));
                               
                                if (DEV_ENVIRONMENT == 'production') {
                                    if (isset($userSocietyData['phone']) && $userSocietyData['phone'] == '8976677224') {
                                        $otp = OTP_CODE;
                                    } else {
                                        $otp = GenRandomNumber(6);
                                    }
                                } else {
                                    $otp = OTP_CODE;
                                }
                                $userSocietyArray = [
                                    'user_society_id' => $userSocietyData['user_society_id'],
                                    'otp' => $otp,
                                    'otp_validity' => $otpValidity,
                                ];
                            
                                if(!empty($userSocietyArray)){
                                    $this->commonWebserviceModel->insertUpdateRecord($userSocietyArray, 'user_society_id', 'tbl_user_society');
                                }
                            }
                            $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                                'phone' => $mobileNo,
                                'resource_type_id' => $resourceTypeIdArray,
                            ));
                            
                            if (!empty($userDataFilter)) {
                                $userDataFilter['is_password_empty'] = empty($userDataFilter['password']) ? 1 : 0;

                                $isUserMultipleFlat = 0;
                                $memberId = isset($userSocietyData['type_id']) ? $userSocietyData['type_id'] : -9;
                                $societyId = isset($userSocietyData['society_id']) ? $userSocietyData['society_id'] : -9;
                                $ownershipFlatMemberData = array();           
                                $ownershipFlatMemberMobileData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                    'member_id' => $memberId,
                                    'society_id' => $societyId,
                                    'is_db_connect' => 1,
                                    'is_active' => 1,
                                    'is_multiple' => 1,
                                ));
                                $rentalMemberMobileData = $this->rentalModel->getRentalsMemberData(array(
                                    'member_id' => $memberId,
                                    'society_id' => $societyId,
                                    'is_db_connect' => 1,
                                    'is_active' => 1,
                                    'is_multiple' => 1,
                                ));             
                                $ownershipFlatMemberData = array_merge($ownershipFlatMemberMobileData,$rentalMemberMobileData);
                                $isUserMultipleFlat = count($ownershipFlatMemberData); 
                                if ($isUserMultipleFlat == 1) {    
                                    $userDataFilter['user_society_flat_data'] = $ownershipFlatMemberData;
                                }
                                
                            }
                            $userSocietyData = $userDataFilter;                           
                        }
                    }
                    if (!empty($userSocietyData)) {
                        $data = array(
                            'status' => TRUE,
                            'message' => lang('CommonWebService.login_successfully'),
                            'data' => $userSocietyData,
                            'is_society_selection_required' => $isSocietySelectRequired,
                            'is_flat_selection_required' => $isFlatSelectRequired,
                            'response_code' => 200,
                        );
                        return $this->response($data, 200);
                    } else {
                        $data = array(
                            'status' => false,
                            'message' => lang('CommonWebService.no_data_found'),
                            'data' => $userSocietyData,
                            'response_code' => 404,
                        );
                        return $this->response($data, 404);
                    }
                }                        
                if($appType == MANAGER_APP || $appType == GATE_KEEPER){
                    $password = PASSWORD;
                    $userSocietyArray = [];
                    if (!empty($userSocietyData)) {
                        $otpValidity = date('Y-m-d H:i:s', strtotime('+15 minutes'));
                        foreach ($userSocietyData as $userSocietyElement) {
                            // Set OTP for each user
                            if (DEV_ENVIRONMENT == 'production') {
                                if (isset($userSocietyElement['phone']) && $userSocietyElement['phone'] == '8976677224') {
                                    $otp = OTP_CODE;
                                } else {
                                    $otp = GenRandomNumber(6);
                                }
                            } else {
                                $otp = OTP_CODE;
                            }
                            $userSocietyArray[] = [
                                'user_society_id' => $userSocietyElement['user_society_id'],
                                'otp' => $otp,
                                'otp_validity' => $otpValidity,
                            ];
                        }
                        if(!empty($userSocietyArray)){
                            $this->commonWebserviceModel->batchUpdate($userSocietyArray, 'user_society_id', 'tbl_user_society');
                        }
                    }
                    $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                        'phone' => $mobileNo,
                        'resource_type_id' => $resourceTypeIdArray,
                    ));
                    if ($appType == GATE_KEEPER) {
                        if (!empty($userDataFilter)) {
                            $userDataFilter['is_pin_empty'] = empty($userDataFilter['pin']) ? 1 : 0;
                        }
                    }
                    if ($appType == MANAGER_APP) {
                        if (!empty($userDataFilter)) {
                            $userDataFilter['is_pin_empty'] = empty($userDataFilter['pin']) ? 1 : 0;
                        }
                    }
                    $userSocietyData = $userDataFilter;
                    if (!empty($userSocietyData)) {
                        $data = array(
                            'status' => TRUE,
                            'message' => lang('CommonWebService.login_successfully'),
                            'data' => $userSocietyData,
                            'is_society_selection_required' => $isSocietySelectRequired,
                            'response_code' => 200,
                        );
                        return $this->response($data, 200);
                    } else {
                        $data = array(
                            'status' => false,
                            'message' => lang('CommonWebService.no_data_found'),
                            'data' => $userSocietyData,
                            'response_code' => 404,
                        );
                        return $this->response($data, 404);
                    }

                }
                
            }

        }
    }

    function userSocietyLogin()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'user_society_id' => $userSocietyId,
                'society_id' => $societyId,
            );
            $userSocietyData = $this->commonWebserviceModel->getUserSocietyData($filterArray);
            if (empty($userSocietyData)) {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.invalid_society'),
                    'data' => $userSocietyData,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
            
            if ($appType == MEMBER_APP) {
                $isUserMultipleFlat = 0;
                $memberId = isset($userSocietyData['type_id']) ? $userSocietyData['type_id'] : -9;
                $ownershipFlatMemberData = array();           
                $ownershipFlatMemberMobileData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'member_id' => $memberId,
                    'society_id' => $societyId,
                    'is_active' => 1,
                    'is_multiple' => 1,
                ));
                $rentalMemberMobileData = $this->rentalModel->getRentalsMemberData(array(
                    'member_id' => $memberId,
                    'society_id' => $societyId,
                    'is_active' => 1,
                    'is_multiple' => 1,
                ));
                                            
                $ownershipFlatMemberData = array_merge($ownershipFlatMemberMobileData,$rentalMemberMobileData);
                $isUserMultipleFlat = count($ownershipFlatMemberData);
                if ($isUserMultipleFlat > 1) {
                    if (!empty($userSocietyData)) {
                        $userType = isset($userSocietyData['resource_type_id']) ? $userSocietyData['resource_type_id'] : '';
                        // $userSocietyData['is_flat_selection_required'] = 1;
                        $userSocietyData['user_society_flat_data'] = $ownershipFlatMemberData;
                    }
                    if (!empty($userSocietyData)) {
                        $data = array(
                            'status' => true,
                            'message' => lang('CommonWebService.user_society_login_successfully'),
                            'data' => $userSocietyData,
                            'is_flat_selection_required' => 1,
                            'response_code' => 200,
                        );
                        return $this->response($data, 200);
                    } else {
                        $data = array(
                            'status' => false,
                            'message' => lang('CommonWebService.no_data_found'),
                            'data' => $userSocietyData,
                            'response_code' => 404,
                        );
                        return $this->response($data, 404);
                    }
                } else {
                    $password = PASSWORD;
                    if (!empty($userSocietyData)) {
                        $otpValidity = date('Y-m-d H:i:s', strtotime('+15 minutes'));
                        $otp = OTP_CODE;
                        if (DEV_ENVIRONMENT == 'production') {
                            if (isset($userSocietyData['phone']) && $userSocietyData['phone'] == '8976677224') {
                                $otp = OTP_CODE;
                            } else {
                                $otp = GenRandomNumber(6);
                            }
                        }
                        $userSocietyArray = [
                            'user_society_id' => $userSocietyId,
                            'otp' => $otp,
                            'otp_validity' => $otpValidity,
                        ];
                        $this->commonWebserviceModel->updateData($userSocietyArray, 'tbl_user_society', 'user_society_id', $userSocietyId);
                    }
                    
                    
                    $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                        'user_society_id' => $userSocietyId,
                    ));
                    if (!empty($userDataFilter)) {
                        $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                        // $userDataFilter['is_flat_selection_required'] = 0;
                        $userDataFilter['user_society_flat_data'] = $ownershipFlatMemberData;
                        $userDataFilter['is_password_empty'] = empty($userDataFilter['password']) ? 1 : 0;
                    }
                    $userSocietyData = $userDataFilter;
                    if (!empty($userSocietyData)) {
                        $data = array(
                            'status' => true,
                            'message' => lang('CommonWebService.user_society_login_successfully'),
                            'data' => $userSocietyData,
                            'is_flat_selection_required' => 0,
                            'response_code' => 200,
                        );
                        return $this->response($data, 200);
                    } else {
                        $data = array(
                            'status' => false,
                            'message' => lang('CommonWebService.no_data_found'),
                            'data' => $userSocietyData,
                            'response_code' => 404,
                        );
                        return $this->response($data, 404);
                    }
                }
            }

            if ($appType == GATE_KEEPER || $appType == MANAGER_APP) {
                $otp = OTP_CODE;
                if (DEV_ENVIRONMENT == 'production') {
                    if (isset($userSocietyData['phone']) && $userSocietyData['phone'] == '8976677224') {
                        $otp = OTP_CODE;
                    } else {
                        $otp = GenRandomNumber(6);
                    }
                }
                $otpValidity = date('Y-m-d H:i:s', strtotime(' +15 minutes'));
                $userArray['otp'] = $otp;
                $userArray['otp_validity'] = $otpValidity;
                $this->commonWebserviceModel->updateData($userArray, 'tbl_user_society', 'user_society_id', $userSocietyId);

                $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                    'user_society_id' => $userSocietyId,
                ));
                if (!empty($userDataFilter)) {
                    $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                    $userDataFilter['is_pin_empty'] = empty($userDataFilter['pin']) ? 1 : 0;
                }
                if (!empty($userDataFilter)) {
                    $data = array(
                        'status' => true,
                        'message' => lang('CommonWebService.user_society_login_successfully'),
                        'data' => $userDataFilter,
                        'response_code' => 200,
                    );
                    return $this->response($data, 200);
                } else {
                    $data = array(
                        'status' => false,
                        'message' => lang('CommonWebService.no_data_found'),
                        'data' => $userDataFilter,
                        'response_code' => 404,
                    );
                    return $this->response($data, 404);
                }
            }

        }
    }

    function userSocietyFlatLogin()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'user_society_id' => $userSocietyId,
            );
            $userSocietyData = $this->commonWebserviceModel->getUserSocietyData($filterArray);

            $memberId = isset($userSocietyData['member_id']) ? $userSocietyData['member_id'] : -9;

            $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'member_id' => $memberId,
            ));

            $ownershipFlatMemberFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'society_id' => $societyId,
                'is_active' => 1,
                'is_multiple' => 1,
            ));
        
    
            $rentalFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'society_id' => $societyId,
                'is_active' => 1,
                'is_multiple' => 1,
            ));
            
            $ownershipFlatMemberData = array_merge($ownershipFlatMemberFlatData,$rentalFlatMemberData);     

            if (empty($ownershipFlatMemberData)) {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.invalid_society_flat'),
                    'data' => $ownershipFlatMemberData,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
            $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                'user_society_id' => $userSocietyId
            ));
            
            $password = PASSWORD;
            if (!empty($userSocietyData)) {
                $otpValidity = date('Y-m-d H:i:s', strtotime('+15 minutes'));
                $otp = OTP_CODE;
                if (DEV_ENVIRONMENT == 'production') {
                    if (isset($userSocietyData['phone']) && $userSocietyData['phone'] == '8976677224') {
                        $otp = OTP_CODE;
                    } else {
                        $otp = GenRandomNumber(6);
                    }
                }
                $userSocietyArray = [
                    'user_society_id' => $userSocietyId,
                    'otp' => $otp,
                    'otp_validity' => $otpValidity,
                ];
                $this->commonWebserviceModel->updateData($userSocietyArray, 'tbl_user_society', 'user_society_id', $userSocietyId);
            }
            
            
            $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                'user_society_id' => $userSocietyId,
            ));

            if (!empty($userDataFilter)) {
                $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                $userDataFilter['user_society_flat_data'] = $ownershipFlatMemberData;
            }
            if (!empty($userDataFilter)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.user_society_flat_login_successfully'),
                    'data' => $userDataFilter,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $userDataFilter,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function submitOtp()
    {
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $otp = $this->request->getVar('otp');
        $pin = $this->request->getVar('pin');
        $appType = $this->request->getVar('app_type');
        $password = $this->request->getVar('password');
        $loginType = $this->request->getVar('login_type');

        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        if ($appType == "member") {
            $this->validation->setRule('login_type', lang('CommonWebService.login_type'), 'required');
        }
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $filterArray = array(
                'user_society_id' => $userSocietyId,
            );
            
            $userSocietyData = $this->commonWebserviceModel->getUserSocietyData($filterArray);

            if ($appType == MEMBER_APP) {

                $isUserMultipleFlat = 0;
                $memberId = isset($userSocietyData['type_id']) ? $userSocietyData['type_id'] : -9;
                $ownershipFlatMemberData = array();           
                $ownershipFlatMemberMobileData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'member_id' => $memberId,
                    'society_id' => $societyId,
                    'is_active' => 1,
                    'is_multiple' => 1,
                ));
                $rentalMemberMobileData = $this->rentalModel->getRentalsMemberData(array(
                    'member_id' => $memberId,
                    'society_id' => $societyId,
                    'is_active' => 1,
                    'is_multiple' => 1,
                ));
                                            
                $ownershipFlatMemberData = array_merge($ownershipFlatMemberMobileData,$rentalMemberMobileData);
                $isUserMultipleFlat = count($ownershipFlatMemberData); 
                if ($isUserMultipleFlat == 1) {    
                    $userSocietyData['user_society_flat_data'] = $ownershipFlatMemberData;
                } 
                
                if (!empty($userSocietyData)) {
                    if (strtolower($loginType) == 'otp') {
                        $otpValidityTime = strtotime($userSocietyData['otp_validity']);
                        $currentTime = strtotime(date("Y-m-d H:i:s"));
                        if ($otp != $userSocietyData['otp']) {
                            return $this->response(array(
                                'status' => false,
                                'response_code' => 404,
                                'message' => lang('CommonWebService.invalid_otp_code'),
                                'data' => null
                            ), 400);
                        } else if ($currentTime > $otpValidityTime) {
                            return $this->response(array(
                                'status' => false,
                                'response_code' => 404,
                                'message' => lang('CommonWebService.otp_code_expired'),
                                'data' => null
                            ), 400);
                        } else {
                            $token = '';
                            $jwtSecretKey = getenv('JWT_SECRET');
                            $iat = time(); // current timestamp value
                            //$exp = $iat + 36000;
                            $exp = $iat + (30 * 86400); // Expires in 7 days
                            $payload = array(
                                "iss" => "Issuer of the JWT",
                                "aud" => "Audience that the JWT",
                                "sub" => "Subject of the JWT",
                                "iat" => $iat, //Time the JWT issued at
                                "exp" => $exp, // Expiration time of token
                                "email" => $userSocietyData['email'],
                                "user_id" => $userSocietyData['user_society_id']
                            );
                            $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                            return $this->response(array(
                                'status' => true,
                                'response_code' => 200,
                                'message' => lang('CommonWebService.otp_verified_successfully'),
                                'data' => $userSocietyData,
                                "token" => $token,
                            ), 200);
                        }
                    }
                    if (strtolower($loginType) == 'password') {
                        $dbPassword = $userSocietyData['password'];
                        $checkPasswordData = $this->commonWebserviceModel->passwordCheck(array(
                            'db_password' => $dbPassword,
                            'password' => $password
                        ));
                        if (!$checkPasswordData) {
                            return $this->response(array(
                                'status' => FALSE,
                                'message' => lang('CommonWebService.invalid_password'),
                                'data' => null,
                                'response_code' => 200,
                            ), 200);
                        } else {
                            $token = '';

                            $jwtSecretKey = getenv('JWT_SECRET');
                            $iat = time(); // current timestamp value
                            //$exp = $iat + 36000;
                            $exp = $iat + (30 * 86400); // Expires in 7 days
                            $payload = array(
                                "iss" => "Issuer of the JWT",
                                "aud" => "Audience that the JWT",
                                "sub" => "Subject of the JWT",
                                "iat" => $iat, //Time the JWT issued at
                                "exp" => $exp, // Expiration time of token
                                "email" => $userSocietyData['email'],
                                "user_id" => $userSocietyData['user_society_id']
                            );
                            $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                            
                            return $this->response(array(
                                'status' => true,
                                'response_code' => 200,
                                'message' => lang('CommonWebService.password_verified_successfully'),
                                'data' => $userSocietyData,
                                "token" => $token,
                            ), 200);
                        }
                    }

                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strtoupper($loginType) . ' ' . lang('CommonWebService.verified_unsuccessfully'),
                        'data' => null
                    ), 400);
                }
            }


            if ($appType == GATE_KEEPER) {

                $isUpdatePinRequired = 0;
                if (!empty($userSocietyData)) {
                    if (empty($userSocietyData['pin'])) {
                        $isUpdatePinRequired = 1;
                        if (empty($pin)) {
                            return $this->response(array(
                                'status' => FALSE,
                                'message' => "Please Enter Pin",
                                'data' => null,
                                'response_code' => 400,
                            ), 400);
                        }
                    }

                    $otpValidityTime = strtotime($userSocietyData['otp_validity']);
                    $currentTime = strtotime(date("Y-m-d H:i:s"));
                    if ($otp != $userSocietyData['otp']) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.invalid_otp_code'),
                            'data' => null
                        ), 400);
                    } else if ($currentTime > $otpValidityTime) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.otp_code_expired'),
                            'data' => null
                        ), 400);
                    } else {
                        if ($isUpdatePinRequired == 1 || $pin != '') {

                            $filterPin = $this->ionAuthModel->hashPassword($pin);
                            $userPinArray['pin'] = $filterPin;
                            $userPinArray['updated_at'] = date('Y-m-d H:i:s');
                            $userPinArray['updated_by'] = $userSocietyData['user_society_id'];
                            $this->commonWebserviceModel->updateData($userPinArray, 'tbl_user_society', 'user_society_id', $userSocietyId);
                        }

                        
                        $isUserSocietyApi = 0;
                        $jwtSecretKey = getenv('JWT_SECRET');
                        $iat = time(); // current timestamp value
                        //$exp = $iat + 36000;
                        $exp = $iat + (30 * 86400); // Expires in 7 days
                        $payload = array(
                            "iss" => "Issuer of the JWT",
                            "aud" => "Audience that the JWT",
                            "sub" => "Subject of the JWT",
                            "iat" => $iat, //Time the JWT issued at
                            "exp" => $exp, // Expiration time of token
                            "email" => $userSocietyData['email'],
                            "user_id" => $userSocietyData['user_society_id']
                        );
                        $token = JWT::encode($payload, $jwtSecretKey, 'HS256');

                        return $this->response(array(
                            'status' => true,
                            'response_code' => 200,
                            'message' => lang('CommonWebService.otp_verified_successfully'),
                            'data' => $userSocietyData,
                            "token" => $token,
                        ), 200);
                    }
                }
            }

            if ($appType == MANAGER_APP) {
                if (!empty($userSocietyData)) {
                    $otpValidityTime = strtotime($userSocietyData['otp_validity']);
                    $currentTime = strtotime(date("Y-m-d H:i:s"));
                    if ($otp != $userSocietyData['otp']) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.invalid_otp_code'),
                            'data' => null
                        ), 400);
                    } else if ($currentTime > $otpValidityTime) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.otp_code_expired'),
                            'data' => null
                        ), 400);
                    } else {
                        
                        $jwtSecretKey = getenv('JWT_SECRET');
                        $iat = time(); // current timestamp value
                        //$exp = $iat + 36000;
                        $exp = $iat + (30 * 86400); // Expires in 7 days
                        $payload = array(
                            "iss" => "Issuer of the JWT",
                            "aud" => "Audience that the JWT",
                            "sub" => "Subject of the JWT",
                            "iat" => $iat, //Time the JWT issued at
                            "exp" => $exp, // Expiration time of token
                            "email" => $userSocietyData['email'],
                            "user_id" => $userSocietyData['user_society_id']
                        );
                        $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                        return $this->response(array(
                            'status' => true,
                            'response_code' => 200,
                            'message' => lang('CommonWebService.otp_verified_successfully'),
                            'data' => $userSocietyData,
                            "token" => $token,
                        ), 200);
                    }
                }
            }
        }
    }

    public function resendOtp()// not
    {
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $userSocietyId = $this->request->getVar('user_society_id');
            $appType = $this->request->getVar('app_type');

            $filterArray = array(
                'user_society_id' => $userSocietyId,
            );
            
            $userSocietyData = $this->commonWebserviceModel->getUserSocietyData($filterArray);

            if (!empty($userSocietyData)) {
                $otpValidityTime = strtotime($userSocietyData['updated_at'], strtotime("-60 seconds"));
                $currentTime = strtotime(date("Y-m-d H:i:s", strtotime("-60 seconds")));
                if ($currentTime < $otpValidityTime) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => lang('CommonWebService.otp_send_every_second'),
                        'data' => null
                    ), 400);
                } else {
                    $otp = OTP_CODE;
                    $mobileNo = isset($userSocietyData['phone']) ? $userSocietyData['phone'] : "";
                    if (DEV_ENVIRONMENT == 'production') {
                        if ($mobileNo == '8976677224') {
                            $otp = OTP_CODE;
                        } else {
                            $otp = GenRandomNumber(6);
                        }
                    }
                    $otpValidity = date('Y-m-d H:i:s', strtotime(' +15 minutes'));
                    $otpArray = array(
                        'user_society_id' => $userSocietyId,
                        'otp' => $otp,
                        'otp_validity' => $otpValidity,
                        'updated_at' => DATE_TIME_DATABASE
                    );

                    $this->commonWebserviceModel->updateData($otpArray, 'tbl_user_society', 'user_society_id', $userSocietyId);

                    $userSocietyDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                        'user_society_id' => $userSocietyId,
                    ));

                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => lang('CommonWebService.otp_send_successfully'),
                        'data' => $userSocietyDataFilter,
                    ), 200);
                }
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => null
                ), 400);
            }
        }
    }

    public function addEditMember() // Not
    {
        $this->db->transStart();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $userId = $this->request->getVar('user_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $name = $this->request->getVar('name');
        $email = $this->request->getVar('email');
        $mobileNo = $this->request->getVar('mobile_no');
        $gender = $this->request->getVar('gender');
        $relation = $this->request->getVar('relation');
        $birthDate = $this->request->getVar('birth_date');
        $bloodGroup = $this->request->getVar('blood_group');
        $relation = $this->request->getVar('relation');
        $foodLike = $this->request->getVar('food_like');
        $isOwner = $this->request->getVar('is_owner');
        $isEdit = $this->request->getVar('is_edit');
        $isStatusChange = $this->request->getVar('is_status_change');
        $memberImage = $this->request->getVar('member_image');
        $memberId = $this->request->getVar('member_id');
        $editMemberId = $this->request->getVar('edit_member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $remarks = $this->request->getVar('remarks');
        $useExistsMember = $this->request->getVar('use_exists_member');

        $this->validation->setRule('ownership_flat_id', lang('CommonWebService.ownership_flat_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('name', lang('CommonWebService.name'), 'required');
        $this->validation->setRule('mobile_no', lang('CommonWebService.mobile_no'), 'required');
        $this->validation->setRule('gender', lang('CommonWebService.gender'), 'required');
        $this->validation->setRule('birth_date', lang('CommonWebService.birth_date'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            $existsMobileNoData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'mobile_no' => $mobileNo,
                'ownership_flat_id' => $ownershipFlatId,
                'member_id_not' => $memberId,
                'is_multiple' => 1,
            ));

            if (!empty($existsMobileNoData)) {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => "Members Mobiles Numbers Can't Be Same",
                    'data' => null
                ), 404);
            }

            $oldOwnershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'type_id' => $ownershipFlatId,
                'is_multiple' => 1,
                'is_active' => 1,
                'society_id' => $societyId,
            ));

            $filterMobileNoArray[] = $mobileNo;

            if(isset($oldOwnershipFlatMemberData) && !empty($oldOwnershipFlatMemberData)){
                foreach($oldOwnershipFlatMemberData as $oldMemberData){
                    if(isset($oldMemberData['mobile_no'])) {
                        $filterMobileNoArray[] = $oldMemberData['mobile_no'];
                    }
                }
            }

            $filterMobileNoArray = array_filter($filterMobileNoArray, function($value, $key) {
                return !empty($value);
            }, ARRAY_FILTER_USE_BOTH);

            // Exists Member-Data
            $resourceTypeMemberId = getResourceTypeId(RESOURCE_TYPE_MEMBER);

            $existsUserData = $this->commonWebserviceModel->getUserSocietyData(array(
                'phone' => $filterMobileNoArray,
                'is_multiple' => 1
            ));

            $existsUserMemberData = $this->commonWebserviceModel->getUserSocietyData(array(
                'phone' => $filterMobileNoArray,
                'is_multiple' => 1,
                'is_member' => 1,
            ));

            $resourceTypeMemberData = $this->resourceTypeModel->getResourceTypeData(array(
                "resource_type_name" => RESOURCE_TYPE_MEMBER,
                "society_id" => $societyId,
            ));

            // if (!empty($isStatusChange)) {
            //     $ownershipFlatMemberArray = array(
            //         'ownership_flat_member_id' => $editMemberId,
            //         'is_active' => 0,
            //         'remarks' => $remarks,
            //     );
            // } else {

                if (isset($_FILES["member_image"])) {
                    $memberImagePath = FLAT_MEMBER_IMAGE_PATH;
                    $memberImageResult = $dt_ci_file_upload->uploadFile('member_image', MAX_IMAGE_SIZE_LIMIT, $memberImagePath, true, true, array('jpeg', 'png', 'jpg'));
                    if ($memberImageResult['success'] == false) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => strip_tags($memberImageResult['message']),
                            'data' => null
                        ), 404);
                    } else {
                        $memberImageRecord = $memberImageResult['file_name'];
                        unset($memberImageResult['success']);
                        $thumbnailResult =  $dt_ci_file_upload->ThumbnailUploadFile($memberImageResult, FLAT_MEMBER_IMAGE_PATH, THUMBNAIL_FLAT_MEMBER_IMAGE_PATH);
                    }
                }

                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_show_all_member' => 1
                ));
                $ownershipFlatMemberUpdateArray = array();
                $ownershipFlatMembersData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'type' => $ownershipFlatMemberData['type'],
                    'type_id' => $ownershipFlatMemberData['type_id'],
                    'flat_id' => $ownershipFlatMemberData['flat_id'],
                    'mobile_no' => $mobileNo,
                    'member_id_not' => $editMemberId,
                    // 'is_multiple' => 1,
                ));

                if (!empty($ownershipFlatMembersData)) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => "Members Mobiles Numbers Can't Be Same",
                        'data' => null
                    ), 404);
                }

                // member-Data 
                $filterMemberIdArr = array_filter($filterMobileNoArray, function($value, $key) {
                    return !empty($value);
                }, ARRAY_FILTER_USE_BOTH);

                $memberDetailsData = array();
                if($filterMemberIdArr) {
                    $memberDetailsData = array_reduce($this->ownershipFlatModel->getMemberData(array(
                        'phone' => $filterMemberIdArr,
                        'is_multiple' => 1
                    )), function($carry, $item) {
                        $carry[$item['member_id']] = $item;
                        return $carry;
                    }, []);
                }

                if(!empty($memberId)){
                    $memberSlug = $memberDetailsData[$memberId]['member_slug'];
                } else {
                    $memberSlug = random_string();
                }

                $memberInsertArray = array(
                    'name' => $name,
                    'email_id' => $email,
                    'member_slug' => $memberSlug,
                    // 'mobile_no' => $mobileNo,
                    'gender' => $gender,
                    // 'relation' => $relation,
                    'birth_date' => DMYToYMD($birthDate),
                    'blood_group' => $bloodGroup,
                );
                if ($isEdit == 1) {
                    $memberInsertArray['member_id'] = $memberId;
                } else {
                    $memberInsertArray['member_id'] = '';
                }
                if (isset($memberImageRecord)) {
                    if ($isEdit == 1) {
                        $memberImageData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array('member_id' => $editMemberId, 'is_show_all_member' => 1));
                        $ownershipFlatMemberUpdateArray = $memberImageData;
                        if ($memberImageData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image'])) {
                            unlink(FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image']);
                        }
                        if ($memberImageData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image'])) {
                            unlink(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image']);
                        }
                    }
                    $memberInsertArray['member_image'] = $memberImageRecord;
                }

                $extraData = array();
                $extraObj['api_user_id'] = $userSocietyId;
                $extraObj['society_id'] = $societyId;
                $extraData['is_api_data'] = $extraObj;
                $memberData = $this->commonWebserviceModel->insertUpdateRecord($memberInsertArray, 'member_id', MASTER_DB.'.tbl_member', 1, '', array(), $extraData, array());
                $lastMemberId = $memberData['lastInsertedId'];

                $ownershipFlatMemberArray = array(
                    'type' => $ownershipFlatMemberData['type'],
                    'type_id' => $ownershipFlatMemberData['type_id'],
                    'member_id' => $lastMemberId,
                    'member_slug' => $memberSlug,
                    'relation' => $relation,
                    'ownership_flat_id' => $ownershipFlatId,
                    'is_owner' => $isOwner,
                    'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                    'is_active' => 1,
                );

                $insertUpdateOwnershipFlatMemberDetailArr[$memberSlug] = array(
                    'member_slug' => $memberSlug,
                    'mobile_no' => $mobileNo,
                );

                if ($isEdit == 1) {
                    $ownershipFlatMemberArray['ownership_flat_member_id'] = $editMemberId;
                } else {
                    $ownershipFlatMemberArray['ownership_flat_member_id'] = '';
                }
                if (isset($memberImageRecord)) {
                    if ($isEdit == 1) {
                        $memberImageData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array('ownership_flat_member_id' => $ownershipFlatMemberId, 'is_show_all_member' => 1));
                        $ownershipFlatMemberUpdateArray = $memberImageData;
                        if ($memberImageData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image'])) {
                            unlink(FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image']);
                        }
                        if ($memberImageData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image'])) {
                            unlink(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image']);
                        }
                    }
                    $ownershipFlatMemberArray['member_image'] = $memberImageRecord;
                }
            // }

            // if ($isEdit == 1 || $isStatusChange == 1) {
                $ownershipFlatMemberUpdateArray = $this->ownershipFlatModel->getOwnershipFlatMemberData(array('ownership_flat_member_id' => $ownershipFlatMemberId, 'is_show_all_member' => 1,'is_active' => 1));
                $ownershipFlatMemberUpdateArray = compareArray($ownershipFlatMemberArray, $ownershipFlatMemberUpdateArray);
            // }

            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $ownershipFlatMemberData = $this->commonWebserviceModel->insertUpdateRecord($ownershipFlatMemberArray, 'ownership_flat_member_id', 'tbl_ownership_flat_member', 1, '', array(), $extraData, $ownershipFlatMemberUpdateArray);
            $lastOwnershipFlatMemberId = $ownershipFlatMemberData['lastInsertedId'];

            $groupData = $this->commonWebserviceModel->getGroupsData([
                'group_id' => $resourceTypeMemberData['group_id'],
                'society_id' => $societyId,
            ]);

            // get permisiion Array
            $groupId = $groupData['id'] ?? '';
            $permissions = $groupData['permissions'] ?? '';
            $permissionArray = unserialize($permissions);
            $permissionLabel = [];
            $controllers_methods = $this->dt_ci_acl->getPermissableMethods();
            
            foreach ($controllers_methods as $controller_name => $methods_arr) {
                foreach ($methods_arr as $method) {
                    $methodDisplay = is_array($method) ? reset($method) : $method;
                    $methodActual = is_array($method) ? key($method) : $method;
                    $inputName = "$controller_name|$methodActual";
                    $permissionLabel[] = "$inputName|dt|$controller_name|dt|$methodDisplay";
                }
            }

            $ownershipFlatMemberInsertData = $this->ownershipFlatModel->getOwnershipFlatMemberData([
                'ownership_flat_id' => $ownershipFlatId,
                'ownership_flat_member_id' => $lastOwnershipFlatMemberId,
                'type' => 'ownership_flat',
                'is_multiple' => 1,
                'society_id' => $societyId,
            ]);

            // printArray($ownershipFlatMemberInsertData);
            // printArray($insertUpdateOwnershipFlatMemberDetailArr,1);

            // adding mobile No's
            foreach ($ownershipFlatMemberInsertData as $key => $value) {
                $ownershipFlatMemberInsertData[$key]['mobile_no'] = $insertUpdateOwnershipFlatMemberDetailArr[$value['member_slug']]['mobile_no'];
            }

            $oldMemberArr = array();
            foreach ($oldOwnershipFlatMemberData as $oKey => $oldMember) {
                $oldmemberComboKey = $oldMember['society_id'].'|'.$oldMember['ownership_flat_member_id'];
                $oldMemberArr[$oldmemberComboKey] = $oldMember;
            }

            $tblUsrInsertArr = [];
            $tblUsrUpdateArr = [];
            $tblUsrSocietyInsertArr = [];
            $tblUsrSocietyUpadteArr = [];
            $tblUsrGroupArr = [];
            $tblUsrPermissionArr = [];
            $deleteUserArr = [];
            $deleteMemberIdArr = [];
            $deleteUserIdArr = [];
            $deleteUserSocietyIdArr = [];

            $existsUserDataArr = array();
            $existsUserMobileNoWiseArr = array();
            if(!empty($existsUserData)){
                foreach($existsUserData as $existsUser) {
                    $comboKey = $existsUser['society_id']."|".$existsUser['resource_type_id']."|".$existsUser['type_id'];
                    $existsUserDataArr[$comboKey] = $existsUser;
                    $existsUserMobileNoWiseArr[$existsUser['phone']][] = $existsUser;
                }
            }

            $existsUserMemberDataArr = array();
            if(!empty($existsUserMemberData)){
                foreach($existsUserMemberData as $existsUserMember){
                    $comboKey=$existsUserMember['society_id']."|".$existsUserMember['resource_type_id']."|".$existsUserMember['type_id'];
                    $existsUserMemberDataArr[$comboKey] = $existsUserMember;
                }
            }

            foreach($ownershipFlatMemberInsertData as $newMember){
                $newMemberComboKey = $newMember['society_id']."|".$newMember['resource_type_id']."|".$newMember['member_id'];
                $newComboKey = $newMember['society_id']."|".$newMember['ownership_flat_member_id'];

                if(empty($existsUserData)){
                    // New User
                    $password = PASSWORD;
                    $slug = random_string();
                    $slugSociety = random_string();
                    if(!empty($newMember['mobile_no'])){
                        $tblUsrInsertArr[] = [
                            'username' => $newMember['email_id'],
                            'email' => $newMember['email_id'],
                            'first_name' => $newMember['name'],
                            // 'phone' => $newMember['mobile_no'],
                            'user_type_id' => $newMember['member_id'],
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'password' => $this->ionAuthModel->hashPassword($password),
                            'active' => 1,
                            'slug' => $slug,
                        ];
                
                        $tblUsrGroupArr[] = [
                            'id' => '',
                            'group_id' => $groupId,
                            'slug' => $slug,
                            'society_slug' => $slugSociety,
                        ];
                
                        $tblUsrSocietyInsertArr[] = [
                            'user_society_id' => '',
                            'society_id' => $societyId,
                            'phone' => $newMember['mobile_no'],
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'type_id' => $newMember['member_id'],
                            'slug' => $slug,
                            'is_active' => 1,
                            'society_slug' => $slugSociety,
                        ];

                        foreach ($permissionLabel as $labelData) {
                            list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                            if (in_array($permissionValue, $permissionArray)) {
                                $tblUsrPermissionArr[] = [
                                    'controller_name' => $controller,
                                    'permission_name' => $permissionValue,
                                    'permission_label' => $label,
                                    'group_id' => $resourceTypeMemberData['group_id'],
                                    'slug' => $slug,
                                    'society_slug' => $slugSociety,
                                    'created_at' => date('Y-m-d H:i:s'),
                                    'created_by' => $userSocietyId,
                                    'updated_at' => date('Y-m-d H:i:s'),
                                    'updated_by' => $userSocietyId,
                                ];
                            }
                        }
                    }
                }
                else {
                    // phone no update
                    if(isset($existsUserDataArr[$newMemberComboKey])){
                        $memberUserSocietyId = $existsUserDataArr[$newMemberComboKey]['user_society_id'];
                        $userSocietyMemberId = $existsUserDataArr[$newMemberComboKey]['type_id'];
                        if($newMember['mobile_no'] != $existsUserDataArr[$newMemberComboKey]['phone']){
                            if(empty($newMember['mobile_no'])){
                                $deleteUserSocietyIdArr[] = $userSocietyMemberId;
                            } else {
                                $tblUsrSocietyUpadteArr[] = array(
                                    'user_society_id' => $memberUserSocietyId,
                                    'phone' => $newMember['mobile_no'],
                                );
                            }
                        }
                        continue;
                    }

                    // member id changed
                    if(isset($oldMemberArr[$newComboKey])){
                        $oldMemberId = $oldMemberArr[$newComboKey]['member_id'];
                        $newMemberId = $newMember['member_id'];
                        // $oldMemberComboKey = $oldMemberArr[$newComboKey]['society_id'].'|'.$oldMemberArr[$newComboKey]['resource_type_id'].'|'.$oldMemberArr[$newComboKey]['member_id'];
                        // $oldUserSocietyId = $existsUserDataArr[$oldMemberComboKey]['user_society_id'];
                        if($oldMemberId != $newMemberId){
                            $deleteUserSocietyIdArr[] = $oldMemberId;
                        }
                    }

                    if(isset($existsUserMobileNoWiseArr[$newMember['mobile_no']])){
                        // new entry if not in user society
                        if(!isset($existsUserMemberDataArr[$newMemberComboKey])) {
                            $password = PASSWORD;
                            $slugSociety = random_string();
                            // $slug = $existsUserMemberDataArr[$newMemberComboKey]['slug'];
                            $slug = $existsUserMobileNoWiseArr[$newMember['mobile_no']][0]['slug'];
                            $tblUsrGroupArr[] = [
                                'id' => '',
                                'group_id' => $groupId,
                                'slug' => $slug,
                                'society_slug' => $slugSociety
                            ];
                    
                            $tblUsrSocietyInsertArr[] = [
                                'user_society_id' => '',
                                'society_id' => $societyId,
                                'phone' => $newMember['mobile_no'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $newMember['member_id'],
                                'slug' => $slug,
                                'is_active' => 1,
                                'society_slug' => $slugSociety,
                            ];
                    
                            foreach ($permissionLabel as $labelData) {
                                list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                                if (in_array($permissionValue, $permissionArray)) {
                                    $tblUsrPermissionArr[] = [
                                        'controller_name' => $controller,
                                        'permission_name' => $permissionValue,
                                        'permission_label' => $label,
                                        'group_id' => $resourceTypeMemberData['group_id'],
                                        'slug' => $slug,
                                        'society_slug' => $slugSociety,
                                        'created_at' => date('Y-m-d H:i:s'),
                                        'created_by' => $userSocietyId,
                                        'updated_at' => date('Y-m-d H:i:s'),
                                        'updated_by' => $userSocietyId,
                                    ];
                                }
                            }
                        }
                    } else {
                        // New User
                        $password = PASSWORD;
                        $slug = random_string();
                        $slugSociety = random_string();
                        if(!empty($newMember['mobile_no'])){
                            $tblUsrInsertArr[] = [
                                'username' => $newMember['email_id'],
                                'email' => $newMember['email_id'],
                                'first_name' => $newMember['name'],
                                // 'phone' => $newMember['mobile_no'],
                                'user_type_id' => $newMember['member_id'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'password' => $this->ionAuthModel->hashPassword($password),
                                'active' => 1,
                                'slug' => $slug,
                            ];
                    
                            $tblUsrGroupArr[] = [
                                'id' => '',
                                'group_id' => $groupId,
                                'slug' => $slug,
                                'society_slug' => $slugSociety
                            ];
                    
                            $tblUsrSocietyInsertArr[] = [
                                'user_society_id' => '',
                                'society_id' => $societyId,
                                'phone' => $newMember['mobile_no'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $newMember['member_id'],
                                'slug' => $slug,
                                'society_slug' => $slugSociety,
                            ];
                    
                            foreach ($permissionLabel as $labelData) {
                                list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                                if (in_array($permissionValue, $permissionArray)) {
                                    $tblUsrPermissionArr[] = [
                                        'controller_name' => $controller,
                                        'permission_name' => $permissionValue,
                                        'permission_label' => $label,
                                        'group_id' => $resourceTypeMemberData['group_id'],
                                        'slug' => $slug,
                                        'society_slug' => $slugSociety,
                                        'created_at' => date('Y-m-d H:i:s'),
                                        'created_by' => $userSocietyId,
                                        'updated_at' => date('Y-m-d H:i:s'),
                                        'updated_by' => $userSocietyId,
                                    ];
                                }
                            }
                        }
                    }
                }
            }

            // printArray($tblUsrUpdateArr);
            // printArray($tblUsrInsertArr);
            // printArray($tblUsrGroupArr);
            // printArray($tblUsrSocietyInsertArr);
            // printArray($tblUsrSocietyUpadteArr);
            // printArray($tblUsrPermissionArr,1);

            // Execute all batch operations
            if (!empty($tblUsrUpdateArr)) {
                $this->ownershipFlatModel->batchUpdate($tblUsrUpdateArr, 'id', MASTER_DB.'.tbl_users');
            }
            if (!empty($tblUsrInsertArr)) {
                $this->ownershipFlatModel->batchInsert($tblUsrInsertArr, MASTER_DB.'.tbl_users');
            }
            if (!empty($tblUsrGroupArr)) {
                $this->ownershipFlatModel->batchInsert($tblUsrGroupArr, MASTER_DB.'.tbl_users_groups');
            }
            if (!empty($tblUsrSocietyInsertArr)) {
                $this->ownershipFlatModel->batchInsert($tblUsrSocietyInsertArr, MASTER_DB.'.tbl_user_society');
            }
            if (!empty($tblUsrSocietyUpadteArr)) {
                $this->ownershipFlatModel->batchUpdate($tblUsrSocietyUpadteArr,'user_society_id', MASTER_DB.'.tbl_user_society');
            }
            if (!empty($tblUsrPermissionArr)) {
                $this->ownershipFlatModel->batchInsert($tblUsrPermissionArr, MASTER_DB.'.tbl_user_permission');
            }
            if (!empty($deleteUserSocietyIdArr)) {
                $this->ownershipFlatModel->deleteUserIdRecords(array(
                    'member_id' => $deleteUserSocietyIdArr,
                    'society_id' => $societyId,
                ));
            }
            
            // Refresh mapping IDs
            $this->resourceTypeModel->updateUserGroupId();
            $this->resourceTypeModel->updateUserSocietyId();
            $this->resourceTypeModel->updateUserPermissionId();
            $this->resourceTypeModel->updateUserPermissionSocietyId();

            $ownershipFlatMemberFilterArray = array(
                'ownership_flat_member_id' => $lastOwnershipFlatMemberId,
                'is_show_all_member' => 1,
            );
            $memberInsertData = array();
            $ownershipFlatMemberInsertData = $this->ownershipFlatModel->getOwnershipFlatMemberData($ownershipFlatMemberFilterArray);
            if (!empty($ownershipFlatMemberInsertData)) {
                $memberInsertData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'type' => $ownershipFlatMemberInsertData['type'],
                    'type_id' => $ownershipFlatMemberInsertData['type_id'],
                    'is_show_all_member' => 1,
                    'is_active' => 1,
                    'is_multiple' => 1
                ));
            }
            if (!empty($memberInsertData)) {
                foreach ($memberInsertData as $vKey => $member) {
                    $formattedRelation = getFunctionKeyValue($member['relation'], relation());
                    // $formattedFoodLike = getFunctionKeyValue($member['food_like'], foodLike());
                    $formattedBloodGroup = getFunctionKeyValue($member['blood_group'], bloodGroupType());
                    $memberPath = site_url('uploads/no_image.png');
                    $memberThumbnailPath = site_url('uploads/no_image.png');
                    if ($member['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $memberPath = site_url() . FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    if ($member['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $memberThumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    $memberInsertData[$vKey]['member_image'] = $memberPath;
                    $memberInsertData[$vKey]['thumbnail_member_image'] = $memberThumbnailPath;
                    $memberInsertData[$vKey]['gender_display'] = underscoreToUcWord($member["gender"]);
                    $memberInsertData[$vKey]['relation'] = $formattedRelation;
                    // $memberInsertData[$vKey]['food_like'] = $formattedFoodLike;
                    $memberInsertData[$vKey]['blood_group'] = $formattedBloodGroup;
                    $memberInsertData[$vKey]['relation_display'] = underscoreToUcWord($member["relation"]);
                    $memberInsertData[$vKey]['food_like_display'] = underscoreToUcWord($member["food_like"]);
                    $memberInsertData[$vKey]['birth_date_display'] = isValidDate($member['birth_date']) ? YMDToDMY($member["birth_date"]) : "";
                }
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($isEdit) && !empty($isEdit)) {
                if ((isset($memberData['success']) && $memberData['success']) && ($transactionStatus == 1)) {
                    // $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.member')),
                        'data' => $memberInsertData
                    ), 200);
                } else {
                    // $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.member')),
                        'data' => null
                    ), 404);
                }
            } else {
                if ((isset($memberData['success']) && $memberData['success']) && ($transactionStatus == 1)) {
                    // $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.member')),
                        'data' => $memberInsertData
                    ), 200);
                } else {
                    // $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.member')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function checkAlreadyExistsNumber(){
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $mobileNo = $this->request->getVar('mobile_no');
        $memberId = $this->request->getVar('member_id');
    
        if(!empty($mobileNo)){

            // get resource data
            $existsResourceData = $this->resourceModel->getResourceData(array(
                "resource_mobile_no" => $mobileNo,
                "society_id" => $societyId,
            ));
            
            if(!empty($existsResourceData)) {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'is_member' => 0,
                    'message' => lang('OwnershipFlat.mobile_no_already_used_resource'),
                    'data' => null
                ), 404);
            }
    
            // Get manager Data
            $resourceTypeManagerId = getResourceTypeId(RESOURCE_TYPE_MANAGER);
            $resourceTypeMemberId = getResourceTypeId(RESOURCE_TYPE_MEMBER);

            if(!empty($resourceTypeManagerData)){
                $userManagerDataArray = $this->commonWebserviceModel->getUserSocietyData(array(
                    'phone' => $mobileNo,
                    'resource_type_id' => $resourceTypeManagerId,
                    'is_multiple' => 1 
                ));
            }
    
            if(!empty($userManagerDataArray)){
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'is_member' => 0,
                    'message' => lang('OwnershipFlat.mobile_no_already_used_manager'),
                    'data' => null
                ), 404);
            }
    
            // get member data
            $userMemberDataArray = $this->commonWebserviceModel->getUserSocietyData(array(
                'phone' => $mobileNo,
                'is_member' => 1,
            ));
        }

        if (isset($userMemberDataArray) && !empty($userMemberDataArray)) {
            return $this->response(array(
                'status' => true,
                'response_code' => 200,
                'is_member' => 1,
                'message' => lang('OwnershipFlat.mobile_no_already_used_member'),
                'data' => $userMemberDataArray
            ), 200);
        } else {
            return $this->response(array(
                'status' => false,
                'response_code' => 404,
                'is_member' => 0,
                'message' => "No Data Found",
                'data' => null
            ), 400);
        }
    }

    public function addEditSosEmergency() // not
    {
        $this->db->transStart();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $sosEmergencyId = $this->request->getVar('sos_emergency_id');
        $categoryId = $this->request->getVar('category_id');
        $description = $this->request->getVar('description');
        $societyId = $this->request->getVar('society_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $appType = $this->request->getVar('app_type');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $sosRecord = $this->request->getVar('sos_record[]');
        $sosNotification = $this->request->getVar('sos_notification[]');
        $this->validation->setRule('description', lang('CommonWebService.common_description'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('category_id', lang('CommonWebService.category_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if ($appType == MEMBER_APP) {
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $statusId = 0;
            $statusData = $this->statusModel->getStatusData(array(
                'is_default' => 1,
                'status_for' => 'sos_emergency',
                'is_active' => 1,
            ));
            if (empty($statusData)) {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => 'Status Master Sos Emergency Is Default Status Not Defined',
                    'data' => null
                ), 404);
            }
            if (!empty($statusData)) {
                $statusId = isset($statusData['status_id']) ? $statusData['status_id'] : 0;
            }
            $sosRecordDocument = array();
            if (isset($_FILES["sos_record"])) {
                $sosRecordPath = CATEGORY_IMAGE_PATH;
                $sosRecordDocument = $dt_ci_file_upload->UploadMultipleFile('sos_record', MAX_IMAGE_SIZE_LIMIT, $sosRecordPath, true, true, array('mp3', 'mp4'));
                if ($sosRecordDocument['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($sosRecordDocument['message']),
                        'data' => null
                    ), 404);
                }
            }
            $sosEmergecyUpdateArray = array();
            $sosEmergencyArray = array(
                'sos_emergency_id' => $sosEmergencyId,
                'category_id' => $categoryId,
                'description' => $description,
                'society_id' => $societyId,
                'status_id' => $statusId,
                'is_active' => 1,
            );
            if (empty($sosEmergencyId)) {
                $sosEmergencyArray['status'] = 'awaiting_response';
            }
            if (!empty($sosEmergencyId)) {
                $sosEmergecyUpdateArray = $this->sosModel->getSosEmergencyData(array(
                    'sos_emergency_id' => $sosEmergencyId,
                ));
                $sosEmergecyUpdateArray = compareArray($sosEmergencyArray, $sosEmergecyUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $sosEmergencyData = $this->commonWebserviceModel->insertUpdateRecord($sosEmergencyArray, 'sos_emergency_id', 'tbl_sos_emergency', 1, '', array(), $extraData, $sosEmergecyUpdateArray);
            $lastSosEmergencyId = $sosEmergencyData['lastInsertedId'];
            if (!empty($sosNotification)) {
                if (!empty($sosEmergencyId)) {
                    $this->sosModel->deleteSosEmergencyNotificationType($sosEmergencyId);
                }
                $sosNotificationTypeArray = array();
                foreach ($sosNotification as $sosNotificationElement) {
                    $sosNotificationTypeArray[] = array(
                        'sos_emergency_notification_id' => '',
                        'sos_emergency_id' => $lastSosEmergencyId,
                        'sos_emergency_type' => $sosNotificationElement,
                        'created_by' => $userSocietyId,
                        'updated_by' => $userSocietyId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                }
                if (!empty($sosNotificationTypeArray)) {
                    $this->sosModel->batchInsert($sosNotificationTypeArray, 'tbl_sos_emergency_notification');
                }
            }
            $notificationDataArray = array();
            $memberIdArray = array();
            $ownershipFlatIdArray = array();
            $sosEmergecyInsertData = $this->sosModel->getSosEmergencyData(array(
                'sos_emergency_id' => $lastSosEmergencyId,
            ));
            if (!empty($sosNotification)) {
                $sosNotificationTypeArray = array();
                $userMergeArray = array();
                $resourceTypeMemberData = $this->resourceTypeModel->getResourceTypeData(array(
                    'resource_type_name' => RESOURCE_TYPE_MEMBER,
                    'society_id' => $societyId,
                ));
                $resourceTypeManagerData = $this->resourceTypeModel->getResourceTypeData(array(
                    'resource_type_name' => RESOURCE_TYPE_MANAGER,
                    'society_id' => $societyId,
                ));
                $resourceTypeGuardData = $this->resourceTypeModel->getResourceTypeData(array(
                    'is_guard' => 1,
                    'is_multiple' => 1,
                    'is_login' => 1,
                    'is_active' => 1,
                    'society_id' => $societyId,
                ));
                $resourceTypeIdArray = [];
                if (!empty($resourceTypeGuardData)) {
                    foreach ($resourceTypeGuardData as $resourceTypeElement) {
                        $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                    }
                }
                $userData = $this->commonWebserviceModel->getUserSocietyData(array(
                    'user_society_id' => $userSocietyId,
                ));
                $resourceTypeIdNot = $userData['resource_type_id'];
                foreach ($sosNotification as $sosNotificationElement) {
                    
                    if ($sosNotificationElement == 'family') {
                        $ownershipFlatMemberIdArray = array();
                        $memberIdArray = array();
                        $userDeviceUserSocietyIdArray = array();
                        $userDeviceUserTypeIdArray = array();
                        $userDeviceUserTypeArray = array();
                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'is_active' => 1,
                            'is_show_all_member' => 1
                        ));

                        if (!empty($ownershipFlatMemberData)) {
                            $type = isset($ownershipFlatMemberData['type']) ? $ownershipFlatMemberData['type'] : '';
                            if ($type == 'ownership_flat') {
                                $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                    'ownership_flat_id' => $ownershipFlatMemberData['ownership_flat_id'],
                                    'ownership_flat_member_id_not' => $ownershipFlatMemberId,
                                    'type' => $type,
                                    'is_show_all_member' => 1,
                                    'is_active' => 1,
                                    'is_multiple' => 1,
                                ));
                            } else if ($type == 'rentals') {
                                $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                    'ownership_flat_id' => $ownershipFlatMemberData['ownership_flat_id'],
                                    'ownership_flat_member_id_not' => $ownershipFlatMemberId,
                                    'is_show_all_member' => 1,
                                    'is_multiple' => 1,
                                    'is_active' => 1,
                                ));
                            }
                        }
                        if (!empty($ownershipFlatData)) {
                            foreach ($ownershipFlatData as $ownershipFlat) {
                                $ownershipFlatMemberIdArray[] = $ownershipFlat['ownership_flat_member_id'];
                                $memberIdArray[] = $ownershipFlat['member_id'];
                            }
                        }
                        if (!empty($ownershipFlatMemberIdArray)) {

                            $userSocietyFamilyData = $this->commonWebserviceModel->getUserSocietyData(array(
                                'society_id' => $societyId,
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $memberIdArray,
                                'is_multiple' => 1
                            ));
                            if (!empty($userSocietyFamilyData)) {
                                foreach ($userSocietyFamilyData as $userSocietyFamilyElement) {
                                    $userDeviceUserSocietyIdArray[] = isset($userSocietyFamilyElement['user_society_id']) ? $userSocietyFamilyElement['user_society_id'] : 0;
                                    $userDeviceUserTypeIdArray = $ownershipFlatMemberIdArray;
                                    $userDeviceUserTypeArray[] = $resourceTypeMemberData['resource_type_id'];
                                }
                                
                                $userDevice = $this->commonWebserviceModel->deviceData(array(
                                    "user_society_id" => $userDeviceUserSocietyIdArray,
                                    "user_type" => MEMBER_APP,
                                    // "resource_type_id" => $userDeviceUserTypeArray,
                                    "is_latest" => 1,
                                    "is_multiple" => 1
                                ));

                                // printArray($userDevice,1);
                                if (!empty($userDevice)) {
                                    foreach ($userDevice as $userDeviceElement) {
                                        if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
                                            $notificationArray = array(
                                                'ownership_flat_id' => 0,
                                                'ownership_flat_member_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                // 'user_type_name' => isset($userDeviceElement['user_type_name']) ? $userDeviceElement['user_type_name'] : '',
                                                'type' => 'sos_emergency',
                                                'status' => 'sos_emergency',
                                                'type_id' => $lastSosEmergencyId,
                                                'society_id' => $societyId,
                                                'flat_id' => 0,
                                                'staff_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'management_committee_id' => 0,
                                                //'user_id' => isset($staff['user_id']) ? $staff['user_id'] : 0,
                                                'user_society_id' => $userSocietyId,
                                                'category_name' => $sosEmergecyInsertData['category_name'],
                                                'notification_title' => $sosEmergecyInsertData['category_name'] . ' Alert: SOS Triggered',
                                                'description' => 'An SOS alert has been triggered with the following message: ' . $sosEmergecyInsertData['category_name'] . ': ' . $sosEmergecyInsertData['description'],
                                                'module' => 'sos_emergency',
                                                'action_type' => 'sent',
                                                'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
                                                'app_type' => $appType,
                                                // 'display_status' => underscoreToUcWord('sos_emergency'),
                                            );

                                            if ($appType == GATE_KEEPER) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                $notificationArray['receive_for_notification'] = $userDeviceElement['user_type'];
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            if ($appType == MANAGER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            if ($appType == MEMBER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                                $notificationArray['receive_for_notification'] = $userDeviceElement['user_type'];
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }
                                            $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                            array_push($notificationDataArray, $notificationArray);
                                        }
                                    }
                                }

                                // if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                                //     sendNotificationSosGateKeeperAndroid($notificationDataArray,$lastSosEmergencyId);
                                // }
                            }
                        }
                    }
                    else if ($sosNotificationElement == 'residents') {
                        $ownershipFlatMemberIdArray = array();
                        $memberIdArray = array();
                        $userDeviceUserSocietyIdArray = array();
                        $userDeviceUserTypeIdArray = array();
                        $userDeviceUserTypeArray = array();
                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'society_id' => $societyId,
                            'is_latest' => 1,
                            'is_show_all_member' => 1,
                            'is_multiple' => 1,
                            'is_active' => 1
                        ));
                        if (!empty($ownershipFlatMemberData)) {
                            foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                $ownershipFlatMemberIdArray[] = $ownershipFlatMember['ownership_flat_member_id'];
                                $memberIdArray[] = $ownershipFlatMember['member_id'];
                            }
                        }

                        if (!empty($ownershipFlatMemberIdArray)) {
                            $userSocietyFamilyData = $this->commonWebserviceModel->getUserSocietyData(array(
                                'society_id' => $societyId,
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'user_society_id_not' => $userSocietyId,
                                'type_id' => $memberIdArray,
                                'is_multiple' => 1
                            ));
                            if (!empty($userSocietyFamilyData)) {
                                foreach ($userSocietyFamilyData as $userSocietyFamilyElement) {
                                    $userDeviceUserSocietyIdArray[] = isset($userSocietyFamilyElement['user_society_id']) ? $userSocietyFamilyElement['user_society_id'] : 0;
                                    $userDeviceUserTypeIdArray[] = $ownershipFlatMemberIdArray;
                                    $userDeviceUserTypeArray[] = $resourceTypeMemberData['resource_type_id'];
                                }

                                $userDevice = $this->commonWebserviceModel->deviceData(array(
                                    "user_society_id" => $userDeviceUserSocietyIdArray,
                                    "user_type" => MEMBER_APP,
                                    // "resource_type_id" => $userDeviceUserTypeArray,
                                    "is_latest" => 1,
                                    "is_multiple" => 1
                                ));

                                // printArray($userDevice,1);


                                if (!empty($userDevice)) {
                                    foreach ($userDevice as $userDeviceElement) {
                                        if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
                                            $notificationArray = array(
                                                'ownership_flat_id' => 0,
                                                'ownership_flat_member_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'type' => 'sos_emergency',
                                                'status' => 'sos_emergency',
                                                'type_id' => $lastSosEmergencyId,
                                                'society_id' => $societyId,
                                                'flat_id' => 0,
                                                'staff_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'management_committee_id' => 0,
                                                //'user_id' => isset($staff['user_id']) ? $staff['user_id'] : 0,
                                                'user_society_id' => $userSocietyId,
                                                'category_name' => $sosEmergecyInsertData['category_name'],
                                                'notification_title' => $sosEmergecyInsertData['category_name'] . ' Alert: SOS Triggered',
                                                'description' => 'An SOS alert has been triggered with the following message: ' . $sosEmergecyInsertData['category_name'] . ': ' . $sosEmergecyInsertData['description'],
                                                'module' => 'sos_emergency',
                                                'action_type' => 'sent',
                                                'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
                                                'app_type' => $appType,
                                                // 'user_type_name' => isset($userDeviceElement['user_type_name']) ? $userDeviceElement['user_type_name'] : '',
                                                // 'display_status' => underscoreToUcWord('sos_emergency'),
                                            );
                                            if ($appType == GATE_KEEPER) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                $notificationArray['receive_for_notification'] = $userDeviceElement['user_type'];
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }
                                            if ($appType == MANAGER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            if ($appType == MEMBER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                                $notificationArray['receive_for_notification'] = $userDeviceElement['user_type'];
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }
                                            $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                            array_push($notificationDataArray, $notificationArray);
                                        }
                                    }
                                }
                            }
                        }

                        // if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                        //     sendNotificationSosGateKeeperAndroid($notificationDataArray,$lastSosEmergencyId);
                        // }
                    }
                    else if ($sosNotificationElement == 'committee') {
                        $userDeviceUserSocietyIdArray = array();
                        $userDeviceUserTypeIdArray = array();
                        $userDeviceUserTypeArray = array();
                        $userManagerDevice = array();
                        $memberIdArray = array();
                        $ownershipFlatMemberIdArray = array();
                        $userDeviceManagerIdArray = array();
                        $userDeviceManagerTypeIdArray = array();
                        $userDeviceManagerTypeArray = array();
                        $managementCommitteeData = $this->managementCommitteeModel->getManagementCommitteeData(array(
                            'society_id' => $societyId,
                            'is_api' => 1,
                            'is_active' => 1,
                            'is_multiple' => 1
                        ));

                        if (!empty($managementCommitteeData)) {
                            foreach ($managementCommitteeData as $managementCommitteeElement) {
                                $memberIdArray[] = $managementCommitteeElement['user_member_id'];
                                $ownershipFlatMemberIdArray[] = $managementCommitteeElement['ownership_flat_member_id'];
                            }
                        }

                        if(!empty($memberIdArray)){
                            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                                'is_show_all_member' => 1,
                                'is_multiple' => 1,
                                'is_active' => 1
                            ));
                            if(!empty($ownershipFlatMemberData)){
                                foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                    $memberIdArray[] = $ownershipFlatMember['member_id'];
                                }
                            }
                            if(!empty($ownershipFlatMemberData)){
                                $userSocietyCommitteeData = $this->commonWebserviceModel->getUserSocietyData(array(
                                    "type_id" => $memberIdArray,
                                    "resource_type_id" => $resourceTypeMemberData['resource_type_id'],
                                    'user_society_id_not' => $userSocietyId,
                                    'society_id' => $societyId,
                                    'is_multiple' => 1 
                                ));

                                if (!empty($userSocietyCommitteeData)) {
                                    foreach ($userSocietyCommitteeData as $userSocietyCommitteeElement) {
                                        $userDeviceUserSocietyIdArray[] = isset($userSocietyCommitteeElement['user_society_id']) ? $userSocietyCommitteeElement['user_society_id'] : 0;
                                        
                                    }


                                    $userMemberDevice = $this->commonWebserviceModel->deviceData(array(
                                        "user_society_id" => $userDeviceUserSocietyIdArray,
                                        "user_type" => MEMBER_APP,
                                        // "resource_type_id" => $userDeviceUserTypeArray,
                                        "is_latest" => 1,
                                        "is_multiple" => 1
                                    ));

                                    $userManagerData = $this->commonWebserviceModel->getUserSocietyData(array(
                                        'society_id' => $societyId,
                                        'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
                                        'user_society_id_not' => $userSocietyId,
                                        'is_active' => 1,
                                        'is_multiple' => 1
                                    ));

                                    if (!empty($userManagerData)) {
                                        foreach ($userManagerData as $userManagerCommittee) {
                                            $userDeviceManagerIdArray[] = isset($userManagerCommittee['user_society_id']) ? $userManagerCommittee['user_society_id'] : 0;
                                        }

                                        $userManagerDevice = $this->commonWebserviceModel->deviceData(array(
                                            "user_society_id" => $userDeviceManagerIdArray,
                                            "user_type" => MANAGER_APP,
                                            // "resource_type_id" => $userDeviceManagerTypeArray,
                                            "is_latest" => 1,
                                            "is_multiple" => 1
                                        ));
                                    }

                                    $userMergeArray = array_merge($userMemberDevice,$userManagerDevice);
                                    if (!empty($userMergeArray)) {
                                        foreach ($userMergeArray as $userDeviceElement) {
                                            if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
                                                $notificationArray = array(
                                                    'ownership_flat_id' => 0,
                                                    'ownership_flat_member_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                    'type' => 'sos_emergency',
                                                    'status' => 'sos_emergency',
                                                    'type_id' => $lastSosEmergencyId,
                                                    'society_id' => $societyId,
                                                    'flat_id' => 0,
                                                    'staff_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                    //'management_committee_id' => isset($staff['management_committee_id']) ? $staff['management_committee_id'] : 0,
                                                    'management_committee_id' => 0,
                                                    //'user_id' => isset($staff['user_id']) ? $staff['user_id'] : 0,
                                                    'user_society_id' => $userSocietyId,
                                                    'category_name' => $sosEmergecyInsertData['category_name'],
                                                    'notification_title' => $sosEmergecyInsertData['category_name'] . ' Alert: SOS Triggered',
                                                    'description' => 'An SOS alert has been triggered with the following message: ' . $sosEmergecyInsertData['category_name'] . ': ' . $sosEmergecyInsertData['description'],
                                                    'module' => 'sos_emergency',
                                                    'action_type' => 'sent',
                                                    'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                    'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                    'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                    'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
                                                    'app_type' => $appType,
                                                    // 'user_type_name' => isset($userDeviceElement['user_type_name']) ? $userDeviceElement['user_type_name'] : '',
                                                    // 'display_status' => underscoreToUcWord('sos_emergency'),
                                                );

                                                if ($appType == GATE_KEEPER) {
                                                    $notificationArray['send_for_notification'] = $appType;
                                                    $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                    $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                                    $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                                }

                                                if ($appType == MANAGER_APP) {
                                                    $notificationArray['send_for_notification'] = $appType;
                                                    $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                    $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                                    $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                                }

                                                if ($appType == MEMBER_APP) {
                                                    $notificationArray['send_for_notification'] = $appType;
                                                    $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                                    $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                                    $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                                }
                                                $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                                array_push($notificationDataArray, $notificationArray);
                                            }
                                        }
                                    }
                                }
                            }

                            // if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                            //     sendNotificationSosGateKeeperAndroid($notificationDataArray,$lastSosEmergencyId);
                            // }
                        }
                    }
                    else if ($sosNotificationElement == 'gatekeeper') {
                       
                        $userSocietyStaffData = $this->commonWebserviceModel->getUserSocietyData(array(
                            'society_id' => $societyId,
                            'resource_type_id' => $resourceTypeIdArray,
                            'user_society_id_not' => $userSocietyId,
                            'is_active' => 1,
                            'is_multiple' => 1
                        ));
                        // printArray($userSocietyStaffData,1);
                        $userDeviceUserSocietyIdArray = [];
                        $userDeviceUserTypeIdArray = [];
                        $userDeviceUserTypeArray = [];
                          if (!empty($userSocietyStaffData)) {
                              foreach ($userSocietyStaffData as $userSocietyStaffElement) {
                                  $userDeviceUserSocietyIdArray[] = isset($userSocietyStaffElement['user_society_id']) ? $userSocietyStaffElement['user_society_id'] : 0;
                                  // $userDeviceUserTypeIdArray[] = isset($userSocietyStaffElement['type_id']) ? $userSocietyStaffElement['type_id'] : 0;
                                  // $userDeviceUserTypeArray[] = isset($userSocietyStaffElement['resource_type_id']) ? $userSocietyStaffElement['resource_type_id'] : 0;
                              }

                              $userDevice = $this->commonWebserviceModel->deviceData(array(
                                  "user_society_id" => $userDeviceUserSocietyIdArray,
                                  "user_type" => GATE_KEEPER,
                                  // "resource_type_id" => $userDeviceUserTypeArray,
                                  "is_latest" => 1,
                                  "is_multiple" => 1
                              ));


                              if (!empty($userDevice)) {
                                  foreach ($userDevice as $userDeviceElement) {
                                      if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
                                          $notificationArray = array(
                                              'ownership_flat_id' => 0,
                                              'ownership_flat_member_id' => 0,
                                              'type' => 'sos_emergency',
                                              'status' => 'sos_emergency',
                                              'type_id' => $lastSosEmergencyId,
                                              'society_id' => $societyId,
                                              'flat_id' => 0,
                                              'staff_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                              'management_committee_id' => 0,
                                              //'user_id' => isset($staff['user_id']) ? $staff['user_id'] : 0,
                                              'user_society_id' => $userSocietyId,
                                              'category_name' => $sosEmergecyInsertData['category_name'],
                                              'notification_title' => $sosEmergecyInsertData['category_name'] . ' Alert: SOS Triggered',
                                              'description' => 'An SOS alert has been triggered with the following message: ' . $sosEmergecyInsertData['category_name'] . ': ' . $sosEmergecyInsertData['description'],
                                              'module' => 'sos_emergency',
                                              'action_type' => 'sent',
                                              'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                              'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                              'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                              'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
                                              'app_type' => $appType,
                                              // 'user_type_name' => isset($userDeviceElement['user_type_name']) ? $userDeviceElement['user_type_name'] : '',
                                              //  'display_status' => underscoreToUcWord('sos_emergency'),
                                          );

                                          if($appType == GATE_KEEPER){
                                              $notificationArray['send_for_notification'] = $appType;
                                              $notificationArray['send_for_notification_id'] = $userSocietyId;
                                              $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : 0;
                                              $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                          }

                                        if ($appType == MANAGER_APP) {
                                            $notificationArray['send_for_notification'] = $appType;
                                            $notificationArray['send_for_notification_id'] = $userSocietyId;
                                            $notificationArray['receive_for_notification'] =  isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : 0;
                                            $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                        }

                                          if($appType == MEMBER_APP){
                                              $notificationArray['send_for_notification'] = $appType;
                                              $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                              $notificationArray['receive_for_notification'] =  isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : 0;
                                              $notificationArray['receive_for_notification_id'] =  isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                          }

                                          $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                          array_push($notificationDataArray, $notificationArray);
                                      }
                                  }
                              }
                          }
                          
                        // if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                        //     sendNotificationSosGateKeeperAndroid($notificationDataArray,$lastSosEmergencyId);
                        // }
                    }
                }

                    // printArray($notificationDataArray,1);
                if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                    sendNotificationSosGateKeeperAndroid($notificationDataArray,$lastSosEmergencyId);
                }
            }

            if ($lastSosEmergencyId != '') {
                if (isset($sosRecordDocument) && count($sosRecordDocument) > 0) {
                    $recordArray = array();
                    unset($sosRecordDocument['success']);
                    foreach ($sosRecordDocument as $key => $imageData) {
                        $dataArray = array(
                            'sos_emergency_record_id' => '',
                            'sos_emergency_id' => $lastSosEmergencyId,
                            'sos_record' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                            'created_by' => $userSocietyId,
                            'updated_by' => $userSocietyId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($recordArray, $dataArray);
                    }
                    $sosExtraDataArray = array();
                    $sosExtraDataArray['module_id'] = $lastSosEmergencyId;
                    $sosExtraDataArray['module'] = 'SOS Emergency Record';
                    $sosExtraDataArray['type'] = 'SOS Emergency';
                    $sosExtraDataArray['old_data'] = '';
                    $sosExtraDataArray['user_id'] = $userSocietyId;
                    $sosExtraDataArray['society_id'] = $societyId;
                    $this->commonWebserviceModel->batchInsert($recordArray, 'tbl_sos_emergency_record', $sosExtraDataArray);
                }
            }
            $sosEmergencyRecordData = $this->sosModel->getSosEmergencyData(array(
                'sos_emergency_id' => $lastSosEmergencyId,
            ));
            if (!empty($sosEmergencyRecordData)) {
                if ($sosEmergencyRecordData["category_image"] == '') {
                    $sosEmergencyRecordData["category_image"] = SITE_URL('uploads/no_image.png');
                    $sosEmergencyRecordData["thumbnail_category_image"] = SITE_URL('uploads/no_image.png');
                } else {
                    $sosEmergencyRecordData["thumbnail_category_image"] = SITE_URL() . THUMBNAIL_CATEGORY_IMAGE_PATH . $sosEmergencyRecordData["category_image"];
                    $sosEmergencyRecordData["category_image"] = SITE_URL() . CATEGORY_IMAGE_PATH . $sosEmergencyRecordData["category_image"];
                }
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($sosEmergencyId) && !empty($sosEmergencyId)) {
                if ((isset($sosEmergencyData['success']) && $sosEmergencyData['success']) && ($transactionStatus == 1)) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.sos')),
                        'data' => $sosEmergencyRecordData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.sos')),
                        'data' => $sosEmergencyRecordData
                    ), 404);
                }
            } else {
                if ((isset($sosEmergencyData['success']) && $sosEmergencyData['success']) && ($transactionStatus == 1)) {
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.sos')),
                        'data' => $sosEmergencyRecordData
                    ), 200);
                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.sos')),
                        'data' => $sosEmergencyRecordData
                    ), 400);
                }
            }
        }
        // }
    }

    public function SosEmergencyResolved()
    {
        $this->db->transStart();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $sosEmergencyId = $this->request->getVar('sos_emergency_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $societyId = $this->request->getVar('society_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_society_id', lang('CommonWebService.user_society_id'), 'required');
        $this->validation->setRule('sos_emergency_id', lang('CommonWebService.sos_emergency_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $statusId = 0;
            $statusData = $this->statusModel->getStatusData(array(
                'is_resolved' => 1,
                'status_for' => 'sos_emergency',
                'is_active' => 1,
            ));
            if (empty($statusData)) {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => 'Status Master Sos Emergency Is Resolved Status Not Defined',
                    'data' => null
                ), 404);
            }
            if (!empty($statusData)) {
                $statusId = isset($statusData['status_id']) ? $statusData['status_id'] : 0;
            }
            $sosEmergecyUpdateArray = array();
            $sosEmergencyArray = array(
                'sos_emergency_id' => $sosEmergencyId,
                'status_id' => $statusId,
            );
            if (!empty($sosEmergencyId)) {
                $sosEmergecyUpdateArray = $this->sosModel->getSosEmergencyData(array(
                    'sos_emergency_id' => $sosEmergencyId,
                ));
                $sosEmergecyUpdateArray = compareArray($sosEmergencyArray, $sosEmergecyUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userSocietyId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $sosEmergencyData = $this->commonWebserviceModel->insertUpdateRecord($sosEmergencyArray, 'sos_emergency_id', 'tbl_sos_emergency', 1, '', array(), $extraData, $sosEmergecyUpdateArray);
            $lastSosEmergencyId = $sosEmergencyData['lastInsertedId'];

            $notificationSosEmergencyArrayData = array();
            $notificationSosEmergencyData = $this->notificationModel->getNotificationData(array(
                'type' => 'sos_emergency',
                'type_id' => $sosEmergencyId,
                'is_multiple' => 1,
            ));

            // printArray($notificationSosEmergencyData,1);

            if(!empty($notificationSosEmergencyData)){
                foreach($notificationSosEmergencyData as $notificationElement){
                    $notificationSosEmergencyArrayData[] = array(
                        'notification_id' => $notificationElement['notification_id'],
                        'is_resolved' => 1,
                        'updated_by' => $userSocietyId,
                        'updated_at' => date("Y-m-d H:i:s")
                    );
                }
            }

            if(!empty($notificationSosEmergencyArrayData)){
                $this->notificationModel->batchUpdate($notificationSosEmergencyArrayData, 'notification_id', 'tbl_notification');
            }
            $sosNotification = $this->sosModel->getSosEmergencyNotificationData(array(
                'sos_emergency_id' => $sosEmergencyId,
                'is_multiple' => 1
            ));
            $notificationDataArray = array();
            $memberIdArray = array();
            $ownershipFlatIdArray = array();
            $sosEmergecyInsertData = $this->sosModel->getSosEmergencyData(array(
                'sos_emergency_id' => $lastSosEmergencyId,
            ));

            // printArray($sosNotification,1);
            if (!empty($sosNotification)) {
                $sosNotificationTypeArray = array();
                $resourceTypeMemberData = $this->resourceTypeModel->getResourceTypeData(array(
                    'resource_type_name' => RESOURCE_TYPE_MEMBER,
                    'society_id' => $societyId,
                ));
                $resourceTypeManagerData = $this->resourceTypeModel->getResourceTypeData(array(
                    'resource_type_name' => RESOURCE_TYPE_MANAGER,
                    'society_id' => $societyId,
                ));
                $resourceTypeGuardData = $this->resourceTypeModel->getResourceTypeData(array(
                    'is_guard' => 1,
                    'is_multiple' => 1,
                    'is_login' => 1,
                    'is_active' => 1,
                    'society_id' => $societyId,
                ));
                $resourceTypeIdArray = [];
                if (!empty($resourceTypeGuardData)) {
                    foreach ($resourceTypeGuardData as $resourceTypeElement) {
                        $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                    }
                }
                $userData = $this->commonWebserviceModel->getUserSocietyData(array(
                    'user_society_id' => $userSocietyId,
                ));
                $resourceTypeIdNot = $userData['resource_type_id'];
                foreach ($sosNotification as $sosNotificationElement) {
                    if ($sosNotificationElement['sos_emergency_type'] == 'family') {
                        $ownershipFlatMemberIdArray = array();
                        $userDeviceUserSocietyIdArray = array();
                        $userDeviceUserTypeIdArray = array();
                        $userDeviceUserTypeArray = array();
                        $userMergeArray = array();
                        $memberIdArray = array();

                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'is_show_all_member' => 1,
                            'is_active' => 1
                        ));
                        if (!empty($ownershipFlatMemberData)) {
                            $type = isset($ownershipFlatMemberData['type']) ? $ownershipFlatMemberData['type'] : '';
                            if ($type == 'ownership_flat') {
                                $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                    'ownership_flat_id' => $ownershipFlatMemberData['ownership_flat_id'],
                                    'ownership_flat_member_id_not' => $ownershipFlatMemberId,
                                    'type' => $type,
                                    'is_show_all_member' => 1,
                                    'is_multiple' => 1,
                                    'is_active' => 1
                                ));
                            } else if ($type == 'rentals') {
                                $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                    'ownership_flat_id' => $ownershipFlatMemberData['ownership_flat_id'],
                                    'ownership_flat_member_id_not' => $ownershipFlatMemberId,
                                    'is_show_all_member' => 1,
                                    'is_multiple' => 1,
                                    'is_active' => 1
                                ));
                            }
                        }
                        if (!empty($ownershipFlatData)) {
                            foreach ($ownershipFlatData as $ownershipFlat) {
                                $memberIdArray[] = $ownershipFlat['member_id'];
                            }
                        }
                        if (!empty($ownershipFlatMemberIdArray)) {
                            $userSocietyFamilyData = $this->commonWebserviceModel->getUserSocietyData(array(
                                'society_id' => $societyId,
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $memberIdArray,
                                'is_multiple' => 1
                            ));

                            if (!empty($userSocietyFamilyData)) {
                                foreach ($userSocietyFamilyData as $userSocietyFamilyElement) {
                                    $userDeviceUserSocietyIdArray[] = isset($userSocietyFamilyElement['user_society_id']) ? $userSocietyFamilyElement['user_society_id'] : 0;
                                    $userDeviceUserTypeIdArray[] = isset($userSocietyFamilyElement['type_id']) ? $userSocietyFamilyElement['type_id'] : 0;
                                    $userDeviceUserTypeArray[] = $resourceTypeMemberData['resource_type_id'];
                                }
                                $userDevice = $this->commonWebserviceModel->deviceData(array(
                                    "user_society_id" => $userDeviceUserSocietyIdArray,
                                    "user_type" => MEMBER_APP,
                                    // "resource_type_id" => $userDeviceUserTypeArray,
                                    "is_latest" => 1,
                                    "is_multiple" => 1
                                ));


                                if (!empty($userDevice)) {
                                    foreach ($userDevice as $userDeviceElement) {
                                        if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
                                            $notificationArray = array(
                                                'ownership_flat_id' => 0,
                                                'ownership_flat_member_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'type' => 'sos_emergency_resolved',
                                                'status' => 'sos_emergency_resolved',
                                                'type_id' => $lastSosEmergencyId,
                                                'society_id' => $societyId,
                                                'flat_id' => 0,
                                                'staff_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'management_committee_id' => 0,
                                                //'user_id' => isset($staff['user_id']) ? $staff['user_id'] : 0,
                                                'user_society_id' => $userSocietyId,
                                                'category_name' => $sosEmergecyInsertData['category_name'],
                                                'notification_title' => $sosEmergecyInsertData['category_name'] . ' Resolved',
                                                'description' => 'The SOS alert with the topic ' . $sosEmergecyInsertData['category_name'] . ' has been resolved. Thank you for your prompt attention.',
                                                'module' => 'sos_emergency',
                                                'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
                                                'app_type' => $appType,
                                                // 'app_url' => MEMBER_URL .'sos_alert/' . $lastSosEmergencyId,
                                                // 'user_type_name' => isset($userDeviceElement['user_type_name']) ? $userDeviceElement['user_type_name'] : '',
                                                // 'display_status' => underscoreToUcWord('sos_emergency_resolved'),
                                            );
                                            if ($appType == GATE_KEEPER) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : 0;
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            if ($appType == MANAGER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            if ($appType == MEMBER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : 0;
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }
                                            $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                            array_push($notificationDataArray, $notificationArray);
                                        }
                                    }
                                }
                            }
                        }
                        // if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                        //     sendNotificationSosGateKeeperAndroid($notificationDataArray,$lastSosEmergencyId);
                        // }

                    } else if ($sosNotificationElement['sos_emergency_type'] == 'residents') {
                        $memberIdArray = array();
                        $userDeviceUserSocietyIdArray = array();
                        $userDeviceUserTypeIdArray = array();
                        $userDeviceUserTypeArray = array();
                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'society_id' => $societyId,
                            'ownership_flat_member_id_not' => $ownershipFlatMemberId,
                            'is_latest' => 1,
                            'is_show_all_member' => 1,
                            'is_multiple' => 1,
                            'is_active' => 1
                        ));
                        if (!empty($ownershipFlatMemberData)) {
                            foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                $memberIdArray[] = $ownershipFlatMember['member_id'];
                            }
                        }


                        // $notificationDataArray = array();
                        if (!empty($memberIdArray)) {

                            $userSocietyFamilyData = $this->commonWebserviceModel->getUserSocietyData(array(
                                'society_id' => $societyId,
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $memberIdArray,
                                'user_society_id_not' => $userSocietyId,
                                'is_multiple' => 1
                            ));

                            // printaRRAY($userSocietyFamilyData,1);
                            if (!empty($userSocietyFamilyData)) {
                                foreach ($userSocietyFamilyData as $userSocietyFamilyElement) {
                                    $userDeviceUserSocietyIdArray[] = isset($userSocietyFamilyElement['user_society_id']) ? $userSocietyFamilyElement['user_society_id'] : 0;
                                    // $userDeviceUserTypeIdArray[] = isset($userSocietyFamilyElement['type_id']) ? $userSocietyFamilyElement['type_id'] : 0;
                                    // $userDeviceUserTypeArray[] = $resourceTypeMemberData['resource_type_id'];
                                }
                                $userDevice = $this->commonWebserviceModel->deviceData(array(
                                    "user_society_id" => $userDeviceUserSocietyIdArray,
                                    "user_type" => MEMBER_APP,
                                    // "resource_type_id" => $userDeviceUserTypeArray,
                                    "is_latest" => 1,
                                    "is_multiple" => 1
                                ));



                                if (!empty($userDevice)) {
                                    foreach ($userDevice as $userDeviceElement) {
                                        if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
                                            $notificationArray = array(
                                                'ownership_flat_id' => 0,
                                                'ownership_flat_member_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'type' => 'sos_emergency_resolved',
                                                'status' => 'sos_emergency_resolved',
                                                'type_id' => $lastSosEmergencyId,
                                                'society_id' => $societyId,
                                                'flat_id' => 0,
                                                'staff_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'management_committee_id' => 0,
                                                //'user_id' => isset($staff['user_id']) ? $staff['user_id'] : 0,
                                                'user_society_id' => $userSocietyId,
                                                'category_name' => $sosEmergecyInsertData['category_name'],
                                                'notification_title' => $sosEmergecyInsertData['category_name'] . ' Resolved',
                                                'description' => 'The SOS alert with the topic ' . $sosEmergecyInsertData['category_name'] . ' has been resolved. Thank you for your prompt attention.',
                                                'module' => 'sos_emergency',
                                                'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
                                                'app_type' => $appType,
                                                // 'app_url' => MEMBER_URL .'sos_alert/' . $lastSosEmergencyId,
                                                // 'user_type_name' => isset($userDeviceElement['user_type_name']) ? $userDeviceElement['user_type_name'] : '',
                                                // 'display_status' => underscoreToUcWord('sos_emergency_resolved'),
                                            );
                                            if ($appType == GATE_KEEPER) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : 0;
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            if ($appType == MANAGER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            if ($appType == MEMBER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : 0;
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }
                                            $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                            array_push($notificationDataArray, $notificationArray);
                                        }
                                    }
                                }
                            }
                        }
                        // if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                        //     sendNotificationSosGateKeeperAndroid($notificationDataArray,$lastSosEmergencyId);
                        // }

                    } else if ($sosNotificationElement['sos_emergency_type'] == 'committee') {
                        $userDeviceUserSocietyIdArray = array();
                        $userDeviceUserTypeIdArray = array();
                        $userDeviceUserTypeArray = array();
                        // $notificationDataArray = array();
                        $userManagerDevice = array();
                        $userDeviceManagerIdArray = array();
                        $userDeviceManagerTypeIdArray = array();
                        $userDeviceManagerTypeArray = array();
                        $ownershipFlatMemberIdArray = array();
                        $memberIdArray = array();

                        $managementCommitteeData = $this->managementCommitteeModel->getManagementCommitteeData(array(
                            'society_id' => $societyId,
                            'is_api' => 1,
                            'is_active' => 1,
                            'is_multiple' => 1
                        ));
                        if (!empty($managementCommitteeData)) {
                            foreach ($managementCommitteeData as $managementCommitteeElement) {
                                $ownershipFlatMemberIdArray[] = $managementCommitteeElement['member_id'];
                                $memberIdArray[] = $managementCommitteeElement['member_id'];
                            }
                        }

                        if(!empty($memberIdArray)){
                            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                                'is_show_all_member' => 1,
                                'is_multiple' => 1,
                                'is_active' => 1
                            ));
                            if(!empty($ownershipFlatMemberData)){
                                foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                    $memberIdArray[] = $ownershipFlatMember['member_id'];
                                }
                            }
                            if(!empty($ownershipFlatMemberData)){
                                $userSocietyCommitteeData = $this->commonWebserviceModel->getUserSocietyData(array(
                                    "type_id" => $memberIdArray,
                                    "resource_type_id" => $resourceTypeMemberData['resource_type_id'],
                                    'user_society_id_not' => $userSocietyId,
                                    'society_id' => $societyId,
                                    'is_multiple' => 1 
                                ));

                                if (!empty($userSocietyCommitteeData)) {
                                    foreach ($userSocietyCommitteeData as $userSocietyCommitteeElement) {
                                        $userDeviceUserSocietyIdArray[] = isset($userSocietyCommitteeElement['user_society_id']) ? $userSocietyCommitteeElement['user_society_id'] : 0;
                                       
                                    }


                                    $userMemberDevice = $this->commonWebserviceModel->deviceData(array(
                                        "user_society_id" => $userDeviceUserSocietyIdArray,
                                        "user_type" => MEMBER_APP,
                                        // "resource_type_id" => $userDeviceUserTypeArray,
                                        "is_latest" => 1,
                                        "is_multiple" => 1
                                    ));

                                    $userManagerData = $this->commonWebserviceModel->getUserSocietyData(array(
                                        'society_id' => $societyId,
                                        'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
                                        'user_society_id_not' => $userSocietyId,
                                        'is_active' => 1,
                                        'is_multiple' => 1
                                    ));

                                    if (!empty($userManagerData)) {
                                        foreach ($userManagerData as $userManagerCommittee) {
                                            $userDeviceManagerIdArray[] = isset($userManagerCommittee['user_society_id']) ? $userManagerCommittee['user_society_id'] : 0;
                                        }

                                        $userManagerDevice = $this->commonWebserviceModel->deviceData(array(
                                            "user_society_id" => $userDeviceManagerIdArray,
                                            "user_type" => MANAGER_APP,
                                            // "resource_type_id" => $userDeviceManagerTypeArray,
                                            "is_latest" => 1,
                                            "is_multiple" => 1
                                        ));
                                    }

                                    $userMergeArray = array_merge($userMemberDevice,$userManagerDevice);

                                    if (!empty($userMergeArray)) {
                                        foreach ($userMergeArray as $userDeviceElement) {
                                            if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
                                                $notificationArray = array(
                                                    'ownership_flat_id' => 0,
                                                    'ownership_flat_member_id' => isset($userDeviceElement['type_id']) ? $userDeviceElement['type_id'] : 0,
                                                    'type' => 'sos_emergency_resolved',
                                                    'status' => 'sos_emergency_resolved',
                                                    'type_id' => $lastSosEmergencyId,
                                                    'society_id' => $societyId,
                                                    'flat_id' => 0,
                                                    'staff_id' => isset($userDeviceElement['type_id']) ? $userDeviceElement['type_id'] : 0,
                                                    'management_committee_id' => isset($userDeviceElement['management_committee_id']) ? $userDeviceElement['management_committee_id'] : 0,
                                                    //'user_id' => isset($staff['user_id']) ? $staff['user_id'] : 0,
                                                    'user_society_id' => $userSocietyId,
                                                    'category_name' => $sosEmergecyInsertData['category_name'],
                                                    'notification_title' => $sosEmergecyInsertData['category_name'] . ' Resolved',
                                                    'description' => 'The SOS alert with the topic ' . $sosEmergecyInsertData['category_name'] . ' has been resolved. Thank you for your prompt attention.',
                                                    'module' => 'sos_emergency',
                                                    'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                    'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                    'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                    'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
                                                    'app_type' => $appType,
                                                    // 'app_url' => MEMBER_URL .'sos_alert/' . $lastSosEmergencyId,
                                                    // 'user_type_name' => isset($userDeviceElement['user_type_name']) ? $userDeviceElement['user_type_name'] : '',
                                                    // 'display_status' => underscoreToUcWord('sos_emergency_resolved'),
                                                );

                                                if ($appType == GATE_KEEPER) {
                                                    $notificationArray['send_for_notification'] = $appType;
                                                    $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                    $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                                    $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                                }

                                                if ($appType == MANAGER_APP) {
                                                    $notificationArray['send_for_notification'] = $appType;
                                                    $notificationArray['send_for_notification_id'] = $userSocietyId;
                                                    $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                                    $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                                }

                                                if ($appType == MEMBER_APP) {
                                                    $notificationArray['send_for_notification'] = $appType;
                                                    $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                                    $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                                    $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
          