<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\WaterTankModel;
class WaterTank extends BaseController
{
    protected $water_tank_model;
    public function __construct() {
        $this->water_tank_model = new WaterTankModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Water Tank';
        $data['v_water_tank_modal'] = view('Admin/WaterTank/WaterTankModalView', $data);
        return $this->dt_ci_template->load("Admin","WaterTank/WaterTankView",$data);
    }

    public function getWaterTankListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_water_tank as twt");
        $this->datatables->select("twt.water_tank_id, twt.water_tank_name,twt.is_active, twt.society_id,ts.society_name");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,twt.created_at,twt.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = twt.updated_by AND tupdate.society_id = twt.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = twt.created_by AND tcreate.society_id = twt.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = twt.society_id","left");
        $this->datatables->groupBy("twt.water_tank_id");
        accessFilter($this->datatables, array("society" => "twt.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "water_tank_id" => isset($displayData['water_tank_id']) ? $displayData['water_tank_id'] : "",
                );
                $data[$key]['action_button'] = waterTankActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function addEdit()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $waterTankId = $this->request->getVar('water_tank_id');
        $waterTankName = $this->request->getVar('water_tank_name');
        $isActive = $this->request->getVar('is_active');

        if (isset($waterTankId) && $waterTankId == '') {
            $validation->setRule('water_tank_name', lang('WaterTank.water_tank_name'), 'required|combination_unique[tbl_water_tank.water_tank_name.'.$this->session->get('society_id').'.]');
        } else {
            $validation->setRule('water_tank_name', lang('WaterTank.water_tank_name'), 'required|edit_unique[tbl_water_tank.water_tank_name.' . $waterTankId . '.'. $this->session->get('society_id').']');
        }
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $waterTankUpdateArray = array();
            $waterTankArray = array(
                'water_tank_id' => $waterTankId,
                'water_tank_name' => $waterTankName,
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
            );
            if(!empty($waterTankId)){
                $waterTankUpdateData = $this->water_tank_model->getWaterTankData(array(
                    'water_tank_id' => $waterTankId,
                    'is_api' => 0,
                ));
                $waterTankUpdateArray = compareArray($waterTankArray,$waterTankUpdateData);
            }

            $waterTankData = $this->water_tank_model->insertUpdateRecord($waterTankArray,'water_tank_id','tbl_water_tank', 1,'',array(),array(),$waterTankUpdateArray);
            $transactionStatus = $this->db->transComplete();
            if (isset($waterTankId) && $waterTankId != '') {
                if (($waterTankData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('WaterTank.water_tank'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('WaterTank.water_tank'));
                }
            } else {
                if (($waterTankData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('WaterTank.water_tank'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('WaterTank.water_tank'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $waterTankId = $this->request->getVar('water_tank_id');
        $status = $this->request->getVar('status');
        $return = $this->water_tank_model->statusChange($waterTankId,$status,'water_tank_id','tbl_water_tank');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('WaterTank.water_tank'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('WaterTank.water_tank'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $waterTankId = $this->request->getVar('water_tank_id');
         if( isReferenceInTable( 'water_tank_id','tbl_water_meter_reading', $waterTankId)){
             if(!empty($waterTankId)){
                 foreach($waterTankId as $waterTank){
                     $deleteDataArray['module'] = 'Water Tank';
                     $deleteDataArray['activity'] = "Tried to delete Water Tank ";
                     $deleteDataArray['module_id'] = $waterTank;
                     logActivity('Tried to delete Water Tank [WaterTankID: ' . $waterTank . ']',$this->data['userId'],'Water Tank',$waterTank,json_encode($deleteDataArray),'','Water Tank',$waterTank);
                 }
             }
             $response['success'] = false;
             $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
             echo json_encode($response);
             exit;
         }
        $waterTankData = $this->water_tank_model->deleteRecord($waterTankId);
        $transactionStatus = $this->db->transComplete();
        if (($waterTankData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('WaterTank.water_tank'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('WaterTank.water_tank'));
        }
        echo json_encode($response);
        exit;
    }

    public function getWaterTankDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $waterTankId = $this->request->getVar('water_tank_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'water_tank_id' => $waterTankId,

        );
        echo $this->water_tank_model->getWaterTank($filterData);
    }

    public function excelExportWaterTank()
    {
        $fileName ='water-tank-' . DATETIMEFORMAT;
        $sheetName = 'WaterTank-' . DATEFORMAT;
        $excelHeaderName = 'Water Tank';
        $tableData = $this->getWaterTankListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('Society.society'),
            lang('WaterTank.water_tank_name'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["water_tank_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'C';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
