<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
// use App\Models\MaterialModel;
use App\Models\VisitorModel;

class Visitor extends BaseController
{
    protected $visitor_model;
    public function __construct() {
        // $this->material_model = new MaterialModel();
        $this->visitor_model = new VisitorModel();

    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Visitor';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "flatDd",
                "id" => "filter_flat_id",
                "name" => "filter_flat_id",
                "title" => "Visitor.flat_no",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_start_date",
                "name" => "filter_start_date",
                "title" => "Visitor.start_date",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_end_date",
                "name" => "filter_end_date",
                "title" => "Visitor.end_date",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Visitor/VisitorView",$data);
    }

    public function getVisitorListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $flatId = $this->request->getVar("filter_flat_id");
        $startDate = $this->request->getVar("filter_start_date");
        $endDate = $this->request->getVar("filter_end_date");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");

        $this->datatables->table("tbl_visitor as tv");

        $this->datatables->select("tv.visitor_id,tv.visitor_name,tv.visitor_mobile_no,tv.visitor_purpose,tv.vehicle_no,tv.vehicle_type,tof.flat_id,tv.visitor_company_id,tv.no_of_parcel,tv.collect_on_gate,tv.status,tv.start_date,tv.end_date,tv.no_of_visitor, tc.visitor_company_name,tv.delivery_reference_name,tv.delivery_reference_mobile,tv.otp,tv.otp_validity");

        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tv.updated_at");
        $this->datatables->select("COALESCE(ts.society_name,'') as society_name");
        $this->datatables->select("concat(COALESCE(tto.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tv.updated_by AND tupdate.society_id = tv.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tv.society_id","left");
        $this->datatables->join("tbl_visitor_company as tc","tc.visitor_company_id = tv.visitor_company_id","left");
        $this->datatables->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tv.ownership_flat_member_id","left");
        $this->datatables->join("tbl_ownership_flat as tof","tof.ownership_flat_id = tv.ownership_flat_id","left");
        $this->datatables->join("tbl_flat as tf","tf.flat_id = tof.flat_id","left");
        $this->datatables->join("tbl_tower as tto","tto.tower_id = tf.tower_id","left");

        $this->datatables->Where("is_deleted = 0");
        accessFilter($this->datatables, array("society" => "tv.society_id"));
        if(isset($flatId)) {
            if(is_array($flatId)){
                $this->datatables->whereIn("tof.flat_id",$flatId);
            } else {
                $this->datatables->where("tof.flat_id",$flatId);
            }
        }
        
        if($startDate != ''){
            list($fromDate,$toDate) = explode(" - ",$startDate);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tv.start_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tv.start_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tv.start_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($endDate != ''){
            list($fromDate,$toDate) = explode(" - ",$endDate);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tv.end_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tv.end_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tv.end_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tv.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tv.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tv.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(tv.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(tv.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(tv.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        $this->datatables->groupBy("tv.visitor_id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : '-';
                $data[$key]['start_date'] = isValidDate($displayData['start_date']) ? siteDateFormat($displayData['start_date'],true) : '-';
                $data[$key]['end_date'] = isValidDate($displayData['end_date']) ? siteDateFormat($displayData['end_date'],true) : '-';
                $data[$key]['vehicle_type'] = isset($displayData['vehicle_type']) ? underscoreToUcWord($displayData['vehicle_type']) : '-';
                $data[$key]['transaction_type'] = isset($displayData['transaction_type']) ? underscoreToUcWord($displayData['transaction_type']) : '-';
                $data[$key]['status'] = isset($displayData['status']) ? underscoreToUcWord($displayData['status']) : '-';
                $data[$key]['excel_flat_no'] = isset($displayData['flat_no']) ?  $displayData['flat_no'] : "";
                $data[$key]['flat_no'] = isset($displayData['flat_no']) ?  flatDocumentToHtml($displayData['flat_no'],$displayData['flat_id']) : "";
                $data[$key]['collect_on_gate'] = (isset($displayData['collect_on_gate']) && $displayData['collect_on_gate'] != 0) ? "Yes"  : "No";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function excelExportVisitor()
    {
        $fileName ='visitor-' . DATETIMEFORMAT;
        $sheetName = 'Visitor-' . DATEFORMAT;
        $excelHeaderName = 'Visitor';
        $tableData = $this->getVisitorListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Visitor.visitor_name'),
            lang('Visitor.visitor_mobile_no'),
            lang('Visitor.visitor_purpose'),
            lang('Visitor.vehicle_type'),
            lang('Visitor.vehicle_no'),
            lang('Visitor.flat_no'),
            lang('Visitor.visitor_company_name'),
            lang('Visitor.no_of_parcel'),
            lang('Visitor.collect_on_gate'),
            lang('Visitor.status'),
            lang('Visitor.start_date'),
            lang('Visitor.end_date'),
            lang('Visitor.no_of_visitor'),
            lang('Visitor.delivery_reference_name'),
            lang('Visitor.delivery_reference_mobile'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["visitor_name"],
                $row["visitor_mobile_no"],
                $row["visitor_purpose"],
                $row["vehicle_type"],
                $row["vehicle_no"],
                $row["excel_flat_no"],
                $row["visitor_company_name"],
                $row["no_of_parcel"],
                $row["collect_on_gate"],
                $row["status"],
                $row["start_date"],
                $row["end_date"],
                $row["no_of_visitor"],
                $row["delivery_reference_name"],
                $row["delivery_reference_mobile"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'Q';

        // printArray($dataRows,1);
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}