<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\OwnershipFlatModel;
use App\Models\DocumentModel;
use App\Models\StaffModel;
class TransferredFlat extends BaseController
{
    protected $ownership_flat_model;
    public function __construct() {
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->document_model = new DocumentModel();
        $this->staff_model = new StaffModel();
    }
    public function index()
    {
        $type =  $this->request->getGet("type");
        if($type == TRANSFERRED) {
            $langAlias = 'TransferredFlat.';
            if (!$this->dt_ci_acl->checkAccess("TransferredFlat|index")) {
                return redirect()->to('Admin/Dashboard');
            }
        }
        else{
            $langAlias = 'OwnershipFlat.';
        }

        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Transferred Flat';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "flatDd",
                "id" => "filter_flat_id",
                "name" => "filter_flat_id",
                "title" => $langAlias."flat_no",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_date_of_registry",
                "name" => "filter_date_of_registry",
                "title" => $langAlias."date_of_registry",
                // "selected" => currentFinancialYear(),
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),

            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),

        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        $data['lang_name'] = $langAlias;
        return $this->dt_ci_template->load("Admin","OwnershipFlat/OwnershipFlatView",$data);
    }



    public function manage($ownershipFlatId = '',$view = '')
    {
        $request    = \Config\Services::request();
        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );
        $type = $this->request->getGet('type');
        if($type == TRANSFERRED) {
            $langAlias = 'TransferredFlat.';
            if (!$this->dt_ci_acl->checkAccess("TransferredFlat|manage")) {
                return redirect()->to('Admin/Dashboard');
            }
        }
        else{
            $langAlias = 'OwnershipFlat.';
        }


        if ($ownershipFlatId != '') {
            $filterData = array(
                "ownership_flat_id" => $ownershipFlatId
            );
            $data['ownership_flat_data'] = $this->ownership_flat_model->getOwnershipFlatData($filterData);
            if (empty($data['ownership_flat_data'])) {
                return redirect()->to('Admin/OwnershipFlat?type=first_owner');
            }

            $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                'type' => 'ownership_flat',
                'type_id' => $ownershipFlatId,
                'is_multiple' => 1
            ));
            $data['ownership_flat_member_data'] = $ownershipFlatMemberData;

            $ownershipFlatEmergencyContactData = $this->ownership_flat_model->getOwnershipFlatEmergencyData(array(
                'type' => 'ownership_flat',
                'type_id' => $ownershipFlatId,
                'is_multiple' => 1
            ));
            $data['ownership_flat_emergency_contact_data'] = $ownershipFlatEmergencyContactData;

            $ownershipFlatParkingData = $this->ownership_flat_model->getOwnershipFlatParkingData(array(
                'type' => 'ownership_flat',
                'type_id' => $ownershipFlatId,
                'is_multiple' => 1
            ));
            $data['ownership_flat_parking_data'] = $ownershipFlatParkingData;

            $ownershipFlatAccessCardData = $this->ownership_flat_model->getModuleAccessCardData(array(
                'type' => 'ownership_flat',
                'type_id' => $ownershipFlatId,
                'is_multiple' => 1
            ));

            $moduleAccessCardTokenIdArray = array();
            if (!empty($ownershipFlatAccessCardData)) {
                foreach ($ownershipFlatAccessCardData as $accessCardElement) {
                    array_push($moduleAccessCardTokenIdArray,$accessCardElement['module_access_card_token_id']);
                }
            }

            $ownershipFlatAccessCardVehicleTypeData = array();
            $ofacvtTypeIdWiseArray = array();
            if(!empty($moduleAccessCardTokenIdArray)){
                $ownershipFlatAccessCardVehicleTypeData = $this->ownership_flat_model->getModuleAccessCardVehicleTypeData(array(
                    'module_access_card_token_id' => $moduleAccessCardTokenIdArray,
                    'is_multiple' => 1
                ));


                if(!empty($ownershipFlatAccessCardVehicleTypeData)){
                    foreach($ownershipFlatAccessCardVehicleTypeData  as $ofacvKey => $ownershipFlatAccessCardVehicleTypeElement){
                        $ofacvtTypeIdWiseArray[$ownershipFlatAccessCardVehicleTypeElement['module_access_card_token_id']][] = $ownershipFlatAccessCardVehicleTypeElement;
                    }
                }
            }

            if(!empty($ownershipFlatAccessCardData)){
                foreach($ownershipFlatAccessCardData as $ofacKey => $ownershipFlatAccessCardElement){
                    $ownershipFlatAccessCardData[$ofacKey]['vehicle_data'] = array_key_exists($ownershipFlatAccessCardElement['module_access_card_token_id'],$ofacvtTypeIdWiseArray) ? $ofacvtTypeIdWiseArray[$ownershipFlatAccessCardElement['module_access_card_token_id']]: array();
                }
            }

            $data['ownership_flat_access_card_data'] = $ownershipFlatAccessCardData;



            $documentData = $this->document_model->getDocumentData(array(
                'document_for' => 'ownership_flat',
                'is_active' => 1,
                'is_multiple' => 1,

            ));
            if(!empty($documentData)){
                foreach ($documentData as $key => $displayData) {
                    $document = $this->staff_model->getDocument(array(
                        'document_id' => $displayData['document_id'],
                    ));
                    if(!empty($document)){
                        $documentData[$key]['module_document_id'] = $document['module_document_id'];
                    }
                    $documentImageData = $this->staff_model->getDocumentImage(array(
                        "document_id" => isset($displayData['document_id']) ? $displayData['document_id'] : "",
                        'module_id' => $ownershipFlatId,
                        'module' => 'ownership_flat',
                        "is_multiple" => 1,
                    ));
                    $documentData[$key]['module_image_data'] = $documentImageData;
                }
            }
            $data['document_data'] = $documentData;
        }
        else{
            $documentType = $this->document_model->getDocumentData(array(
                'document_for' => 'ownership_flat',
                'is_active' => 1,
                'is_multiple' => 1,

            ));
            $iKey = 0;
            if(!empty($documentType)){
                foreach($documentType as $imageType){
                    $documentTypeData[$iKey] = $imageType;
                    $iKey = $iKey + 1;
                }
            }
            if(!empty($documentTypeData)){
                $data['document_data'] = $documentTypeData;
            }
        }
        if ($ownershipFlatId != '') {
            $data['title'] = lang($langAlias.'edit_ownership_flat');
        } else {
            $data['title'] = lang($langAlias.'add_ownership_flat');
        }
        $data['ownership_flat_data']['view'] = (isset($view) && $view != '' ? 1 : 0);

        $data['document_table'] = view('Admin/Staff/DocumentView', isset($data) ? $data : array());
        $data['request']= $request;
        $data['ownership_flat_member_table'] = view('Admin/OwnershipFlat/OwnershipFlatMemberView', isset($data) ? $data : array());
        $data['ownership_flat_emergency_contact_table'] = view('Admin/OwnershipFlat/OwnershipFlatEmergencyContactView', isset($data) ? $data : array());
        $data['ownership_flat_parking_table'] = view('Admin/OwnershipFlat/OwnershipFlatParkingView', isset($data) ? $data : array());
        $data['ownership_flat_access_card_table'] = view('Admin/OwnershipFlat/OwnershipFlatAccessCardView', isset($data) ? $data : array());
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax) ? $select2Ajax : array());

        if ((isset($data['ownership_flat_data']['society_id']) && $data['ownership_flat_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/OwnershipFlat?type=transferred');
        }
        $data['lang_name'] = $langAlias;
        $this->dt_ci_template->load("Admin","OwnershipFlat/OwnershipFlatManageView",$data);
    }
}
