<?php
namespace App\Controllers\Admin;

use App\Models\FlatModel;
use CodeIgniter\Controller;
use App\Models\TowerModel;
class Tower extends BaseController
{
    protected $tower_model;
    protected $flat_model;
    public function __construct() {
        $this->tower_model = new TowerModel();
        $this->flat_model = new FlatModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Tower';
        return $this->dt_ci_template->load("Admin","Tower/TowerView",$data);
    }

    public function manage($towerId = '')
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        if ($towerId != '') {
            $filterData = array(
                "tower_id" => $towerId
            );
            $data['tower_data'] = $this->tower_model->getTowerData($filterData);


            $towerUnit = $this->tower_model->getTowerUnitData(array(
                'tower_id' => $towerId,
                'is_multiple' => 1
            ));
            $data['tower_unit_data'] = $towerUnit;

        }
        if ($towerId != '') {
            $data['title'] = 'Edit Tower';
        } else {
            $data['title'] = 'Add Tower';
        }
        if ((isset($data['tower_data']['society_id']) && $data['tower_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Tower');
        }
        $data['tower_unit_table'] = view('Admin/Tower/TowerUnitView', isset($data) ? $data : array());
        return $this->dt_ci_template->load("Admin","Tower/TowerManageView",$data);
    }

    public function getTowerListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_tower as tt");
        $this->datatables->select("tt.tower_id, tt.tower_name, tt.is_active,tt.society_id,ts.society_name");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tt.created_at,tt.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tt.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tt.updated_by AND tupdate.society_id = tt.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tt.created_by AND tcreate.society_id = tt.society_id","left");

        $this->datatables->groupBy("tt.tower_id");
        accessFilter($this->datatables, array("society" => "tt.society_id"));
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "tower_id" => isset($displayData['tower_id']) ? $displayData['tower_id'] : ""
                );
                $data[$key]['action_button'] = towerActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $towerId = $this->request->getVar('tower_id');
        $towerName = $this->request->getVar('tower_name');
        $isActive = $this->request->getVar('is_active');
        $towerUnitIdArray = $this->request->getVar('tower_unit_id');
        $unitArray = $this->request->getVar('unit');
        $unitGroupArray = $this->request->getVar('unit_group');
        $numberTypeArray = $this->request->getVar('number_type');
        $rangeLabelArray = $this->request->getVar('range_label');
        $rangeStartFromArray = $this->request->getVar('range_start_from');
        $sqrFtArray = $this->request->getVar('sqr_ft');
        $bhkArray = $this->request->getVar('bhk');
        $carpetAreaArray = $this->request->getVar('carpet_area');

        if (isset($towerId) && $towerId == '') {
            $validation->setRule('tower_name', lang('Tower.tower_name'), 'required|combination_unique[tbl_tower.tower_name.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
            $validation->setRule('tower_name', lang('Tower.tower_name'), 'required|edit_unique[tbl_tower.tower_name.'.$towerId. '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        }
        $oldTowerUnitData = array();
        if(!empty($towerUnitIdArray)){
            $oldTowerUnitData = $this->tower_model->getTowerUnitData(array(
                'tower_unit_id' => $towerUnitIdArray,
                'is_multiple' => 1
            ));
        }

        $validation->setRule('unit.*', lang('Tower.unit'), 'required');
        $validation->setRule('unit_group.*', lang('Tower.unit_group'), 'required');
        $validation->setRule('number_type.*', lang('Tower.number_type'), 'required');

        foreach ($numberTypeArray as $nkey => $value) {
            if ($value == 'range') {
                // Check if range_label is empty
                if (empty($rangeLabelArray[$nkey])) {
                    $validation->setError("range_label[$nkey]", "Range Label Is Required For Row " . ($nkey));
                }
                // Check if range_start_from is empty
                if (empty($rangeStartFromArray[$nkey])) {
                    $validation->setError("range_start_from[$nkey]", "Range Start From Is Required For Row " . ($nkey));
                }
            }
        }
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $towerUpdateArray = array();
            $towerArray = array(
                'tower_id' => $towerId,
                'tower_name' => $towerName,
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
            );
            if(!empty($towerId)){
                $towerUpdateData = $this->tower_model->getTowerData(array(
                    'tower_id' => $towerId,
                ));
                $towerUpdateArray = compareArray($towerArray,$towerUpdateData);
            }
            $towerData = $this->tower_model->insertUpdateRecord($towerArray,'tower_id','tbl_tower', 1,'',array(),array(),$towerUpdateArray);
            $lastTowerId = $towerData['lastInsertedId'];
            if (!empty($towerUnitIdArray)) {
                foreach ($towerUnitIdArray as $fkey => $towerUnitId) {
                    if(isset($towerId) && $towerId != ''){
                        if(!empty($towerUnitId)){
                            $filterData = array(
                                "tower_id" => $towerId,
                                "tower_unit_id" => $towerUnitId,
                                "society_id" => $this->session->get('society_id'),
                            );
                            $towerUnitStoreData = $this->tower_model->getTowerUnitData($filterData);

                            $towerFlatFilterData = array(
                                "tower_id" => $towerId,
                                "tower_unit_id" => $towerUnitId,
                                "society_id" => $this->session->get('society_id'),
                                'is_multiple' => 1
                            );
                            $towerFlatStoreData = $this->flat_model->getFlatData($towerFlatFilterData);
                        }
                    }
                    $unit = array_key_exists($fkey, $unitArray) ? $unitArray[$fkey] : '';
                    $unitGroup = array_key_exists($fkey, $unitGroupArray) ? $unitGroupArray[$fkey] : '';
                    $numberType = array_key_exists($fkey, $numberTypeArray) ? $numberTypeArray[$fkey] : '';
                    $rangeLabel = array_key_exists($fkey, $rangeLabelArray) ? $rangeLabelArray[$fkey] : '';
                    $rangeStartFrom = array_key_exists($fkey, $rangeStartFromArray) ? $rangeStartFromArray[$fkey] : '';
                    $carpetArea = array_key_exists($fkey, $carpetAreaArray) ? $carpetAreaArray[$fkey] : '';
                    $bhk = array_key_exists($fkey, $bhkArray) ? $bhkArray[$fkey] : '';
                    $sqrFt = array_key_exists($fkey, $sqrFtArray) ? $sqrFtArray[$fkey] : '';
                    // if ($towerUnitId == '' && $unit != '') {
                        $towerUnitInsertUpdateArray = array(
                            'tower_unit_id' => $towerUnitId,
                            'tower_id' => $lastTowerId,
                            'unit' => $unit,
                            'unit_group' => $unitGroup,
                            'number_type' => $numberType,
                            'range_label' => $rangeLabel,
                            'range_start_from' => $rangeStartFrom,
                            'sqr_ft' => roundNumber($sqrFt),
                            'bhk' => roundNumber($bhk),
                            'carpet_area' => $carpetArea,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    // }

                    $towerUnitData = $this->tower_model->insertUpdateRecord($towerUnitInsertUpdateArray, 'tower_unit_id', 'tbl_tower_unit', 1,'',array(),array(),array());
                    $lastTowerUnitId = $towerUnitData['lastInsertedId'];

                    if(!empty($towerUnitId)){
                        if(($towerUnitStoreData['bhk'] != $bhk) || ($towerUnitStoreData['sqr_ft'] != $sqrFt) || ($towerUnitStoreData['bhk'] != $bhk)){
                            if(!empty($towerFlatStoreData)){
                                foreach($towerFlatStoreData as $towerFlatElement){
                                    $towerFlatArray[] = array(
                                        'flat_id' => $towerFlatElement['flat_id'],
                                        'sqr_ft' => roundNumber($sqrFt),
                                        'bhk' => roundNumber($bhk),
                                        'carpet_area' => $carpetArea,
                                    );
                                }
                                if (!empty($towerFlatArray)) {
                                    $this->tower_model->batchUpdate($towerFlatArray, "flat_id", 'tbl_flat',array());
                                }
                            }
                        }
                    }

                    if($towerUnitId == ''){
                        if($numberType == 'range'){
                            $endRangeForm = $rangeStartFrom +$unit;
                            for($i = $rangeStartFrom; $i<$endRangeForm; $i++) {
                                $flatArray = array(
                                    'flat_id' => '',
                                    'tower_id' => $lastTowerId,
                                    'floor_id' => $lastTowerUnitId,
                                    'flat_no' => $rangeLabel."-".$i,
                                    'sqr_ft' => roundNumber($sqrFt),
                                    'bhk' => roundNumber($bhk),
                                    'carpet_area' => $carpetArea,
                                    'society_id' => $this->session->get('society_id'),
                                    'is_active' => 1,
                                );
                                $flatData = $this->tower_model->insertUpdateRecord($flatArray,'flat_id','tbl_flat', 1,'',array(),array(),array());
                            }
                        }
                        if($numberType == 'manual'){
                            for($i = 1; $i<=$unit; $i++) {
                                $flatArray = array(
                                    'flat_id' => '',
                                    'tower_id' => $lastTowerId,
                                    'floor_id' => $lastTowerUnitId,
                                    'flat_no' => $i,
                                    'sqr_ft' => roundNumber($sqrFt),
                                    'bhk' => roundNumber($bhk),
                                    'carpet_area' => $carpetArea,
                                    'society_id' => $this->session->get('society_id'),
                                    'is_active' =>  1,
                                );
                                $flatData = $this->tower_model->insertUpdateRecord($flatArray,'flat_id','tbl_flat', 1,'',array(),array(),array());
                            }
                        }
                    }
                    else{
                        $changeUnit = 0;
                        if(isset($towerId) && $towerId != ''){
                            if(!empty($towerUnitStoreData)){
                                if ($towerUnitStoreData['unit'] != $unit) {
                                    $changeUnit = $unit - $towerUnitStoreData['unit'];
                                    if($changeUnit > 0){
                                        $changeUnit = abs($changeUnit);
                                        if($numberType == 'range'){
                                            $rangeStart = $towerUnitStoreData['bhk'] + $towerUnitStoreData['unit'];
                                            // PRINTaRRAY($rangeStart,1);
                                            $endRange = $rangeStart +$changeUnit;
                                            for($j = $rangeStart; $j<$endRange; $j++) {
                                                $flatArray = array(
                                                    'flat_id' => '',
                                                    'tower_id' => $lastTowerId,
                                                    'floor_id' => $lastTowerUnitId,
                                                    'flat_no' => $rangeLabel."-".$j,
                                                    'sqr_ft' => roundNumber($sqrFt),
                                                    'bhk' => roundNumber($bhk),
                                                    'carpet_area' => $carpetArea,
                                                    'society_id' => $this->session->get('society_id'),
                                                    'is_active' => 1,
                                                );
                                                $flatData = $this->tower_model->insertUpdateRecord($flatArray,'flat_id','tbl_flat', 1,'',array(),array(),array());
                                            }
                                        }
                                        if($numberType == 'manual'){
                                            for($j = 0; $j<$changeUnit; $j++) {
                                                $flatArray = array(
                                                    'flat_id' => '',
                                                    'tower_id' => $lastTowerId,
                                                    'floor_id' => $lastTowerUnitId,
                                                    'flat_no' => $j,
                                                    'sqr_ft' => roundNumber($sqrFt),
                                                    'bhk' => roundNumber($bhk),
                                                    'carpet_area' => $carpetArea,
                                                    'society_id' => $this->session->get('society_id'),
                                                    'is_active' =>  1,
                                                );
                                                $flatData = $this->tower_model->insertUpdateRecord($flatArray,'flat_id','tbl_flat', 1,'',array(),array(),array());
                                            }
                                        }
                                    } else {
                                        $filterData = array(
                                            'tower_id' => $towerId,
                                            "tower_unit_id" => $towerUnitId,
                                            'society_id' => $this->session->get('society_id'),
                                            'is_flat_assign' => 1,
                                            'is_multiple' => 1,
                                        );
                                        $notAssignedFlatData = $this->flat_model->getFlatData($filterData);
                                        if(!empty($notAssignedFlatData) && count($notAssignedFlatData) >= abs($changeUnit)){
                                            $notAssignedFlatIdArray = array();
                                            foreach ($notAssignedFlatData as $key => $value) {
                                                if($key < abs($changeUnit)) {
                                                    $notAssignedFlatIdArray[] = $value['flat_id'];
                                                }
                                            }
                                            // printArray($notAssignedFlatData,1);
                                            $this->flat_model->deleteRecord($notAssignedFlatIdArray);
                                        } else {
                                            $response['success'] = false;
                                            $response['msg'] = lang("ParkingArea.flat_already_assigned");
                                            echo json_encode($response);
                                            exit;
                                        } 
                                    }
                                }
                            }
                        }
                    }
                }
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($towerId) && $towerId != '') {
                if (($towerData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Tower.tower'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Tower.tower'));
                }
            } else {
                if (($towerData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Tower.tower'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Tower.tower'));
                }
            }
            echo json_encode($response);
            exit();
        }
    }

    public function changeStatus()
    {
        $towerId = $this->request->getVar('tower_id');
        $status = $this->request->getVar('status');

        $return = $this->tower_model->statusChange($towerId,$status,'tower_id','tbl_tower');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Tower.tower'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Tower.tower'));
        }
        echo json_encode($response);
        exit();
    }

    public function addTowerUnitRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $memberRow = view('Admin/Tower/TowerUnitRowView', $data);
        echo $memberRow;
    }

    public function deleteTowerUnitRow()
    {
        $this->db->transStart();
        $towerUnitId  = $this->request->getVar('tower_unit_id');
        $towerId = $this->request->getVar('tower_id');

        $towerUnitData = $this->tower_model->deleteTowerUnitRecord($towerUnitId);

        if ($towerUnitData) {
            if(!empty($towerUnitId)){
                foreach($towerUnitId as $documentElement){
                    $deleteDataArray['module'] = 'Tower Unit';
                    $deleteDataArray['activity'] = "Tower Unit Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Tower Unit Deleted [TowerUnitID: ' . $documentElement . ']',$this->data['userId'],'Tower Unit',$documentElement,json_encode($deleteDataArray),'','Tower',$towerId);
                }
            }
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Tower.tower_unit'));
            }
            else{
                $response['success'] = false;
                $response['msg']     = sprintf(lang('CommonMessage.delete_error'),lang('Tower.tower_unit'));
            }
        } else {
            $this->db->transRollback();
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Tower.tower_unit'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $towerId = $this->request->getVar('tower_id');
        if (isReferenceInTable('tower_id', 'tbl_flat', $towerId) || 
            isReferenceInTable('tower_id', 'tbl_gate', $towerId) ||
            isReferenceInTable('tower_id', 'tbl_notice_tower', $towerId) || 
            isReferenceInTable('tower_id', 'tbl_resource_flat', $towerId)
            // isReferenceInTable('tower_id', 'tbl_staff', $towerId)
        ) {
            if (!empty($towerId)) {
                foreach ($towerId as $tower) {
                    $deleteDataArray['module'] = 'Tower';
                    $deleteDataArray['activity'] = "Tried to delete Tower ";
                    $deleteDataArray['module_id'] = $tower;
                    logActivity('Tried to delete Tower [TowerID: ' . $tower . ']', $this->data['userId'], 'Tower', $tower, json_encode($deleteDataArray), '', 'Tower', $tower);
                }
            }
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $towerData = $this->tower_model->deleteRecord($towerId);
        $transactionStatus = $this->db->transComplete();
        if (($towerData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang('Tower.tower'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang('Tower.tower'));
        }
        echo json_encode($response);
        exit;
    }

    public function getTowerDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $towerId = $this->request->getVar('tower_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'tower_id' => $towerId,
        );
        echo $this->tower_model->getTower($filterData);
    }

    public function getTowerUnitDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $towerId = $this->request->getVar('tower_id');
        $towerUnitId = $this->request->getVar('tower_unit_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'tower_id' => $towerId,
            'tower_unit_id' => $towerUnitId,
        );
        echo $this->tower_model->getTowerUnit($filterData);
    }

    public function excelExportTower()
    {
        $fileName ='tower-' . DATETIMEFORMAT;
        $sheetName = 'Tower-' . DATEFORMAT;
        $excelHeaderName = 'Tower';
        $tableData = $this->getTowerListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('Tower.society'),
            lang('Tower.tower'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["tower_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'C';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function view($id = null)
    {
        $towerId = $this->request->getVar("view_id");
        if($towerId == "" && $towerId == null){
            return redirect()->to('Admin/Tower');
        }
        else {
            $id = $towerId;
            $filterData = array(
                "tower_id" => $towerId
            );
            $data['tower_data'] = $this->tower_model->getTowerData($filterData);

            $towerUnit = $this->tower_model->getTowerUnitData(array(
                'tower_id' => $towerId,
                'is_multiple' => 1
            ));
            $data['tower_unit_data'] = $towerUnit;

            // printArray($data,1);
            $towerView = view("Admin/Tower/TowerModelView", $data);
            $response['view_title'] = "Tower Details";
            $response['view_detail'] = $towerView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }
}
