<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\TimeSlotModel;
class TimeSlot extends BaseController
{
    protected $time_slot_model;
    public function __construct() {
        $this->time_slot_model = new TimeSlotModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Time Slot';
        return $this->dt_ci_template->load("Admin","TimeSlot/TimeSlotView",$data);
    }

    public function manage($timeSlotId = '')
	{

		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );

        if ($timeSlotId != '') {
			$filterData = array(
				"time_slot_id" => $timeSlotId
			);
			$data['time_slot_data'] = $this->time_slot_model->getTimeSlotData($filterData);
		}
		if ($timeSlotId != '') {
			$data['title'] = 'Edit Time Slot';
		} else {
			$data['title'] = 'Add Time Slot';
		}
		return $this->dt_ci_template->load("Admin","TimeSlot/TimeSlotManageView",$data);
	}

	public function getTimeSlotListing($return = false ,$filterData = array())
	{
		if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}

		$this->datatables->table("tbl_time_slot as tts");
		$this->datatables->select("tts.time_slot_id,tts.time_slot_name,tts.created_at,tts.is_active,ts.society_name as society_name,tts.society_id,tts.start_time,tts.end_time");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tts.updated_at");
		$this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tts.society_id","left");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tts.updated_by AND tupdate.society_id = tts.society_id","left");
		accessFilter($this->datatables, array("society" => "tts.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];

		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"time_slot_id" => isset($data[$key]['time_slot_id']) ? $data[$key]['time_slot_id'] : ""
				);
				$data[$key]['start_time'] = isset($data[$key]['start_time']) ? date("H:i", strtotime($data[$key]['start_time'])) : '';
				$data[$key]['start_time_display'] = isset($data[$key]['start_time']) ? date("h:i A", strtotime($data[$key]['start_time'])) : '';
				$data[$key]['end_time'] = isset($data[$key]['end_time']) ? date("H:i", strtotime($data[$key]['end_time'])) : '';
				$data[$key]['end_time_display'] = isset($data[$key]['end_time']) ? date("h:i A", strtotime($data[$key]['end_time'])) : '';
				$data[$key]['action_button'] = timeSlotActionButton($actionButtonFilter);
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
	}

	public function save()
	{
        $validation = \Config\Services::validation();
		$timeSlotId  = $this->request->getVar('time_slot_id');
		$timeSlotName = $this->request->getVar('time_slot_name');
		$societyId = $this->request->getVar('society_id');
		$startTime = $this->request->getVar('start_time');
		$endTime = $this->request->getVar('end_time');
		$isActive = $this->request->getVar('is_active');

		$validation->setRule('time_slot_name', lang('TimeSlot.time_slot_name'), 'required');
		$validation->setRule('start_time', lang('TimeSlot.start_time'), 'required');
		$validation->setRule('end_time', lang('TimeSlot.end_time'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        }

        $startTime = date('H:i',strtotime($startTime));
        $endTime = date('H:i',strtotime($endTime));

		if($endTime == '00:00'){
			$endDate = date('d-m-Y', strtotime("+1 day", strtotime(TODAY_DATE)));
		} else {
			$endDate = TODAY_DATE;
		}

		if(strtotime(TODAY_DATE." ".$startTime) > strtotime($endDate." ".$endTime)){
			$response['title'] = lang("TimeSlot.valid_time");
			$response['success'] = false;
			$response['msg'] = lang("TimeSlot.end_time_less_error");
			echo json_encode($response);
			exit();
		}

		$timeSlotDataArray = $this->time_slot_model->getTimeSlotData(array(
			"time_slot_name" => $timeSlotName,
			"start_time" => $startTime,
			'society_id' => $this->session->get('society_id'),
			'time_slot_id_not' => $timeSlotId,
		));

		if (!empty($timeSlotDataArray)) {
			$response['success'] = false;
			$response['msg'] = lang("TimeSlot.duplicate_time_slot_error");
			echo json_encode($response);
			exit;
		}

		// check overlapping time
		$timeSlotDataArray = $this->time_slot_model->getTimeSlotData(array(
			"start_time" => $startTime,
			'society_id' => $societyId,
			'time_slot_id_not' => $timeSlotId,
		));

		if (!empty($timeSlotDataArray)) {
			$response['success'] = false;
			$response['msg'] = lang("TimeSlot.overlapping_time_slot_error");
			echo json_encode($response);
			exit;
		}

		
		$timeSlotUpdateArray = array();
		$timeSlotArray = array(
			'time_slot_id' => $timeSlotId,
			'time_slot_name' => $timeSlotName,
			'society_id' => $this->session->get('society_id'),
			'is_active' => isset($isActive) ? 1 : 0,
			'start_time' => $startTime,
			'end_time' => $endTime,
		);

		if(!empty($timeSlotId)){
            $timeSlotUpdateData = $this->time_slot_model->getTimeSlotData(array(
                'time_slot_id' => $timeSlotId,
            ));
            $timeSlotUpdateArray = compareArray($timeSlotArray,$timeSlotUpdateData);
        }

		$timeSlotData = $this->time_slot_model->insertUpdateRecord($timeSlotArray,'time_slot_id','tbl_time_slot',1,'',array(),array(),$timeSlotUpdateArray);
		if (isset($timeSlotId) && $timeSlotId != '') {
			if ($timeSlotData['success']) {
				$response['success'] = true;
				$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("TimeSlot.time_slot"));
			} else {
				$response['success'] = false;
				$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("TimeSlot.time_slot"));
			}
		} else {
			if ($timeSlotData['success']) {
				$response['success'] = true;
				$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("TimeSlot.time_slot"));
			} else {
				$response['success'] = false;
				$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("TimeSlot.time_slot"));
			}
		}
		echo json_encode($response);
		exit;
	}

	public function changeStatus()
	{
		$timeSlotId = $this->request->getVar('time_slot_id');
		$status = $this->request->getVar('status');
		$return = $this->time_slot_model->statusChange($timeSlotId, $status, 'time_slot_id', 'tbl_time_slot');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg'] = sprintf(lang('CommonMessage.status_change'), lang('TimeSlot.time_slot'));
		} else {
			$response['success'] = false;
			$response['msg'] = sprintf(lang('CommonMessage.status_change_error'), lang('TimeSlot.time_slot'));
		}
		echo json_encode($response);
		exit();
	}

	public function delete()
	{
		$this->db->transStart();
		$timeSlotId = $this->request->getVar('time_slot_id');

		$ids = is_array($timeSlotId) ? implode(',',$timeSlotId) : $timeSlotId;
		 if( isReferenceInTable( 'time_slot_id','tbl_booking', $timeSlotId)){

		 	if(!empty($timeSlotId)){
		 		foreach($timeSlotId as $documentElement){
		 			$deleteDataArray['module'] = 'Time Slot';
		 			$deleteDataArray['activity'] = "Tried to delete Time Slot";
		 			$deleteDataArray['module_id'] = $documentElement;
		 			logActivity('Tried to delete Time Slot [TimeSlotID: ' . $documentElement . ']',$this->data['userId'],'Time Slot',$documentElement,json_encode($deleteDataArray),'','Time Slot',$documentElement);
		 		}
		 	}
             $response['success'] = false;
             $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
             echo json_encode($response);
             exit;
         }
		$timeSlotData = $this->time_slot_model->deleteRecord($timeSlotId);
		$transactionStatus = $this->db->transComplete();
		if (($timeSlotData) && ($transactionStatus == 1)) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang("TimeSlot.time_slot"));
		} else {
			$response['success'] = false;
			$response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang("TimeSlot.time_slot"));
		}
		echo json_encode($response);
		exit;
	}

	public function getTimeSlotDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $timeSlotId = $this->request->getVar('time_slot_id');
        $filterData = array(
            'time_slot_id' => $timeSlotId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->time_slot_model->getTimeSlot($filterData);
    }

    public function excelExportTimeSlot()
	{
		$fileName ='time-slot-' . DATETIMEFORMAT;
		$sheetName = 'Time Slot-' . DATEFORMAT;
		$excelHeaderName = 'Time Slot';
		$tableData = $this->getTimeSlotListing(true, $_GET);
		$dataRows = array();
		$dataRows[] = array(
			// lang('TimeSlot.society'),
			lang('TimeSlot.time_slot'),
			lang('TimeSlot.start_time'),
			lang('TimeSlot.end_time'),
			lang('CommonMessage.common_updated_by'),
			lang('CommonMessage.common_updated_at')
		);
		foreach ($tableData as $row) {
			$dataRows[] = array(
				// $row["society_name"],
				$row["time_slot_name"],
				$row["start_time_display"],
				$row["end_time_display"],
				$row["updated_by"],
				$row["updated_at"]
			);
		}
		$subTotalCellValueArray = [];
		$toColumn = 'E';
		$excelFilterData = array(
			'file_name' => $fileName,
			'sheet_name' => $sheetName,
			'excel_header_name' => $excelHeaderName,
			'data_row' => $dataRows,
			'sub_total_cell_value_array' => $subTotalCellValueArray,
			'to_column' => $toColumn,
			'skip_header' => false,
			'ignore_currency_symbols_sub_total_cell_value_array' => array(),
			'row_cell_currency_format' => array()
		);
		//excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
		excelExport($excelFilterData);
	}
}
