<?php
namespace App\Controllers\Admin;
use App\Models\CommonWebServiceModel;
use CodeIgniter\Controller;
use App\Models\SubLedgerModel;
use App\Models\DocumentModel;
class SubLedger extends BaseController
{
    protected $sub_ledger_model;
    public function __construct() {
        $this->sub_ledger_model = new SubLedgerModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'SubLedger';
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
		$this->dt_ci_template->load("Admin","SubLedger/SubLedgerView",$data);
	}

	public function manage($subLedgerId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
        );

        if ($subLedgerId != '') {
			$filterData = array(
				"sub_ledger_id" => $subLedgerId
			);
			$data['sub_ledger_data'] = $this->sub_ledger_model->getSubLedgerData($filterData);

			if (empty($data['sub_ledger_data'])) {
                return redirect()->to('Admin/SubLedger');
            }

		   	$ledgerSubSubLedgerData = $this->sub_ledger_model->getSubLedgerLedgerData(array(
				'sub_ledger_id' => $subLedgerId,
				'is_multiple' => 1
			));
			$data['ledger_sub_data'] = $ledgerSubSubLedgerData;
		}
		if ($subLedgerId != '') {
			$data['title'] = 'Edit Sub Ledger';
		} else {
			$data['title'] = 'Add Sub Ledger';
		}

		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
		if ((isset($data['ledger_data']['society_id']) && $data['ledger_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/SubLedger');
        }
		$this->dt_ci_template->load("Admin","SubLedger/SubLedgerManageView",$data);
	}

    public function getSubLedgerListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}

        $this->datatables->table("tbl_sub_ledger as ts");
		$this->datatables->select("ts.sub_ledger_id,ts.sub_ledger_name,ts.sub_ledger_code,tsoc.society_name");
		$this->datatables->select("ts.is_active,concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,ts.updated_at");
		$this->datatables->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = ts.society_id","left");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ts.updated_by AND tupdate.society_id = ts.society_id","left");


		$this->datatables->groupBy("ts.sub_ledger_id");
		accessFilter($this->datatables, array("society" => "ts.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"sub_ledger_id" => isset($data[$key]['sub_ledger_id']) ? $data[$key]['sub_ledger_id'] : ""
				);
				$data[$key]['action_button'] = subLedgerActionButton($actionButtonFilter);
				$data[$key]['updated_at'] = isValidDate($data[$key]['updated_at']) ? siteDateFormat($data[$key]['updated_at'],true) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $subLedgerId = $this->request->getVar('sub_ledger_id');
        $status = $this->request->getVar('status');
        $return = $this->sub_ledger_model->statusChange($subLedgerId,$status,'sub_ledger_id','tbl_sub_ledger');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('SubLedger.ledger'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('SubLedger.ledger'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
//        printArray($_POST,1);
		$this->db->transBegin();
		$validation = \Config\Services::validation();
		$subLedgerId = $this->request->getVar('sub_ledger_id');
		$subLedgerCode = $this->request->getVar('sub_ledger_code');
		$subLedgerName = $this->request->getVar('sub_ledger_name');
		$isActive = $this->request->getVar('is_active');

		if (isset($subLedgerId) && $subLedgerId == '') {
			$validation->setRule('sub_ledger_code', lang('SubLedger.sub_ledger_code'), 'required|combination_unique[tbl_sub_ledger.sub_ledger_code.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
			$validation->setRule('sub_ledger_code', lang('SubLedger.sub_ledger_code'), 'required|edit_unique[tbl_sub_ledger.sub_ledger_code.' . $subLedgerId . '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        }
		
		// $validation->setRule('sub_ledger_code', lang('SubLedger.sub_ledger_code'), 'required');
		$validation->setRule('sub_ledger_name', lang('SubLedger.sub_ledger_name'), 'required');
		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

			$ledgerUpdateArray = array();
			$ledgerArray = array(
				'sub_ledger_id' => $subLedgerId,
				'sub_ledger_code' => $subLedgerCode,
				'sub_ledger_name' => $subLedgerName,
				'society_id' => $this->session->get('society_id'),
				'is_active' => isset($isActive) ? 1 : 0,
			);

			if(!empty($subLedgerId)){
                $ledgerUpdateData = $this->sub_ledger_model->getSubLedgerData(array(
                    'sub_ledger_id' => $subLedgerId,
                ));
                $ledgerUpdateArray = compareArray($ledgerArray,$ledgerUpdateData);
            }

			$ledgerData = $this->sub_ledger_model->insertUpdateRecord($ledgerArray, 'sub_ledger_id', 'tbl_sub_ledger', 1,'',array(),array(),$ledgerUpdateArray);
			$lastSubLedgerId = $ledgerData['lastInsertedId'];

			$ledgerSubSubLedgerData = array();
            if(!empty($subLedgerId)) {
                $ledgerSubSubLedgerData = $this->sub_ledger_model->getSubLedgerLedgerData(array(
                    'sub_ledger_id' => $subLedgerId,
                    'is_multiple' => 1
                ));
            }

			$LedgerIdArray = $this->request->getVar('ledger_id[]');
            if(isset($subLedgerId) && $subLedgerId != ''){
                $this->sub_ledger_model->deleteLedgerRecord($subLedgerId);
            }
            if(isset($LedgerIdArray)&& $LedgerIdArray != ''){
                $ledgerSubLedgerArray = array();
                foreach($LedgerIdArray as $subSubLedgerId){
                    $ledgerSubLedgerArray[] = array(
                        'ledger_sub_ledger_id' => '',
                        'sub_ledger_id' => $lastSubLedgerId,
                        'ledger_id' => $subSubLedgerId,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
                $ledgerSocietyExtraDataArray = array();
                $ledgerSocietyExtraDataArray['module_id'] = $lastSubLedgerId;
                $ledgerSocietyExtraDataArray['module'] = 'SubLedger Sub SubLedger';
                $ledgerSocietyExtraDataArray['type'] = 'SubLedger';
                $ledgerSocietyExtraDataArray['old_data'] = $ledgerSubSubLedgerData;
                $ledgerSocietyExtraDataArray['user_id'] = $this->data['userId'];
                $ledgerSocietyExtraDataArray['society_id'] = $this->session->get('society_id');

                if(!empty($ledgerSubLedgerArray)){
                    $this->sub_ledger_model->batchInsert($ledgerSubLedgerArray,'tbl_ledger_sub_ledger',$ledgerSocietyExtraDataArray);
                }
            }

			if (isset($subLedgerId) && $subLedgerId != '') {
				if ($ledgerData['success']) {
					$this->db->transCommit();
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("SubLedger.ledger"));
				} else {
					$this->db->transRollback();
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("SubLedger.ledger"));
				}
			} else {
				if ($ledgerData['success']) {
					$this->db->transCommit();
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("SubLedger.ledger"));
				} else {
					$this->db->transRollback();
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("SubLedger.ledger"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
        $subLedgerId = $this->request->getVar('sub_ledger_id');
         if( isReferenceInTable( 'sub_ledger_id','tbl_budget_sub_ledger', $subLedgerId) ||
         	isReferenceInTable( 'sub_ledger_id','tbl_ledger_sub_ledger', $subLedgerId)
     		){
			if(!empty($subLedgerId)){
			 	foreach($subLedgerId as $documentElement){
			 		$deleteDataArray['module'] = 'SubLedger';
			 		$deleteDataArray['activity'] = "Tried to Delete SubLedger ";
			 		$deleteDataArray['module_id'] = $documentElement;
			 		logActivity('Tried to delete SubLedger [SubLedgerID: ' . $documentElement . ']',$this->data['userId'],'SubLedger',$documentElement,json_encode($deleteDataArray),'','SubLedger',$documentElement);
			 	}
			}
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
         }

        $ledgerData = $this->sub_ledger_model->deleteRecord($subLedgerId);
        $ledgerGuardData = $this->sub_ledger_model->deleteLedgerRecord($subLedgerId);
        $transactionStatus = $this->db->transComplete();
        if (($ledgerData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("SubLedger.ledger"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("SubLedger.ledger"));
        }
        echo json_encode($response);
        exit;
    }

    public function getSubLedgerDd(){
    	$filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $subLedgerId = $this->request->getVar('sub_ledger_id');
        $societyId = $this->request->getVar('society_id');
        $filterData = array(
            'sub_ledger_id' => $subLedgerId,
            'society_id' => $this->session->get('society_id'),
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'is_active' => 1,
            'limit' => DATA_LIMIT
        );

        echo $this->sub_ledger_model->getSubLedger($filterData);
    }

	public function excelExportSubLedger()
	{
		$fileName ='ledger-' . DATETIMEFORMAT;
		$sheetName = 'SubLedger-' . DATEFORMAT;
		$excelHeaderName = 'SubLedger';
		$tableData = $this->getSubLedgerListing(true, $_GET);
		$dataRows = array();
		$dataRows[] = array(
			lang('SubLedger.ledger_type'),
			lang('SubLedger.sub_ledger_name'),
			lang('SubLedger.father_name'),
			lang('SubLedger.date_of_birth'),
			lang('SubLedger.gender'),
			lang('SubLedger.work'),
			lang('SubLedger.contact_no'),
			lang('SubLedger.present_address'),
			lang('SubLedger.permanent_address'),
			lang('SubLedger.reference'),
			lang('CommonMessage.common_updated_by'),
			lang('common_updated_at')
		);
		foreach ($tableData as $row) {
			$dataRows[] = array(
				$row["ledger_type"],
				$row["sub_ledger_name"],
				$row["father_name"],
				$row["date_of_birth"],
				$row["gender"],
				$row["work"],
				$row["contact_no"],
				$row["present_address"],
				$row["permanent_address"],
				$row["reference"],
				$row["updated_by"],
				$row["updated_at"]
			);
		}
		$subTotalCellValueArray = [];
		$toColumn = 'L';
		$excelFilterData = array(
			'file_name' => $fileName,
			'sheet_name' => $sheetName,
			'excel_header_name' => $excelHeaderName,
			'data_row' => $dataRows,
			'sub_total_cell_value_array' => $subTotalCellValueArray,
			'to_column' => $toColumn,
			'skip_header' => false,
			'ignore_currency_symbols_sub_total_cell_value_array' => array(),
			'row_cell_currency_format' => array()
		);
		//excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
		excelExport($excelFilterData);
	}


}
