<?php
namespace App\Controllers\Admin;
use App\Models\CommonWebServiceModel;
use CodeIgniter\Controller;
use App\Models\SubAccountModel;
use App\Models\DocumentModel;
class SubAccount extends BaseController
{
    protected $sub_account_model;
    public function __construct() {
        $this->sub_account_model = new SubAccountModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'SubAccount';
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
		$this->dt_ci_template->load("Admin","SubAccount/SubAccountView",$data);
	}

	public function manage($subAccountId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
        );

        if ($subAccountId != '') {
			$filterData = array(
				"sub_account_id" => $subAccountId
			);
			$data['sub_account_data'] = $this->sub_account_model->getSubAccountData($filterData);

			$accountData = $this->sub_account_model->getSubAccountAccountData(array(
				'sub_account_id' => $subAccountId,
				'is_multiple' => 1
			));
			$data['account_sub_data'] = $accountData;

			if (empty($data['sub_account_data'])) {
                return redirect()->to('Admin/SubAccount');
            }

		}
		if ($subAccountId != '') {
			$data['title'] = 'Edit Sub Account';
		} else {
			$data['title'] = 'Add Sub Account';
		}

		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
		if ((isset($data['account_data']['society_id']) && $data['account_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/SubAccount');
        }
		$this->dt_ci_template->load("Admin","SubAccount/SubAccountManageView",$data);
	}

    public function getSubAccountListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}

        $this->datatables->table("tbl_sub_account as ts");
		
		$this->datatables->select("ts.sub_account_id,ts.sub_account_name,ts.sub_account_code,tsoc.society_name");
		$this->datatables->select("ts.is_active,concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,ts.updated_at");

        $this->datatables->select("ta.account_name as accounts_name");

		$this->datatables->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = ts.society_id","left");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ts.updated_by AND tupdate.society_id = ts.society_id","left");
        $this->datatables->join("tbl_account_sub_account as tasa","tasa.sub_account_id = ts.sub_account_id","left");

        $this->datatables->join("tbl_account as ta","ta.account_id = tasa.account_id","left");
        

		$this->datatables->groupBy("ts.sub_account_id");
		accessFilter($this->datatables, array("society" => "ts.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		// printArray($data,1);

		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"sub_account_id" => isset($data[$key]['sub_account_id']) ? $data[$key]['sub_account_id'] : ""
				);
				$data[$key]['action_button'] = subAccountActionButton($actionButtonFilter);
				$data[$key]['updated_at'] = isValidDate($data[$key]['updated_at']) ? siteDateFormat($data[$key]['updated_at'],true) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $subAccountId = $this->request->getVar('sub_account_id');
        $status = $this->request->getVar('status');
        $return = $this->sub_account_model->statusChange($subAccountId,$status,'sub_account_id','tbl_sub_account');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('SubAccount.account'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('SubAccount.account'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
		$this->db->transStart();
		$validation = \Config\Services::validation();
		$subAccountId = $this->request->getVar('sub_account_id');
		// $accountId = $this->request->getVar('account_id');
		$subAccountCode = $this->request->getVar('sub_account_code');
		$subAccountName = $this->request->getVar('sub_account_name');
		$isActive = $this->request->getVar('is_active');

		if (isset($subAccountId) && $subAccountId == '') {
			$validation->setRule('sub_account_code', lang('SubAccount.sub_account_code'), 'required|combination_unique[tbl_sub_account.sub_account_code.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
			$validation->setRule('sub_account_code', lang('SubAccount.sub_account_code'), 'required|edit_unique[tbl_sub_account.sub_account_code.' . $subAccountId . '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        }
		
		// $validation->setRule('sub_account_code', lang('SubAccount.sub_account_code'), 'required');
		$validation->setRule('sub_account_name', lang('SubAccount.sub_account_name'), 'required');
		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

			$accountUpdateArray = array();
			$accountArray = array(
				'sub_account_id' => $subAccountId,
				'sub_account_code' => $subAccountCode,
				'sub_account_name' => $subAccountName,
				'society_id' => $this->session->get('society_id'),
				'is_active' => isset($isActive) ? 1 : 0,
			);

			if(!empty($subAccountId)){
                $accountUpdateData = $this->sub_account_model->getSubAccountData(array(
                    'sub_account_id' => $subAccountId,
                ));
                $accountUpdateArray = compareArray($accountArray,$accountUpdateData);
            }

			$accountData = $this->sub_account_model->insertUpdateRecord($accountArray, 'sub_account_id', 'tbl_sub_account', 1,'',array(),array(),$accountUpdateArray);
			$lastSubAccountId = $accountData['lastInsertedId'];

			$accountSubSubAccountData = array();
            if(!empty($subAccountId)) {
                $accountSubSubAccountData = $this->sub_account_model->getSubAccountAccountData(array(
                    'sub_account_id' => $subAccountId,
                    'is_multiple' => 1
                ));
            }

			$AccountIdArray = $this->request->getVar('account_id[]');
            if(isset($subAccountId) && $subAccountId != ''){
                $this->sub_account_model->deleteAccountRecord($subAccountId);
            }
            if(isset($AccountIdArray)&& $AccountIdArray != ''){
                $accountSubAccountArray = array();
                foreach($AccountIdArray as $subSubAccountId){
                    $accountSubAccountArray[] = array(
                        'account_sub_account_id' => '',
                        'sub_account_id' => $lastSubAccountId,
                        'account_id' => $subSubAccountId,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
                $accountSocietyExtraDataArray = array();
                $accountSocietyExtraDataArray['module_id'] = $lastSubAccountId;
                $accountSocietyExtraDataArray['module'] = 'SubAccount Sub SubAccount';
                $accountSocietyExtraDataArray['type'] = 'SubAccount';
                $accountSocietyExtraDataArray['old_data'] = $accountSubSubAccountData;
                $accountSocietyExtraDataArray['user_id'] = $this->data['userId'];
                $accountSocietyExtraDataArray['society_id'] = $this->session->get('society_id');

                if(!empty($accountSubAccountArray)){
                    $this->sub_account_model->batchInsert($accountSubAccountArray,'tbl_account_sub_account',$accountSocietyExtraDataArray);
                }
            }
            $transactionStatus = $this->db->transComplete();
			if (isset($subAccountId) && $subAccountId != '') {
				if (($accountData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("SubAccount.sub_account"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("SubAccount.sub_account"));
				}
			} else {
				if (($accountData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("SubAccount.sub_account"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("SubAccount.sub_account"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
        $subAccountId = $this->request->getVar('sub_account_id');
         if( isReferenceInTable( 'sub_account_id','tbl_budget_sub_account', $subAccountId)
         	// isReferenceInTable( 'sub_account_id','tbl_account_sub_account', $subAccountId)
     		){
			if(!empty($subAccountId)){
			 	foreach($subAccountId as $documentElement){
			 		$deleteDataArray['module'] = 'SubAccount';
			 		$deleteDataArray['activity'] = "Tried to Delete SubAccount ";
			 		$deleteDataArray['module_id'] = $documentElement;
			 		logActivity('Tried to delete SubAccount [SubAccountID: ' . $documentElement . ']',$this->data['userId'],'SubAccount',$documentElement,json_encode($deleteDataArray),'','SubAccount',$documentElement);
			 	}
			}
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $accountData = $this->sub_account_model->deleteAccountRecord($subAccountId);
        $subAccountData = $this->sub_account_model->deleteRecord($subAccountId);
        $transactionStatus = $this->db->transComplete();
        if (($subAccountData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("SubAccount.sub_account"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("SubAccount.sub_account"));
        }
        echo json_encode($response);
        exit;
    }

    public function getSubAccountDd(){
    	$filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $subAccountId = $this->request->getVar('sub_account_id');
        $societyId = $this->request->getVar('society_id');
        $filterData = array(
            'sub_account_id' => $subAccountId,
            'society_id' => $this->session->get('society_id'),
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'is_active' => 1,
            'limit' => DATA_LIMIT
        );

        echo $this->sub_account_model->getSubAccount($filterData);
    }

	public function excelExportSubAccount()
	{
		$fileName ='account-' . DATETIMEFORMAT;
		$sheetName = 'SubAccount-' . DATEFORMAT;
		$excelHeaderName = 'SubAccount';
		$tableData = $this->getSubAccountListing(true, $_GET);
		$dataRows = array();
		$dataRows[] = array(
			lang('SubAccount.account_type'),
			lang('SubAccount.sub_account_name'),
			lang('SubAccount.father_name'),
			lang('SubAccount.date_of_birth'),
			lang('SubAccount.gender'),
			lang('SubAccount.work'),
			lang('SubAccount.contact_no'),
			lang('SubAccount.present_address'),
			lang('SubAccount.permanent_address'),
			lang('SubAccount.reference'),
			lang('CommonMessage.common_updated_by'),
			lang('common_updated_at')
		);
		foreach ($tableData as $row) {
			$dataRows[] = array(
				$row["account_type"],
				$row["sub_account_name"],
				$row["father_name"],
				$row["date_of_birth"],
				$row["gender"],
				$row["work"],
				$row["contact_no"],
				$row["present_address"],
				$row["permanent_address"],
				$row["reference"],
				$row["updated_by"],
				$row["updated_at"]
			);
		}
		$subTotalCellValueArray = [];
		$toColumn = 'L';
		$excelFilterData = array(
			'file_name' => $fileName,
			'sheet_name' => $sheetName,
			'excel_header_name' => $excelHeaderName,
			'data_row' => $dataRows,
			'sub_total_cell_value_array' => $subTotalCellValueArray,
			'to_column' => $toColumn,
			'skip_header' => false,
			'ignore_currency_symbols_sub_total_cell_value_array' => array(),
			'row_cell_currency_format' => array()
		);
		//excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
		excelExport($excelFilterData);
	}


}
